/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.fx.services;

import com.sun.javafx.tk.Toolkit;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.geometry.Point2D;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.util.Duration;
import org.eclipse.fx.core.SystemUtils;
import org.eclipse.fx.core.app.ApplicationContext;
import org.eclipse.fx.ui.services.startup.StartupProgressTrackerService;

public abstract class InteractiveStartupService
implements StartupProgressTrackerService {
    private ApplicationContext applicationContext;
    private Stage stage;
    private CountDownLatch hideLatch = new CountDownLatch(1);

    public StartupProgressTrackerService.OSGiRV applicationLaunched(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        return StartupProgressTrackerService.OSGiRV.CONTINUE;
    }

    protected abstract Scene createScene(ApplicationContext var1, Image var2);

    protected void show() {
        if (SystemUtils.isMacOS()) {
            this.stage.show();
            this.applicationContext.applicationRunning();
        } else {
            this.stage.setOnShown(e -> new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)100.0), ev -> {
                Toolkit.getToolkit().exitNestedEventLoop((Object)this, null);
                this.hideLatch.countDown();
            }, new KeyValue[0])}).play());
            this.stage.show();
            Toolkit.getToolkit().enterNestedEventLoop((Object)this);
        }
    }

    public void stateReached(StartupProgressTrackerService.ProgressState state) {
        if (state == StartupProgressTrackerService.DefaultProgressState.JAVAFX_INITIALIZED) {
            Optional splash = this.applicationContext.getSplashImage();
            if (splash.isPresent()) {
                Image img = new Image(((ApplicationContext.Splash)splash.get()).getUrl().toExternalForm());
                this.stage = new Stage(StageStyle.TRANSPARENT);
                this.stage.setScene(this.createScene(this.applicationContext, img));
                Point2D location = ((ApplicationContext.Splash)splash.get()).getLocation();
                this.stage.setX(location.getX());
                this.stage.setY(location.getY());
            }
        } else if (state == StartupProgressTrackerService.DefaultProgressState.JAVAFX_INITIALIZED_LAUNCHER_THREAD) {
            if (!SystemUtils.isMacOS()) {
                try {
                    this.hideLatch.await();
                }
                catch (InterruptedException interruptedException) {}
                this.applicationContext.applicationRunning();
            }
        } else if (state == StartupProgressTrackerService.DefaultProgressState.WORKBENCH_GUI_SHOWN) {
            this.stage.hide();
        }
    }
}

