/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.portfolio.viewers.convertible;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.formatters.SecFilter;
import cms.tmx.control.search.AutoCompletion;
import cms.tmx.control.search.Search;
import cms.tmx.control.spinner.DoubleSpinnerCtrl;
import cms.tmx.control.spinner.IntSpinnerCtrl;
import cms.tmx.control.spinner.SpinnerUtils;
import cms.tmx.control.table.EditTreeTableCell;
import cms.tmx.control.table.NumberTreeTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.data.utils.SecConverter;
import cms.tmx.data.utils.SecSuggest;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.Portfolio;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.data.HandicapInfo;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.ConvertibleBond;
import cms.tmx.entity.trade.PortfolioAccountDistribution;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.MxBindings;
import cms.tmx.portfolio.models.PortfolioConvertibleBondTradeModel;
import cms.tmx.portfolio.models.UserPrePortfolioCtrl;
import cms.tmx.portfolio.uitls.AccCollapseCell;
import cms.tmx.portfolio.uitls.PortfoCollapseCell;
import cms.tmx.portfolio.viewers.PortfolioCheckBoxCell;
import cms.tmx.portfolio.viewers.PortfolioTradePart;
import cms.tmx.trade.views.CcsEntrustConfirmDialog;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.function.UnaryOperator;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Spinner;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PortfolioConvertibleBondTradePart
extends PortfolioTradePart {
    private static final Logger logger = LogManager.getLogger(PortfolioConvertibleBondTradePart.class);
    public static final int SECURITY_TYPE = 1;
    @FXML
    protected RadioButton buyRadio;
    @FXML
    protected RadioButton sellRadio;
    @FXML
    protected TextField txtCode;
    @FXML
    protected ComboBox<MxNode> cmbPriceType;
    @FXML
    protected Spinner<Double> priceSpn;
    @FXML
    protected Spinner<Integer> quantitySpn;
    @FXML
    protected ComboBox<MxNode> countStg;
    @FXML
    private Label lbCountOne;
    @FXML
    private Label lbCountTwo;
    @FXML
    private Label lbCountThree;
    @FXML
    private Label lbCountFour;
    @FXML
    protected Button btnOrder;
    @FXML
    protected ComboBox<MxNode> cmbDist;
    @Inject
    protected PortfolioConvertibleBondTradeModel model;
    @FXML
    private HBox hboxCounts;
    @Inject
    protected UserPrePortfolioCtrl preModel;
    @Inject
    protected IRefDataMng refMng;
    @FXML
    private Label lbName;
    @Inject
    protected MObjFactory of;
    @FXML
    private TextField txtSearch;
    @FXML
    protected Label lbUnit;
    @FXML
    protected TreeTableView<PortfolioAccountDistribution> portfolioTreeTable;
    @FXML
    private TreeTableColumn<PortfolioAccountDistribution, Boolean> checkBoxCol;
    @FXML
    private TreeTableColumn<PortfolioAccountDistribution, Portfolio> portfolioCol;
    @FXML
    private TreeTableColumn<PortfolioAccountDistribution, CcsFundAccount> accountCol;
    @FXML
    private TreeTableColumn<PortfolioAccountDistribution, SecAccount> secAcctCol;
    @FXML
    protected TreeTableColumn<PortfolioAccountDistribution, Number> availableCol;
    @FXML
    private TreeTableColumn<PortfolioAccountDistribution, Number> assetCol;
    @FXML
    private TreeTableColumn<PortfolioAccountDistribution, Number> weightCol;
    @FXML
    private TreeTableColumn<PortfolioAccountDistribution, Number> amountCol;
    @FXML
    protected TreeTableColumn<PortfolioAccountDistribution, Number> canBuyCol;
    @FXML
    protected TreeTableColumn<PortfolioAccountDistribution, Number> canSellCol;
    protected MarketItem mktItem;
    protected IntSpinnerCtrl ctrlCount = new IntSpinnerCtrl(true, 9, 100);
    protected DoubleSpinnerCtrl ctrlPrice = new DoubleSpinnerCtrl(true, 6, 3);
    private static final String INVALID_CODE = "\u65e0\u6548\u4ee3\u7801";
    private boolean isPstEvent = false;
    private MEvent pstEvent = new MEvent();
    protected boolean priceSettle = false;
    protected SecSuggest spCode = new SecSuggest();
    private SecConverter secCvt;
    private ToggleGroup group = new ToggleGroup();
    private String confirmSymbol = "";
    protected AutoCompletion<RefItem> autoCompletionNormal;
    private String buySymbol = "\u4e70\u5165";
    private String sellSymbol = "\u5356\u51fa";
    private InvalidationListener lstnRefMng = ob -> {
        Collection<RefItem> list = this.getRefItems();
        this.spCode.setAllSuggestions(list);
    };
    private MEventHandler hSetCode = event -> {
        if (event.getStr("parent_id").toUpperCase().contains(this.model.getTradeType()) && event.getStr("sec_type").equals(this.model.getTradeType())) {
            this.txtCode.requestFocus();
            if (this.txtCode.isFocused()) {
                this.txtCode.setText(event.getStr("sec_code"));
            }
            this.pstEvent = event;
            this.isPstEvent = true;
            if (this.txtCode.getText().equals(event.getStr("sec_code"))) {
                this.model.setCount(this.pstEvent.getInt("count"));
                this.model.setPrice(((HandicapInfo)this.mktItem.getListBuyHandicap().get(0)).getPrice());
                this.sellRadio.setSelected(this.pstEvent.getBool("side_sell"));
            }
        }
    };

    @Inject
    public PortfolioConvertibleBondTradePart() {
    }

    @Override
    @FXML
    public void initialize() {
        this.mktItem = this.model.getMI();
        this.mktItem.refItemProperty().addListener(ob -> this.onRefChange());
        this.refMng.changedProperty().addListener(ob -> {
            Collection<RefItem> list = this.getRefItems();
            this.spCode.setAllSuggestions(list);
        });
        this.model.create("0");
        this.initUserPre();
        this.initBind();
        this.createAcctTree();
    }

    @Override
    public void initUserPre() {
        this.preModel.setType("6", "200052");
        this.preModel.setPart(this);
        this.model.setPreModel(this.preModel);
        try {
            this.preModel.doSet();
        }
        catch (MException mException) {
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, "\u67e5\u8be2\u7528\u6237\u8bbe\u7f6e\u5931\u8d25"));
        }
    }

    private void initBind() {
        this.secCvt = (SecConverter)this.of.create(SecConverter.class);
        this.spCode.clearSuggestions();
        this.spCode.addPossibleSuggestions(this.getRefItems());
        this.autoCompletionNormal = Search.bindAutoCompletion((TextField)this.txtCode, (Callback)this.spCode, (StringConverter)this.secCvt);
        this.autoCompletionNormal.changedProperty().addListener((ob, oldV, newV) -> Platform.runLater(() -> {
            this.onSecurityChange((String)newV);
            this.portfolioTreeTable.refresh();
        }));
        this.txtCode.setTextFormatter(new TextFormatter((UnaryOperator)new SecFilter("[A-Za-z0-9]*", 6)));
        this.txtCode.addEventFilter(KeyEvent.KEY_PRESSED, event -> this.codeKeyPress((KeyEvent)event));
        this.txtCode.focusedProperty().addListener((ob, old, newV) -> this.loseFocus((Boolean)newV));
        this.txtCode.textProperty().bindBidirectional((Property)this.model.securityProperty());
        this.lbName.textProperty().bindBidirectional((Property)this.model.nameProperty());
        this.buyRadio.setToggleGroup(this.group);
        this.sellRadio.setToggleGroup(this.group);
        this.sellRadio.setDisable(true);
        this.buyRadio.selectedProperty().addListener((ob, old, now) -> this.onBSChange((Boolean)old, (Boolean)now));
        this.buyRadio.selectedProperty().bindBidirectional((Property)this.model.buyProperty());
        this.cmbPriceType.setItems(this.model.getPriceStg().getNodes());
        this.cmbPriceType.valueProperty().bindBidirectional(this.model.priceStgProperty());
        this.cmbPriceType.valueProperty().addListener(ob -> this.onPriceTypeChange());
        this.ctrlPrice.ctrl(this.priceSpn);
        this.priceDisableBind();
        MxBindings.bindSD((Property)this.priceSpn.getEditor().textProperty(), (Property)this.model.priceProperty());
        this.priceSpn.getEditor().addEventFilter(KeyEvent.KEY_PRESSED, event -> this.priceKeyPress((KeyEvent)event));
        this.priceSpn.getEditor().setOnMouseClicked(event -> this.preModel.selectTwoOrAllPriceDecimal());
        this.priceSpn.getEditor().setText("");
        this.priceSpn.getEditor().visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> ((MxNode)this.cmbPriceType.getValue()).getRaw().equals("50"), (Observable[])new Observable[]{this.cmbPriceType.valueProperty()}));
        SpinnerUtils.arrowsStyle(this.priceSpn);
        SpinnerUtils.arrowsStyle(this.quantitySpn);
        this.setPriceUnit();
        this.ctrlCount.ctrl(this.quantitySpn);
        this.quantityDisableBind();
        MxBindings.bindSI((Property)this.quantitySpn.getEditor().textProperty(), (Property)this.model.countProperty());
        this.quantitySpn.getEditor().addEventFilter(KeyEvent.KEY_PRESSED, event -> this.quantityKeyPress((KeyEvent)event));
        this.quantitySpn.getEditor().setOnMouseClicked(event -> this.quantitySpn.getEditor().selectAll());
        this.quantitySpn.getEditor().clear();
        this.hboxCounts.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.model.getCountStg().is("1"), (Observable[])new Observable[]{this.model.countStgProperty()}));
        this.countStg.setItems(this.model.getCountStg().getNodes());
        this.countStg.valueProperty().addListener((ob, old, now) -> this.onCountStgChange((MxNode)now));
        this.countStg.valueProperty().bindBidirectional(this.model.countStgProperty());
        this.countStg.addEventFilter(KeyEvent.KEY_RELEASED, event -> this.cmbStgKeyPress((KeyEvent)event));
    }

    protected void priceDisableBind() {
        this.priceSpn.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.model.isLimitPrice(), (Observable[])new Observable[]{this.model.priceStgProperty()}));
    }

    protected void quantityDisableBind() {
        this.quantitySpn.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.model.getCountStg().is("1"), (Observable[])new Observable[]{this.model.countStgProperty()}));
    }

    protected void quantityKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode()) {
            this.txtCode.requestFocus();
            this.txtCode.selectAll();
            key.consume();
        } else if (KeyCode.ENTER == key.getCode()) {
            this.priceSpn.requestFocus();
            this.order();
            this.preModel.selectTwoOrAllPriceDecimal();
            key.consume();
        }
    }

    @Override
    protected void setPriceUnit() {
        this.lbUnit.setText("\u80a1");
    }

    private void priceKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode() || KeyCode.ENTER == key.getCode()) {
            if (((MxNode)this.countStg.getValue()).getRaw().equals("1")) {
                this.quantitySpn.requestFocus();
                this.quantitySpn.getEditor().selectAll();
            }
            key.consume();
        }
    }

    private void onPriceTypeChange() {
        this.priceSpn.getEditor().setText("");
    }

    @Override
    protected void onBSChange(Boolean old, Boolean now) {
        Platform.runLater(() -> {
            Date time = new Date();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
            logger.info(String.valueOf(df.format(time)) + "\u5f00\u59cb\u4e70\u5356\u5207\u6362");
            if (now.booleanValue()) {
                this.btnOrder.setText(this.getBuySymbol());
                CssUtils.addStyleClass((Control)this.btnOrder, (String)"btnRed");
                logger.info("\u53ef\u8f6c\u503a\u7533\u8d2d\u6295\u7ec4\u6307\u4ee4\u6267\u884c\u4e70");
            } else {
                this.btnOrder.setText(this.getSellSymbol());
                CssUtils.removeStyleClass((Control)this.btnOrder, (String)"btnRed");
                logger.info("\u53ef\u8f6c\u503a\u7533\u8d2d\u6295\u7ec4\u6307\u4ee4\u6267\u884c\u5356");
            }
            logger.info("\u6700\u7ec8\u7ed3\u679c\u663e\u793a" + this.btnOrder.getText());
            this.preModel.onBsChange(now);
            this.layout();
        });
    }

    public void setBuySymbol(String buySymbol) {
        this.buySymbol = buySymbol;
    }

    public void setSellSymbol(String sellSymbol) {
        this.sellSymbol = sellSymbol;
    }

    public String getBuySymbol() {
        return this.buySymbol;
    }

    public String getSellSymbol() {
        return this.sellSymbol;
    }

    private void loseFocus(Boolean val) {
        if (!val.booleanValue() && this.txtCode.getText().length() > 0) {
            this.check();
        } else if (val.booleanValue()) {
            Platform.runLater(() -> this.txtCode.selectAll());
        }
    }

    protected Collection<RefItem> getRefItems() {
        ArrayList<RefItem> list = new ArrayList<RefItem>();
        for (RefItem item : this.refMng.getItems(new String[]{"OIS"})) {
            ConvertibleBond bond = (ConvertibleBond)item;
            if (!bond.getSubType().equals("\u53ef\u8f6c\u503a\u7533\u8d2d")) continue;
            list.add((RefItem)((ConvertibleBond)item));
        }
        return list;
    }

    protected void onSecurityChange(String newText) {
        RefItem refItem = null;
        Object obj = this.txtCode.getUserData();
        if (obj instanceof RefItem) {
            refItem = (RefItem)RefItem.class.cast(obj);
        }
        this.model.getMI().setRefItem(refItem);
        if (this.model.isValidRef()) {
            this.ctrlPrice.setScale(this.mktItem.getRefItem().getScale());
        }
        this.model.onSecChange();
        this.preModel.onCountStgChange(this.buyRadio.isSelected());
        if (newText.length() >= 6) {
            this.check();
        }
        if (refItem != null) {
            this.txtCode.textProperty().set((Object)refItem.getCode());
            this.txtCode.selectEnd();
            this.txtCode.deselect();
        }
        if (this.isPstEvent) {
            this.isPstEvent = false;
            this.model.setCount(this.pstEvent.getInt("count"));
            this.model.setPrice(((HandicapInfo)this.mktItem.getListBuyHandicap().get(0)).getPrice());
            this.sellRadio.setSelected(this.pstEvent.getBool("side_sell"));
        }
        if (this.model.isValidRef()) {
            this.priceSettle = false;
            this.setPrePrice();
        }
        Platform.runLater(() -> {
            if (this.model.isValidRef()) {
                if (this.mktItem.getRefItem().getMarket().equals("XSHG")) {
                    this.lbUnit.setText("\u624b");
                    this.ctrlCount.setUnit(1);
                } else {
                    this.lbUnit.setText("\u5f20");
                    this.ctrlCount.setUnit(10);
                }
                RefItem item = this.refMng.getItem("OIS", this.model.getMI().getRefItem().getMarket(), this.model.getSecurity());
                if (item != null && item instanceof ConvertibleBond) {
                    ConvertibleBond bond = (ConvertibleBond)ConvertibleBond.class.cast(item);
                    this.model.setPrice(bond.getSubPrice());
                }
            }
        });
    }

    protected void setPrePrice() {
        if (this.model.getPrice() > 0.0 || this.priceSettle) {
            return;
        }
        this.model.setPrice(this.preModel.getDefPrice(this.buyRadio.isSelected()));
        if (this.preModel.getDefPrice(this.buyRadio.isSelected()) != 0.0) {
            this.priceSettle = true;
        }
    }

    protected void check() {
        if (this.txtCode.getText().length() < 6) {
            return;
        }
        RefItem ref = this.mktItem.getRefItem();
        if (ref == null || ref.getName().equals("") || this.model.getValidRef() == null) {
            this.lbName.setText(INVALID_CODE);
        } else if (this.mktItem.getStop().getValue().booleanValue()) {
            this.lbName.setText(this.mktItem.getStatus());
        }
    }

    @Override
    protected void createAcctTree() {
        this.cmbDist.setItems(this.model.getDistStg().getNodes());
        this.cmbDist.valueProperty().bindBidirectional(this.model.distStgProperty());
        this.txtSearch.textProperty().bindBidirectional((Property)this.model.getAccDisModel().searchSecProperty());
        this.txtSearch.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9]+", 16));
        this.portfolioCol.setCellValueFactory(data -> ((PortfolioAccountDistribution)data.getValue().getValue()).portfolioProperty());
        this.portfolioCol.setCellFactory(p -> new PortfoCollapseCell(this.model.getAccDisModel().isSingle()));
        this.accountCol.setCellValueFactory(data -> ((PortfolioAccountDistribution)data.getValue().getValue()).accProperty());
        this.accountCol.setCellFactory(p -> new AccCollapseCell(this.model.getAccDisModel().isSingle()));
        this.secAcctCol.setCellValueFactory(data -> ((PortfolioAccountDistribution)data.getValue().getValue()).secAccProperty());
        this.availableCol.setCellValueFactory(data -> ((PortfolioAccountDistribution)data.getValue().getValue()).isPortDist() ? ((PortfolioAccountDistribution)data.getValue().getValue()).getPortfolio().availableProperty() : (((PortfolioAccountDistribution)data.getValue().getValue()).getAcc() == null ? new SimpleDoubleProperty(0.0) : ((PortfolioAccountDistribution)data.getValue().getValue()).getAcc().availableProperty()));
        this.availableCol.setCellFactory(p -> new MoneyCell(2));
        this.canBuyCol.setCellValueFactory(data -> ((PortfolioAccountDistribution)data.getValue().getValue()).canBuyProperty());
        this.canBuyCol.setCellFactory(cell -> new NumberTreeTableCell());
        this.canSellCol.setCellValueFactory(data -> ((PortfolioAccountDistribution)data.getValue().getValue()).canSellProperty());
        this.canSellCol.setCellFactory(cell -> new NumberTreeTableCell());
        this.canBuyCol.setEditable(false);
        this.canSellCol.setEditable(false);
        this.model.getAccDisModel().repoProperty().addListener((ob, old, newV) -> {
            this.canBuyCol.setVisible(newV == false);
            this.canSellCol.setVisible(newV == false);
        });
        this.assetCol.setCellValueFactory(data -> ((PortfolioAccountDistribution)data.getValue().getValue()).isPortDist() ? ((PortfolioAccountDistribution)data.getValue().getValue()).getPortfolio().assetAmtProperty() : (((PortfolioAccountDistribution)data.getValue().getValue()).getAcc() == null ? new SimpleDoubleProperty(0.0) : ((PortfolioAccountDistribution)data.getValue().getValue()).getAcc().assetAmtProperty()));
        this.assetCol.setCellFactory(p -> new MoneyCell(2));
        this.weightCol.setCellValueFactory(data -> ((PortfolioAccountDistribution)data.getValue().getValue()).weightProperty());
        this.weightCol.setCellFactory(p -> new WeightCell(0));
        this.amountCol.setCellValueFactory(data -> ((PortfolioAccountDistribution)data.getValue().getValue()).countProperty());
        this.amountCol.setCellFactory(cell -> new NumberTreeTableCell());
        this.checkBoxCol.setCellFactory(p -> new PortfolioCheckBoxCell(this.model.getAccDisModel().isSingle(), !this.model.getAccDisModel().isActive()));
        this.portfolioTreeTable.setRoot(this.model.getAccDisModel().getRoot());
        this.portfolioTreeTable.setShowRoot(false);
        this.portfolioTreeTable.sort();
        this.portfolioTreeTable.refresh();
        this.portfolioTreeTable.setPlaceholder((Node)new Label());
        this.portfolioTreeTable.editableProperty().bind((ObservableValue)this.model.getAccDisModel().activeProperty());
        this.availableCol.setEditable(false);
        this.assetCol.setEditable(false);
        ContextMenu menu = new ContextMenu();
        MenuItem itemCopy = new MenuItem("\u590d\u5236");
        MenuItem itemRefresh = new MenuItem("\u5237\u65b0");
        menu.getItems().add((Object)itemCopy);
        menu.getItems().add((Object)itemRefresh);
        this.portfolioTreeTable.setContextMenu(menu);
        itemRefresh.setOnAction(event -> this.model.getAccDisModel().refresh());
        itemCopy.setOnAction(event -> this.copy());
        this.acctTreeSupplement();
    }

    @Override
    protected void acctTreeSupplement() {
        this.model.countStgProperty().addListener(ob -> {
            String stg = this.model.getCountStg().getRaw();
            if (stg.equals("1") || stg.equals("5")) {
                this.cmbDist.setDisable(false);
            } else {
                this.cmbDist.setDisable(true);
            }
        });
        this.canBuyCol.setCellFactory(p -> new MoneyCell(0));
        TableUtils.orgnizeClmWidth(this.portfolioTreeTable);
    }

    protected void doChange(RefItem refItem, String newText) {
        this.model.getMI().setRefItem(refItem);
        this.quantitySpn.getEditor().clear();
        this.priceSpn.getEditor().clear();
        if (this.model.isValidRef()) {
            this.ctrlPrice.setScale(this.mktItem.getRefItem().getScale());
        }
        this.model.onSecChange();
        this.preModel.onCountStgChange(this.buyRadio.isSelected());
        if (refItem != null) {
            this.txtCode.setText(refItem.getCode());
        }
        this.txtCode.selectEnd();
        this.txtCode.deselect();
        if (newText.length() >= 6) {
            this.check();
        }
        if (this.model.isValidRef()) {
            this.priceSettle = false;
            this.setPrePrice();
        }
    }

    private void copy() {
        StringBuilder clipboardString = new StringBuilder();
        clipboardString.append(String.valueOf(this.portfolioCol.getText()) + "\t" + this.accountCol.getText() + "\t" + this.secAcctCol.getText() + "\t" + this.availableCol.getText() + "\t" + this.assetCol.getText() + "\t" + this.weightCol.getText() + "\t" + this.amountCol.getText() + "\t" + this.canBuyCol.getText() + "\t" + this.canSellCol.getText() + "\t" + '\n');
        for (TreeItem item : this.model.getAccDisModel().getRoot().getChildren()) {
            PortfolioAccountDistribution portfDis = (PortfolioAccountDistribution)item.getValue();
            clipboardString.append(portfDis.getPortfolio() + "\t" + "\t" + "\t" + portfDis.getPortfolio().getAvailable() + "\t" + portfDis.getPortfolio().getAssetAmt() + "\t" + portfDis.getWeight() + "\t" + portfDis.getCount() + "\t" + portfDis.getCanBuy() + "\t" + portfDis.getCanSell() + "\t" + '\n');
            for (TreeItem subItem : item.getChildren()) {
                PortfolioAccountDistribution accDis = (PortfolioAccountDistribution)subItem.getValue();
                clipboardString.append("\t" + accDis.getAcc() + "\t" + "\t" + accDis.getAcc().getAvailable() + "\t" + accDis.getAcc().getAssetAmt() + "\t" + (accDis.getWeight() == 0 ? "" : Integer.valueOf(0)) + "\t" + accDis.getCount() + "\t" + accDis.getCanBuy() + "\t" + accDis.getCanSell() + "\t" + '\n');
                for (TreeItem secItem : subItem.getChildren()) {
                    PortfolioAccountDistribution secAccDis = (PortfolioAccountDistribution)secItem.getValue();
                    clipboardString.append("\t\t" + secAccDis.getSecAcc() + "\t" + "\t" + "\t" + (secAccDis.getWeight() == 0 ? "" : Integer.valueOf(0)) + "\t" + secAccDis.getCount() + "\t" + secAccDis.getCanBuy() + "\t" + secAccDis.getCanSell() + "\t" + '\n');
                }
            }
        }
        ClipboardContent content = new ClipboardContent();
        content.putString(clipboardString.toString());
        Clipboard.getSystemClipboard().setContent((Map)content);
    }

    @Override
    @FXML
    public void order() {
        this.model.validSecAcc();
        if (this.valid()) {
            try {
                if (this.preModel.isPopBeforeOrder()) {
                    CcsEntrustConfirmDialog obj = (CcsEntrustConfirmDialog)this.of.create(CcsEntrustConfirmDialog.class);
                    obj.setRefItem(this.mktItem.getRefItem());
                    obj.setPriceStg(this.model.getPriceStg());
                    obj.setUnit(this.lbUnit.getText());
                    obj.setList(this.model.getEntrustList(true));
                    MxDialog dialog = this.df.create((DialogObj)obj, StringUtils.isEmpty((String)this.confirmSymbol) ? "\u4e0b\u5355\u786e\u8ba4" : this.confirmSymbol);
                    if (dialog.launch() == ButtonType.OK) {
                        this.doAction();
                        logger.info("\u53ef\u8f6c\u503a\u7533\u8d2d\u6295\u7ec4\u6307\u4ee4\u4e0b\u5355");
                    }
                } else {
                    this.doAction();
                }
            }
            catch (MException e) {
                logger.error("\u53ef\u8f6c\u503a\u7533\u8d2d\u6295\u7ec4\u6307\u4ee4\u4e0b\u5355\u5931\u8d25" + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    protected String doAction() throws MException {
        return this.model.submitOrder();
    }

    @Override
    public boolean valid() {
        String tip1 = "\u8bf7\u8f93\u5165\u6709\u6548\u4ee3\u7801";
        if (!this.alert.check(this.model.isValidRef(), Alert.AlertType.WARNING, tip1)) {
            return false;
        }
        if (!this.priceValid()) {
            return false;
        }
        String tip4 = "\u672a\u9009\u62e9\u8bc1\u5238\u8d26\u53f7";
        if (!this.alert.check(this.model.SelectedNumValid(), Alert.AlertType.WARNING, tip4)) {
            return false;
        }
        String tip5 = "\u4ea4\u6613\u6570\u91cf\u4e0d\u5408\u6cd5";
        if (!this.alert.check(this.model.getCount() >= 0L && this.model.isCountValid() != false, Alert.AlertType.WARNING, tip5)) {
            return false;
        }
        String tip6 = "\u4fdd\u62a4\u4ef7\u683c\u9700\u8981\u5927\u4e8e0\uff0c\u5c0f\u4e8e1\u4e07\u5143\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165";
        if (!this.alert.check(!this.model.isStar() || !this.model.isMktPrice() || this.model.isStar() && this.model.getPriceProtected() > 0.0 && this.model.getPriceProtected() < 10000.0, Alert.AlertType.WARNING, tip6)) {
            return false;
        }
        if (this.model.getValidRef().getType().equals("REPO")) {
            String tip7 = "\u6295\u7ec4\u4e0d\u652f\u6301\u6b63\u56de\u8d2d\u4e1a\u52a1";
            if (!this.alert.check(!this.model.isBuy(), Alert.AlertType.WARNING, tip7)) {
                return false;
            }
        }
        return true;
    }

    protected boolean priceValid() {
        String tip3 = "\u672a\u8f93\u5165\u4ef7\u683c";
        return this.alert.check(!this.model.isLimitPrice() && !this.model.isAfterHoursPrice() || this.model.isUnlimited() || this.model.getPrice() > 0.0, Alert.AlertType.WARNING, tip3);
    }

    @Override
    public MarketItem getMarketItem() {
        return this.mktItem;
    }

    protected void setDialogSymbol(String symbol) {
        this.confirmSymbol = symbol;
    }

    @Override
    public Label getLbCountOne() {
        return this.lbCountOne;
    }

    public void setLbCountOne(Label lbCountOne) {
        this.lbCountOne = lbCountOne;
    }

    @Override
    public Label getLbCountTwo() {
        return this.lbCountTwo;
    }

    public void setLbCountTwo(Label lbCountTwo) {
        this.lbCountTwo = lbCountTwo;
    }

    @Override
    public Label getLbCountThree() {
        return this.lbCountThree;
    }

    public void setLbCountThree(Label lbCountThree) {
        this.lbCountThree = lbCountThree;
    }

    @Override
    public Label getLbCountFour() {
        return this.lbCountFour;
    }

    public void setLbCountFour(Label lbCountFour) {
        this.lbCountFour = lbCountFour;
    }

    @Override
    public RefItem getValidRef() {
        return this.model.getValidRef();
    }

    private class MoneyCell
    extends EditTreeTableCell<PortfolioAccountDistribution> {
        MoneyCell(int i) {
            super(i);
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
            PortfolioAccountDistribution accItem = (PortfolioAccountDistribution)this.getTreeTableRow().getItem();
            if (!empty && accItem != null && accItem.isIsSecAcc()) {
                this.setText("");
            }
        }
    }

    private class WeightCell
    extends EditTreeTableCell<PortfolioAccountDistribution> {
        WeightCell(int i) {
            super(i);
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty && this.getTreeTableRow().getItem() != null) {
                this.editableProperty().bind((ObservableValue)((PortfolioAccountDistribution)this.getTreeTableRow().getItem()).portDistProperty());
                if (!((PortfolioAccountDistribution)this.getTreeTableRow().getItem()).isPortDist()) {
                    this.setText("");
                }
            }
        }
    }
}

