/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.portfolio.viewers.convertible;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MException;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.AlgoParam;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.entity.trade.instruction.OrderAdvice;
import cms.tmx.portfolio.viewers.LoadPartModel;
import cms.tmx.portfolio.viewers.convertible.PortfolioConvertibleBondTradePart;
import cms.tmx.query.current.models.portfolio.AlgoFuncControl;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IMarketDataMng;
import java.net.URL;
import java.util.Timer;
import java.util.TimerTask;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InstructionConvertiblePortfPassPart
extends PortfolioConvertibleBondTradePart {
    private static final Logger logger = LogManager.getLogger(InstructionConvertiblePortfPassPart.class);
    protected OrderAdvice advice;
    protected AlgoParam algoAdvice;
    protected Instruction instruction;
    protected MEvent instructEvent = new MEvent();
    protected boolean isInstructionEvent = false;
    private boolean inApprove = false;
    @Inject
    private IMarketDataMng mktMng;
    @Inject
    protected AlgoFuncControl algoFunc;
    @Inject
    private LoadPartModel load;
    protected MEventHandler hSetCode = event -> Platform.runLater(() -> {
        this.instructEvent = event;
        if (this.instructEvent.get((Object)"instruction") == null || !(this.instructEvent.get((Object)"instruction") instanceof Instruction)) {
            return;
        }
        if (!this.validOrderFill()) {
            return;
        }
        this.instruction = (Instruction)Instruction.class.cast(this.instructEvent.get((Object)"instruction"));
        this.doSetCode();
    });
    protected boolean initFinished = false;
    protected ChangeListener<Boolean> lstnFocusPrice = (ob, old, newV) -> {
        if (this.advice == null) {
            return;
        }
        if (this.model.isUpLimit() && !newV.booleanValue() && this.model.getPrice() > this.advice.getPrice()) {
            this.model.setPrice(this.advice.getPrice());
            this.priceSpn.getEditor().requestFocus();
            this.priceSpn.getEditor().selectAll();
        }
        if (this.model.isDownLimit() && !newV.booleanValue() && this.model.getPrice() < this.advice.getPrice()) {
            this.model.setPrice(this.advice.getPrice());
            this.priceSpn.getEditor().requestFocus();
            this.priceSpn.getEditor().selectAll();
        }
    };
    protected ChangeListener<Boolean> lstnFocusQuantity = (ob, old, newV) -> {
        if (this.advice == null) {
            return;
        }
        if (newV.booleanValue()) {
            return;
        }
        this.modifyQuantity();
    };

    @Inject
    public InstructionConvertiblePortfPassPart() {
        this.path = "PortfolioConvertibleBondTradePart.fxml";
    }

    public boolean isInApprove() {
        return this.inApprove;
    }

    public void setInApprove(boolean inApprove) {
        this.inApprove = inApprove;
    }

    @Override
    protected URL getFXMLLocation() {
        URL url = super.getFXMLLocation();
        if (url == null) {
            url = this.load.getClass().getResource(String.valueOf(((Object)((Object)this)).getClass().getSuperclass().getSuperclass().getSimpleName()) + ".fxml");
        }
        return url;
    }

    @Override
    @FXML
    public void initialize() {
        super.initialize();
        this.buyRadio.setDisable(true);
        this.sellRadio.setDisable(true);
        this.cmbPriceType.setDisable(true);
        this.countStg.setDisable(true);
        this.priceSpn.getEditor().focusedProperty().addListener(this.lstnFocusPrice);
        this.quantitySpn.getEditor().focusedProperty().addListener(this.lstnFocusQuantity);
        this.initFinished = true;
        Platform.runLater(() -> this.doSetCode());
    }

    protected void doSetCode() {
        if (!this.initFinished || this.instruction == null) {
            return;
        }
        this.initPanel();
        if (this.instruction.getType().getRaw().equals("3")) {
            this.advice = this.instruction.getOrderAdvice();
            this.model.setInstruction(this.instruction);
            if (this.advice == null) {
                return;
            }
            RefItem refItem = this.refMng.getItem(this.advice.getSecType(), this.advice.getMarket(), this.advice.getSec());
            this.txtCode.setUserData((Object)refItem);
            this.doSecurityChange(refItem, this.advice.getSec());
        }
        this.portfolioTreeTable.refresh();
        this.layout();
    }

    private void doSecurityChange(RefItem refItem, String secCode) {
        super.doChange(refItem, secCode);
        if (this.isInstructionEvent && this.advice != null && this.getValidRef() != null && this.instruction.getType().getRaw().equals("3")) {
            this.isInstructionEvent = false;
            this.doOrderFill();
        }
    }

    protected boolean validOrderFill() {
        return false;
    }

    public void doOrderFill() {
        if (this.getValidRef() == null) {
            return;
        }
        long effectiveQuantity = this.instruction.getIsOrderStep() ? this.advice.getOrderAvailableQuantity() : this.advice.getOrderQty();
        this.quantitySpn.getEditor().setText(Long.toString(effectiveQuantity));
        this.model.getAccDisModel().fillPorfolio(this.instruction);
        this.cmbPriceType.getSelectionModel().select((Object)this.model.getPriceStg().getNode(Integer.toString(this.advice.getOrdType())));
        if (this.advice.getSide() == 50 || this.advice.getSide() == 70) {
            this.sellRadio.setSelected(true);
        } else {
            this.buyRadio.setSelected(true);
        }
        if (this.instruction.getIsOrderStep() && this.model.isLimitPrice()) {
            if (this.model.isSpecify()) {
                this.model.setPrice(this.advice.getPrice());
            } else {
                this.priceSpn.getEditor().clear();
            }
        }
        if (!this.instruction.getIsOrderStep() && this.model.isLimitPrice()) {
            this.model.setPrice(this.advice.getPrice());
        }
        if (this.instruction.getOrderAdvice().getOrdType() == 99) {
            this.model.setPrice(this.advice.getPrice());
        }
        if (this.instruction.getSecurityCode().startsWith("688")) {
            this.model.setPriceProtected(this.advice.getProtectedLimitPrice());
        }
        this.onApprove(true);
    }

    protected void sliceCheck(TextField tf) {
        String slice = tf.getText();
        if (StringUtils.patternCheck((String)"[0-9]?", (String)slice)) {
            tf.insertText(0, "0");
        }
    }

    @Override
    @FXML
    public void order() {
        super.order();
        this.clearPanel();
    }

    protected void clearPanel() {
        this.setInApprove(false);
        this.advice = null;
        this.instruction = null;
        this.txtCode.requestFocus();
        this.txtCode.clear();
        this.onSecurityChange(this.txtCode.getText());
        this.buyRadio.setSelected(true);
        this.cmbPriceType.getSelectionModel().select(0);
        this.quantitySpn.getEditor().clear();
        this.priceSpn.getEditor().clear();
        this.model.getAccDisModel().removeTree();
        this.countStg.getSelectionModel().select(0);
        this.model.setInstruction(new Instruction());
        this.onApprove(false);
        this.model.getAccDisModel().setActive(true);
    }

    private void initPanel() {
        this.setInApprove(true);
        this.isInstructionEvent = true;
        this.txtCode.clear();
        this.quantitySpn.getEditor().clear();
        this.priceSpn.getEditor().clear();
        this.countStg.getSelectionModel().select(0);
        this.model.setInstruction(new Instruction());
        this.onApprove(true);
        this.model.getAccDisModel().setActive(false);
        this.buyRadio.setSelected(true);
    }

    protected void onApprove(boolean disable) {
        this.txtCode.setEditable(!disable);
    }

    @Override
    protected String doAction() {
        String doAction = "";
        try {
            doAction = super.doAction();
        }
        catch (MException e) {
            logger.info("\u53ef\u8f6c\u503a\u7533\u8d2d\u6307\u4ee4\u5931\u8d25" + e.getMessage());
        }
        if ("3".equals(this.model.getAccDisModel().getInstructType())) {
            this.clearPanel();
        } else if (this.preModel.isClearAfterOrder()) {
            this.clearCountCheck();
            this.updateInstruction(false);
        } else {
            this.updateInstruction(true);
        }
        return doAction;
    }

    private void updateInstruction(final boolean updateCount) {
        Timer timer = new Timer();
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                Platform.runLater(() -> {
                    try {
                        InstructionConvertiblePortfPassPart.this.model.getInstructionModel().refreshResource(InstructionConvertiblePortfPassPart.this.instruction);
                    }
                    catch (MException mException) {
                        InstructionConvertiblePortfPassPart.this.alert.alert(Alert.AlertType.ERROR, "\u81ea\u52a8\u586b\u5165\u5269\u4f59\u6570\u91cf\u5f02\u5e38\uff0c\u8bf7\u624b\u52a8\u518d\u6b21\u6267\u884c\u586b\u5355");
                    }
                    if (InstructionConvertiblePortfPassPart.this.instruction.getResource().getAvailOrderQty() <= 0L) {
                        InstructionConvertiblePortfPassPart.this.clearCountCheckForce();
                        return;
                    }
                    InstructionConvertiblePortfPassPart.this.model.getAccDisModel().fillPorfolio(InstructionConvertiblePortfPassPart.this.instruction);
                    InstructionConvertiblePortfPassPart.this.advice = InstructionConvertiblePortfPassPart.this.instruction.getOrderAdvice();
                    InstructionConvertiblePortfPassPart.this.model.onSecChange();
                    if (updateCount) {
                        InstructionConvertiblePortfPassPart.this.quantitySpn.getEditor().setText(StringUtils.toStr((double)InstructionConvertiblePortfPassPart.this.instruction.getResource().getAvailOrderQty(), (int)0));
                    }
                });
            }
        };
        timer.schedule(task, 1000L);
    }

    protected void clearCountCheckForce() {
        block10: {
            if (!this.preModel.isClearAfterOrder()) break block10;
            switch (this.model.getCountStg().getRaw()) {
                case "5": {
                    this.model.setMoney(0.0);
                    break;
                }
                case "1": {
                    this.model.setCount(0L);
                    break;
                }
                default: {
                    this.model.setCountPer(0.0);
                }
            }
        }
    }

    @Override
    public boolean valid() {
        String tip1 = "\u8bf7\u4ece\u6307\u4ee4\u5217\u8868\u4e2d\u586b\u5165\u6307\u4ee4";
        if (!this.alert.check(this.isInApprove(), Alert.AlertType.WARNING, tip1)) {
            return false;
        }
        return super.valid();
    }

    @Override
    protected void priceDisableBind() {
        this.priceSpn.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.model.isLimitPrice() && !this.model.isAfterHoursPrice() || this.model.isUnlimited() || this.model.isSpecify() || this.model.getAccDisModel().isActive(), (Observable[])new Observable[]{this.model.priceStgProperty(), this.model.priceTypeLimitedStgProperty(), this.model.getAccDisModel().activeProperty()}));
    }

    @Override
    protected void quantityDisableBind() {
        this.quantitySpn.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.model.getCountStg().is("1") || this.model.getAccDisModel().isActive(), (Observable[])new Observable[]{this.model.countStgProperty(), this.model.getAccDisModel().activeProperty()}));
    }

    @Override
    public void setPrice(double price) {
        if ((this.model.isLimitPrice() || this.model.isAfterHoursPrice()) && price > 0.0 && !this.model.isUnlimited() && !this.priceSpn.isDisabled()) {
            this.priceSpn.getValueFactory().setValue((Object)price);
        }
    }

    protected void checkRepo() {
    }

    @Override
    protected void quantityKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode()) {
            this.txtCode.requestFocus();
            this.txtCode.selectAll();
            key.consume();
        } else if (KeyCode.ENTER == key.getCode()) {
            this.priceSpn.requestFocus();
            this.modifyQuantity();
            this.order();
            this.preModel.selectTwoOrAllPriceDecimal();
            key.consume();
        }
    }

    private void modifyQuantity() {
        long effectiveQuantity;
        long l = effectiveQuantity = this.instruction.getIsOrderStep() ? this.advice.getOrderAvailableQuantity() : this.advice.getOrderQty();
        if (this.model.getCount() > effectiveQuantity) {
            this.model.setCount(effectiveQuantity);
            this.quantitySpn.getEditor().requestFocus();
            this.quantitySpn.getEditor().selectAll();
        }
    }
}

