/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.portfolio.viewers.convertible;

import cms.tmx.core.MException;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.portfolio.viewers.convertible.InstructionConvertiblePortfPassPart;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InstructionConvertiblePortfExecPart
extends InstructionConvertiblePortfPassPart {
    private static final Logger logger = LogManager.getLogger(InstructionConvertiblePortfExecPart.class);

    @Override
    protected void setPrePrice() {
        if (this.model.isBidAskPrice() && !this.priceSettle) {
            this.model.setBidAskPrice();
            if (this.model.getPrice() > 0.0) {
                this.priceSettle = true;
            }
            return;
        }
        if (this.model.isMktPrice() && !this.priceSettle) {
            this.model.setMktPrice();
            if (this.model.getPrice() > 0.0) {
                this.priceSettle = true;
            }
            return;
        }
    }

    @Inject
    public InstructionConvertiblePortfExecPart() {
        this.path = "PortfolioConvertibleBondTradePart.fxml";
    }

    @PostConstruct
    public void init() {
        super.init();
        this.es.subscribe("instruction.set.on.panel", this.hSetCode);
    }

    @PreDestroy
    private void close() {
        this.es.unSubscribe("instruction.set.on.panel", this.hSetCode);
    }

    @Override
    @FXML
    public void initialize() {
        super.initialize();
        this.model.create("4");
        this.setBuySymbol("\u6307\u4ee4\u7533\u8d2d");
        this.setSellSymbol("\u6307\u4ee4\u7533\u8d2d");
        this.initPane();
        this.mktItem.changedProperty().addListener(ob -> this.setPrePrice());
    }

    private void initPane() {
        this.txtCode.setDisable(true);
    }

    @PreDestroy
    public void destroy() {
        this.es.unSubscribe("instruction.set.on.panel", this.hSetCode);
    }

    @Override
    protected boolean validOrderFill() {
        Instruction eventInstr = (Instruction)Instruction.class.cast(this.instructEvent.get((Object)"instruction"));
        return ("3".equals(eventInstr.getType().getRaw()) || "9".equals(eventInstr.getType().getRaw())) && eventInstr.getIsOrderStep();
    }

    @Override
    protected String doAction() {
        try {
            this.model.execute(this.instruction);
        }
        catch (MException e) {
            logger.error("\u53ef\u8f6c\u503a\u7533\u8d2d\u6295\u7ec4\u6307\u4ee4\u6267\u884c\u5931\u8d25 " + e.getMessage());
        }
        String doAction = super.doAction();
        this.clearPanel();
        return doAction;
    }

    @Override
    protected boolean priceValid() {
        String tip3 = "\u672a\u8f93\u5165\u4ef7\u683c";
        return this.alert.check(this.model.isMktPrice() || this.model.getPrice() > 0.0, Alert.AlertType.WARNING, tip3);
    }

    @Override
    public void setPrice(double price) {
        if ((this.model.isLimitPrice() || this.model.isAfterHoursPrice()) && !this.model.isSpecify() && price > 0.0) {
            this.model.setPrice(price);
            this.priceSpn.getValueFactory().setValue((Object)price);
            this.priceSpn.getEditor().requestFocus();
            this.priceSpn.getEditor().selectAll();
        }
    }

    @Override
    protected void priceDisableBind() {
        this.priceSpn.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.model.isLimitPrice() || this.model.isSpecify() || this.model.getAccDisModel().isActive(), (Observable[])new Observable[]{this.model.priceStgProperty(), this.model.priceTypeLimitedStgProperty(), this.model.getAccDisModel().activeProperty()}));
    }

    @Override
    protected void doSetCode() {
        super.doSetCode();
        if (!this.initFinished || this.instruction == null) {
            return;
        }
        if (this.instruction.isCanModify()) {
            return;
        }
        this.layout();
    }

    @Override
    public void doOrderFill() {
        if (this.getValidRef() == null) {
            return;
        }
        long effectiveQuantity = this.instruction.getIsOrderStep() ? this.advice.getOrderAvailableQuantity() : this.advice.getOrderQty();
        this.quantitySpn.getEditor().setText(Long.toString(effectiveQuantity));
        this.model.getAccDisModel().fillPorfolio(this.instruction);
        this.cmbPriceType.getSelectionModel().select((Object)this.model.getPriceStg().getNode(Integer.toString(this.advice.getOrdType())));
        if (this.advice.getSide() == 50 || this.advice.getSide() == 70) {
            this.sellRadio.setSelected(true);
        } else {
            this.buyRadio.setSelected(true);
        }
        if (this.instruction.getIsOrderStep() && this.model.isLimitPrice()) {
            this.model.setPrice(this.advice.getPrice());
        }
        this.onApprove(true);
    }
}

