/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.portfolio.viewers;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.formatters.SecFilter;
import cms.tmx.control.search.Search;
import cms.tmx.control.spinner.DoubleSpinnerCtrl;
import cms.tmx.control.spinner.IntSpinnerCtrl;
import cms.tmx.control.spinner.SpinnerUtils;
import cms.tmx.control.table.EditTreeTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.TextFieldUtils;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.data.utils.HandicapCountCell;
import cms.tmx.data.utils.PriceCell;
import cms.tmx.data.utils.SecConverter;
import cms.tmx.data.utils.SecSuggest;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.Portfolio;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.data.HandicapInfo;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.PortfolioAccountDistribution;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.MxBindings;
import cms.tmx.portfolio.models.PortfolioTradeModel;
import cms.tmx.portfolio.models.UserPrePortfolioCtrl;
import cms.tmx.portfolio.uitls.AccCollapseCell;
import cms.tmx.portfolio.uitls.PortfoCollapseCell;
import cms.tmx.portfolio.viewers.LoadPartModel;
import cms.tmx.portfolio.viewers.PortfolioCheckBoxCell;
import cms.tmx.trade.utils.TradeBindings;
import cms.tmx.trade.views.CcsEntrustConfirmDialog;
import cms.tmx.utils.StringUtils;
import cms.tmx.web.api.settings.UserPreOrderTips;
import cmx.tmx.data.IRefDataMng;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import java.util.function.UnaryOperator;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Spinner;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javax.inject.Inject;
import javax.inject.Named;

public class PortfolioTradePart
extends MxPart {
    public static final int SECURITY_TYPE = 1;
    @Inject
    protected PortfolioTradeModel model;
    @FXML
    private TableColumn<String, String> indexBuy;
    @FXML
    private TableColumn<String, String> indexSell;
    @FXML
    private TextField txtCode;
    @FXML
    private GridPane gridPanel;
    @FXML
    private Label lbName;
    @FXML
    protected Label lbSide;
    @FXML
    protected RadioButton buyRadio;
    @FXML
    protected RadioButton sellRadio;
    @FXML
    protected ComboBox<MxNode> countStg;
    @FXML
    private ComboBox<MxNode> cmbPriceType;
    @FXML
    protected Spinner<Double> priceSpn;
    @FXML
    protected Label lbUnit;
    @FXML
    protected Spinner<Integer> quantitySpn;
    @FXML
    private Label lbPer;
    @FXML
    private Label lbPerSymbol;
    @FXML
    private TextField txtPerCount;
    @FXML
    protected Spinner<Double> moneySpn;
    @FXML
    private Label lbRate;
    @FXML
    private Label lbLatest;
    @FXML
    protected Label lbUpLimit;
    @FXML
    protected Label lbDownLimit;
    @FXML
    protected ComboBox<MxNode> cmbDist;
    @FXML
    protected TreeTableView<PortfolioAccountDistribution> portfolioTreeTable;
    @FXML
    private TreeTableColumn<PortfolioAccountDistribution, Boolean> checkBoxCol;
    @FXML
    private TreeTableColumn<PortfolioAccountDistribution, Portfolio> portfolioCol;
    @FXML
    private TreeTableColumn<PortfolioAccountDistribution, CcsFundAccount> accountCol;
    @FXML
    private TreeTableColumn<PortfolioAccountDistribution, SecAccount> secAcctCol;
    @FXML
    protected TreeTableColumn<PortfolioAccountDistribution, Number> availableCol;
    @FXML
    private TreeTableColumn<PortfolioAccountDistribution, Number> assetCol;
    @FXML
    private TreeTableColumn<PortfolioAccountDistribution, Number> weightCol;
    @FXML
    private TreeTableColumn<PortfolioAccountDistribution, Number> amountCol;
    @FXML
    protected TreeTableColumn<PortfolioAccountDistribution, Number> canBuyCol;
    @FXML
    protected TreeTableColumn<PortfolioAccountDistribution, Number> canSellCol;
    @FXML
    private Label lbCountOne;
    @FXML
    private Label lbCountTwo;
    @FXML
    private Label lbCountThree;
    @FXML
    private Label lbCountFour;
    @FXML
    private Label lbAmountOne;
    @FXML
    private Label lbAmountTwo;
    @FXML
    private Label lbAmountThree;
    @FXML
    private Label lbAmountFour;
    @FXML
    private Label lbTotalOne;
    @FXML
    private Label lbTotalTwo;
    @FXML
    private Label lbTotalThree;
    @FXML
    private Label lbTotalFour;
    @FXML
    private Label lbCanbuyOne;
    @FXML
    private Label lbCanbuyTwo;
    @FXML
    private Label lbCanbuyThree;
    @FXML
    private Label lbCanbuyFour;
    @FXML
    private Label lbCansellOne;
    @FXML
    private Label lbCansellTwo;
    @FXML
    private Label lbCansellThree;
    @FXML
    private Label lbCansellFour;
    @FXML
    private HBox hboxCounts;
    @FXML
    private HBox hboxPer;
    @FXML
    private HBox hboxMoney;
    @FXML
    private HBox hboxCommAmount;
    @FXML
    private HBox hboxTotalAsset;
    @FXML
    private HBox hboxCanbuy;
    @FXML
    private HBox hboxCansell;
    @FXML
    private TableView<HandicapInfo> tableMarketSell;
    @FXML
    private TableColumn<HandicapInfo, String> mktSellPrice;
    @FXML
    private TableColumn<HandicapInfo, Number> colSellCount;
    @FXML
    private TableView<HandicapInfo> tableMarketBuy;
    @FXML
    private TableColumn<HandicapInfo, String> mktBuyPrice;
    @FXML
    private TableColumn<HandicapInfo, Number> colBuyCount;
    @FXML
    protected Label lbCan;
    @FXML
    protected Label lbCanCount;
    @FXML
    protected Button btnOrder;
    private ToggleGroup group = new ToggleGroup();
    @Inject
    @Named(value="core_event")
    protected MEvent eCore;
    @Inject
    private IRefDataMng refMng;
    @Inject
    protected MEventService es;
    @Inject
    protected MxAlert alert;
    @Inject
    protected MObjFactory of;
    @Inject
    protected DialogFactory df;
    @Inject
    private UserPreOrderTips setTips;
    private static final String INVALID_CODE = "\u65e0\u6548\u4ee3\u7801";
    protected MarketItem mktItem;
    private SecConverter secCvt;
    @Inject
    protected UserPrePortfolioCtrl preModel;
    protected DoubleSpinnerCtrl ctrlPrice = new DoubleSpinnerCtrl(true, 6, 2);
    protected IntSpinnerCtrl ctrlCount = new IntSpinnerCtrl(true, 9, 100);
    protected DoubleSpinnerCtrl ctrlMoney = new DoubleSpinnerCtrl(true, 12, 2);
    private SecSuggest spCode = new SecSuggest();
    private MEventHandler hSetCode = event -> {
        this.txtCode.requestFocus();
        if (this.txtCode.isFocused()) {
            this.txtCode.setText(event.getStr("sec_code"));
        }
        if (this.txtCode.getText().equals(event.getStr("sec_code"))) {
            this.model.setCount(event.getInt("count"));
            this.model.setPrice(((HandicapInfo)this.mktItem.getListBuyHandicap().get(0)).getPrice());
            this.model.setPstAcct(event.getStr("secAccount"), event.getStr("tMarket"));
            this.sellRadio.setSelected(event.getBool("side_sell"));
        }
    };
    @Inject
    private LoadPartModel load;

    @Inject
    public PortfolioTradePart() {
    }

    public void onShowEvent(MEvent event) {
    }

    @FXML
    public void initialize() {
        this.mktItem = this.model.getMI();
        this.mktItem.refItemProperty().addListener(ob -> this.onRefChange());
        this.refMng.changedProperty().addListener(ob -> {
            Collection<RefItem> list = this.getRefItems();
            this.spCode.setAllSuggestions(list);
        });
        this.initUserPre();
        this.initControls();
        this.createMarketTable();
        this.createAcctTree();
        this.es.subscribe("trade.panel.set.code", this.hSetCode);
        this.mktItem.changedProperty().addListener((ob, old, now) -> {
            if (this.model.getPrice() > 0.0) {
                return;
            }
            this.model.setPrice(this.preModel.getDefPrice(this.buyRadio.isSelected()));
            this.priceSpn.getValueFactory().setValue((Object)this.model.getPrice());
        });
    }

    private Collection<RefItem> getRefItems() {
        if (this.model.getTradeType().equals("CCS")) {
            return this.refMng.getItems(new String[]{"STOCK", "BOND", "FUND", "REPO"});
        }
        return this.refMng.getItems(new String[]{this.model.getTradeType()});
    }

    public void afterTableRestore() {
        this.accountCol.setVisible(!this.model.getAccDisModel().isSingle());
        this.secAcctCol.setVisible(!this.model.getAccDisModel().isSingle());
    }

    protected void initControls() {
        this.secCvt = (SecConverter)this.of.create(SecConverter.class);
        this.spCode.setAllSuggestions(this.getRefItems());
        Search.bindAutoCompletion((TextField)this.txtCode, (Callback)this.spCode, (StringConverter)this.secCvt).changedProperty().addListener((ob, oldV, newV) -> {
            this.onSecurityChange();
            this.portfolioTreeTable.refresh();
        });
        this.txtCode.setTextFormatter(new TextFormatter((UnaryOperator)new SecFilter("[A-Za-z0-9]*", 6)));
        this.txtCode.addEventFilter(KeyEvent.KEY_PRESSED, event -> this.codeKeyPress((KeyEvent)event));
        this.txtCode.focusedProperty().addListener((ob, old, newV) -> this.loseFocus((Boolean)newV));
        this.txtCode.textProperty().bindBidirectional((Property)this.model.securityProperty());
        this.lbName.textProperty().bindBidirectional((Property)this.model.nameProperty());
        this.buyRadio.setToggleGroup(this.group);
        this.sellRadio.setToggleGroup(this.group);
        this.buyRadio.selectedProperty().addListener((ob, old, now) -> this.onBSChange((Boolean)old, (Boolean)now));
        this.buyRadio.selectedProperty().bindBidirectional((Property)this.model.buyProperty());
        this.cmbPriceType.setItems(this.model.getPriceStg().getNodes());
        this.cmbPriceType.valueProperty().bindBidirectional(this.model.priceStgProperty());
        this.cmbPriceType.valueProperty().addListener(ob -> this.onPriceTypeChange());
        this.ctrlPrice.ctrl(this.priceSpn);
        this.priceSpn.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.model.isLimitPrice(), (Observable[])new Observable[]{this.model.priceStgProperty()}));
        MxBindings.bindSD((Property)this.priceSpn.getEditor().textProperty(), (Property)this.model.priceProperty());
        this.priceSpn.getEditor().addEventFilter(KeyEvent.KEY_PRESSED, event -> this.priceKeyPress((KeyEvent)event));
        this.priceSpn.getEditor().setOnMouseClicked(event -> this.preModel.selectTwoOrAllPriceDecimal());
        this.priceSpn.getEditor().setText("");
        this.priceSpn.getEditor().visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> ((MxNode)this.cmbPriceType.getValue()).getRaw().equals("50"), (Observable[])new Observable[]{this.cmbPriceType.valueProperty()}));
        SpinnerUtils.arrowsStyle(this.priceSpn);
        SpinnerUtils.arrowsStyle(this.quantitySpn);
        SpinnerUtils.arrowsStyle(this.moneySpn);
        this.setPriceUnit();
        this.lbCan.visibleProperty().bind((ObservableValue)this.model.getAccDisModel().showCanBuyProperty());
        this.lbCanCount.visibleProperty().bind((ObservableValue)this.model.getAccDisModel().showCanBuyProperty());
        MxBindings.bindSI((Property)this.lbCanCount.textProperty(), (Property)this.model.getAccDisModel().canBuyProperty());
        this.ctrlCount.ctrl(this.quantitySpn);
        this.quantitySpn.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.model.getCountStg().is("1"), (Observable[])new Observable[]{this.model.countStgProperty()}));
        MxBindings.bindSI((Property)this.quantitySpn.getEditor().textProperty(), (Property)this.model.countProperty());
        this.quantitySpn.getEditor().addEventFilter(KeyEvent.KEY_PRESSED, event -> this.quantityKeyPress((KeyEvent)event));
        this.quantitySpn.getEditor().setOnMouseClicked(event -> this.quantitySpn.getEditor().selectAll());
        this.countStg.setItems(this.model.getCountStg().getNodes());
        this.countStg.valueProperty().addListener((ob, old, now) -> this.onCountStgChange((MxNode)now));
        this.countStg.valueProperty().bindBidirectional(this.model.countStgProperty());
        this.countStg.addEventFilter(KeyEvent.KEY_RELEASED, event -> this.cmbStgKeyPress((KeyEvent)event));
        this.hboxCounts.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.model.getCountStg().is("1"), (Observable[])new Observable[]{this.model.countStgProperty()}));
        this.hboxPer.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.model.getCountStg().is("3") || this.model.getCountStg().is("2") || this.model.getCountStg().is("4"), (Observable[])new Observable[]{this.model.countStgProperty()}));
        TextFieldUtils.setLess100((TextField)this.txtPerCount);
        MxBindings.bindSD((Property)this.txtPerCount.textProperty(), (Property)this.model.countPerProperty());
        this.hboxMoney.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.model.getCountStg().getRaw().equals("5"), (Observable[])new Observable[]{this.model.countStgProperty()}));
        this.ctrlMoney.ctrl(this.moneySpn);
        this.moneySpn.getEditor().addEventFilter(KeyEvent.KEY_PRESSED, event -> this.quantityKeyPress((KeyEvent)event));
        this.txtPerCount.addEventFilter(KeyEvent.KEY_PRESSED, event -> this.quantityKeyPress((KeyEvent)event));
        MxBindings.bindSDTwoScale((Property)this.moneySpn.getEditor().textProperty(), (Property)this.model.moneyProperty());
        this.moneySpn.getEditor().setText(String.format("%1$,.2f", this.model.getMoney()));
        this.hboxCommAmount.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.model.getCountStg().getRaw().equals("5"), (Observable[])new Observable[]{this.model.countStgProperty()}));
        this.hboxTotalAsset.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.model.getCountStg().getRaw().equals("2"), (Observable[])new Observable[]{this.model.countStgProperty()}));
        this.hboxCanbuy.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.model.getCountStg().getRaw().equals("3"), (Observable[])new Observable[]{this.model.countStgProperty()}));
        this.hboxCansell.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.model.getCountStg().getRaw().equals("4"), (Observable[])new Observable[]{this.model.countStgProperty()}));
    }

    protected void createMarketTable() {
        this.indexBuy.setCellValueFactory(p -> new ReadOnlyStringWrapper(String.valueOf(new StringBuilder("\u4e70").append(StringUtils.numToChinese((int)(this.tableMarketBuy.getItems().indexOf(p.getValue()) + 1))))));
        this.mktBuyPrice.setCellFactory(cell -> new PriceCell(this.mktItem));
        this.mktBuyPrice.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).priceStrProperty());
        this.colBuyCount.setCellFactory(cell -> new HandicapCountCell(this.mktItem));
        this.colBuyCount.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).countProperty());
        this.tableMarketBuy.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> this.onItemSelected((HandicapInfo)now));
        this.tableMarketBuy.setItems(this.mktItem.getListBuyHandicap());
        this.tableMarketBuy.setPlaceholder((Node)new Label());
        this.indexSell.setCellValueFactory(p -> new ReadOnlyStringWrapper(String.valueOf(new StringBuilder("\u5356").append(StringUtils.numToChinese((int)(this.tableMarketSell.getItems().size() - this.tableMarketSell.getItems().indexOf(p.getValue())))))));
        this.mktSellPrice.setCellFactory(cell -> new PriceCell(this.mktItem));
        this.mktSellPrice.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).priceStrProperty());
        this.colSellCount.setCellFactory(cell -> new HandicapCountCell(this.mktItem));
        this.colSellCount.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).countProperty());
        this.tableMarketSell.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> this.onItemSelected((HandicapInfo)now));
        this.tableMarketSell.setItems((ObservableList)this.mktItem.getListSellHandicap().sorted((h1, h2) -> h1.getIndex() > h2.getIndex() ? -1 : 1));
        this.tableMarketSell.setPlaceholder((Node)new Label());
        this.lbLatest.setOnMouseClicked(event -> this.setPrice(this.mktItem.getNowPrice()));
        this.lbUpLimit.setOnMouseClicked(event -> this.setPrice(this.mktItem.getUpLimitPrice()));
        this.lbDownLimit.setOnMouseClicked(event -> this.setPrice(this.mktItem.getDownLimitPrice()));
        this.lbLatest.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.mktItem.getNowPrice() != 0.0 && !this.mktItem.isClear(), (Observable[])new Observable[]{this.mktItem.changedProperty()}));
        this.lbRate.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.mktItem.getNowPrice() != 0.0 && !this.mktItem.isClear(), (Observable[])new Observable[]{this.mktItem.changedProperty()}));
        this.lbRate.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.mktItem.getNowPrice() != 0.0 && !this.mktItem.isClear(), (Observable[])new Observable[]{this.mktItem.changedProperty()}));
        CssUtils.makeRise((Control)this.lbUpLimit);
        CssUtils.makeFall((Control)this.lbDownLimit);
        MxBindings.percentBinding((Property)this.lbRate.textProperty(), (ObservableNumberValue)this.mktItem.pctProperty(), (int)2);
        this.mktItem.pctProperty().addListener(obs -> {
            CssUtils.checkPrice((Control)this.lbLatest, (double)this.mktItem.getClosePrice(), (double)this.mktItem.getNowPrice());
            CssUtils.checkPct((Control)this.lbRate, (double)this.mktItem.pctProperty().getValue());
        });
    }

    protected void createAcctTree() {
        this.cmbDist.setItems(this.model.getDistStg().getNodes());
        this.cmbDist.valueProperty().bindBidirectional(this.model.distStgProperty());
        this.portfolioCol.setCellValueFactory(data -> ((PortfolioAccountDistribution)data.getValue().getValue()).portfolioProperty());
        this.portfolioCol.setCellFactory(p -> new PortfoCollapseCell(this.model.getAccDisModel().isSingle()));
        this.accountCol.setCellValueFactory(data -> ((PortfolioAccountDistribution)data.getValue().getValue()).accProperty());
        this.accountCol.setCellFactory(p -> new AccCollapseCell(this.model.getAccDisModel().isSingle()));
        this.secAcctCol.setCellValueFactory(data -> ((PortfolioAccountDistribution)data.getValue().getValue()).secAccProperty());
        this.availableCol.setCellValueFactory(data -> ((PortfolioAccountDistribution)data.getValue().getValue()).isPortDist() ? ((PortfolioAccountDistribution)data.getValue().getValue()).getPortfolio().availableProperty() : (((PortfolioAccountDistribution)data.getValue().getValue()).getAcc() == null ? new SimpleDoubleProperty(0.0) : ((PortfolioAccountDistribution)data.getValue().getValue()).getAcc().availableProperty()));
        this.availableCol.setCellFactory(p -> new MoneyCell(2));
        this.canBuyCol.setCellValueFactory(data -> ((PortfolioAccountDistribution)data.getValue().getValue()).canBuyProperty());
        this.canSellCol.setCellValueFactory(data -> ((PortfolioAccountDistribution)data.getValue().getValue()).canSellProperty());
        this.canBuyCol.setEditable(false);
        this.canSellCol.setEditable(false);
        this.assetCol.setCellValueFactory(data -> ((PortfolioAccountDistribution)data.getValue().getValue()).isPortDist() ? ((PortfolioAccountDistribution)data.getValue().getValue()).getPortfolio().assetAmtProperty() : (((PortfolioAccountDistribution)data.getValue().getValue()).getAcc() == null ? new SimpleDoubleProperty(0.0) : ((PortfolioAccountDistribution)data.getValue().getValue()).getAcc().assetAmtProperty()));
        this.assetCol.setCellFactory(p -> new MoneyCell(2));
        this.weightCol.setCellValueFactory(data -> ((PortfolioAccountDistribution)data.getValue().getValue()).weightProperty());
        this.weightCol.setCellFactory(p -> new WeightCell(0));
        this.amountCol.setCellValueFactory(data -> ((PortfolioAccountDistribution)data.getValue().getValue()).countProperty());
        this.checkBoxCol.setCellFactory(p -> new PortfolioCheckBoxCell(this.model.getAccDisModel().isSingle()));
        this.portfolioTreeTable.setRoot(this.model.getAccDisModel().getRoot());
        this.portfolioTreeTable.setShowRoot(false);
        this.portfolioTreeTable.sort();
        this.portfolioTreeTable.refresh();
        this.portfolioTreeTable.setPlaceholder((Node)new Label());
        this.portfolioTreeTable.setEditable(true);
        this.availableCol.setEditable(false);
        this.assetCol.setEditable(false);
        ContextMenu menu = new ContextMenu();
        MenuItem itemCopy = new MenuItem("\u590d\u5236");
        MenuItem itemRefresh = new MenuItem("\u5237\u65b0");
        menu.getItems().add((Object)itemCopy);
        menu.getItems().add((Object)itemRefresh);
        this.portfolioTreeTable.setContextMenu(menu);
        itemRefresh.setOnAction(event -> this.model.getAccDisModel().refresh());
        itemCopy.setOnAction(event -> this.copy());
        this.acctTreeSupplement();
    }

    protected void acctTreeSupplement() {
        this.model.countStgProperty().addListener(ob -> {
            String stg = this.model.getCountStg().getRaw();
            if (stg.equals("1") || stg.equals("5")) {
                this.cmbDist.setDisable(false);
            } else {
                this.cmbDist.setDisable(true);
            }
        });
        this.canBuyCol.setCellFactory(p -> new MoneyCell(0));
        TableUtils.orgnizeClmWidth(this.portfolioTreeTable);
    }

    protected void onRefChange() {
        TradeBindings.priceBinding((Property)this.lbLatest.textProperty(), (ObservableNumberValue)this.mktItem.nowPriceProperty(), (ObservableNumberValue)this.mktItem.getRefItem().priceUnitProperty());
        TradeBindings.priceBinding((Property)this.lbUpLimit.textProperty(), (ObservableNumberValue)this.mktItem.upLimitPriceProperty(), (ObservableNumberValue)this.mktItem.getRefItem().priceUnitProperty());
        TradeBindings.priceBinding((Property)this.lbDownLimit.textProperty(), (ObservableNumberValue)this.mktItem.downLimitPriceProperty(), (ObservableNumberValue)this.mktItem.getRefItem().priceUnitProperty());
        this.ctrlPrice.setScale(this.mktItem.getRefItem().getScale());
        this.priceSpn.getEditor().clear();
        this.lbUpLimit.setVisible(this.model.isValidRef() && !this.model.isBond());
        this.lbDownLimit.setVisible(this.model.isValidRef() && !this.model.isBond());
        this.changeUnit();
    }

    protected void onBSChange(Boolean old, Boolean now) {
        if (now.booleanValue()) {
            this.btnOrder.setText("\u4e70\u5165");
            this.lbCan.setText("\u53ef\u4e70");
            CssUtils.addStyleClass((Control)this.btnOrder, (String)"btnRed");
        } else {
            this.btnOrder.setText("\u5356\u51fa");
            this.lbCan.setText("\u53ef\u5356");
            CssUtils.removeStyleClass((Control)this.btnOrder, (String)"btnRed");
        }
        this.preModel.onBsChange(now);
    }

    private void changeUnit() {
        this.lbUnit.setText("");
        if (this.model.isBond()) {
            if (this.model.isSHbond()) {
                this.lbUnit.setText("\u624b");
            } else {
                this.lbUnit.setText("\u5f20");
            }
        }
        if (this.model.isStock()) {
            this.lbUnit.setText("\u80a1");
        }
        if (this.model.isFund()) {
            this.lbUnit.setText("\u4efd");
        }
        this.ctrlCount.setUnit(this.mktItem.getRefItem().getBuyUnit());
    }

    private void onPriceTypeChange() {
        this.priceSpn.getEditor().setText("");
    }

    protected void onCountStgChange(MxNode now) {
        this.preModel.onCountStgChange(this.buyRadio.isSelected());
    }

    private void loseFocus(Boolean val) {
        if (!val.booleanValue() && this.txtCode.getText().length() > 0) {
            this.check();
        } else if (val.booleanValue()) {
            Platform.runLater(() -> this.txtCode.selectAll());
        }
    }

    protected void onSecurityChange() {
        RefItem refItem = null;
        Object obj = this.txtCode.getUserData();
        if (obj instanceof RefItem) {
            refItem = (RefItem)RefItem.class.cast(obj);
        }
        this.model.getMI().setRefItem(refItem);
        this.model.onSecChange();
        this.preModel.onCountStgChange(this.buyRadio.isSelected());
        if (refItem != null) {
            this.txtCode.textProperty().set((Object)refItem.getCode());
            this.txtCode.selectEnd();
            this.txtCode.deselect();
        }
        if (this.txtCode.getText().length() >= 6 && refItem == null) {
            this.check();
        }
    }

    private void check() {
        RefItem ref = this.mktItem.getRefItem();
        if (ref == null || ref.getName().equals("") || this.mktItem.getStop().getValue().booleanValue() || this.model.getValidRef() == null) {
            this.lbName.setText(INVALID_CODE);
        }
    }

    protected void setPriceUnit() {
        this.lbUnit.setText("\u80a1");
    }

    public boolean valid() {
        String tip1 = "\u8bf7\u8f93\u5165\u6709\u6548\u4ee3\u7801";
        if (!this.alert.check(this.model.isValidRef(), Alert.AlertType.WARNING, tip1)) {
            return false;
        }
        String tip3 = "\u672a\u8f93\u5165\u4ef7\u683c";
        if (!this.alert.check(!this.model.isLimitPrice() || this.model.getPrice() > 0.0, Alert.AlertType.WARNING, tip3)) {
            return false;
        }
        String tip4 = "\u672a\u9009\u62e9\u8bc1\u5238\u8d26\u53f7";
        if (!this.alert.check(this.model.SelectedNumValid(), Alert.AlertType.WARNING, tip4)) {
            return false;
        }
        String tip5 = "\u4ea4\u6613\u6570\u91cf\u4e0d\u5408\u6cd5";
        if (!this.alert.check(this.model.getCount() >= 0L && this.model.isCountValid() != false, Alert.AlertType.WARNING, tip5)) {
            return false;
        }
        if (this.model.getValidRef().getType().equals("REPO")) {
            String tip6 = "\u6295\u7ec4\u4e0d\u652f\u6301\u6b63\u56de\u8d2d\u4e1a\u52a1";
            if (!this.alert.check(!this.model.isBuy(), Alert.AlertType.WARNING, tip6)) {
                return false;
            }
        }
        return true;
    }

    protected String getOrderInfo() {
        StringBuilder info = new StringBuilder();
        for (PortfolioAccountDistribution acc : this.model.validSecAcc()) {
            info.append("\n\u8d26\u53f7 " + acc.getSecAcc().getInverstorSecId() + "\u59d4\u6258\u6570\u91cf " + acc.getCount());
        }
        return info.toString();
    }

    @FXML
    public void order() {
        this.model.validSecAcc();
        if (this.valid()) {
            if (this.preModel.isPopBeforeOrder()) {
                CcsEntrustConfirmDialog obj = (CcsEntrustConfirmDialog)this.of.create(CcsEntrustConfirmDialog.class);
                obj.setRefItem(this.mktItem.getRefItem());
                obj.setPriceStg(this.model.getPriceStg());
                obj.setUnit(this.lbUnit.getText());
                try {
                    obj.setList(this.model.getEntrustList());
                    MxDialog dialog = this.df.create((DialogObj)obj, "\u4e0b\u5355\u786e\u8ba4");
                    if (dialog.launch() == ButtonType.OK) {
                        this.submitOrder();
                    }
                }
                catch (MException e) {
                    this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                }
            } else {
                this.submitOrder();
            }
        }
    }

    private void submitOrder() {
        try {
            String result = this.model.submit();
            this.alert.check(!this.setTips.getOrderTips(), Alert.AlertType.INFORMATION, result);
        }
        catch (MException e) {
            this.alert.check(!this.setTips.getOrderTips(), Alert.AlertType.ERROR, e.getMessage());
        }
        this.clearCountCheck();
    }

    protected void clearCountCheck() {
        block10: {
            if (!this.preModel.isClearAfterOrder()) break block10;
            this.model.setPrice(0.0);
            switch (this.model.getCountStg().getRaw()) {
                case "5": {
                    this.model.setMoney(0.0);
                    break;
                }
                case "1": {
                    this.model.setCount(0L);
                    break;
                }
                default: {
                    this.model.setCountPer(0.0);
                }
            }
        }
    }

    public void codeKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode() || KeyCode.ENTER == key.getCode()) {
            this.priceSpn.requestFocus();
            this.preModel.selectTwoOrAllPriceDecimal();
            if (this.model.isLimitPrice()) {
                this.priceSpn.requestFocus();
                this.preModel.selectTwoOrAllPriceDecimal();
            } else {
                this.quantitySpn.requestFocus();
                this.quantitySpn.getEditor().selectAll();
            }
            key.consume();
        }
    }

    private void priceKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode() || KeyCode.ENTER == key.getCode()) {
            if (((MxNode)this.countStg.getValue()).getRaw().equals("1")) {
                this.quantitySpn.requestFocus();
                this.quantitySpn.getEditor().selectAll();
            } else if (((MxNode)this.countStg.getValue()).getRaw().equals("2")) {
                this.txtPerCount.requestFocus();
                this.txtPerCount.selectAll();
            } else if (((MxNode)this.countStg.getValue()).getRaw().equals("3")) {
                this.txtPerCount.requestFocus();
                this.txtPerCount.selectAll();
            } else if (((MxNode)this.countStg.getValue()).getRaw().equals("4")) {
                this.txtPerCount.requestFocus();
                this.txtPerCount.selectAll();
            } else if (((MxNode)this.countStg.getValue()).getRaw().equals("5")) {
                this.moneySpn.requestFocus();
                this.moneySpn.getEditor().selectAll();
            }
            key.consume();
        }
    }

    private void quantityKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode()) {
            this.txtCode.requestFocus();
            this.txtCode.selectAll();
            key.consume();
        } else if (KeyCode.ENTER == key.getCode()) {
            this.order();
            this.priceSpn.requestFocus();
            this.preModel.selectTwoOrAllPriceDecimal();
            key.consume();
        }
    }

    protected void cmbStgKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode()) {
            this.txtCode.requestFocus();
            key.consume();
        }
    }

    private void onItemSelected(HandicapInfo now) {
        if (now != null) {
            this.setPrice(now.getPrice());
            Platform.runLater(() -> this.clearSelection());
        }
    }

    private void clearSelection() {
        this.tableMarketBuy.getSelectionModel().clearSelection();
        this.tableMarketSell.getSelectionModel().clearSelection();
    }

    public void setPrice(double price) {
        if (this.model.isLimitPrice() && price > 0.0) {
            this.priceSpn.getValueFactory().setValue((Object)price);
            this.model.setPrice(price);
        } else {
            this.priceSpn.getEditor().setText("");
        }
    }

    private void copy() {
        StringBuilder clipboardString = new StringBuilder();
        clipboardString.append(String.valueOf(this.accountCol.getText()) + "\t" + this.secAcctCol.getText() + "\t" + this.availableCol.getText() + "\t" + this.assetCol.getText() + "\t" + this.weightCol.getText() + "\t" + this.amountCol.getText() + "\t" + this.canBuyCol.getText() + "\t" + this.canSellCol.getText() + "\t" + '\n');
        for (TreeItem item : this.model.getAccDisModel().getRoot().getChildren()) {
            PortfolioAccountDistribution accDis = (PortfolioAccountDistribution)item.getValue();
            clipboardString.append(accDis.getAcc() + "\t" + accDis.getSecAcc() + "\t" + accDis.getAcc().getAvailable() + "\t" + accDis.getAcc().getAssetAmt() + "\t" + accDis.getWeight() + "\t" + accDis.getCount() + "\t" + accDis.getCanBuy() + "\t" + accDis.getCanSell() + "\t" + '\n');
            for (TreeItem subItem : item.getChildren()) {
                PortfolioAccountDistribution secAccDis = (PortfolioAccountDistribution)subItem.getValue();
                clipboardString.append(secAccDis.getAcc() + "\t" + secAccDis.getSecAcc() + "\t" + secAccDis.getAcc().getAssetAmt() + "\t" + secAccDis.getAcc().getAvailable() + "\t" + secAccDis.getWeight() + "\t" + secAccDis.getCount() + "\t" + '\n');
            }
        }
        ClipboardContent content = new ClipboardContent();
        content.putString(clipboardString.toString());
        Clipboard.getSystemClipboard().setContent((Map)content);
    }

    public TreeTableView<PortfolioAccountDistribution> getAccTreeTable() {
        return this.portfolioTreeTable;
    }

    protected URL getFXMLLocation() {
        URL url = super.getFXMLLocation();
        if (url == null) {
            url = this.load.getClass().getResource(String.valueOf(((Object)((Object)this)).getClass().getSuperclass().getSimpleName()) + ".fxml");
        }
        return url;
    }

    public void initUserPre() {
        this.preModel.setType("6", "200052");
        this.preModel.setPart(this);
        try {
            this.preModel.doSet();
        }
        catch (MException mException) {
            this.alert.alert(Alert.AlertType.WARNING, "\u67e5\u8be2\u7528\u6237\u8bbe\u7f6e\u5931\u8d25");
        }
    }

    public Spinner<Double> getPriceSpn() {
        return this.priceSpn;
    }

    public Spinner<Integer> getQuantitySpn() {
        return this.quantitySpn;
    }

    public Spinner<Double> getMoneySpn() {
        return this.moneySpn;
    }

    public Label getLbCountOne() {
        return this.lbCountOne;
    }

    public Label getLbCountTwo() {
        return this.lbCountTwo;
    }

    public Label getLbCountThree() {
        return this.lbCountThree;
    }

    public Label getLbCountFour() {
        return this.lbCountFour;
    }

    public Label getLbAmountOne() {
        return this.lbAmountOne;
    }

    public Label getLbAmountTwo() {
        return this.lbAmountTwo;
    }

    public Label getLbAmountThree() {
        return this.lbAmountThree;
    }

    public Label getLbAmountFour() {
        return this.lbAmountFour;
    }

    public Label getLbTotalOne() {
        return this.lbTotalOne;
    }

    public Label getLbTotalTwo() {
        return this.lbTotalTwo;
    }

    public Label getLbTotalThree() {
        return this.lbTotalThree;
    }

    public Label getLbTotalFour() {
        return this.lbTotalFour;
    }

    public Label getLbCanbuyOne() {
        return this.lbCanbuyOne;
    }

    public Label getLbCanbuyTwo() {
        return this.lbCanbuyTwo;
    }

    public Label getLbCanbuyThree() {
        return this.lbCanbuyThree;
    }

    public Label getLbCanbuyFour() {
        return this.lbCanbuyFour;
    }

    public Label getLbCansellOne() {
        return this.lbCansellOne;
    }

    public Label getLbCansellTwo() {
        return this.lbCansellTwo;
    }

    public Label getLbCansellThree() {
        return this.lbCansellThree;
    }

    public Label getLbCansellFour() {
        return this.lbCansellFour;
    }

    public MxNode getCountStg() {
        return (MxNode)this.countStg.getValue();
    }

    public void setCount(Long buyQuantity) {
        this.model.setCount(buyQuantity);
    }

    public void setMoney(Double value) {
        this.model.setMoney(value);
    }

    public void setCountPer(Double value) {
        this.model.setCountPer(value);
    }

    public MarketItem getMarketItem() {
        return this.mktItem;
    }

    public void setAutoSlice(boolean slice, long size) {
        this.model.setAutoSlice(slice);
        this.model.setSliceSize(size);
    }

    public RefItem getValidRef() {
        return this.model.getValidRef();
    }

    private class MoneyCell
    extends EditTreeTableCell<PortfolioAccountDistribution> {
        MoneyCell(int i) {
            super(i);
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
            PortfolioAccountDistribution accItem = (PortfolioAccountDistribution)this.getTreeTableRow().getItem();
            if (!empty && accItem != null && accItem.isIsSecAcc()) {
                this.setText("");
            }
        }
    }

    private class WeightCell
    extends EditTreeTableCell<PortfolioAccountDistribution> {
        WeightCell(int i) {
            super(i);
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty && this.getTreeTableRow().getItem() != null) {
                this.editableProperty().bind((ObservableValue)((PortfolioAccountDistribution)this.getTreeTableRow().getItem()).portDistProperty());
                if (!((PortfolioAccountDistribution)this.getTreeTableRow().getItem()).isPortDist()) {
                    this.setText("");
                }
            }
        }
    }
}

