/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.portfolio.viewers;

import cms.tmx.entity.trade.PortfolioAccountDistribution;
import javafx.beans.property.Property;
import javafx.collections.ListChangeListener;
import javafx.css.PseudoClass;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.input.MouseEvent;

public class PortfolioCheckBoxCell<T>
extends TreeTableCell<PortfolioAccountDistribution, Boolean> {
    private static final PseudoClass pcMxSelected = PseudoClass.getPseudoClass((String)"mselected");
    private boolean isSingle = false;
    private boolean isDisable = false;
    private ListChangeListener<TreeItem<PortfolioAccountDistribution>> lst = ob -> {
        if (ob.getList().size() != 0) {
            this.doCheckChildrenSelected((TreeItem<PortfolioAccountDistribution>)((TreeItem)ob.getList().get(0)));
        }
    };

    public PortfolioCheckBoxCell() {
    }

    public PortfolioCheckBoxCell(boolean isSingle) {
        this.isSingle = isSingle;
    }

    public PortfolioCheckBoxCell(boolean isSingle, boolean isDisable) {
        this.isSingle = isSingle;
        this.isDisable = isDisable;
    }

    private void doCheckChildrenSelected(TreeItem<PortfolioAccountDistribution> treeItem) {
        TreeItem prtItem = treeItem.getParent();
        Boolean isSelected = false;
        if (prtItem == null || prtItem.getValue() == null) {
            return;
        }
        for (TreeItem eachItem : prtItem.getChildren()) {
            if (!((PortfolioAccountDistribution)eachItem.getValue()).isSelected()) continue;
            isSelected = true;
            break;
        }
        ((PortfolioAccountDistribution)prtItem.getValue()).setSelected(isSelected.booleanValue());
        this.doCheckChildrenSelected((TreeItem<PortfolioAccountDistribution>)prtItem);
    }

    public void updateItem(Boolean item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
            this.setText(null);
            this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, false);
        } else {
            this.setText(null);
            if (this.getTreeTableRow().getItem() != null) {
                if (this.isSingle) {
                    this.getTreeTableRow().addEventFilter(MouseEvent.MOUSE_PRESSED, event -> {
                        if (event.getTarget() instanceof PortfolioCheckBoxCell) {
                            event.consume();
                        }
                    });
                }
                CheckBox checkBox = new CheckBox();
                checkBox.selectedProperty().bindBidirectional((Property)((PortfolioAccountDistribution)this.getTreeTableRow().getItem()).selectedProperty());
                checkBox.setDisable(this.isDisable);
                TreeItem treeItem = this.getTreeTableRow().getTreeItem();
                if (treeItem == null) {
                    return;
                }
                treeItem.getChildren().addListener(this.lst);
                treeItem.getChildren().forEach(each -> each.getChildren().addListener(this.lst));
                checkBox.setOnMouseClicked(event -> {
                    this.doCheckChildrenSelected((TreeItem<PortfolioAccountDistribution>)treeItem);
                    TreeItem curItem = treeItem;
                    curItem.getChildren().forEach(each -> {
                        ((PortfolioAccountDistribution)each.getValue()).setSelected(((PortfolioAccountDistribution)treeItem.getValue()).isSelected());
                        if (!each.getChildren().isEmpty()) {
                            each.getChildren().forEach(subEach -> ((PortfolioAccountDistribution)subEach.getValue()).setSelected(((PortfolioAccountDistribution)treeItem.getValue()).isSelected()));
                        }
                    });
                    if (((PortfolioAccountDistribution)treeItem.getValue()).isSelected()) {
                        while (curItem.getParent() != null) {
                            ((PortfolioAccountDistribution)curItem.getParent().getValue()).setSelected(((PortfolioAccountDistribution)treeItem.getValue()).isSelected());
                            curItem = curItem.getParent();
                        }
                    }
                });
                this.doCheckChildrenSelected((TreeItem<PortfolioAccountDistribution>)treeItem);
                if (treeItem.isLeaf()) {
                    checkBox.selectedProperty().addListener((ob, old, newV) -> {
                        if (newV.booleanValue() && treeItem.getParent() != null && treeItem.getParent().getValue() != null) {
                            ((PortfolioAccountDistribution)treeItem.getParent().getValue()).setSelected(newV.booleanValue());
                            this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, newV != false && treeItem.getParent().isExpanded());
                        } else {
                            this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, false);
                        }
                    });
                    this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, ((PortfolioAccountDistribution)treeItem.getValue()).isSelected() && treeItem.getParent().isExpanded());
                } else {
                    checkBox.selectedProperty().addListener((ob, old, newV) -> {
                        this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, newV.booleanValue());
                        if (newV.booleanValue()) {
                            this.getTreeTableView().refresh();
                        }
                    });
                    treeItem.expandedProperty().addListener((ob, old, newV) -> this.getTreeTableView().refresh());
                    this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, ((PortfolioAccountDistribution)treeItem.getValue()).isSelected());
                }
                this.setGraphic((Node)checkBox);
            }
        }
    }
}

