/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.portfolio.viewers;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.entity.Portfolio;
import cms.tmx.portfolio.models.PortfolioBasketInfo;
import cms.tmx.portfolio.models.PortfolioBasketTradeModel;
import cms.tmx.portfolio.viewers.PortfolioBasketAccSetDialog;
import cms.tmx.query.current.models.PortfolioAccountModel;
import cms.tmx.trade.views.basket.BasketTradePart;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import javafx.collections.ListChangeListener;
import javafx.fxml.FXML;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javax.inject.Inject;
import org.controlsfx.control.CheckComboBox;

public class PortfolioBasketTradePart
extends BasketTradePart {
    @FXML
    private CheckComboBox<Portfolio> cmbPortfolio;
    @FXML
    private Label lbPort;
    @Inject
    private PortfolioBasketTradeModel portfolioModel;
    @Inject
    private PortfolioBasketInfo portfolioBi;
    @Inject
    private PortfolioAccountModel portfAccntModel;
    private List<Portfolio> portfolioList = new ArrayList<Portfolio>();
    private ReentrantLock lock = new ReentrantLock();

    @Inject
    public PortfolioBasketTradePart() {
    }

    @FXML
    public void initialize() {
        this.setAccntSizeTip("\u672a\u9009\u62e9\u6295\u7ec4");
        this.setBi(this.portfolioBi);
        this.setModel(this.portfolioModel);
        super.initialize();
    }

    protected void initAcc() {
        this.getAccCheckBox().setVisible(true);
        this.getAccCheckLabel().setVisible(true);
        this.portfolioList = new ArrayList<Portfolio>(this.portfAccntModel.getPortfolios());
        this.portfolioList.removeIf(portfolio -> this.portfAccntModel.getMap(portfolio) == null || this.portfAccntModel.getMap(portfolio).isEmpty());
        this.cmbPortfolio.getItems().setAll(this.portfolioList);
        this.cmbPortfolio.getCheckModel().getCheckedItems().addListener(change -> {
            this.portfolioModel.setAccList(this.getListAccount());
            this.portfolioModel.onPortfolioChange((ListChangeListener.Change<? extends Portfolio>)change);
            this.showTips();
        });
        if (!this.cmbPortfolio.getItems().isEmpty()) {
            this.cmbPortfolio.getCheckModel().clearChecks();
        }
    }

    @FXML
    public void setSecAcc() {
        PortfolioBasketAccSetDialog obj = (PortfolioBasketAccSetDialog)((Object)this.of.create(PortfolioBasketAccSetDialog.class));
        MxDialog dialog = this.df.create((DialogObj)obj, "\u9009\u62e9\u8bc1\u5238\u8d26\u53f7");
        obj.setPortfolioList((List<Portfolio>)this.cmbPortfolio.getCheckModel().getCheckedItems());
        obj.create();
        if (dialog.launch().equals(ButtonType.OK)) {
            this.cmbPortfolio.getCheckModel().clearChecks();
            obj.getPortfolioBasketAccSetModel().getSelectedPortfolioList().forEach(each -> {
                this.lock.lock();
                try {
                    this.cmbPortfolio.getCheckModel().check(each);
                }
                finally {
                    this.lock.unlock();
                }
            });
        }
    }

    private void showTips() {
        this.lbAccContent.setText(this.cmbPortfolio.getCheckModel().getCheckedItems().toString().substring(1, this.cmbPortfolio.getCheckModel().getCheckedItems().toString().length() - 1));
        this.lbAccContent.setTooltip(new Tooltip(this.lbAccContent.getText()));
    }

    public CheckComboBox<?> getAccCheckBox() {
        return this.cmbPortfolio;
    }

    public Label getAccCheckLabel() {
        return this.lbPort;
    }

    protected URL getFXMLLocation() {
        URL url = ((Object)((Object)this)).getClass().getSuperclass().getResource(String.valueOf(((Object)((Object)this)).getClass().getSuperclass().getSimpleName()) + ".fxml");
        return url;
    }
}

