/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.portfolio.uitls;

import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.trade.PortfolioAccountDistribution;
import javafx.css.PseudoClass;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.input.MouseEvent;

public class AccCollapseCell<S>
extends TreeTableCell<PortfolioAccountDistribution, CcsFundAccount> {
    private static final PseudoClass CSS_TREE_ARROW = PseudoClass.getPseudoClass((String)"treeAccArrow");
    private boolean isSingle = false;
    private static final int DOUBLE_CLICK = 2;

    public AccCollapseCell(boolean isSingle) {
        this.isSingle = isSingle;
    }

    public AccCollapseCell() {
    }

    public void updateItem(CcsFundAccount item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (!empty) {
            this.setText(item == null ? "" : String.valueOf(item));
            if (this.isSingle) {
                this.getTreeTableRow().addEventFilter(MouseEvent.MOUSE_RELEASED, event -> {
                    if (event.getClickCount() >= 2) {
                        event.consume();
                    }
                });
                return;
            }
            TreeItem treeItem = this.getTreeTableView().getTreeItem(this.getIndex());
            if (treeItem != null) {
                if (((PortfolioAccountDistribution)treeItem.getValue()).isIsSecAcc() || ((PortfolioAccountDistribution)treeItem.getValue()).isPortDist()) {
                    this.setText("");
                }
                this.getTreeTableRow().pseudoClassStateChanged(CSS_TREE_ARROW, !((PortfolioAccountDistribution)treeItem.getValue()).isPortDist() && !((PortfolioAccountDistribution)treeItem.getValue()).isIsSecAcc());
                this.setOnMouseClicked(event -> {
                    if (treeItem.isExpanded()) {
                        treeItem.setExpanded(false);
                    } else {
                        treeItem.setExpanded(true);
                    }
                });
            } else {
                this.setText("");
                this.getTreeTableRow().pseudoClassStateChanged(CSS_TREE_ARROW, false);
            }
        } else {
            this.setText("");
            this.getTreeTableRow().pseudoClassStateChanged(CSS_TREE_ARROW, false);
        }
    }
}

