/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.portfolio.models;

import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.CcsSubFundAccount;
import cms.tmx.entity.CcsSubSecAccount;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.PortfolioAccountDistribution;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.portfolio.models.PortfolioDistributionModel;
import cms.tmx.trade.api.ITradeModel;
import cms.tmx.trade.entrust.CcsEntrustFactory;
import cms.tmx.trade.entrust.CcsSingleEntrust;
import cms.tmx.trade.models.CcsEntrustSplitModel;
import cmx.tmx.data.IMarketDataMng;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TreeItem;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class PortfolioTradeModel
implements ITradeModel {
    @Inject
    private PortfolioDistributionModel distModel;
    private StringProperty security = new SimpleStringProperty("");
    private StringProperty name = new SimpleStringProperty("");
    private BooleanProperty buy = new SimpleBooleanProperty(true);
    private DoubleProperty price = new SimpleDoubleProperty();
    private LongProperty count = new SimpleLongProperty();
    protected ObjectProperty<MxNode> priceStg = new SimpleObjectProperty();
    private ObjectProperty<MxNode> countStg = new SimpleObjectProperty();
    private ObjectProperty<MxNode> distStg = new SimpleObjectProperty();
    private DoubleProperty countPer = new SimpleDoubleProperty();
    private DoubleProperty money = new SimpleDoubleProperty();
    private boolean autoSlice = false;
    private long sliceSize;
    private StringProperty tradeType = new SimpleStringProperty();
    private final int INIT_UNIT = 100;
    private static final Logger logger = LogManager.getLogger(PortfolioTradeModel.class);
    private boolean countValid = true;
    @Inject
    protected MObjFactory of;
    private MarketItem mktItem;
    @Inject
    private IMarketDataMng mktMng;
    @Inject
    private CcsEntrustFactory ef;
    @Inject
    private CcsEntrustSplitModel entrustSplit;

    @PostConstruct
    public void init() {
        this.setTradeType("CCS");
        try {
            this.getAccDisModel().create();
        }
        catch (MException e) {
            logger.error(e.getMessage());
        }
        this.mktItem = this.mktMng.createItem(10);
        this.getAccDisModel().buyProperty().bind((ObservableValue)this.buy);
        this.buy.addListener(ob -> this.onBsChange());
        MxNode node = MxNodeFactory.create((String)"trade_count_stg", (String)"1");
        this.countStg.addListener(ob -> this.onCountStgChange());
        this.countStgBuy(node);
        node = MxNodeFactory.create((String)"acc_dist_mode", (String)"2");
        this.distStgInit(node);
        this.setDistStg(node);
        node = MxNodeFactory.create((String)"price_type", (String)"50");
        this.initPriceType(node);
        this.setPriceStg(node);
        this.priceStg.addListener(ob -> this.onPriceStgChange());
        this.count.addListener(ob -> this.onCountChange());
        ((PortfolioAccountDistribution)this.getAccDisModel().getRoot().getValue()).countProperty().bind((ObservableValue)this.count);
        this.price.addListener(ob -> this.onPriceChange());
        this.getAccDisModel().priceProperty().bind((ObservableValue)this.price);
        this.getAccDisModel().moneyProperty().bind((ObservableValue)this.money);
        this.money.addListener(ob -> this.onMoneyChange());
        this.getAccDisModel().percentProperty().bind((ObservableValue)Bindings.multiply((double)0.01, (ObservableNumberValue)this.countPer));
        this.countPer.addListener(ob -> this.onCountPerChange());
        this.getAccDisModel().changedProperty().addListener(ob -> this.calCountDistribution());
    }

    public void onSecChange() {
        this.setCount(0L);
        this.setPrice(0.0);
        this.mktItem.setRefItem(this.getValidRef());
        this.getAccDisModel().setRepo(this.isReverseRepo());
        this.mktMng.dye(this.mktItem);
        this.setName(this.mktItem.getRefItem().getName());
        this.filterAcc();
        this.changeMarketPriceType();
        this.changeQuantityUnit();
    }

    public final MarketItem getMI() {
        return this.mktItem;
    }

    private void onCountStgChange() {
        this.getAccDisModel().setCountStg(this.getCountStg().getRaw());
        if (this.getCountStg().getRaw().equals("5")) {
            this.setCount(this.getPrice() != 0.0 ? (long)(this.getMoney() / this.getPrice()) / (long)this.getUnit() * (long)this.getUnit() / (long)this.getCvt() : 0L);
            return;
        }
        this.calCountDistribution();
    }

    private void onCountChange() {
        if (this.getCount() == 0L) {
            this.getAccDisModel().clearCount(this.getAccDisModel().getRoot());
            return;
        }
        this.calCountDistribution();
    }

    protected void onPriceStgChange() {
        this.getAccDisModel().setCountStg(this.getCountStg().getRaw());
        if (!this.isLimitPrice() && this.isValidRef()) {
            this.setPrice(this.isBuy() ? this.mktItem.getUpLimitPrice() : this.mktItem.getDownLimitPrice());
        } else {
            this.setPrice(0.0);
        }
    }

    private void onPriceChange() {
        if (this.getPrice() == 0.0) {
            this.getAccDisModel().clearCount(this.getAccDisModel().getRoot());
            this.getAccDisModel().clearCanBuy(this.getAccDisModel().getRoot());
            return;
        }
        if (this.getCountStg().getRaw().equals("5")) {
            this.setCount((long)(this.getMoney() / this.getPrice()) / (long)this.getUnit() * (long)this.getUnit() / (long)this.getCvt());
            return;
        }
        this.calCountDistribution();
    }

    private void onMoneyChange() {
        if (this.getPrice() != 0.0) {
            this.setCount((long)(this.getMoney() / this.getPrice()) / (long)this.getUnit() * (long)this.getUnit() / (long)this.getCvt());
        }
    }

    private void onCountPerChange() {
        this.calCountDistribution();
    }

    private void calCountDistribution() {
        if (!this.isValidRef()) {
            this.getAccDisModel().clearAll();
            return;
        }
        Platform.runLater(() -> {
            long total = this.getAccDisModel().allocateCount();
            if (this.setCaledCount()) {
                this.setCount(total);
            }
        });
    }

    private void filterAcc() {
        this.getAccDisModel().setRefItem(this.getValidRef());
        this.getAccDisModel().filterAcc();
    }

    private void changeQuantityUnit() {
        if (this.isValidRef()) {
            this.getAccDisModel().setUnit(this.mktItem.getRefItem().getBuyUnit());
            this.setCvt();
        } else {
            this.getAccDisModel().setUnit(100);
        }
    }

    public BooleanProperty buyProperty() {
        return this.buy;
    }

    public boolean isBuy() {
        return this.buyProperty().get();
    }

    public void setBuy(boolean buy) {
        this.buyProperty().set(buy);
    }

    public ObjectProperty<MxNode> countStgProperty() {
        return this.countStg;
    }

    public MxNode getCountStg() {
        return (MxNode)this.countStgProperty().get();
    }

    public void setCountStg(MxNode countStg) {
        this.countStgProperty().set((Object)countStg);
    }

    public List<TreeItem<PortfolioAccountDistribution>> getSelectedItems(TreeItem<PortfolioAccountDistribution> tree) {
        return tree.getChildren().filtered(ad -> ((PortfolioAccountDistribution)ad.getValue()).isSelected());
    }

    public List<TreeItem<PortfolioAccountDistribution>> getNoZeroItems(TreeItem<PortfolioAccountDistribution> tree) {
        return tree.getChildren().filtered(ad -> ((PortfolioAccountDistribution)ad.getValue()).isSelected() && ((PortfolioAccountDistribution)ad.getValue()).getCount() != 0L);
    }

    public synchronized String submit() throws MException {
        Result result = new Result();
        for (CcsSingleEntrust en : this.getEntrustList()) {
            try {
                en.submit();
                ++result.success;
            }
            catch (MException mException) {
                ++result.failed;
            }
        }
        return result.getDesc();
    }

    public List<CcsSingleEntrust> getEntrustList() throws MException {
        LinkedList<CcsSingleEntrust> enList = new LinkedList<CcsSingleEntrust>();
        for (TreeItem<PortfolioAccountDistribution> portfo : this.getSelectedItems(this.getAccDisModel().getRoot())) {
            for (TreeItem<PortfolioAccountDistribution> acc : this.getSelectedItems(portfo)) {
                for (TreeItem<PortfolioAccountDistribution> secAcc : this.getNoZeroItems(acc)) {
                    CcsSingleEntrust en;
                    block39: {
                        block38: {
                            String fundAccId = ((PortfolioAccountDistribution)acc.getValue()).getAcc().getExtAccntId();
                            String secAccId = ((PortfolioAccountDistribution)secAcc.getValue()).getSecAcc().getExtSecAccntId();
                            en = this.createEntrust(fundAccId, secAccId);
                            if (this.isReverseRepo()) {
                                en.setSide(this.buy.get() ? 71 : 70);
                            } else {
                                en.setSide(this.buy.get() ? 49 : 50);
                            }
                            en.setFundAccount((FundAccount)((PortfolioAccountDistribution)acc.getValue()).getAcc());
                            en.setSecAccount(((PortfolioAccountDistribution)secAcc.getValue()).getSecAcc());
                            en.setInvestorId(((PortfolioAccountDistribution)acc.getValue()).getAcc().getInvestId());
                            en.setInvestorSecId(((PortfolioAccountDistribution)secAcc.getValue()).getSecAcc().getInverstorSecId());
                            en.setQuantity(((PortfolioAccountDistribution)secAcc.getValue()).getCount());
                            en.setMarket(this.mktItem.getRefItem().getMarket());
                            en.setSecType(this.mktItem.getRefItem().getType());
                            en.setPrice(this.getPrice());
                            en.setCanSell(((PortfolioAccountDistribution)secAcc.getValue()).getCanSell());
                            if (!this.getPriceStg().getRaw().equals("50")) break block38;
                            en.setOrderType(50);
                            en.setPrice(this.getPrice());
                            break block39;
                        }
                        en.setOrderType(49);
                        switch (this.getPriceStg().getRaw()) {
                            case "SH1": {
                                en.setMaxLevels(5);
                                en.setTif(48);
                                break;
                            }
                            case "SH2": {
                                en.setTif(51);
                                en.setMaxLevels(5);
                                break;
                            }
                            case "SH3": {
                                en.setMaxLevels(1);
                                en.setTif(48);
                                break;
                            }
                            case "SH4": {
                                en.setMaxLevels(0);
                                en.setTif(48);
                                break;
                            }
                            case "SZ1": {
                                en.setTif(48);
                                en.setMaxLevels(1);
                                break;
                            }
                            case "SZ2": {
                                en.setTif(48);
                                en.setMaxLevels(0);
                                break;
                            }
                            case "SZ3": {
                                en.setTif(51);
                                en.setMaxLevels(0);
                                break;
                            }
                            case "SZ4": {
                                en.setTif(51);
                                en.setMaxLevels(5);
                                break;
                            }
                            case "SZ5": {
                                en.setTif(52);
                                en.setMaxLevels(0);
                                break;
                            }
                        }
                    }
                    en.setSec(this.mktItem.getRefItem().getCode());
                    en.setSecName(this.mktItem.getRefItem().getName());
                    en.setAppID(this.isReverseRepo() ? "110" : "010");
                    if (!(((PortfolioAccountDistribution)acc.getValue()).getAcc() instanceof CcsSubFundAccount) || !(((PortfolioAccountDistribution)secAcc.getValue()).getSecAcc() instanceof CcsSubSecAccount)) {
                        throw new MException(1, "\u8d26\u53f7\u9519\u8bef");
                    }
                    CcsSubFundAccount subFundAcc = (CcsSubFundAccount)CcsSubFundAccount.class.cast(((PortfolioAccountDistribution)acc.getValue()).getAcc());
                    CcsSubSecAccount subSecAcc = (CcsSubSecAccount)CcsSubSecAccount.class.cast(((PortfolioAccountDistribution)secAcc.getValue()).getSecAcc());
                    en.setPortfolioId(((PortfolioAccountDistribution)portfo.getValue()).getPortfolio().getId());
                    en.setPortfolioName(((PortfolioAccountDistribution)portfo.getValue()).getPortfolio().getName());
                    en.setSubAccntId(subFundAcc.getSubAccntId());
                    en.setSubSecAccntId(subSecAcc.getSubSecAccntId());
                    if (this.isAutoSlice()) {
                        this.entrustSplit.setRefItem(this.getValidRef());
                        List splitList = this.entrustSplit.split(en, this.getSliceSize());
                        enList.addAll(splitList);
                        continue;
                    }
                    enList.add(en);
                }
            }
        }
        return enList;
    }

    public void getSelectedSecAcc() {
    }

    public final ObjectProperty<MxNode> distStgProperty() {
        return this.distStg;
    }

    public final MxNode getDistStg() {
        return (MxNode)this.distStgProperty().get();
    }

    public final void setDistStg(MxNode distStg) {
        this.distStgProperty().set((Object)distStg);
    }

    public String getDirection() {
        return this.isBuy() ? "\u4e70\u5165" : "\u5356\u51fa";
    }

    public boolean isLimitPrice() {
        return this.getPriceStg().is(Integer.toString(50));
    }

    public String getLimitOrMarket() {
        return this.isLimitPrice() ? "\u9650\u4ef7" : "\u5e02\u4ef7";
    }

    public final StringProperty tradeTypeProperty() {
        return this.tradeType;
    }

    public final String getTradeType() {
        return (String)this.tradeTypeProperty().get();
    }

    public final void setTradeType(String tradeType) {
        this.tradeTypeProperty().set((Object)tradeType);
    }

    private void changeMarketPriceType() {
        MxNode node = this.getPriceStg();
        if (this.isBond()) {
            this.initPriceType(node);
            return;
        }
        if (this.mktItem.getRefItem().getMarket().equals("XSHG")) {
            this.shMarket(node);
        } else if (this.mktItem.getRefItem().getMarket().equals("XSHE")) {
            this.szMarket(node);
        } else {
            this.initPriceType(node);
        }
    }

    protected void initPriceType(MxNode node) {
        this.removeOthers(node, "50");
    }

    private MxNode shMarket(MxNode node) {
        this.removeOthers(node, "50");
        node.addNode("SH1");
        node.addNode("SH2");
        return node;
    }

    private MxNode szMarket(MxNode node) {
        this.removeOthers(node, "50");
        node.addNode("SZ1");
        node.addNode("SZ2");
        node.addNode("SZ3");
        node.addNode("SZ4");
        node.addNode("SZ5");
        return node;
    }

    private void countStgBuy(MxNode node) {
        String oldNodeRaw = node.getRaw();
        this.removeOthers(node, "1");
        node.addNode("3");
        node.addNode("5");
        node.addNode("2");
        node.setRaw(oldNodeRaw.equals("4") ? "3" : oldNodeRaw);
        this.setCountStg(node);
    }

    private void countStgSell(MxNode node) {
        String oldNodeRaw = node.getRaw();
        this.removeOthers(node, "1");
        node.addNode("4");
        node.addNode("5");
        node.addNode("2");
        node.setRaw(oldNodeRaw.equals("3") ? "4" : oldNodeRaw);
        this.setCountStg(node);
    }

    private void distStgInit(MxNode node) {
        this.removeOthers(node, "2");
        this.getAccDisModel().setDistStg(node.getRaw());
    }

    public DoubleProperty countPerProperty() {
        return this.countPer;
    }

    public double getCountPer() {
        return this.countPerProperty().get();
    }

    public void setCountPer(double countPer) {
        this.countPerProperty().set(countPer);
    }

    public DoubleProperty moneyProperty() {
        return this.money;
    }

    public double getMoney() {
        return this.moneyProperty().get();
    }

    public void setMoney(double money) {
        this.moneyProperty().set(money);
    }

    public boolean isValidRef() {
        if (this.mktItem.getRefItem() == null) {
            return false;
        }
        if (this.mktItem.getRefItem().getType().isEmpty()) {
            return false;
        }
        if (this.getTradeType().equals("CCS")) {
            return true;
        }
        return this.mktItem.getRefItem().getType().equals(this.getTradeType());
    }

    public RefItem getValidRef() {
        RefItem item = this.mktItem.getRefItem();
        if (item == null || item.getType().isEmpty()) {
            return null;
        }
        if (this.getTradeType().equals("CCS")) {
            return item;
        }
        if (item.getType().equals(this.getTradeType())) {
            return item;
        }
        return null;
    }

    private int getUnit() {
        return this.getAccDisModel().getUnit();
    }

    private int getCvt() {
        return this.getAccDisModel().getUnitConvert();
    }

    private void setCvt() {
        this.getAccDisModel().setUnitConvert(this.isSHbond() ? 10 : 1);
    }

    public boolean isSHbond() {
        if (!this.isValidRef()) {
            return false;
        }
        return this.isBond() && this.mktItem.getRefItem().getMarket().equals("XSHG");
    }

    public boolean isBond() {
        if (!this.isValidRef()) {
            return false;
        }
        return this.getValidRef().getType().equals("BOND") || this.getValidRef().getType().equals("REPO");
    }

    public boolean isReverseRepo() {
        if (!this.isValidRef()) {
            return false;
        }
        return this.getValidRef().getType().equals("REPO");
    }

    public boolean isStock() {
        if (!this.isValidRef()) {
            return false;
        }
        return this.getValidRef().getType().equals("STOCK");
    }

    public boolean isFund() {
        if (!this.isValidRef()) {
            return false;
        }
        return this.getValidRef().getType().equals("FUND");
    }

    private boolean setCaledCount() {
        return this.getCountStg().getRaw().equals("4") || this.getCountStg().getRaw().equals("3") || this.getCountStg().getRaw().equals("2");
    }

    private void onBsChange() {
        MxNode nodeCountStg = this.getCountStg();
        if (this.isBuy()) {
            this.countStgBuy(nodeCountStg);
        } else {
            this.countStgSell(nodeCountStg);
        }
        if (!this.isLimitPrice() && this.isValidRef()) {
            this.setPrice(this.isBuy() ? this.mktItem.getUpLimitPrice() : this.mktItem.getDownLimitPrice());
        }
        this.filterAcc();
    }

    public void removeOthers(MxNode rowNode, String raw) {
        Iterator it = rowNode.getNodes().iterator();
        while (it.hasNext()) {
            MxNode node = (MxNode)it.next();
            if (node.getRaw().equals(raw)) continue;
            it.remove();
        }
    }

    public CcsSingleEntrust createEntrust(String acc, String secAcc) {
        return this.ef.createCcsSingle(acc, secAcc);
    }

    public PortfolioDistributionModel getAccDisModel() {
        return this.distModel;
    }

    public final StringProperty securityProperty() {
        return this.security;
    }

    public final String getSecurity() {
        return (String)this.securityProperty().get();
    }

    public final void setSecurity(String security) {
        this.securityProperty().set((Object)security);
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    public final String getName() {
        return (String)this.nameProperty().get();
    }

    public final void setName(String name) {
        this.nameProperty().set((Object)name);
    }

    public DoubleProperty priceProperty() {
        return this.price;
    }

    public double getPrice() {
        return this.priceProperty().get();
    }

    public void setPrice(double price) {
        this.priceProperty().set(price);
    }

    public ObjectProperty<MxNode> priceStgProperty() {
        return this.priceStg;
    }

    public MxNode getPriceStg() {
        return (MxNode)this.priceStgProperty().get();
    }

    public void setPriceStg(MxNode priceStg) {
        this.priceStgProperty().set((Object)priceStg);
    }

    public LongProperty countProperty() {
        return this.count;
    }

    public long getCount() {
        return this.countProperty().get();
    }

    public void setCount(long count) {
        this.countProperty().set(count);
    }

    public boolean isAutoSlice() {
        return this.autoSlice;
    }

    public void setAutoSlice(boolean autoSlice) {
        this.autoSlice = autoSlice;
    }

    public long getSliceSize() {
        return this.sliceSize;
    }

    public void setSliceSize(long sliceSize) {
        this.sliceSize = sliceSize;
    }

    public void setPstAcct(String secAcc, String mkt) {
        this.getAccDisModel().clearSelect();
    }

    public void clearCount(TreeItem<PortfolioAccountDistribution> parent) {
        parent.getChildren().forEach(each -> {
            ((PortfolioAccountDistribution)each.getValue()).setCount(0L);
            for (TreeItem sub : each.getChildren()) {
                if (sub == null) continue;
                ((PortfolioAccountDistribution)sub.getValue()).setCount(0L);
            }
        });
    }

    public Boolean isCountValid() {
        return this.countValid;
    }

    public boolean SelectedNumValid() {
        for (TreeItem item : this.getAccDisModel().getRoot().getChildren().filtered(ad -> ((PortfolioAccountDistribution)ad.getValue()).isSelected())) {
            for (TreeItem subItem : item.getChildren().filtered(pd -> ((PortfolioAccountDistribution)pd.getValue()).isSelected())) {
                for (TreeItem secItem : subItem.getChildren()) {
                    if (!((PortfolioAccountDistribution)secItem.getValue()).isSelected()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public List<PortfolioAccountDistribution> validSecAcc() {
        LinkedList<PortfolioAccountDistribution> list = new LinkedList<PortfolioAccountDistribution>();
        int totalcount = 0;
        this.countValid = true;
        for (TreeItem portfo : this.getAccDisModel().getRoot().getChildren().filtered(ad -> ((PortfolioAccountDistribution)ad.getValue()).isSelected())) {
            for (TreeItem acc : portfo.getChildren().filtered(ad -> ((PortfolioAccountDistribution)ad.getValue()).isSelected())) {
                for (TreeItem sec : acc.getChildren().filtered(ad -> ((PortfolioAccountDistribution)ad.getValue()).isSelected())) {
                    if (((PortfolioAccountDistribution)sec.getValue()).getCount() == 0L) continue;
                    list.add((PortfolioAccountDistribution)sec.getValue());
                    totalcount = (int)((long)totalcount + ((PortfolioAccountDistribution)sec.getValue()).getCount());
                }
            }
        }
        if (totalcount == 0) {
            this.countValid = false;
        }
        return list;
    }

    public class Result {
        public int success;
        public int failed;

        public String getDesc() {
            return "\u4e0b\u5355\u63d0\u4ea4\u6210\u529f" + this.success + "\u7b14" + " " + "\u5931\u8d25" + this.failed + "\u7b14";
        }
    }
}

