/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.portfolio.models;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.define.MxDict;
import cms.tmx.entity.AccntStepAttribute;
import cms.tmx.entity.CcsSubFundAccount;
import cms.tmx.entity.CcsSubSecAccount;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.User;
import cms.tmx.entity.WorkFlowDescriptor;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.PortfolioAccountDistribution;
import cms.tmx.entity.trade.instruction.AccntSecInfo;
import cms.tmx.entity.trade.instruction.AppointedTraderSetting;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.entity.trade.instruction.InstructionSubmitResult;
import cms.tmx.entity.trade.instruction.OrderAdvice;
import cms.tmx.entity.trade.instruction.Resource;
import cms.tmx.javafx.MxNode;
import cms.tmx.manage.models.PostMngServiceImpl;
import cms.tmx.portfolio.models.InstrPortfoDistributionModel;
import cms.tmx.portfolio.models.UserPrePortfolioCtrl;
import cms.tmx.query.current.models.InstructionAccountModel;
import cms.tmx.query.current.models.InstructionModel;
import cms.tmx.query.current.models.ResourceModel;
import cms.tmx.trade.api.ITradeModel;
import cms.tmx.trade.entrust.CcsEntrustFactory;
import cms.tmx.trade.entrust.CcsSingleEntrust;
import cms.tmx.trade.message.MessagePromptMng;
import cms.tmx.trade.models.CcsEntrustSplitModel;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IMarketDataMng;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TreeItem;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class PortfolioConvertibleBondTradeModel
implements ITradeModel {
    private static final Logger logger = LogManager.getLogger(PortfolioConvertibleBondTradeModel.class);
    @Inject
    private InstrPortfoDistributionModel distModel;
    @Inject
    public InstructionAccountModel instrAccModel;
    public BooleanProperty normal = new SimpleBooleanProperty(true);
    private StringProperty security = new SimpleStringProperty("");
    private StringProperty name = new SimpleStringProperty("");
    private BooleanProperty buy = new SimpleBooleanProperty(true);
    private DoubleProperty price = new SimpleDoubleProperty();
    private DoubleProperty priceProtected = new SimpleDoubleProperty();
    private LongProperty count = new SimpleLongProperty();
    private ObjectProperty<MxNode> priceStg = new SimpleObjectProperty();
    private ObjectProperty<MxNode> countStg = new SimpleObjectProperty();
    private ObjectProperty<MxNode> distStg = new SimpleObjectProperty();
    private ObjectProperty<MxNode> priceTypeLimitedStg = new SimpleObjectProperty();
    private ObjectProperty<MxNode> priceTypeMktStg = new SimpleObjectProperty();
    private ObjectProperty<MxNode> priceTypeBidAskStg = new SimpleObjectProperty();
    private ObjectProperty<MxNode> priceTypeAfterHours = new SimpleObjectProperty();
    private SimpleBooleanProperty canModify = new SimpleBooleanProperty(false);
    private DoubleProperty countPer = new SimpleDoubleProperty();
    private DoubleProperty money = new SimpleDoubleProperty();
    private boolean autoSlice = false;
    private long sliceSize;
    private ObjectProperty<Instruction> instruction = new SimpleObjectProperty((Object)new Instruction());
    private StringProperty tradeType = new SimpleStringProperty();
    private final int INIT_UNIT = 100;
    private boolean countValid = true;
    private String postil = "";
    @Inject
    private MObjFactory of;
    private MarketItem mktItem;
    @Inject
    private IMarketDataMng mktMng;
    @Inject
    private CcsEntrustFactory ef;
    @Inject
    private CcsEntrustSplitModel entrustSplit;
    @Inject
    private InstructionModel instructionModel;
    public static final int FIRST_SETP_ID = 1;
    @Inject
    private ResourceModel resModel;
    @Inject
    private MessagePromptMng mpMng;
    @Inject
    private PostMngServiceImpl postMng;
    @Inject
    private IBaseApi baseApi;
    private UserPrePortfolioCtrl preModel;
    protected Map<FundAccount, String> insExpiredMap = new HashMap<FundAccount, String>();
    protected Map<FundAccount, AppointedTraderSetting> fundTraderMap = new HashMap<FundAccount, AppointedTraderSetting>();
    private static int PAR_VALUE = 100;

    @PostConstruct
    public void init() {
        this.setTradeType("OIS");
        this.mktItem = this.mktMng.createItem(10);
        this.getAccDisModel().getAllocateModel().normalProperty().bind((ObservableValue)this.normal);
        this.getAccDisModel().buyProperty().bind((ObservableValue)this.buy);
        this.buy.addListener(ob -> this.onBsChange());
        MxNode node = ((MxNode)this.of.create(MxNode.class)).load("trade_count_stg", "1");
        this.countStg.addListener(ob -> this.onCountStgChange());
        this.countStgBuy(node);
        node = ((MxNode)this.of.create(MxNode.class)).load("acc_dist_mode", "2");
        this.distStgInit(node);
        this.distStg.addListener(ob -> this.onDistStgChange());
        this.setDistStg(node);
        node = ((MxNode)this.of.create(MxNode.class)).load("price_type", "50");
        this.initPriceType(node);
        this.setPriceStg(node);
        this.priceStg.addListener(ob -> this.onPriceStgChange());
        node = ((MxNode)this.of.create(MxNode.class)).load("cstr_price_type_limited", "1");
        this.setPriceTypeLimitedStg(node);
        this.limitStgBuy(node);
        node = ((MxNode)this.of.create(MxNode.class)).load("instr_handicap", "-1");
        this.initPriceGear(node);
        this.setPriceTypeBidAskStg(node);
        this.priceTypeBidAskStg.addListener(ob -> this.onPriceStgChange());
        node = ((MxNode)this.of.create(MxNode.class)).load("cstr_price_type_mkt", "0");
        this.initMarketType(node);
        this.setPriceTypeMktStg(node);
        node = ((MxNode)this.of.create(MxNode.class)).load("cstr_price_type_after_hours", "1");
        this.setPriceTypeAfterHours(node);
        this.count.addListener(ob -> this.onCountChange());
        this.price.addListener(ob -> this.onPriceChange());
        this.priceProtected.addListener(ob -> this.onPriceChange());
        this.getAccDisModel().moneyProperty().bind((ObservableValue)this.money);
        this.money.addListener(ob -> this.onMoneyChange());
        this.getAccDisModel().percentProperty().bind((ObservableValue)Bindings.multiply((double)0.01, (ObservableNumberValue)this.countPer));
        this.countPer.addListener(ob -> this.onCountPerChange());
        this.getAccDisModel().changedProperty().addListener(ob -> this.calCountDistribution());
    }

    private MxNode initPriceType(MxNode node) {
        node.addNode("50");
        this.removeOthers(node, "50");
        node.setRaw("50");
        return node;
    }

    public void create(String instructType) {
        this.getAccDisModel().setInstructType(instructType);
        try {
            this.getAccDisModel().create();
        }
        catch (MException e) {
            logger.error(e.getMessage());
        }
    }

    public void onSecChange() {
        this.getAccDisModel().setRepo(this.isReverseRepo());
        this.mktMng.dye(this.mktItem);
        if (!this.mktItem.getStop().getValue().booleanValue()) {
            this.setName(this.mktItem.getRefItem().getName());
        }
        this.filterAcc();
        this.changePriceStg();
        this.changeMarketPriceType();
        this.changeQuantityUnit();
        this.setMktPrice();
        this.setBidAskPrice();
        this.setAfterHoursPrice();
    }

    public final MarketItem getMI() {
        return this.mktItem;
    }

    private void onDistStgChange() {
        this.getAccDisModel().setDistStg(this.getDistStg().getRaw());
        this.calCountDistribution();
    }

    private void onCountStgChange() {
        this.getAccDisModel().setCountStg(this.getCountStg().getRaw());
        if (this.getCountStg().getRaw().equals("5")) {
            if (this.isStar() && this.isMktPrice()) {
                this.setCount(this.getPriceProtected() != 0.0 ? (long)(this.getMoney() / this.getPriceProtected()) / (long)this.getUnit() * (long)this.getUnit() / (long)this.getCvt() : 0L);
            } else {
                this.setCount(this.getPrice() != 0.0 ? (long)(this.getMoney() / this.getPrice()) / (long)this.getUnit() * (long)this.getUnit() / (long)this.getCvt() : 0L);
            }
            return;
        }
        this.calCountDistribution();
    }

    private void onCountChange() {
        if (this.isNormal()) {
            ((PortfolioAccountDistribution)this.getAccDisModel().getRoot().getValue()).setCount(this.getCount());
            if (this.getCount() == 0L) {
                this.getAccDisModel().clearCount(this.getAccDisModel().getRoot());
                return;
            }
            this.calCountDistribution();
            if (!this.getAccDisModel().isActive() && this.getAccDisModel().getInstructType().equals("4")) {
                this.getAccDisModel().getAllocateModel().allocateCount();
            }
        }
    }

    private void onPriceStgChange() {
        this.getAccDisModel().setCountStg(this.getCountStg().getRaw());
        if (this.isMktPrice() && this.isValidRef()) {
            this.setMktPrice();
        } else if (this.isBidAskPrice()) {
            this.setBidAskPrice();
        } else if (this.isAfterHoursPrice()) {
            this.setAfterHoursPrice();
        } else {
            this.setPrice(0.0);
        }
    }

    public void setMktPrice() {
        if (this.isMktPrice() && this.isValidRef()) {
            this.setPrice(this.isBuy() ? this.mktItem.getUpLimitPrice() : this.mktItem.getDownLimitPrice());
        }
        if (this.isStar() && this.isMktPrice()) {
            this.setPrice(this.getPriceProtected());
        }
        if (this.isGemFirst()) {
            this.setPrice(0.0);
        }
    }

    public boolean isGemFirst() {
        if (this.mktItem.getRefItem().getStatus() == null) {
            return false;
        }
        return this.mktItem.getRefItem().getStatus().contains("\u4e0a\u5e02\u521d\u671f") || this.mktItem.getRefItem().getStatus().contains("\u4e0a\u5e02\u9996\u65e5");
    }

    public void setBidAskPrice() {
        if (!this.isBidAskPrice()) {
            return;
        }
        int raw = Integer.parseInt(this.getPriceTypeBidAskStg().getRaw());
        double price = 0.0;
        if (raw > 0) {
            while (price <= 0.0 && raw > 0 && raw <= 10) {
                price = this.mktItem.getBuyPrice(raw - 1);
                --raw;
            }
        }
        if (raw < 0) {
            raw = Math.abs(raw);
            while (price <= 0.0 && raw > 0 && raw <= 10) {
                price = this.mktItem.getSellPrice(raw - 1);
                --raw;
            }
        }
        if (price <= 0.0) {
            price = this.mktItem.getNowPrice() == 0.0 ? this.mktItem.getClosePrice() : this.mktItem.getNowPrice();
        }
        this.setPrice(price);
    }

    private void setAfterHoursPrice() {
        if (!this.isAfterHoursPrice()) {
            return;
        }
        double price = this.mktItem.getNowPrice() == 0.0 ? this.mktItem.getClosePrice() : this.mktItem.getNowPrice();
        this.setPrice(price);
    }

    public void onPriceChange() {
        Platform.runLater(() -> {
            if (this.isNormal()) {
                if (this.isStar() && this.isMktPrice()) {
                    this.getAccDisModel().setPrice(this.getPriceProtected());
                } else {
                    this.getAccDisModel().setPrice(this.getPrice());
                }
                if (this.isCountOrSell()) {
                    this.getAccDisModel().fundCanBuy();
                    this.getAccDisModel().calCanBuySell();
                    return;
                }
                boolean clear = false;
                if (this.isStar() && this.isMktPrice()) {
                    clear = this.getPriceProtected() == 0.0;
                } else {
                    boolean bl = clear = this.getPrice() == 0.0 && !this.isUnlimited();
                }
                if (clear) {
                    this.getAccDisModel().clearCount(this.getAccDisModel().getRoot());
                    this.getAccDisModel().clearCanBuy(this.getAccDisModel().getRoot());
                    return;
                }
                if (this.getCountStg().getRaw().equals("5")) {
                    this.setCount((long)(this.getMoney() / this.getAccDisModel().getPrice()) / (long)this.getUnit() * (long)this.getUnit() / (long)this.getCvt());
                    return;
                }
                this.calCountDistribution();
            }
        });
    }

    private void onMoneyChange() {
        if (this.isStar() && this.isMktPrice()) {
            if (this.getPriceProtected() != 0.0) {
                this.setCount((long)(this.getMoney() / this.getPriceProtected()) / (long)this.getUnit() * (long)this.getUnit() / (long)this.getCvt());
            }
        } else if (this.getPrice() != 0.0) {
            this.setCount((long)(this.getMoney() / this.getPrice()) / (long)this.getUnit() * (long)this.getUnit() / (long)this.getCvt());
        }
    }

    private void onCountPerChange() {
        this.calCountDistribution();
    }

    public void calCountDistribution() {
        if (!this.isValidRef()) {
            this.getAccDisModel().clearAll();
            return;
        }
        if (!this.getAccDisModel().isActive() && !((Instruction)this.instruction.get()).isCanModify()) {
            return;
        }
        Platform.runLater(() -> {
            long total = this.getAccDisModel().allocateCount();
            if (this.setCaledCount()) {
                this.setCount(total);
            }
        });
    }

    public void filterAcc() {
        if (this.getValidRef() != null) {
            this.getAccDisModel().setRefItem(null);
            this.getAccDisModel().clearCanBuySell(this.getAccDisModel().getRoot());
            this.getAccDisModel().filterAcc();
        }
        this.getAccDisModel().setRefItem(this.getValidRef());
        this.getAccDisModel().filterAcc();
    }

    private void changeQuantityUnit() {
        if (this.isValidRef()) {
            this.getAccDisModel().setUnit(this.mktItem.getRefItem().getBuyUnit());
            this.setCvt();
        } else {
            this.getAccDisModel().setUnit(100);
        }
    }

    public BooleanProperty buyProperty() {
        return this.buy;
    }

    public boolean isBuy() {
        return this.buyProperty().get();
    }

    public void setBuy(boolean buy) {
        this.buyProperty().set(buy);
    }

    public ObjectProperty<MxNode> countStgProperty() {
        return this.countStg;
    }

    public MxNode getCountStg() {
        return (MxNode)this.countStgProperty().get();
    }

    public void setCountStg(MxNode countStg) {
        this.countStgProperty().set((Object)countStg);
    }

    public List<TreeItem<PortfolioAccountDistribution>> getSelectedItems(TreeItem<PortfolioAccountDistribution> tree) {
        return tree.getChildren().filtered(ad -> ((PortfolioAccountDistribution)ad.getValue()).isSelected());
    }

    public List<TreeItem<PortfolioAccountDistribution>> getNoZeroItems(TreeItem<PortfolioAccountDistribution> tree) {
        return tree.getChildren().filtered(ad -> ((PortfolioAccountDistribution)ad.getValue()).isSelected() && ((PortfolioAccountDistribution)ad.getValue()).getCount() != 0L);
    }

    public synchronized String submitInstruction() throws MException {
        Result result = new Result();
        for (OrderAdvice ad : this.getOrderAdvice()) {
            try {
                InstructionSubmitResult submitResult = ad.submit();
                ++result.success;
                this.mpMng.regularInst(ad, this.getAccDisModel().getInstructType(), (Object)submitResult.getInstructionId(), submitResult.getReason());
            }
            catch (MException e) {
                ++result.failed;
                this.mpMng.regularInst(ad, this.getAccDisModel().getInstructType(), (Object)e, "");
            }
        }
        return result.getDesc("\u6307\u4ee4");
    }

    public String submitApprove(Instruction instruction) throws MException {
        Result result = new Result();
        Iterator<OrderAdvice> iterator = this.getOrderAdvice().iterator();
        while (iterator.hasNext()) {
            iterator.next();
            try {
                this.instructionModel.approve(instruction, MxDict.WORKFLOW_APPROVE, instruction.getPostil());
                ++result.success;
            }
            catch (MException mException) {
                ++result.failed;
            }
        }
        return result.getDesc("\u5ba1\u6279");
    }

    public String execute(Instruction instruction) throws MException {
        this.instructionModel.execute(instruction, MxDict.WORKFLOW_EXECUTE, instruction.getPostil());
        Result result = new Result();
        ++result.success;
        return result.getDesc("\u4e0b\u5355");
    }

    public synchronized String submitOrder() throws MException {
        Result result = new Result();
        for (CcsSingleEntrust en : this.getEntrustList(true)) {
            try {
                if (this.instruction.get() != null) {
                    en.setInstructionId(((Instruction)this.instruction.get()).getId());
                    if (!((Instruction)this.instruction.get()).getId().isEmpty()) {
                        Resource resource = this.resModel.getResource((Instruction)this.instruction.get());
                        if (resource == null) {
                            ++result.failed;
                            continue;
                        }
                        en.setResourceId(resource.getId());
                        en.setOrdQuantityCapacity(((Instruction)this.instruction.get()).getOrderAdvice().getOrderQty());
                    }
                }
                en.submit();
                ++result.success;
            }
            catch (MException mException) {
                ++result.failed;
            }
        }
        return result.getDesc("\u4e0b\u5355");
    }

    public List<OrderAdvice> getOrderAdvice() throws MException {
        LinkedList<OrderAdvice> adviceList = new LinkedList<OrderAdvice>();
        for (TreeItem<PortfolioAccountDistribution> portfo : this.getSelectedItems(this.getAccDisModel().getRoot())) {
            OrderAdvice orderAdvice = (OrderAdvice)this.of.create(OrderAdvice.class);
            orderAdvice.setMarket(this.mktItem.getRefItem().getMarket());
            orderAdvice.setSecType(this.mktItem.getRefItem().getType());
            orderAdvice.setInstructionType(3);
            orderAdvice.setInstructionPanelType(this.getAccDisModel().getInstructType());
            orderAdvice.setStar(this.isStar());
            orderAdvice.setSide(200);
            if ("50".equals(this.getPriceStg().getRaw())) {
                orderAdvice.setOrdType(50);
                orderAdvice.setPriceLimit(Integer.valueOf(this.getPriceTypeLimitedStg().getRaw()).intValue());
                orderAdvice.setPrice(this.getPrice());
                if ("3".equals(this.getPriceTypeLimitedStg().getRaw()) && this.isValidRef()) {
                    orderAdvice.setPrice(this.mktItem.getNowPrice());
                }
            }
            if (this.isStar()) {
                orderAdvice.setProtectedLimitPrice(this.getPriceProtected());
            }
            orderAdvice.setSec(this.mktItem.getRefItem().getCode());
            orderAdvice.setSecType(this.mktItem.getRefItem().getType());
            orderAdvice.setSecName(this.mktItem.getRefItem().getName());
            orderAdvice.setAppID("130");
            orderAdvice.setPortfolioId(((PortfolioAccountDistribution)portfo.getValue()).getPortfolio().getId());
            orderAdvice.setPortfolioName(((PortfolioAccountDistribution)portfo.getValue()).getPortfolio().getName());
            orderAdvice.setAccntLevel(1);
            List stepList = this.instrAccModel.getWorkflow(((PortfolioAccountDistribution)portfo.getValue()).getPortfolio().getId()).getSteps();
            if (stepList != null && !stepList.isEmpty()) {
                for (AccntStepAttribute step : stepList) {
                    if (1 != step.getStepId()) continue;
                    orderAdvice.setFlowAttriId(step.getFlowAttriId());
                    orderAdvice.setStepAttrId(step.getStepAttriId());
                    break;
                }
            }
            ArrayList<AccntSecInfo> accntSecList = new ArrayList<AccntSecInfo>();
            long orderQty = 0L;
            for (TreeItem<PortfolioAccountDistribution> acc : this.getSelectedItems(portfo)) {
                if (((PortfolioAccountDistribution)acc.getValue()).getAcc() instanceof CcsSubFundAccount) {
                    AppointedTraderSetting traderSetting;
                    CcsSubFundAccount subFundAcc = (CcsSubFundAccount)CcsSubFundAccount.class.cast(((PortfolioAccountDistribution)acc.getValue()).getAcc());
                    if (StringUtils.isEmpty((String)orderAdvice.getInsExpiredDate())) {
                        orderAdvice.setInsExpiredDate(this.insExpiredMap.get(subFundAcc));
                    }
                    if ((traderSetting = this.fundTraderMap.get(subFundAcc)) != null) {
                        orderAdvice.setTraderUserIds(traderSetting.getAppointedTraderIds());
                    }
                    for (TreeItem<PortfolioAccountDistribution> secAcc : this.getNoZeroItems(acc)) {
                        if (((PortfolioAccountDistribution)secAcc.getValue()).getSecAcc() instanceof CcsSubSecAccount) {
                            AccntSecInfo accntSec = new AccntSecInfo();
                            accntSec.setAccntId(subFundAcc.getSubAccntId());
                            accntSec.setInvestorId(subFundAcc.getInvestId());
                            accntSec.setParentId(subFundAcc.getParentId());
                            accntSec.setSubParentId(subFundAcc.getParentSubAccntId());
                            CcsSubSecAccount subSecAcc = (CcsSubSecAccount)CcsSubSecAccount.class.cast(((PortfolioAccountDistribution)secAcc.getValue()).getSecAcc());
                            accntSec.setSecAccntId(subSecAcc.getSubSecAccntId());
                            accntSec.setOrderQty(((PortfolioAccountDistribution)secAcc.getValue()).getCount());
                            orderQty += ((PortfolioAccountDistribution)secAcc.getValue()).getCount();
                            accntSec.setMarket(subSecAcc.getExchange().getRaw());
                            accntSecList.add(accntSec);
                            continue;
                        }
                        throw new MException(1, "\u8bc1\u5238\u8d26\u53f7\u9519\u8bef");
                    }
                    continue;
                }
                throw new MException(1, "\u8d44\u91d1\u8d26\u53f7\u9519\u8bef");
            }
            if (accntSecList.isEmpty()) continue;
            orderAdvice.setOrderQty(orderQty);
            orderAdvice.setAccSecInfoList(accntSecList);
            orderAdvice.setPostil(this.getPostil());
            orderAdvice.setAmount(this.getMoney(orderAdvice));
            adviceList.add(orderAdvice);
        }
        return adviceList;
    }

    private int getParValue(OrderAdvice item) {
        return item.getMarket().equals("XSHG") ? 10 * PAR_VALUE : PAR_VALUE;
    }

    private double getMoney(OrderAdvice item) {
        switch (item.getSide()) {
            case 70: 
            case 71: {
                return item.getOrderQty() * (long)this.getParValue(item);
            }
        }
        if ("XSHG".equals(item.getMarket()) && "BOND".equals(item.getSecType())) {
            return (double)item.getOrderQty() * item.getPrice() * 10.0;
        }
        if (this.isStar() && "49".equals(((MxNode)this.priceStg.getValue()).getRaw())) {
            return (double)item.getOrderQty() * item.getProtectedLimitPrice();
        }
        return (double)item.getOrderQty() * item.getPrice();
    }

    public List<CcsSingleEntrust> getEntrustList(boolean isOrder) throws MException {
        LinkedList<CcsSingleEntrust> enList = new LinkedList<CcsSingleEntrust>();
        for (TreeItem<PortfolioAccountDistribution> portfo : this.getSelectedItems(this.getAccDisModel().getRoot())) {
            for (TreeItem<PortfolioAccountDistribution> acc : this.getSelectedItems(portfo)) {
                for (TreeItem<PortfolioAccountDistribution> secAcc : this.getNoZeroItems(acc)) {
                    CcsSingleEntrust en;
                    block38: {
                        block40: {
                            block39: {
                                block37: {
                                    String fundAccId = ((PortfolioAccountDistribution)acc.getValue()).getAcc().getExtAccntId();
                                    String secAccId = ((PortfolioAccountDistribution)secAcc.getValue()).getSecAcc().getExtSecAccntId();
                                    en = this.createEntrust(fundAccId, secAccId);
                                    en.setSide(49);
                                    en.setFundAccount((FundAccount)((PortfolioAccountDistribution)acc.getValue()).getAcc());
                                    en.setSecAccount(((PortfolioAccountDistribution)secAcc.getValue()).getSecAcc());
                                    en.setInvestorId(((PortfolioAccountDistribution)acc.getValue()).getAcc().getInvestId());
                                    en.setInvestorSecId(((PortfolioAccountDistribution)secAcc.getValue()).getSecAcc().getInverstorSecId());
                                    en.setQuantity(((PortfolioAccountDistribution)secAcc.getValue()).getCount());
                                    en.setMarket(this.mktItem.getRefItem().getMarket());
                                    en.setSecType(this.mktItem.getRefItem().getType());
                                    en.setCanSell(((PortfolioAccountDistribution)secAcc.getValue()).getCanSell());
                                    en.setPrice(this.getPrice());
                                    en.setAppID(this.isReverseRepo() ? "110" : "010");
                                    if (!"50".equals(this.getPriceStg().getRaw())) break block37;
                                    en.setOrderType(50);
                                    en.setPrice(this.getPrice());
                                    if (0.0 == this.getPrice() && "3".equals(this.getPriceTypeLimitedStg().getRaw()) && this.isValidRef()) {
                                        en.setPrice(this.mktItem.getNowPrice());
                                    }
                                    break block38;
                                }
                                if (!"0".equals(this.getPriceStg().getRaw())) break block39;
                                en.setOrderType(0);
                                en.setPrice(this.getPrice());
                                break block38;
                            }
                            if (!"99".equals(this.getPriceStg().getRaw())) break block40;
                            en.setOrderType(99);
                            en.setPrice(this.getPrice());
                            break block38;
                        }
                        en.setOrderType(49);
                        switch (this.getPriceTypeMktStg().getRaw()) {
                            case "SH1": {
                                en.setMaxLevels(5);
                                en.setTif(48);
                                break;
                            }
                            case "SH2": {
                                en.setTif(51);
                                en.setMaxLevels(5);
                                break;
                            }
                            case "SH3": {
                                en.setMaxLevels(1);
                                en.setTif(48);
                                break;
                            }
                            case "SH4": {
                                en.setMaxLevels(0);
                                en.setTif(48);
                                break;
                            }
                            case "SZ1": {
                                en.setTif(48);
                                en.setMaxLevels(1);
                                break;
                            }
                            case "SZ2": {
                                en.setTif(48);
                                en.setMaxLevels(0);
                                break;
                            }
                            case "SZ3": {
                                en.setTif(51);
                                en.setMaxLevels(0);
                                break;
                            }
                            case "SZ4": {
                                en.setTif(51);
                                en.setMaxLevels(5);
                                break;
                            }
                            case "SZ5": {
                                en.setTif(52);
                                en.setMaxLevels(0);
                                break;
                            }
                        }
                    }
                    en.setAppID("130");
                    en.setSec(this.mktItem.getRefItem().getCode());
                    en.setSecName(this.mktItem.getRefItem().getName());
                    if (!(((PortfolioAccountDistribution)acc.getValue()).getAcc() instanceof CcsSubFundAccount) || !(((PortfolioAccountDistribution)secAcc.getValue()).getSecAcc() instanceof CcsSubSecAccount)) {
                        throw new MException(1, "\u8d26\u53f7\u9519\u8bef");
                    }
                    CcsSubFundAccount subFundAcc = (CcsSubFundAccount)CcsSubFundAccount.class.cast(((PortfolioAccountDistribution)acc.getValue()).getAcc());
                    CcsSubSecAccount subSecAcc = (CcsSubSecAccount)CcsSubSecAccount.class.cast(((PortfolioAccountDistribution)secAcc.getValue()).getSecAcc());
                    en.setPortfolioId(((PortfolioAccountDistribution)portfo.getValue()).getPortfolio().getId());
                    en.setPortfolioName(((PortfolioAccountDistribution)portfo.getValue()).getPortfolio().getName());
                    en.setSubAccntId(subFundAcc.getSubAccntId());
                    en.setSubSecAccntId(subSecAcc.getSubSecAccntId());
                    if (this.isAutoSlice()) {
                        this.entrustSplit.setRefItem(this.getValidRef());
                        List splitList = this.entrustSplit.split(en, this.getSliceSize());
                        enList.addAll(splitList);
                        continue;
                    }
                    enList.add(en);
                }
            }
        }
        return enList;
    }

    public void getSelectedSecAcc() {
    }

    public final ObjectProperty<MxNode> distStgProperty() {
        return this.distStg;
    }

    public final MxNode getDistStg() {
        return (MxNode)this.distStgProperty().get();
    }

    public final void setDistStg(MxNode distStg) {
        this.distStgProperty().set((Object)distStg);
    }

    public String getDirection() {
        return this.isBuy() ? "\u4e70\u5165" : "\u5356\u51fa";
    }

    public boolean isLimitPrice() {
        if (this.getPriceStg() == null) {
            return false;
        }
        return this.getPriceStg().is("50");
    }

    public boolean isUnlimited() {
        if (this.getPriceTypeLimitedStg() == null || !this.isLimitPrice()) {
            return false;
        }
        return this.getPriceTypeLimitedStg().is("3");
    }

    public boolean isSpecify() {
        if (this.getPriceTypeLimitedStg() == null || !this.isLimitPrice()) {
            return false;
        }
        return this.getPriceTypeLimitedStg().is("2");
    }

    public boolean isAfterHours() {
        if (this.getPriceStg() == null) {
            return false;
        }
        return this.getPriceStg().is("99");
    }

    public boolean isUpLimit() {
        if (this.getPriceTypeLimitedStg() == null || !this.isLimitPrice()) {
            return false;
        }
        return this.getPriceTypeLimitedStg().is("1");
    }

    public boolean isDownLimit() {
        if (this.getPriceTypeLimitedStg() == null || !this.isLimitPrice()) {
            return false;
        }
        return this.getPriceTypeLimitedStg().is("4");
    }

    public boolean isMktPrice() {
        if (this.getPriceStg() == null) {
            return false;
        }
        return this.getPriceStg().is("49");
    }

    public boolean isBidAskPrice() {
        if (this.getPriceStg() == null) {
            return false;
        }
        return this.getPriceStg().is("0");
    }

    public final StringProperty tradeTypeProperty() {
        return this.tradeType;
    }

    public final String getTradeType() {
        return (String)this.tradeTypeProperty().get();
    }

    public final void setTradeType(String tradeType) {
        this.tradeTypeProperty().set((Object)tradeType);
    }

    private void changeMarketPriceType() {
        MxNode node = this.getPriceTypeMktStg();
        if (node == null) {
            return;
        }
        if (this.mktItem.getRefItem().getMarket().equals("XSHG")) {
            this.shMarket(node);
        } else if (this.mktItem.getRefItem().getMarket().equals("XSHE")) {
            this.szMarket(node);
        } else {
            this.initMarketType(node);
        }
    }

    private void changePriceStg() {
        MxNode node = this.getPriceStg();
        if (node == null) {
            return;
        }
        String old = node.getRaw();
        if (this.isBond() && this.isMktPrice()) {
            node.removeOthers("50");
            node.addNode("0");
            node.setRaw("50");
        } else if (this.isBond()) {
            node.removeNode("49");
            node.removeNode("99");
            if (old.equals("49") || old.equals("99")) {
                node.setRaw("50");
            }
        } else {
            this.getPriceStg().addNode("49");
            if (!this.isStar() && !this.isGem()) {
                node.removeNode("99");
                if (old.equals("99")) {
                    node.setRaw("50");
                }
            } else {
                node.addNode("99");
            }
        }
        this.setPriceStg(node);
    }

    private MxNode initMarketType(MxNode node) {
        node.addNode("0");
        this.removeOthers(node, "0");
        node.setRaw("0");
        this.setPriceTypeMktStg(node);
        return node;
    }

    private MxNode shMarket(MxNode node) {
        node.addNode("0");
        this.removeOthers(node, "0");
        node.addNode("SH1");
        node.addNode("SH2");
        if (this.isStar()) {
            node.addNode("SH3");
            node.addNode("SH4");
        }
        node.removeNode("0");
        node.setRaw("SH1");
        this.setPriceTypeMktStg(node);
        return node;
    }

    private MxNode szMarket(MxNode node) {
        node.addNode("0");
        this.removeOthers(node, "0");
        node.addNode("SZ1");
        node.addNode("SZ2");
        node.addNode("SZ3");
        node.addNode("SZ4");
        node.addNode("SZ5");
        node.removeNode("0");
        node.setRaw("SZ1");
        this.setPriceTypeMktStg(node);
        return node;
    }

    public boolean isAfterHoursPrice() {
        if (this.getPriceStg() == null) {
            return false;
        }
        return this.getPriceStg().is("99");
    }

    private void countStgBuy(MxNode node) {
        if (node == null) {
            return;
        }
        String oldNodeRaw = node.getRaw();
        this.removeOthers(node, "1");
        node.addNode("3");
        node.addNode("5");
        node.addNode("2");
        node.setRaw(oldNodeRaw.equals("4") ? "3" : oldNodeRaw);
        this.setCountStg(node);
    }

    private void countStgSell(MxNode node) {
        if (node == null) {
            return;
        }
        String oldNodeRaw = node.getRaw();
        this.removeOthers(node, "1");
        node.addNode("4");
        node.addNode("5");
        node.addNode("2");
        node.setRaw(oldNodeRaw.equals("3") ? "4" : oldNodeRaw);
        this.setCountStg(node);
    }

    private void limitStgBuy(MxNode node) {
        if (node == null) {
            return;
        }
        node.getRaw();
        this.removeOthers(node, "2");
        this.setPriceTypeLimitedStg(node);
    }

    private void limitStgSell(MxNode node) {
        if (node == null) {
            return;
        }
        String oldNodeRaw = node.getRaw();
        this.removeOthers(node, "2");
        node.addNode("4");
        node.addNode("3");
        node.setRaw(oldNodeRaw.equals("1") ? "4" : oldNodeRaw);
        this.setPriceTypeLimitedStg(node);
    }

    private void distStgInit(MxNode node) {
        if (node == null) {
            return;
        }
        if (node.getRaw().equals("3")) {
            this.removeOthers(node, "2");
        } else {
            this.removeOthers(node, "2");
        }
    }

    public boolean isStar() {
        return this.mktItem.isValidRef() && this.mktItem.getRefItem().getCode().startsWith("688");
    }

    public boolean isGem() {
        return this.mktItem.isValidRef() && this.mktItem.getRefItem().isGem();
    }

    protected void distStgSell(MxNode node) {
        node.addNode("3");
    }

    public DoubleProperty countPerProperty() {
        return this.countPer;
    }

    public double getCountPer() {
        return this.countPerProperty().get();
    }

    public void setCountPer(double countPer) {
        this.countPerProperty().set(countPer);
    }

    public DoubleProperty moneyProperty() {
        return this.money;
    }

    public double getMoney() {
        return this.moneyProperty().get();
    }

    public void setMoney(double money) {
        this.moneyProperty().set(money);
    }

    public boolean isValidRef() {
        if (this.mktItem.getRefItem() == null) {
            return false;
        }
        if (this.mktItem.getRefItem().getType().isEmpty()) {
            return false;
        }
        if (this.getTradeType().equals("CCS")) {
            return true;
        }
        return this.mktItem.getRefItem().getType().equals(this.getTradeType());
    }

    public RefItem getValidRef() {
        RefItem item = this.mktItem.getRefItem();
        if (item == null || item.getType().isEmpty()) {
            return null;
        }
        if (this.getTradeType().equals("OIS")) {
            return item;
        }
        if (item.getType().equals(this.getTradeType())) {
            return item;
        }
        return null;
    }

    private int getUnit() {
        return this.getAccDisModel().getUnit();
    }

    private int getCvt() {
        return this.getAccDisModel().getUnitConvert();
    }

    private void setCvt() {
        this.getAccDisModel().setUnitConvert(this.isSHbond() ? 10 : 1);
    }

    public boolean isSHbond() {
        if (!this.isValidRef()) {
            return false;
        }
        return this.isBond() && this.mktItem.getRefItem().getMarket().equals("XSHG");
    }

    public boolean isBond() {
        if (!this.isValidRef()) {
            return false;
        }
        return this.getValidRef().getType().equals("OIS") || this.getValidRef().getType().equals("BOND") || this.getValidRef().getType().equals("REPO");
    }

    public boolean isReverseRepo() {
        if (!this.isValidRef()) {
            return false;
        }
        return this.getValidRef().getType().equals("REPO");
    }

    public boolean isStock() {
        if (!this.isValidRef()) {
            return false;
        }
        return this.getValidRef().getType().equals("STOCK");
    }

    public boolean isFund() {
        if (!this.isValidRef()) {
            return false;
        }
        return this.getValidRef().getType().equals("FUND");
    }

    private boolean setCaledCount() {
        return this.getCountStg().getRaw().equals("4") || this.getCountStg().getRaw().equals("3") || this.getCountStg().getRaw().equals("2");
    }

    protected boolean isCountOrSell() {
        return this.getCountStg().getRaw().equals("4") || this.getCountStg().getRaw().equals("1");
    }

    private void onBsChange() {
        if (this.isBuy()) {
            this.countStgBuy(this.getCountStg());
            this.limitStgBuy(this.getPriceTypeLimitedStg());
            this.distStgInit(this.getDistStg());
        } else {
            this.countStgSell(this.getCountStg());
            this.limitStgSell(this.getPriceTypeLimitedStg());
            this.distStgSell(this.getDistStg());
        }
        if (this.isMktPrice() && this.isValidRef()) {
            this.setPrice(this.isBuy() ? this.mktItem.getUpLimitPrice() : this.mktItem.getDownLimitPrice());
        }
        if (this.isStar() && this.isMktPrice()) {
            this.setPrice(this.getPriceProtected());
        }
        this.filterAcc();
    }

    public void removeOthers(MxNode rowNode, String raw) {
        rowNode.addNode(raw);
        Iterator it = rowNode.getNodes().iterator();
        while (it.hasNext()) {
            MxNode node = (MxNode)it.next();
            if (node.getRaw().equals(raw)) continue;
            it.remove();
        }
    }

    public CcsSingleEntrust createEntrust(String acc, String secAcc) {
        return this.ef.createCcsSingle(acc, secAcc);
    }

    public InstrPortfoDistributionModel getAccDisModel() {
        return this.distModel;
    }

    public final StringProperty securityProperty() {
        return this.security;
    }

    public final String getSecurity() {
        return (String)this.securityProperty().get();
    }

    public final void setSecurity(String security) {
        this.securityProperty().set((Object)security);
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    public final String getName() {
        return (String)this.nameProperty().get();
    }

    public final void setName(String name) {
        this.nameProperty().set((Object)name);
    }

    public DoubleProperty priceProperty() {
        return this.price;
    }

    public double getPrice() {
        return this.priceProperty().get();
    }

    public void setPrice(double price) {
        this.priceProperty().set(price);
    }

    public ObjectProperty<MxNode> priceStgProperty() {
        return this.priceStg;
    }

    public MxNode getPriceStg() {
        return (MxNode)this.priceStgProperty().get();
    }

    public void setPriceStg(MxNode priceStg) {
        this.priceStgProperty().set((Object)priceStg);
    }

    public LongProperty countProperty() {
        return this.count;
    }

    public long getCount() {
        return this.countProperty().get();
    }

    public void setCount(long count) {
        this.countProperty().set(count);
    }

    public boolean isAutoSlice() {
        return this.autoSlice;
    }

    public void setAutoSlice(boolean autoSlice) {
        this.autoSlice = autoSlice;
    }

    public long getSliceSize() {
        return this.sliceSize;
    }

    public void setSliceSize(long sliceSize) {
        this.sliceSize = sliceSize;
    }

    public void setPstAcct(String portfId, String AccId, String secAcc, String mkt) {
        this.getAccDisModel().clearSelect();
        this.getAccDisModel().selectSecAcc(portfId, AccId, secAcc, mkt);
    }

    public void setPresetPstAcct(String portfId, String AccId, String secAcc, String mkt) {
        this.getAccDisModel().selectSecAcc(portfId, AccId, secAcc, mkt);
    }

    public void clearCount(TreeItem<PortfolioAccountDistribution> parent) {
        parent.getChildren().forEach(each -> {
            ((PortfolioAccountDistribution)each.getValue()).setCount(0L);
            for (TreeItem sub : each.getChildren()) {
                if (sub == null) continue;
                ((PortfolioAccountDistribution)sub.getValue()).setCount(0L);
            }
        });
    }

    public Boolean isCountValid() {
        return this.countValid;
    }

    public boolean SelectedNumValid() {
        for (TreeItem item : this.getAccDisModel().getRoot().getChildren().filtered(ad -> ((PortfolioAccountDistribution)ad.getValue()).isSelected())) {
            for (TreeItem subItem : item.getChildren().filtered(pd -> ((PortfolioAccountDistribution)pd.getValue()).isSelected())) {
                for (TreeItem secItem : subItem.getChildren()) {
                    if (!((PortfolioAccountDistribution)secItem.getValue()).isSelected()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public List<PortfolioAccountDistribution> validSecAcc() {
        LinkedList<PortfolioAccountDistribution> list = new LinkedList<PortfolioAccountDistribution>();
        int totalcount = 0;
        this.countValid = true;
        for (TreeItem portfo : this.getAccDisModel().getRoot().getChildren().filtered(ad -> ((PortfolioAccountDistribution)ad.getValue()).isSelected())) {
            for (TreeItem acc : portfo.getChildren().filtered(ad -> ((PortfolioAccountDistribution)ad.getValue()).isSelected())) {
                for (TreeItem sec : acc.getChildren().filtered(ad -> ((PortfolioAccountDistribution)ad.getValue()).isSelected())) {
                    if (((PortfolioAccountDistribution)sec.getValue()).getCount() == 0L) continue;
                    list.add((PortfolioAccountDistribution)sec.getValue());
                    totalcount = (int)((long)totalcount + ((PortfolioAccountDistribution)sec.getValue()).getCount());
                }
            }
        }
        if (totalcount == 0) {
            this.countValid = false;
        }
        return list;
    }

    public ObjectProperty<MxNode> priceTypeLimitedStgProperty() {
        return this.priceTypeLimitedStg;
    }

    public MxNode getPriceTypeLimitedStg() {
        return (MxNode)this.priceTypeLimitedStgProperty().get();
    }

    public void setPriceTypeLimitedStg(MxNode priceTypeLimitedStg) {
        this.priceTypeLimitedStgProperty().set((Object)priceTypeLimitedStg);
    }

    public ObjectProperty<MxNode> priceTypeMktStgProperty() {
        return this.priceTypeMktStg;
    }

    public MxNode getPriceTypeMktStg() {
        return (MxNode)this.priceTypeMktStgProperty().get();
    }

    public void setPriceTypeMktStg(MxNode priceTypeMktStg) {
        this.priceTypeMktStgProperty().set((Object)priceTypeMktStg);
    }

    public ObjectProperty<MxNode> priceTypeBidAskStgProperty() {
        return this.priceTypeBidAskStg;
    }

    public MxNode getPriceTypeBidAskStg() {
        return (MxNode)this.priceTypeBidAskStgProperty().get();
    }

    public void setPriceTypeBidAskStg(MxNode priceTypeBidAskStg) {
        this.priceTypeBidAskStgProperty().set((Object)priceTypeBidAskStg);
    }

    private void initPriceGear(MxNode node) {
        this.removeOthers(node, "-10");
        node.addNode("-9");
        node.addNode("-8");
        node.addNode("-7");
        node.addNode("-6");
        node.addNode("-5");
        node.addNode("-4");
        node.addNode("-3");
        node.addNode("-2");
        node.addNode("-1");
        node.addNode("0");
        node.addNode("1");
        node.addNode("2");
        node.addNode("3");
        node.addNode("4");
        node.addNode("5");
        node.addNode("6");
        node.addNode("7");
        node.addNode("8");
        node.addNode("9");
        node.addNode("10");
    }

    public final BooleanProperty normalProperty() {
        return this.normal;
    }

    public final boolean isNormal() {
        return this.normalProperty().get();
    }

    public final void setNormal(boolean normal) {
        this.normalProperty().set(normal);
    }

    public ObjectProperty<Instruction> instructionProperty() {
        return this.instruction;
    }

    public Instruction getInstruction() {
        return (Instruction)this.instructionProperty().get();
    }

    public void setInstruction(Instruction instruction) {
        this.instructionProperty().set((Object)instruction);
    }

    public final SimpleBooleanProperty canModifyProperty() {
        return this.canModify;
    }

    public final boolean isCanModify() {
        return this.canModifyProperty().get();
    }

    public final void setCanModify(boolean canModify) {
        this.canModifyProperty().set(canModify);
    }

    public InstructionModel getInstructionModel() {
        return this.instructionModel;
    }

    public void setPreModel(UserPrePortfolioCtrl preModel) {
        this.preModel = preModel;
    }

    public ObjectProperty<MxNode> priceTypeAfterHoursProperty() {
        return this.priceTypeAfterHours;
    }

    public MxNode getPriceTypeAfterHours() {
        return (MxNode)this.priceTypeAfterHoursProperty().get();
    }

    public void setPriceTypeAfterHours(MxNode priceTypeAfterHours) {
        this.priceTypeAfterHoursProperty().set((Object)priceTypeAfterHours);
    }

    public DoubleProperty priceProtectedProperty() {
        return this.priceProtected;
    }

    public double getPriceProtected() {
        return this.priceProtectedProperty().get();
    }

    public void setPriceProtected(double priceProtected) {
        this.priceProtectedProperty().set(priceProtected);
    }

    public void setPostil(String postil) {
        this.postil = postil;
    }

    public String getPostil() {
        return this.postil;
    }

    public Map<FundAccount, String> getInsExpiredMap() {
        return this.insExpiredMap;
    }

    public void setInsExpiredMap(Map<FundAccount, String> insExpiredMap) {
        this.insExpiredMap = insExpiredMap;
    }

    public Map<FundAccount, AppointedTraderSetting> getFundTraderMap() {
        return this.fundTraderMap;
    }

    public void setFundTraderMap(Map<FundAccount, AppointedTraderSetting> fundTraderMap) {
        this.fundTraderMap = fundTraderMap;
    }

    public WorkFlowDescriptor getWorkFlowByPortfolioId(String portfolioId) {
        return this.instrAccModel.getWorkflow(portfolioId);
    }

    public AppointedTraderSetting buildTraderSetting(WorkFlowDescriptor workFlow) {
        AppointedTraderSetting traderSettings = new AppointedTraderSetting();
        List postIds = ((AccntStepAttribute)workFlow.getSteps().get(workFlow.getSteps().size() - 1)).getObjIds();
        if (postIds == null || postIds.isEmpty()) {
            return traderSettings;
        }
        List users = null;
        try {
            users = this.postMng.getUserList(postIds, this.baseApi.getPartyId(), true);
        }
        catch (MException e) {
            logger.error("\u6839\u636e\u804c\u4f4did\uff0c\u67e5\u8be2\u5176\u6240\u6709\u7528\u6237\u51fa\u9519\uff1a", (Throwable)e);
        }
        if (users == null || users.isEmpty()) {
            return traderSettings;
        }
        traderSettings.setUsers(users);
        for (User user : users) {
            traderSettings.getAppointedTraderIds().add(user.getId());
        }
        return traderSettings;
    }

    public class Result {
        int success;
        int failed;

        public String getDesc(String type) {
            return String.valueOf(type) + "\u63d0\u4ea4\u6210\u529f" + this.success + "\u7b14" + " " + "\u5931\u8d25" + this.failed + "\u7b14";
        }
    }
}

