/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.portfolio.models;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.CcsSubFundAccount;
import cms.tmx.entity.Portfolio;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.trade.CcsPortfPosition;
import cms.tmx.entity.trade.basket.BasketItem;
import cms.tmx.entity.trade.basket.BasketSubmitResult;
import cms.tmx.entity.trade.basket.BasketTradeItem;
import cms.tmx.portfolio.models.PortfolioBasketAccSetModel;
import cms.tmx.portfolio.models.PortfolioBasketInfo;
import cms.tmx.query.current.models.CcsPortfPositionModel;
import cms.tmx.query.current.models.PortfolioAccountModel;
import cms.tmx.query.current.models.PositionModel;
import cms.tmx.trade.models.basket.BasketTradeModel;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class PortfolioBasketTradeModel
extends BasketTradeModel {
    @Inject
    private CcsPortfPositionModel posModel;
    @Inject
    private PortfolioAccountModel portfAccntModel;
    @Inject
    private PortfolioBasketInfo portfolioInfo;
    @Inject
    private PortfolioBasketAccSetModel portfolioBsktAccModel;
    @Inject
    protected MEventService es;

    @PostConstruct
    public void init() {
        this.setBi(this.portfolioInfo);
        super.init();
    }

    public void addAccSecs(CcsFundAccount acc) {
        if (!(acc instanceof CcsSubFundAccount)) {
            return;
        }
        CcsSubFundAccount subAcc = (CcsSubFundAccount)CcsSubFundAccount.class.cast(acc);
        LinkedList<BasketTradeItem> listTmp = new LinkedList<BasketTradeItem>();
        if (this.getBi().getItemShowList() == null) {
            return;
        }
        if (this.getMapItem().get(acc) != null && !((ObservableList)this.getMapItem().get(acc)).isEmpty()) {
            return;
        }
        for (BasketItem info : this.getBi().getItemShowList()) {
            if (info.getRefItem() == null) continue;
            BasketTradeItem item = this.bskTradeItemFactory.create();
            item.setAcc(acc);
            ObservableList secList = null;
            List<SecAccount> selectList = this.getPortfolioBsktAccModel().getSelectedMap().get(acc);
            if (this.getPortfolioBsktAccModel().getSelectedMap() != null && selectList != null) {
                secList = FXCollections.observableList(selectList);
            }
            if (secList == null) {
                if (this.getPortfolioBsktAccModel().getSelectedPortfolioList().isEmpty()) {
                    CcsSubFundAccount subFundAcc = (CcsSubFundAccount)CcsSubFundAccount.class.cast(acc);
                    Map map = this.portfAccntModel.getMap(subFundAcc.getPortfolioId());
                    secList = FXCollections.observableList((List)((List)map.get(subFundAcc)));
                } else {
                    boolean newPortfolio = true;
                    for (Portfolio portfolio : this.getPortfolioBsktAccModel().getSelectedPortfolioList()) {
                        if (!portfolio.getId().equals(subAcc.getPortfolioId())) continue;
                        newPortfolio = false;
                        break;
                    }
                    if (newPortfolio) {
                        CcsSubFundAccount subFundAcc = (CcsSubFundAccount)CcsSubFundAccount.class.cast(acc);
                        Map map = this.portfAccntModel.getMap(subFundAcc.getPortfolioId());
                        secList = FXCollections.observableList((List)((List)map.get(subFundAcc)));
                    }
                }
            }
            if (secList != null && !secList.isEmpty()) {
                FilteredList validSecs = secList.filtered(fd -> fd.getExchange().getRaw().equals(info.getMarket().getRaw()));
                if (validSecs.isEmpty()) continue;
                item.setSecAcc((SecAccount)validSecs.get(0));
            }
            item.setItem(info);
            item.getBsTrade().setRaw(this.isBuyItem(item) ? "49" : "50");
            if (item.getSecAcc() != null) {
                listTmp.add(item);
            }
            this.checkItemDisable(item);
            item.selectedProperty().addListener(ob -> this.calSecs());
        }
        this.getItems().addAll(listTmp);
        this.getMapItem().put(acc, FXCollections.observableList(listTmp));
        this.calSecs();
    }

    private void addAcc(CcsFundAccount subAccnt) {
        if (!this.getAccList().contains((Object)subAccnt)) {
            this.getAccList().add((Object)subAccnt);
        }
    }

    public void removeAccSecs(CcsFundAccount acc) {
        List accItemList = (List)this.getMapItem().get(acc);
        if (accItemList != null) {
            this.getItems().removeAll((Collection)accItemList);
            this.getMapItem().remove(acc);
        }
    }

    public PositionModel<CcsPortfPosition> getPostModel() {
        return this.posModel;
    }

    public void onPortfolioChange(ListChangeListener.Change<? extends Portfolio> change) {
        while (change.next()) {
            if (change.wasAdded()) {
                change.getAddedSubList().forEach(each -> {
                    if (this.getPortfolioBsktAccModel().getSelectedPortfolioList().isEmpty()) {
                        Map accntMap = this.portfAccntModel.getMap(each);
                        boolean first = true;
                        for (CcsFundAccount accnt : accntMap.keySet()) {
                            if (!first) continue;
                            this.addAcc(accnt);
                            this.addAccSecs(accnt);
                            first = false;
                        }
                    } else {
                        boolean newPortfolio = true;
                        for (Portfolio portfolio : this.getPortfolioBsktAccModel().getSelectedPortfolioList()) {
                            if (!portfolio.getId().equals(each.getId())) continue;
                            newPortfolio = false;
                            break;
                        }
                        if (newPortfolio) {
                            Map accntMap = this.portfAccntModel.getMap(each);
                            boolean first = true;
                            for (CcsFundAccount accnt : accntMap.keySet()) {
                                if (!first) continue;
                                this.addAcc(accnt);
                                this.addAccSecs(accnt);
                                first = false;
                            }
                        } else {
                            this.getPortfolioBsktAccModel().getSelectedMap().keySet().forEach(subAccnt -> {
                                CcsSubFundAccount subAcc;
                                if (subAccnt instanceof CcsSubFundAccount && (subAcc = (CcsSubFundAccount)CcsSubFundAccount.class.cast(subAccnt)).getPortfolioId().equals(each.getId())) {
                                    this.addAcc((CcsFundAccount)subAccnt);
                                    this.addAccSecs((CcsFundAccount)subAccnt);
                                }
                            });
                        }
                    }
                });
            }
            if (!change.wasRemoved()) continue;
            change.getRemoved().forEach(each -> {
                Map accntMap = this.portfAccntModel.getMap(each);
                accntMap.keySet().forEach(subFundAccnt -> {
                    this.getAccList().remove(subFundAccnt);
                    this.removeAccSecs((CcsFundAccount)subFundAccnt);
                });
            });
        }
    }

    public void entrust() throws MException {
        BasketSubmitResult result = this.getBatchEntrust().submit(null, (List)this.getEntrustList(), this.getBi().getBasket(), "");
        for (String id : result.getSuccessedIds()) {
            MEvent event = new MEvent();
            event.put((Object)"listId", (Object)id);
            event.put((Object)"isPortfolio", (Object)true);
            this.es.postEvent("basket.submit", event);
        }
        throw new MException(0, "\u7bee\u5b50\u63d0\u4ea4\u6210\u529f");
    }

    public PortfolioBasketAccSetModel getPortfolioBsktAccModel() {
        return this.portfolioBsktAccModel;
    }

    public void setPortfolioBsktAccModel(PortfolioBasketAccSetModel portfolioBsktAccModel) {
        this.portfolioBsktAccModel = portfolioBsktAccModel;
    }
}

