/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.portfolio.models;

import cms.tmx.core.MException;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.Portfolio;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.trade.PortfolioAccountDistribution;
import cms.tmx.javafx.MxTreeList;
import cms.tmx.portfolio.models.PortfolioBasketDistributionModel;
import cms.tmx.portfolio.models.PortfolioDistributionModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javafx.scene.control.TreeItem;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Singleton
@Creatable
public class PortfolioBasketAccSetModel {
    @Inject
    private PortfolioBasketDistributionModel portfDistModel;
    private Map<CcsFundAccount, List<SecAccount>> selectedMap = new HashMap<CcsFundAccount, List<SecAccount>>();
    private List<Portfolio> portfolioList = new ArrayList<Portfolio>();
    private List<Portfolio> selectedPortfolioList = new ArrayList<Portfolio>();
    protected TreeItem<PortfolioAccountDistribution> root = new TreeItem((Object)new PortfolioAccountDistribution());
    protected MxTreeList<PortfolioAccountDistribution> accMxList;
    protected Map<String, MxTreeList<PortfolioAccountDistribution>> mapSecDisMxList;
    private static final Logger logger = LogManager.getLogger(PortfolioBasketAccSetModel.class);
    private final int MAP_CAP = 100;
    private Map<CcsFundAccount, List<SecAccount>> mapAccount = new HashMap<CcsFundAccount, List<SecAccount>>(100);

    @PostConstruct
    private void init() {
        try {
            this.root = this.getPortfDistModel().create();
            this.filterEmptyPortfolio();
        }
        catch (MException e) {
            logger.error("\u521d\u59cb\u5316\u6295\u7ec4\u8d26\u53f7\u6811\u5931\u8d25", (Throwable)e);
        }
    }

    private void filterEmptyPortfolio() {
        Iterator iterator = this.root.getChildren().iterator();
        while (iterator.hasNext()) {
            TreeItem next = (TreeItem)iterator.next();
            if (next.getChildren().size() != 0) continue;
            iterator.remove();
        }
    }

    public void setPortfolioList(List<Portfolio> list) {
        this.portfolioList = list;
    }

    public Map<CcsFundAccount, List<SecAccount>> getSelectedMap() {
        if (!this.selectedMap.isEmpty()) {
            return this.selectedMap;
        }
        this.root.getChildren().forEach(portItem -> {
            if (((PortfolioAccountDistribution)portItem.getValue()).isSelected()) {
                portItem.getChildren().forEach(accItem -> {
                    if (((PortfolioAccountDistribution)accItem.getValue()).isSelected()) {
                        LinkedList secList = new LinkedList();
                        accItem.getChildren().forEach(secItem -> {
                            if (((PortfolioAccountDistribution)secItem.getValue()).isSelected()) {
                                secList.add(((PortfolioAccountDistribution)secItem.getValue()).getSecAcc());
                            }
                        });
                        this.selectedMap.put(((PortfolioAccountDistribution)accItem.getValue()).getAcc(), secList);
                    }
                });
            }
        });
        return this.selectedMap;
    }

    public TreeItem<PortfolioAccountDistribution> getRoot() {
        return this.root;
    }

    public void createTree() throws MException {
        this.getPortfDistModel().clearSelect();
        this.getMapAccount().clear();
        this.root.getChildren().forEach(item -> {
            for (Portfolio portfolio : this.portfolioList) {
                if (!((PortfolioAccountDistribution)item.getValue()).getPortfolio().getId().equals(portfolio.getId())) continue;
                ((PortfolioAccountDistribution)item.getValue()).setSelected(true);
                if (item.getChildren().isEmpty()) continue;
                if (this.selectedMap.isEmpty() || this.selectedPortfolioList.isEmpty()) {
                    this.pickTwoDefault((TreeItem<PortfolioAccountDistribution>)item);
                    continue;
                }
                if (!this.selectedPortfolioList.contains(portfolio)) {
                    this.pickTwoDefault((TreeItem<PortfolioAccountDistribution>)item);
                    continue;
                }
                this.reSelected((TreeItem<PortfolioAccountDistribution>)item);
            }
        });
    }

    private void reSelected(TreeItem<PortfolioAccountDistribution> item) {
        for (TreeItem accItem : item.getChildren()) {
            if (!this.selectedMap.containsKey(((PortfolioAccountDistribution)accItem.getValue()).getAcc())) continue;
            ((PortfolioAccountDistribution)accItem.getValue()).setSelected(true);
            accItem.getChildren().forEach(secItem -> {
                if (this.selectedMap.get(((PortfolioAccountDistribution)accItem.getValue()).getAcc()).contains(((PortfolioAccountDistribution)secItem.getValue()).getSecAcc())) {
                    ((PortfolioAccountDistribution)secItem.getValue()).setSelected(true);
                }
            });
        }
    }

    private void pickTwoDefault(TreeItem<PortfolioAccountDistribution> item) {
        ((PortfolioAccountDistribution)((TreeItem)item.getChildren().get(0)).getValue()).setSelected(true);
        boolean xshg = true;
        boolean xshe = true;
        for (TreeItem secAccItem : ((TreeItem)item.getChildren().get(0)).getChildren()) {
            if (xshg && "XSHG".equals(((PortfolioAccountDistribution)secAccItem.getValue()).getSecAcc().getExchange().getRaw())) {
                ((PortfolioAccountDistribution)secAccItem.getValue()).setSelected(true);
                xshg = false;
            }
            if (!xshe || !"XSHE".equals(((PortfolioAccountDistribution)secAccItem.getValue()).getSecAcc().getExchange().getRaw())) continue;
            ((PortfolioAccountDistribution)secAccItem.getValue()).setSelected(true);
            xshe = false;
        }
    }

    public Map<CcsFundAccount, List<SecAccount>> getMapAccount() {
        return this.mapAccount;
    }

    public void setMapAccount(Map<CcsFundAccount, List<SecAccount>> mapAccount) {
        this.mapAccount = mapAccount;
    }

    public PortfolioDistributionModel getPortfDistModel() {
        return this.portfDistModel;
    }

    public void setPortfDistModel(PortfolioBasketDistributionModel portfDistModel) {
        this.portfDistModel = portfDistModel;
    }

    public List<Portfolio> getSelectedPortfolioList() {
        return this.selectedPortfolioList;
    }

    public void setSelectedPortfolioList(List<Portfolio> selectedPortfolioList) {
        this.selectedPortfolioList = selectedPortfolioList;
    }

    public void clearSelect() {
        this.selectedMap.clear();
    }
}

