/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.portfolio.models;

import cms.tmx.core.MException;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.Portfolio;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.trade.AlgoParam;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.entity.trade.instruction.OrderAdvice;
import cms.tmx.portfolio.models.PortfolioDistributionModel;
import cms.tmx.query.current.models.InstructionAccountModel;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class InstrPortfoDistributionModel
extends PortfolioDistributionModel {
    private Instruction instruction;
    private OrderAdvice advice;
    private AlgoParam param;
    private BooleanProperty active = new SimpleBooleanProperty(true);
    private StringProperty instructType = new SimpleStringProperty("");
    @Inject
    private InstructionAccountModel instructionAccModel;
    private static final Logger logger = LogManager.getLogger(InstrPortfoDistributionModel.class);

    public Instruction getInstruction() {
        return this.instruction;
    }

    public AlgoParam getParam() {
        return this.param;
    }

    public void setParam(AlgoParam param) {
        this.param = param;
    }

    public void setInstruction(Instruction instruction) {
        this.instruction = instruction;
    }

    public OrderAdvice getAdvice() {
        return this.advice;
    }

    public void setAdvice(OrderAdvice advice) {
        this.advice = advice;
    }

    @Override
    public void filterAcc() {
        if (this.isActive()) {
            super.filterAcc();
        } else {
            this.fundCanBuy();
            this.calCanBuySell();
            this.secCanSell();
            this.changed();
        }
    }

    @Override
    public List<Portfolio> getPortfolios() {
        List list = this.isActive() ? this.instructionAccModel.getActivePortfolios(this.getInstructType()) : this.instructionAccModel.getPassivePortfolios(this.instruction != null ? this.instruction.getPortfolioId() : "");
        return list == null ? new LinkedList() : list;
    }

    @Override
    public Map<CcsFundAccount, List<SecAccount>> getAccSecsMap(Portfolio pf) {
        if (this.isActive()) {
            return super.getAccSecsMap(pf);
        }
        return this.instructionAccModel.getPassiveAccMap(this.instruction);
    }

    public StringProperty instructTypeProperty() {
        return this.instructType;
    }

    public String getInstructType() {
        return (String)this.instructTypeProperty().get();
    }

    public void setInstructType(String instructType) {
        this.instructTypeProperty().set((Object)instructType);
    }

    @Override
    public long allocateCount() {
        this.fundCanBuy();
        this.calCanBuySell();
        this.showCanBuy();
        return this.allocateModel.allocateCount();
    }

    public void fillPorfolio(Instruction instruction) {
        this.removeTree();
        this.mapQuantiy.clear();
        this.setInstruction(instruction);
        if ("3".equals(instruction.getType().getRaw())) {
            this.setAdvice(instruction.getOrderAdvice());
            if (instruction.getIsOrderStep()) {
                this.mapQuantiy.put(this.advice.getPortfolioId(), this.advice.getOrderAvailableQuantity());
                this.advice.getAccSecInfoList().forEach(accSec -> {
                    long oldCount = 0L;
                    if (this.mapQuantiy.get(accSec.getAccntId()) != null) {
                        oldCount = (Long)this.mapQuantiy.get(accSec.getAccntId());
                    }
                    this.mapQuantiy.put(accSec.getSecAccntId(), accSec.getOrderAvailableQuantity());
                    this.mapQuantiy.put(accSec.getAccntId(), accSec.getOrderAvailableQuantity() + oldCount);
                });
            } else {
                this.mapQuantiy.put(this.advice.getPortfolioId(), this.advice.getOrderQty());
                this.advice.getAccSecInfoList().forEach(accSec -> {
                    long oldCount = 0L;
                    if (this.mapQuantiy.get(accSec.getAccntId()) != null) {
                        oldCount = (Long)this.mapQuantiy.get(accSec.getAccntId());
                    }
                    this.mapQuantiy.put(accSec.getSecAccntId(), accSec.getOrderQty());
                    this.mapQuantiy.put(accSec.getAccntId(), accSec.getOrderQty() + oldCount);
                });
            }
        } else if ("9".equals(instruction.getType().getRaw())) {
            this.setParam(instruction.getAlgoParam());
            if (instruction.getIsOrderStep()) {
                this.mapQuantiy.put(instruction.getPortfolioId(), Long.valueOf(this.param.getOrderAvailableQuantity()));
                this.param.getAccSecInfoList().forEach(accSec -> {
                    long oldCount = 0L;
                    if (this.mapQuantiy.get(accSec.getAccntId()) != null) {
                        oldCount = (Long)this.mapQuantiy.get(accSec.getAccntId());
                    }
                    this.mapQuantiy.put(accSec.getSecAccntId(), accSec.getOrderAvailableQuantity());
                    this.mapQuantiy.put(accSec.getAccntId(), accSec.getOrderAvailableQuantity() + oldCount);
                });
            } else {
                this.mapQuantiy.put(instruction.getPortfolioId(), Long.valueOf(this.param.getCount()));
                this.param.getAccSecInfoList().forEach(accSec -> {
                    long oldCount = 0L;
                    if (this.mapQuantiy.get(accSec.getAccntId()) != null) {
                        oldCount = (Long)this.mapQuantiy.get(accSec.getAccntId());
                    }
                    this.mapQuantiy.put(accSec.getSecAccntId(), accSec.getOrderQty());
                    this.mapQuantiy.put(accSec.getAccntId(), accSec.getOrderQty() + oldCount);
                });
            }
        }
        this.setActive(false);
        this.setSelected(true);
        try {
            this.createPortfolioTree();
            this.hasChecked = false;
            this.checkSingle();
        }
        catch (MException e) {
            logger.error("\u67e5\u8be2\u6295\u7ec4\u5931\u8d25" + (Object)((Object)e));
        }
    }

    public void removeTree() {
        this.root.getChildren().remove(0, this.root.getChildren().size());
    }

    public BooleanProperty activeProperty() {
        return this.active;
    }

    public boolean isActive() {
        return this.activeProperty().get();
    }

    public void setActive(boolean active) {
        this.activeProperty().set(active);
    }
}

