/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.portfolio.models;

import cms.tmx.entity.trade.CcsAccountDistribution;
import cms.tmx.entity.trade.PortfolioAccountDistribution;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.MxTreeList;
import cms.tmx.portfolio.models.PortfolioDistributionModel;
import java.util.function.Predicate;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class FilterAccountModel
extends MxModel {
    private PortfolioDistributionModel model;
    private Predicate<PortfolioAccountDistribution> pdShow = dist -> dist.isShow();

    public void setDistModel(PortfolioDistributionModel model) {
        this.model = model;
    }

    public void doFilter() {
        if (this.model.getRefItem() == null) {
            this.showAll(this.model.getPortfolioMxList());
            this.model.getMapAccSec().keySet().forEach(each -> this.showAll(this.model.getMapAccSec().get(each)));
            this.model.getMapPortFolioAcc().keySet().forEach(each -> this.showAll(this.model.getMapPortFolioAcc().get(each)));
        } else {
            this.filterSecAcc();
        }
        this.filterFundAcc();
        this.filterPortfolio();
    }

    private void filterSecAcc() {
        String exchange = this.model.getRefItem().getMarket();
        if ("".equals(exchange)) {
            this.model.getMapAccSec().keySet().forEach(each -> this.showAll(this.model.getMapAccSec().get(each)));
        } else {
            this.model.getMapAccSec().keySet().forEach(each -> this.showSec(this.model.getMapAccSec().get(each), exchange));
        }
    }

    private void showSec(MxTreeList<PortfolioAccountDistribution> mxTreeList, String market) {
        for (CcsAccountDistribution dist : mxTreeList.getOrList()) {
            if (!dist.getSecAcc().getExchange().getRaw().equals(market)) {
                dist.setShow(false);
                continue;
            }
            if (!(this.model.isMail() || this.model.isBuy() || dist.getCanSell() != 0L || this.model.isRepo())) {
                dist.setShow(false);
                continue;
            }
            dist.setShow(true);
        }
        mxTreeList.filter(this.pdShow);
    }

    private void showAll(MxTreeList<PortfolioAccountDistribution> distList) {
        distList.getOrList().forEach(each -> each.setShow(true));
        distList.filter(this.pdShow);
    }

    public void filterFundAcc() {
        this.model.getMapPortFolioAcc().keySet().stream().forEach(each -> this.showAll(this.model.getMapPortFolioAcc().get(each)));
        this.model.getMapAccSec().keySet().stream().forEach(each -> {
            if (this.model.getMapAccSec().get(each).getObList().size() == 0) {
                each.getAcc().getInvestId();
                this.model.getMapPortFolioAcc().keySet().forEach(portfo -> this.model.getMapPortFolioAcc().get(portfo).getOrList().forEach(acc -> {
                    if (acc.equals(each)) {
                        acc.setShow(false);
                    }
                }));
            }
        });
        this.model.getMapPortFolioAcc().keySet().stream().forEach(each -> this.model.getMapPortFolioAcc().get(each).filter(this.pdShow));
    }

    public void filterPortfolio() {
        this.showAll(this.model.getPortfolioMxList());
        this.model.getMapPortFolioAcc().keySet().stream().forEach(each -> {
            if (this.model.getMapPortFolioAcc().get(each).getOrList().filtered(pd -> pd.isShow()).size() == 0) {
                each.setShow(false);
            }
        });
        this.model.getPortfolioMxList().filter(this.pdShow);
    }
}

