/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.portfolio.models;

import cms.tmx.entity.trade.CcsAccountDistribution;
import cms.tmx.entity.trade.PortfolioAccountDistribution;
import cms.tmx.javafx.MxModel;
import cms.tmx.portfolio.models.PortfolioDistributionModel;
import cms.tmx.query.current.models.CcsPortfPositionModel;
import cms.tmx.utils.MathUtils;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.ObservableList;
import javafx.scene.control.TreeItem;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class AllocateQuantityModel
extends MxModel {
    @Inject
    private CcsPortfPositionModel posModel;
    private PortfolioDistributionModel model;
    private TreeItem<PortfolioAccountDistribution> root;
    private BooleanProperty normal = new SimpleBooleanProperty(true);
    private static final int CAL_BY_ASSET = 1;
    private static final int CAL_BY_AVAILABEL = 2;

    public void setDistModel(PortfolioDistributionModel model) {
        this.model = model;
        this.root = model.getRoot();
    }

    public long allocateCount() {
        this.clearCount(this.root);
        long totalCount = 0L;
        if (this.model.getCountStg().isEmpty()) {
            return 0L;
        }
        if (!this.isNormal()) {
            totalCount = this.calByCount(totalCount);
            return totalCount;
        }
        switch (this.model.getCountStg()) {
            case "1": {
                totalCount = this.calByCount(totalCount);
                break;
            }
            case "5": {
                totalCount = this.calByMoney(totalCount);
                break;
            }
            case "2": {
                totalCount = this.calByAsset(totalCount);
                break;
            }
            case "3": {
                totalCount = this.calByCanBuy(totalCount);
                break;
            }
            case "4": {
                totalCount = this.calByCanSell(totalCount);
                break;
            }
            default: {
                this.clearCount(this.root);
            }
        }
        return totalCount;
    }

    private long calByCount(long totalCount) {
        this.clearCount(this.root);
        totalCount = this.doQuantityAllocate(this.root, false);
        this.root.getChildren().filtered(ad -> ((PortfolioAccountDistribution)ad.getValue()).isSelected()).forEach(portfoEach -> {
            this.doQuantityAllocate((TreeItem<PortfolioAccountDistribution>)portfoEach, true);
            if (this.model.getDistStg().equals("3")) {
                return;
            }
            portfoEach.getChildren().filtered(ad -> ((PortfolioAccountDistribution)ad.getValue()).isSelected()).forEach(accEach -> this.doQuantityAllocate((TreeItem<PortfolioAccountDistribution>)accEach, true));
        });
        return totalCount;
    }

    private long calByMoney(long totalCount) {
        if (this.model.getPrice() <= 0.0) {
            this.clearCount(this.root);
            return 0L;
        }
        long count = (long)(this.model.getMoney() / this.model.getPrice());
        totalCount = count / (long)this.model.getUnit() * (long)this.model.getUnit() / (long)this.model.getUnitConvert();
        this.calByCount(totalCount);
        return totalCount;
    }

    private long calByAsset(long totalCount) {
        return this.doCalByPct(totalCount, 1);
    }

    private long calByCanBuy(long totalCount) {
        return this.doCalByPct(totalCount, 2);
    }

    private long calByCanSell(long totalCount) {
        for (TreeItem portfoItem : this.root.getChildren().filtered(ad -> ((PortfolioAccountDistribution)ad.getValue()).isSelected() && this.hasSelectedChd((TreeItem<PortfolioAccountDistribution>)ad) != false)) {
            long porfoCount = 0L;
            for (TreeItem accItem : portfoItem.getChildren().filtered(ad -> ((PortfolioAccountDistribution)ad.getValue()).isSelected() && this.hasSelectedChd((TreeItem<PortfolioAccountDistribution>)ad) != false)) {
                long count = 0L;
                for (TreeItem secItem : accItem.getChildren().filtered(ad -> ((PortfolioAccountDistribution)ad.getValue()).isSelected())) {
                    CcsAccountDistribution secAccItem = (CcsAccountDistribution)secItem.getValue();
                    long cansell = new Double(this.posModel.getCanSell(secAccItem.getSecAcc(), this.model.getRefItem().getCode())).longValue();
                    if (this.model.getPercent() == 1.0) {
                        secAccItem.setCount((long)((double)cansell * this.model.getPercent()));
                    } else {
                        secAccItem.setCount((long)((double)cansell * this.model.getPercent()) / (long)this.model.getUnit() * (long)this.model.getUnit());
                    }
                    count += secAccItem.getCount();
                }
                ((PortfolioAccountDistribution)accItem.getValue()).setCount(count);
                porfoCount += ((PortfolioAccountDistribution)accItem.getValue()).getCount();
            }
            ((PortfolioAccountDistribution)portfoItem.getValue()).setCount(porfoCount);
            totalCount += porfoCount;
        }
        return totalCount;
    }

    private long doCalByPct(long totalCount, int type) {
        if (this.model.getPrice() <= 0.0) {
            return 0L;
        }
        for (TreeItem portfoItem : this.root.getChildren().filtered(pd -> ((PortfolioAccountDistribution)pd.getValue()).isSelected() && this.hasSelectedChd((TreeItem<PortfolioAccountDistribution>)pd) != false)) {
            long portCount = 0L;
            for (TreeItem accItem : portfoItem.getChildren().filtered(ad -> ((PortfolioAccountDistribution)ad.getValue()).isSelected() && this.hasSelectedChd((TreeItem<PortfolioAccountDistribution>)ad) != false)) {
                PortfolioAccountDistribution accDist = (PortfolioAccountDistribution)accItem.getValue();
                double underlyling = type == 1 ? accDist.getAcc().getAssetAmt() : accDist.getAcc().getAvailable();
                long count = (long)(underlyling * this.model.getPercent() / this.model.getPrice()) / (long)this.model.getUnit() * (long)this.model.getUnit() / (long)this.model.getUnitConvert();
                ((PortfolioAccountDistribution)accItem.getValue()).setCount(count);
                portCount += accDist.getCount();
                this.doQuantityAllocate((TreeItem<PortfolioAccountDistribution>)accItem, true);
            }
            ((PortfolioAccountDistribution)portfoItem.getValue()).setCount(portCount);
            totalCount += portCount;
        }
        return totalCount;
    }

    private long doQuantityAllocate(TreeItem<PortfolioAccountDistribution> parent, boolean isAverage, long pTotal) {
        int totalWeight = 0;
        long totalCount = pTotal;
        this.clearCount(parent);
        int countAcc = this.getCalChildren(parent, isAverage).size();
        for (TreeItem ad : this.getCalChildren(parent, isAverage)) {
            totalWeight += 100 * ((PortfolioAccountDistribution)ad.getValue()).getWeight();
        }
        long assigned = 0L;
        if (this.model.getDistStg().equals("3")) {
            return this.doAllocateByMin(parent, totalCount);
        }
        Iterator it = this.getCalChildren(parent, isAverage).iterator();
        while (it.hasNext()) {
            TreeItem ad = (TreeItem)it.next();
            if (!it.hasNext()) {
                long count = MathUtils.calCount((long)(totalCount - assigned), (int)1);
                ((PortfolioAccountDistribution)ad.getValue()).setCount(count);
                assigned += count;
                break;
            }
            long target = 0L;
            if (isAverage) {
                target = totalCount / (long)countAcc;
            } else if (this.model.getDistStg().equals("2")) {
                target = totalCount * (long)((PortfolioAccountDistribution)ad.getValue()).getWeight() * 100L / (long)totalWeight;
            }
            long count = MathUtils.calCount((long)target, (int)this.model.getUnit());
            if (this.model.getRefItem() != null && this.model.getRefItem().getCode().startsWith("688") && count < 200L) {
                count = 0L;
            }
            assigned += count;
            ((PortfolioAccountDistribution)ad.getValue()).setCount(count);
        }
        return assigned;
    }

    private long doQuantityAllocate(TreeItem<PortfolioAccountDistribution> parent, boolean isAverage) {
        return this.doQuantityAllocate(parent, isAverage, ((PortfolioAccountDistribution)parent.getValue()).getCount());
    }

    protected long doAllocateByMin(TreeItem<PortfolioAccountDistribution> parent, long totalCount) {
        long assigned = 0L;
        LinkedList<TreeItem<PortfolioAccountDistribution>> list = new LinkedList<TreeItem<PortfolioAccountDistribution>>();
        parent.getChildren().filtered(ad -> ((PortfolioAccountDistribution)ad.getValue()).isSelected() && this.hasSelectedChd((TreeItem<PortfolioAccountDistribution>)ad) != false).forEach(each -> each.getChildren().filtered(ad -> ((PortfolioAccountDistribution)ad.getValue()).isSelected()).forEach(subEach -> list.add((TreeItem<PortfolioAccountDistribution>)subEach)));
        list.sort(new CanSellComparator());
        Iterator it = list.iterator();
        while (it.hasNext()) {
            TreeItem ad2 = (TreeItem)it.next();
            if (!it.hasNext()) {
                long count = MathUtils.calCount((long)(totalCount - assigned), (int)1);
                ((PortfolioAccountDistribution)ad2.getValue()).setCount(count);
                assigned += count;
                long prCount = ((PortfolioAccountDistribution)ad2.getParent().getValue()).getCount() + ((PortfolioAccountDistribution)ad2.getValue()).getCount();
                ((PortfolioAccountDistribution)ad2.getParent().getValue()).setCount(prCount);
                break;
            }
            if (totalCount - assigned >= ((PortfolioAccountDistribution)ad2.getValue()).getCanSell()) {
                ((PortfolioAccountDistribution)ad2.getValue()).setCount(((PortfolioAccountDistribution)ad2.getValue()).getCanSell());
            } else {
                ((PortfolioAccountDistribution)ad2.getValue()).setCount(totalCount - assigned);
            }
            long prCount = ((PortfolioAccountDistribution)ad2.getParent().getValue()).getCount() + ((PortfolioAccountDistribution)ad2.getValue()).getCount();
            ((PortfolioAccountDistribution)ad2.getParent().getValue()).setCount(prCount);
            if ((assigned += ((PortfolioAccountDistribution)ad2.getValue()).getCount()) == totalCount) break;
        }
        return assigned;
    }

    public void clearCount(TreeItem<PortfolioAccountDistribution> parent) {
        parent.getChildren().forEach(portfoEach -> {
            ((PortfolioAccountDistribution)portfoEach.getValue()).setCount(0L);
            portfoEach.getChildren().forEach(accEach -> {
                ((PortfolioAccountDistribution)accEach.getValue()).setCount(0L);
                accEach.getChildren().forEach(secEach -> ((PortfolioAccountDistribution)secEach.getValue()).setCount(0L));
            });
        });
    }

    public void clearCanBuy(TreeItem<PortfolioAccountDistribution> parent) {
        parent.getChildren().forEach(each -> {
            ((PortfolioAccountDistribution)each.getValue()).setCanBuy(0L);
            for (TreeItem sub : each.getChildren()) {
                if (sub == null) continue;
                ((PortfolioAccountDistribution)sub.getValue()).setCanBuy(0L);
            }
        });
    }

    public void clearCanBuySell(TreeItem<PortfolioAccountDistribution> parent) {
        parent.getChildren().forEach(each -> {
            ((PortfolioAccountDistribution)each.getValue()).setCanBuy(0L);
            ((PortfolioAccountDistribution)each.getValue()).setCanSell(0L);
            for (TreeItem sub : each.getChildren()) {
                if (sub == null) continue;
                ((PortfolioAccountDistribution)sub.getValue()).setCanBuy(0L);
                ((PortfolioAccountDistribution)sub.getValue()).setCanSell(0L);
            }
        });
    }

    private Boolean hasSelectedChd(TreeItem<PortfolioAccountDistribution> parent) {
        if (!((PortfolioAccountDistribution)parent.getValue()).isIsSecAcc() && parent.isLeaf()) {
            return false;
        }
        if (!parent.isLeaf() && parent.getChildren().filtered(each -> ((PortfolioAccountDistribution)each.getValue()).isSelected()).size() == 0) {
            return false;
        }
        return true;
    }

    private ObservableList<TreeItem<PortfolioAccountDistribution>> getCalChildren(TreeItem<PortfolioAccountDistribution> parent, boolean isAverage) {
        if (!isAverage && this.model.getDistStg().equals("2")) {
            return parent.getChildren().filtered(ad -> ((PortfolioAccountDistribution)ad.getValue()).isSelected() && this.hasSelectedChd((TreeItem<PortfolioAccountDistribution>)ad) != false && ((PortfolioAccountDistribution)ad.getValue()).getWeight() != 0);
        }
        return parent.getChildren().filtered(ad -> ((PortfolioAccountDistribution)ad.getValue()).isSelected() && this.hasSelectedChd((TreeItem<PortfolioAccountDistribution>)ad) != false);
    }

    public final BooleanProperty normalProperty() {
        return this.normal;
    }

    public final boolean isNormal() {
        return this.normalProperty().get();
    }

    public final void setNormal(boolean normal) {
        this.normalProperty().set(normal);
    }

    protected class CanSellComparator
    implements Comparator<TreeItem<PortfolioAccountDistribution>> {
        protected CanSellComparator() {
        }

        @Override
        public int compare(TreeItem<PortfolioAccountDistribution> o1, TreeItem<PortfolioAccountDistribution> o2) {
            if (((PortfolioAccountDistribution)o1.getValue()).getCanSell() == ((PortfolioAccountDistribution)o2.getValue()).getCanSell()) {
                return 0;
            }
            return ((PortfolioAccountDistribution)o1.getValue()).getCanSell() >= ((PortfolioAccountDistribution)o2.getValue()).getCanSell() ? 1 : -1;
        }
    }
}

