﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Text;

namespace desktopEnglish.utils
{
    class FileUtil
    {
        /// <summary>
        /// 获得指定路径下所有文件名
        /// </summary>
        /// <param name="sw">文件写入流</param>
        /// <param name="path">文件写入流</param>
        public static List<string> getFileName(string path)
        {
            List<string> fileNameList = new List<string>();
            if (!Directory.Exists(path))
            {
                return fileNameList;
            }
            DirectoryInfo root = new DirectoryInfo(path);
            foreach (FileInfo f in root.GetFiles())
            {
                if (f.Extension.Equals(".txt"))
                {
                    fileNameList.Add(f.Name);
                }
            }
            return fileNameList;
        }
    }
}
