﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.Text;
using System.Windows.Forms;

namespace desktopEnglish.settingForm
{
    public partial class FormNewFile : Form
    {
        private string rootPath;
        public delegate void newFile(string fileName);
        public event newFile getFileName;
        public FormNewFile(string rootPath)
        {
            InitializeComponent();
            this.rootPath = rootPath;
            this.TopMost = true;
        }

        private void buttonYes_Click(object sender, EventArgs e)
        {
            string filePath = this.textBoxFilename.Text;
            if (filePath != "")
            {
                string subStr = "";
                if (filePath.Length > 4)
                {
                    subStr = filePath.Substring(filePath.Length - 4, 4);
                }

                if (subStr == ".txt")
                {
                    StreamWriter sw = File.CreateText(rootPath + "\\" + filePath);
                    sw.Close();
                    getFileName(filePath);                 
                }
                else
                {
                    StreamWriter sw = File.CreateText(rootPath + "\\" + filePath + ".txt");
                    sw.Close();
                    getFileName(filePath+".txt");
                }
                this.Close();
            }
        }

        private void buttonNo_Click(object sender, EventArgs e)
        {
            this.Close();
        }
    }
}
