﻿using desktopEnglish.entity;
using desktopEnglish.settingForm;
using desktopEnglish.utils;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Runtime.InteropServices;
using System.Text;
using System.Windows.Forms;

namespace desktopEnglish
{
    public partial class FormSetting : Form
    {
        //为实现关闭设置窗口后，foreForm能响应设置的改变
        public delegate void formSettingFlush();
        public event formSettingFlush FormFlush;
        // 子窗体
        private Form currentChildForm;
        private Form backForm;
        private Form foreForm;
        public FormSetting(Form backForm,Form foreForm)
        {
            InitializeComponent();
            this.backForm = backForm;
            this.foreForm = foreForm;
        }
        //打开子窗体
        private void OpenChildForm(Form childForm)
        {
            if (currentChildForm != null)
            {
                //只打开一个窗体
                currentChildForm.Close();
            }
            // 实例化子窗体
            currentChildForm = childForm;
            childForm.TopLevel = false;
            childForm.FormBorderStyle = FormBorderStyle.None;
            childForm.Dock = DockStyle.Fill;
            // 向panelDesktop 控件集合中添加 子窗体
            panelContainer.Controls.Add(childForm);
            panelContainer.Tag = childForm;
            childForm.BringToFront();
            childForm.Show();
        }

        #region 设置的退出
        private void labelClick_MouseHover(object sender, EventArgs e)
        {
            this.labelClick.BackColor = Color.Red;
        }

        private void labelClick_MouseLeave(object sender, EventArgs e)
        {
            this.labelClick.BackColor = this.panelHeader.BackColor;
        }

        private void labelClick_Click(object sender, EventArgs e)
        {
            if (currentChildForm != null)
            {
                currentChildForm.Close();
            }
            this.Close();
        }
        #endregion

        #region 窗体拖动
        //拖动的形式
        [DllImport("user32.DLL", EntryPoint = "ReleaseCapture")]
        private extern static void ReleaseCapture();

        [DllImport("user32.DLL", EntryPoint = "SendMessage")]
        private extern static void SendMessage(System.IntPtr hWnd, int wMsg, int wParam, int lParam);

        private void panelHeader_MouseDown(object sender, MouseEventArgs e)
        {
            ReleaseCapture();
            SendMessage(this.Handle, 0x112, 0xf012, 0);
        }

        #endregion

        private void buttonRoutine_Click(object sender, EventArgs e)
        {
            this.label1.Text = "常规设置";
            OpenChildForm(new FormRoutine());
        }

        private void FormSetting_Load(object sender, EventArgs e)
        {
            this.foreForm.TopMost = false;
            Form1.timerStaRandom.Stop();
            this.backForm.TopMost = false;
            this.TopMost = true;
            this.label1.Text = "设置";
        }

        private void FormSetting_FormClosing(object sender, FormClosingEventArgs e)
        {
            //窗体重新置顶
            this.backForm.TopMost = true;
            this.foreForm.TopMost = true;
            //重新读取常规配置
            Form1.routineSetting = UtilSerialize.DeserializeFromFile(FinalStrPath.RoutineConfigPath) as RoutineSetting;
            this.backForm.BackColor = Form1.routineSetting.BackColor;
            this.backForm.Opacity = Form1.routineSetting.Opacity;
            Form1.timerStaRandom.Interval = Form1.routineSetting.Speed * 1000;
            Form1.timerStaRandom.Start();
            //重新读取单词设置
            Form1.wordSetting = UtilSerialize.DeserializeFromFile(FinalStrPath.WordConfigPath) as WordSetting;
            FormFlush();
        }

        private void btuWord_Click(object sender, EventArgs e)
        {
            this.label1.Text = "单词设置";
            OpenChildForm(new FormWord());
        }

        private void pictureBox1_Click(object sender, EventArgs e)
        {
            this.label1.Text = "设置";
            if (currentChildForm != null)
            {
                //只打开一个窗体
                currentChildForm.Close();
            }
        }

        private void panelContainer_Paint(object sender, PaintEventArgs e)
        {
            RoutineSetting routineSetting = UtilSerialize.DeserializeFromFile(FinalStrPath.RoutineConfigPath) as RoutineSetting;
            if(routineSetting == null)
            {
                routineSetting = RoutineSetting.initRoutineSetting();
            }
            this.panelContainer.BackColor = routineSetting.BackColor;
            Graphics g = e.Graphics;
            string str = "sky\n美[skaɪ]，英[skaɪ]\nn.天空；\nv.把（球）击向高空网络释义：天空电视台，天蓝色，蓝天；";
            Font font = routineSetting.Font;
            g.Clear(this.panelContainer.BackColor);
            g.TextRenderingHint = System.Drawing.Text.TextRenderingHint.SingleBitPerPixel;
            g.DrawString(str, font, new SolidBrush(routineSetting.FontColor), new PointF(30, 20));
            g.Dispose();
        }
    }
}
