/***************************************************************************
 *                          Zanoza Modeler v3.x                            *
 *      This is unpublished propietary source code of Zanoza Software.     *
 *      The copyright notice does not evidence any actual or intended      *
 *                    publication of such source code.                     *
 *                                                                         *
 *                 Copyright (c) 2002-2012 Zanoza Software.                *
 *                                                                         *
 *                        All rights reserved.                             *
 ***************************************************************************
 *--------------------------------------------------------------------------
 * @author:   Oleg M.
 *--------------------------------------------------------------------------
 * @purpose:  ZModeler 3.x shader technique: wireframe shader
 *--------------------------------------------------------------------------
 * @histroy: 12.07.2011. Created

<[[
UserName = "Colored Wireframe"
Version  = 1.8
Options  = PURE
]]>

 */

#pragma pack_matrix( row_major ) 

struct VS_INPUT
{
    float4 vPosition        : POSITION;
    float4 vColorDif        : COLOR0;
    float4 vDeformPosition  : TEXCOORD5;
    float4 vDeformNormal    : COLOR2;
    uint4  vBones0          : BLENDINDICES0;
    uint4  vBones1          : BLENDINDICES1;
    float4 vWeights0        : BLENDWEIGHT0;
    float4 vWeights1        : BLENDWEIGHT1;
};

struct VS_OUTPUT
{
    float4  vPosition : POSITION;
    float4  vDiffuse  : COLOR;
};


#include "zmCommon.inl"

#ifdef VERTEX_SHADER
VS_OUTPUT mainVS(in VS_INPUT v)
{
    VS_OUTPUT output;
    //transform to screen:
    float4 vNorm    = (float4)0;
    float4 vTangent = (float4)0;
    float4 vView    = (float4)0;

    output.vPosition = transformInput(v, vNorm, vTangent, vView);

    //compute color:

    //diffuse:
    float4 color = g_colors[1]*(any(v.vColorDif.rgb) ? v.vColorDif : 1);


    // discard specular in wireframe computations;

    // add emissive:
    //color.rgb = lerp(color.rgb, g_colors[3].rgb, g_colors[3].a);
    color.rgb += g_colors[3].rgb*g_colors[3].a;

    output.vDiffuse = color;
    output.vDiffuse.a = g_colors[1].a;
    return output;
}
#endif //VERTEX_SHADER

float4 mainPS(in VS_OUTPUT v) : COLOR
{
  return v.vDiffuse;
}
