/***************************************************************************
 *                          Zanoza Modeler v3.x                            *
 *      This is unpublished propietary source code of Zanoza Software.     *
 *      The copyright notice does not evidence any actual or intended      *
 *                    publication of such source code.                     *
 *                                                                         *
 *                 Copyright (c) 2002-2012 Zanoza Software.                *
 *                                                                         *
 *                        All rights reserved.                             *
 ***************************************************************************
 *--------------------------------------------------------------------------
 * @author:   Oleg M.
 *--------------------------------------------------------------------------
 * @purpose:  ZModeler 3.x Color + Diffuse Texture + Environment shader
 *--------------------------------------------------------------------------
 * @histroy: 14.06.2015. Created
<[[
UserName = "Diffuse+Env"
Description = "Color, Diffuse, Environment map"
Version  = 1.9.0
Options  = SOLID SPECULAR ENVIRONMENT FRESNEL TRANSITION EMISSIVECOLOR DUSTCOLOR DIRTCOLOR SCRATCHCOLOR BURNCOLOR DIFFUSECOLOR2 DIFFUSECOLOR3 DIFFUSECOLOR4
Samplers = DETAIL ENVMAP MASK
ManualUV1 = v.vUV01.xy
ManualUV2 = v.vUV01.zw
ManualUV3 = v.vUV23.xy
ManualUV4 = v.vUV23.zw
EnvUV = v.vUVRefl.xy
WorldUV = v.vUVRefl.zw
AlphaRegister = 29

[DETAIL]
Variable = g_Diffuse
Register = 0
RegisterTrans = 1
Mask = R G B A RGB
Config = 30

[ENVMAP]
Variable = g_Refl
Register = 2
Mask = RGB
Config = 31

[MASK]
Variable = g_Mask
Register = 3
Mask = R G B A RGB
Config = 33

[DUSTCOLOR]
Register    = 34

[DIRTCOLOR]
Register    = 35

[SCRATCHCOLOR]
Register    = 36

[BURNCOLOR]
Register    = 37

[DIFFUSECOLOR2]
Register    = 38

[DIFFUSECOLOR3]
Register    = 39

[DIFFUSECOLOR4]
Register    = 40

[ALPHABLEND]

[ALPHATEST]

[CUSTOM.1]
Name = Opacity Amplifier
Slot = 32.R
Type = float
Min = 0.0
Max = 1.0
Default = 0.2

[CUSTOM.2]
Name = Fresnel
Slot = 32.G
Type = float
Min = 0.001
Max = 0.3
Default = 0.018


]]>
*/

#pragma pack_matrix( row_major ) 

struct VS_INPUT
{
    float4 vPosition        : POSITION;
    float4 vNormal          : NORMAL;
    float4 vColorDif        : COLOR0;
    float4 vUV01            : TEXCOORD0;
    float4 vUV23            : TEXCOORD1;
    float4 vDeformPosition  : TEXCOORD5;
    float4 vDeformNormal    : COLOR2;
    uint4  vBones0          : BLENDINDICES0;
    uint4  vBones1          : BLENDINDICES1;
    float4 vWeights0        : BLENDWEIGHT0;
    float4 vWeights1        : BLENDWEIGHT1;
};

struct VS_OUTPUT
{
    float4 vPosition  : POSITION;   //transformed position
    float4 vColorDif  : COLOR0;
    //precomputed stuff:
    float4 vNormal    : TEXCOORD0;  //world-space normal;
    float4 vViewer    : TEXCOORD1;  //camera-space position;
    float4 vUV01      : TEXCOORD2;
    float4 vUV23      : TEXCOORD3;
    float4 vUVRefl    : TEXCOORD4;
};

//----------------------------------------------------------------------
// globals:
//----------------------------------------------------------------------
#include "zmCommon.inl"

float4      g_alpha          : register(c29);  //[minlevel:testvalue, maxlevel, mapaffect, angular level]
float4      g_diffConfig     : register(c30);  //[level, angular, tiling.uv]
float4      g_envConfig      : register(c31);  //[level, angular, tiling.uv]
float4      g_environment    : register(c32);  //[opacity refl amplifier, fresnel value, 0, 0]
float4      g_maskConfig     : register(c33);  //[level, angular, tiling.uv]

float4      g_dustColor      : register(c34);  //dust color r,g,b and level in .a
float4      g_dirtColor      : register(c35);  //dirt color r,g,b and level in .a
float4      g_scratchColor   : register(c36);  //scratch color r,g,b and level in .a
float4      g_burnColor      : register(c37);  //burn color r,g,b and level in .a
                                               //level of main diffuse is in g_colors[1].a;
float4      g_diffuse2Color  : register(c38);  //diffuse2 color r,g,b and level in .a
float4      g_diffuse3Color  : register(c39);  //diffuse3 color r,g,b and level in .a
float4      g_diffuse4Color  : register(c40);  //diffuse4 color r,g,b and level in .a

// textures:
sampler     g_Diffuse        : register(s[0]);
sampler     g_DiffuseTrans   : register(s[1]);
sampler     g_Refl           : register(s[2]);
sampler     g_Mask           : register(s[3]);

#ifdef VERTEX_SHADER
VS_OUTPUT mainVS(in VS_INPUT v)
{
    VS_OUTPUT output = (VS_OUTPUT)0;
    output.vNormal = v.vNormal;
    float4 vTangent = (float4)0;
    output.vPosition = transformInput(v, output.vNormal, vTangent, output.vViewer);
    output.vColorDif = any(v.vColorDif.rgb) ? v.vColorDif : 1;

    output.vUV01 = v.vUV01;
    output.vUV23 = v.vUV23;
    output.vUVRefl.xy = (mul(output.vNormal.xyz, (float3x3)g_mView).xy+1)/2;
    output.vUVRefl.zw = v.vPosition.xz;

    return output;
}
#endif //VERTEX_SHADER

#ifdef PIXEL_SHADER
//------------------------------------------------------------
//  PixelShader: generic Color+Dif+Refl;
//------------------------------------------------------------
float4 mainPS(in VS_OUTPUT v) : COLOR0
{
    float4 oColor;
    float4 CONST_TEXEL      = float4(1,1,1,1);
    float4 VCOLOR_TEXEL     = v.vColorDif;
    float4 PERVERTEXCOLOR = lerp(1, VCOLOR_TEXEL, g_deform.z);
    float4 DETAIL_TEXEL     = tex2D(DETAIL_SOURCE, DETAIL_UV_SOURCE*g_diffConfig.zw);
    float4 MASK_TEXEL       = tex2D(MASK_SOURCE, MASK_UV_SOURCE*g_maskConfig.zw)*g_maskConfig.x*(MASK_INPUT_MASK);
    float4 ENVMAP_TEXEL     = tex2D(ENVMAP_SOURCE, ENVMAP_UV_SOURCE*g_envConfig.zw);
    //apply transitions:
    DETAIL_TEXEL = lerp(DETAIL_TEXEL, tex2D(g_DiffuseTrans, DETAIL_UV_SOURCE*g_diffConfig.zw), DETAIL_TRANSITION);

    float3 light = -g_lightDir.xyz;
    float4 Temp   = float4(1,1,saturate(dot(v.vViewer.xyz, v.vNormal.xyz)), 0); 
    
#ifdef SPECULAR_ENABLED
    float3 normal = normalize(v.vNormal.xyz);
    float3 halfSpec = normalize(light + v.vViewer.xyz);
    Temp.xy = float2(dot(normal, light), dot(normal, halfSpec));
    float4 LitCoef = lit(Temp.x, Temp.y, g_colors[2].a);
#else
    float4 LitCoef = float4(1, saturate(dot(light, v.vNormal.xyz)), 0, 0);
#endif //SPECULAR_ENABLED
    // alter diffuse light factor by ambient illumitaion addon:
    LitCoef.y = saturate(LitCoef.y + (g_ambientLight.r + g_ambientLight.g + g_ambientLight.b)/3);

    float3 fDetailColor    = DETAIL_INPUT;
    float3 fEnvironColor    = (ENVMAP_INPUT*(ENVMAP_INPUT_MASK));
    if (g_diffConfig.y >= 0) //diff angular value
      Temp.w = lerp(1, Temp.z, g_diffConfig.y)*g_diffConfig.x*(DETAIL_INPUT_MASK);
    else
      Temp.w = lerp(1, 1-Temp.z, abs(g_diffConfig.y))*g_diffConfig.x*(DETAIL_INPUT_MASK);

    if (g_envConfig.y >= 0) //refl angular value
      Temp.x = lerp(1, Temp.z, g_envConfig.y)*g_envConfig.x;
    else
      Temp.x = lerp(1, 1-Temp.z, abs(g_envConfig.y))*g_envConfig.x;

    //
    // damaged version of texture is always lerp-ed over g_deform.x
    fDetailColor = lerp(1, fDetailColor, Temp.w);

    float fresnel = (1-LitCoef.y);
    Temp.y = fresnel*fresnel;
    Temp.y = Temp.y*Temp.y;
    Temp.y = saturate(mad(Temp.y*fresnel, 1-saturate(g_environment.y), g_environment.y));

    //
    // advanced diffuse color, and shine/opacity overload controllers:
    ADVANCED_COLOR_DIFFUSELEVEL(fAdvColorLevels)
    ADVANCED_COLOR_DIFFUSEVAR(fAdvancedDiffuseColor, fAdvColorLevels)
    ADVANCED_COLOR_EFFECTLEVELS(fEffectLevels)
    ADVANCED_COLOR_EFFECTVAR(fEffectColor, fEffectLevels)
    ADVANCED_COLOR_OPTIONS(advShineOpac, fEffectLevels, fAdvColorLevels)

    fEnvironColor = fEnvironColor*saturate(Temp.x+(0.7 + g_envConfig.x)*Temp.y);
    float3 fSpecularColor = g_colors[2].rgb*(LitCoef.z + LitCoef.z*(1+LitCoef.y)*saturate(advShineOpac.g));

    oColor.rgb =
                // ambient: 
                (g_colors[0].rgb + 0.2*PERVERTEXCOLOR.rgb + 0.8*fDetailColor*g_ambientLight.rgb)*g_ambientLight.rgb +
                // diffuse component:
                (fAdvancedDiffuseColor*PERVERTEXCOLOR.rgb*fDetailColor*(1-fEffectColor.a) + fEffectColor.rgb*fEffectColor.a)*max((EMISSIVECOLOR_INPUT_MASK)*advShineOpac.r*4*g_colors[3].a, LitCoef.y) +
                //matted or dimmed:
                advShineOpac.r*(
                  // specular component:
                  fSpecularColor +
                  // reflection component:
                  fEnvironColor + 
                  // emissive component:
                  g_colors[3].rgb*(EMISSIVECOLOR_INPUT_MASK)*g_colors[3].a
                );

#ifdef ALPHABLEND_ENABLED
    if (g_alpha.w >= 0)
      Temp.w = lerp(1, Temp.z, g_alpha.w);
    else
      Temp.w = lerp(1, 1-Temp.z, abs(g_alpha.w));
    oColor.a = saturate(lerp(1, ALPHABLEND_INPUT, g_alpha.z)*ALPHABLEND_VERTEXCOLOR*Temp.w*g_alpha.y + 
                        (length(fEnvironColor) + length(fSpecularColor))*g_environment.x + advShineOpac.b);
    
#else
    oColor.a = g_alpha.y;
#endif//ALPHABLEND_ENABLED
#ifdef ALPHATEST_ENABLED
    clip(oColor.a - g_alpha.x);
#endif//ALPHATEST_ENABLED
    return oColor;
}
#endif //PIXEL_SHADER

