/***************************************************************************
 *                          Zanoza Modeler v3.x                            *
 *      This is unpublished propietary source code of Zanoza Software.     *
 *      The copyright notice does not evidence any actual or intended      *
 *                    publication of such source code.                     *
 *                                                                         *
 *                 Copyright (c) 2002-2012 Zanoza Software.                *
 *                                                                         *
 *                        All rights reserved.                             *
 ***************************************************************************
 *--------------------------------------------------------------------------
 * @author:   Oleg M.
 *--------------------------------------------------------------------------
 * @purpose:  ZModeler 3.x Color + Bump + two Diffuse Textures shader
 *--------------------------------------------------------------------------
 * @histroy: 29.08.2012. Created
<[[
UserName = "Bump+Dual Diffuse"
Description = "Color, Bump and two Diffuse maps"
Version  = 1.9.1
Options  = SOLID BUMP SPECULAR TRANSITION EMISSIVECOLOR DUSTCOLOR DIRTCOLOR SCRATCHCOLOR BURNCOLOR DIFFUSECOLOR2 DIFFUSECOLOR3 DIFFUSECOLOR4
Samplers = DETAIL DETAIL2 BUMPMAP MASK
ManualUV1 = v.vUV01.xy
ManualUV2 = v.vUV01.zw
ManualUV3 = v.vUV23.xy
ManualUV4 = v.vUV23.zw
EnvUV = v.vUVRefl.xy
WorldUV = v.vUVRefl.zw
AlphaRegister = 29

[DETAIL]
Variable = g_Diffuse
Register = 0
RegisterTrans = 1
Mask = R G B A RGB
Config = 30

[DETAIL2]
Variable = g_Diffuse2
Register = 2
RegisterTrans = 3
Mask = R G B A RGB AGB GRB AG GA
Config = 31

[BUMPMAP]
Variable = g_BumpMap
Register = 4
RegisterTrans = 5
Mask = RGB AGB GRB AG GA
Config = 32

[MASK]
Variable = g_Mask
Register = 6
Mask = R G B A RGB
Config = 40
	
[DUSTCOLOR]
Register    = 33

[DIRTCOLOR]
Register    = 34

[SCRATCHCOLOR]
Register    = 35

[BURNCOLOR]
Register    = 36

[DIFFUSECOLOR2]
Register    = 37

[DIFFUSECOLOR3]
Register    = 38

[DIFFUSECOLOR4]
Register    = 39

[ALPHABLEND]

[ALPHATEST]

[CUSTOM.1]
Name = MODE
Type = combo
Definition = DIFFUSE2_TOP_
Variants = Multiply = MULT, Add = ADD, Lerp = LERP, Overlay = OVERLAY, Mix = MIX, Displace = DISPLACE
;Default = Add


]]>
*/

#pragma pack_matrix( row_major ) 

struct VS_INPUT
{
    float4 vPosition        : POSITION;
    float4 vNormal          : NORMAL;
    float4 vTangent         : TANGENT;
    float4 vColorDif        : COLOR0;
    float4 vUV01            : TEXCOORD0;
    float4 vUV23            : TEXCOORD1;
    float4 vDeformPosition  : TEXCOORD5;
    float4 vDeformNormal    : COLOR2;
    uint4  vBones0          : BLENDINDICES0;
    uint4  vBones1          : BLENDINDICES1;
    float4 vWeights0        : BLENDWEIGHT0;
    float4 vWeights1        : BLENDWEIGHT1;
};

struct VS_OUTPUT
{
    float4 vPosition  : POSITION;   //transformed position
    float4 vColor     : COLOR0;     //vertex color composition {ambient, diffuse, specular, 1}
    float4 vUV01      : TEXCOORD0;
    float4 vUV23      : TEXCOORD1;
    float4 vUVRefl    : TEXCOORD2;  //environment reflection;
    //precomputed stuff:
    float4 vNormal    : TEXCOORD4;  //world-space normal;
    float4 vViewer    : TEXCOORD5;  //camera-space position;
    float4 vBumpLit   : TEXCOORD6;  //tangent-space light;
    float4 vBumpViewer: TEXCOORD7;  //tangent-space position;
};

//----------------------------------------------------------------------
// globals:
//----------------------------------------------------------------------

#include "zmCommon.inl"

float4      g_alpha          : register(c29);  //[minlevel:testvalue, maxlevel, mapaffect, angular level]
float4      g_diffConfig     : register(c30);  //[level, angular, tiling.uv]
float4      g_diff2Config    : register(c31);  //[level, angular, tiling.uv]
float4      g_bumpConfig     : register(c32);  //[level, angular, tiling.uv]
float4      g_dustColor      : register(c33);  //dust color r,g,b and level in .a
float4      g_dirtColor      : register(c34);  //dirt color r,g,b and level in .a
float4      g_scratchColor   : register(c35);  //scratch color r,g,b and level in .a
float4      g_burnColor      : register(c36);  //burn color r,g,b and level in .a
                                               //level of main diffuse is in g_colors[1].a;
float4      g_diffuse2Color  : register(c37);  //diffuse2 color r,g,b and level in .a
float4      g_diffuse3Color  : register(c38);  //diffuse3 color r,g,b and level in .a
float4      g_diffuse4Color  : register(c39);  //diffuse4 color r,g,b and level in .a
float4      g_maskConfig     : register(c40);  //[level, angular, tiling.uv]

// textures:
sampler     g_Diffuse        : register(s[0]);
sampler     g_DiffuseTrans   : register(s[1]);
sampler     g_Diffuse2       : register(s[2]);
sampler     g_Diffuse2Trans  : register(s[3]);
sampler     g_BumpMap        : register(s[4]);
sampler     g_BumpMapTrans   : register(s[5]);
sampler     g_Mask           : register(s[6]);


// textures:

#ifdef VERTEX_SHADER
VS_OUTPUT mainVS(in VS_INPUT v)
{
    VS_OUTPUT output = (VS_OUTPUT)0;
    output.vNormal = v.vNormal;
    float4 vTangent = v.vTangent;
    output.vPosition = transformInput(v, output.vNormal, vTangent, output.vViewer);
    output.vColor = any(v.vColorDif.rgb) ? v.vColorDif : 1;

    output.vUV01 = v.vUV01;
    output.vUV23 = v.vUV23;
    //bump-map reflection can mix this spehere-env uv mapping with bump-reflected env;
    output.vUVRefl.xy = (mul(output.vNormal.xyz, (float3x3)g_mView).xy+1)/2;
    output.vUVRefl.zw = v.vPosition.xz;

    // bump-transformed light:
    //-----
    float3x3 worldToTangentSpace;
    worldToTangentSpace[0] = vTangent.xyz;
    worldToTangentSpace[1] = normalize(cross(vTangent.xyz, output.vNormal.xyz)*(-v.vTangent.w));
    worldToTangentSpace[2] = output.vNormal.xyz;
    output.vBumpLit = normalize(float4(mul(worldToTangentSpace, -g_lightDir.xyz), 1));
    output.vBumpViewer = float4(mul(worldToTangentSpace, output.vViewer.xyz), 1);

    return output;
}
#endif //VERTEX_SHADER

#ifdef PIXEL_SHADER
//------------------------------------------------------------
//  PixelShader: generic (Dif x Dif2)+Bump+SpecMap+Refl;
//------------------------------------------------------------
float4 mainPS(in VS_OUTPUT v) : COLOR0
{
    float4 oColor;
    float4 CONST_TEXEL   = float4(1,1,1,1);
    float4 BUMPMAP_TEXEL = tex2D(BUMPMAP_SOURCE, BUMPMAP_UV_SOURCE*g_bumpConfig.zw);
    float4 DETAIL_TEXEL  = tex2D(DETAIL_SOURCE, DETAIL_UV_SOURCE*g_diffConfig.zw);
    float4 DETAIL2_TEXEL = tex2D(DETAIL2_SOURCE, DETAIL2_UV_SOURCE*g_diff2Config.zw);
    float4 VCOLOR_TEXEL  = v.vColor;
    float4 PERVERTEXCOLOR = lerp(1, VCOLOR_TEXEL, g_deform.z);
    float4 MASK_TEXEL    = tex2D(MASK_SOURCE, MASK_UV_SOURCE*g_maskConfig.zw)*g_maskConfig.x*(MASK_INPUT_MASK);
    DETAIL_TEXEL  = lerp(DETAIL_TEXEL,  tex2D(g_DiffuseTrans, DETAIL_UV_SOURCE*g_diffConfig.zw), DETAIL_TRANSITION);
    DETAIL2_TEXEL = lerp(DETAIL2_TEXEL, tex2D(g_Diffuse2Trans, DETAIL2_UV_SOURCE*g_diff2Config.zw), DETAIL2_TRANSITION);
    BUMPMAP_TEXEL = lerp(BUMPMAP_TEXEL, tex2D(g_BumpMapTrans, BUMPMAP_UV_SOURCE*g_bumpConfig.zw), BUMPMAP_TRANSITION);

    float3 normal = normalize(v.vNormal.xyz);
    float3 bumpNormal = normalize(2*(BUMPMAP_INPUT*(BUMPMAP_INPUT_MASK))-1);
    float3 bumpLight = normalize(v.vBumpLit.xyz);
#ifdef DIFFUSE2_TOP_DISPLACE
    bumpNormal = normalize(bumpNormal + (((DETAIL2_INPUT)*2)-1)*g_diff2Config.x*(DETAIL2_INPUT_MASK));
#endif
    
    //
    // regular vs bump-mapped normals and light:
    // float4 LightTemp is [non-bump diff, non-bump spec, bump-diff, bump spec]
#ifdef SPECULAR_ENABLED
    float4 specData;
    specData.xy = float2(dot(-g_lightDir.xyz, normal), dot(normal, normalize(v.vViewer.xyz-g_lightDir.xyz)));
    specData.zw = float2(dot(bumpLight, bumpNormal), dot(bumpNormal, normalize(bumpLight+v.vBumpViewer.xyz)));
    float4 LightTemp = float4(
                    saturate(specData.x), 
                    lit(specData.x, specData.y, g_colors[2].a).z,
                    saturate(specData.z),
                    lit(specData.z, specData.w, g_colors[2].a).z); 
    
#else
    float4 LightTemp = float4(
                    saturate(dot(-g_lightDir.xyz, normal)), 
                    0,
                    saturate(dot(bumpLight, bumpNormal)),
                    0); 
#endif //SPECULAR_ENABLED
    // alter diffuse light factor by ambient illumitaion addon:
    LightTemp.x = saturate(LightTemp.x + (g_ambientLight.r + g_ambientLight.g + g_ambientLight.b)/3);
    LightTemp.z = saturate(LightTemp.z + (g_ambientLight.r + g_ambientLight.g + g_ambientLight.b)/3);

    //angular level (.z - final (after angular level), .w - initial)
    float4 Temp   = float4(1,1,1,
                           lerp(saturate(dot(v.vViewer.xyz, normal)), saturate(dot(v.vBumpViewer, bumpNormal)), g_bumpConfig.x));
    
    if (g_bumpConfig.y >= 0)
      Temp.z = lerp(1, Temp.w, g_bumpConfig.y)*g_bumpConfig.x;
    else
      Temp.z = lerp(1, 1-Temp.w, abs(g_bumpConfig.y))*g_bumpConfig.x;

    float3 fDiffuse1Color   = DETAIL_INPUT;
    float3 fDiffuse2Color   = DETAIL2_INPUT;

    if (g_diffConfig.y >= 0)
      Temp.x = lerp(1, Temp.z, g_diffConfig.y)*g_diffConfig.x*(DETAIL_INPUT_MASK);
    else
      Temp.x = lerp(1, 1-Temp.z, abs(g_diffConfig.y))*g_diffConfig.x*(DETAIL_INPUT_MASK);
    if (g_diff2Config.y >= 0)
      Temp.y = lerp(1, Temp.z, g_diff2Config.y)*g_diff2Config.x*(DETAIL2_INPUT_MASK);
    else
      Temp.y = lerp(1, 1-Temp.z, abs(g_diff2Config.y))*g_diff2Config.x*(DETAIL2_INPUT_MASK);

    //
    // advanced diffuse color, and shine/opacity overload controllers:
    ADVANCED_COLOR_DIFFUSELEVEL(fAdvColorLevels)
    ADVANCED_COLOR_DIFFUSEVAR(fAdvancedDiffuseColor, fAdvColorLevels)
    ADVANCED_COLOR_EFFECTLEVELS(fEffectLevels)
    ADVANCED_COLOR_EFFECTVAR(fEffectColor, fEffectLevels)
    ADVANCED_COLOR_OPTIONS(advShineOpac, fEffectLevels, fAdvColorLevels)
    
    float3 fFinalDiffuseColor = fAdvancedDiffuseColor*PERVERTEXCOLOR.rgb*fDiffuse1Color;

    fFinalDiffuseColor = 
#if defined(DIFFUSE2_TOP_MULT)
      lerp(1, fFinalDiffuseColor, Temp.x)*lerp(1, fDiffuse2Color, Temp.y);
#elif defined(DIFFUSE2_TOP_MIX)
      lerp(1, fFinalDiffuseColor*Temp.x + fDiffuse2Color*Temp.y, saturate(Temp.x+Temp.y));
#elif defined(DIFFUSE2_TOP_LERP)
      lerp(lerp(1, fFinalDiffuseColor, Temp.x), fDiffuse2Color, Temp.y);
#elif defined(DIFFUSE2_TOP_OVERLAY)
      saturate(lerp(1, fFinalDiffuseColor, Temp.x)*(0.5+lerp(0.5, fDiffuse2Color, Temp.y)));
#elif defined (DIFFUSE2_TOP_DISPLACE)
      lerp(1, fFinalDiffuseColor, Temp.x);
#else
      lerp(1, fFinalDiffuseColor, Temp.x) + fDiffuse2Color*Temp.y;
#endif

    // diffuse level (with respect to bump level/angular)
    Temp.x = lerp(LightTemp.x, LightTemp.z, Temp.z); 

    // specular level (with respect to bump level/angular)
    Temp.y = lerp(LightTemp.y, LightTemp.w, Temp.z); 

    float3 fSpecularColor = g_colors[2].rgb*(Temp.y + Temp.y*(1+Temp.x)*saturate(advShineOpac.g));
    //regular:
    oColor.rgb =
                // ambient: 
                (g_colors[0].rgb + 0.2*PERVERTEXCOLOR.rgb + 0.8*fFinalDiffuseColor*g_ambientLight.rgb)*g_ambientLight.rgb +
                // diffuse component:
                (fFinalDiffuseColor*(1-fEffectColor.a) + fEffectColor.rgb*fEffectColor.a)*max((EMISSIVECOLOR_INPUT_MASK)*advShineOpac.r*4*g_colors[3].a, Temp.x) +
                // matted:
                advShineOpac.r*(
                  // specular component:
                  fSpecularColor +
                  // emissive component:
                  g_colors[3].rgb*(EMISSIVECOLOR_INPUT_MASK)*g_colors[3].a
                );

#ifdef ALPHABLEND_ENABLED
    if (g_alpha.w >= 0)
      Temp.x = lerp(1, Temp.z, g_alpha.w);
    else
      Temp.x = lerp(1, 1-Temp.z, abs(g_alpha.w));
    oColor.a = saturate(lerp(1, ALPHABLEND_INPUT, g_alpha.z)*ALPHABLEND_VERTEXCOLOR*Temp.x*g_alpha.y + 
                        advShineOpac.b + length(fSpecularColor)*0.5);
#else
    oColor.a = g_alpha.y;
#endif//ALPHABLEND_ENABLED
#ifdef ALPHATEST_ENABLED
    clip(oColor.a - g_alpha.x);
#endif//ALPHATEST_ENABLED

    return oColor;
}
#endif //PIXEL_SHADER

