#ifndef _SPI_FLASH_H_
#define _SPI_FLASH_H_

//#include "stm32f10x_type.h"
//#include "stm32f10x_lib.h"
//#include "stm32.h"
#include "stm32f10x.h"
//#include "Fat_Disk.h"

#define FLASHOVERTIMECNT        4//ʱڱFLASH

/*
#define FLASH_CHREAD 0x0B
#define FLASH_CLREAD 0x03
#define FLASH_PREAD	0xD2

#define FLASH_BUFWRITE1 0x84
#define FLASH_IDREAD 0x9F
#define FLASH_STATUS 0xD7
#define PAGE_ERASE 0x81
#define PAGE_READ 0xD2
#define MM_PAGE_TO_B1_XFER 0x53				// 洢ָҳݼصһ
#define BUFFER_2_WRITE 0x87					// дڶ
#define B2_TO_MM_PAGE_PROG_WITH_ERASE 0x86	// ڶд洢ģʽ
*/
#define FAT_SECTOR_SIZE 				4096
#define FAT_SECTOR_NUM					1536//256*6M=1536
#define FLASH_SECTOR_SIZE				4096
#define FLASH_PAGE_SIZE					256//һҳС
#define FLASH_PAGE_SNUM					16//һҳ
#define FLASH_SECTOR_SIZE				FAT_SECTOR_SIZE//4096//һС
#define FLASH_SECTOR_COUNT			FAT_SECTOR_NUM//2048//,8M=4096*2048
#define FLASH_BLOCK_SIZE				16//һ
#define FLASH_PAGES_PER_SECTOR	FLASH_SECTOR_SIZE/FLASH_PAGE_SIZE//һҳ
#define FLASH_ERASE_PAGE_SIZE		4096//һҳС
#define FLASH_BUF_SIZE					256//FlashоƬһݴС
typedef enum
{//*ΪƬѡNSS1Byteǰ,֮
	SF_CMD_WREN=0X06,//дʹ*
	SF_CMD_WRDIS=0X04,//дֹ*
	SF_CMD_RDID1=0X9F,//ID
	SF_CMD_RDID2=0X9E,
	SF_CMD_RDSR=0X05,//״̬Ĵ
	SF_CMD_WRSR=0X01,//д״̬Ĵ*
	SF_CMD_WRLR=0XE5,//д*
	SF_CMD_RDLR=0XE8,//
	SF_CMD_RDDB=0X03,//ֽ
	SF_CMD_RDDBHS=0X0B,//ٶֽ
	SF_CMD_DOFRD=0X3B,//˫ٶ
	SF_CMD_RDOTP=0X4B,//ֽ
	SF_CMD_PROOTP=0X42,//ֽڱ*
	SF_CMD_PP=0X02,//ҳ*
	SF_CMD_DIFP=0XA2,//˫ٱ*
	SF_CMD_SUBSERASE=0X20,//4K*
	SF_CMD_SERASE=0XD8,//4K*16=64K
	SF_CMD_BULKERASE=0XC7,//ȫ*
	SF_CMD_DPD=0XB9,//˯*
	SF_CMD_RDPD=0XAB//
}SPI_FLASH_CMD_DEFINED;
#define SF_SR_BUSY		0X01//0x03
#define SF_SR_WIP			0X01//Write in progress bit
#define SF_SR_WEL			0X02//Write enable latch bit
#define SF_SR_BP012		0X1C//Block protect bits
#define SF_SR_TB			0X20//Top/bottom bit
#define SF_SR_SRWD  	0X80//Status register write protect
//Dataflashָ
#define Cmd_DF_PageRead         0xD2
#define Cmd_DF_Buffer1Read      0xD1
#define Cmd_DF_Buffer2Read      0xD3
#define Cmd_DF_WriteBuffer1     0x84
#define Cmd_DF_WriteBuffer2     0x87
#define Cmd_DF_Buffer1ToPage  	0x83
#define Cmd_DF_Buffer2ToPage  	0x86
#define Cmd_DF_PageErase        0x81
#define Cmd_DF_BlockErase       0x50
#define Cmd_DF_SectorErase      0x7C
#define Cmd_DF_AllErase         0xC7
#define Cmd_DF_ReadState        0xD7
#define Cmd_DF_ReadID           0x9F

#define Dummy_Byte 0xA5

extern u8 Select_FlashFlag;
// Select SPI FLASH: ChipSelect pin low
#define Select_Flash()      {/*while(Select_FlashFlag);Select_FlashFlag=1;*/GPIO_ResetBits(GPIOB,GPIO_Pin_12);}
// Deselect SPI FLASH: ChipSelect pin high
#define NotSelect_Flash()   {/*if(Select_FlashFlag)Select_FlashFlag=0;*/GPIO_SetBits(GPIOB,GPIO_Pin_12);}

typedef enum
{
	SPI_NONE=0,
	SPI_SUCCESS,
	SPI_ERROR,
	SPI_OVERTIME
}SPI_FLASH_DEFINED;

void sFlash_Init(void);	//SPIʼ
u8 sFlash_ReadByte(void);		//flashһֽ
u8 sFlash_SendByte(u8 byte);		//	FLASHһֽ
void sFlashPageEarse(u16 page);	//ָҳ,ҳΧ0-4095

void sFlashPageRead(u16 page,u8 *Data);		//ȡҳҳΧ0-4095
//void sFlashPageWrite1(u16 page,u8 *Data);		//дһҳҳΧ0-4095
u8 sFlashPageWrite1(u16 page,u8 *Data);		//дһҳҳΧ0-4095
void sFlashPageWrite2(u16 page, u8 * Data);

//void sFlashWaitBusy(void);			//Flashæ
u8 sFlashWaitBusy(void);			//Flashæ20140329
void sFlashReadID(u8 *ProdustID);		//ȡflashIDĸֽ
u8 sFlashReadState(void);	
void sFlashModity512bytes(void);
u8 sFlashMultiRead(u8 *buf,u32 addr,u16 page_len);

u8 sFlash_WriteSector(u32 nSector, u8* pBuffer);
u8 SPI_Flash_Erase_Sector(u32 Dst_Addr);

u8 sFlash_ReadMultiBytes(u32 Addr,u16 lenght,u8* pBuffer);
u8 sFlash_WriteMultiBytes(u32 Addr,u16 lenght,u8* pBuffer);
u8 sFlash_Read_Sector(u32 nSector, u8* pBuffer);
u8 sFlash_SetReadStartAddr(u32 mAddr);
u8 sFlash_WaitReadSectorFinsh(void);
u8 sFlash_WaitReadFinsh(void);
#endif
