#ifndef __jmkernel_H__
#define __jmkernel_H__

#ifdef __cplusplus
  extern "C" {
#endif

#include "stm32f0xx_hal.h"
#include "cmsis_os.h"
#include "usb_device.h"
#include "app_eeprom.h"
#include "I2C_Soft.h"

//LEDƶ
#define ON_LED1 GPIOA->BSRR = (uint32_t)GPIO_PIN_8;
#define ON_LED2 GPIOB->BSRR = (uint32_t)GPIO_PIN_15;
#define ON_LED3 GPIOB->BSRR = (uint32_t)GPIO_PIN_2;
#define ON_LED4 GPIOF->BSRR = (uint32_t)GPIO_PIN_1;
#define ON_LED5 GPIOF->BSRR = (uint32_t)GPIO_PIN_0;
#define ON_LED6 GPIOC->BSRR = (uint32_t)GPIO_PIN_15;
#define ON_LED7 GPIOC->BSRR = (uint32_t)GPIO_PIN_14;
#define ON_LED8 GPIOC->BSRR = (uint32_t)GPIO_PIN_13;
#define OFF_LED1 GPIOA->BRR = (uint32_t)GPIO_PIN_8;
#define OFF_LED2 GPIOB->BRR = (uint32_t)GPIO_PIN_15; 
#define OFF_LED3 GPIOB->BRR = (uint32_t)GPIO_PIN_2;
#define OFF_LED4 GPIOF->BRR = (uint32_t)GPIO_PIN_1;
#define OFF_LED5 GPIOF->BRR = (uint32_t)GPIO_PIN_0;
#define OFF_LED6 GPIOC->BRR = (uint32_t)GPIO_PIN_15;
#define OFF_LED7 GPIOC->BRR = (uint32_t)GPIO_PIN_14;
#define OFF_LED8 GPIOC->BRR = (uint32_t)GPIO_PIN_13;

//RGBɫʱ
#define Send_IC_Low_Code()    do{GPIOB->BSRR = (uint32_t)GPIO_PIN_9;__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();GPIOB->BRR = (uint32_t)GPIO_PIN_9;__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();}while(0)
#define Send_IC_High_Code()    do{GPIOB->BSRR = (uint32_t)GPIO_PIN_9;__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();GPIOB->BRR = (uint32_t)GPIO_PIN_9;__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();}while(0)
#define Send_IC_Code_Reset()  do{GPIOB->BRR = (uint32_t)GPIO_PIN_9;osDelay(10);}while(0)

#define ON 1
#define OFF 0

//ңK1\K2
#define key1 !HAL_GPIO_ReadPin(GPIOB,GPIO_PIN_12)
#define key2 !HAL_GPIO_ReadPin(GPIOA,GPIO_PIN_0)

void functionsfinish(void);
void SetWaitForTime(float a);
void Send_LEDData_32Bits(uint32_t dat);
void PWM_init(void);
void Setmotorspeed(uint8_t which,int speed);
void onoff8LED(uint8_t which,uint8_t a);
void Beep(uint32_t state);
void BeepMusic(uint16_t BeepHz);
uint32_t BluetoothPhoneControl(void);
void Servo(uint8_t which, int angle);
void ADC_init(void);
uint32_t readADC(uint8_t which);
uint32_t ReadMIC(void);
void SetSystemTime(void);
uint32_t GetSystemTime(void);
void maininit(void);

void HAL_UART_RxCpltCallback(UART_HandleTypeDef *huart);
void HAL_TIM_IC_CaptureCallback(TIM_HandleTypeDef *htim);


//
//----------------------------------------------
#define TONE_0  -1		//0
//----------------------------------------------
#define TONE_AL1 221	//A 1
#define TONE_AL2 248	//          .
#define TONE_AL3 278
#define TONE_AL4 294
#define TONE_AL5 330
#define TONE_AL6 371
#define TONE_AL7 416

#define TONE_BL1 248
#define TONE_BL2 278
#define TONE_BL3 294
#define TONE_BL4 330
#define TONE_BL5 371
#define TONE_BL6 416
#define TONE_BL7 467

#define TONE_CL1 131
#define TONE_CL2 147
#define TONE_CL3 165
#define TONE_CL4 175
#define TONE_CL5 221
#define TONE_CL6 248
#define TONE_CL7 278

#define TONE_DL1 147
#define TONE_DL2 165
#define TONE_DL3 175
#define TONE_DL4 196
#define TONE_DL5 221
#define TONE_DL6 248
#define TONE_DL7 178

#define TONE_EL1 165
#define TONE_EL2 175
#define TONE_EL3 196
#define TONE_EL4 221
#define TONE_EL5 248
#define TONE_EL6 278
#define TONE_EL7 312

#define TONE_FL1 175
#define TONE_FL2 196
#define TONE_FL3 221
#define TONE_FL4 234
#define TONE_FL5 262
#define TONE_FL6 294
#define TONE_FL7 330

#define TONE_GL1 196
#define TONE_GL2 221
#define TONE_GL3 234
#define TONE_GL4 262
#define TONE_GL5 294
#define TONE_GL6 330
#define TONE_GL7 371
//----------------------------------------------
#define TONE_A1 441		//A1
#define TONE_A2 495
#define TONE_A3 556
#define TONE_A4 589
#define TONE_A5 661
#define TONE_A6 742
#define TONE_A7 833

#define TONE_B1 495
#define TONE_B2 556
#define TONE_B3 624
#define TONE_B4 661
#define TONE_B5 742
#define TONE_B6 833
#define TONE_B7 935

#define TONE_C1 262
#define TONE_C2 294
#define TONE_C3 330
#define TONE_C4 350
#define TONE_C5 393
#define TONE_C6 441
#define TONE_C7 495

#define TONE_D1 294
#define TONE_D2 330
#define TONE_D3 350
#define TONE_D4 393
#define TONE_D5 441
#define TONE_D6 495
#define TONE_D7 556

#define TONE_E1 330
#define TONE_E2 350
#define TONE_E3 393
#define TONE_E4 441
#define TONE_E5 495
#define TONE_E6 556
#define TONE_E7 624

#define TONE_F1 350
#define TONE_F2 393
#define TONE_F3 441
#define TONE_F4 495
#define TONE_F5 556
#define TONE_F6 624
#define TONE_F7 661

#define TONE_G1 393
#define TONE_G2 441
#define TONE_G3 495
#define TONE_G4 556
#define TONE_G5 624
#define TONE_G6 661
#define TONE_G7 742
//----------------------------------------------
#define TONE_AH1 882		//A .
#define TONE_AH2 990		//			1
#define TONE_AH3 1112
#define TONE_AH4 1178
#define TONE_AH5 1322
#define TONE_AH6 1484
#define TONE_AH7 1665

#define TONE_BH1 990
#define TONE_BH2 1112
#define TONE_BH3 1178
#define TONE_BH4 1322
#define TONE_BH5 1484
#define TONE_BH6 1665
#define TONE_BH7 1869

#define TONE_CH1 525
#define TONE_CH2 589
#define TONE_CH3 661
#define TONE_CH4 700
#define TONE_CH5 786
#define TONE_CH6 882
#define TONE_CH7 990

#define TONE_DH1 589
#define TONE_DH2 661
#define TONE_DH3 700
#define TONE_DH4 786
#define TONE_DH5 882
#define TONE_DH6 990
#define TONE_DH7 1112

#define TONE_EH1 661
#define TONE_EH2 700
#define TONE_EH3 786
#define TONE_EH4 882
#define TONE_EH5 990
#define TONE_EH6 1112
#define TONE_EH7 1284

#define TONE_FH1 700
#define TONE_FH2 786
#define TONE_FH3 882
#define TONE_FH4 935
#define TONE_FH5 1049
#define TONE_FH6 1178
#define TONE_FH7 1322

#define TONE_GH1 786
#define TONE_GH2 882
#define TONE_GH3 990
#define TONE_GH4 1049
#define TONE_GH5 1178
#define TONE_GH6 1322
#define TONE_GH7 1484
//----------------------------------------------
#define DOUBLE		2 
#define WHOLE 		1
#define HALF 		0.5
#define QUARTER 	0.25
#define EIGHTH 		0.125
#define SIXTEENTH 	0.0625

//ⲿӢĶӦӣҲȽϺÿ

#ifdef __cplusplus
}
#endif

#endif /* __jmkernel_H__ */

