//*********************************************************
//        Joinmax Digital Module library 1.0
//*********************************************************
// File                 : JMLib.c 
// Version              :  V1.0
// Compiler             : GCCARM
// Target               : STM32F407VGT6
// Author               : LXW
// Support telephone    : +86 20 84134792 (JoinMax digital)
// Support fax          : +86 20 84134890 (JoinMax digital)
//********************  Module List  **********************
// 
//*********************************************************
//IICģĵַ
//BE-1727 :  0x02 GetCompoI
//BE-2615 :  0x76   GetCompassB
//BE-6303 :  0x04   GetUltrasound
//BE-6305 :  0X06   GetShortIRDist
//BE-1319 :  0X08   SetIRBoard
//BE-2620 :  0XA6   GetGSensor
//BE-1151 :  0XA1 GetAirQuality
//BE-2205 :  0X0E   SetMusicPlayer
//BE-2621 :  0X3A GetAHRS  SetAHRS
//BE-1131 :  0X350  GetColorSensor SetColorSensor
//BE-1141 :  0XA8 GetColorSensor SetColorSensor
//BE-1245 :  0X52 GetLaserDist

//**********************  HISTORY  ************************


#include "stm32f4xx_hal.h"
#include <math.h>
#include "Pinformat.h"
#include <LCD_COLOR.h>
#include "jmdmath.h"
#include "jmdos.h"






#ifndef _TC_VAR_
#define _TC_VAR_
volatile uint32_t TouchClicks[8];
uint8_t Flag_ADS[8]={0,0,0,0,0,0,0,0};
uint8_t _Adc_initdelay=0;
uint16_t _Adc_indicatorlamp=0;
#endif


#if _TOUCH_TO_SCREEN_EN_ > 0
volatile uint8_t TTSC_Flag;
#endif

//==SetNSec Readding ID:  == DON'T DELETE!! ==

#ifdef _SETWAITFORTIME_
 #ifndef  _SETWAITFORTIME_EXISTS_
  #define _SETWAITFORTIME_EXISTS_
  #include <jmkernel.h>
  void SetWaitForTime(float s){

	 uint32_t endtime;
	 endtime=(uint32_t)(s*1000);
	 Delay1ms(endtime);  

  }
 #endif
#endif

#ifdef _SETLIGHTSENSORLED_
#ifndef  _SETLIGHTSENSORLED_EXISTS_
#define _SETLIGHTSENSORLED_EXISTS_
#include <jmkernel.h>

  void SetLightSensorLed(uint8_t which,int state){
   uint32_t port1 = portarray[RcuPORT[which][0]];
   uint32_t port3 = portarray[RcuPORT[which][2]];
   uint8_t bit1=RcuPIN[which][0];
   uint8_t bit3=RcuPIN[which][2];
    uint16_t i;
    uint8_t channel;
    GPIO_Setting((GPIO_TypeDef*)port1,bit1,GPIO_MODE_OUTPUT_PP);
    
    if(state==1)
    {
		 HAL_GPIO_WritePin((GPIO_TypeDef*)port1,(1<<bit1),GPIO_PIN_SET);
		 state=0x80;
    }
    else
    {
		 HAL_GPIO_WritePin((GPIO_TypeDef*)port1,(1<<bit1),GPIO_PIN_RESET);
		 state=0x00;
    }
		Flag_ADS[which-1]=1|state;
  }
 #endif
#endif

#ifdef _SETLIGHTSENSORILAMP_
#ifndef  _SETLIGHTSENSORILAMP_EXISTS_
#define _SETLIGHTSENSORILAMP_EXISTS_
#include <jmkernel.h>

  void SetLightSensorILamp(uint8_t which,int state){
    uint32_t port2 = portarray[RcuPORT[which][1]];
    uint8_t bit2=RcuPIN[which][1];
    uint16_t i;
    uint8_t channel;
		
    GPIO_Setting((GPIO_TypeDef*)port2,bit2,GPIO_MODE_OUTPUT_PP);
    if(state==1)
    {
	 HAL_GPIO_WritePin((GPIO_TypeDef*)port2,(1<<bit2),GPIO_PIN_SET);
    }
    else
    {
	 HAL_GPIO_WritePin((GPIO_TypeDef*)port2,(1<<bit2),GPIO_PIN_RESET);
    }
		if(((_Adc_indicatorlamp>>(which-1))&0x01)==0)_Adc_indicatorlamp|=(1<<(which-1));
  }
 #endif
#endif


#ifdef _SETLIGHTSENSORTHRESHOLD_
#ifndef  _SETLIGHTSENSORTHRESHOLD_EXISTS_
#define _SETLIGHTSENSORTHRESHOLD_EXISTS_
#include <jmkernel.h>
  void SetLightSensorThreshold(uint8_t which,int Threshold){
   WriteAdcThreshold(which-1,Threshold,1);
  }
 #endif
#endif

#ifdef _GETLIGHTSENSORTHRESHOLD_
#ifndef  _GETLIGHTSENSORTHRESHOLD_EXISTS_
#define _GETLIGHTSENSORTHRESHOLD_EXISTS_
#include <jmkernel.h>
  uint16_t GetLightSensorThreshold(uint8_t which){
   return ReadAdcThreshold(which-1);
  }
 #endif
#endif

#ifdef _GETANTILIGHT_
#ifndef  _GETANTILIGHT_EXISTS_
#define _GETANTILIGHT_EXISTS_
#include <jmkernel.h>

  uint16_t GetAntiLight(uint8_t which){
   uint32_t port1 = portarray[RcuPORT[which][0]];
   uint32_t port3 = portarray[RcuPORT[which][2]];
   uint8_t bit1=RcuPIN[which][0];
   uint8_t bit3=RcuPIN[which][2];
    uint16_t m_Value1,m_Value2,m_Value3;
    uint8_t channel;
	RcuWhichMutexTake(which,1,4095);

	GPIO_Setting((GPIO_TypeDef*)port1,bit1,GPIO_MODE_OUTPUT_PP);
	GPIO_Setting((GPIO_TypeDef*)port3,bit3,GPIO_MODE_ANALOG);
    HAL_GPIO_WritePin((GPIO_TypeDef*)port1,(1<<bit1),GPIO_PIN_RESET);
	
    Delay1ms(5);
    m_Value1 = GetAdcResult(which);
	HAL_GPIO_WritePin((GPIO_TypeDef*)port1,(1<<bit1),GPIO_PIN_SET);

    Delay1ms(5);
    m_Value2 = GetAdcResult(which);
    RcuWhichMutexGive(which,1,4095);
    if(m_Value2>m_Value1)
    {
    m_Value3 = m_Value2 - m_Value1; 
    }
    else
    {
    m_Value3 = 0;
    }
    
    return m_Value3;
  }
 #endif
#endif

#ifdef _GETLIGHTSENSOR_
#ifndef  _GETLIGHTSENSOR_EXISTS_
#define _GETLIGHTSENSOR_EXISTS_
#include <jmkernel.h>

uint16_t GetLightSensor(uint8_t which){
uint32_t port1 = portarray[RcuPORT[which][0]];
uint32_t port2 = portarray[RcuPORT[which][1]];
uint32_t port3 = portarray[RcuPORT[which][2]];
uint8_t bit1=RcuPIN[which][0];
uint8_t bit2=RcuPIN[which][1];
uint8_t bit3=RcuPIN[which][2];
uint16_t i;
uint8_t channel;


  GPIO_Setting((GPIO_TypeDef*)port1,bit1,GPIO_MODE_OUTPUT_PP);
  GPIO_Setting((GPIO_TypeDef*)port2,bit2,GPIO_MODE_OUTPUT_PP);
  GPIO_Setting((GPIO_TypeDef*)port3,bit3,GPIO_MODE_ANALOG);

  if(Flag_ADS[which-1]==0)
 {
		RcuWhichMutexTake(which,1,4095);
		HAL_GPIO_WritePin((GPIO_TypeDef*)port1,(1<<bit1),GPIO_PIN_SET);
		Flag_ADS[which-1]=0X81;
    	Delay1ms(10);
		RcuWhichMutexGive(which,1,4095);
 }
   if(_Adc_initdelay==0)
   {
      Delay1ms(1);
	  _Adc_initdelay=1;
   }
   i=GetAdcResult(which);
	if(((_Adc_indicatorlamp>>(which-1))&0x01)==0)
	GPIO_AdcLed2State(which,(GPIO_TypeDef*)port2,bit2,i,1);
    return (uint16_t)i;
  }
 #endif
#endif


#ifdef _GETLIGHTSENSORDATA_
#ifndef  _GETLIGHTSENSORDATA_EXISTS_
#define _GETLIGHTSENSORDATA_EXISTS_
#include <jmkernel.h>
uint16_t ee;

uint16_t GetLightSensorData(uint8_t which)
{
   uint32_t port1 = portarray[RcuPORT[which][0]];
	 uint32_t port2 = portarray[RcuPORT[which][1]];
   uint32_t port3 = portarray[RcuPORT[which][2]];
   uint8_t bit1=RcuPIN[which][0];
	 uint8_t bit2=RcuPIN[which][1];
   uint8_t bit3=RcuPIN[which][2];
    uint16_t i,th;
    uint8_t channel;
	
    GPIO_Setting((GPIO_TypeDef*)port1,bit1,GPIO_MODE_OUTPUT_PP);
	GPIO_Setting((GPIO_TypeDef*)port2,bit2,GPIO_MODE_OUTPUT_PP);
	GPIO_Setting((GPIO_TypeDef*)port3,bit3,GPIO_MODE_ANALOG);

	  if(Flag_ADS[which-1]==0)
		{
			RcuWhichMutexTake(which,1,4095);
			HAL_GPIO_WritePin((GPIO_TypeDef*)port1,(1<<bit1),GPIO_PIN_SET);
			Flag_ADS[which-1]=0X81;
	    	Delay1ms(5);
			RcuWhichMutexGive(which,1,4095);
		}
	   if(_Adc_initdelay==0)
	   {
	      Delay1ms(1);
		  _Adc_initdelay=1;
	   }
  	  	 i=GetAdcResult(which);
		th=ReadAdcThreshold(which-1);

		if(i<th)
		{
			i=1;
			if(((_Adc_indicatorlamp>>(which-1))&0x01)==0)
			HAL_GPIO_WritePin((GPIO_TypeDef*)port2,(1<<bit2),GPIO_PIN_SET);
		}
		else 
		{
			i=0;
			if(((_Adc_indicatorlamp>>(which-1))&0x01)==0)
			HAL_GPIO_WritePin((GPIO_TypeDef*)port2,(1<<bit2),GPIO_PIN_RESET);
		}
    return (uint16_t)i;
  }
 #endif
#endif
#ifdef _SETWAITFORDARK_
#ifndef  _SETWAITFORDARK_EXISTS_
#define _SETWAITFORDARK_EXISTS_
#include <jmkernel.h>

  void SetWaitforDark(uint8_t which,uint16_t value){
   uint32_t port1 = portarray[RcuPORT[which][0]];
	 uint32_t port2 = portarray[RcuPORT[which][1]];
   uint32_t port3 = portarray[RcuPORT[which][2]];
   uint8_t bit1=RcuPIN[which][0];
	 uint8_t bit2=RcuPIN[which][1];
   uint8_t bit3=RcuPIN[which][2];
    uint16_t i;
    uint8_t channel;
		
    GPIO_Setting((GPIO_TypeDef*)port1,bit1,GPIO_MODE_OUTPUT_PP);
	GPIO_Setting((GPIO_TypeDef*)port2,bit2,GPIO_MODE_OUTPUT_PP);
	GPIO_Setting((GPIO_TypeDef*)port3,bit3,GPIO_MODE_ANALOG);

    if(Flag_ADS[which-1]==0)
	{
		RcuWhichMutexTake(which,1,4095);
		HAL_GPIO_WritePin((GPIO_TypeDef*)port1,(1<<bit1),GPIO_PIN_SET);
		Flag_ADS[which-1]=0X81;
        Delay1ms(5);
		RcuWhichMutexGive(which,1,4095);
	}

	do
	{  
	    if(_Adc_initdelay==0)
	   {
	      Delay1ms(1);
		  _Adc_initdelay=1;
	   }
    	i=GetAdcResult(which);
	}while(i>value);
	
  }
 #endif
#endif

#ifdef _SETWAITFORLIGHT_
#ifndef  _SETWAITFORLIGHT_EXISTS_
#define _SETWAITFORLIGHT_EXISTS_
#include <jmkernel.h>

  uint16_t SetWaitforLight(uint8_t which,uint16_t value){
   uint32_t port1 = portarray[RcuPORT[which][0]];
	 uint32_t port2 = portarray[RcuPORT[which][1]];
   uint32_t port3 = portarray[RcuPORT[which][2]];
   uint8_t bit1=RcuPIN[which][0];
	 uint8_t bit2=RcuPIN[which][1];
   uint8_t bit3=RcuPIN[which][2];
    uint16_t i;
    uint8_t channel;
		
    GPIO_Setting((GPIO_TypeDef*)port1,bit1,GPIO_MODE_OUTPUT_PP);
	GPIO_Setting((GPIO_TypeDef*)port2,bit2,GPIO_MODE_OUTPUT_PP);
	GPIO_Setting((GPIO_TypeDef*)port3,bit3,GPIO_MODE_ANALOG);

    if(Flag_ADS[which-1]==0)
	{
		RcuWhichMutexTake(which,1,4095);
		HAL_GPIO_WritePin((GPIO_TypeDef*)port1,(1<<bit1),GPIO_PIN_SET);
		Flag_ADS[which-1]=0X81;
        Delay1ms(5);
		RcuWhichMutexGive(which,1,4095);
	}

	do
	{   
	   if(_Adc_initdelay==0)
	   {
	      Delay1ms(1);
		  _Adc_initdelay=1;
	   }
    	i=GetAdcResult(which);
	}while(i<value);
	
  }
 #endif
#endif

#ifdef _SETWAITFORDARKER_
#ifndef  _SETWAITFORDARKER_EXISTS_
#define _SETWAITFORDARKER_EXISTS_
#include <jmkernel.h>

  uint16_t SetWaitforDarker(uint8_t which,uint16_t value){
   uint32_t port1 = portarray[RcuPORT[which][0]];
	 uint32_t port2 = portarray[RcuPORT[which][1]];
   uint32_t port3 = portarray[RcuPORT[which][2]];
   uint8_t bit1=RcuPIN[which][0];
	 uint8_t bit2=RcuPIN[which][1];
   uint8_t bit3=RcuPIN[which][2];
    uint16_t i,temp;
    uint8_t channel;
		
    GPIO_Setting((GPIO_TypeDef*)port1,bit1,GPIO_MODE_OUTPUT_PP);
	GPIO_Setting((GPIO_TypeDef*)port2,bit2,GPIO_MODE_OUTPUT_PP);
	GPIO_Setting((GPIO_TypeDef*)port3,bit3,GPIO_MODE_ANALOG);
    if(Flag_ADS[which-1]==0)
	{
		RcuWhichMutexTake(which,1,4095);
		HAL_GPIO_WritePin((GPIO_TypeDef*)port1,(1<<bit1),GPIO_PIN_SET);
		Flag_ADS[which-1]=0X81;
        Delay1ms(5);
		RcuWhichMutexGive(which,1,4095);
	}
    if(_Adc_initdelay==0)
    {
       Delay1ms(1);
 	  _Adc_initdelay=1;
    }
	temp = GetAdcResult(which);
	do
	{   
    	i=GetAdcResult(which);
	}while(i>(temp-value));
	
  }
 #endif
#endif

#ifdef _SETWAITFORLIGHTER_
#ifndef  _SETWAITFORLIGHTER_EXISTS_
#define _SETWAITFORLIGHTER_EXISTS_
#include <jmkernel.h>

  uint16_t SetWaitforLighter(uint8_t which,uint16_t value){
   uint32_t port1 = portarray[RcuPORT[which][0]];
	 uint32_t port2 = portarray[RcuPORT[which][1]];
   uint32_t port3 = portarray[RcuPORT[which][2]];
   uint8_t bit1=RcuPIN[which][0];
	 uint8_t bit2=RcuPIN[which][1];
   uint8_t bit3=RcuPIN[which][2];
    uint16_t i,temp;
    uint8_t channel;
		
    GPIO_Setting((GPIO_TypeDef*)port1,bit1,GPIO_MODE_OUTPUT_PP);
	GPIO_Setting((GPIO_TypeDef*)port2,bit2,GPIO_MODE_OUTPUT_PP);
    GPIO_Setting((GPIO_TypeDef*)port3,bit3,GPIO_MODE_ANALOG);
    if(Flag_ADS[which-1]==0)
	{
	RcuWhichMutexTake(which,1,4095);
	HAL_GPIO_WritePin((GPIO_TypeDef*)port1,(1<<bit1),GPIO_PIN_SET);
	Flag_ADS[which-1]=0X81;
	Delay1ms(5);
	RcuWhichMutexGive(which,1,4095);
	}
    if(_Adc_initdelay==0)
    {
       Delay1ms(1);
 	  _Adc_initdelay=1;
    }
	temp = GetAdcResult(which);
	do
	{
    	i=GetAdcResult(which);
	}while(i<(temp+value));
	
  }
 #endif
#endif


#ifdef _GETTOUCH_
 #ifndef  _GETTOUCH_EXISTS_
  #define _GETTOUCH_EXISTS_
  #include <jmkernel.h>

  uint16_t GetTouch(uint8_t which){
   uint32_t port1=portarray[RcuPORT[which][0]];//I2C_SCL
   uint8_t bit1=RcuPIN[which][0];
   GPIO_Setting((GPIO_TypeDef*)port1,bit1,GPIO_MODE_INPUT);

    uint8_t value=HAL_GPIO_ReadPin((GPIO_TypeDef*)port1,(1<<bit1));
    if(value) return 0;
    else      return 1;
  }
 #endif
#endif

#ifdef _GETTOUCHA_
 #ifndef  _GETTOUCHA_EXISTS_
  #define _GETTOUCHA_EXISTS_
  #include <jmkernel.h>

uint16_t GetTouchA(uint8_t which)
{
   uint32_t port1=portarray[RcuPORT[which][1]];//I2C_SDA
   uint8_t bit1=RcuPIN[which][1];
   GPIO_Setting((GPIO_TypeDef*)port1,bit1,GPIO_MODE_INPUT);

    uint8_t value=HAL_GPIO_ReadPin((GPIO_TypeDef*)port1,(1<<bit1));
    if(value)
      return 0;
    else
      return 1;
  }
 #endif
#endif

#ifdef _GETTOUCHB_
 #ifndef  _GETTOUCHB_EXISTS_
  #define _GETTOUCHB_EXISTS_
  #include <jmkernel.h>

uint16_t GetTouchB(uint8_t which)
{
   uint32_t port1=portarray[RcuPORT[which][2]];//ADC
   uint8_t bit1=RcuPIN[which][2];
   GPIO_Setting((GPIO_TypeDef*)port1,bit1,GPIO_MODE_INPUT);

    uint8_t value=HAL_GPIO_ReadPin((GPIO_TypeDef*)port1,(1<<bit1));
    if(value)    return 0;
    else   return 1;
  }
 #endif
#endif



#ifdef _SETLCDBACK_
 #ifndef  _SETLCDBACK_EXISTS_
  #define _SETLCDBACK_EXISTS_
  #include <jmkernel.h>
  #include "LCD320240.h"
void SetLCDBack(uint8_t led)
{
	GPIO_Setting(LCD_BACKLED_GPIO,LCD_BACKLED_PIN,GPIO_MODE_OUTPUT_PP);//3??????
	SetBackLed(led);
	g_LcdBackLignt=led;
}
 #endif
#endif


#ifdef _SETFONTSIZE_
 #ifndef  _SETFONTSIZE_EXISTS_
  #define _SETFONTSIZE_EXISTS_
void SetFontSize(uint8_t size)//0(С8X16)/1(32X32)/2(64X64)/3(128X128)/4(256X256)
{
	SetFlashFontSize(size);
}
 #endif
#endif

#ifdef _GETDISPLAYPIXEL_
 #ifndef  _GETDISPLAYPIXEL_EXISTS_
  #define _GETDISPLAYPIXEL_EXISTS_
uint8_t GetDisplayPixel(uint8_t x,uint16_t y)//ʾ1
{
	return RedOneFontXYpixel(x, y);
}
 #endif
#endif


//==SetLCD8Char Readding ID:  == DON'T DELETE!! ==

#ifdef _SETDISPLAYVAR_
#ifndef  _SETDISPLAYVAR_EXISTS_
#define _SETDISPLAYVAR_EXISTS_
#include <jmkernel.h>
#include "LCD320240.h"

void SetDisplayVar(int y,int32_t data,uint16_t ch_color,uint16_t bg_color)
{
	uint16_t Xsize    =  GetFontLibWidth();
    SetBackLed(g_LcdBackLignt);
	switch(Xsize)
  {
	case 8  : Xsize=(GetFontLibWidth()*8)-1;if(y>20)y=20;break;//ʾ20
	case 16 : Xsize=(GetFontLibWidth()*8)-1;if(y>10)y=10;break;
	case 32 : Xsize=(GetFontLibWidth()*7)-1;if(y>5)y=5;break;
	case 64 : Xsize=(GetFontLibWidth()*3)-1;if(y>2)y=2;break;
	case 128 : Xsize=(GetFontLibWidth()*1)-1;if(y>1)y=1;break;
  }  
	LCD_DisplayNum(LCD_Width-Xsize, (y-1)*GetFontLibHeight(),(int32_t)data, ch_color, bg_color,0x8088); 
}
#endif
#endif

//==SetLCD8Char Readding ID:  == DON'T DELETE!! ==

#ifdef _SETDISPLAYVARU32_
#ifndef  _SETDISPLAYVARU32_EXISTS_
#define _SETDISPLAYVARU32_EXISTS_
#include <jmkernel.h>
#include "LCD320240.h"

void SetDisplayVarU32(int y,uint32_t data,uint16_t ch_color,uint16_t bg_color)
{
    uint16_t Xsize    =  GetFontLibWidth();
    SetBackLed(g_LcdBackLignt);
	switch(Xsize)
  {
	case 8  : Xsize=(GetFontLibWidth()*10)-1;if(y>20)y=20;break;//ʾ20
	case 16 : Xsize=(GetFontLibWidth()*10)-1;if(y>10)y=10;break;
	case 32 : Xsize=(GetFontLibWidth()*7)-1;if(y>5)y=5;break;
	case 64 : Xsize=(GetFontLibWidth()*3)-1;if(y>2)y=2;break;
	case 128 : Xsize=(GetFontLibWidth()*1)-1;if(y>1)y=1;break;
  }  
	LCD_DisplayNumU32(LCD_Width-Xsize, (y-1)*GetFontLibHeight(),(uint32_t)data, ch_color, bg_color,0x800A); 
}
#endif
#endif



#ifdef _SETDISPLAYVARXY_
#ifndef  _SETDISPLAYVARXY_EXISTS_
#define _SETDISPLAYVARXY_EXISTS_
#include <jmkernel.h>
#include "LCD320240.h"

void SetDisplayVarXY(int x,int y,int32_t data,uint16_t ch_color,uint16_t bg_color)
{
 	SetBackLed(g_LcdBackLignt);
	LCD_DisplayNum(x,y,(int32_t)data, ch_color, bg_color,0x8088); 
}
#endif
#endif


#ifdef _SETDISPLAYVARIABLE_
#ifndef  _SETDISPLAYVARIABLE_EXISTS_
#define _SETDISPLAYVARIABLE_EXISTS_
#include <jmkernel.h>
#include "LCD320240.h"

void SetDisplayVariable(int x,int y,int32_t data,uint16_t ch_color,uint16_t bg_color)
{
 	SetBackLed(g_LcdBackLignt); 	
	LCD_DisplayNum(x,y,(int32_t)data, ch_color, bg_color,0x8088); 
}
#endif
#endif


//==SetLCD10Char Readding ID:  == DON'T DELETE!! ==
#ifdef _SETDISPLAYVARuint32_t_
#ifndef  _SETDISPLAYVARuint32_t_EXISTS_
#define _SETDISPLAYVARuint32_t_EXISTS_
#include <jmkernel.h>
#include "LCD320240.h"

void SetDisplayVaruint32_t(int y,uint32_t data,uint16_t ch_color,uint16_t bg_color)
{
  SetBackLed(g_LcdBackLignt);
  LCD_DisplayNumuint32_t(LCD_Width-(GetFontLibWidth()*10)-1, (y-1)*GetFontLibHeight(),(uint32_t)data, ch_color, bg_color,0x800A); 
}
#endif
#endif


//==SetLCD10Char Readding ID:  == DON'T DELETE!! ==
#ifdef _SETDISPLAYVARHEX_
#ifndef  _SETDISPLAYVARHEX_EXISTS_
#define _SETDISPLAYVARHEX_EXISTS_
#include <jmkernel.h>
#include "LCD320240.h"

void SetDisplayVarHEX(int y,uint32_t data,uint16_t ch_color,uint16_t bg_color)
{
  SetBackLed(g_LcdBackLignt);
  LCD_DisplayNumuint32_t(0, (y-1)*GetFontLibHeight(),(uint32_t)data, ch_color, bg_color,0x804F); //8λ16
}
#endif
#endif


//==SetDisplayFloat Readding ID:  == DON'T DELETE!! ==
#ifdef _SETDISPLAYFLOAT_
#ifndef  _SETDISPLAYFLOAT_EXISTS_
#define _SETDISPLAYFLOAT_EXISTS_
#include <jmkernel.h>
#include "LCD320240.h"

void SetDisplayFloat(int y,double data,uint16_t ch_color,uint16_t bg_color)
{

   uint16_t Xsize    =  GetFontLibWidth();
   SetBackLed(g_LcdBackLignt);
   switch(Xsize)
  {
	case 8  : Xsize=(GetFontLibWidth()*11)-1;if(y>20)y=20;break;//ʾ20
	case 16 : Xsize=(GetFontLibWidth()*11)-1;if(y>10)y=10;break;
	default : Xsize=(16*11)-1;if(y>10)y=10;break;//16*32
  }  
	LCD_DisplayFloatNum(LCD_Width-Xsize, (y-1)*GetFontLibHeight(),(double)data, ch_color, bg_color,0x0802);  
}

 #endif
#endif

#ifdef _SETLCDCLEAR_
#ifndef  _SETLCDCLEAR_EXISTS_
#define _SETLCDCLEAR_EXISTS_
#include <jmkernel.h>
#include "LCD320240.h"

void SetLCDClear(uint16_t m_color)
{
  LCD_Pant(m_color);
}
#endif
#endif

#ifdef _SETLCDDOT_
#ifndef  _SETLCDDOT_EXISTS_
#define _SETLCDDOT_EXISTS_
#include <jmkernel.h>
#include "LCD320240.h"

void SetLCDDot(uint8_t x,uint16_t y,uint16_t m_color)
{
	SetBackLed(g_LcdBackLignt);
	if(x==0||y==0)return;
#if _TOUCH_TO_SCREEN_EN_ > 0
	uint16_t iy=320-y;
	if(TTSC_Flag)iy=320-y;//if(TTSC_Flag)iy=y;
	else iy=y;
	LCD_DrawPoint((x-1),(iy),m_color);
#else
  //LCD_DrawPoint((x-1),(320-y),m_color);
	LCD_DrawPoint((x-1),(y-1),m_color);
#endif
}
#endif
#endif

#ifdef _SETLCDPICTURE_
#ifndef  _SETLCDPICTURE_EXISTS_
#define _SETLCDPICTURE_EXISTS_
#include <jmkernel.h>
#include "LCD320240.h"

void SetLCDPicture(uint8_t x,uint16_t y,uint8_t num)
{
SetBackLed(g_LcdBackLignt);
  LCD_DrawPicture(x,y,Picture1,YELLOW,BLACK);
}

#endif
#endif

#ifdef _GETCHOICEBOX_
#ifndef _GETCHOICEBOX_EXISTS_
#define _GETCHOICEBOX_EXISTS_
#include <jmkernel.h>
#include "LCD320240.h"

uint8_t GetChoiceBox(uint8_t* words)
{
  uint8_t state=0;
  float m_TouchX,m_TouchY,m_Valid;
  LCD_Pant(BLACK);
  SetBackLed(g_LcdBackLignt);
  LCD_String(0,16,words,YELLOW,BLACK,0);
  LCD_Display4Chioce();

  while(state==0)
  {
		m_TouchX=ReadTouchXFilter();
		m_TouchY=ReadTouchYFilter();
		
   if((m_TouchY>65)&&(m_TouchY<134))
    {
       if((m_TouchX>27)&&(m_TouchX<96))
			{
				state=1;//A
			}
			else if((m_TouchX>143)&&(m_TouchX<212))
			{
				state=2;//B
			}
		}
		else if((m_TouchY>176)&&(m_TouchY<245))
		{
			if((m_TouchX>27)&&(m_TouchX<96))
			{
				state=3;//C
			}
			else if((m_TouchX>143)&&(m_TouchX<212))
			{
				state=4;//D
			}
    }
		Delay1ms(5);
  }
	LCD_Pant(BLACK);
	return state;
}

#endif
#endif

//==SetLCDString Readding ID:  == DON'T DELETE!! ==

#ifdef _SETDISPLAYSTRING_
#ifndef  _SETDISPLAYSTRING_EXISTS_
#define _SETDISPLAYSTRING_EXISTS_
#include <jmkernel.h>
#include "LCD320240.h"

 void SetDisplayString(uint16_t y,int8_t* pic,uint16_t ch_color,uint16_t bg_color)
{
   SetBackLed(g_LcdBackLignt);
   LCD_String(0,(y-1)*GetFontLibHeight(),pic,ch_color,bg_color,0);
}
 #endif
#endif

//==SetLCDStr Readding ID:  == DON'T DELETE!! ==
#ifdef _SETDISPLAYSTR_
#ifndef  _SETDISPLAYSTR_EXISTS_
#define _SETDISPLAYSTR_EXISTS_
#include <jmkernel.h>
#include "LCD320240.h"

 void SetDisplayStr(uint16_t x,uint16_t y,int8_t* pic,uint16_t ch_color,uint16_t bg_color)
{
  SetBackLed(g_LcdBackLignt);
  LCD_String(x,y,pic,ch_color,bg_color,0);
}
 #endif
#endif


//==SetLCDStr Readding ID:  == DON'T DELETE!! ==
#ifdef _SETDISPLAYSTRINGXY_
#ifndef  _SETDISPLAYSTRINGXY_EXISTS_
#define _SETDISPLAYSTRINGXY_EXISTS_
#include <jmkernel.h>
#include "LCD320240.h"

 void SetDisplayStringXY(int x,int y,int8_t* pic,uint16_t ch_color,uint16_t bg_color,uint8_t T)
{
  SetBackLed(g_LcdBackLignt);
  LCD_String(x,y,pic,ch_color,bg_color,T);
}
 #endif
#endif


//==SetLCDClear Readding ID:  == DON'T DELETE!! ==

#ifdef   _SETLCDCLEAR_
#ifndef  _SETLCDCLEAR_EXISTS_
#define  _SETLCDCLEAR_EXISTS_
#include <jmkernel.h>
#include "LCD12864.h"
void SetLCDClear(uint16_t m_color){
    LCD_Pant(m_color);
}
#endif
#endif

#ifdef _SET3CLED_
 #ifndef  _SET3CLED_EXISTS_
  #define _SET3CLED_EXISTS_
  #include <jmkernel.h>

void Set3CLed(uint8_t which,uint16_t Color)
{
   uint32_t port1=portarray[RcuPORT[which][0]];
   uint32_t port2=portarray[RcuPORT[which][1]];
   uint32_t port3=portarray[RcuPORT[which][2]];
   uint8_t bit1=RcuPIN[which][0];
   uint8_t bit2=RcuPIN[which][1];
   uint8_t bit3=RcuPIN[which][2];

   uint8_t RedLed,GreenLed,BlueLed;
RcuWhichMutexTake(which,1,0);
   GPIO_Setting((GPIO_TypeDef*)port1,bit1,GPIO_MODE_OUTPUT_PP);
   GPIO_Setting((GPIO_TypeDef*)port2,bit2,GPIO_MODE_OUTPUT_PP);
   GPIO_Setting((GPIO_TypeDef*)port3,bit3,GPIO_MODE_OUTPUT_PP);

   switch(Color)
	{
	case 0: RedLed=0;GreenLed=0;BlueLed=0;	break;
	case RED:RedLed=1;GreenLed=0;BlueLed=0;	break;
	case 1: RedLed=1;GreenLed=0;BlueLed=0;	break;
	case GREEN:RedLed=0;GreenLed=1;BlueLed=0;	break;
	case 2: RedLed=0;GreenLed=1;BlueLed=0;	break;
	case BLUE:RedLed=0;GreenLed=0;BlueLed=1;	break;
	case 3: RedLed=0;GreenLed=0;BlueLed=1;	break;
	case YELLOW:RedLed=1;GreenLed=1;BlueLed=0;	break;
	case 4: RedLed=1;GreenLed=1;BlueLed=0;	break;
	case PURPLE:RedLed=1;GreenLed=0;BlueLed=1;	break;
	case 5: RedLed=1;GreenLed=0;BlueLed=1;	break;
	case CYAN:RedLed=0;GreenLed=1;BlueLed=1;	break;
	case 6: RedLed=0;GreenLed=1;BlueLed=1;	break;
	case WHITE:RedLed=1;GreenLed=1;BlueLed=1;	break;
	case 7: RedLed=1;GreenLed=1;BlueLed=1;	break;
	}

//o?
   if(RedLed==1)
   HAL_GPIO_WritePin((GPIO_TypeDef*)port1,(1<<bit1),GPIO_PIN_SET);
   else
   	HAL_GPIO_WritePin((GPIO_TypeDef*)port1,(1<<bit1),GPIO_PIN_RESET);
//??
   if(GreenLed==1)
   HAL_GPIO_WritePin((GPIO_TypeDef*)port2,(1<<bit2),GPIO_PIN_SET);
   else
  	HAL_GPIO_WritePin((GPIO_TypeDef*)port2,(1<<bit2),GPIO_PIN_RESET);
//??
   if(BlueLed==1)
   HAL_GPIO_WritePin((GPIO_TypeDef*)port3,(1<<bit3),GPIO_PIN_SET);
   else
   	HAL_GPIO_WritePin((GPIO_TypeDef*)port3,(1<<bit3),GPIO_PIN_RESET);
RcuWhichMutexGive(which,1,0);
  }
 #endif
#endif

#ifdef _SETMOTORPOWER_
 #ifndef _SETMOTORPOWER_EXISTS_
 #define _SETMOTORPOWER_EXISTS_
#include <jmkernel.h>

void SetMotorPower(uint8_t m_Per1,int m_Per2,int m_Per3,int m_Per4)////﹦
{
	g_MotorPowerFlag=1;
	g_M1SpeedPer=m_Per1;//M1
	g_M2SpeedPer=m_Per2;//M2
	g_M3SpeedPer=m_Per3;//M3
	g_M4SpeedPer=m_Per4;//M4
}	
 #endif
#endif


#ifdef _SETMOTOR_
 #ifndef  _SETMOTOR_EXISTS_
 #define _SETMOTOR_EXISTS_
 #include <jmkernel.h>

void SetMotor(uint8_t which,int speed)
{
	uint8_t m_speedper;
	speed=(uint8_t)speed;
	SetMotorNormalMode(which);
	if(g_MotorPowerFlag)//ȡ﹦
	{
		switch(which)
		{
			case 1:m_speedper=g_M1SpeedPer;break;
			case 2:m_speedper=g_M2SpeedPer;break;
			case 3:m_speedper=g_M3SpeedPer;break;
			case 4:m_speedper=g_M4SpeedPer;break;
		}
	}
	if(speed==0)
	{
		SetMotorX(which,1,speed);
	}
	else if(speed<=100)
	{
		if(g_MotorPowerFlag)speed=(uint8_t)((uint16_t)m_speedper*speed/100);
		SetMotorX(which,2,speed);
	}
	else
	{
		speed=256-speed;
		if(g_MotorPowerFlag)speed=(uint8_t)((uint16_t)m_speedper*(speed)/100);
		SetMotorX(which,0,speed);
		//SetMotorX(which,0,256-speed);
	}  
}
 #endif
#endif


#ifdef _SETMOTORFREE_
 #ifndef  _SETMOTORFREE_EXISTS_
 #define _SETMOTORFREE_EXISTS_
 #include <jmkernel.h>

void SetMotorFree(uint8_t which)
{
	MotorFree(which);
}
 #endif
#endif


#ifdef _SETMOTORCODE_
 #ifndef  _SETMOTORCODE_EXISTS_
 #define _SETMOTORCODE_EXISTS_
 #include <jmkernel.h>

void SetMotorCode(uint8_t which)
{
   MotorCodingInit();
   switch(which)
   {
	case 1:SetMotorCnt1Zero();
	break;
	case 2:SetMotorCnt2Zero();
	break;
	case 3:SetMotorCnt3Zero();
	break;
	case 4:SetMotorCnt4Zero();
	break;
   }
}
 #endif
#endif

#ifdef _GETMOTORCODE_
 #ifndef  _GETMOTORCODE_EXISTS_
 #define _GETMOTORCODE_EXISTS_
 #include <jmkernel.h>

volatile int32_t GetMotorCode(uint8_t which)
{
  MotorCodingInit();
  switch(which)
  {
		case 1:return GetMotorCnt1();	break;
		case 2:return GetMotorCnt2();	break;
		case 3:return GetMotorCnt3();	break;
		case 4:return GetMotorCnt4();	break;
  }
}
 #endif
#endif

//==GetSysTime Readding ID:  == DON'T DELETE!! ==

#ifdef _GETSYSTIME_
 #ifndef  _GETSYSTIME_EXISTS_
  #define _GETSYSTIME_EXISTS_
  #include <jmkernel.h>

  uint32_t GetSysTime(void){
  return GetSystemTime();
  }
 #endif
#endif

//==SetSysTime Readding ID:  == DON'T DELETE!! ==

#ifdef _SETSYSTIME_
 #ifndef  _SETSYSTIME_EXISTS_
  #define _SETSYSTIME_EXISTS_
  #include <jmkernel.h>

  void SetSysTime(void){
    SetSystemTime();
  }
 #endif
#endif
//==Getdata Readding eeprom ==

#ifdef _GETDATA_
 #ifndef  _GETDATA_EXISTS_
  #define _GETDATA_EXISTS_
  #include <jmkernel.h>

uint16_t GetData(int dataadr){
  if((dataadr>0)&&(dataadr<=156))
  return ReadEEP(dataadr);
  else
  return 888;
}
 #endif
#endif

//==Setdata write data to eeprom ==

#ifdef _SETDATA_
 #ifndef  _SETDATA_EXISTS_
  #define _SETDATA_EXISTS_
  #include <jmkernel.h>

void SetData(int dataadr,int datacode)
{
	if(datacode>4095)datacode=4095;
	if((dataadr>0)&&(dataadr<=156))
	WriteEEP(dataadr,datacode);
}
 #endif
#endif

//==GetButton1 Readding ID:  == DON'T DELETE!! ==
#ifdef   _GETLEFTBUTTON_
#ifndef  _GETLEFTBUTTON_EXISTS_
#define _GETLEFTBUTTON_EXISTS_
#include <jmkernel.h>
uint8_t GetLeftButton(void)
{  
 GPIO_Setting(GPIOC,15,GPIO_MODE_INPUT);
 uint8_t value=HAL_GPIO_ReadPin(GPIOC,GPIO_PIN_15);
  if(value)      return 0;
  else      return 1;
}
#endif
#endif

//==GetButton2 Readding ID:  == DON'T DELETE!! ==
#ifdef   _GETRIGHTBUTTON_
#ifndef  _GETRIGHTBUTTON_EXISTS_
#define _GETRIGHTBUTTON_EXISTS_
#include <jmkernel.h>
uint8_t GetRightButton(void)
{
 GPIO_Setting(GPIOC,14,GPIO_MODE_INPUT);
 uint8_t value=HAL_GPIO_ReadPin(GPIOC,GPIO_PIN_14);
 if(value)      return 0;
  else      return 1;
}
#endif
#endif


//------------------------------------------
//==SETTOUCHTOSCREENCOORDINATE Readding ID:  == DON'T DELETE!! ==

#ifdef _SETTOUCHTOSCREENCOORDINATE_
 #ifndef  _SETTOUCHTOSCREENCOORDINATE_EXISTS_
  #define _SETTOUCHTOSCREENCOORDINATE_EXISTS_
  
void SetTouchToScreenCoordinate(void)
{
  #if _TOUCH_TO_SCREEN_EN_ > 0
	TTSC_Flag=1;
  #endif
}
 #endif
#endif



#ifdef   _GETTOUCHSCREEN_
#ifndef  _GETTOUCHSCREEN_EXISTS_
#define _GETTOUCHSCREEN_EXISTS_
#include <jmkernel.h>
uint16_t GetTouchScreen(void)
{

	return ReadTouchState();
}
#endif
#endif

#ifdef   _GETTOUCHSCREENX_
#ifndef  _GETTOUCHSCREENX_EXISTS_
#define _GETTOUCHSCREENX_EXISTS_
#include <jmkernel.h>
uint16_t GetTouchScreenX(void)
{
	uint16_t m_value;
	m_value=ReadTouchXFilter();
	#if _TOUCH_TO_SCREEN_EN_ > 0
	if(TTSC_Flag)
	{
		if(m_value>240)m_value=240;
		if(m_value)m_value=241-m_value;
	}
#endif	
   return m_value;
}
#endif
#endif

#ifdef   _GETTOUCHSCREENY_
#ifndef  _GETTOUCHSCREENY_EXISTS_
#define _GETTOUCHSCREENY_EXISTS_
#include <jmkernel.h>
uint16_t GetTouchScreenY(void)
{
  uint16_t m_value;
	m_value=ReadTouchYFilter();
#if _TOUCH_TO_SCREEN_EN_ > 0
	if(TTSC_Flag)
	{
		if(m_value>320)m_value=320;
		if(m_value)m_value=321-m_value;
	}
#endif	
   return m_value;
}
#endif
#endif

#ifdef   _GETINMIC_
#ifndef  _GETINMIC_EXISTS_
#define _GETINMIC_EXISTS_
#include <jmkernel.h>

uint16_t GetInMic(void)
{
uint16_t temp;
temp=ReadInMicVaule();
return temp;
}
#endif
#endif

#ifdef   _SETWAITFORLOUD_
#ifndef  _SETWAITFORLOUD_EXISTS_
#define _SETWAITFORLOUD_EXISTS_
#include <jmkernel.h>

void SetWaitforLoud(int value)
{
	uint16_t temp;
	do
	{
		temp=ReadInMicVaule();
	}while(temp<value);
}
#endif
#endif

#ifdef   _SETWAITFORQUIET_
#ifndef  _SETWAITFORQUIET_EXISTS_
#define _SETWAITFORQUIET_EXISTS_
#include <jmkernel.h>

void SetWaitforQuiet(int value)
{
	uint16_t temp;
	do
	{
		temp=ReadInMicVaule();
	}while(temp>value);
}
#endif
#endif

#ifdef   _SETWAITFORLOUDER_
#ifndef  _SETWAITFORLOUDER_EXISTS_
#define _SETWAITFORLOUDER_EXISTS_
#include <jmkernel.h>

void SetWaitforLouder(int value)
{
uint16_t temp,org;
	org=ReadInMicVaule();
	do
	{
	temp=ReadInMicVaule();
	}while(temp<(org+value));
}
#endif
#endif

#ifdef   _SETWAITFORQUIETER_
#ifndef  _SETWAITFORQUIETER_EXISTS_
#define _SETWAITFORQUIETER_EXISTS_
#include <jmkernel.h>

void SetWaitforQuieter(int value)
{
uint16_t temp,org;
	org=ReadInMicVaule();
	do
	{
	temp=ReadInMicVaule();
	}while(temp>(org-value));
}
#endif
#endif

#ifdef   _GETINVOTAGE_
#ifndef  _GETINVOTAGE_EXISTS_
#define _GETINVOTAGE_EXISTS_
#include <jmkernel.h>

uint16_t GetInVotage(void)
{
uint16_t temp;
uint32_t m_Votage;
temp=ReadInVoltageVaule();
m_Votage=((temp*74)/10+100)/100;
return (uint16_t)m_Votage;
}
#endif
#endif

//==SetLCDBack Readding ID:  == DON'T DELETE!! ==

#ifdef _SETINBEEP_
 #ifndef  _SETINBEEP_EXISTS_
  #define _SETINBEEP_EXISTS_
  #include <jmkernel.h>

void SetInBeep(uint8_t state)
{
  Beep(state);
}
 #endif
#endif


#ifdef _SETMOTORSERVO_
 #ifndef  _SETMOTORSERVO_EXISTS_
  #define _SETMOTORSERVO_EXISTS_
  #include <jmkernel.h>

void SetMotorServo(uint8_t which,int speed,uint32_t Angle)
{
	Angle=abs(Angle);
	Motor_Init();
	MotorCodingInit();
	SetMotorServoMode(which);
	SetCodeServoAngle(which,speed,Angle);
}
 #endif
#endif



#ifdef _SETMOTORSERVO48_
 #ifndef  _SETMOTORSERVO48_EXISTS_
  #define _SETMOTORSERVO48_EXISTS_
  #include <jmkernel.h>

void SetMotorServo48(uint8_t which,int speed,uint32_t Angle)
{
	Angle=abs(Angle);
	Motor_Init();
	MotorCodingInit();
	SetMotorServoMode(which);
	SetCodeServoAngle48(which,speed,Angle);
}
 #endif
#endif

#ifdef _SETMOTORSERVO128_
 #ifndef  _SETMOTORSERVO128_EXISTS_
  #define _SETMOTORSERVO128_EXISTS_
  #include <jmkernel.h>


void SetMotorServo128(uint8_t which,int speed,uint32_t Angle)
{
	Angle=abs(Angle);
	Motor_Init();
	MotorCodingInit();
	SetMotorServoMode(which);
	SetCodeServoAngle128(which,speed,Angle);
}
 #endif
#endif



#ifdef _SETWAITFORANGLE_
 #ifndef  _SETWAITFORANGLE_EXISTS_
  #define _SETWAITFORANGLE_EXISTS_
  #include <jmkernel.h>

void SetWaitForAngle(uint8_t which,int speed,int32_t Angle)
{
	int32_t m_Target=0,m_CV;
	Angle=abs(Angle);
	Motor_Init();
	MotorCodingInit();
	SetMotorServoMode(which);
	SetCodeServoAngle(which,speed,Angle);
	m_Target = GetTMCP(which);

	do
	{
		switch(which)
		{
			case 1:m_CV=GetMotorCnt1();	break;
			case 2:m_CV=GetMotorCnt2();	break;
			case 3:m_CV=GetMotorCnt3();	break;
			case 4:m_CV=GetMotorCnt4();	break;
		}
		if((m_Target>=(m_CV-6))&&(m_Target<=(m_CV+6)))break;
  }while(1);
}
 #endif
#endif


#ifdef _SETWAITFORANGLE48_
 #ifndef  _SETWAITFORANGLE48_EXISTS_
  #define _SETWAITFORANGLE48_EXISTS_
  #include <jmkernel.h>

void SetWaitForAngle48(uint8_t which,int speed,int32_t Angle)
{
	int32_t m_Target=0,m_CV;
	Angle=abs(Angle);
	Motor_Init();
	MotorCodingInit();
	SetMotorServoMode(which);
	SetCodeServoAngle48(which,speed,Angle);
	m_Target = GetTMCP(which);

	do
	{
		switch(which)
		{
			case 1:m_CV=GetMotorCnt1();	break;
			case 2:m_CV=GetMotorCnt2();	break;
			case 3:m_CV=GetMotorCnt3();	break;
			case 4:m_CV=GetMotorCnt4();	break;
		}
		if((m_Target>=(m_CV-6))&&(m_Target<=(m_CV+6)))break;
  }while(1);
}
 #endif
#endif



#ifdef _SETWAITFORANGLE128_
 #ifndef  _SETWAITFORANGLE128_EXISTS_
  #define _SETWAITFORANGLE128_EXISTS_
  #include <jmkernel.h>

void SetWaitForAngle128(uint8_t which,int speed,int32_t Angle)
{
int32_t m_Target=0,m_CV;
Angle=abs(Angle);
Motor_Init();
MotorCodingInit();
SetMotorServoMode(which);
SetCodeServoAngle128(which,speed,Angle);

m_Target = GetTMCP(which);

do{
    switch(which)
	{
	case 1:m_CV=GetMotorCnt1();	break;
	case 2:m_CV=GetMotorCnt2();	break;
	case 3:m_CV=GetMotorCnt3();	break;
	case 4:m_CV=GetMotorCnt4();	break;
	}

     if((m_Target>=(m_CV-6))&&(m_Target<=(m_CV+6)))break;

  }while(1);
}
 #endif
#endif

#ifdef _SETWAITFORPRESS_
 #ifndef  _SETWAITFORPRESS_EXISTS_
  #define _SETWAITFORPRESS_EXISTS_
  #include <jmkernel.h>

void SetWaitForPress(uint8_t which)
{
   uint32_t port1=portarray[RcuPORT[which][0]];
   uint8_t bit1=RcuPIN[which][0];
   uint8_t value;

   GPIO_Setting((GPIO_TypeDef*)port1,bit1,GPIO_MODE_INPUT);
    do
    {
    value=HAL_GPIO_ReadPin((GPIO_TypeDef*)port1,(1<<bit1));
    }while(value==1);
   TouchClicks[which-1]++;
   Delay1ms(5);
}
 #endif
#endif

#ifdef _SETWAITFORRELEASE_
 #ifndef  _SETWAITFORRELEASE_EXISTS_
  #define _SETWAITFORRELEASE_EXISTS_
  #include <jmkernel.h>

void SetWaitForRelease(uint8_t which)
{
   uint32_t port1=portarray[RcuPORT[which][0]];
   uint8_t bit1=RcuPIN[which][0];
   uint8_t value;
   GPIO_Setting((GPIO_TypeDef*)port1,bit1,GPIO_MODE_INPUT);
    do
    {
    value=HAL_GPIO_ReadPin((GPIO_TypeDef*)port1,(1<<bit1));
    }while(value==0);
   TouchClicks[which-1]++;
   Delay1ms(5);
}
 #endif
#endif

#ifdef _SETWAITFORBUMP_
 #ifndef  _SETWAITFORBUMP_EXISTS_
  #define _SETWAITFORBUMP_EXISTS_
  #include <jmkernel.h>

void SetWaitForBump(uint8_t which)
{
   uint32_t port1=portarray[RcuPORT[which][0]];
   uint8_t bit1=RcuPIN[which][0];
   uint8_t value;
   GPIO_Setting((GPIO_TypeDef*)port1,bit1,GPIO_MODE_INPUT);
    do
    {
    value=HAL_GPIO_ReadPin((GPIO_TypeDef*)port1,(1<<bit1));
    }while(value==1);
    Delay1ms(5);
    do
    {
    value=HAL_GPIO_ReadPin((GPIO_TypeDef*)port1,(1<<bit1));
    }while(value==0);
    TouchClicks[which-1]++;
    Delay1ms(5);
}
 #endif
#endif

#ifdef _GETNUMBEROFCLICKS_
 #ifndef  _GETNUMBEROFCLICKS_EXISTS_
  #define _GETNUMBEROFCLICKS_EXISTS_
  #include <jmkernel.h>

uint32_t GetNumberOfClicks(uint8_t which)
{
    return TouchClicks[which-1];
}
 #endif
#endif
 
 
//==GetUltrasound (adr=04)Readding ID:  == DON'T DELETE!! == 3?

#ifdef _GETULTRASOUND_
 #ifndef  _GETULTRASOUND_EXISTS_
  #define _GETULTRASOUND_EXISTS_
  #include <jmkernel.h>
  #include "I2C_Soft.h"
  
#define _ULTRASOUND_ADDR_		0X04
uint16_t GetUltrasound(uint8_t which)
{
   uint32_t port1=portarray[RcuPORT[which][0]];//I2C_SCL
   uint32_t port2=portarray[RcuPORT[which][1]];//I2C_SDA
   uint32_t port3=portarray[RcuPORT[which][2]];//ADC
   uint8_t bit1=RcuPIN[which][0];
   uint8_t bit2=RcuPIN[which][1];
   uint8_t bit3=RcuPIN[which][2];
   
   uint16_t data=999;
   uint8_t  datah=0,datal=0,cmd=0,s=0,SUM=0,i;

	 RcuWhichMutexTake(which,1,999);//??????IIC1?
	 Soft_I2C_Typedef iic_typedef;
	 Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
					&iic_typedef);
   for(i=0;i<3;i++)
	{
		Soft_I2C_Start(&iic_typedef);
		Soft_I2C_Write(&iic_typedef,_ULTRASOUND_ADDR_);
		Soft_I2C_Write(&iic_typedef,0xaa);
		Soft_I2C_Stop(&iic_typedef);
		
		Soft_I2C_Start(&iic_typedef);
		Soft_I2C_Write(&iic_typedef,_ULTRASOUND_ADDR_+1);
		cmd=Soft_I2C_Read(&iic_typedef,0);		//ݿͷ
		if(cmd!=0xAA) cmd=Soft_I2C_Read(&iic_typedef,0);
		datah=Soft_I2C_Read(&iic_typedef,0);	//ݸ߰λ
		datal=Soft_I2C_Read(&iic_typedef,0);	//Ͱλ
		s=Soft_I2C_Read(&iic_typedef,1);		//
		Soft_I2C_Stop(&iic_typedef);

		SUM=(uint8_t)(cmd+datah+datal);//У
		if(SUM==s)i=3;		//һζȡɹһΣɹ
   	}	
	if(SUM!=s)//У
	{
		data=999;
	}
	else
	{
		data=(uint16_t)(((uint16_t)datah<<8)|datal);	
	}
	RcuWhichMutexGive(which,1,data);//??IIC???1?
	
	
    return (uint16_t)data;
}
 #endif
#endif


//==GetDBCompoI Readding ID:0x02  == DON'T DELETE!! == ???
//BE1727
#ifdef _GETCOMPOI_
 #ifndef  _GETCOMPOI_EXISTS_
  #define _GETCOMPOI_EXISTS_
  #include <jmkernel.h>
  #include "I2C_Soft.h"
 
#define _COMPOI_ADDR_		0X02//I2C ???
uint8_t GetCompoI(uint8_t which, uint8_t command)
{
   uint32_t port1=portarray[RcuPORT[which][0]];//I2C_SCL
   uint32_t port2=portarray[RcuPORT[which][1]];//I2C_SDA
   uint8_t bit1=RcuPIN[which][0];
   uint8_t bit2=RcuPIN[which][1];
   //OS_ENTER_CRITICAL();

	 RcuWhichMutexTake(which,1,0XFFFF);//??????IIC1?
   Soft_I2C_Typedef iic_typedef;
	 Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
										&iic_typedef);
    unsigned char m_temp,m_fix;
    if(command<=15)
    {
    	if( command <= 7)
	{
	  switch(command)
	  {		
		case 1:m_fix = 7;		break;
		case 2:m_fix = 6;		break;
		case 3:m_fix = 5;		break;
		case 4:m_fix = 4;		break;
		case 5:m_fix = 3;		break;
		case 6:m_fix = 2;		break;
		case 7:m_fix = 1;		break;
	  }
	}
	else
	{
		m_fix = command;
	}

    Soft_I2C_Start(&iic_typedef);
    Soft_I2C_Write(&iic_typedef,_COMPOI_ADDR_);//0x02
    Soft_I2C_Write(&iic_typedef,m_fix);
    Soft_I2C_Stop(&iic_typedef);
    Soft_I2C_Start(&iic_typedef);
    Soft_I2C_Write(&iic_typedef,_COMPOI_ADDR_+1);//0x03 
    m_temp=Soft_I2C_Read(&iic_typedef,1);
    Soft_I2C_Stop(&iic_typedef); 
		//OS_EXIT_CRITICAL();
    }
		RcuWhichMutexGive(which,1,0xffff);//??IIC???1?
    if(m_fix == 8)
    {
		if(m_temp==255)return 255;
		return (8-m_temp);
    }
    else
    {
		return m_temp;
    }  
   
}
 #endif
#endif


//==GetCompassB Readding ID:0x76  == DON'T DELETE!! == ??????

#ifdef _GETCOMPASSB_
 #ifndef  _GETCOMPASSB_EXISTS_
  #define _GETCOMPASSB_EXISTS_
  #include <jmkernel.h>
  #include "I2C_Soft.h"
#define _COMPOB_ADDR_		0X76//I2C ???
uint16_t GetCompassB(uint8_t which)
{
   uint32_t port1=portarray[RcuPORT[which][0]];//I2C_SCL
   uint32_t port2=portarray[RcuPORT[which][1]];//I2C_SDA
   uint8_t bit1=RcuPIN[which][0];
   uint8_t bit2=RcuPIN[which][1];
//OS_ENTER_CRITICAL();

		RcuWhichMutexTake(which,1,9999);//??????IIC1?
		Soft_I2C_Typedef iic_typedef;
	 Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
										&iic_typedef);
    uint8_t low;
    uint8_t high;
    uint16_t angle;
    Soft_I2C_Start(&iic_typedef);
    Soft_I2C_Write(&iic_typedef,_COMPOB_ADDR_);//
    Soft_I2C_Write(&iic_typedef,0x01);
    Soft_I2C_Start(&iic_typedef);
    Soft_I2C_Write(&iic_typedef,_COMPOB_ADDR_+1);
    high=Soft_I2C_Read(&iic_typedef,0);
    low=Soft_I2C_Read(&iic_typedef,1);
    Soft_I2C_Stop(&iic_typedef);
//OS_EXIT_CRITICAL();
    if(high==1)
      angle=256+low;
    else
      if(high==0)
        angle=low;
      else
        angle=9999;
				RcuWhichMutexGive(which,1,angle);//??IIC???1?
    return angle;
  }
 #endif
#endif

//==GETGETGSENSOR Readding ID:0xa6  == DON'T DELETE!! == y????

#ifdef _GETGSENSOR_
 #ifndef  _GETGSENSOR_EXISTS_
  #define _GETGSENSOR_EXISTS_
   #include <jmkernel.h>
  #include "I2C_Soft.h"
  
#define _GSENSOR_ADDR_  0xA6
//2:6.6ms;  4:9ms;  3:7.9ms
#define _GS_cnt_ 	4//????2??y>=2
void ADXL345_Write(Soft_I2C_Typedef *iic_typedef,uint8_t Reg,uint8_t Data)
{
//OS_ENTER_CRITICAL();
	Soft_I2C_Start(iic_typedef);
	Soft_I2C_Write(iic_typedef,_GSENSOR_ADDR_);
	Soft_I2C_Write(iic_typedef,Reg);
	Soft_I2C_Write(iic_typedef,Data);
	Soft_I2C_Stop(iic_typedef);
	//OS_EXIT_CRITICAL();
}
void gSense_Init(Soft_I2C_Typedef *iic_typedef)
{
	ADXL345_Write(iic_typedef,0x31, 0x00);	//??2a????
	ADXL345_Write(iic_typedef,0x2C, 0x0A);  //???
	ADXL345_Write(iic_typedef,0x2D, 0x08);  //????꨺?
	ADXL345_Write(iic_typedef,0x1E, 0x00);  //X???? 0 ?D?y
	ADXL345_Write(iic_typedef,0x1F, 0x00);  //Y???? 0
	ADXL345_Write(iic_typedef,0x20, 0x0a);  //Z???? 0 
}
int GetGSensor(uint8_t which,uint8_t axis)
{
   uint32_t port1=portarray[RcuPORT[which][0]];//I2C_SCL
   uint32_t port2=portarray[RcuPORT[which][1]];//I2C_SDA
   uint8_t bit1=RcuPIN[which][0];
   uint8_t bit2=RcuPIN[which][1];
//OS_ENTER_CRITICAL();

		RcuWhichMutexTake(which,1,0XFFFF);//??????IIC1?
Soft_I2C_Typedef iic_typedef;
	 Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
										&iic_typedef);
	uint8_t i,j,m_temp[6];
	int16_t GS_X,GS_Y,GS_Z;
	int8_t g_x,g_y,g_z;
	int8_t buf=0;
	int16_t GS_Data[_GS_cnt_][3];  //??|???????????????2
	uint8_t GS_idx;
	
	
	gSense_Init(&iic_typedef);//3???
	Delay1ms(2);
	
	for(GS_idx=0;GS_idx<_GS_cnt_;GS_idx++)
	{
		Soft_I2C_Start(&iic_typedef);
		Soft_I2C_Write(&iic_typedef,_GSENSOR_ADDR_);
		Soft_I2C_Write(&iic_typedef,0x32);
		Soft_I2C_Start(&iic_typedef);
		Soft_I2C_Write(&iic_typedef,_GSENSOR_ADDR_+1);
		for(j=0;j<5;j++)m_temp[j]=Soft_I2C_Read(&iic_typedef,0);
		m_temp[5]=Soft_I2C_Read(&iic_typedef,1);
		Soft_I2C_Stop(&iic_typedef);

		GS_Data[GS_idx][0]	=	(m_temp[1]*256+m_temp[0]);
		GS_Data[GS_idx][1]	=	(m_temp[3]*256+m_temp[2]);
		GS_Data[GS_idx][2]	=	(m_temp[5]*256+m_temp[4]);
	}
	//OS_EXIT_CRITICAL();
	GS_X = 0;
	GS_Y = 0;
	GS_Z = 0;
	g_x = 0;
	g_y = 0;
	g_z = 0;
	
	for(i=0;i<_GS_cnt_;i++)
	{
		GS_X += GS_Data[i][0];
		GS_Y += GS_Data[i][1];
		GS_Z += GS_Data[i][2];
	}
	
	g_x	=(int8_t)(GS_X/4/_GS_cnt_);
	g_y	=(int8_t)(GS_Y/4/_GS_cnt_);
	g_z	=(int8_t)(GS_Z/4/_GS_cnt_);
	
	switch(axis)
	{
		case 1:buf=g_x;break;
		case 2:buf=g_y;break;
		case 3:buf=g_z;break;
	}
	RcuWhichMutexGive(which,1,buf);//??IIC???1?
	return buf;
}
 #endif
#endif

#ifdef   _GETBLUETOOTH_
#ifndef  _GETBLUETOOTH_EXISTS_
#define  _GETBLUETOOTH_EXISTS_
#include <jmkernel.h>

uint16_t GetBluetooth(void)  
{
   uint16_t m_temp;	
  //SetUsart1RxMode(0);//???꨺?
  m_temp = ReadBTData();
  return m_temp;
}

 #endif
#endif


#ifdef   _SETBLUETOOTH_
#ifndef  _SETBLUETOOTH_EXISTS_
#define  _SETBLUETOOTH_EXISTS_
#include <jmkernel.h>

void SetBluetooth(uint8_t data)  
{
  SendBTData(data);
}

 #endif
#endif

//==SetBluetooth Readding ID:  == DON'T DELETE!! ==

#ifdef _SETWIFIDATA_
 #ifndef  _SETWIFIDATA_EXISTS_
  #define _SETWIFIDATA_EXISTS_

uint8_t SetWifiData(uint8_t data)
{
	return SetWirelessData(data);
}
 #endif
#endif

//==GetBluetooth Readding ID:  == DON'T DELETE!! ==

#ifdef _GETWIFIDATA_
 #ifndef  _GETWIFIDATA_EXISTS_
  #define _GETWIFIDATA_EXISTS_
 
uint16_t GetWifiData(void)
{
	return ReadWirelessData();
}
 #endif
#endif
//==SetFan Readding ID:  == DON'T DELETE!! == ??

#ifdef _SETFAN_
 #ifndef  _SETFAN_EXISTS_
  #define _SETFAN_EXISTS_
  #include <jmkernel.h>

void SetFan(uint8_t which,int speed)
{
speed=(uint8_t)speed;
	if(speed==0)
	{
		SetMotorX(which,1,speed);
	}
   else if(speed<=100)
	{
		SetMotorX(which,2,speed);
	}
   else
	{
SetMotorX(which,0,256-speed);
	}  
}

 #endif
#endif


//==SetIR Readding ID:  == DON'T DELETE!! == oa?騦? -PIN3

#ifdef _SETIR_
 #ifndef  _SETIR_EXISTS_
  #define _SETIR_EXISTS_
  #include <jmkernel.h>

void SetIR(uint8_t which,uint8_t state)
{
   volatile unsigned long i=0;
   uint32_t port1=portarray[RcuPORT[which][0]];
   uint32_t port2=portarray[RcuPORT[which][1]];
   uint8_t bit1=RcuPIN[which][0];
   uint8_t bit2=RcuPIN[which][1];
   
   GPIO_Setting((GPIO_TypeDef*)port1,bit1,GPIO_MODE_OUTPUT_PP);
   GPIO_Setting((GPIO_TypeDef*)port2,bit2,GPIO_MODE_OUTPUT_PP);
   HAL_GPIO_WritePin((GPIO_TypeDef*)port2,(1<<bit2),GPIO_PIN_RESET);

	if(state>0)
	{
		for(i=0;i<11500;i++);//for(i=0;i<9999;i++);
		for(i=0;i<11500;i++);//11500-2ms
		for(i=0;i<11500;i++);
		for(i=0;i<11500;i++);
		for(i=0;i<11500;i++);
		for(i=0;i<11500;i++);
		for(i=0;i<11500;i++);
		for(i=0;i<11500;i++);
		for(i=0;i<11500;i++);
		for(i=0;i<11500;i++);
		for(i=0;i<11500;i++);
		for(i=0;i<11500;i++);//delay24ms
		HAL_GPIO_WritePin((GPIO_TypeDef*)port1,(1<<bit1),GPIO_PIN_SET);
		for(i=0;i<9999;i++);
    }
    HAL_GPIO_WritePin((GPIO_TypeDef*)port1,(1<<bit1),GPIO_PIN_RESET);

}
 #endif
#endif


//==GetIRDete Readding ID:  == DON'T DELETE!! == oa?? PIN3

#ifdef _GETIRDETE_
 #ifndef  _GETIRDETE_EXISTS_
  #define _GETIRDETE_EXISTS_
  #include <jmkernel.h>
  
uint8_t GetIRDete(uint8_t which)
{
    uint32_t port1=portarray[RcuPORT[which][0]];//I2C_SCL
	uint8_t bit1=RcuPIN[which][0];
	
    GPIO_Setting((GPIO_TypeDef*)port1,bit1,GPIO_MODE_INPUT);
    uint8_t value=HAL_GPIO_ReadPin((GPIO_TypeDef*)port1,(1<<bit1));
    if(value) return 0;
    else     return 1;
}
 #endif
#endif


//==GetIRDist Readding ID:  == DON'T DELETE!! == oa2a?

#ifdef _GETIRDIST_
 #ifndef  _GETIRDIST_EXISTS_
  #define _GETIRDIST_EXISTS_
  #include <jmkernel.h>

uint16_t GetIRDist(uint8_t which)
{
    uint32_t port1=portarray[RcuPORT[which][2]];//ADC
	uint8_t bit1=RcuPIN[which][2];
	
    uint16_t i;
    GPIO_Setting((GPIO_TypeDef*)port1,bit1,GPIO_MODE_ANALOG);
    i=GetAdcResult(which);
    return (uint16_t)i;
}
 #endif
#endif

//==GetInfrared Readding ID:  == DON'T DELETE!! == ??oa

#ifdef _GETINFRARED_
 #ifndef  _GETINFRARED_EXISTS_
  #define _GETINFRARED_EXISTS_
  #include <jmkernel.h>

uint16_t GetInfrared(uint8_t which)
{
    uint32_t port1=portarray[RcuPORT[which][0]];//SCL
	uint8_t bit1=RcuPIN[which][0];
	
	GPIO_Setting((GPIO_TypeDef*)port1,bit1,GPIO_MODE_INPUT);//GPIO_Mode_IPU
    uint8_t value=HAL_GPIO_ReadPin((GPIO_TypeDef*)port1,(1<<bit1));
    if(value) return 1;
    else     return 0;
}
 #endif
#endif

//==GetRemoIR Readding ID:  == DON'T DELETE!! == ?e??

#ifdef _GETREMOIR_
 #ifndef  _GETREMOIR_EXISTS_
  #define _GETREMOIR_EXISTS_
  #include <jmkernel.h>
  

uint16_t GetRemoIR(uint8_t which)
{
    uint32_t port1=portarray[RcuPORT[which][2]];//ADC
	uint8_t bit1=RcuPIN[which][2];
	
    uint16_t i;
    GPIO_Setting((GPIO_TypeDef*)port1,bit1,GPIO_MODE_ANALOG);
    i=GetAdcResult(which);
    return (uint16_t)i;
}
 #endif
#endif


//==GetVolume Readding ID:  == DON'T DELETE!! == ?????

#ifdef _GETVOLUME_
 #ifndef  _GETVOLUME_EXISTS_
  #define _GETVOLUME_EXISTS_
  #include <jmkernel.h>

uint16_t GetVolume(uint8_t which)
{
    uint32_t port1=portarray[RcuPORT[which][2]];//ADC
	uint8_t bit1=RcuPIN[which][2];
	
    uint16_t i;
    GPIO_Setting((GPIO_TypeDef*)port1,bit1,GPIO_MODE_ANALOG);
    i=GetAdcResult(which);
    return (uint16_t)i;
}
 #endif
#endif

//==GetVoltage Readding ID:  == DON'T DELETE!! == ??1?2a
//??11??oVin=Vout/0.091̣????=Vout*1000/91
//0.0~30.0
#ifdef _GETVOLTAGE_
 #ifndef  _GETVOLTAGE_EXISTS_
  #define _GETVOLTAGE_EXISTS_
  #include <jmkernel.h>

uint16_t GetVoltage(uint8_t which)//mV
{
    uint32_t port1=portarray[RcuPORT[which][2]];//ADC
	uint8_t bit1=RcuPIN[which][2];
	
	uint32_t adc;
	uint32_t m_Voltage;
	uint8_t i;
	uint32_t s=0;

    GPIO_Setting((GPIO_TypeDef*)port1,bit1,GPIO_MODE_ANALOG);

	for(i=0;i<5;i++)
	{
		adc=GetAdcResult(which);
		s+=adc;
	}
	adc=s/5;
	
	m_Voltage=(uint32_t)((adc*80586)/91)/10000;//(((temp*3300*1000)/4095)/91);
	
    return (uint16_t)m_Voltage;
}
 #endif
#endif

//==GetCurrent Readding ID:  == DON'T DELETE!! == ??2a
//?¡1??oI=|(Vout-2.5)/0.185 ̣??2??D?2.5V??oy
//-4.0~4.0A
#ifdef _GETCURRENT_
 #ifndef  _GETCURRENT_EXISTS_
  #define _GETCURRENT_EXISTS_
  #include <jmkernel.h>
  
int GetCurrent(uint8_t which)
{
    uint32_t port1=portarray[RcuPORT[which][2]];//ADC
	uint8_t bit1=RcuPIN[which][2];
	
	uint16_t adc;
	float buf;
	int16_t m_current;
	uint8_t i;
	uint32_t s=0;
    GPIO_Setting((GPIO_TypeDef*)port1,bit1,GPIO_MODE_ANALOG);

    for(i=0;i<5;i++)
	{
		adc=GetAdcResult(which);
		s+=adc;
	}
	adc=s/5;
	
	buf=(float)(adc*80.586);//(uint32_t)(adc*3300)/4095
	buf-=250000;
	m_current=(int16_t)(buf/185)/10;
	
    return (int)m_current;
}
 #endif
#endif


//==GetPhoto Readding ID:  == DON'T DELETE!! == 1a??

#ifdef _GETPHOTO_
 #ifndef  _GETPHOTO_EXISTS_
  #define _GETPHOTO_EXISTS_
  #include <jmkernel.h>

uint16_t GetPhoto(uint8_t which)
{
    uint32_t port1=portarray[RcuPORT[which][2]];//ADC
	uint8_t bit1=RcuPIN[which][2];
	
    uint16_t i;
    GPIO_Setting((GPIO_TypeDef*)port1,bit1,GPIO_MODE_ANALOG);
    i=GetAdcResult(which);
    return (uint16_t)i;
  }
 #endif
#endif

//==GetMagnet Readding ID:  == DON'T DELETE!! == ??? PIN3

#ifdef _GETMAGNET_
 #ifndef  _GETMAGNET_EXISTS_
  #define _GETMAGNET_EXISTS_
  #include <jmkernel.h>
  
uint8_t GetMagnet(uint8_t which)
{
    uint32_t port1=portarray[RcuPORT[which][0]];//I2C_SCL
	uint8_t bit1=RcuPIN[which][0];
	
    GPIO_Setting((GPIO_TypeDef*)port1,bit1,GPIO_MODE_INPUT);
    uint8_t value=HAL_GPIO_ReadPin((GPIO_TypeDef*)port1,(1<<bit1));
    if(value) return 0;
    else     return 1;
}
 #endif
#endif


//==GetDTHSensor Readding ID:  == DON'T DELETE!! ==ʪ PIN4
// digital temperature and humidity sensor
//0: Humidity
//1: Temperature
#ifdef _GETDTHSENSOR_
 #ifndef  _GETDTHSENSOR_EXISTS_
  #define _GETDTHSENSOR_EXISTS_
	#include <jmkernel.h>
	#include"DTHSensor.h"

uint16_t GetDTHSensor(uint8_t which,int mode)
{
    uint32_t port1=portarray[RcuPORT[which][1]];//I2C_SDA
	uint8_t bit1=RcuPIN[which][1];
	uint16_t value;
	uint8_t i,j;
	RcuWhichMutexTake(which,1,999);
	WIRE_PORT=port1;
	WIRE_BIT=bit1;

   i=0;j=20;
	do
	{
		i=GetDHT11Data(mode,&value);
		if(j>0)j--;
		else {i=1;j=0;}
	}while(i==0);
	RcuWhichMutexGive(which,1,999);
	return (uint16_t)value;
  }
 #endif
#endif

//==GetAirQuality  Readding ID: 0xa0 == DON'T DELETE!! == ??????

#ifdef _GETAIRQUALITY_
 #ifndef  _GETAIRQUALITY_EXISTS_
  #define _GETAIRQUALITY_EXISTS_
	#include <jmkernel.h>
  #include "I2C_Soft.h"
#define _AQ_ADDR_		0XA1//I2C ???
uint8_t GetAirQuality(uint8_t which)
{
	uint32_t port1=portarray[RcuPORT[which][0]];//I2C_SCL
	uint32_t port2=portarray[RcuPORT[which][1]];//I2C_SDA
	uint8_t bit1=RcuPIN[which][0];
	uint8_t bit2=RcuPIN[which][1];
	
	uint8_t data;
	//OS_ENTER_CRITICAL();

		RcuWhichMutexTake(which,1,0XFFFF);//??????IIC1?
	Soft_I2C_Typedef iic_typedef;
	 Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
										&iic_typedef);
	Soft_I2C_Start(&iic_typedef);
	Soft_I2C_Write(&iic_typedef,0XA1);//0XA1
	data=Soft_I2C_Read(&iic_typedef,1);
	Soft_I2C_Stop(&iic_typedef);
	RcuWhichMutexGive(which,1,data);//??IIC???1?
	//OS_EXIT_CRITICAL();
	return (uint8_t)data;
  }
 #endif
#endif

//==GetMusicPlayer  Readding ID: 0xa0 == DON'T DELETE!! == ??????

#ifdef _SETMUSICPLAYER_
 #ifndef  _SETMUSICPLAYER_EXISTS_
  #define _SETMUSICPLAYER_EXISTS_
	#include <jmkernel.h>
  #include "I2C_Soft.h"
#define _MUSICPLAY_ADDR_		0x0E//I2C ???
void SetMusicPlayer(uint8_t which, int cmd)
{
	uint32_t port1=portarray[RcuPORT[which][0]];//I2C_SCL
	uint32_t port2=portarray[RcuPORT[which][1]];//I2C_SDA
	uint8_t bit1=RcuPIN[which][0];
	uint8_t bit2=RcuPIN[which][1];
	uint16_t i;
	//OS_ENTER_CRITICAL();
 
		RcuWhichMutexTake(which,1,999);//??????IIC1?
	Soft_I2C_Typedef iic_typedef;
	 Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
										&iic_typedef);
	Soft_I2C_Start(&iic_typedef);
	Soft_I2C_Write(&iic_typedef, _MUSICPLAY_ADDR_);
	Soft_I2C_Write(&iic_typedef,cmd);
	Soft_I2C_Stop(&iic_typedef);	
	RcuWhichMutexGive(which,1,999);//??IIC???1?
	//OS_EXIT_CRITICAL();
  }
 #endif
#endif

//==GetIR Readding ID:  == DON'T DELETE!! == oa?騦??????

#ifdef _GETIR_
 #ifndef  _GETIR_EXISTS_
  #define _GETIR_EXISTS_
  #include <jmkernel.h>

uint8_t GetIR(uint8_t whichs,uint8_t whichr,uint8_t state)
{
   volatile unsigned long i=0;
   uint32_t port1=portarray[RcuPORT[whichs][0]];//I2C_SCL
   uint8_t bit1=RcuPIN[whichs][0];
   uint32_t port2=portarray[RcuPORT[whichr][0]];//I2C_SCL
   uint8_t bit2=RcuPIN[whichr][0];
	 
   RcuWhichMutexTake(whichs,1,0);
   GPIO_Setting((GPIO_TypeDef*)port1,bit1,GPIO_MODE_OUTPUT_PP);
	if(state>0)
	{
		for(i=0;i<11500;i++);//11500-2ms
		for(i=0;i<11500;i++);
		for(i=0;i<11500;i++);
		for(i=0;i<11500;i++);
		for(i=0;i<11500;i++);
		for(i=0;i<11500;i++);
		for(i=0;i<11500;i++);
		for(i=0;i<11500;i++);
		for(i=0;i<11500;i++);
		for(i=0;i<11500;i++);
		for(i=0;i<11500;i++);
		for(i=0;i<11500;i++);
		HAL_GPIO_WritePin((GPIO_TypeDef*)port1,(1<<bit1),GPIO_PIN_SET);
		for(i=0;i<9999;i++);
    }
    GPIO_ResetBits((GPIO_TypeDef*)port1,( 1<<bit1));
	
    GPIO_Setting((GPIO_TypeDef*)port2,bit2,GPIO_Mode_IPU);
    uint8_t value=GPIO_ReadInputDataBit((GPIO_TypeDef*)port2,(1<<bit2));
		RcuWhichMutexGive(whichs,1,0);
    if(value) return 0;
    else     return 1;
}
 #endif
#endif

#ifdef   _SETWAITFORBLUETOOTH_
 #ifndef  _SETWAITFORBLUETOOTH_EXISTS_
 #define  _SETWAITFORBLUETOOTH_EXISTS_
   #include <jmkernel.h>

void SetWaitForBluetooth(uint8_t data)  
{
	uint16_t m_temp;	
	do
	{
		m_temp = ReadBTData();
	}while(m_temp!=data);
}

 #endif
#endif


#ifdef   _SETWAITFORWIFIDATA_
 #ifndef  _SETWAITFORWIFIDATA_EXISTS_
 #define  _SETWAITFORWIFIDATA_EXISTS_
   #include <jmkernel.h>

void SetWaitForWifiData(uint8_t data)  
{
	uint16_t m_temp;	
	do
	{
		m_temp = ReadWirelessData();
	}while(m_temp!=data);
}

 #endif
#endif

#ifdef _SETPIDMOTOR_
 #ifndef  _SETPIDMOTOR_EXISTS_
 #define _SETPIDMOTOR_EXISTS_
 #include <jmkernel.h>

void SetPIDMotor(uint8_t which,uint8_t speed)
{
	Motor_Init();
	MotorPIDTime_Init();
	MotorCodingInit();
	SetMotorPIDMode(which);
	SetPIDSpeed(which,speed);
}
 #endif
#endif

#ifdef _SETPIDMOTORREF_
 #ifndef  _SETPIDMOTORREF_EXISTS_
 #define _SETPIDMOTORREF_EXISTS_
 #include <jmkernel.h>

void SetPIDMotorRef(uint8_t pulse)
{
	SetFullSpeedRef(pulse);
}
 #endif
#endif

//------BE2560-?????-----------------------------

//==calendar Readding adr:07  == DON'T DELETE!! ==

#ifdef _GETCALENDAR_
 #ifndef  _GETCALENDAR_EXISTS_
  #define _GETCALENDAR_EXISTS_
  #include <jmkernel.h>
  #include "I2C_Soft.h"

unsigned char GetCalendar(uint8_t which, unsigned char command)
{
	uint32_t port1=portarray[RcuPORT[which][0]];//I2C_SCL
	uint32_t port2=portarray[RcuPORT[which][1]];//I2C_SDA
	uint8_t bit1=RcuPIN[which][0];
	uint8_t bit2=RcuPIN[which][1];
	//OS_ENTER_CRITICAL();

		RcuWhichMutexTake(which,1,88);//??????IIC1?
Soft_I2C_Typedef iic_typedef;
	 Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
										&iic_typedef);
    unsigned char data;
    unsigned char temph,templ;
    unsigned char ack=1;    
	if((command>=30)&&(command<=41))
  {
		Soft_I2C_Start(&iic_typedef);
		ack &=Soft_I2C_Write(&iic_typedef,0x0e);
		ack &=Soft_I2C_Write(&iic_typedef,command);
		Soft_I2C_Stop(&iic_typedef);
		Soft_I2C_Start(&iic_typedef);
		Soft_I2C_Write(&iic_typedef,0x0f);     
		data=Soft_I2C_Read(&iic_typedef,1);
		Soft_I2C_Stop(&iic_typedef); 
		//OS_EXIT_CRITICAL();
		if(command<37)
		{
			templ=data;
			temph=data;
			templ=templ&0x0f;       
			temph=temph>>4;
			data=temph*10+templ;
		}
		//return data;
  }
	else
	{
		data=88;//return 88;
	}
	RcuWhichMutexGive(which,1,data);//??IIC???1?
	return data;
}
 #endif
#endif

//==calendar write adr:07  == DON'T DELETE!! ==

#ifdef _SETCALENDAR_
 #ifndef  _SETCALENDAR_EXISTS_
  #define _SETCALENDAR_EXISTS_
  #include <jmkernel.h>
  #include "I2C_Soft.h"

void SetCalendar(uint8_t which, unsigned char sec,unsigned char min,unsigned char hour,unsigned char date,unsigned char month,unsigned char year)
{
	uint32_t port1=portarray[RcuPORT[which][0]];//I2C_SCL
	uint32_t port2=portarray[RcuPORT[which][1]];//I2C_SDA
	uint8_t bit1=RcuPIN[which][0];
	uint8_t bit2=RcuPIN[which][1];
	//OS_ENTER_CRITICAL();

		RcuWhichMutexTake(which,1,999);//??????IIC1?
    Soft_I2C_Typedef iic_typedef;
	 Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
										&iic_typedef);
    unsigned char ack=1; 
    unsigned char buf[4];
    unsigned long temp;
    unsigned int temp1;
    
    Soft_I2C_Start(&iic_typedef);
    ack &=Soft_I2C_Write(&iic_typedef,0x0e);
    ack &=Soft_I2C_Write(&iic_typedef,49);    //COMMAND=49
    ack &=Soft_I2C_Write(&iic_typedef,year);    
    ack &=Soft_I2C_Write(&iic_typedef,month);
    ack &=Soft_I2C_Write(&iic_typedef,date);
    ack &=Soft_I2C_Write(&iic_typedef,hour); 
    ack &=Soft_I2C_Write(&iic_typedef,min);
    ack &=Soft_I2C_Write(&iic_typedef,sec);     
    Soft_I2C_Stop(&iic_typedef);
		RcuWhichMutexGive(which,1,999);//??IIC???1?
		//OS_EXIT_CRITICAL();
 }
 #endif
#endif

//== write calendaradr lcd:07  == DON'T DELETE!! ==

#ifdef _SETBE2560LCD1_
 #ifndef  _SETBE2560LCD1_EXISTS_
  #define _SETBE2560LCD1_EXISTS_
  #include <jmkernel.h>
  #include "I2C_Soft.h"

void SetBE2560LCD1(uint8_t which, unsigned char command,unsigned char lx,unsigned char lxdchar)
{
	uint32_t port1=portarray[RcuPORT[which][0]];//I2C_SCL
	uint32_t port2=portarray[RcuPORT[which][1]];//I2C_SDA
	uint8_t bit1=RcuPIN[which][0];
	uint8_t bit2=RcuPIN[which][1];
	//OS_ENTER_CRITICAL();

		RcuWhichMutexTake(which,1,999);//??????IIC1?
    Soft_I2C_Typedef iic_typedef;
	 Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
										&iic_typedef);
    unsigned char ack=1;
    unsigned char led;
 
	if(command==50)
    {
		Soft_I2C_Start(&iic_typedef);
		ack &=Soft_I2C_Write(&iic_typedef,0x0e);
		ack &=Soft_I2C_Write(&iic_typedef,command);  
		ack &=Soft_I2C_Write(&iic_typedef,lx);   
		ack &=Soft_I2C_Write(&iic_typedef,lxdchar); 
		Soft_I2C_Stop(&iic_typedef);
    }
	if(command==54)
    {
		Soft_I2C_Start(&iic_typedef);
		ack &=Soft_I2C_Write(&iic_typedef,0x0e);
		ack &=Soft_I2C_Write(&iic_typedef,command); 
		Soft_I2C_Stop(&iic_typedef);
    }
	if(command==55)
    {
		Soft_I2C_Start(&iic_typedef);
		ack &=Soft_I2C_Write(&iic_typedef,0x0e);
		ack &=Soft_I2C_Write(&iic_typedef,command);    
		ack &=Soft_I2C_Write(&iic_typedef,lx); 
		Soft_I2C_Stop(&iic_typedef);
    }
		RcuWhichMutexGive(which,1,999);//??IIC???1?
		//OS_EXIT_CRITICAL();
 }

 #endif
#endif

//== write calendaradr lcd:07  == DON'T DELETE!! ==

#ifdef _SETBE2560BACK_
 #ifndef  _SETBE2560BACK_EXISTS_
  #define _SETBE2560BACK_EXISTS_
  #include <jmkernel.h>
  #include "I2C_Soft.h"

void SetBE2560Back(uint8_t which, unsigned char led)
{
	uint32_t port1=portarray[RcuPORT[which][0]];//I2C_SCL
	uint32_t port2=portarray[RcuPORT[which][1]];//I2C_SDA
	uint8_t bit1=RcuPIN[which][0];
	uint8_t bit2=RcuPIN[which][1];
	//OS_ENTER_CRITICAL();

		RcuWhichMutexTake(which,1,999);//??????IIC1?
    Soft_I2C_Typedef iic_typedef;
	 Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
										&iic_typedef);
    unsigned char ack=1;
    
    Soft_I2C_Start(&iic_typedef);
    ack &=Soft_I2C_Write(&iic_typedef,0x0e);
    ack &=Soft_I2C_Write(&iic_typedef,53);    
    ack &=Soft_I2C_Write(&iic_typedef,led); 
    Soft_I2C_Stop(&iic_typedef);
		RcuWhichMutexGive(which,1,999);//??IIC???1?
		//OS_EXIT_CRITICAL();
    
}

 #endif
#endif

//== write calendaradr lcd:07  == DON'T DELETE!! ==

#ifdef _SETBE2560LCD3_
 #ifndef  _SETBE2560LCD3_EXISTS_
  #define _SETBE2560LCD3_EXISTS_
  #include <jmkernel.h>
  #include "I2C_Soft.h"

void SetBE2560LCD3(uint8_t which, unsigned char lx,unsigned int lxdint)
{
    uint32_t port1=portarray[RcuPORT[which][0]];//I2C_SCL
	uint32_t port2=portarray[RcuPORT[which][1]];//I2C_SDA
	uint8_t bit1=RcuPIN[which][0];
	uint8_t bit2=RcuPIN[which][1];
	//OS_ENTER_CRITICAL();

		RcuWhichMutexTake(which,1,999);//??????IIC1?
    Soft_I2C_Typedef iic_typedef;
	 Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
										&iic_typedef);
    unsigned char ack=1; 
    unsigned char buf[2];
    unsigned int temp1;

    temp1=lxdint;
    buf[0]=(unsigned char)temp1;
    temp1=lxdint;  
    temp1=temp1>>8;
    buf[1]=(unsigned char)temp1;
    Soft_I2C_Start(&iic_typedef);
    ack &=Soft_I2C_Write(&iic_typedef,0x0e);
    ack &=Soft_I2C_Write(&iic_typedef,51);
    ack &=Soft_I2C_Write(&iic_typedef,lx);     
    ack &=Soft_I2C_Write(&iic_typedef,buf[0]); 
    ack &=Soft_I2C_Write(&iic_typedef,buf[1]); 
    Soft_I2C_Stop(&iic_typedef);
		RcuWhichMutexGive(which,1,999);//??IIC???1?
		//OS_EXIT_CRITICAL();
}

 #endif
#endif

//== write calendaradr lcd:07  == DON'T DELETE!! ==

#ifdef _SETBE2560LCD8_
 #ifndef  _SETBE2560LCD8_EXISTS_
  #define _SETBE2560LCD8_EXISTS_
  #include <jmkernel.h>
  #include "I2C_Soft.h"

void SetBE2560LCD8(uint8_t which, unsigned char lx,unsigned long lxdlong)
{
    uint32_t port1=portarray[RcuPORT[which][0]];//I2C_SCL
	uint32_t port2=portarray[RcuPORT[which][1]];//I2C_SDA
	uint8_t bit1=RcuPIN[which][0];
	uint8_t bit2=RcuPIN[which][1];
	//OS_ENTER_CRITICAL();

		RcuWhichMutexTake(which,1,999);//??????IIC1?
    Soft_I2C_Typedef iic_typedef;
	 Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
										&iic_typedef);
    unsigned char ack=1; 
    unsigned char buf[4];
    unsigned long temp1;
	
    temp1=lxdlong;
    buf[0]=(unsigned char)temp1;

    temp1=lxdlong;  
    temp1=temp1>>8;
    buf[1]=(unsigned char)temp1;

    temp1=lxdlong;
    temp1=temp1>>16;
    buf[2]=(unsigned char)temp1;

    temp1=lxdlong;  
    temp1=temp1>>24;
    buf[3]=(unsigned char)temp1;
    Soft_I2C_Start(&iic_typedef);
    ack &=Soft_I2C_Write(&iic_typedef,0x0e);
    ack &=Soft_I2C_Write(&iic_typedef,52);
    ack &=Soft_I2C_Write(&iic_typedef,lx);     
    ack &=Soft_I2C_Write(&iic_typedef,buf[0]); 
    ack &=Soft_I2C_Write(&iic_typedef,buf[1]); 
    ack &=Soft_I2C_Write(&iic_typedef,buf[2]); 
    ack &=Soft_I2C_Write(&iic_typedef,buf[3]); 
    Soft_I2C_Stop(&iic_typedef);
		RcuWhichMutexGive(which,1,999);//??IIC???1?
		//OS_EXIT_CRITICAL();
 }

 #endif
#endif

//== set calendaradr speaker:07  == DON'T DELETE!! ==

#ifdef _SETBE2560SPK_
 #ifndef  _SETBE2560SPK_EXISTS_
  #define _SETBE2560SPK_EXISTS_
  #include <jmkernel.h>
  #include "I2C_Soft.h"

void SetBE2560spk(uint8_t which, unsigned char time,unsigned int freq)
{
    uint32_t port1=portarray[RcuPORT[which][0]];//I2C_SCL
	uint32_t port2=portarray[RcuPORT[which][1]];//I2C_SDA
	uint8_t bit1=RcuPIN[which][0];
	uint8_t bit2=RcuPIN[which][1];
	//OS_ENTER_CRITICAL();

		RcuWhichMutexTake(which,1,999);//??????IIC1?
    Soft_I2C_Typedef iic_typedef;
	 Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
										&iic_typedef);
    unsigned char ack=1; 
    unsigned char buf[2];
    unsigned int temp1;
    
    temp1=freq;
    buf[0]=(unsigned char)temp1;
    temp1=freq;  
    temp1=temp1>>8;
    buf[1]=(unsigned char)temp1;
    Soft_I2C_Start(&iic_typedef);
    ack &=Soft_I2C_Write(&iic_typedef,0x0e);
    ack &=Soft_I2C_Write(&iic_typedef,56);
    ack &=Soft_I2C_Write(&iic_typedef,time);     
    ack &=Soft_I2C_Write(&iic_typedef,buf[0]); 
    ack &=Soft_I2C_Write(&iic_typedef,buf[1]); 
    Soft_I2C_Stop(&iic_typedef);
		RcuWhichMutexGive(which,1,999);//??IIC???1?
  //OS_EXIT_CRITICAL();
 }

 #endif
#endif


//==SETAHRS Readding ID:  == DON'T DELETE!! == ?

#ifdef _SETAHRS_
 #ifndef  _SETAHRS_EXISTS_
  #define _SETAHRS_EXISTS_
  
  #include <jmkernel.h>
  #include "I2C_Soft.h"
void SetAHRS(uint8_t which,uint8_t command)
{
   uint32_t port1=portarray[RcuPORT[which][0]];//I2C_SCL
   uint32_t port2=portarray[RcuPORT[which][1]];//I2C_SDA
   uint8_t bit1=RcuPIN[which][0];
   uint8_t bit2=RcuPIN[which][1];
   //OS_ENTER_CRITICAL();

	RcuWhichMutexTake(which,1,999);//??????IIC1?
	Soft_I2C_Typedef iic_typedef;
	 Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
										&iic_typedef);
	Soft_I2C_Start(&iic_typedef);
	Soft_I2C_Write(&iic_typedef,0x3a);//addr
	Soft_I2C_Write(&iic_typedef,0xaa);
	Soft_I2C_Write(&iic_typedef,0x55);
	Soft_I2C_Write(&iic_typedef,command);
	Soft_I2C_Write(&iic_typedef,0);
	Soft_I2C_Write(&iic_typedef,0);
	Soft_I2C_Write(&iic_typedef,0);
	Soft_I2C_Write(&iic_typedef,0xcf);
	Soft_I2C_Stop(&iic_typedef);
	RcuWhichMutexGive(which,1,999);//??IIC???1?
	//OS_EXIT_CRITICAL();
	Delay1ms(1000);
}
 #endif
#endif

//==GETAHRS Readding ID:  == DON'T DELETE!! == ?

#ifdef _GETAHRS_
 #ifndef  _GETAHRS_EXISTS_
  #define _GETAHRS_EXISTS_
  
  #include <jmkernel.h>
  #include "I2C_Soft.h"
  
  int16_t g_AhrsRecBuf[8][9];
  uint8_t g_AhrsRecBufCnt[8];
  uint8_t g_AhrsFistRxFlag[8];
  uint8_t g_LastCmdList[8][9];
int16_t GetAHRSRecBuf(uint8_t which,uint8_t cnt)//y?Y??-?3?????8888
{
	int16_t buf;
	if(cnt>8)return 9999;//cnt=9-1
	buf=g_AhrsRecBuf[which][cnt];
	g_AhrsRecBuf[which][cnt]=8888;
	if(buf!=8888)
	{
		g_AhrsRecBufCnt[which]++;
		g_LastCmdList[which][cnt]=1;
	}
	if(g_AhrsRecBufCnt[which]>8)//??-???o??2??3?
	{
		g_AhrsRecBufCnt[which]=0;
		g_AhrsFistRxFlag[which]=0;
	}
	return buf;
}
int16_t GetAHRS(uint8_t which,uint8_t command1,uint8_t command2)
{
	uint32_t port1=portarray[RcuPORT[which][0]];//I2C_SCL
	uint32_t port2=portarray[RcuPORT[which][1]];//I2C_SDA
	uint8_t bit1=RcuPIN[which][0];
	uint8_t bit2=RcuPIN[which][1];
	uint8_t i,j;
	uint8_t ACK=0;
	int16_t m_data;
	uint8_t m_AhrsRecBufList[22];
	uint8_t m_Rxflag=0;//??????
	uint8_t whichx=which-1;
	//OS_ENTER_CRITICAL();
	RcuWhichMutexTake(which,1,9999);//??????IIC1?
	Soft_I2C_Typedef iic_typedef;
	 Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
										&iic_typedef);
	if(g_AhrsFistRxFlag[whichx]==0||command2||g_LastCmdList[whichx][command1-1])
	{
		m_Rxflag=1;//?????o?
		if(command2==0)g_AhrsFistRxFlag[whichx]=1;
		else g_AhrsFistRxFlag[whichx]=0;
		for(i=0;i<9;i++)	{g_LastCmdList[whichx][i]=0;}//???
		
		Soft_I2C_Start(&iic_typedef);
		Soft_I2C_Write(&iic_typedef,0x3b);//addr
		for(i=0;i<22;i++)
		{
			if(i==21) ACK =1;
			else  ACK = 0;
			m_AhrsRecBufList[i]=Soft_I2C_Read(&iic_typedef,ACK);  
		}  
		Soft_I2C_Stop(&iic_typedef);
	}
	//OS_EXIT_CRITICAL();
	if(m_Rxflag)//????y?Y
    {
		g_AhrsRecBufCnt[whichx]=0;
		if(m_AhrsRecBufList[0]==0xaa && m_AhrsRecBufList[1]==0x55 && m_AhrsRecBufList[21]==0xcf)//?y?y?Y㨹
		{
			g_AhrsFistRxFlag[whichx]=2;
			g_AhrsRecBuf[whichx][0]=(int16_t)(m_AhrsRecBufList[2])|((int8_t)m_AhrsRecBufList[3]<<8);//roll//o1??? degreeꡧ??䨮10??
			g_AhrsRecBuf[whichx][1]=(int16_t)(m_AhrsRecBufList[4])|((int8_t)m_AhrsRecBufList[5]<<8);//pitch//?????? degreeꡧ??䨮10??
			g_AhrsRecBuf[whichx][2]=(int16_t)(m_AhrsRecBufList[6])|((int8_t)m_AhrsRecBufList[7]<<8);//yaw//??o??? degreeꡧ??䨮10??
			g_AhrsRecBuf[whichx][3]=(int16_t)(m_AhrsRecBufList[8])|((int8_t)m_AhrsRecBufList[9]<<8);//ax//???X gꡧ??䨮100??
			g_AhrsRecBuf[whichx][4]=(int16_t)(m_AhrsRecBufList[10])|((int8_t)m_AhrsRecBufList[11]<<8);//ay//???Y gꡧ??䨮100??
			g_AhrsRecBuf[whichx][5]=(int16_t)(m_AhrsRecBufList[12])|((int8_t)m_AhrsRecBufList[13]<<8);//az//???Z gꡧ??䨮100??
			g_AhrsRecBuf[whichx][6]=(int16_t)(m_AhrsRecBufList[14])|((int8_t)m_AhrsRecBufList[15]<<8);//gx//?Y?X  dpsꡧ??䨮100??
			g_AhrsRecBuf[whichx][7]=(int16_t)(m_AhrsRecBufList[16])|((int8_t)m_AhrsRecBufList[17]<<8);//gy//?Y?Y  dpsꡧ??䨮100??
			g_AhrsRecBuf[whichx][8]=(int16_t)(m_AhrsRecBufList[18])|((int8_t)m_AhrsRecBufList[19]<<8);//gz//?Y?Z  dpsꡧ??䨮100??
		}
		else 
		{
			g_AhrsFistRxFlag[whichx]=0;
			return 9999;//?????y?Y㨹
		}
		m_AhrsRecBufList[0]=0;		
		m_AhrsRecBufList[1]=0; 		
		m_AhrsRecBufList[21]=0;
   }
   if(g_AhrsFistRxFlag[whichx]==2)  m_data=GetAHRSRecBuf(whichx,command1-1);//command1=1~9
   else m_data=9999;
	 RcuWhichMutexGive(which,1,m_data);//??IIC???1?
   return (int16_t)m_data;
}
 #endif
#endif

#ifdef _SETEXTBLUETOOTHMODE_
 #ifndef  _SETEXTBLUETOOTHMODE_EXISTS_
  #define _SETEXTBLUETOOTHMODE_EXISTS_
  
	#include "jmkernel.h"
	#include "bluetooth.h"
	
uint8_t SetExtBluetoothMode(uint8_t *name,uint8_t *mode,uint8_t *pswd)
{
	return ExtBT_Config(name,mode,pswd);
}

 #endif
#endif

#ifdef _SETEXTBLUETOOTH_
 #ifndef  _SETEXTBLUETOOTH_EXISTS_
  #define _SETEXTBLUETOOTH_EXISTS_
  
	#include "jmkernel.h"
	#include "bluetooth.h"
	
void SetExtBluetooth(uint8_t data)
{
	SendExtBTData(data);
}

 #endif
#endif

#ifdef _GETEXTBLUETOOTH_
 #ifndef  _GETEXTBLUETOOTH_EXISTS_
  #define _GETEXTBLUETOOTH_EXISTS_
  
	#include "jmkernel.h"
	#include "bluetooth.h"
	
uint16_t GetExtBluetooth(void)
{
	return ReadExtBTData();
}

 #endif
#endif

#ifdef _SETEXTBLUETOOTHCMD_
 #ifndef  _SETEXTBLUETOOTHCMD_EXISTS_
  #define _SETEXTBLUETOOTHCDM_EXISTS_
  
	#include "jmkernel.h"
	#include "bluetooth.h"
	
uint8_t SetExtBluetoothCmd(uint8_t mode,uint8_t *strcmd,uint8_t *str)
{
	return ExtBT_AT_SetCmd(mode,strcmd,str);
}

 #endif
#endif

#ifdef _GETREMOTECONTROLLERBUTTON_
 #ifndef  _GETREMOTECONTROLLERBUTTON_EXISTS_
  #define _GETREMOTECONTROLLERBUTTON_EXISTS_
  
	#include "jmkernel.h"
//0~19,20~39:0~39???,40:?2?????
uint32_t GetRemoteControllerButton(void)//???
{
	Joystick_Init();
	//26bit=1,0~19bit???0~19,26bit=1,0~19bit???20~39;
	//27bit=1,3D?꨺?,27bit=0,???꨺?;
	//20~25bitꨢ?
	return ReadJSButtonData(0);//0 ???1~4??(32Bit),1~4???1~4??(8Bit)
}

 #endif
#endif

#ifdef _GETREMOTECONTROLLERBUTTONSTATE_
 #ifndef  _GETREMOTECONTROLLERBUTTONSTATE_EXISTS_
  #define _GETREMOTECONTROLLERBUTTONSTATE_EXISTS_
  
	#include "jmkernel.h"
//0~19,20~39:0~39???
uint16_t GetRemoteControllerButtonState(void)//???????
{
	uint32_t m_buf=0;
	uint8_t i,flag=0;
	Joystick_Init();
	m_buf=ReadJSButtonData(0);	//0 ???1~4??(32Bit),1~4???1~4??(8Bit)
	if((m_buf&0x000fffff)==0)return 999;//??D??? 
	if(m_buf&(0x04000000))flag=1;
	for(i=0;i<20;i++)
	{
		if(m_buf&(1<<i))
		{
			if(flag)return (i+20);
			else return i;
		}
	}
	return 999;
}

 #endif
#endif

#ifdef _GETREMOTECONTROLLERROCKER_
 #ifndef  _GETREMOTECONTROLLERROCKER_EXISTS_
  #define _GETREMOTECONTROLLERROCKER_EXISTS_
  
	#include "jmkernel.h"
	//dir=0 left,dir=1 right, axis=0 x,  axis=1 y
uint32_t GetRemoteControllerRocker(uint8_t dir,uint8_t axis)//????
{
	Joystick_Init();
	if(dir==0)
	{
		if(axis==0)return ReadJSRockerData(1);
		else return ReadJSRockerData(2);
	}
	else
	{
		if(axis==0)return ReadJSRockerData(3);
		else return ReadJSRockerData(4);
	}
}

 #endif
#endif


#ifdef _GETREMOTECONTROLLERGRAVITY_
 #ifndef  _GETREMOTECONTROLLERGRAVITY_EXISTS_
  #define _GETREMOTECONTROLLERGRAVITY_EXISTS_

	#include "jmkernel.h"
	//i=1 x,i=2 y,i=3 z
int16_t GetRemoteControllerGravity(uint8_t i)//????|???
{
	uint16_t m_val;
	Joystick_Init();
	m_val=ReadJSGravityData(i+3);
	if(m_val==999)return 999;
	return (int8_t)m_val;
}

 #endif
#endif

#ifdef _GETREMOTECONTROLLEREULERIAN_
 #ifndef  _GETREMOTECONTROLLEREULERIAN_EXISTS_
  #define _GETREMOTECONTROLLEREULERIAN_EXISTS_

	#include "jmkernel.h"

uint16_t g_QLastList[4];
int16_t g_RollLast,g_PitchLast,g_YawLast;

//i=1 Roll,2 Pitch,3 Yaw
int16_t GetRemoteControllerEulerian(uint8_t i)//????-??
{
	int16_t m_val=0;
	float quartf[4];
	int32_t q0,q1,q2,q3;
	Joystick_Init();
	if(ReadJSQuartfData(&q0,&q1,&q2,&q3)==0)
	{
		g_QLastList[0]=0;
		g_QLastList[1]=0;
		g_QLastList[2]=0;
		g_QLastList[3]=0;
		g_RollLast=0;g_PitchLast=0;g_YawLast=0;
		return 999;
	}
	if(g_QLastList[0]!=q0||g_QLastList[1]!=q1||g_QLastList[2]!=q2||g_QLastList[3]!=q3)
	{
		quartf[0] = q0/1073741824.0;  
		quartf[1] = q1/1073741824.0;
		quartf[2] = q2/1073741824.0;
		quartf[3] = q3/1073741824.0;
	}
	switch(i)
	{
		case 1:// Roll
		{
			if(g_QLastList[0]==q0&&g_QLastList[1]==q1&&g_QLastList[2]==q2&&g_QLastList[3]==q3)return (int16_t)g_RollLast;
			m_val = atan2(2*(quartf[2]*quartf[3]+quartf[0]*quartf[1]),\
					quartf[0]*quartf[0]-quartf[1]*quartf[1]-quartf[2]*quartf[2]+quartf[3]*quartf[3])*57.3;
			g_RollLast=m_val;
		}break;
		case 2:// Pitch
		{
			if(g_QLastList[0]==q0&&g_QLastList[1]==q1&&g_QLastList[2]==q2&&g_QLastList[3]==q3)return (int16_t)g_PitchLast;
			m_val = asin(-2*(quartf[1]*quartf[3]-quartf[0]*quartf[2]))*57.3;
			g_PitchLast=m_val;
		}break;
		case 3:// Yaw
		{
			if(g_QLastList[0]==q0&&g_QLastList[1]==q1&&g_QLastList[2]==q2&&g_QLastList[3]==q3)return (int16_t)g_YawLast;
			m_val = atan2(2*(quartf[1]*quartf[2]+quartf[0]*quartf[3]),\
			quartf[0]*quartf[0]+quartf[1]*quartf[1]-quartf[2]*quartf[2]-quartf[3]*quartf[3])*57.3;
			g_YawLast=m_val;
		}break;
	}
	return (int16_t)m_val;
}

 #endif
#endif

#ifdef _SETMOTORDIRECTION_
 #ifndef  _SETMOTORDIRECTION_EXISTS_
 #define _SETMOTORDIRECTION_EXISTS_
 #include <jmkernel.h>

void SetMotorDirection(uint8_t dir,uint8_t speed)//dir 0:left 1:right ;speed 0~10
{

}
 #endif
#endif


//==SetLCDSolidCircle Readding ID:  == DON'T DELETE!! == ?-D??2

#ifdef _SETLCDSOLIDCIRCLE_
 #ifndef  _SETLCDSOLIDCIRCLE_EXISTS_
  #define _SETLCDSOLIDCIRCLE_EXISTS_
 #include <jmkernel.h>
#include "LCD320240.h"
  
void SetLCDSolidCircle(int x,int y,uint16_t radius,uint16_t color)
{
	uint16_t xs,xe,ix,ys,ye,iy,yb,ib;
	if(x>radius)xs=x-radius;
	else xs=0;
	xe=x+radius;
	SetBackLed(g_LcdBackLignt);
	for(ix=xs;ix<=xe;ix++)
	{
		if(ix>x)	ib=sqrt(radius*radius-(ix-x)*(ix-x));
		else ib=sqrt(radius*radius-(x-ix)*(x-ix));
		if(y>ib)ys=y-ib;
		else ys=0;
		ye=y+ib;
		if(ye>319)ye=319;
		LCD_DrawRectangleFont( ix,ys,ix, ye, color);
	}
}
 #endif
#endif

//==SetLCDFilledRectangle Readding ID:  == DON'T DELETE!! == ?-D???D?

#ifdef _SETLCDFILLEDRECTANGLE_
 #ifndef  _SETLCDFILLEDRECTANGLE_EXISTS_
  #define _SETLCDFILLEDRECTANGLE_EXISTS_
#include <jmkernel.h>
#include "LCD320240.h"

void SetLCDFilledRectangle(int x1,int y1,int x2,int y2,uint16_t color)
{
	SetBackLed(g_LcdBackLignt);
	LCD_DrawRectangleFont(x1,y1,x2,y2,color);
}
 #endif
#endif

//==SetLCDRectangle Readding ID:  == DON'T DELETE!! == ?-??D?

#ifdef _SETLCDRECTANGLE_
 #ifndef  _SETLCDRECTANGLE_EXISTS_
  #define _SETLCDRECTANGLE_EXISTS_
#include <jmkernel.h>
#include "LCD320240.h"

void SetLCDRectangle(int x1,int y1,int x2,int y2,int w,uint16_t color)
{
	uint8_t wmx,wmy,wm;
	wmx=x2-x1;
	wmy=y2-y1;
	wm=(wmx<wmy)?wmx:wmy;
	if(w>wm)w=wm;
	if(w>0)w-=1;
	SetBackLed(g_LcdBackLignt);
	LCD_DrawRectangleFont( x1,y1,x2,y1+w, color);
	LCD_DrawRectangleFont( x1,y1+w,x1+w, y2, color);
	LCD_DrawRectangleFont( x1+w,y2-w,x2, y2, color);
	LCD_DrawRectangleFont( x2-w,y1+w,x2, y2-w, color);
}
 #endif
#endif

//==GetColorSensor Readding ID:  == DON'T DELETE!! == BE1130
//STM8 addr 10bit//N76E003 addr 8bit
#ifdef _GETCOLORSENSOR_
 #ifndef  _GETCOLORSENSOR_EXISTS_
  #define _GETCOLORSENSOR_EXISTS_
  
  #include "I2C_Soft.h"
 uint8_t MCUN76E003FirstByte; 
uint32_t GetColorSensor(uint8_t which,uint8_t cmd)
{   
  uint32_t port1=portarray[RcuPORT[which][0]];//I2C_SCL
  uint32_t port2=portarray[RcuPORT[which][1]];//I2C_SDA
  uint8_t bit1=RcuPIN[which][0];
  uint8_t bit2=RcuPIN[which][1];
   //OS_ENTER_CRITICAL();
  RcuWhichMutexTake(which,1,999);//ȡ˿IICʹȨ
   Soft_I2C_Typedef iic_typedef;
   Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
                    &iic_typedef);
  uint32_t m_val=0;
  uint8_t m_val1=0, m_val2=0, m_val3=0;
  uint8_t m_bit1=0, m_bit2=0;
  uint8_t first=0,end=0;
  uint8_t m_id=0;
  uint8_t sum=0,m_para1=0,m_para2=0;
  uint8_t addrh,addrl;
  uint8_t id=1;
  uint8_t addr;
  
   RcuWhichMutexGive(which,1,MCUN76E003FirstByte);//ͷIIC˿ʹȨ

    Soft_I2C_Start(&iic_typedef);
    Soft_I2C_Write(&iic_typedef,0xA9);//SlaveAddr+0x01
    MCUN76E003FirstByte=Soft_I2C_Read(&iic_typedef,1);//0xA9
    Soft_I2C_Stop(&iic_typedef);//ֹͣλ
    if(MCUN76E003FirstByte==0xA9)  //N76E0037bitַ
    {
         addr=id+0xA8-1;//0xA8

          //FistByte+cmd+parameter1+parameter2+sum
          Soft_I2C_Start(&iic_typedef);
        //  Soft_I2C_Write(&iic_typedef,0xf6);//SlaveAddrH
          Soft_I2C_Write(&iic_typedef,addr);//SlaveAddrL
          Soft_I2C_Write(&iic_typedef,0xFA);//0
          Soft_I2C_Write(&iic_typedef,cmd);//2
           Soft_I2C_Stop(&iic_typedef);//ֹͣλ
        //FistByte+id+parameter1+[parameter2]+[parameter3]+sum
        //if(cmd<20&&cmd>0)//

        if((cmd<20&&cmd>0)||(cmd>60&&cmd<=74)||((cmd>=254)&&(cmd<=255)))
        {
          Soft_I2C_Start(&iic_typedef);//ظʼλ
          Soft_I2C_Write(&iic_typedef,0xA9);//SlaveAddr|0x01
          first=Soft_I2C_Read(&iic_typedef,0);//SlaveAddr|0x01
          first=Soft_I2C_Read(&iic_typedef,0);
          m_id=Soft_I2C_Read(&iic_typedef,0);
          m_val1=Soft_I2C_Read(&iic_typedef,0);
          if((cmd>=5&&cmd<=18)||(cmd>60&&cmd<=74)||(cmd==254))
          {
            m_val2=Soft_I2C_Read(&iic_typedef,0);
            m_bit1=8;m_bit2=0;
          }
          if(cmd==5)
          {
            m_val3=Soft_I2C_Read(&iic_typedef,0);
            m_bit1=16;m_bit2=8;
          }
          end=Soft_I2C_Read(&iic_typedef,1);
        }
        Soft_I2C_Stop(&iic_typedef);//ֹͣλ

        //OS_EXIT_CRITICAL();
        sum=m_id+m_val1+m_val2+m_val3;//Уͼ

        if(first==0xEA&&sum==end&&m_id==addr)
        {
          m_val=(uint32_t)(m_val1<<m_bit1)|(m_val2<<m_bit2)|(m_val3);
        }
        else
        {
          m_val=999;
        }
        RcuWhichMutexGive(which,1,m_val);//ͷIIC˿ʹȨ
        return m_val;

    }
    else
    {
            addr=id+0x50-1;//0xf650~0xf657

         //FistByte+cmd+parameter1+parameter2+sum
          Soft_I2C_Start(&iic_typedef);
          Soft_I2C_Write(&iic_typedef,0xf6);//SlaveAddrH
          Soft_I2C_Write(&iic_typedef,addr);//SlaveAddrL
          Soft_I2C_Write(&iic_typedef,0xFA);//0
          Soft_I2C_Write(&iic_typedef,cmd);//2

          //FistByte+id+parameter1+[parameter2]+[parameter3]+sum
          //if(cmd<20&&cmd>0)//
         if((cmd<20&&cmd>0)||(cmd>60&&cmd<=74)||((cmd>=254)&&(cmd<=255)))
         {
             Soft_I2C_Start(&iic_typedef);//ظʼλ
             Soft_I2C_Write(&iic_typedef,0xf7);//SlaveAddr|0x01
             first=Soft_I2C_Read(&iic_typedef,0);
             m_id=Soft_I2C_Read(&iic_typedef,0);//Ͱλַ
             m_val1=Soft_I2C_Read(&iic_typedef,0);
            if((cmd>=5&&cmd<=18)||(cmd>60&&cmd<=74)||(cmd==254))
           {
                m_val2=Soft_I2C_Read(&iic_typedef,0);
              m_bit1=8;m_bit2=0;
            }
             if(cmd==5)
           {
               m_val3=Soft_I2C_Read(&iic_typedef,0);
               m_bit1=16;m_bit2=8;
            }
           end=Soft_I2C_Read(&iic_typedef,1);
         }
          Soft_I2C_Stop(&iic_typedef);//ֹͣλ

          //OS_EXIT_CRITICAL();
          sum=m_id+m_val1+m_val2+m_val3;//Уͼ

         if(first==0xEA&&sum==end&&m_id==addr)
         {
            m_val=(uint32_t)(m_val1<<m_bit1)|(m_val2<<m_bit2)|(m_val3);
         }
          else
          {
            m_val=999;
         }
         RcuWhichMutexGive(which,1,m_val);//ͷIIC˿ʹȨ
         return m_val;
    }

}
 #endif
#endif




//==GetColorSensorRGB Readding ID:  == DON'T DELETE!! == BE1130
//addr 10bit
#ifdef _GETCOLORSENSORRGB_
 #ifndef  _GETCOLORSENSORRGB_EXISTS_
  #define _GETCOLORSENSORRGB_EXISTS_
  
  #include "I2C_Soft.h"
 uint8_t GetMCUN76E003FirstByteRGB; //ɫר
uint32_t GetColorSensorRGB(uint8_t which,uint8_t cmd)
{   
  uint32_t port1=portarray[RcuPORT[which][0]];//I2C_SCL
  uint32_t port2=portarray[RcuPORT[which][1]];//I2C_SDA
  uint8_t bit1=RcuPIN[which][0];
  uint8_t bit2=RcuPIN[which][1];
   //OS_ENTER_CRITICAL();
  RcuWhichMutexTake(which,1,999);//ȡ˿IICʹȨ
   Soft_I2C_Typedef iic_typedef;
   Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
                    &iic_typedef);
  uint32_t m_val=0;
  uint8_t m_val1=0, m_val2=0, m_val3=0;
  uint8_t m_bit1=0, m_bit2=0;
  uint8_t first=0,end=0;
  uint8_t m_id=0;
  uint8_t sum=0,m_para1=0,m_para2=0;
  uint8_t addrh,addrl;
  uint8_t id=1;
  uint8_t addr;

   RcuWhichMutexGive(which,1,MCUN76E003FirstByte);//ͷIIC˿ʹȨ
    Soft_I2C_Start(&iic_typedef);
    Soft_I2C_Write(&iic_typedef,0xA9);//SlaveAddr+0x01
    GetMCUN76E003FirstByteRGB=Soft_I2C_Read(&iic_typedef,1);//0xA9
    Soft_I2C_Stop(&iic_typedef);//ֹͣλ
    if(GetMCUN76E003FirstByteRGB==0xA9)  
  {
        addr=id+0xA8-1;//0xA8
  
        //FistByte+cmd+parameter1+parameter2+sum
        Soft_I2C_Start(&iic_typedef);
      //  Soft_I2C_Write(&iic_typedef,0xf6);//SlaveAddrH
        Soft_I2C_Write(&iic_typedef,addr);//SlaveAddrL
        Soft_I2C_Write(&iic_typedef,0xFA);//0
        Soft_I2C_Write(&iic_typedef,cmd);//2
         Soft_I2C_Stop(&iic_typedef);//ֹͣλ
      //FistByte+id+parameter1+[parameter2]+[parameter3]+sum
      //if(cmd<20&&cmd>0)//
    
      if((cmd<20&&cmd>0)||(cmd>60&&cmd<=74)||((cmd>=254)&&(cmd<=255)))
      {
        Soft_I2C_Start(&iic_typedef);//ظʼλ
        Soft_I2C_Write(&iic_typedef,0xA9);//SlaveAddr|0x01
        first=Soft_I2C_Read(&iic_typedef,0);//SlaveAddr|0x01
        first=Soft_I2C_Read(&iic_typedef,0);
        m_id=Soft_I2C_Read(&iic_typedef,0);
        m_val1=Soft_I2C_Read(&iic_typedef,0);
        if((cmd>=5&&cmd<=18)||(cmd>60&&cmd<=74)||(cmd==254))
        {
          m_val2=Soft_I2C_Read(&iic_typedef,0);
          m_bit1=8;m_bit2=0;
        }
        if(cmd==5)
        {
          m_val3=Soft_I2C_Read(&iic_typedef,0);
          m_bit1=16;m_bit2=8;
        }
        end=Soft_I2C_Read(&iic_typedef,1);
      } 
      Soft_I2C_Stop(&iic_typedef);//ֹͣλ
      
      //OS_EXIT_CRITICAL();
      sum=m_id+m_val1+m_val2+m_val3;//Уͼ

      if(first==0xEA&&sum==end&&m_id==addr) 
      {
        m_val=(uint32_t)(m_val1<<m_bit1)|(m_val2<<m_bit2)|(m_val3);
      }
      else 
      {
        m_val=999;
      }
      RcuWhichMutexGive(which,1,m_val);//ͷIIC˿ʹȨ
      return m_val;
  }
   else
   {
  
        addr=id+0x50-1;//0xf650~0xf657
        
        //FistByte+cmd+parameter1+parameter2+sum
        Soft_I2C_Start(&iic_typedef);
        Soft_I2C_Write(&iic_typedef,0xf6);//SlaveAddrH
        Soft_I2C_Write(&iic_typedef,addr);//SlaveAddrL
        Soft_I2C_Write(&iic_typedef,0xFA);//0
        Soft_I2C_Write(&iic_typedef,cmd);//2
        
        //FistByte+id+parameter1+[parameter2]+[parameter3]+sum
        //if(cmd<20&&cmd>0)//
        if((cmd<20&&cmd>0)||(cmd>60&&cmd<=74)||((cmd>=254)&&(cmd<=255)))
        {
          Soft_I2C_Start(&iic_typedef);//ظʼλ
          Soft_I2C_Write(&iic_typedef,0xf7);//SlaveAddr|0x01
          first=Soft_I2C_Read(&iic_typedef,0);
          m_id=Soft_I2C_Read(&iic_typedef,0);//Ͱλַ
          m_val1=Soft_I2C_Read(&iic_typedef,0);
          if((cmd>=5&&cmd<=18)||(cmd>60&&cmd<=74)||(cmd==254))
          {
            m_val2=Soft_I2C_Read(&iic_typedef,0);
            m_bit1=8;m_bit2=0;
          }
          if(cmd==5)
          {
            m_val3=Soft_I2C_Read(&iic_typedef,0);
            m_bit1=16;m_bit2=8;
          }
          end=Soft_I2C_Read(&iic_typedef,1);
        } 
        Soft_I2C_Stop(&iic_typedef);//ֹͣλ
        
        //OS_EXIT_CRITICAL();
        sum=m_id+m_val1+m_val2+m_val3;//Уͼ

        if(first==0xEA&&sum==end&&m_id==addr) 
        {
          m_val=(uint32_t)(m_val1<<m_bit1)|(m_val2<<m_bit2)|(m_val3);
        }
        else 
        {
          m_val=999;
        }
        RcuWhichMutexGive(which,1,m_val);//ͷIIC˿ʹȨ
        return m_val;
  }
}
 #endif
#endif


//==SetColorSensor Readding ID:  == DON'T DELETE!! == BE1130
//addr 10bit
#ifdef _SETCOLORSENSOR_
 #ifndef  _SETCOLORSENSOR_EXISTS_
  #define _SETCOLORSENSOR_EXISTS_
  
  #include "I2C_Soft.h"
 uint8_t SetMCUN76E003FirstByte; //ɫר
uint32_t SetColorSensor(uint8_t which,uint8_t cmd,int parameter)
{   
  uint32_t port1=portarray[RcuPORT[which][0]];//I2C_SCL
  uint32_t port2=portarray[RcuPORT[which][1]];//I2C_SDA
  uint8_t bit1=RcuPIN[which][0];
  uint8_t bit2=RcuPIN[which][1];
   //OS_ENTER_CRITICAL();
  RcuWhichMutexTake(which,1,999);//ȡ˿IICʹȨ
  Soft_I2C_Typedef iic_typedef;
   Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
                    &iic_typedef);
  uint8_t sum=0;
  uint8_t addr=0x50;//ʱַĵͰλ
  uint8_t m_addrh,m_addrl;
  uint8_t first,m_id,end;
  uint16_t m_val;
  uint8_t id=1;
  if(cmd==40||cmd==41)return;
  //sum=ID+cmd+parameter1+parameter2;
  

  Soft_I2C_Start(&iic_typedef);
  Soft_I2C_Write(&iic_typedef,0xA9);//SlaveAddr+0x01
  SetMCUN76E003FirstByte=Soft_I2C_Read(&iic_typedef,1);//0xA9
  Soft_I2C_Stop(&iic_typedef);//ֹͣλ
  
  if(SetMCUN76E003FirstByte==0xA9)  
  {
        //ӻַΪ8Bite  0XA8
      //TX FistByte+cmd+parameter1+parameter2
      Soft_I2C_Start(&iic_typedef);
      Soft_I2C_Write(&iic_typedef,0xA8);//0I2C_ADDR
      Soft_I2C_Write(&iic_typedef,0xEA);//0I2C_SetFirstByte
      Soft_I2C_Write(&iic_typedef,cmd);//дӻ
      Soft_I2C_Write(&iic_typedef,parameter>>8);//
      Soft_I2C_Write(&iic_typedef,parameter&0xff);//
      Soft_I2C_Stop(&iic_typedef);
      RcuWhichMutexGive(which,1,999);//ͷIIC˿ʹȨ
      //OS_EXIT_CRITICAL();
      if(((cmd>=31)&&(cmd<=32))||(cmd>=34&&cmd<=37)||(cmd>=44&&cmd<=55))Delay1ms(25);
      else if(cmd>=33)Delay1ms(200);
      else if(cmd>=43)Delay1ms(1500);
  }
  else
  {
      //ӻַΪ10Bite 0xf6xx:2λ̶Ϊ11,ͰλΪ0x50~0x57,ʵʹõĵַΪ0x350~0x357(0xf650~0xf657)
      //TX FistByte+cmd+parameter1+parameter2
      Soft_I2C_Start(&iic_typedef);
      Soft_I2C_Write(&iic_typedef,0xf6);//дʱַ
      Soft_I2C_Write(&iic_typedef,addr);//
      Soft_I2C_Write(&iic_typedef,0xEA);//0I2C_SetFirstByte
      Soft_I2C_Write(&iic_typedef,cmd);//дӻ
      Soft_I2C_Write(&iic_typedef,parameter>>8);//
      Soft_I2C_Write(&iic_typedef,parameter&0xff);//
      Soft_I2C_Stop(&iic_typedef);
      RcuWhichMutexGive(which,1,999);//ͷIIC˿ʹȨ
      //OS_EXIT_CRITICAL();
      if(((cmd>=31)&&(cmd<=32))||(cmd>=34&&cmd<=37)||(cmd>=44&&cmd<=55))Delay1ms(25);
      else if(cmd>=33)Delay1ms(200);
      else if(cmd>=43)Delay1ms(1500);
  }
}
 #endif
#endif

//==SetServo Readding ID:  == DON'T DELETE!! ==
#ifdef _SETSERVO_
 #ifndef  _SETSERVO_EXISTS_
  #define _SETSERVO_EXISTS_
  
void SetServo(uint8_t which,int angle)
{
	SetComServoAngleAdjustFlag(1);
    ComServoInit(which);
	if(angle==220)ComServoAngle(which,0,0);//??2?3?
	else ComServoAngle(which,(angle+50),0);
}
 #endif
#endif

//==SetServo Readding ID:  == DON'T DELETE!! ==
#ifdef _SETSERVOTIME_
 #ifndef  _SETSERVOTIME_EXISTS_
  #define _SETSERVOTIME_EXISTS_
  
void SetServoTime(uint8_t which,int angle,u16 time)
{
	SetComServoAngleAdjustFlag(1);
    ComServoInit(which);
	if(angle==220)ComServoAngle(which,0,0);//??2?3?
	else ComServoAngle(which,(angle+50),time);
}
 #endif
#endif


//==SetMusicNote Readding ID:  == DON'T DELETE!! ==

#ifdef _SETMUSICNOTE_
 #ifndef  _SETMUSICNOTE_EXISTS_
  #define _SETMUSICNOTE_EXISTS_
	#include "I2C_Soft.h"
	//1?90??/???	
const uint16_t MusicMeter_TimeList[]={133,300,217,550,383,1050,716,2050,1383,4050,2716};//3?3
uint8_t SetMusicNote(uint8_t which,uint8_t m_note,uint8_t m_meter,uint8_t m_pitch,uint8_t m_scale)
{
	uint32_t port1=portarray[RcuPORT[which][0]];//I2C_SCL
	uint32_t port2=portarray[RcuPORT[which][1]];//I2C_SDA
	uint8_t bit1=RcuPIN[which][0];
	uint8_t bit2=RcuPIN[which][1];
   //OS_ENTER_CRITICAL();
	RcuWhichMutexTake(which,1,0);//??????IIC1?
	Soft_I2C_Typedef iic_typedef;
	 Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
										&iic_typedef);
	uint8_t ack;
	uint16_t dt;
	uint8_t m_led=1;//LED????
	uint8_t mmeter=m_meter&0x0f;//?????
	if(m_note==0)m_led=0;//?1?e?
	
	Soft_I2C_Start(&iic_typedef);
	Soft_I2C_Write(&iic_typedef,0x0E);	//???
	Soft_I2C_Write(&iic_typedef,0XEA);	//??
	Soft_I2C_Write(&iic_typedef,m_note);	//1 ???0o?1?1~7
	Soft_I2C_Write(&iic_typedef,m_pitch);//2 ??? 0ǫ?1o?D?2o??
	Soft_I2C_Write(&iic_typedef,m_scale);//3 ?? 1o???0??
	Soft_I2C_Write(&iic_typedef,mmeter);//4 ??? beatflag&0xf0=0 0:1/8  1:3/8  2:1/4  3:3/4  4:1/2  5:3/2  6:1  7:3  8:2  9:6  10:4 
	Soft_I2C_Write(&iic_typedef,0);//5 ????a1????3?????,̣??1ms
	Soft_I2C_Write(&iic_typedef,0);//6 ̨???
	Soft_I2C_Write(&iic_typedef,1);//7 beatflag ̨4???????1o1? ?0o?̡,2 ?????̡?meter1/meter2????3o???1?2????????? ????1????y:0X10:TimeList1[],???TimeList[]
	Soft_I2C_Write(&iic_typedef,0);//8 stopꡧ̨4??? 2?????? o0?1?12??1?freqflagꡧ??????? 1o????????0o1????
	Soft_I2C_Write(&iic_typedef,1);//9 2???????;???3(̨4??)1:?????0ọ?2?????;??4??settime 1???3(???=1)1??a?o3
	Soft_I2C_Write(&iic_typedef,m_led);//10 led LED䨬?????,2?led
	Soft_I2C_Write(&iic_typedef,0);	//11 ??????beatflag=22??e¨?
	Soft_I2C_Write(&iic_typedef,0);	//12 ????????beatflag=22??e¨?
	Soft_I2C_Write(&iic_typedef,0);	//13 ???2?? freqflag==12??e¨?
	Soft_I2C_Write(&iic_typedef,0);	//14 
	Soft_I2C_Write(&iic_typedef,0xF5);//??2
	Soft_I2C_Stop(&iic_typedef);
	//OS_EXIT_CRITICAL();
	//dt =6000;//3?
	dt=MusicMeter_TimeList[mmeter];//???3?3
	do//???|e???|e31|?2???
	{
		 //OS_ENTER_CRITICAL();
		Soft_I2C_Start(&iic_typedef);
		Soft_I2C_Write(&iic_typedef,0x0F);
		ack=Soft_I2C_Read(&iic_typedef,1);	
		Soft_I2C_Stop(&iic_typedef);
		//OS_EXIT_CRITICAL();
		if(ack==0xFA)break;//return 1;//??????
		if(ack==0xFC)break;//?????D?2??
		Delay1ms(1);
	}while(dt--);
	RcuWhichMutexGive(which,1,0);//??IIC???1?
	if(ack==0XFA)return 1;
	return 0;//3?
}
 #endif
#endif


#ifdef _GETTRACEV2I2C_
 #ifndef _GETTRACEV2I2C_EXISTS_
  #define _GETTRACEV2I2C_EXISTS_

  #include "I2C_Soft.h"

uint8_t GetTraceV2I2C( uint8_t which, uint8_t command)
{
	uint32_t port1=portarray[RcuPORT[which][0]];//I2C_SCL
	uint32_t port2=portarray[RcuPORT[which][1]];//I2C_SDA
	uint8_t bit1=RcuPIN[which][0];
	uint8_t bit2=RcuPIN[which][1];
   //OS_ENTER_CRITICAL();

	RcuWhichMutexTake(which,1,0XFFFF);//??????IIC1?
Soft_I2C_Typedef iic_typedef;
	 Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
										&iic_typedef);
    unsigned char m_ChannelState;
    Soft_I2C_Start(&iic_typedef);
    Soft_I2C_Write(&iic_typedef,0x18);
    Soft_I2C_Write(&iic_typedef,command);
    Soft_I2C_Stop(&iic_typedef);
    
    Soft_I2C_Start(&iic_typedef);
    Soft_I2C_Write(&iic_typedef,0x19);
    m_ChannelState=Soft_I2C_Read(&iic_typedef,1);
    Soft_I2C_Stop(&iic_typedef);
		RcuWhichMutexGive(which,1,0XFFFF);//??IIC???1?
    //OS_EXIT_CRITICAL();
    return m_ChannelState;
}
 #endif
#endif

#ifdef  _SETTRACEV2COLOR_
 #ifndef _SETTRACEV2COLOR_EXISTS_
  #define _SETTRACEV2COLOR_EXISTS_

  #include "I2C_Soft.h"

void SetTraceV2Color(uint8_t which,int ch1,int ch2,int ch3,int ch4,int ch5,int ch6,int ch7)
{
	uint32_t port1=portarray[RcuPORT[which][0]];//I2C_SCL
	uint32_t port2=portarray[RcuPORT[which][1]];//I2C_SDA
	uint8_t bit1=RcuPIN[which][0];
	uint8_t bit2=RcuPIN[which][1];
   //OS_ENTER_CRITICAL();
	RcuWhichMutexTake(which,1,999);//??????IIC1?
   Soft_I2C_Typedef iic_typedef;
	 Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
										&iic_typedef);
    Soft_I2C_Start(&iic_typedef);
    Soft_I2C_Write(&iic_typedef,0x18);
    Soft_I2C_Write(&iic_typedef,51);
    Soft_I2C_Write(&iic_typedef,ch1);
    Soft_I2C_Write(&iic_typedef,ch2);
    Soft_I2C_Write(&iic_typedef,ch3);
    Soft_I2C_Write(&iic_typedef,ch4);
    Soft_I2C_Write(&iic_typedef,ch5);
    Soft_I2C_Write(&iic_typedef,ch6);
    Soft_I2C_Write(&iic_typedef,ch7);
    Soft_I2C_Stop(&iic_typedef);
		RcuWhichMutexGive(which,1,999);//??IIC???1?
		//OS_EXIT_CRITICAL();
}
  #endif
#endif

#ifdef  _SETTRACEV2BEEPI2C_
 #ifndef _SETTRACEV2BEEPI2C_EXISTS_
  #define _SETTRACEV2BEEPI2C_EXISTS_
  
  #include "I2C_Soft.h"

void SetTraceV2BeepI2C( uint8_t which,int beeptime)
{
	uint32_t port1=portarray[RcuPORT[which][0]];//I2C_SCL
	uint32_t port2=portarray[RcuPORT[which][1]];//I2C_SDA
	uint8_t bit1=RcuPIN[which][0];
	uint8_t bit2=RcuPIN[which][1];
   //OS_ENTER_CRITICAL();
	RcuWhichMutexTake(which,1,999);//??????IIC1?
   Soft_I2C_Typedef iic_typedef;
	 Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
										&iic_typedef);
    unsigned char m_ChannelState;
    Soft_I2C_Start(&iic_typedef);
    Soft_I2C_Write(&iic_typedef,0x18);
    Soft_I2C_Write(&iic_typedef,52);
    Soft_I2C_Stop(&iic_typedef);
    
    Soft_I2C_Start(&iic_typedef);
    Soft_I2C_Write(&iic_typedef,0x18);
    Soft_I2C_Write(&iic_typedef,beeptime);
    Soft_I2C_Stop(&iic_typedef);
		RcuWhichMutexGive(which,1,999);//??IIC???1?
    //OS_EXIT_CRITICAL();
}
  #endif
#endif

#ifdef  _SETTRACEV2PERCENTI2C_
 #ifndef _SETTRACEV2PERCENTI2C_EXISTS_
  #define _SETTRACEV2PERCENTI2C_EXISTS_

  #include "I2C_Soft.h"

void SetTraceV2PercentI2C( uint8_t which,int molecular,int denominator)
{
	uint32_t port1=portarray[RcuPORT[which][0]];//I2C_SCL
	uint32_t port2=portarray[RcuPORT[which][1]];//I2C_SDA
	uint8_t bit1=RcuPIN[which][0];
	uint8_t bit2=RcuPIN[which][1];
   //OS_ENTER_CRITICAL();
	RcuWhichMutexTake(which,1,999);//??????IIC1?
   Soft_I2C_Typedef iic_typedef;
	 Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
										&iic_typedef);
    Soft_I2C_Start(&iic_typedef);
    Soft_I2C_Write(&iic_typedef,0x18);
    Soft_I2C_Write(&iic_typedef,55);
    Soft_I2C_Write(&iic_typedef,molecular);
    Soft_I2C_Write(&iic_typedef,denominator);
    Soft_I2C_Stop(&iic_typedef);
		RcuWhichMutexGive(which,1,999);//??IIC???1?
		//OS_EXIT_CRITICAL();
}
   #endif
 #endif
 
 



//==SetRFPassWord Readding ID:  BE-9242 == DON'T DELETE!! ==

#ifdef _SETRFPASSWORD_
 #ifndef  _SETRFPASSWORD_EXISTS_
  #define _SETRFPASSWORD_EXISTS_
  
  #include "I2C_Soft.h"
  #define _I2C_addr_w  0XA0
  
 void SetRFPassWord(uint8_t which,uint32_t password)
  {
	uint32_t port1=portarray[RcuPORT[which][0]];//I2C_SCL
	uint32_t port2=portarray[RcuPORT[which][1]];//I2C_SDA
	uint8_t bit1=RcuPIN[which][0];
	uint8_t bit2=RcuPIN[which][1];
 
    uint8_t pw[6]={0x00};
    uint8_t check_sum=0;
    //OS_ENTER_CRITICAL();
		RcuWhichMutexTake(which,1,999);//??????IIC1?
    Soft_I2C_Typedef iic_typedef;
	 Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
										&iic_typedef);
   pw[0]=(uint8_t)(password/1000000);  
   pw[1]=(uint8_t)((password/100000)%10);
   pw[2]=(uint8_t)((password/10000)%10);
   pw[3]=(uint8_t)((password/1000)%10);
   pw[4]=(uint8_t)((password/100)%10);
   pw[5]=(uint8_t)(password%100);
	delay_iic=IIC_SPEED_100K;//20->100k 34->70k 30->78k
    //??DT????????
    Soft_I2C_Start(&iic_typedef);
    Soft_I2C_Write(&iic_typedef,_I2C_addr_w);
    Soft_I2C_Write(&iic_typedef,0xaa);    
    Soft_I2C_Write(&iic_typedef,0x55);    
    Soft_I2C_Write(&iic_typedef,0x01);//??
    check_sum+=0x01;
    Soft_I2C_Write(&iic_typedef,0x09); 
    check_sum+=0x09;
    Soft_I2C_Write(&iic_typedef,pw[0]); 
    check_sum+=pw[0];
    Soft_I2C_Write(&iic_typedef,pw[1]);
    check_sum+=pw[1];
    Soft_I2C_Write(&iic_typedef,pw[2]);  
    check_sum+=pw[2];   
    Soft_I2C_Write(&iic_typedef,pw[3]); 
    check_sum+=pw[3];
    Soft_I2C_Write(&iic_typedef,pw[4]);
    check_sum+=pw[4];
    Soft_I2C_Write(&iic_typedef,pw[5]);  
    check_sum+=pw[5];
    Soft_I2C_Write(&iic_typedef,check_sum);  
    Soft_I2C_Stop(&iic_typedef);
		RcuWhichMutexGive(which,1,999);//??IIC???1?
    delay_iic=IIC_SPEED_DEFAULT;//????????
		//OS_EXIT_CRITICAL();
 }
 #endif
#endif

//==GetRFModuleByte Readding ID:  == DON'T DELETE!! == BE9242
#ifdef _GETRFMODULEBYTE_
 #ifndef  _GETRFMODULEBYTE_EXISTS_
  #define _GETRFMODULEBYTE_EXISTS_
  #include "I2C_Soft.h"
   #define _I2C_addr_w  0XA0

uint16_t GetRFModuleByte(uint8_t which)
{
	uint32_t port1=portarray[RcuPORT[which][0]];//I2C_SCL
	uint32_t port2=portarray[RcuPORT[which][1]];//I2C_SDA
	uint8_t bit1=RcuPIN[which][0];
	uint8_t bit2=RcuPIN[which][1];

	uint16_t data=999;
	uint8_t check_sum=0;
	uint8_t rf_data[16]={0x00};  
	uint8_t n;
//OS_ENTER_CRITICAL();
		RcuWhichMutexTake(which,1,999);//??????IIC1?
		Soft_I2C_Typedef iic_typedef;
	 Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
										&iic_typedef);
	delay_iic=IIC_SPEED_100K;//20->100k 34->70k 30->78k
	 Soft_I2C_Start(&iic_typedef);
    Soft_I2C_Write(&iic_typedef,_I2C_addr_w);
    Soft_I2C_Write(&iic_typedef,0xaa);    
    Soft_I2C_Write(&iic_typedef,0x55);    
    Soft_I2C_Write(&iic_typedef,0x05);//??,2????o3?
    check_sum+=0x05;
    Soft_I2C_Write(&iic_typedef,0x04); 
    check_sum+=0x04;
    Soft_I2C_Write(&iic_typedef,0x00); 
    check_sum+=0x00;
	 Soft_I2C_Write(&iic_typedef,check_sum); 
	 Soft_I2C_Stop(&iic_typedef);
	
    Soft_I2C_Start(&iic_typedef);
    Soft_I2C_Write(&iic_typedef,_I2C_addr_w+1);
    for(n=0;n<15;n++) //??a???D?o3?y?Y
    {
         rf_data[n]=Soft_I2C_Read(&iic_typedef,0);
    }
    rf_data[15]=Soft_I2C_Read(&iic_typedef,1);
    Soft_I2C_Stop(&iic_typedef);
    if(rf_data[0]==0x56&&rf_data[1]==0xAB&&rf_data[2]==0x11&&rf_data[15]==0xCF) //????㨹
    {	
       data=rf_data[3];
    }
		RcuWhichMutexGive(which,1,999);//??IIC???1?
    delay_iic=IIC_SPEED_DEFAULT;//????????
		//OS_EXIT_CRITICAL();
   return data;
}
 #endif
#endif


//==SetRFModuleByte Readding ID:  == DON'T DELETE!! == BE9242
#ifdef _SETRFMODULEBYTE_
 #ifndef  _SETRFMODULEBYTE_EXISTS_
  #define _SETRFMODULEBYTE_EXISTS_
  #include "I2C_Soft.h"
   #define _I2C_addr_w  0XA0

uint8_t SetRFModuleByte(uint8_t which,uint8_t _data)
{
	uint32_t port1=portarray[RcuPORT[which][0]];//I2C_SCL
	uint32_t port2=portarray[RcuPORT[which][1]];//I2C_SDA
	uint8_t bit1=RcuPIN[which][0];
	uint8_t bit2=RcuPIN[which][1];

	uint8_t check_sum=0;
	uint8_t ok_flag=0x02;
//OS_ENTER_CRITICAL();
		RcuWhichMutexTake(which,1,0);//??????IIC1?
		Soft_I2C_Typedef iic_typedef;
	 Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
										&iic_typedef);
	delay_iic=IIC_SPEED_100K;//20->100k 34->70k 30->78k
//?騦????
	 Soft_I2C_Start(&iic_typedef);
    Soft_I2C_Write(&iic_typedef,_I2C_addr_w);
    Soft_I2C_Write(&iic_typedef,0xaa);    
    Soft_I2C_Write(&iic_typedef,0x55);    
    Soft_I2C_Write(&iic_typedef,0x02);//??,?騦?y?Y
    check_sum+=0x02;
    Soft_I2C_Write(&iic_typedef,0x04); 
    check_sum+=0x04;
    Soft_I2C_Write(&iic_typedef,_data); 
    check_sum+=_data;
	 Soft_I2C_Write(&iic_typedef,check_sum); 
	 Soft_I2C_Stop(&iic_typedef);
	 //??2???Y?????
	Soft_I2C_Start(&iic_typedef);
    Soft_I2C_Write(&iic_typedef,_I2C_addr_w);
    Soft_I2C_Write(&iic_typedef,0xaa);    
    Soft_I2C_Write(&iic_typedef,0x55);    
    Soft_I2C_Write(&iic_typedef,0x04);//??
    check_sum+=0x04;
    Soft_I2C_Write(&iic_typedef,0x04); 
    check_sum+=0x04;
    Soft_I2C_Write(&iic_typedef,0x00); 
    check_sum+=0x00;
	 Soft_I2C_Write(&iic_typedef,check_sum); 
	 Soft_I2C_Stop(&iic_typedef);
	//?????y?Y
    Soft_I2C_Start(&iic_typedef);
    Soft_I2C_Write(&iic_typedef,_I2C_addr_w+1);
    do{
    	   ok_flag=Soft_I2C_Read(&iic_typedef,0);
    	 }while(ok_flag==0x02); //2???2??̨y?騦??
    ok_flag=Soft_I2C_Read(&iic_typedef,1); 
    Soft_I2C_Stop(&iic_typedef);
		RcuWhichMutexGive(which,1,0);//??IIC???1?
    delay_iic=IIC_SPEED_DEFAULT;//????????
		//OS_EXIT_CRITICAL();
   return(ok_flag);
}
 #endif
#endif

//==GetRFModuleRemoteButton Readding ID:  == DON'T DELETE!! == BE9242
#ifdef _GETRFMODULEREMOTEBUTTON_
 #ifndef  _GETRFMODULEREMOTEBUTTON_EXISTS_
  #define _GETRFMODULEREMOTEBUTTON_EXISTS_
  #include "I2C_Soft.h"
   #define _I2C_addr_w  0XA0

uint16_t GetRFModuleRemoteButton(uint8_t which)
{
	uint32_t port1=portarray[RcuPORT[which][0]];//I2C_SCL
	uint32_t port2=portarray[RcuPORT[which][1]];//I2C_SDA
	uint8_t bit1=RcuPIN[which][0];
	uint8_t bit2=RcuPIN[which][1];

	uint16_t data=999;
	uint8_t check_sum=0;
	uint8_t rf_data[16]={0x00};  
	uint32_t code=0;
	uint32_t k=1;
	uint8_t n;
//OS_ENTER_CRITICAL();
		RcuWhichMutexTake(which,1,999);//??????IIC1?
		Soft_I2C_Typedef iic_typedef;
	 Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
										&iic_typedef);
	delay_iic=IIC_SPEED_100K;//20->100k 34->70k 30->78k
	 Soft_I2C_Start(&iic_typedef);
    Soft_I2C_Write(&iic_typedef,_I2C_addr_w);
    Soft_I2C_Write(&iic_typedef,0xaa);    
    Soft_I2C_Write(&iic_typedef,0x55);    
    Soft_I2C_Write(&iic_typedef,0x05);//??,2????o3?
    check_sum+=0x05;
    Soft_I2C_Write(&iic_typedef,0x04); 
    check_sum+=0x04;
    Soft_I2C_Write(&iic_typedef,0x00); 
    check_sum+=0x00;
	 Soft_I2C_Write(&iic_typedef,check_sum); 
	 Soft_I2C_Stop(&iic_typedef);
	
    Soft_I2C_Start(&iic_typedef);
    Soft_I2C_Write(&iic_typedef,_I2C_addr_w+1);
    for(n=0;n<15;n++) //??a???D?o3?y?Y
    {
         rf_data[n]=Soft_I2C_Read(&iic_typedef,0);
    }
    rf_data[15]=Soft_I2C_Read(&iic_typedef,1);
    Soft_I2C_Stop(&iic_typedef);
    
    // data=rf_data[3];
    if(rf_data[0]==0x56&&rf_data[1]==0xAB&&rf_data[2]==0x05&&rf_data[15]==0xCF) //????㨹
    {
    	code=(uint32_t)rf_data[3]*0x1000000+(uint32_t)rf_data[4]*0x10000+(uint32_t)rf_data[5]*0x100+(uint32_t)rf_data[6];
    	 for(n=0;n<20;n++)
       {
       	 if(code&(k<<n))
       	 {
       	 	 data=n;
       	 	 if(code&(k<<26))
       	 	 {
       	 	 	  data+=20;
       	 	 }
       	 	 break;
       	 }
       }
    }
		RcuWhichMutexGive(which,1,data);//??IIC???1?
	delay_iic=IIC_SPEED_DEFAULT;//????????
	//OS_EXIT_CRITICAL();
   return data;
}
 #endif
#endif

//==GetRFModuleRemoteCode Readding ID:  == DON'T DELETE!! == BE9242
#ifdef _GETRFMODULEREMOTECODE_
 #ifndef  _GETRFMODULEREMOTECODE_EXISTS_
  #define _GETRFMODULEREMOTECODE_EXISTS_
  #include "I2C_Soft.h"
   #define _I2C_addr_w  0XA0

uint32_t GetRFModuleRemoteCode(uint8_t which)
{
	uint32_t port1=portarray[RcuPORT[which][0]];//I2C_SCL
	uint32_t port2=portarray[RcuPORT[which][1]];//I2C_SDA
	uint8_t bit1=RcuPIN[which][0];
	uint8_t bit2=RcuPIN[which][1];

	uint32_t code=0;
	uint8_t check_sum=0;
	uint8_t rf_data[16]={0x00};  
	uint32_t k=1;
	uint8_t n;
		RcuWhichMutexTake(which,1,0);//??????IIC1?
		Soft_I2C_Typedef iic_typedef;
	 Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
										&iic_typedef);
	delay_iic=IIC_SPEED_100K;//20->100k 34->70k 30->78k
	 Soft_I2C_Start(&iic_typedef);
    Soft_I2C_Write(&iic_typedef,_I2C_addr_w);
    Soft_I2C_Write(&iic_typedef,0xaa);    
    Soft_I2C_Write(&iic_typedef,0x55);    
    Soft_I2C_Write(&iic_typedef,0x05);//??,2????o3?
    check_sum+=0x05;
    Soft_I2C_Write(&iic_typedef,0x04); 
    check_sum+=0x04;
    Soft_I2C_Write(&iic_typedef,0x00); 
    check_sum+=0x00;
	 Soft_I2C_Write(&iic_typedef,check_sum); 
	 Soft_I2C_Stop(&iic_typedef);
	
    Soft_I2C_Start(&iic_typedef);
    Soft_I2C_Write(&iic_typedef,_I2C_addr_w+1);
    for(n=0;n<15;n++) //??a???D?o3?y?Y
    {
         rf_data[n]=Soft_I2C_Read(&iic_typedef,0);
    }
    rf_data[15]=Soft_I2C_Read(&iic_typedef,1);
    Soft_I2C_Stop(&iic_typedef);

    // data=rf_data[3];
    if(rf_data[0]==0x56&&rf_data[1]==0xAB&&rf_data[2]==0x05&&rf_data[15]==0xCF) //????㨹
    {
    	code=(uint32_t)rf_data[3]*0x1000000+(uint32_t)rf_data[4]*0x10000+(uint32_t)rf_data[5]*0x100+(uint32_t)rf_data[6];
    }
		RcuWhichMutexGive(which,1,code);//??IIC???1?
	delay_iic=IIC_SPEED_DEFAULT;//????????
   return code;
}
 #endif
#endif

//==GetRFModuleRemoteGravity Readding ID:  == DON'T DELETE!! == BE9242
#ifdef _GETRFMODULEREMOTEGRAVITY_
 #ifndef  _GETRFMODULEREMOTEGRAVITY_EXISTS_
  #define _GETRFMODULEREMOTEGRAVITY_EXISTS_
  #include "I2C_Soft.h"
   #define _I2C_addr_w  0XA0

int16_t GetRFModuleRemoteGravity(uint8_t which,uint8_t axis)
{
	uint32_t port1=portarray[RcuPORT[which][0]];//I2C_SCL
	uint32_t port2=portarray[RcuPORT[which][1]];//I2C_SDA
	uint8_t bit1=RcuPIN[which][0];
	uint8_t bit2=RcuPIN[which][1];

	int16_t data=999;
	uint8_t check_sum=0;
	uint8_t rf_data[16]={0x00};  
	uint8_t n;
		RcuWhichMutexTake(which,1,999);//??????IIC1?
		Soft_I2C_Typedef iic_typedef;
	 Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
										&iic_typedef);
	delay_iic=IIC_SPEED_100K;//20->100k 34->70k 30->78k
	 Soft_I2C_Start(&iic_typedef);
    Soft_I2C_Write(&iic_typedef,_I2C_addr_w);
    Soft_I2C_Write(&iic_typedef,0xaa);    
    Soft_I2C_Write(&iic_typedef,0x55);    
    Soft_I2C_Write(&iic_typedef,0x05);//??,2????o3?
    check_sum+=0x05;
    Soft_I2C_Write(&iic_typedef,0x04); 
    check_sum+=0x04;
    Soft_I2C_Write(&iic_typedef,0x00); 
    check_sum+=0x00;
	 Soft_I2C_Write(&iic_typedef,check_sum); 
	 Soft_I2C_Stop(&iic_typedef);
	
    Soft_I2C_Start(&iic_typedef);
    Soft_I2C_Write(&iic_typedef,_I2C_addr_w+1);
    for(n=0;n<15;n++) //??a???D?o3?y?Y
    {
         rf_data[n]=Soft_I2C_Read(&iic_typedef,0);
    }
    rf_data[15]=Soft_I2C_Read(&iic_typedef,1);
    Soft_I2C_Stop(&iic_typedef);
    
    // data=rf_data[3];
    if(rf_data[0]==0x56&&rf_data[1]==0xAB&&rf_data[2]==0x05&&rf_data[15]==0xCF) //????㨹
    {
        switch(axis){
        	                  case 0x01:{data=(int8_t)rf_data[11];}break; //X
        	                  case 0x02:{data=(int8_t)rf_data[12];}break; //Y
        	                  case 0x03:{data=(int8_t)rf_data[13];}break;//Z
        	                  default:{data=999;}
        	               } 
    }
		RcuWhichMutexGive(which,1,data);//??IIC???1?
delay_iic=IIC_SPEED_DEFAULT;//????????
   return data;
}
 #endif
#endif

//==GetRFModuleRemoteRocker Readding ID:  == DON'T DELETE!! == BE9242
#ifdef _GETRFMODULEREMOTEROCKER_
 #ifndef  _GETRFMODULEREMOTEROCKER_EXISTS_
  #define _GETRFMODULEREMOTEROCKER_EXISTS_
  #include "I2C_Soft.h"
   #define _I2C_addr_w  0XA0

int16_t GetRFModuleRemoteRocker(uint8_t which,uint8_t direction,uint8_t axis)
{
	uint32_t port1=portarray[RcuPORT[which][0]];//I2C_SCL
	uint32_t port2=portarray[RcuPORT[which][1]];//I2C_SDA
	uint8_t bit1=RcuPIN[which][0];
	uint8_t bit2=RcuPIN[which][1];

	int16_t data=999;
	uint8_t check_sum=0;
	uint8_t rf_data[16]={0x00};  
	uint8_t n;
//OS_ENTER_CRITICAL();
		RcuWhichMutexTake(which,1,999);//??????IIC1?
		Soft_I2C_Typedef iic_typedef;
	 Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
										&iic_typedef);
	delay_iic=IIC_SPEED_100K;//20->100k 34->70k 30->78k
	 Soft_I2C_Start(&iic_typedef);
    Soft_I2C_Write(&iic_typedef,_I2C_addr_w);
    Soft_I2C_Write(&iic_typedef,0xaa);    
    Soft_I2C_Write(&iic_typedef,0x55);    
    Soft_I2C_Write(&iic_typedef,0x05);//??,2????o3?
    check_sum+=0x05;
    Soft_I2C_Write(&iic_typedef,0x04); 
    check_sum+=0x04;
    Soft_I2C_Write(&iic_typedef,0x00); 
    check_sum+=0x00;
	 Soft_I2C_Write(&iic_typedef,check_sum); 
	 Soft_I2C_Stop(&iic_typedef);
	
    Soft_I2C_Start(&iic_typedef);
    Soft_I2C_Write(&iic_typedef,_I2C_addr_w+1);
    for(n=0;n<15;n++) //??a???D?o3?y?Y
    {
         rf_data[n]=Soft_I2C_Read(&iic_typedef,0);
    }
    rf_data[15]=Soft_I2C_Read(&iic_typedef,1);
    Soft_I2C_Stop(&iic_typedef);
    
    // data=rf_data[3];
    if(rf_data[0]==0x56&&rf_data[1]==0xAB&&rf_data[2]==0x05&&rf_data[15]==0xCF) //????㨹
    {
    	 if(direction==0)
    	 {
            switch(axis){
        	                     case 0x00:{data=(int8_t)rf_data[7];}break; //X
        	                     case 0x01:{data=(int8_t)rf_data[8];}break; //Y
        	                     default:{data=999;}
        	                  } 
        
        }
        else
        {
        	  switch(axis){
        	                     case 0x00:{data=(int8_t)rf_data[9];}break; //X
        	                     case 0x01:{data=(int8_t)rf_data[10];}break; //Y
        	                     default:{data=999;}
        	                  } 
        }
    }
		RcuWhichMutexGive(which,1,data);//??IIC???1?
delay_iic=IIC_SPEED_DEFAULT;//????????
//OS_EXIT_CRITICAL();
   return data;
}
 #endif
#endif


#ifdef _SETMUSICADDDATA_
 #ifndef  _SETMUSICADDDATA_EXISTS_
  #define _SETMUSICADDDATA_EXISTS_
  #include <jmkernel.h>
	#include "jmdmusic.h"
  void SetMusicAddData(uint8_t mdata,int time)
  {
	MUSIC_typedef m_Music;
	InMusic_DataProcess(&m_Music, mdata, time);
	Music_AddData(m_Music.freq,m_Music.time);
  }
 #endif
#endif

#ifdef _SETMUSICADDTREBLE_
 #ifndef  _SETMUSICADDTREBLE_EXISTS_
  #define _SETMUSICADDTREBLE_EXISTS_
  #include <jmkernel.h>
  #include "jmdmusic.h"
  void SetMusicAddtreble(uint8_t mdata,int time){
  	MUSIC_typedef m_Music;
	InMusic_DataProcess(&m_Music, (14+mdata), time);
	Music_AddData(m_Music.freq,m_Music.time);
  }
 #endif
#endif

//==SetMusicAddalto Readding ID:  == DON'T DELETE!! ==

#ifdef _SETMUSICADDALTO_
 #ifndef  _MUSICADDALTO_EXISTS_
  #define _MUSICADDALTO_EXISTS_
  #include <jmkernel.h>
  #include "jmdmusic.h"
  void SetMusicAddalto(uint8_t mdata,int time){
    	MUSIC_typedef m_Music;
	InMusic_DataProcess(&m_Music, (7+mdata), time);
	Music_AddData(m_Music.freq,m_Music.time);
  }
 #endif
#endif

//==SetMusicAddbass Readding ID:  == DON'T DELETE!! ==

#ifdef _SETMUSICADDBASS_
 #ifndef  _MUSICADDBASS_EXISTS_
  #define _MUSICADDBASS_EXISTS_
  #include <jmkernel.h>
  #include "jmdmusic.h"
void SetMusicAddbass(uint8_t mdata,int time){
   	MUSIC_typedef m_Music;
	InMusic_DataProcess(&m_Music, (mdata), time);
	Music_AddData(m_Music.freq,m_Music.time);
  }
 #endif
#endif

//==SetMusicStop Readding ID:  == DON'T DELETE!! ==

#ifdef _SETMUSICSTOP_
 #ifndef  _SETMUSICSTOP_EXISTS_
  #define _SETMUSICSTOP_EXISTS_
  #include <jmkernel.h>
  #include "jmdmusic.h"
void SetMusicStop(int time){
   	MUSIC_typedef m_Music;
	InMusic_DataProcess(&m_Music, (0), (uint8_t)time);
	Music_AddData(0,m_Music.time);
  }
 #endif
#endif

//==SetMusicRepeat Readding ID:  == DON'T DELETE!! ==

#ifdef _SETMUSICREPEAT_
 #ifndef  _SETMUSICREPEAT_EXISTS_
  #define _SETMUSICREPEAT_EXISTS_
  #include <jmkernel.h>
  void SetMusicRepeat(int c)
 {
  Music_Repeat(c);
  }
 #endif
#endif

//==SetMusicClear Readding ID:  == DON'T DELETE!! ==

#ifdef _SETMUSICCLEAR_
 #ifndef  _SETMUSICCLEAR_EXISTS_
  #define _SETMUSICCLEAR_EXISTS_
  #include <jmkernel.h>
  
void SetMusicClear(void)
{
  Music_DataClear();
}
 #endif
#endif

//==SetMusicPlay Readding ID:  == DON'T DELETE!! ==

#ifdef _SETMUSICPLAY_
 #ifndef  _SETMUSICPLAY_EXISTS_
  #define _SETMUSICPLAY_EXISTS_
  #include <jmkernel.h>

  void SetMusicPlay(void)
  {
   InMusic_Play();
  }
 #endif
#endif

//==GetMusicState Readding ID:  == DON'T DELETE!! ==

#ifdef   _GETMUSICSTATE_
#ifndef  _GETMUSICSTATE_EXISTS_
#define  _GETMUSICSTATE_EXISTS_
#include <jmkernel.h>

uint8_t GetMusicState(void)
  {
   return Music_GetEndState();
  }
 #endif
#endif

#ifdef _SETINSOUND_
 #ifndef  _SETINSOUND_EXISTS_
  #define _SETINSOUND_EXISTS_
  #include <jmkernel.h>

  void SetInSound(int freq,int time)
  {
		if(freq>20000)freq=20000;
		if(time==0)return;
		else if(time>0x7fff)time=0x7fff;
		SetAddMusicPlay(freq,time);
#ifndef __RCU_MUSIC_FREQ_PLAY_DISABLE
		Delay1ms(time);
#endif//__RCU_MUSIC_FREQ_PLAY_DISABLE
  }
 #endif
#endif

//==SetTunes Readding ID:  == DON'T DELETE!! ==

#ifdef _SETMUSICMETER_
 #ifndef  _SETMUSICMETER_EXISTS_
  #define _SETMUSICMETER_EXISTS_
  #include <jmkernel.h>
  #include "jmdmusic.h"
void SetMusicMeter(unsigned int meter)//DT?????????80??/???
{
	uint32_t mmeter=60000/meter;
	MusicMeter(TimeList,mmeter);
}
 #endif
#endif

#ifdef _GETRCUPORTDATA_
 #ifndef  _GETRCUPORTDATA_EXISTS_
  #define _GETRCUPORTDATA_EXISTS_
  #include <jmkernel.h>
uint16_t GetRcuPortData(uint8_t which)//?2???o?1??RCU?????D???
{
  uint32_t port1=portarray[RcuPORT[which][0]];
  uint8_t bit1=RcuPIN[which][0];
  uint32_t port2=portarray[RcuPORT[which][1]];
  uint8_t bit2=RcuPIN[which][1];
  uint32_t port3=portarray[RcuPORT[which][2]];
  uint8_t bit3=RcuPIN[which][2];
	
  GPIO_Setting((GPIO_TypeDef*)port1,bit1,GPIO_MODE_INPUT);
  GPIO_Setting((GPIO_TypeDef*)port2,bit2,GPIO_MODE_INPUT);
  GPIO_Setting((GPIO_TypeDef*)port3,bit3,GPIO_MODE_INPUT);

  uint8_t value=HAL_GPIO_ReadPin((GPIO_TypeDef*)port1,(1<<bit1));
  value|=HAL_GPIO_ReadPin((GPIO_TypeDef*)port2,(1<<bit2))<<1;
  value|=HAL_GPIO_ReadPin((GPIO_TypeDef*)port3,(1<<bit3))<<2;
  
  switch(value)
  {
		case 0:value=0;break;
		case 1:value=1;break;
		case 2:value=2;break;
		case 3:value=4;break;
		case 4:value=3;break;
		case 5:value=5;break;
		case 6:value=6;break;
		case 7:value=7;break;
  }
  return value;
}
 #endif
#endif


#ifdef _SETMOTORSTRAIGHTANGLE_
 #ifndef  _SETMOTORSTRAIGHTANGLE_EXISTS_
  #define _SETMOTORSTRAIGHTANGLE_EXISTS_
  #include <jmkernel.h>

void SetMotorStraightAngle(uint8_t whichL,uint8_t whichR,int speed,int32_t pulse)//ֱ
{
	if(pulse<0)pulse=-pulse;
	uint8_t which;
	if(whichL==0||whichL>4||whichR==0||whichR>4)return ;
	which=whichL|(whichR<<4);
	PidPara_Init(0,0,(void *)0,0);
	CarPidCtrl_Init(0,which ,0,speed, pulse);
	Create_PicTask();//ʼ
}
 #endif
#endif

#ifdef _SETWAITFORSTRAIGHT_
 #ifndef  _SETWAITFORSTRAIGHT_EXISTS_
  #define _SETWAITFORSTRAIGHT_EXISTS_

void SetWaitForStraight(uint8_t whichL,uint8_t whichR,int speed,long pulse)//ֱ(ȴ)
{

	if(pulse<0)pulse=-pulse;//pulse=abs(pulse);
	uint8_t which;
	if(whichL==0||whichL>4||whichR==0||whichR>4)return ;
	which=whichL|(whichR<<4);
	PidPara_Init(0,0,(void *)0,0);
	CarPidCtrl_Init(0,which ,0,speed, pulse);
	Create_PicTask();//ʼ
	while(1)
	{
		if(ReadPidCtrlFlag(0)==0)break;//ִ
	}
}
#endif
#endif

#ifdef _SETMOTORSTRAIGHT_
 #ifndef  _SETMOTORSTRAIGHT_EXISTS_
  #define _SETMOTORSTRAIGHT_EXISTS_
  #include <jmkernel.h>

void SetMotorStraight(uint8_t whichL,uint8_t whichR,int speed)//ֱ(һֱ)
{
	uint8_t which;
	if(whichL==0||whichL>4||whichR==0||whichR>4)return ;
	which=whichL|(whichR<<4);
	PidPara_Init(0,0,(void *)0,0);
	CarPidCtrl_Init(0,which ,0,speed, 0xFFFFFF);//16777215?
	Create_PicTask();//ʼ
}
 #endif
#endif

#ifdef _SETMOTORSTRAIGHTTURN_
 #ifndef  _SETMOTORSTRAIGHTTURN_EXISTS_
  #define _SETMOTORSTRAIGHTTURN_EXISTS_
  #include <jmkernel.h>

void SetMotorStraightTurn(uint8_t whichL,uint8_t whichR,int speed,int8_t angle)//ֱͬת
{
	uint8_t which;
	if(whichL==0||whichL>4||whichR==0||whichR>4)return ;
	if(angle>=90)angle=90;else if(angle<=-90)angle=-90;
	which=whichL|(whichR<<4);
	PidPara_Init(0,0,(void *)0,angle);
	CarPidCtrl_Init(0,which ,0,speed, 0xFFFFFF);//16777215?
	Create_PicTask();//ʼ
}
 #endif
#endif



#ifdef _SETCARTURN_
 #ifndef  _SETCARTURN_EXISTS_
  #define _SETCARTURN_EXISTS_

void SetCarTurn(uint8_t whichL,uint8_t whichR,int speed,long pulse)//ת speed>0ת,<0ת =0ֹͣ
{

	if(pulse<0)pulse=-pulse;//pulse=abs(pulse);
	uint8_t which;
	if(whichL==0||whichL>4||whichR==0||whichR>4)return ;
	which=whichL|(whichR<<4);
	PidPara_Init(0,1,(void *)0,0);
	CarPidCtrl_Init(0,which ,1,speed, pulse);
	Create_PicTask();////ʼ
}
#endif
#endif

#ifdef _SETWAITFORCARTURN_
 #ifndef  _SETWAITFORCARTURN_EXISTS_
  #define _SETWAITFORCARTURN_EXISTS_

void SetWaitForCarTurn(uint8_t whichL,uint8_t whichR,int speed,long pulse)//ת speed>0ת,<0ת =0ֹͣ(ȴ)
{

	if(pulse<0)pulse=-pulse;//pulse=abs(pulse);
	uint8_t which;
	if(whichL==0||whichL>4||whichR==0||whichR>4)return ;
	uint8_t m_speedper;

	which=whichL|(whichR<<4);
	PidPara_Init(0,1,(void *)0,0);
	CarPidCtrl_Init(0,which ,1,speed, pulse);
	Create_PicTask();//ʼ
	while(1)
	{
		if(ReadPidCtrlFlag(0)==0)break;//ִ
	}
}
#endif
#endif

#ifdef _SETMOTORSTRAIGHTSTOP_
 #ifndef  _SETMOTORSTRAIGHTSTOP_EXISTS_
  #define _SETMOTORSTRAIGHTSTOP_EXISTS_

int32_t SetMotorStraightStop(uint8_t whichL,uint8_t whichR)
{
	uint8_t which;
	if(whichL==0||whichL>4||whichR==0||whichR>4)return ;
	which=whichL|(whichR<<4);
	PidPara_Init(0,0,(void *)0,0);
	CarPidCtrl_Init(0,which ,0,0, 0);
	Create_PicTask();//ʼ
}
 #endif
#endif

#ifdef _SETMOTORSTRAIGHTANGLE128_
 #ifndef  _SETMOTORSTRAIGHTANGLE128_EXISTS_
  #define _SETMOTORSTRAIGHTANGLE128_EXISTS_
  #include <jmkernel.h>

void SetMotorStraightAngle128(uint8_t which,int speed,int32_t Angle)
{
	Angle=abs(Angle);
	Motor_Init();
	MotorCodingInit();
	MotorPIDTime_Init();
	SetMCPidServoAngle128(which,speed,Angle);
}
 #endif
#endif

#ifdef _SETTASKSUSPEND_
 #ifndef  _SETTASKSUSPEND_EXISTS_
  #define _SETTASKSUSPEND_EXISTS_
 
uint16_t SetTaskSuspend(uint8_t tasknum)//1?e??????,tasknum=01?e??o
{
	return OS_TaskSuspend(tasknum);
}
 #endif
#endif

#ifdef _SETTASKRESUME_
 #ifndef  _SETTASKRESUME_EXISTS_
  #define _SETTASKRESUME_EXISTS_
 
uint16_t SetTaskResume(uint8_t tasknum)//??D???????
{
	OS_TaskCreate(tasknum);//????
	return OS_TaskResume(tasknum);
}
 #endif
#endif

#ifdef _SETTASKDELETE_
 #ifndef  _SETTASKDELETE_EXISTS_
  #define _SETTASKDELETE_EXISTS_
 
uint16_t SetTaskDelete(uint8_t tasknum)//?3y??????
{
	return OS_TaskDelete(tasknum);
}
 #endif
#endif

#ifdef _SETTASKCREATE_
 #ifndef  _SETTASKCREATE_EXISTS_
  #define _SETTASKCREATE_EXISTS_
 
uint16_t SetTaskCreate(uint8_t tasknum)//???????
{
	return OS_TaskCreate(tasknum);
}
 #endif
#endif


#ifdef _GETIRCODE_
 #ifndef  _GETIRCODE_EXISTS_
  #define _GETIRCODE_EXISTS_

extern volatile uint32_t IR_code;
extern uint8_t IR_revOK;
uint8_t lastIRData;
uint8_t GetIRCode(uint8_t which)
{
uint8_t IR_addr,IR_addr_n,IR_data,IR_data_n;

uint32_t port2=portarray[RcuPORT[which][1]];//I2C_SDA
uint8_t bit2=RcuPIN[which][1];

HAL_GPIO_WritePin((GPIO_TypeDef*)port2,(1<<bit2),GPIO_PIN_SET);
   ReadIRcodeInit();
   if(IR_revOK==1)
   {
    IR_revOK=0;
   IR_addr = 0xFF&(IR_code>>24);
   IR_addr_n = 0xFF&(IR_code>>16);
   IR_data = 0xFF&(IR_code>>8);
   IR_data_n = 0xFF&IR_code;
   lastIRData = IR_data;
   return IR_data;
   }
   if(IR_revOK==2)
   {
      IR_revOK=0;
      return lastIRData;
    }
   else
   {
    	return 0;
    }

}	
 #endif
#endif

#ifdef _SETIRCODE_
 #ifndef  _SETIRCODE_EXISTS_
  #define _SETIRCODE_EXISTS_

uint8_t SetIRCode(uint8_t which,uint8_t data)
{
    uint8_t status;
//?a?????ay?Y
    status=SendIRFunction(0,data);
    return status;
}	
 #endif
#endif

#ifdef _SETMP3PLAY_
 #ifndef  _SETMP3PLAY_EXISTS_
  #define _SETMP3PLAY_EXISTS_
	#include "mp3lib.h"
void SetMp3Play(uint16_t folder,uint16_t mp3num)
{
  uint8_t volume=0;
  volume = MP3_GetSound();	
  MP3_SetSound(volume);
  Delay1ms(20);
  MP3_PlaySong(0X05,((folder&0XFF)<<8)|((mp3num&0XFF)));
}	
 #endif
#endif

#ifdef _SETMP3SUSPEND_
 #ifndef  _SETMP3SUSPEND_EXISTS_
  #define _SETMP3SUSPEND_EXISTS_
	#include "mp3lib.h"
void SetMp3Suspend(void)//?Y2??
{
  MP3_PlaySong(0x02,0x0000);
}	
 #endif
#endif

#ifdef _GETRANDOM_
 #ifndef  _GETRANDOM_EXISTS_
  #define _GETRANDOM_EXISTS_
#define _MULTIPLIER 	0x015a4e35L 
#define _INCREMENT	 	1 
uint8_t g_GetRandomFirst=0;
int GetRandom(int m,int n)
{
	static long seed;
	int rn=0,randn;
	if(g_GetRandomFirst==0)//̨?????????
	{
		seed=GetSystemTime()+ReadInMicVaule()+ReadInVoltageVaule();
		Delay1ms(1);
		seed=(GetSystemTime()+ReadInMicVaule()+216+ReadInVoltageVaule())%0x8000;
		g_GetRandomFirst=1;
	}
	seed = _MULTIPLIER*seed + _INCREMENT; 
	randn=((int)(seed>>16) & 0x7fff); 
	rn=(int)(randn%(n-m+1)+m);//m~n???y
	return((int)rn);
}
 #endif
#endif


#ifdef _GETRCUPORTDATA_
 #ifndef  _GETRCUPORTDATA_EXISTS_
  #define _GETRCUPORTDATA_EXISTS_
  #include <jmkernel.h>
uint16_t GetRcuPortData(uint8_t which)//?2???o?1??RCU?????D???
{
  uint32_t port1=portarray[RcuPORT[which][0]];
  uint8_t bit1=RcuPIN[which][0];
  uint32_t port2=portarray[RcuPORT[which][1]];
  uint8_t bit2=RcuPIN[which][1];
  uint32_t port3=portarray[RcuPORT[which][2]];
  uint8_t bit3=RcuPIN[which][2];


	
  GPIO_Setting((GPIO_TypeDef*)port1,bit1,GPIO_MODE_INPUT);
  GPIO_Setting((GPIO_TypeDef*)port2,bit2,GPIO_MODE_INPUT);
  GPIO_Setting((GPIO_TypeDef*)port3,bit3,GPIO_MODE_INPUT);//GPIO_Mode_IN_FLOATING

  uint8_t value=HAL_GPIO_ReadPin((GPIO_TypeDef*)port1,(1<<bit1));
  value|=HAL_GPIO_ReadPin((GPIO_TypeDef*)port2,(1<<bit2))<<1;
  value|=HAL_GPIO_ReadPin((GPIO_TypeDef*)port3,(1<<bit3))<<2;
  
  switch(value)
  {
		case 0:value=0;break;
		case 1:value=1;break;
		case 2:value=2;break;
		case 3:value=4;break;
		case 4:value=3;break;
		case 5:value=5;break;
		case 6:value=6;break;
		case 7:value=7;break;
  }
  return value;
}
 #endif
#endif

#ifdef _SETRCUPORTDATA_
 #ifndef  _SETRCUPORTDATA_EXISTS_
  #define _SETRCUPORTDATA_EXISTS_

void SetRcuPortData(uint8_t which,uint16_t Color)
{
   uint32_t port1=portarray[RcuPORT[which][0]];
   uint32_t port2=portarray[RcuPORT[which][1]];
   uint32_t port3=portarray[RcuPORT[which][2]];
   uint8_t bit1=RcuPIN[which][0];
   uint8_t bit2=RcuPIN[which][1];
   uint8_t bit3=RcuPIN[which][2];
   uint8_t RedLed,GreenLed,BlueLed;
   GPIO_Setting((GPIO_TypeDef*)port1,bit1,GPIO_MODE_OUTPUT_PP);
   GPIO_Setting((GPIO_TypeDef*)port2,bit2,GPIO_MODE_OUTPUT_PP);
   GPIO_Setting((GPIO_TypeDef*)port3,bit3,GPIO_MODE_OUTPUT_PP);
   switch(Color)
	{
		case 0: RedLed=0;GreenLed=0;BlueLed=0;	break;
		case 1: RedLed=1;GreenLed=0;BlueLed=0;	break;
		case 2: RedLed=0;GreenLed=1;BlueLed=0;	break;
		case 3: RedLed=0;GreenLed=0;BlueLed=1;	break;
		case 4: RedLed=1;GreenLed=1;BlueLed=0;	break;
		case 5: RedLed=1;GreenLed=0;BlueLed=1;	break;
		case 6: RedLed=0;GreenLed=1;BlueLed=1;	break;
		case 7: RedLed=1;GreenLed=1;BlueLed=1;	break;
	}

//o?
   if(RedLed==1)   HAL_GPIO_WritePin((GPIO_TypeDef*)port1,(1<<bit1),GPIO_PIN_SET);
   else    HAL_GPIO_WritePin((GPIO_TypeDef*)port1,(1<<bit1),GPIO_PIN_RESET);
//??
   if(GreenLed==1)   HAL_GPIO_WritePin((GPIO_TypeDef*)port2,(1<<bit2),GPIO_PIN_SET);
   else  HAL_GPIO_WritePin((GPIO_TypeDef*)port2,(1<<bit2),GPIO_PIN_RESET);
//??
   if(BlueLed==1)    HAL_GPIO_WritePin((GPIO_TypeDef*)port3,(1<<bit3),GPIO_PIN_SET);
   else   HAL_GPIO_WritePin((GPIO_TypeDef*)port3,(1<<bit3),GPIO_PIN_RESET);

  }
 #endif
#endif


//==GetRFModuleRemoteBit Readding ID:  == DON'T DELETE!! == BE9237
#ifdef _GETRFMODULEREMOTEBIT_
 #ifndef  _GETRFMODULEREMOTEBIT_EXISTS_
  #define _GETRFMODULEREMOTEBIT_EXISTS_
  #include "I2C_Soft.h"
   #define _I2C_addr_w  0XA0

uint16_t GetRFModuleRemoteBit(uint8_t which,uint8_t num)
{
	uint32_t port1=portarray[RcuPORT[which][0]];//I2C_SCL
	uint32_t port2=portarray[RcuPORT[which][1]];//I2C_SDA
	uint8_t bit1=RcuPIN[which][0];
	uint8_t bit2=RcuPIN[which][1];

	uint16_t data=0;
	uint8_t check_sum=0;
	uint8_t rf_data[16]={0x00};  
	uint32_t code=0;
	uint32_t k=1;
	uint8_t n;

		RcuWhichMutexTake(which,1,999);//??????IIC1?
		Soft_I2C_Typedef iic_typedef;
	 Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
										&iic_typedef);
	delay_iic=IIC_SPEED_100K;//20->100k 34->70k 30->78k
	  Soft_I2C_Start(&iic_typedef);
    Soft_I2C_Write(&iic_typedef,_I2C_addr_w);
    Soft_I2C_Write(&iic_typedef,0xaa);    
    Soft_I2C_Write(&iic_typedef,0x55);    
    Soft_I2C_Write(&iic_typedef,0x05);//??,2????o3?
    check_sum+=0x05;
    Soft_I2C_Write(&iic_typedef,0x04); 
    check_sum+=0x04;
    Soft_I2C_Write(&iic_typedef,0x00); 
    check_sum+=0x00;
	 Soft_I2C_Write(&iic_typedef,check_sum); 
	 Soft_I2C_Stop(&iic_typedef);
	
    Soft_I2C_Start(&iic_typedef);
    Soft_I2C_Write(&iic_typedef,_I2C_addr_w+1);
    for(n=0;n<15;n++) //??a???D?o3?y?Y
    {
         rf_data[n]=Soft_I2C_Read(&iic_typedef,0);
    }
    rf_data[15]=Soft_I2C_Read(&iic_typedef,1);
    Soft_I2C_Stop(&iic_typedef);
    
    // data=rf_data[3];
    if(rf_data[0]==0x56&&rf_data[1]==0xAB&&rf_data[2]==0x05&&rf_data[15]==0xCF) //????㨹
    {
    	   code=(uint32_t)rf_data[3]*0x1000000+(uint32_t)rf_data[4]*0x10000+(uint32_t)rf_data[5]*0x100+(uint32_t)rf_data[6];
       	 if(code&(k<<num))
       	 {
       	 	 data=1;
       	 }
    }
		RcuWhichMutexGive(which,1,data);//??IIC???1?
   	delay_iic=IIC_SPEED_DEFAULT;//????????
    return data;
}
 #endif
#endif

#ifdef _GETWIFIVOICE_
 #ifndef _GETWIFIVOICE_EXISTS_
  #define _GETWIFIVOICE_EXISTS_
 
uint16_t GetWifiVoice(uint8_t *str)
{
	int s=-1;
	//if(GetWifiReadRxMode()!=1)	
	//{
	//	SetWifiReadRxMode(1);//WIFI???꨺??aD-??
	//}
	WifiVoice_Init();
	s=ReadWifiVoiceResult(str);
	if(s==-1)return 0;
	else return 1;//?e31|
}
 #endif
#endif
#ifdef _SETWIFIVOICESTRING_
 #ifndef _SETWIFIVOICESTRING_EXISTS_
  #define _SETWIFIVOICESTRING_EXISTS_
 #include "LCD320240.h"
uint16_t SetWifiVoiceString(int y,uint16_t ch_color,uint16_t bg_color)
{
	uint8_t* str=ReadWifiVoiceString();
	uint8_t strlist[32],i,n=LCD_Width/GetFontLibWidth();
	for(i=0;i<n;i++)
	{
		if(*str!='\0')strlist[i]=*str++;
		else strlist[i]=' ';
	}
	strlist[i]='\0';
  SetBackLed(g_LcdBackLignt);
  LCD_String(0,(y-1)*GetFontLibHeight(),strlist,ch_color,bg_color);
}
 #endif
#endif

#ifdef _SETNOTE_
 #ifndef  _SETNOTE_EXISTS_
  #define _SETNOTE_EXISTS_
  #include "jmdmusic.h"
  void SetNote(int note)
  {
		uint16_t freq;
		BeepInit();
		if(note==0)
		{
			BeepOff();
		}
		else
		{
			freq=NoteList[1][note-1];
			SetMusicPWMFreq(freq);
		}
  }
 #endif
#endif


//==SetUartData Readding ID:  == DON'T DELETE!! ==

#ifdef _SETUARTDATA_
 #ifndef  _SETUARTDATA_EXISTS_
  #define _SETUARTDATA_EXISTS_
#include <jmkernel.h>

void SetUartData(uint8_t data,uint32_t baud)//P8????y?Y
{
	uint32_t BaudRate;
  switch(baud)
  {
		case 0:BaudRate=9600  ;break;
		case 1:BaudRate=14400 ;break;
		case 2:BaudRate=19200 ;break;
		case 3:BaudRate=38400 ;break;
		case 4:BaudRate=57600 ;break;
		case 5:BaudRate=76800 ;break;
		case 6:BaudRate=115200;break;
		case 7:BaudRate=128000;break;
		case 8:BaudRate=256000;break;
		case 9:BaudRate=512000;break;
		case 10:BaudRate=921600;break;
		default:BaudRate=baud;break;
  }
	SysCOM_Init(BaudRate);
	SetComData(data);
}
 #endif
#endif

//==GetUartData Readding ID:  == DON'T DELETE!! ==

#ifdef _GETUARTDATA_
 #ifndef  _GETUARTDATA_EXISTS_
  #define _GETUARTDATA_EXISTS_
 #include <jmkernel.h>
 extern volatile uint8_t UART2_Sletc;
uint8_t GetUartData(uint32_t baud)//P8????y?Y
{
	
	uint8_t buf;
	uint32_t BaudRate;
	UART2_Sletc=0;//ͨ
  switch(baud)
  {
		case 0:BaudRate=9600  ;break;
		case 1:BaudRate=14400 ;break;
		case 2:BaudRate=19200 ;break;
		case 3:BaudRate=38400 ;break;
		case 4:BaudRate=57600 ;break;
		case 5:BaudRate=76800 ;break;
		case 6:BaudRate=115200;break;
		case 7:BaudRate=128000;break;
		case 8:BaudRate=256000;break;
		case 9:BaudRate=512000;break;
		case 10:BaudRate=921600;break;
		default:BaudRate=baud;break;
  }
	SysCOM_Init(BaudRate);
	buf=ReadCOMData();
	return buf;
}
 #endif
#endif


#ifdef _SETLCDFILLEDRECTANGLE2_
 #ifndef  _SETLCDFILLEDRECTANGLE2_EXISTS_
  #define _SETLCDFILLEDRECTANGLE2_EXISTS_
#include <jmkernel.h>
#include "LCD320240.h"

void SetLCDFilledRectangle2(uint16_t x,uint16_t y,uint16_t xlong ,uint16_t ylong,uint16_t color)
{
	SetBackLed(g_LcdBackLignt);//GPIO_SetBits(GPIOA,GPIO_Pin_4);
	if(xlong==0||ylong==0)return ;
	LCD_DrawRectangleFont(x,y,x+xlong,y+ylong,color);
}
 #endif
#endif

#ifdef _SETLCDRECTANGLE2_
 #ifndef  _SETLCDRECTANGLE2_EXISTS_
  #define _SETLCDRECTANGLE2_EXISTS_
#include <jmkernel.h>
#include "LCD320240.h"

void SetLCDRectangle2(uint16_t x1,uint16_t y1,uint16_t xlong,uint16_t ylong,uint16_t w,uint16_t color)
{
	uint8_t wmx,wmy,wm;
	uint16_t x2,y2;
	SetBackLed(g_LcdBackLignt);//GPIO_SetBits(GPIOA,GPIO_Pin_4);
	if(xlong==0||ylong==0)return ;
	
	x2=x1+xlong;
	y2=y1+ylong;
	wmx=x2-x1;
	wmy=y2-y1;
	wm=(wmx<wmy)?wmx:wmy;
	if(w>wm)w=wm;
	if(w>0)w-=1;
	
	LCD_DrawRectangleFont( x1,y1,x2,y1+w, color);// |
	LCD_DrawRectangleFont( x1,y1+w,x1+w, y2, color);//  |
	LCD_DrawRectangleFont( x1+w,y2-w,x2, y2, color);//-
	LCD_DrawRectangleFont( x2-w,y1+w,x2, y2-w, color);//_
}
 #endif
#endif

#ifdef _SETLCDLINE_
 #ifndef  _SETLCDLINE_EXISTS_
  #define _SETLCDLINE_EXISTS_
#include <jmkernel.h>
#include "LCD320240.h"

void SetLCDLine(uint16_t x1,uint16_t y1,int16_t angle, uint16_t lenght,uint16_t color)
{
	SetBackLed(g_LcdBackLignt);//GPIO_SetBits(GPIOA,GPIO_Pin_4);
	LCD_Line(x1,y1,angle,lenght,color,1);
}
 #endif
#endif
//==SetOneServo Readding ID:  == DON'T DELETE!! ==//BE5235/BE5236

#ifdef _SETONESERVO_
 #ifndef  _SETONESERVO_EXISTS_
  #define _SETONESERVO_EXISTS_
  
  #include "I2C_Soft.h"
  
#define _SERVO2_ADDR_		(0x18)//0x18
void SetOneServo(uint8_t which,uint8_t Channel, uint8_t angle, uint16_t time)
{
	uint32_t port1=portarray[RcuPORT[which][0]];//I2C_SCL
	uint32_t port2=portarray[RcuPORT[which][1]];//I2C_SDA
	uint8_t bit1=RcuPIN[which][0];
	uint8_t bit2=RcuPIN[which][1];

	uint8_t timh,timl;
	uint8_t sum=0;
	timh=time>>8;
	timl=time&0xff;
	
	RcuWhichMutexTake(which,1,999);//??????IIC1?
 	Soft_I2C_Typedef iic_typedef;
 	Soft_I2C_BspInit( port2,bit2,//SDA
   									port1,bit1,//SCL
   									&iic_typedef);
	//if(g_Servo8to10Flag==0)//10
	{
		sum=(uint8_t)(Channel+angle+timh+timl);
	}
  Soft_I2C_Start(&iic_typedef);
  Soft_I2C_Write(&iic_typedef,_SERVO2_ADDR_);
  Soft_I2C_Write(&iic_typedef,0xfa);
  Soft_I2C_Write(&iic_typedef,Channel);
  Soft_I2C_Write(&iic_typedef,angle);
  Soft_I2C_Write(&iic_typedef,timh);
  Soft_I2C_Write(&iic_typedef,timl);
	//if(g_Servo8to10Flag==0)
	Soft_I2C_Write(&iic_typedef,sum);//10
  Soft_I2C_Stop(&iic_typedef);
  RcuWhichMutexGive(which,1,999);//??IIC???1?
}
 #endif
#endif


#ifdef _SETDISPLAYPICTURE_
 #ifndef  _SETDISPLAYPICTURE_EXISTS_
  #define _SETDISPLAYPICTURE_EXISTS_

int SetDisplayPicture(int x,int y,//ͼƬʼX=0-239Y=0-319
		            	 	 	const char* filename,//ͼƬļ(ַ),ƲģͼƬƲܳ8ֽ,׺ܳ3ֽ
		            	 	 	char scale)//ͼű0-3 : 1,1/2,1/4,1/8
{
	  int res=0;
	  //return LCD_DisplayPicture(x,y,filename,scale);
	  while(ReadDisplayPictureFlag());//ȴһʾ
	  os_task_enter_critical();
	  SetDisplayPictureFlag(1);//ʾһεͼƬ
	  StartDisplayPicture(x,y,filename,scale);
	  os_task_exit_critical();
	  while(ReadDisplayPictureFlag());//ȴʾ
	  res=ReadDisplayPictureState();//ʾ״̬
	  return res;

}
#endif
#endif
#ifdef _SETWIFIUDPMODE_
 #ifndef  _SETWIFIUDPMODE_EXISTS_
  #define _SETWIFIUDPMODE_EXISTS_

//uint16_t SetWifiUdpMode(uint8_t *remotip,uint8_t *remoteport,uint8_t *port)
uint16_t SetWifiUdpMode(uint8_t *remotip,uint16_t remoteport,uint16_t port)//??UDP???IPo???
{
	//print("IP:%s\r\n??3???:%s\r\n?????:%s\r\n",remotip,remoteport,port);
	if(WifiSetting_Init(remotip,remoteport,port,0)==2)return 1;
	return 0;
}
 #endif
#endif


//==SetColorIR (adr=0x32)Readding ID:  == DON'T DELETE!! == 

#ifdef _SETSMARTEYEALLLED_
#ifndef  _SETSMARTEYEALLLED_EXISTS_
#define _SETSMARTEYEALLLED_EXISTS_
#include <jmkernel.h>
#include "I2C_Soft.h"
#define _COLORIR_ADDR_ 0x32

uint32_t SetSmartEyeAllLed(uint8_t which,uint32_t led1, uint32_t led2,uint32_t led3,uint32_t led4,uint32_t led5,uint32_t led6,uint32_t led7,uint32_t led8)
{
   uint32_t port1=portarray[RcuPORT[which][0]];//I2C_SCL
   uint32_t port2=portarray[RcuPORT[which][1]];//I2C_SDA
   uint8_t bit1=RcuPIN[which][0];
   uint8_t bit2=RcuPIN[which][1]; 
   uint8_t i;

   RcuWhichMutexTake(which,1,999);//???I2C1?
   Soft_I2C_Typedef iic_typedef;
   Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
          &iic_typedef);

	Soft_I2C_Start(&iic_typedef);
	Soft_I2C_Write(&iic_typedef,_COLORIR_ADDR_);
	Soft_I2C_Write(&iic_typedef,0xAA);//CMD
	Soft_I2C_Write(&iic_typedef,0xD1);//mode

	Soft_I2C_Write(&iic_typedef,(led1&0xFF0000)>>16);
	Soft_I2C_Write(&iic_typedef,(led1&0xFF00)>>8);
	Soft_I2C_Write(&iic_typedef,(led1&0xFF));

	Soft_I2C_Write(&iic_typedef,(led2&0xFF0000)>>16);
	Soft_I2C_Write(&iic_typedef,(led2&0xFF00)>>8);
	Soft_I2C_Write(&iic_typedef,(led2&0xFF));

	Soft_I2C_Write(&iic_typedef,(led3&0xFF0000)>>16);
	Soft_I2C_Write(&iic_typedef,(led3&0xFF00)>>8);
	Soft_I2C_Write(&iic_typedef,(led3&0xFF));

	Soft_I2C_Write(&iic_typedef,(led4&0xFF0000)>>16);
	Soft_I2C_Write(&iic_typedef,(led4&0xFF00)>>8);
	Soft_I2C_Write(&iic_typedef,(led4&0xFF));

	Soft_I2C_Write(&iic_typedef,(led5&0xFF0000)>>16);
	Soft_I2C_Write(&iic_typedef,(led5&0xFF00)>>8);
	Soft_I2C_Write(&iic_typedef,(led5&0xFF));

	Soft_I2C_Write(&iic_typedef,(led6&0xFF0000)>>16);
	Soft_I2C_Write(&iic_typedef,(led6&0xFF00)>>8);
	Soft_I2C_Write(&iic_typedef,(led6&0xFF));

	Soft_I2C_Write(&iic_typedef,(led7&0xFF0000)>>16);
	Soft_I2C_Write(&iic_typedef,(led7&0xFF00)>>8);
	Soft_I2C_Write(&iic_typedef,(led7&0xFF));

	Soft_I2C_Write(&iic_typedef,(led8&0xFF0000)>>16);
	Soft_I2C_Write(&iic_typedef,(led8&0xFF00)>>8);
	Soft_I2C_Write(&iic_typedef,(led8&0xFF));


	Soft_I2C_Stop(&iic_typedef);

  RcuWhichMutexGive(which,1,999);//??I2C1? 

        
}
#endif
#endif

//==SetColorIR (adr=0x32)Readding ID:  == DON'T DELETE!! == 

#ifdef _SETSMARTEYEALLLED2_
#ifndef  _SETSMARTEYEALLLED2_EXISTS_
#define _SETSMARTEYEALLLED2_EXISTS_
#include <jmkernel.h>
#include "I2C_Soft.h"
#define _COLORIR_ADDR_ 0x32

void SetSmartEyeAllLed2(uint8_t which,int8_t* color1, int8_t* color2,int8_t* color3,int8_t* color4,int8_t* color5,int8_t* color6,int8_t* color7,int8_t* color8)
{
   uint32_t port1=portarray[RcuPORT[which][0]];//I2C_SCL
   uint32_t port2=portarray[RcuPORT[which][1]];//I2C_SDA
   uint8_t bit1=RcuPIN[which][0];
   uint8_t bit2=RcuPIN[which][1]; 
   uint32_t led1,led2,led3,led4,led5,led6,led7,led8;
   led1=atoi(color1);
   led2=atoi(color2);
   led3=atoi(color3);
   led4=atoi(color4);
   led5=atoi(color5);
   led6=atoi(color6);
   led7=atoi(color7);
   led8=atoi(color8);
   RcuWhichMutexTake(which,1,999);//???I2C1?
   Soft_I2C_Typedef iic_typedef;
   Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
          &iic_typedef);

  Soft_I2C_Start(&iic_typedef);
  Soft_I2C_Write(&iic_typedef,_COLORIR_ADDR_);
  Soft_I2C_Write(&iic_typedef,0xAA);//CMD
  Soft_I2C_Write(&iic_typedef,0xD1);//mode

  Soft_I2C_Write(&iic_typedef,led1/1000000);//λ
  Soft_I2C_Write(&iic_typedef,(led1%1000000)/1000);//λ
  Soft_I2C_Write(&iic_typedef,(led1%1000000)%1000);//λ

  Soft_I2C_Write(&iic_typedef,led2/1000000);//λ
  Soft_I2C_Write(&iic_typedef,(led2%1000000)/1000);//λ
  Soft_I2C_Write(&iic_typedef,(led2%1000000)%1000);//λ

  Soft_I2C_Write(&iic_typedef,led3/1000000);//λ
  Soft_I2C_Write(&iic_typedef,(led3%1000000)/1000);//λ
  Soft_I2C_Write(&iic_typedef,(led3%1000000)%1000);//λ

  Soft_I2C_Write(&iic_typedef,led4/1000000);//λ
  Soft_I2C_Write(&iic_typedef,(led4%1000000)/1000);//λ
  Soft_I2C_Write(&iic_typedef,(led4%1000000)%1000);//λ

  Soft_I2C_Write(&iic_typedef,led5/1000000);//λ
  Soft_I2C_Write(&iic_typedef,(led5%1000000)/1000);//λ
  Soft_I2C_Write(&iic_typedef,(led5%1000000)%1000);//λ

  Soft_I2C_Write(&iic_typedef,led6/1000000);//λ
  Soft_I2C_Write(&iic_typedef,(led6%1000000)/1000);//λ
  Soft_I2C_Write(&iic_typedef,(led6%1000000)%1000);//λ

  Soft_I2C_Write(&iic_typedef,led7/1000000);//λ
  Soft_I2C_Write(&iic_typedef,(led7%1000000)/1000);//λ
  Soft_I2C_Write(&iic_typedef,(led7%1000000)%1000);//λ

  Soft_I2C_Write(&iic_typedef,led8/1000000);//λ
  Soft_I2C_Write(&iic_typedef,(led8%1000000)/1000);//λ
  Soft_I2C_Write(&iic_typedef,(led8%1000000)%1000);//λ

  Soft_I2C_Stop(&iic_typedef);

  RcuWhichMutexGive(which,1,999);//??I2C1? 

        
}
#endif
#endif


//==SetColorIR (adr=0x32)Readding ID:  == DON'T DELETE!! == 
#ifdef _SETSMARTEYEMODE_
#ifndef  _SETSMARTEYEMODE_EXISTS_
#define _SETSMARTEYEMODE_EXISTS_
#include <jmkernel.h>
#include "I2C_Soft.h"
#define _COLORIR_ADDR_ 0x32
uint32_t SetSmartEyeMode(uint8_t which,uint8_t cmd,uint32_t color)
{
   uint32_t port1=portarray[RcuPORT[which][0]];//I2C_SCL
   uint32_t port2=portarray[RcuPORT[which][1]];//I2C_SDA
   uint8_t bit1=RcuPIN[which][0];
   uint8_t bit2=RcuPIN[which][1]; 
   uint8_t red,gerrn,bule;

  red   = (color&0xFF0000)>>16;
  gerrn = (color&0xFF00)>>8;
  bule  = (color&0xFF);
   RcuWhichMutexTake(which,1,999);//???I2C1?
   Soft_I2C_Typedef iic_typedef;
   Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
          &iic_typedef);

  Soft_I2C_Start(&iic_typedef);
  Soft_I2C_Write(&iic_typedef,_COLORIR_ADDR_);
  Soft_I2C_Write(&iic_typedef,0xAA);//CMD
  Soft_I2C_Write(&iic_typedef,0xD2);//mode
  Soft_I2C_Write(&iic_typedef,cmd);
  Soft_I2C_Write(&iic_typedef,red);
  Soft_I2C_Write(&iic_typedef,gerrn);
  Soft_I2C_Write(&iic_typedef,bule);
  Soft_I2C_Stop(&iic_typedef);

  RcuWhichMutexGive(which,1,999);//??I2C1? 

        
}

 #endif
#endif

//==SetColorIR (adr=0x32)Readding ID:  == DON'T DELETE!! == 
#ifdef _SETSMARTEYEMODE2_
#ifndef  _SETSMARTEYEMODE2_EXISTS_
#define _SETSMARTEYEMODE2_EXISTS_
#include <jmkernel.h>
#include "I2C_Soft.h"
#define _COLORIR_ADDR_ 0x32
uint32_t SetSmartEyeMode2(uint8_t which,uint8_t cmd,uint8_t* color)
{
   uint32_t port1=portarray[RcuPORT[which][0]];//I2C_SCL
   uint32_t port2=portarray[RcuPORT[which][1]];//I2C_SDA
   uint8_t bit1=RcuPIN[which][0];
   uint8_t bit2=RcuPIN[which][1]; 
   uint8_t red,gerrn,bule;
   uint32_t colorc;
   colorc=atoi(color);

   red   =(colorc/1000000);//λ
   gerrn =(colorc%1000000)/1000;//λ
   bule  =(colorc%1000000)%1000;//λ

   RcuWhichMutexTake(which,1,999);//???I2C1?
   Soft_I2C_Typedef iic_typedef;
   Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
          &iic_typedef);

  Soft_I2C_Start(&iic_typedef);
  Soft_I2C_Write(&iic_typedef,_COLORIR_ADDR_);
  Soft_I2C_Write(&iic_typedef,0xAA);//CMD
  Soft_I2C_Write(&iic_typedef,0xD2);//mode
  Soft_I2C_Write(&iic_typedef,cmd);
  Soft_I2C_Write(&iic_typedef,red);
  Soft_I2C_Write(&iic_typedef,gerrn);
  Soft_I2C_Write(&iic_typedef,bule);
  Soft_I2C_Stop(&iic_typedef);

  RcuWhichMutexGive(which,1,999);//??I2C1? 

        
}

 #endif
#endif


//==GetColorIR (adr=0x32)Readding ID:  == DON'T DELETE!! == 
#ifdef _GETSMARTEYEIRCODE_
#ifndef _GETSMARTEYEIRCODE_EXISTS_
#define _GETSMARTEYEIRCODE_EXISTS_
#include <jmkernel.h>
#include "I2C_Soft.h"
#define _COLORIR_ADDR_ 0x32
uint32_t GetSmartEyeIRcode(uint8_t which)
{
   uint32_t port1=portarray[RcuPORT[which][0]];//I2C_SCL
   uint32_t port2=portarray[RcuPORT[which][1]];//I2C_SDA
   uint8_t bit1=RcuPIN[which][0];
   uint8_t bit2=RcuPIN[which][1]; 
   
   uint8_t data;
   RcuWhichMutexTake(which,1,999);//???I2C1?
   Soft_I2C_Typedef iic_typedef;
   Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
          &iic_typedef);

  Soft_I2C_Start(&iic_typedef);
  Soft_I2C_Write(&iic_typedef,_COLORIR_ADDR_);
  Soft_I2C_Write(&iic_typedef,0xAA);//CMD
  Soft_I2C_Write(&iic_typedef,0xD3);//mode
  Soft_I2C_Write(&iic_typedef,0x00);
  Soft_I2C_Write(&iic_typedef,0x00);
  Soft_I2C_Write(&iic_typedef,0x00);
  Soft_I2C_Write(&iic_typedef,0x00);
  Soft_I2C_Stop(&iic_typedef);

  Soft_I2C_Start(&iic_typedef);
  Soft_I2C_Write(&iic_typedef,_COLORIR_ADDR_+1);
  data=Soft_I2C_Read(&iic_typedef,0);//_COLORIR_ADDR_+1
  data=Soft_I2C_Read(&iic_typedef,1);//
  Soft_I2C_Stop(&iic_typedef);
  RcuWhichMutexGive(which,1,999);//??I2C1?  
  
  if(data!=0&&data!=0xFF) return data;
  else return 0;
        
}

 #endif
#endif



//==SetColorIR (adr=0x32)Readding ID:  == DON'T DELETE!! == 
#ifdef _SETSMARTEYEIRCODE_
#ifndef  _SETSMARTEYEIRCODE_EXISTS_
#define _SETSMARTEYEIRCODE_EXISTS_
#include <jmkernel.h>
#include "I2C_Soft.h"
#define _COLORIR_ADDR_ 0x32
uint32_t SetSmartEyeIRcode(uint8_t which,uint8_t cmd)
{
   uint32_t port1=portarray[RcuPORT[which][0]];//I2C_SCL
   uint32_t port2=portarray[RcuPORT[which][1]];//I2C_SDA
   uint8_t bit1=RcuPIN[which][0];
   uint8_t bit2=RcuPIN[which][1]; 
   

   RcuWhichMutexTake(which,1,999);//???I2C1?
   Soft_I2C_Typedef iic_typedef;
   Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
          &iic_typedef);

  Soft_I2C_Start(&iic_typedef);
  Soft_I2C_Write(&iic_typedef,_COLORIR_ADDR_);
  Soft_I2C_Write(&iic_typedef,0xAA);//CMD
  Soft_I2C_Write(&iic_typedef,0xD4);//mode
  Soft_I2C_Write(&iic_typedef,0);//addr
  Soft_I2C_Write(&iic_typedef,cmd);
  Soft_I2C_Write(&iic_typedef,0);
  Soft_I2C_Write(&iic_typedef,0);
  Soft_I2C_Stop(&iic_typedef);

  RcuWhichMutexGive(which,1,999);//??I2C1? 
        
}

 #endif
#endif


//==GetColorIR (adr=0x32)Readding ID:  == DON'T DELETE!! == 
#ifdef _GETSMARTEYEDIST_
#ifndef _GETSMARTEYEDIST_EXISTS_
#define _GETSMARTEYEDIST_EXISTS_
#include <jmkernel.h>
#include "I2C_Soft.h"
#define _COLORIR_ADDR_ 0x32
uint32_t GetSmartEyeDist(uint8_t which)
{
   uint8_t data;
   uint32_t port1=portarray[RcuPORT[which][0]];//I2C_SCL
   uint32_t port2=portarray[RcuPORT[which][1]];//I2C_SDA
   uint8_t bit1=RcuPIN[which][0];
   uint8_t bit2=RcuPIN[which][1]; 
   

   RcuWhichMutexTake(which,1,999);//???I2C1?
   Soft_I2C_Typedef iic_typedef;
   Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
          &iic_typedef);

  Soft_I2C_Start(&iic_typedef);
  Soft_I2C_Write(&iic_typedef,_COLORIR_ADDR_);
  Soft_I2C_Write(&iic_typedef,0xAA);//CMD
  Soft_I2C_Write(&iic_typedef,0xD5);//mode
  Soft_I2C_Write(&iic_typedef,0);//addr
  Soft_I2C_Write(&iic_typedef,0);
  Soft_I2C_Write(&iic_typedef,0);
  Soft_I2C_Write(&iic_typedef,0);
  Soft_I2C_Stop(&iic_typedef);

  Soft_I2C_Start(&iic_typedef);
  Soft_I2C_Write(&iic_typedef,_COLORIR_ADDR_+1);
  data=Soft_I2C_Read(&iic_typedef,0);//_COLORIR_ADDR_+1
  data=Soft_I2C_Read(&iic_typedef,1);//
  Soft_I2C_Stop(&iic_typedef);

  RcuWhichMutexGive(which,1,999); 
  if(data!=0xFF) return data;
  else return 0;
        
}

 #endif
#endif


/***ഫ ַ0x52***/
#ifdef _GETLASERDIST_  
#ifndef  _GETLASERDIST_EXISTS_
#define _GETLASERDIST_EXISTS_
#include <jmkernel.h>
#include "I2C_Soft.h"
#include "vl53l0x.h"
 //vl_mode=0,Ĭģʽ1.2ײࣻ   
 //vl_mode=1,ģʽ2ײࡣ
 uint16_t GetLaserDist(uint8_t which, uint8_t vl_mode) 
 {
   uint16_t distance = 0;
 
   uint32_t port1=portarray[RcuPORT[which][0]];//I2C_SCL
   uint32_t port2=portarray[RcuPORT[which][1]];//I2C_SDA  
   uint8_t bit1=RcuPIN[which][0];
   uint8_t bit2=RcuPIN[which][1];
   
   Soft_I2C_Typedef iic_typedef;
   Soft_I2C_BspInit(port2,bit2,//SDA
					 port1,bit1,//SCL
		   &iic_typedef);
   
   vl_init(&iic_typedef);		   
   setTimeout(500);
   
   if( (mode_flag==0)||(vl_mode!=MODE) )
   {
	 mode_flag=1;  
	 if(vl_mode==0){vl_default_mode(&iic_typedef);MODE=0;}
	 if(vl_mode==1){vl_long_mode(&iic_typedef);MODE=1;}  
   }
   
   distance = vl_result(&iic_typedef);	
   if(distance>8000)return 8888;  
   return(distance);
 }
   
 #endif
#endif  




#ifdef _GETGESTURE_
 #ifndef  _GETGESTURE_EXISTS_
  #define _GETGESTURE_EXISTS_
  #include <jmkernel.h>
  #include "PAJ7620.h"
  #include "I2C_Soft.h"
uint8_t GestureInitFlag=0,CheckSensor=0;
uint8_t Sdata=0;//Ƶ
uint32_t GestureO=0,GestureN=0;//ڱʶһʱ
uint8_t GetGesture(uint8_t which)
{
   uint32_t port1=portarray[RcuPORT[which][0]];//I2C_SCL
   uint32_t port2=portarray[RcuPORT[which][1]];//I2C_SDA
   uint32_t port3=portarray[RcuPORT[which][2]];//ADC
   uint8_t bit1=RcuPIN[which][0];
   uint8_t bit2=RcuPIN[which][1];
   uint8_t bit3=RcuPIN[which][2];
   
   uint16_t gesture_data;   
   uint8_t i,status;
   uint8_t data[2];

   GPIO_Setting2((GPIO_TypeDef*)port3,bit3,GPIO_MODE_INPUT);
   CheckSensor=HAL_GPIO_ReadPin((GPIO_TypeDef*)port3,(1<<bit3));

   RcuWhichMutexTake(which,1,999);//ȡ˿IICʹȨ
   Soft_I2C_Typedef iic_typedef;
   Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
                    &iic_typedef);
            

  if(CheckSensor==1) GestureInitFlag=0;
  if(GestureInitFlag==0&&CheckSensor==0)//ѽ봫ʼһ
  {

      while(!paj7620u2_init(&iic_typedef));//PAJ7620U2ʼ
    //paj7620u2_init(&iic_typedef);
      paj7620u2_selectBank(BANK0,&iic_typedef);//BANK0Ĵ
      for(i=0;i<GESTURE_SIZE;i++)
      {
      GS_Write_Byte(gesture_arry[i][0],gesture_arry[i][1],&iic_typedef);//ʶģʽʼ
     } 
    paj7620u2_selectBank(BANK0,&iic_typedef);//лBANK0Ĵ
    GestureInitFlag=1;
 }

      GestureN=GetSystemTime();
	if(GestureN-GestureO>50){
		status = GS_Read_nByte(PAJ_GET_INT_FLAG1,2,&data[0],&iic_typedef);//ȡ״̬
		Sdata=0;
		GestureO=GestureN;
	}

    if(!status)
    {   
      gesture_data =(uint16_t)data[1]<<8 | data[0];

      if(gesture_data) 
      {
        switch(gesture_data)
        {
          case GES_UP:               Sdata=0x01;break; //
          case GES_DOWM:             Sdata=0x02;break; //
          case GES_LEFT:             Sdata=0x03;break; //
          case GES_RIGHT:            Sdata=0x04;break; //
          case GES_FORWARD:          Sdata=0x05;break; //ǰ
          case GES_BACKWARD:         Sdata=0x06;break; //
          case GES_CLOCKWISE:        Sdata=0x07;break; //˳ʱ
          case GES_COUNT_CLOCKWISE:  Sdata=0x08;break; //ʱ
          case GES_WAVE:             Sdata=0x09;break; //Ӷ
          default:  Sdata=0x00; break;          
        }  

      }
      RcuWhichMutexGive(which,1,999);//ͷIIC˿ʹȨ
      return Sdata;   
    }
        //Delay1ms(50);
   /* */
 
  return 0;
}
 #endif
#endif      


#ifdef _GETSHORTIRDIST_
 #ifndef  _GETSHORTIRDIST__EXISTS_
  #define _GETSHORTIRDIST__EXISTS_
  #include <jmkernel.h>
  #include "I2C_Soft.h"
#define _SHORTIRDIST_ADDR_ 0X06
uint16_t GetShortIRDist(uint32_t which)
{
   uint32_t port1=portarray[RcuPORT[which][0]];//I2C_SCL
   uint32_t port2=portarray[RcuPORT[which][1]];//I2C_SDA

   uint8_t bit1=RcuPIN[which][0];
   uint8_t bit2=RcuPIN[which][1];
   
    uint16_t data;
    uint8_t  datah=0,datal=0,cmd=0,s=0,SUM=0;


   RcuWhichMutexTake(which,1,999);//ȡ˿IICʹȨ
   Soft_I2C_Typedef iic_typedef;
   Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
                    &iic_typedef);

  Soft_I2C_Start(&iic_typedef);
  Soft_I2C_Write(&iic_typedef,_SHORTIRDIST_ADDR_);
  Soft_I2C_Write(&iic_typedef,0xAA);
  Soft_I2C_Stop(&iic_typedef);
    
  Soft_I2C_Start(&iic_typedef);
  Soft_I2C_Write(&iic_typedef,_SHORTIRDIST_ADDR_+1);
  cmd=Soft_I2C_Read(&iic_typedef,0); //ݿͷ
  datah=Soft_I2C_Read(&iic_typedef,0); //ݸ߰λ
  datal=Soft_I2C_Read(&iic_typedef,0); //ڰλ
  s=Soft_I2C_Read(&iic_typedef,1);   //
  Soft_I2C_Stop(&iic_typedef);

  SUM=(uint8_t)(cmd+datah+datal);//У
    
  if(SUM!=s)//
  {
      return 999;
  }
  else
  {
      data=(uint16_t)(((uint16_t)datah<<8)|datal);  
  }
  RcuWhichMutexGive(which,1,999);//ͷIIC˿ʹȨ
  return (uint16_t)data;
}
 #endif
#endif  



//==GetWifiCamCtrl Readding ID:  == DON'T DELETE!! ==

#ifdef _GETWIFICAMCTRL_
 #ifndef  _GETWIFICAMCTRL_EXISTS_
  #define _GETWIFICAMCTRL_EXISTS_
 #include <jmkernel.h>
 extern volatile uint8_t UART2_Sletc;
uint32_t GetWifiCamCtrl(void)
{
	uint32_t buf;
	UART2_Sletc=1;//ͷ
	SysCOM_Init(115200);
	buf=WifiCamRX_ISR();
	return buf;
	
}
 #endif
#endif

//==GetWifiCamCtrldata Readding ID:  == DON'T DELETE!! ==

#ifdef _GETWIFICAMCTRLDATA_
 #ifndef  _GETWIFICAMCTRLDATA_EXISTS_
  #define _GETWIFICAMCTRLDATA_EXISTS_
 #include <jmkernel.h>
 extern volatile uint8_t UART2_Sletc;
uint8_t GetWifiCamCtrlData(uint8_t mode)
{
	uint8_t val;
	uint32_t buf;
	UART2_Sletc=1;//ͷ
	SysCOM_Init(115200);
	buf=WifiCamRX_ISR();
	switch(mode)
	{
		case 1:val=(buf>>24)&0xFF;break;//X
		case 2:val=(buf>>16)&0xFF;break;//Y
		case 3:val=(buf>>8)&0xFF;break;//ID
		case 4:val=buf&0xFF;break;//С
	}
	return val;
	
}
 #endif
#endif



//==GetWifiCamCtrl Readding ID:  == DON'T DELETE!! ==

#ifdef _GETWIFICAMROCKCTRL_
 #ifndef  _GETWIFICAMROCKCTRL_EXISTS_
  #define _GETWIFICAMROCKCTRL_EXISTS_
 #include <jmkernel.h>
 extern volatile uint8_t UART2_Sletc;
int8_t GetWifiCamRockCtrl(uint8_t direction,uint8_t axis)
{
	int8_t temp;
	uint32_t buf;
	UART2_Sletc=1;//ͷ
	SysCOM_Init(115200);
	buf=WifiCamRX_Rock();
	if(direction==0)//ҡ
	{
		if(axis==0) temp=(buf>>24)&0xFF;//X
		else if(axis==1) temp=(buf>>16)&0xFF;//Y
	}
	else if(direction==1)//ҡ
	{
		if(axis==0) temp=(buf>>8)&0xFF;//X
		else if(axis==1) temp=buf&0xFF;//Y
	}
	
	return temp;
	
}
 #endif
#endif




//==GetBluetoothControl Readding ID:  == DON'T DELETE!! ==

#ifdef _GETBLUETOOTHCONTROL_
 #ifndef  _GETBLUETOOTHCONTROL_EXISTS_
  #define _GETBLUETOOTHCONTROL_EXISTS_
 #include <jmkernel.h>

uint32_t GetBluetoothControl(void)
{
	return BluetoothPhoneControl();	
}
 #endif
#endif


//==GetBluetoothControl Readding ID:  == DON'T DELETE!! ==

#ifdef _GETBLUETOOTHCONTROLDATA_
 #ifndef  _GETBLUETOOTHCONTROLDATA_EXISTS_
  #define _GETBLUETOOTHCONTROLDATA_EXISTS_
 #include <jmkernel.h>

uint8_t GetBluetoothControlData(void)
{
	uint8_t key;
	uint32_t PhoneKey;	
	PhoneKey = BluetoothPhoneControl();
	switch(PhoneKey)
	{
		case 0x02:  key=1;
		break;
		case 0x04:  key=2;
		break;
		case 0x08:  key=3;
		break;
		case 0x10:  key=4;
		break;
		case 0x20:  key=5;
		break;
		case 0x40:  key=6;
		break;
		case 0x80:  key=7;
		break;
		case 0x100: key=8;
		break;
		default :   key=0;
		break;
	}

	return key;
	
}
 #endif
#endif


//==SetBluetoothData Readding ID:  == DON'T DELETE!! ==

#ifdef _SETBLUETOOTHDATA_
 #ifndef  _SETBLUETOOTHDATA_EXISTS_
  #define _SETBLUETOOTHDATA_EXISTS_
 #include <jmkernel.h>

void SetBluetoothData(uint8_t data)
{
	BluetoothSendData(data);	
}
 #endif
#endif



//==GetBluetoothData Readding ID:  == DON'T DELETE!! ==

#ifdef _GETBLUETOOTHDATA_
 #ifndef  _GETBLUETOOTHDATA_EXISTS_
  #define _GETBLUETOOTHDATA_EXISTS_
 #include <jmkernel.h>

uint8_t GetBluetoothData(void)
{
	return BluetoothReceiveData();	
}
 #endif
#endif


//==GetBTModuleRemoteButton Readding ID:  == DON'T DELETE!! == BE9256
#ifdef _GETBTMODULEREMOTEBUTTON_
 #ifndef  _GETBTMODULEREMOTEBUTTON_EXISTS_
  #define _GETBTMODULEREMOTEBUTTON_EXISTS_
  #include "jdy16.h"


uint16_t GetBTModuleRemoteButton(void)
{

	uint16_t data=999;
	uint32_t code=0;
	uint32_t k=1;
	uint8_t n,i;
	int8_t Rokerdata[4];
	BlueTH_Init(115200); 
	RockerDelayTimInit();
    if(BTroker2RcuData[0]==0x56&&BTroker2RcuData[1]==0xAB&&BTroker2RcuData[2]==0x05&&BTroker2RcuData[15]==0xCF) //У
    {
    	code=(uint32_t)BTroker2RcuData[3]*0x1000000+(uint32_t)BTroker2RcuData[4]*0x10000+(uint32_t)BTroker2RcuData[5]*0x100+(uint32_t)BTroker2RcuData[6];
    	 for(n=0;n<20;n++)
       {
       	 if(code&(k<<n))
       	 {
       	 	 data=n;
       	 	 if(code&(k<<26))
       	 	 {
       	 	 	  data+=20;
       	 	 }
       	 	 break;
       	 }
       }

    }	
	if(data>=12&&data<=19)
	{
		//7X 8Y    9X 10Y
		for(i=0;i<4;i++) Rokerdata[i]=BTroker2RcuData[7+i];
		//0X 1Y    2X 3Y
		if(Rokerdata[3]==100&&(Rokerdata[2]>=-100&&Rokerdata[2]<100)) return 12;
		else if(Rokerdata[2]==100&&(Rokerdata[3]>=-100&&Rokerdata[3]<=100)) return 13;		
		else if(Rokerdata[3]==-100&&(Rokerdata[2]>-100&&Rokerdata[2]<100)) return 14;
		else if(Rokerdata[2]==-100&&(Rokerdata[3]>=-100&&Rokerdata[3]<=100)) return 15;
		
		else if(Rokerdata[1]==100&&(Rokerdata[0]>=-100&&Rokerdata[0]<100)) return 16;
		else if(Rokerdata[0]==100&&(Rokerdata[1]>=-100&&Rokerdata[1]<=100)) return 17;
		else if(Rokerdata[1]==-100&&(Rokerdata[0]>-100&&Rokerdata[0]<100)) return 18;
		else if(Rokerdata[0]==-100&&(Rokerdata[1]>=-100&&Rokerdata[1]<=100)) return 19;
		else return 999;
	}
    else return data;
}
 #endif
#endif

//==GetBTModuleRemoteCode Readding ID:  == DON'T DELETE!! == BE9256
#ifdef _GETBTMODULEREMOTECODE_
 #ifndef  _GETBTMODULEREMOTECODE_EXISTS_
  #define _GETBTMODULEREMOTECODE_EXISTS_
#include "jdy16.h"
uint32_t GetBTModuleRemoteCode(void)
{
	uint32_t code=0;
	uint32_t k=1;
	uint8_t n;
	
	BlueTH_Init(115200); 
	RockerDelayTimInit();
    if(BTroker2RcuData[0]==0x56&&BTroker2RcuData[1]==0xAB&&BTroker2RcuData[2]==0x05&&BTroker2RcuData[15]==0xCF) //У
    {
    	code=(uint32_t)BTroker2RcuData[3]*0x1000000+(uint32_t)BTroker2RcuData[4]*0x10000+(uint32_t)BTroker2RcuData[5]*0x100+(uint32_t)BTroker2RcuData[6];   
	}
	return code; 
   
}
 #endif
#endif


//==GetBTModuleRemoteRocker Readding ID:  == DON'T DELETE!! == BE9256
#ifdef _GETBTMODULEREMOTEROCKER_
 #ifndef  _GETBTMODULEREMOTEROCKER_EXISTS_
  #define _GETBTMODULEREMOTEROCKER_EXISTS_
#include "jdy16.h"

int16_t GetBTModuleRemoteRocker(uint8_t direction,uint8_t axis)
{
  int16_t data=999; 
  uint8_t n;
  
  BlueTH_Init(115200); 
  RockerDelayTimInit();
    if(BTroker2RcuData[0]==0x56&&BTroker2RcuData[1]==0xAB&&BTroker2RcuData[2]==0x05&&BTroker2RcuData[15]==0xCF) //У
    {
       if(direction==0)
       {
            switch(axis)
            {
               case 0x00:{data=(int8_t)BTroker2RcuData[7];}break; //X
               case 0x01:{data=(int8_t)BTroker2RcuData[8];}break; //Y
               default:{data=999;}
            } 
        
        }
        else
        {
            switch(axis)
            {
               case 0x00:{data=(int8_t)BTroker2RcuData[9];}break; //X
               case 0x01:{data=(int8_t)BTroker2RcuData[10];}break; //Y
               default:{data=999;}
            } 
        }
    }
    return data;
}
 #endif
#endif


#ifdef _SETIRBOARD_
 #ifndef  _SETIRBOARD_EXISTS_
  #define _SETIRBOARD_EXISTS_
  #include <jmkernel.h>
  #include "I2C_Soft.h"
  
#define _SETIRBOARD_ADDR_   0X08
void SetIRBoard(uint8_t which,uint8_t addr,uint8_t mode,uint8_t color)
{
   uint32_t port1=portarray[RcuPORT[which][0]];//I2C_SCL
   uint32_t port2=portarray[RcuPORT[which][1]];//I2C_SDA
   uint32_t port3=portarray[RcuPORT[which][2]];//ADC
   uint8_t bit1=RcuPIN[which][0];
   uint8_t bit2=RcuPIN[which][1];
   uint8_t bit3=RcuPIN[which][2];
   
   uint16_t data;
   uint8_t  cmd=0;

   RcuWhichMutexTake(which,1,999);//ȡ˿IICʹȨ
   Soft_I2C_Typedef iic_typedef;
   Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
        &iic_typedef);
   if(mode>3)mode=3;
   if(color>63)color=63;
   cmd = (mode<<6|color);
   Soft_I2C_Start(&iic_typedef);
   Soft_I2C_Write(&iic_typedef,_SETIRBOARD_ADDR_);
   Soft_I2C_Write(&iic_typedef,0xAA);
   Soft_I2C_Write(&iic_typedef,addr);
   Soft_I2C_Write(&iic_typedef,cmd);
   Soft_I2C_Stop(&iic_typedef);
   RcuWhichMutexGive(which,1,999);//ͷIIC˿ʹȨ
}
 #endif
#endif


//==GetRFPenCode Readding ID:  == DON'T DELETE!! == BE9237ֵ
#ifdef _GETRFPENCODE_
 #ifndef  _GETRFPENCODE_EXISTS_
  #define _GETRFPENCODE_EXISTS_
  #include "I2C_Soft.h"
   #define _I2C_addr_w  0XA0

uint32_t GetRFPenCode(uint8_t which)
{
   uint32_t port1=portarray[RcuPORT[which][0]];//I2C_SCL
   uint32_t port2=portarray[RcuPORT[which][1]];//I2C_SDA
   uint8_t bit1=RcuPIN[which][0];
   uint8_t bit2=RcuPIN[which][1];
  uint32_t data=0X1000000;
  uint8_t check_sum=0;
  uint8_t rf_data[32]={0x00};  
  uint8_t n;


  RcuWhichMutexTake(which,1,999);//ȡ˿IICʹȨ
   Soft_I2C_Typedef iic_typedef;
   Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
        &iic_typedef);

   delay_iic=IIC_SPEED_100K;//20->100k 34->70k 30->78k
   Soft_I2C_Start(&iic_typedef);
    Soft_I2C_Write(&iic_typedef,_I2C_addr_w);
    Soft_I2C_Write(&iic_typedef,0xaa);    
    Soft_I2C_Write(&iic_typedef,0x55);    
    Soft_I2C_Write(&iic_typedef,0x05);//,ѯ
    check_sum+=0x05;
    Soft_I2C_Write(&iic_typedef,0x04); 
    check_sum+=0x04;
    Soft_I2C_Write(&iic_typedef,0x00); 
    check_sum+=0x00;
   Soft_I2C_Write(&iic_typedef,check_sum); 
   Soft_I2C_Stop(&iic_typedef);
  
    Soft_I2C_Start(&iic_typedef);
    Soft_I2C_Write(&iic_typedef,_I2C_addr_w+1);
    for(n=0;n<15;n++) //һҪȡл
    {
         rf_data[n]=Soft_I2C_Read(&iic_typedef,0);
    }
    rf_data[15]=Soft_I2C_Read(&iic_typedef,1);
    Soft_I2C_Stop(&iic_typedef);
    if(rf_data[0]==0x56&&rf_data[1]==0xAB&&rf_data[2]==0x31&&rf_data[15]==0xCF)
    {
       data=(uint32_t)rf_data[3]*0x10000+(uint32_t)rf_data[4]*0x100+(uint32_t)rf_data[5];
    }
    delay_iic=IIC_SPEED_DEFAULT;//ָĬٶ
    RcuWhichMutexGive(which,1,999);//ͷIIC˿ʹȨ
   return data;
}
 #endif
#endif

//==GetRFID (adr=0x50)Readding ID:  == DON'T DELETE!! == rc522 // I2C 0x50
//rfid
#ifdef _GETRFID522_
#ifndef  __GETRFID522__EXISTS_
#define __GETRFID522__EXISTS_
#include <jmkernel.h>
#include "I2C_Soft.h"
#include "MFRC522.h"
uint8_t rc522Reset=1;//rc522ʼ־λ
uint32_t GetRFID522(uint8_t which)//ѡģʽ
{
   uint32_t port1=portarray[RcuPORT[which][0]];//I2C_SCL
   uint32_t port2=portarray[RcuPORT[which][1]];//I2C_SDA
   uint32_t port3=portarray[RcuPORT[which][2]];//RST
   uint8_t bit1=RcuPIN[which][0];
   uint8_t bit2=RcuPIN[which][1];
   uint8_t bit3=RcuPIN[which][2];   
   
   RcuWhichMutexTake(which,1,999);//ȡ˿IICʹȨ
   Soft_I2C_Typedef iic_typedef;
   Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
          &iic_typedef);

    unsigned char TagType[2];
  uint8_t SelectedSnr[4];
  uint32_t tmp;
   
    char status;
  unsigned char i=1;

    if(rc522Reset)
    {//ʼrc522
  GPIO_Setting((GPIO_TypeDef*)port3,bit3,GPIO_MODE_OUTPUT_PP);
   HAL_GPIO_WritePin((GPIO_TypeDef*)port3,(1<<bit3),GPIO_PIN_SET);
  Delay1ms(1);
   HAL_GPIO_WritePin((GPIO_TypeDef*)port3,(1<<bit3),GPIO_PIN_RESET);
  Delay1ms(1);
   HAL_GPIO_WritePin((GPIO_TypeDef*)port3,(1<<bit3),GPIO_PIN_SET);
  Delay1ms(1);

    WriteRawRC(CommandReg,PCD_RESETPHASE,&iic_typedef); 
    WriteRawRC(ModeReg,0x3D,&iic_typedef);//MifareͨѶCRCʼֵ0x6363
  WriteRawRC(TReloadRegL,30,&iic_typedef);           
  WriteRawRC(TReloadRegH,0,&iic_typedef);
  WriteRawRC(TModeReg,0x8D,&iic_typedef);
  WriteRawRC(TPrescalerReg,0x3E,&iic_typedef);
  WriteRawRC(TxAutoReg,0x40,&iic_typedef);
  
  ClearBitMask(TxControlReg, 0x03,&iic_typedef);//ر
  i = ReadRawRC(TxControlReg,&iic_typedef);//
    if (!(i & 0x03))
    { SetBitMask(TxControlReg, 0x03,&iic_typedef);  }
  rc522Reset=0;
    }
 
  else
  {
  status = PcdRequest(REQ_ALL,TagType,&iic_typedef);//Ѱ
  if(!status)
  {
    status = PcdAnticoll(SelectedSnr,&iic_typedef);//ײ
    { PcdHalt(&iic_typedef);  }
  }
  }
  tmp=SelectedSnr[0]*0x1000000+SelectedSnr[1]*0x10000+SelectedSnr[2]*0x100+SelectedSnr[3];
  return tmp;
}

 #endif
#endif



//==_SETRFID_ (adr=0x50)Readding ID:  == DON'T DELETE!! == 
//rfidд
#ifdef _SETRFID522_
#ifndef  _SETRFID522_EXISTS_
#define _SETRFID522_EXISTS_
#include <jmkernel.h>
#include "I2C_Soft.h"
#include "MFRC522.h"
uint8_t rc522Reset=1;//rc522ʼ־λ
uint32_t SetRFID522(uint8_t which,uint8_t mode,uint8_t buf)//ѡģʽ
{
   uint32_t port1=portarray[RcuPORT[which][0]];//I2C_SCL
   uint32_t port2=portarray[RcuPORT[which][1]];//I2C_SDA
   uint32_t port3=portarray[RcuPORT[which][2]];//RST
   uint8_t bit1=RcuPIN[which][0];
   uint8_t bit2=RcuPIN[which][1];
   uint8_t bit3=RcuPIN[which][2];   
   
   RcuWhichMutexTake(which,1,999);//ȡ˿IICʹȨ
   Soft_I2C_Typedef iic_typedef;
   Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
          &iic_typedef);
          
  unsigned char DefaultKey[6] = {0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF};
    unsigned char TagType[2];
  uint8_t SelectedSnr[4];
  uint32_t tmp;
   
    char status;
  //unsigned char snr, buf[16];
  unsigned char snr;
  unsigned char i=1;

    if(rc522Reset)
    {//ʼrc522
  GPIO_Setting((GPIO_TypeDef*)port3,bit3,GPIO_MODE_OUTPUT_PP);
  HAL_GPIO_WritePin((GPIO_TypeDef*)port3,(1<<bit3),GPIO_PIN_SET);
  Delay1ms(1);
   HAL_GPIO_WritePin((GPIO_TypeDef*)port3,(1<<bit3),GPIO_PIN_RESET);
  Delay1ms(1);
   HAL_GPIO_WritePin((GPIO_TypeDef*)port3,(1<<bit3),GPIO_PIN_SET);
  Delay1ms(1);

    WriteRawRC(CommandReg,PCD_RESETPHASE,&iic_typedef); 
    WriteRawRC(ModeReg,0x3D,&iic_typedef);//MifareͨѶCRCʼֵ0x6363
  WriteRawRC(TReloadRegL,30,&iic_typedef);           
  WriteRawRC(TReloadRegH,0,&iic_typedef);
  WriteRawRC(TModeReg,0x8D,&iic_typedef);
  WriteRawRC(TPrescalerReg,0x3E,&iic_typedef);
  WriteRawRC(TxAutoReg,0x40,&iic_typedef);
  
  ClearBitMask(TxControlReg, 0x03,&iic_typedef);//ر
  i = ReadRawRC(TxControlReg,&iic_typedef);//
    if (!(i & 0x03))
    { SetBitMask(TxControlReg, 0x03,&iic_typedef);  }
  rc522Reset=0;
    }
 
  else
  {
//  buf[0]=6;
  status = PcdRequest(REQ_ALL,TagType,&iic_typedef);//ѰƬͣѰʽ飩
  if(!status)
  {
    status = PcdAnticoll(SelectedSnr,&iic_typedef);//ײSelectedSnrλţ
    if(!status)
    { 
      status=PcdSelect(SelectedSnr,&iic_typedef);//ѡƬ
      if(!status)
      {
        snr = 1;  //1ĸ
        status = PcdAuthState(KEYA, (snr*4+3), DefaultKey, SelectedSnr, &iic_typedef);// У1룬λÿһ3
          if(!status)
        {
          if(mode==0)//ģʽѡ񣬶1
          { 
            status = PcdRead((snr*4+0), &buf, &iic_typedef);  // ȡ10ݵbuf[0]-buf[16]
            return buf[0];
          }
          if(mode==1)//ģʽѡд1
          { 
            status = PcdWrite((snr*4+0), &buf, &iic_typedef);  // дbuf[0]-buf[16]д10 
          }
          if(!status)
          {
            WaitCardOff(&iic_typedef);//ȴƬ뿪
          }
        }
      }
    }
  }
  }
  tmp=status;
  return tmp;
}

 #endif
#endif

//==GetCamRecog Readding ID:  == DON'T DELETE!! == ȡͷģݰ
#ifdef _GETCAMRECOG_
 #ifndef  _GETCAMRECOG_EXISTS_
  #define _GETCAMRECOG_EXISTS_
	#include <jmkernel.h>
extern volatile uint8_t UART2_Sletc;
int8_t GetCamRecog(uint8_t mode)
{
	int8_t val=0;

	uint32_t buf,buf2;
	UART2_Sletc=1;//ͷ
	SysCOM_Init(115200);
	if(mode>4&&mode<9){
		buf=WifiCamRX_ISR();//ͼ
	}
	if(mode>8&&mode<13){
		buf2=WifiCamRX_Rock();//ҡ
	}
	switch(mode)
	{
		case 0:val=0x56;break;//ݰʽ
		case 1:val=0xAB;break;//ݰʽ
		case 2:val=0x14;break;//ݰʽ
		case 3:val=0xE8;break;//ݰʽ
		case 4:val=0x13;break;//ݰʽ

		case 5:val=(buf>>24)&0xFF;break;//X
		case 6:val=(buf>>16)&0xFF;break;//Y
		case 7:val=(buf>>8)&0xFF;break; //ID
		case 8:val=buf&0xFF;break;      //С

		case 9:val=(buf2>>24)&0xFF;break; //ҡx
		case 10:val=(buf2>>16)&0xFF;break;//ҡy
		case 11:val=(buf2>>8)&0xFF;break; //ҡx
		case 12:val=buf2&0xFF;break;      //ҡy
	}

	return val;
	
}
 #endif
#endif

//==GetWifiPictureData Readding ID:  == DON'T DELETE!! == ȡͷģ
//0άID	1:ͼ	 2:ͼX	 3:ͼY
#ifdef _GETWIFIPICTUREDATA_
 #ifndef  _GETWIFIPICTUREDATA_EXISTS_
  #define _GETWIFIPICTUREDATA_EXISTS_
	#include <jmkernel.h>
extern volatile uint8_t UART2_Sletc;
uint8_t GetWifiPictureData(uint8_t mode)
{
	uint8_t val=0;

	uint32_t buf;
	UART2_Sletc=1;//ͷ
	SysCOM_Init(115200);
	buf=WifiCamRX_ISR();//ͼ
	switch(mode)
	{
		case 0:val=(buf>>8)&0xFF;break; //άID
		case 1:val=buf&0xFF;break;			//ͼ
		case 2:val=(buf>>24)&0xFF;break;	//ͼX
		case 3:val=(buf>>16)&0xFF;break;	//ͼY
	}

	return val;
	
}
 #endif
#endif

//==GetWifiCamRockCtrlNew Readding ID:  == DON'T DELETE!! == ȡͷģ
//0ҡx	1:ҡy	 2:ҡx	 3:ҡy
#ifdef _GETWIFICAMROCKCTRLNEW_
 #ifndef  _GETWIFICAMROCKCTRLNEW_EXISTS_
  #define _GETWIFICAMROCKCTRLNEW_EXISTS_
	#include <jmkernel.h>
extern volatile uint8_t UART2_Sletc;
int8_t GetWifiCamRockCtrlNew(uint8_t mode)
{
	int8_t val=0;

	uint32_t buf2;
	UART2_Sletc=1;//ͷ
	SysCOM_Init(115200);
	buf2=WifiCamRX_Rock();//ҡ

	switch(mode)
	{
		case 0:val=(buf2>>24)&0xFF;break; //ҡx
		case 1:val=(buf2>>16)&0xFF;break; //ҡy
		case 2:val=(buf2>>8)&0xFF;break;  //ҡx
		case 3:val=buf2&0xFF;break;       //ҡy
	}

	return val;
	
}
 #endif
#endif


//==GetWifiCamPictureResult Readding ID:  == DON'T DELETE!! == ȡͷģݰ
//ͷͼĽά룩⵽1ⲻ0
#ifdef _GETWIFICAMPICTURERESULT_
 #ifndef  _GETWIFICAMPICTURERESULT_EXISTS_
  #define _GETWIFICAMPICTURERESULT_EXISTS_
	#include <jmkernel.h>
extern volatile uint8_t UART2_Sletc;
uint8_t GetWifiCamPictureResult(uint8_t mode)
{
	uint8_t val=0;

	uint32_t buf;
	UART2_Sletc=1;//ͷ
	SysCOM_Init(115200);
	buf=WifiCamRX_ISR();//ͼ
	
	val=buf&0xFF;      //ȡͼС

	if(val>0) return 1;
	else return 0;
}
 #endif
#endif


//==GetWifiCamPictureSize Readding ID:  == DON'T DELETE!! == ͷͼСĽ
//012ʾ󡱡СС
//롰󡱣Ҽ⵽ͼΪ󡱣1򷵻0
//롰СҼ⵽ͼΪС1򷵻0
//롰СҼ⵽ͼΪС1򷵻0
#ifdef _GETWIFICAMPICTURESIZE_
 #ifndef  _GETWIFICAMPICTURESIZE_EXISTS_
  #define _GETWIFICAMPICTURESIZE_EXISTS_
	#include <jmkernel.h>
extern volatile uint8_t UART2_Sletc;
uint8_t GetWifiCamPictureSize(uint8_t mode)
{
	uint8_t val=0,Result=0;

	uint32_t buf;
	UART2_Sletc=1;//ͷ
	SysCOM_Init(115200);
	buf=WifiCamRX_ISR();//ͼ
	
	val=buf&0xFF;      //С
	
	if(mode==0&&val>=110&&val<255) {Result=1;}			//
	else if(mode==1&&val>=60&&val<110) {Result=1;}	//
	else if(mode==2&&val>0&&val<60) {Result=1;}	//С
	else Result=0;

	return Result;
	
}
 #endif
#endif


//==GetWifiCamPictureSite Readding ID:  == DON'T DELETE!! == ȡͷͼ⵽λ
//01234ʾϡ¡󡱡ҡС
//롰////СҼ⵽ͼΪ////С1򷵻0
#ifdef _GETWIFICAMPICTURESITE_
 #ifndef  _GETWIFICAMPICTURESITE_EXISTS_
  #define _GETWIFICAMPICTURESITE_EXISTS_
	#include <jmkernel.h>
extern volatile uint8_t UART2_Sletc;
uint8_t GetWifiCamPictureSite(uint8_t mode)
{
	uint8_t val=0,val2=0,Result=0;

	uint32_t buf;
	UART2_Sletc=1;//ͷ
	SysCOM_Init(115200);
	buf=WifiCamRX_ISR();//ͼ

	val=(buf>>24)&0xFF;//X
	val2=(buf>>16)&0xFF;//Y

	if(mode==0&&val2<=128&&val2>0) {Result=1;}						//
	else if(mode==1&&val2>128) {Result=1;}							//
	else if(mode==2&&val<=128&&val>0) {Result=1;}					//
	else if(mode==3&&val>128) {Result=1;}							//
	else if(mode==4&&val>64&&val<192&&val2>64&&val2<192) {Result=1;}//
	
	return Result;
	
}
 #endif
#endif

#ifdef _SETDISPLAYLATTICE_
 #ifndef  _SETDISPLAYLATTICE_EXISTS_
  #define _SETDISPLAYLATTICE_EXISTS_
#include "HT1632cDriver.h"
void SetDisplayLattice(uint8_t which,char* pic,int8_t luminance)
{
   u32 port1=portarray[RcuPORT[which][0]];//
   u32 port2=portarray[RcuPORT[which][1]];//
   u32 port3=portarray[RcuPORT[which][2]];//

   u8 bit1=RcuPIN[which][0];
   u8 bit2=RcuPIN[which][1];
   u8 bit3=RcuPIN[which][2];

	 RcuWhichMutexTake(which,1,999);//ȡ˿IICʹȨ
	 Soft_DI2C_Typedef Diic_typedef;
	 Soft_DI2C_BspInit(port1,bit1,//DATA
                    port2,bit2,//WR
				  port3,bit3,//CS
										&Diic_typedef);   

   Adafruit_HT1632(&Diic_typedef);//˿ڲ
   
   begin(ADA_HT1632_COMMON_16NMOS,luminance);//ʼģʽ
												//ȿƣΧ0x0-0xF   
   //zi1616(TEXT1);//ԼַԶͼ
   
   //ʾһ16x16ĺֻ8x16ֻ
   ziku1616(pic);//ʾ16x16ַ

   RcuWhichMutexGive(which,1,999);
}
 #endif
#endif

#ifdef _SETDISPLAYLATTICEPIC_
 #ifndef  _SETDISPLAYLATTICEPIC_EXISTS_
  #define _SETDISPLAYLATTICEPIC_EXISTS_
#include "HT1632cDriver.h"
void SetDisplayLatticePic(uint8_t which,int8_t* pic,int8_t luminance)
{
   u32 port1=portarray[RcuPORT[which][0]];//
   u32 port2=portarray[RcuPORT[which][1]];//
   u32 port3=portarray[RcuPORT[which][2]];//

   u8 bit1=RcuPIN[which][0];
   u8 bit2=RcuPIN[which][1];
   u8 bit3=RcuPIN[which][2];

	 RcuWhichMutexTake(which,1,999);//ȡ˿IICʹȨ
	 Soft_DI2C_Typedef Diic_typedef;
	 Soft_DI2C_BspInit(port1,bit1,//DATA
                    port2,bit2,//WR
				  port3,bit3,//CS
										&Diic_typedef);   

   Adafruit_HT1632(&Diic_typedef);//˿ڲ
   
   begin(ADA_HT1632_COMMON_16NMOS,luminance);//ʼģʽ
												//ȿƣΧ0x0-0xF   
   //zi1616(TEXT1);//ԼַԶͼ
   
   //ʾһ16x16ĺֻ8x16ֻ
   hua1616(pic);////Ʒר

   RcuWhichMutexGive(which,1,999);
}
 #endif
#endif

#ifdef _SETDISPLAYLATTICESTRING_
 #ifndef  _SETDISPLAYLATTICESTRING_EXISTS_
  #define _SETDISPLAYLATTICESTRING_EXISTS_
#include "HT1632cDriver.h"
//ʾַ
void SetDisplayLatticeString(uint8_t which,char* pic,int8_t direction,uint32_t speed,int8_t luminance)
{//                            ˿    ַ      ƶ  ٶ       
   u32 port1=portarray[RcuPORT[which][0]];//
   u32 port2=portarray[RcuPORT[which][1]];//
   u32 port3=portarray[RcuPORT[which][2]];//

   u8 bit1=RcuPIN[which][0];
   u8 bit2=RcuPIN[which][1];
   u8 bit3=RcuPIN[which][2];
   

	 RcuWhichMutexTake(which,1,999);//ȡ˿IICʹȨ
	 Soft_DI2C_Typedef Diic_typedef;
	 Soft_DI2C_BspInit(port1,bit1,//DATA
                    port2,bit2,//WR
				  port3,bit3,//CS
										&Diic_typedef);   

   Adafruit_HT1632(&Diic_typedef);//˿ڲ
   
   begin(ADA_HT1632_COMMON_16NMOS,luminance);//ʼģʽ
												//ȿƣΧ0x0-0xF   

   String1616(pic,direction,speed);
   RcuWhichMutexGive(which,1,999);
}
 #endif
#endif

#ifdef _SETDISPLAYLATTICECLEAR_
 #ifndef  _SETDISPLAYLATTICECLEAR_EXISTS_
  #define _SETDISPLAYLATTICECLEAR_EXISTS_
#include "HT1632cDriver.h"
//
void SetDisplayLatticeClear(uint8_t which)
{//                            ˿    ַ      ƶ         
   u32 port1=portarray[RcuPORT[which][0]];//
   u32 port2=portarray[RcuPORT[which][1]];//
   u32 port3=portarray[RcuPORT[which][2]];//

   u8 bit1=RcuPIN[which][0];
   u8 bit2=RcuPIN[which][1];
   u8 bit3=RcuPIN[which][2];
   

	 RcuWhichMutexTake(which,1,999);//ȡ˿IICʹȨ
	 Soft_DI2C_Typedef Diic_typedef;
	 Soft_DI2C_BspInit(port1,bit1,//DATA
                    port2,bit2,//WR
				  port3,bit3,//CS
										&Diic_typedef);   

   Adafruit_HT1632(&Diic_typedef);//˿ڲ
   
   begin(ADA_HT1632_COMMON_16NMOS,15);//ʼģʽ
												//ȿƣΧ0x0-0xF   
												
   clearScreen();
   
   RcuWhichMutexGive(which,1,999);
}
 #endif
#endif

#ifdef _SETDISPLAYLATTICEXY_
 #ifndef  _SETDISPLAYLATTICEXY_EXISTS_
  #define _SETDISPLAYLATTICEXY_EXISTS_
#include "HT1632cDriver.h"
//һĲ
void SetDisplayLatticeXY(uint8_t which,int8_t x,int8_t y,uint8_t state,uint8_t luminance)
{//                            ˿        X  Y     /          
   u32 port1=portarray[RcuPORT[which][0]];//
   u32 port2=portarray[RcuPORT[which][1]];//
   u32 port3=portarray[RcuPORT[which][2]];//

   u8 bit1=RcuPIN[which][0];
   u8 bit2=RcuPIN[which][1];
   u8 bit3=RcuPIN[which][2];
   

	 RcuWhichMutexTake(which,1,999);//ȡ˿IICʹȨ
	 Soft_DI2C_Typedef Diic_typedef;
	 Soft_DI2C_BspInit(port1,bit1,//DATA
                    port2,bit2,//WR
				  port3,bit3,//CS
										&Diic_typedef);   

   Adafruit_HT1632(&Diic_typedef);//˿ڲ
   
   begin(ADA_HT1632_COMMON_16NMOS,luminance);//ʼģʽ
												//ȿƣΧ0x0-0xF   
												
   AloneXY(x-1,y-1,state);
   
   RcuWhichMutexGive(which,1,999);
}
 #endif
#endif


#ifdef _GETAICAMDATA_
 #ifndef  _GETAICAMDATA_EXISTS_
  #define _GETAICAMDATA_EXISTS_
 #include <jmkernel.h>
 extern volatile uint8_t UART2_Sletc;
 extern volatile uint32_t AISystemTimeO=0,AISystemTimeN=0;
uint8_t GetAICamData(uint8_t cmd)//P8
{
	
	uint8_t buf;
	UART2_Sletc=1;////ͷ
	SysCOM_Init(115200);
	AISystemTimeN=(uint32_t)GetSystemTime();
    switch(cmd)
   {

		case 1:buf=(GetCOMPackData(0)>>24)&0xFF;break; 
		case 2:buf=(GetCOMPackData(0)>>16)&0xFF;break; 
		case 3:buf=(GetCOMPackData(0)>>8)&0xFF;break;  
		case 4:buf=GetCOMPackData(0)&0xFF;break;       
		case 5:buf=(GetCOMPackData(1)>>24)&0xFF;break; 
		case 6:buf=(GetCOMPackData(1)>>16)&0xFF;break; 
		case 7:buf=(GetCOMPackData(1)>>8)&0xFF;break;  
		case 8:buf=GetCOMPackData(1)&0xFF;break;     
    case 9:buf=(GetCOMPackData(2)>>24)&0xFF;break; 
		case 10:buf=(GetCOMPackData(2)>>16)&0xFF;break; 
		case 11:buf=(GetCOMPackData(2)>>8)&0xFF;break;  
		case 12:buf=GetCOMPackData(2)&0xFF;break;
		case 13:buf=(GetCOMPackData(3)>>8)&0xFF;break;
		case 14:buf=GetCOMPackData(3)&0xFF;break;	   
		default:buf=0;break;

    }
	if(AISystemTimeN - AISystemTimeO >= 500)
	  {
		  SetCOMPackData(0);
		  SetCOMPackData(1);
      SetCOMPackData(2);
		  AISystemTimeO = AISystemTimeN;
	  }
	return buf;
}
 #endif
#endif



#ifdef _SETAICAMDATA_
 #ifndef  _SETAICAMDATA_EXISTS_
  #define _SETAICAMDATA_EXISTS_
 #include <jmkernel.h>
 extern volatile uint8_t UART2_Sletc;
void SetAICamData(uint8_t cmd0,uint8_t cmd1)//P8
{
	
	uint8_t buf;
	UART2_Sletc=1;////ͷ
	SysCOM_Init(115200);
    SetCOMByteData(cmd0,cmd1);
}
 #endif
#endif

#ifdef _SETWAITFORAICAMDATA_
 #ifndef  _SETWAITFORAICAMDATA_EXISTS_
  #define _SETWAITFORAICAMDATA_EXISTS_
 #include <jmkernel.h>
 extern volatile uint8_t UART2_Sletc;
void SetWaitForAICamData(uint8_t cmd0,uint8_t cmd1)//P8
{
	
	uint8_t buf,time=0;
	UART2_Sletc=1;////ͷ
	SysCOM_Init(115200);
  while(1)
	{
		SetCOMByteData(0xEE,0xFF);
		Delay1ms(50);
		time++;
		if(((((GetCOMPackData(0)>>24)&0xFF)==0xF0)&&(((GetCOMPackData(0)>>16)&0xFF)==0xF1))||time>200)break;
	}
	Delay1ms(10);
	SetCOMByteData(cmd0,cmd1);
}
 #endif
#endif


#ifdef _GETAICAMVOICE_
 #ifndef  _GETAICAMVOICE_EXISTS_
  #define _GETAICAMVOICE_EXISTS_
 #include <jmkernel.h>
 extern volatile uint8_t UART2_Sletc;
uint16_t GetAICamVoice(uint16_t cmd)//P8
{
	
    uint8_t buf;
    uint16_t cmp=0;
    UART2_Sletc=1;////ͷ
    SysCOM_Init(115200);
    cmp=((uint8_t)((GetCOMPackData(3)>>8)&0xFF))*256+((uint8_t)GetCOMPackData(3)&0xFF);
    if(cmp==cmd) 
    {
        SetCOMPackData(3);
        return 1;
    }
    else return 0;
}
 #endif
#endif

#ifdef _GETCOMVOICE_
 #ifndef  _GETCOMVOICE_EXISTS_
  #define _GETCOMVOICE_EXISTS_
 #include <jmkernel.h>
 extern volatile uint8_t UART2_Sletc;
int8_t GetComVoice(int8_t* pic)//P8
{
	int s=-1;
	s=ReadComVoiceResult(pic);
	if(s==-1)return 0;
	else return 1;//ʶɹ

}
 #endif
#endif


#ifdef _GETSCANCAMERA_
 #ifndef  _GETSCANCAMERA_EXISTS_
  #define _GETSCANCAMERA_EXISTS_
 
uint16_t GetScanCamera(void)
{//P8ȡ
	//E3000Yõɨ
	//E3000HѾʼΪɨ
	uint8_t which=8;//P8
	uint32_t port2 = portarray[RcuPORT[which][1]];
	uint8_t bit2=RcuPIN[which][1];	
	
	GPIO_Setting((GPIO_TypeDef*)port2,bit2,GPIO_MODE_OUTPUT_PP);
	HAL_GPIO_WritePin((GPIO_TypeDef*)port2,(1<<bit2),GPIO_PIN_RESET);	
	uint16_t buf;
	uint32_t BaudRate=115200;

	SysCOM_Init(BaudRate);
	buf=ReadCOMData();//ʱ999
	if(buf!=0x0D&&buf!=0x0A&&buf!=999&&buf!=0xE7)
	{//0D 0AE3000Yֹͣ־λE3000Hûλ
		buf=buf-48;
	}
	else
	{
		buf=999;		
	}
	return buf;
}
 #endif
#endif


#ifdef _GETAIRPRESSURE_
 #ifndef  _GETAIRPRESSURE_EXISTS_
  #define _GETAIRPRESSURE_EXISTS_
 #include <jmkernel.h>
#include "gmp102.h"
//ѹ
float GetAirPressure(u8 which) 
{
  uint32_t port1=portarray[RcuPORT[which][0]];//I2C_SCL
  uint32_t port2=portarray[RcuPORT[which][1]];//I2C_SDA  
  uint8_t bit1=RcuPIN[which][0];
  uint8_t bit2=RcuPIN[which][1];
  
  float Pressure=0;
  RcuWhichMutexTake(which,1,999);//ȡ˿IICʹȨ
  Soft_I2C_Typedef iic_typedef;
  Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
          &iic_typedef);
  //return GetPressure(&iic_typedef);
  Pressure = GetPressure(&iic_typedef);
  RcuWhichMutexGive(which,1,999);//ͷIIC˿ʹȨ
  return PressureDataPro(Pressure);
}  
 #endif
#endif

#ifdef _GETSHT30_
 #ifndef  _GETSHT30_EXISTS_
  #define _GETSHT30_EXISTS_
 #include <jmkernel.h>
#include "sht30.h"
/* SHT30ʪȴ
 TEMPERATURE  0		//¶
 HUMIDITY  1		//ʪ
*/
float GetSht30(u8 which, u8 command) 
{
  uint32_t port1=portarray[RcuPORT[which][0]];//I2C_SCL
  uint32_t port2=portarray[RcuPORT[which][1]];//I2C_SDA  
  uint8_t bit1=RcuPIN[which][0];
  uint8_t bit2=RcuPIN[which][1];
  
  RcuWhichMutexTake(which,1,999);//ȡ˿IICʹȨ
  Soft_I2C_Typedef iic_typedef;
  Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
          &iic_typedef);
  
  //  result = periodicFetchData(&iic_typedef); 
  
  ReadTempAndHumi(&iic_typedef);
  RcuWhichMutexGive(which,1,999);//ͷIIC˿ʹȨ
  Delay1ms(15);
  if(command==0) return cTemp;
  if(command==1) return humidity;
  
}  
 #endif
#endif

#ifdef _GETMAGNETIC_
 #ifndef  _GETMAGNETIC_EXISTS_
  #define _GETMAGNETIC_EXISTS_
 #include <jmkernel.h>
/*
 model  0	//ųǿ
 model  1	//ų
*/
uint16_t GetMagnetic(u8 which, u8 model) 
{
	uint32_t port3 = portarray[RcuPORT[which][2]];
	uint8_t bit3=RcuPIN[which][2];
	uint16_t i;
	uint16_t strength,direction;
	GPIO_Setting((GPIO_TypeDef*)port3,bit3,GPIO_MODE_ANALOG);
	
	i=GetAdcResult(which);
	if(i>2000) {strength=i-2000;}
	else {strength=2000-i;}
	
	if(i>2300) {direction=1;}
	else if(i<1700) {direction=2;}
	else {direction=0;}

	if(model==0) return strength;
	if(model==1) return direction;	
	//return (uint16_t)i;  
}  
 #endif
#endif



