#ifndef _FONT_H_
#define _FONT_H_

#define FLASH_SECTOR_SIZE 				4096
#define FAT_SECTOR_SIZE 					4096

#define FONT_FLASH_ADDR_START		0x00600000//ֿFLASHеʼַ
#define FONT_FLASH_SENTOR_START	0x600//ֿFLASHеʼ/4096
#define DISK_FONT_LIB_SIZE				0x200000//ֿռ2MB
#define FONT_FLASH_SENTOR_NUM		(DISK_FONT_LIB_SIZE/FAT_SECTOR_SIZE)//512//ֿռ
//ֿ1 DBR1
#define FONT_DBR1Cluster		  	0x600//ʼ
#define FONT_DBR1ClusterSize		0x01//ռݴصĴС
#define FONT_DBR1Addr			    	(FONT_DBR1Cluster*FAT_SECTOR_SIZE)//ʼַ(DBRCluster*4096)=0X000
#define FONT_DBR1Size			    	(FONT_DBR1ClusterSize*FAT_SECTOR_SIZE)//1*4096
//ֿ2 DBR2
#define FONT_DBR2Cluster		  	(FONT_DBR1Cluster+FONT_DBR1ClusterSize)//0x601//ʼ
#define FONT_DBR2ClusterSize		0x01//ռݴصĴС
#define FONT_DBR2Addr			    	(FONT_DBR2Cluster*FAT_SECTOR_SIZE)//ʼַ(DBRCluster*4096)=0X000
#define FONT_DBR2Size			    	(FONT_DBR2ClusterSize*FAT_SECTOR_SIZE)//1*4096

//ʵֿDATA
#define FONT_DATACluster	 	    (FONT_DBR2Cluster+FONT_DBR2ClusterSize)//0x602//(ROOTCluster+ROOTClusterSize)//0x07//ʼ
#define FONT_DATAClusterSize    (FONT_FLASH_SENTOR_NUM-FONT_DBR1ClusterSize-FONT_DBR2ClusterSize)//500//ռݴصĴС
#define FONT_DATAAddr	 	        (FONT_DATACluster*FAT_SECTOR_SIZE)//ʼַDATACluster*4096 28672=0X7000
#define FONT_DATASize		        (FONT_DATAClusterSize*FAT_SECTOR_SIZE)//500*4096

//ɹдֿı־λ,жֿǷдɹ/ֿ֮дflash
#define FONT_UPGRADE_FLAG				0xAA55AB56//0xAAAA5555//
#define FONT_UPGRADE_SIZE				(FONT_DATASize+FONT_DBR2Size)
#define FONT_UPGRADECluster			FONT_DBR2Cluster//FONT_DATACluster
#define FONT_CHECK_FLAG					0xAA55AB56//ֿ־λJMDFONT.DAT BYTE16-BYTE19Ϊֿ־

#define FONT_ROOT_SIZE					((FONT_DBR1Size-32)>>5)//ֿֿĿ¼(4096-32)/32=127

//***********************************************************************
#define LCD_ILI9325		0//ɰҺ
#define LCD_ST7789		1//°Һ
#define LCD_ILI9341		2//°Һ
#define LCD_RM68090		3//ɰҺ

#define FONT_TYPE_ASCII	0X0000//ASCII
#define FONT_TYPE_CN			0X0001//
#define FONT_LIB_FLAG			0X56AB55AA
//0x8006000-0x800600F//ֿƵ 0xAA,0x55,0xAB,0x56,Ϊͷ
//0x8006010-0x800601F//ֿϢ
//0x8006020ֿʼַ
#define FONT_LIB_ADDRESS					0x8006800//0x8006000
#define FONT_LIB_INFOMADDRESS		(FONT_LIB_ADDRESS+0x10)//0x8006010
#define ASCII_LIB_SADDRESS				(FONT_LIB_ADDRESS+0x20)//0x8006020

typedef enum
{
	LCD_TYPED_NC=0,
	LCD_TYPED_ASCII_I=1,//ڲflash
	LCD_TYPED_ASCII_O=2,//FLASHֿ 8*16
	LCD_TYPED_CN_I=3,
	LCD_TYPED_CN_O=4//FLASHֿ 16*16
}Lcd_Type_Defined;
typedef enum
{
	TYPE_ASCII_8X16=0,//ASCII 8*16
	TYPE_CN_16X16=1,// 16*16
	TYPE_ASCII_16X32=2,//ASCII 16*32
	TYPE_CN_32X32=3,// 32*32
}Font_Type_Defined;

typedef struct
{
	u16 height;//ֱ
	u16 width;
	u16 fwbyte;//ģռֽ
	u16 fsize;//ֿģ
	u16 type;//ֿ
	u32 startaddress;//ֿʼַ
	u16 fsbyte;//һַռֽ
	u8 charbyte;//һַռֽ,ASCIIռ1,2
	u8 fonttype;//ǰֿ 1 ascii,2 flash ascii ,3 cn(ڲ)4 flash cn
}Lcd_Lib_Typedef;

#endif
