from Qt.QtGui import *
from Qt.QtCore import *
from Qt.QtWidgets import *
import Qt.QtCompat

import maya.OpenMayaUI as apiUI

import os
import pdb
import webbrowser

db = pdb.set_trace

_winback = (38, 40, 43, 250)
_buttback = (29, 29, 35, 255)
_tabback = (16, 18, 25, 255)
_textfore = (190, 190, 193, 130)
_lineback = (16, 18, 25, 255)
_labelfor = (85, 85, 90, 100)

_gradTop = (27, 73, 135, 15)
_gradBot = (48, 147, 215, 75)

_butthov = (38, 50, 65, 130)
_frame = (235, 235, 0, 25)
_ouf = (255, 255, 0, 255)
_style = '''

QMainWindow{{
    background-color: rgba(255, 255, 25, 255);
    color : rgba(255, 255, 25, 255);
}}

QTabBar{{
    background-color: rgba{buttback};
    color : rgba{textforce};
}}

QSpinBox{{
    background-color: rgba{buttback};
    color: rgba{textforce};
}}

QGroupBox{{
    background-color: rgba{buttback};
    color: rgba{textforce};
}}

QMenuBar{{
    background-color: rgba{buttback};
}}

QMainWindow{{
    background-color: rgba{lineback};
}}

QPushButton:pressed{{
    background-color: rgba{textforce};
}}

QLabel{{
    color: rgba{labelfor};
}}

QCheckBox{{
    color: rgba{labelfor};
}}

QFrame{{
    background-color: rgba{tabback};
    color: rgba{textforce};
}}


QPushButton,QCheckBox,QComboBox{{
    background-color: rgba{buttback};
    color: rgba{textforce};
    border-radius: 1px 1px 1px 1px;
    border-color: rgb(255,10,10);
    height: 20px;
}}

QPushButton:hover, QCheckBox:hover, QComboBox:hover{{
    background-color: rgba{butthov};
    border-radius: 2px 2px 2px 2px;
}}

QPushButton:checked{{
    background-color: qlineargradient(spread:pad, x1:0.035533, y1:0, x2:0.248838, y2:1, stop:0 rgba{gradtop}, stop:1 rgba{gradbot});
    border-radius: 2px 2px 2px 2px;
}}

QLineEdit{{
    background-color: rgba{tabback};
    color: rgba{textforce};
}}

QTreeWidget:item:selected{{
    background: rgba{butthov};
    color: rgba{textforce};
}}

QTreeWidget{{
    color: rgba{textforce};
    background-color: rgba{tabback};
    show-decoration-selected: 0;
}}

;'''.format(
    winback=_winback,
    buttback=_buttback,
    tabback=_tabback,
    textforce=_textfore,
    lineback=_lineback,
    labelfor=_labelfor,
    gradtop=_gradTop,
    gradbot=_gradBot,
    butthov=_butthov,
    frame=_frame,
    ouf=_ouf)


def getMayaWin():
    winPtr = apiUI.MQtUtil.mainWindow()

    if not winPtr:
        raise Exception('could find MayaWindow Pointer')

    mayaWindow = Qt.QtCompat.wrapInstance(long(winPtr), QWidget)

    return mayaWindow


class Frameless(QMainWindow, QObject):

    prevSize = QSize()
    offset = QPoint()
    prev = QPoint()
    previous = False
    miniSize = 32

    wheeled = Signal(int)

    def __init__(self, parent=getMayaWin()):
        QMainWindow.__init__(self, parent)

        self.settings = Settings(__file__.split()[-1])

        self.setContentsMargins(0, 0, 0, 0)
        self.setMouseTracking(True)
        self.setStatusBar(None)
        self.setSheet()
        self.setKey()

    def mouseMoveEvent(self, event):

        if event.buttons() == Qt.QtCore.Qt.MidButton:
            if not self.previous:
                self.prev = event.globalPos()
                self.offset = event.pos()
                self.previous = True
                return

            out = event.globalPos() - self.prev
            self.move(self.prev - self.offset + out)

        if event.buttons() == Qt.QtCore.Qt.RightButton:
            if not self.previous:
                self.prev = event.globalPos()
                self.prevSize = self.size()
                self.previous = True
                return

            out = event.globalPos() - self.prev
            self.resize(self.prevSize.width() + out.x(),
                        self.prevSize.height() + out.y()
                        )

    def mouseReleaseEvent(self, event):
        self.previous = False

    def wheelEvent(self, event):
        self.wheeled.emit(event.delta())

    def setKey(self):

        action = QAction(self)
        action.setShortcut(QKeySequence(Qt.QtCore.Qt.Key_Escape))
        action.triggered.connect(self.close)

        self.addAction(action)

    def setSheet(self):
        self.setStyleSheet(_style)

    def addBar(self, help=""):

        self.bar = QToolBar()
        self.butTheme = QPushButton('')
        self.butWindo = QPushButton('')
        self.butAbout = QPushButton('')

        self.logo = VertextureLogo(url="www.vertexture.org")
        pixlogo = QPixmap(':/vertexture/skin/vertexture/logoHs_color.png')
        self.butTheme.setIcon(self.pixmap(':/vertexture/skin/bar/darkgrey.png'))
        self.butWindo.setIcon(self.pixmap(':/vertexture/skin/bar/framegrey.png'))
        self.butAbout.setIcon(self.pixmap(':/vertexture/skin/bar/questiongrey.png'))
        self.logo.setPixmap(pixlogo)

        self.spacer = QWidget()
        self.spacer.setSizePolicy(QSizePolicy.Expanding, QSizePolicy.Preferred)

        self.bar.setMinimumHeight(self.miniSize)
        self.bar.setMaximumHeight(self.miniSize)
        self.bar.setFloatable(False)
        self.bar.setMovable(False)

        self.logo.setMaximumWidth(120)

        map(lambda x: x.setMinimumHeight(self.miniSize-4), (self.butTheme,
                                                          self.butWindo,
                                                          self.butAbout))

        map(lambda x: x.setIconSize(QSize(28, 28)),
            [self.butTheme, self.butWindo, self.butAbout])

        self.butTheme.setCheckable(True)
        self.butWindo.setCheckable(True)

        self.butTheme.clicked.connect(self.themeEvent)
        self.butWindo.clicked.connect(self.windoEvent)
        self.butAbout.clicked.connect(lambda: self.aboutEvent(help))

        self.bar.addWidget(self.logo)
        self.bar.addWidget(self.spacer)

        self.bar.addWidget(self.butTheme)
        self.bar.addWidget(self.butWindo)
        self.bar.addWidget(self.butAbout)

        self.addToolBar(self.bar)
        self.addToolTips()
        self.restore()

    def addToolTips(self):
        """Description
        """
        self.butTheme.setToolTip("Change the theme to dark or light")
        self.butWindo.setToolTip("Restore/remove the window frame ")
        self.butAbout.setToolTip("bring more information about the app")

    def restore(self):
        """Description
        """
        table = {
            self.butTheme: 'theme',
            self.butWindo: "window"}

        for key, value in table.items():

            stored = self.settings.load(value)

            if stored:
                key.setChecked(eval(stored.capitalize()))
                key.clicked.emit()

    def windoEvent(self):
        """Description
        """
        if self.sender().isChecked():
            self.setWindowFlags(Qt.QtCore.Qt.FramelessWindowHint |
                                Qt.QtCore.Qt.Window)
        else:
            self.setWindowFlags(Qt.QtCore.Qt.Window)

        self.settings.save('window', self.sender().isChecked())
        self.show()

    def themeEvent(self):
        """Description
        """
        butts = [self.butTheme, self.butWindo, self.butAbout]

        # -- darkTheme
        if self.sender().isChecked():

            self.setStyleSheet(_style)

            for butt in butts or []:
                butt.setStyleSheet("background-color: rgba(16,18,25,255)")

        # -- lightTheme
        else:

            for butt in butts or []:
                butt.setMaximumHeight(self.miniSize-2)
                butt.setFlat(True)


            self.setStyleSheet('')

        self.settings.save('theme', self.sender().isChecked())

    def pixmap(self, path):

        pix = QPixmap(path)
        pixresized = pix.scaled(self.miniSize-10, self.miniSize-10)
        return QIcon(pixresized)

    def aboutEvent(self, help):
        """Description
        """
        about = AboutWin(help)
        about.size(400, 800)
        about.setWindowTitle("Manual Reference")
        about.setWindowIcon(QIcon(QPixmap(':/vertexture/skin/vertexture/logoHs_color.png')))
        about.show()

# ====================================================================
# ====================================================================
class OpenGl(Frameless, QObject):
    # need to display OpenGl mesh in a QGLwidget
    # in the right file?

    def __init__(self, parent=getMayaWin()):
        QMainWindow.__init__(self, parent)
        pass


# ====================================================================
# ====================================================================
# ====================================================================
# ====================================================================
class Confirmation(QWidget, QObject):

    _output = str()

    returned = Signal(tuple)

    _result = str()

    def __init__(self, genre="path",
                 label="",
                 infos="",
                 boomrang="",
                 placeHolder="",
                 object=None,
                 parent=None):

        QWidget.__init__(self, parent)

        self.placeHolder = placeHolder
        self.boomrang = boomrang
        self.object = object
        self.label = label
        self.infos = infos
        self.genre = genre
        self.setWin()

        self.setPrefs()
        self.setConnections()

        self.mainPop.show()

    def setConnections(self):
        self.okButton.clicked.connect(self.apply)
        self.cancelButton.clicked.connect(self.ignore)
        self.input.returnPressed.connect(self.apply)
        self.input.installEventFilter(self)

    def eventFilter(self, obj, event):

        if obj == self.input:
            if (event.type() == QEvent.KeyPress or
                    event.type() == QEvent.KeyRelease):

                self.checkInput()
                obj.event(event)
                return True
        return False

    def __repr__(self):
        return self._result

    def checkInput(self):
        self.log.clear()

        text = str(self.input.text())

        if self.genre == "path":
            if not os.path.exists(text):
                self.okButton.setHidden(True)
                self.log.setText("\'{}\' does not exist".format(text))

            else:
                self.log.setText("status ok".format())
                self.okButton.setHidden(False)

    def ignore(self):

        self.returned.emit(tuple())
        self.mainPop.close()

    def apply(self):
        self.checkInput()
        path = str(self.input.text())
        self.returned.emit((path, self.boomrang))

        self._result = path
        self.mainPop.close()

    def setPrefs(self):
        self.notice.setAlignment(
            Qt.QtCore.Qt.AlignHCenter | Qt.QtCore.Qt.AlignVCenter)
        self.log.setAlignment(Qt.QtCore.Qt.AlignHCenter |
                              Qt.QtCore.Qt.AlignVCenter)
        self.vlayout.setContentsMargins(0, 0, 0, 0)
        self.okButton.setHidden(True)

        self.mainPop.setWindowModality(Qt.QtCore.Qt.WindowModal)

        if self.placeHolder:
            self.input.setText(self.placeHolder)
            self.checkInput()

    def setWin(self):

        self.mainPop = Frameless()

        self.notice = QLabel(self.label)
        self.input = QLineEdit("")
        self.log = QLabel(self.infos)

        self.okButton = QPushButton("Confirm", self)
        self.cancelButton = QPushButton("Ignore", self)

        mainLayout = QVBoxLayout(self)
        self.vlayout = QVBoxLayout(self)
        self.hlayout = QHBoxLayout(self)

        self.vlayout.addWidget(self.notice)
        self.vlayout.addWidget(self.input)
        self.vlayout.addWidget(self.log)

        self.hlayout.addWidget(self.okButton)
        self.hlayout.addWidget(self.cancelButton)

        self.setLayout(mainLayout)
        mainLayout.addLayout(self.vlayout)
        mainLayout.addLayout(self.hlayout)

        self.mainPop.setCentralWidget(self)


class JukeBox(QWidget, QObject):
    """Items as several buttons stacked vertically  = list()
    notice is the label on top = string()
    """

    returned = Signal(tuple)

    _result = str()

    def __init__(self, notice="Pick Item", parent=None, *items):
        QWidget.__init__(self, parent)

        self.items = items[0]
        self.noti = notice

        self.setWin()
        self.mainPop.show()

    def setWin(self):

        self.mainPop = Frameless()
        self.notice = QLabel(self.noti.title())
        self.notice.setAlignment(
            Qt.QtCore.Qt.AlignHCenter | Qt.QtCore.Qt.AlignVCenter)

        mainLayout = QVBoxLayout(self)
        mainLayout.setContentsMargins(5, 5, 5, 5)
        mainLayout.addWidget(self.notice)

        for item in self.items:
            butt = QPushButton(item)
            butt.setSizePolicy(QSizePolicy.Expanding, QSizePolicy.Expanding)
            butt.setMinimumHeight(50)

            mainLayout.addWidget(butt)
            butt.clicked.connect(self.buttClicked)

        self.setLayout(mainLayout)
        self.mainPop.setCentralWidget(self)

    def buttClicked(self):
        name = str(self.sender().text())
        self._result = name
        self.returned.emit((name,))
        self.mainPop.close()

    def __repr__(self):
        return self._result


class Prefs(QWidget, QObject):

    prefsChanged = Signal(str)

    def __init__(self):
        QWidget.__init__(self, parent)

        self.setWin()
        self.show()

    def setWin(self):

        self.mainPop = Frameless()


class DiInvertLabel(QLabel, QObject):
    """A inverted display label, with a clicked signal
    """

    clicked = Signal()

    def __init__(self, label='title', parent=None):
        QLabel.__init__(self, parent)

        self._label = label
        # self.setMaximumSize(220, 25)
        self.border = 5
        self.light = 170

    @property
    def light(self):
        return self._light

    @light.setter
    def light(self, value):
        self._light = value
        self.update()

    @property
    def label(self):
        return str(self._label)

    @label.setter
    def label(self, value):
        self._label = value
        self.update()

    @property
    def border(self):
        return self._border

    @border.setter
    def border(self, value):
        self._border = value
        self.update()

    def mousePressEvent(self, event):

        if event.button() == Qt.QtCore.Qt.LeftButton:
            self.clicked.emit()
            self.update()

    def paintEvent(self, event):

        painter = QPainter(self)
        painter.setRenderHint(QPainter.Antialiasing, True)

        textBrush = self.palette().base()
        textColor = textBrush.color()
        font = QFont('FreeSans', 11, QFont.Bold)

        textLabel = QPainterPath()
        textLabel.addText(5, self.size().height() * .7, font, self.label)

        painter.setPen(Qt.QtCore.Qt.NoPen)
        painter.setBrush(QBrush(textColor.lighter(self.light)))
        bound = textLabel.boundingRect()

        painter.drawRoundedRect(0, 0,
                                bound.right() + 8,
                                bound.bottom(),
                                self.border,
                                self.border)

        painter.setBrush(textBrush)
        painter.drawPath(textLabel)


class InteractiveText(QTextEdit, QObject):
    """Send a dblClick signal with the text double clicked
    """

    rightClick = Signal()
    dblClick = Signal(str)
    midClick = Signal()

    def __init__(self, parent=None):
        QTextEdit.__init__(self, parent)

    def mouseDoubleClickEvent(self, event):
        QTextEdit.mouseDoubleClickEvent(self, event)

        cursor = self.textCursor()

        if cursor.hasSelection():
            text = cursor.selectedText()

            self.dblClick.emit(text)

    def mousePressEvent(self, event):

        if event.buttons() == Qt.QtCore.Qt.MidButton:
            self.midClick.emit()

        if event.buttons() == Qt.QtCore.Qt.RightButton:
            self.rightClick.emit()


class AboutWin(QWidget, QObject):
    """Display a widown with html
    """

    def __init__(self, text, parent=None):
        super(AboutWin, self).__init__(parent)

        self.main = Frameless()
        self.doc = InteractiveText()
        self.doc.document().setDefaultStyleSheet(
            "p,li { white-space: pre-wrap; }")

        self.doc.setHtml(text)
        self.doc.setReadOnly(True)

        self.lay = QVBoxLayout()
        self.lay.addWidget(self.doc)
        self.setLayout(self.lay)

        self.main.setCentralWidget(self)
        self.main.show()

    def setContent(self, txt):
        self.doc.setHtml(txt)

    def setWindowTitle(self, title):
        """Set the title of the windown
        """
        self.main.setWindowTitle(title)

    def size(self, x=470, y=170):
        """Reset the size of the window
        """
        self.main.resize(x, y)


class MimeWin(QWidget, QObject):

    def __init__(self, parent=None):
        QWidget.__init__(self, parent)

        self.setAcceptDrops(True)
        self.resize(500, 500)

    def mousePressEvent(self, event):
        if event.button() == Qt.QtCore.Qt.LeftButton:
            print 'in Mime %s' % mime.text()

    def dragEnterEvent(self, event):

        if event.mouseButtons() == Qt.QtCore.Qt.MidButton:
            event.acceptProposedAction()
            print 'dragEnterEvent accpeted'

    def dragLeaveEvent(self, event):
        pass

    def dragMoveEvent(self, event):
        pass

    def dropEvent(self, event):
        # print 'dropEvent'

        mime = QMimeData()
        mime.setText(';'.join(cmds.ls(sl=True)))

        print 'in Mime %s' % mime.text()


class VertextureLogo(QLabel, QObject):

    def __init__(self, url, parent=None):
        QLabel.__init__(self, parent)
        self.url = url
        # self.setCursor(Qt.QtCore.Qt.DragMoveCursor)

    def mousePressEvent(self, event):
        pass
        # if event.button() == Qt.QtCore.Qt.LeftButton:
            # webbrowser.open(self.url, new=2)


class Settings(QObject):

    def __init__(self, name ):
        self.settings = QSettings('Dize', name)

    def clear(self):
        self.settings.clear()

    def save(self, attr, value) :
        self.settings.setValue(attr, value)

    def load(self, attr):

        if self.settings.contains(attr):
            return self.settings.value(attr)