// ==UserScript==
// @name         知乎美化
// @namespace    http://tampermonkey.net/
// @version      1.5.3
// @description  ①【重要更新】增加夜间模式按钮 ②知乎题目栏增加举报、匿名、问题日志、快捷键四个按钮 ③知乎大多数按钮图标(题目按钮、回答下方按钮、评论按钮等)，在鼠标悬停时变色 ④回答的发布时间移至顶部 ⑤图片原图显示 ⑥文字和卡片链接从知乎跳转链接改为直链 ⑦集成其他脚本的知乎视频下载功能 ⑧【实验功能】隐藏侧边栏 ⑨GIF图自动播放【默认不开启】
// @author       AN drew
// @match        *://www.zhihu.com/*
// @match        https://zhuanlan.zhihu.com/*
// @match        https://v.vzuu.com/video/*
// @match        https://video.zhihu.com/video/*
// @require      https://cdn.bootcdn.net/ajax/libs/jquery/3.1.1/jquery.min.js
// @require      https://cdn.bootcdn.net/ajax/libs/jquery-cookie/1.4.1/jquery.cookie.min.js
// @connect      zhihu.com
// @connect      vzuu.com
// @grant        GM_info
// @grant        GM_download
// @grant        unsafeWindow
// ==/UserScript==

var publishTop=1; //置顶回答时间
var hideIndexSidebar=1;       //隐藏首页侧边栏
var hideQuestionSidebar=1;    //隐藏回答侧边栏
var hideSearchSideBar=1;      //隐藏搜索侧边栏
var hideTopicSideBar=1;       //隐藏话题侧边栏
var hideCollectionSideBar=1;  //隐藏收藏侧边栏
var hideClubSideBar=1;        //隐藏圈子侧边栏
var GIFAutoPlay=0; //GIF自动播放


var light='data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBzdGFuZGFsb25lPSJubyI/PjwhRE9DVFlQRSBzdmcgUFVCTElDIC'+
        'ItLy9XM0MvL0RURCBTVkcgMS4xLy9FTiIgImh0dHA6Ly93d3cudzMub3JnL0dyYXBoaWNzL1NWRy8xLjEvRFREL3N2ZzExLmR0ZCI+PHN2ZyB0PSIxNTkxNjA2NzI5MzM4IiB'+
        'jbGFzcz0iaWNvbiIgdmlld0JveD0iMCAwIDEwMjQgMTAyNCIgdmVyc2lvbj0iMS4xIiB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHAtaWQ9IjkxNSIgd2lk'+
        'dGg9IjMyIiBoZWlnaHQ9IjMyIiB4bWxuczp4bGluaz0iaHR0cDovL3d3dy53My5vcmcvMTk5OS94bGluayI+PGRlZnM+PHN0eWxlIHR5cGU9InRleHQvY3NzIj5AZm9udC1mY'+
        'WNlIHsgZm9udC1mYW1pbHk6IGVsZW1lbnQtaWNvbnM7IHNyYzogdXJsKCJjaHJvbWUtZXh0ZW5zaW9uOi8vYmJha2hubWZramVuZmJoamRkZGlwY2VmbmhwaWtqYmovZm9udH'+
        'MvZWxlbWVudC1pY29ucy53b2ZmIikgZm9ybWF0KCJ3b2ZmIiksIHVybCgiY2hyb21lLWV4dGVuc2lvbjovL2JiYWtobm1ma2plbmZiaGpkZGRpcGNlZm5ocGlramJqL2ZvbnR'+
        'zL2VsZW1lbnQtaWNvbnMudHRmICIpIGZvcm1hdCgidHJ1ZXR5cGUiKTsgfQo8L3N0eWxlPjwvZGVmcz48cGF0aCBkPSJNNTEyLjEgNzQzLjVjLTEyNy42IDAtMjMxLjQtMTAz'+
        'LjgtMjMxLjQtMjMxLjRzMTAzLjgtMjMxLjQgMjMxLjQtMjMxLjQgMjMxLjQgMTAzLjggMjMxLjQgMjMxLjQtMTAzLjggMjMxLjQtMjMxLjQgMjMxLjR6IG0wLTM5My40Yy04O'+
        'S4zIDAtMTYyIDcyLjctMTYyIDE2MnM3Mi43IDE2MiAxNjIgMTYyIDE2Mi03Mi43IDE2Mi0xNjItNzIuNy0xNjItMTYyLTE2MnpNNTEyLjEgMjI3LjFjLTE5LjIgMC0zNC43LT'+
        'E1LjUtMzQuNy0zNC43Vjk4LjdjMC0xOS4yIDE1LjUtMzQuNyAzNC43LTM0LjcgMTkuMiAwIDM0LjcgMTUuNSAzNC43IDM0Ljd2OTMuN2MwIDE5LjEtMTUuNSAzNC43LTM0Ljc'+
        'gMzQuN3pNMjg2IDMyMC43Yy04LjkgMC0xNy44LTMuNC0yNC41LTEwLjJsLTY2LjMtNjYuM2MtMTMuNi0xMy42LTEzLjYtMzUuNSAwLTQ5LjEgMTMuNS0xMy42IDM1LjUtMTMu'+
        'NiA0OS4xIDBsNjYuMyA2Ni4zYzEzLjYgMTMuNiAxMy42IDM1LjUgMCA0OS4xYTM0LjY4IDM0LjY4IDAgMCAxLTI0LjYgMTAuMnpNMTkyLjQgNTQ2LjhIOTguN2MtMTkuMiAwL'+
        'TM0LjctMTUuNS0zNC43LTM0LjcgMC0xOS4yIDE1LjUtMzQuNyAzNC43LTM0LjdoOTMuN2MxOS4yIDAgMzQuNyAxNS41IDM0LjcgMzQuNyAwIDE5LjEtMTUuNSAzNC43LTM0Lj'+
        'cgMzQuN3pNMjE5LjggODM5LjFjLTguOSAwLTE3LjgtMy40LTI0LjUtMTAuMi0xMy42LTEzLjYtMTMuNi0zNS41IDAtNDkuMWw2Ni4zLTY2LjNjMTMuNS0xMy42IDM1LjUtMTM'+
        'uNiA0OS4xIDAgMTMuNiAxMy42IDEzLjYgMzUuNSAwIDQ5LjFsLTY2LjMgNjYuM2MtNi45IDYuOC0xNS43IDEwLjItMjQuNiAxMC4yek01MTIuMSA5NjAuMmMtMTkuMiAwLTM0'+
        'LjctMTUuNS0zNC43LTM0Ljd2LTkzLjdjMC0xOS4yIDE1LjUtMzQuNyAzNC43LTM0LjcgMTkuMiAwIDM0LjcgMTUuNSAzNC43IDM0Ljd2OTMuN2MwIDE5LjItMTUuNSAzNC43L'+
        'TM0LjcgMzQuN3pNODA0LjQgODM5LjFjLTguOSAwLTE3LjgtMy40LTI0LjUtMTAuMmwtNjYuMy02Ni4zYy0xMy42LTEzLjYtMTMuNi0zNS41IDAtNDkuMSAxMy41LTEzLjYgMz'+
        'UuNS0xMy42IDQ5LjEgMGw2Ni4zIDY2LjNjMTMuNiAxMy42IDEzLjYgMzUuNSAwIDQ5LjFhMzQuNjggMzQuNjggMCAwIDEtMjQuNiAxMC4yek05MjUuNSA1NDYuOGgtOTMuN2M'+
        'tMTkuMiAwLTM0LjctMTUuNS0zNC43LTM0LjcgMC0xOS4yIDE1LjUtMzQuNyAzNC43LTM0LjdoOTMuN2MxOS4yIDAgMzQuNyAxNS41IDM0LjcgMzQuNyAwIDE5LjEtMTUuNSAz'+
        'NC43LTM0LjcgMzQuN3pNNzM4LjIgMzIwLjdjLTguOSAwLTE3LjgtMy40LTI0LjUtMTAuMi0xMy42LTEzLjYtMTMuNi0zNS41IDAtNDkuMWw2Ni4zLTY2LjNjMTMuNS0xMy42I'+
        'DM1LjUtMTMuNiA0OS4xIDAgMTMuNiAxMy42IDEzLjYgMzUuNSAwIDQ5LjFsLTY2LjMgNjYuM2MtNi45IDYuOC0xNS44IDEwLjItMjQuNiAxMC4yeiIgZmlsbD0iI2Y0ZWEyYS'+
        'IgcC1pZD0iOTE2Ij48L3BhdGg+PC9zdmc+'

var dark='data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBzdGFuZGFsb25lPSJubyI/PjwhRE9DVFlQRSBzdmcgUFVCTElDI'+
    'CItLy9XM0MvL0RURCBTVkcgMS4xLy9FTiIgImh0dHA6Ly93d3cudzMub3JnL0dyYXBoaWNzL1NWRy8xLjEvRFREL3N2ZzExLmR0ZCI+PHN2ZyB0PSIxNTkxNjAzODE3ODAwI'+
    'iBjbGFzcz0iaWNvbiIgdmlld0JveD0iMCAwIDEwMjQgMTAyNCIgdmVyc2lvbj0iMS4xIiB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHAtaWQ9IjExMDEiI'+
    'HhtbG5zOnhsaW5rPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5L3hsaW5rIiB3aWR0aD0iMTYiIGhlaWdodD0iMTYiPjxkZWZzPjxzdHlsZSB0eXBlPSJ0ZXh0L2NzcyI+QGZvb'+
    'nQtZmFjZSB7IGZvbnQtZmFtaWx5OiBlbGVtZW50LWljb25zOyBzcmM6IHVybCgiY2hyb21lLWV4dGVuc2lvbjovL2JiYWtobm1ma2plbmZiaGpkZGRpcGNlZm5ocGlramJqL'+
    '2ZvbnRzL2VsZW1lbnQtaWNvbnMud29mZiIpIGZvcm1hdCgid29mZiIpLCB1cmwoImNocm9tZS1leHRlbnNpb246Ly9iYmFraG5tZmtqZW5mYmhqZGRkaXBjZWZuaHBpa2pia'+
    'i9mb250cy9lbGVtZW50LWljb25zLnR0ZiAiKSBmb3JtYXQoInRydWV0eXBlIik7IH0KPC9zdHlsZT48L2RlZnM+PHBhdGggZD0iTTUwMy40IDk1OS4yYy0xNTYuMSAwLTMwM'+
    'y4xLTgzLjItMzgzLjUtMjE3LjNsLTQ1LjgtNzYuMyA4Ny4yIDE3LjNjNDQgOC44IDg4LjkgOC42IDEzMy4yLTAuNkMzODIuNiA2NjQuNCA0NTguMyA2MTMgNTA3LjggNTM4Y'+
    'zQ5LjUtNzUuMSA2Ni44LTE2NC45IDQ4LjctMjUzLTExLjgtNTcuMy0zOC40LTExMC43LTc2LjktMTU0LjRsLTU4LjctNjYuNyA4OC44IDEuMmMyNDMuMSAzLjQgNDQwLjggM'+
    'jAzLjkgNDQwLjggNDQ3IDAgMjQ2LjUtMjAwLjYgNDQ3LjEtNDQ3LjEgNDQ3LjF6TTIzOC4zIDc2OC4xYzY4LjUgNzEuNCAxNjMgMTEyLjMgMjY1LjEgMTEyLjMgMjAzLjEgM'+
    'CAzNjguMy0xNjUuMiAzNjguMy0zNjguMyAwLTE3MS42LTExOS42LTMxNy40LTI3OS44LTM1Ny40IDE5LjQgMzUuNyAzMy41IDc0LjMgNDEuOCAxMTQuNCA0Ni4xIDIyNC40L'+
    'Tk4LjkgNDQ0LjQtMzIzLjMgNDkwLjUtMjQgNS00OCA3LjgtNzIuMSA4LjV6IiBmaWxsPSIjMDAwMDAwIiBwLWlkPSIxMTAyIj48L3BhdGg+PC9zdmc+'

var $hint =$('<div>'+
'   <div>'+
'    <div>'+
'     <div class="Modal-wrapper Modal-enter-done">'+
'      <div class="Modal-backdrop"></div>'+
'      <div class="Modal Modal--default ShortcutHintModal" tabindex="0">'+
'       <div class="Modal-inner">'+
'        <h3 class="Modal-title">快捷键帮助</h3>'+
'        <div class="Modal-content">'+
'         <div class="ShortcutHintModal-content">'+
'          <div class="ShortcutHintModal-hintListContainer">'+
'           <div class="ShortcutHintModal-hintList">'+
'            <div class="ShortcutHintModal-hintTitle">'+
'             操作'+
'            </div>'+
'            <div class="KeyHint">'+
'             <div class="KeyHint-keyContainer">'+
'              <div class="KeyHint-key">'+
'               <kbd class="KeyHint-kbd">V</kbd>'+
'              </div>'+
'             </div>'+
'             <div>'+
'              ：赞同'+
'             </div>'+
'            </div>'+
'            <div class="KeyHint">'+
'             <div class="KeyHint-keyContainer">'+
'              <div class="KeyHint-key">'+
'               <kbd class="KeyHint-kbd">D</kbd>'+
'              </div>'+
'             </div>'+
'             <div>'+
'              ：反对'+
'             </div>'+
'            </div>'+
'            <div class="KeyHint">'+
'             <div class="KeyHint-keyContainer">'+
'              <div class="KeyHint-key">'+
'               <kbd class="KeyHint-kbd">L</kbd>'+
'              </div>'+
'             </div>'+
'             <div>'+
'              ：喜欢'+
'             </div>'+
'            </div>'+
'            <div class="KeyHint">'+
'             <div class="KeyHint-keyContainer">'+
'              <div class="KeyHint-key">'+
'               <kbd class="KeyHint-kbd">C</kbd>'+
'              </div>'+
'             </div>'+
'             <div>'+
'              ：展开 / 收起评论'+
'             </div>'+
'            </div>'+
'            <div class="KeyHint">'+
'             <div class="KeyHint-keyContainer">'+
'              <div class="KeyHint-key">'+
'               <kbd class="KeyHint-kbd">Shift</kbd>'+
'               <div class="KeyHint-separator">'+
'                +'+
'               </div>'+
'              </div>'+
'              <div class="KeyHint-key">'+
'               <kbd class="KeyHint-kbd">C</kbd>'+
'              </div>'+
'             </div>'+
'             <div>'+
'              ：聚焦到评论框'+
'             </div>'+
'            </div>'+
'            <div class="KeyHint">'+
'             <div class="KeyHint-keyContainer">'+
'              <div class="KeyHint-key">'+
'               <kbd class="KeyHint-kbd">O</kbd>'+
'              </div>'+
'             </div>'+
'             <div>'+
'              ：展开 / 收起全文'+
'             </div>'+
'            </div>'+
'            <div class="KeyHint">'+
'             <div class="KeyHint-keyContainer">'+
'              <div class="KeyHint-key">'+
'               <kbd class="KeyHint-kbd">S</kbd>'+
'               <div class="KeyHint-separator KeyHint-separator--space"> '+
'               </div>'+
'              </div>'+
'              <div class="KeyHint-key">'+
'               <kbd class="KeyHint-kbd">C</kbd>'+
'              </div>'+
'             </div>'+
'             <div>'+
'              ：收藏'+
'             </div>'+
'            </div>'+
'            <div class="KeyHint">'+
'             <div class="KeyHint-keyContainer">'+
'              <div class="KeyHint-key">'+
'               <kbd class="KeyHint-kbd">F</kbd>'+
'               <div class="KeyHint-separator KeyHint-separator--space"> '+
'               </div>'+
'              </div>'+
'              <div class="KeyHint-key">'+
'               <kbd class="KeyHint-kbd">X</kbd>'+
'              </div>'+
'             </div>'+
'             <div>'+
'              ：分享'+
'             </div>'+
'            </div>'+
'           </div>'+
'           <div class="ShortcutHintModal-hintList">'+
'            <div class="ShortcutHintModal-hintTitle">'+
'             导航'+
'            </div>'+
'            <div class="KeyHint">'+
'             <div class="KeyHint-keyContainer">'+
'              <div class="KeyHint-key">'+
'               <kbd class="KeyHint-kbd">J</kbd>'+
'              </div>'+
'             </div>'+
'             <div>'+
'              ：下一项'+
'             </div>'+
'            </div>'+
'            <div class="KeyHint">'+
'             <div class="KeyHint-keyContainer">'+
'              <div class="KeyHint-key">'+
'               <kbd class="KeyHint-kbd">K</kbd>'+
'              </div>'+
'             </div>'+
'             <div>'+
'              ：上一项'+
'             </div>'+
'            </div>'+
'            <div class="KeyHint">'+
'             <div class="KeyHint-keyContainer">'+
'              <div class="KeyHint-key">'+
'               <kbd class="KeyHint-kbd">G</kbd>'+
'               <div class="KeyHint-separator KeyHint-separator--space"> '+
'               </div>'+
'              </div>'+
'              <div class="KeyHint-key">'+
'               <kbd class="KeyHint-kbd">G</kbd>'+
'              </div>'+
'             </div>'+
'             <div>'+
'              ：第一项'+
'             </div>'+
'            </div>'+
'            <div class="KeyHint">'+
'             <div class="KeyHint-keyContainer">'+
'              <div class="KeyHint-key">'+
'               <kbd class="KeyHint-kbd">Shift</kbd>'+
'               <div class="KeyHint-separator">'+
'                +'+
'               </div>'+
'              </div>'+
'              <div class="KeyHint-key">'+
'               <kbd class="KeyHint-kbd">G</kbd>'+
'              </div>'+
'             </div>'+
'             <div>'+
'              ：最后一项'+
'             </div>'+
'            </div>'+
'            <div class="KeyHint">'+
'             <div class="KeyHint-keyContainer">'+
'              <div class="KeyHint-key">'+
'               <kbd class="KeyHint-kbd">Shift</kbd>'+
'               <div class="KeyHint-separator">'+
'                +'+
'               </div>'+
'              </div>'+
'              <div class="KeyHint-key">'+
'               <kbd class="KeyHint-kbd">U</kbd>'+
'              </div>'+
'             </div>'+
'             <div>'+
'              ：向上滚动半屏'+
'             </div>'+
'            </div>'+
'            <div class="KeyHint">'+
'             <div class="KeyHint-keyContainer">'+
'              <div class="KeyHint-key">'+
'               <kbd class="KeyHint-kbd">Shift</kbd>'+
'               <div class="KeyHint-separator">'+
'                +'+
'               </div>'+
'              </div>'+
'              <div class="KeyHint-key">'+
'               <kbd class="KeyHint-kbd">D</kbd>'+
'              </div>'+
'             </div>'+
'             <div>'+
'              ：向下滚动半屏'+
'             </div>'+
'            </div>'+
'            <div class="KeyHint">'+
'             <div class="KeyHint-keyContainer">'+
'              <div class="KeyHint-key">'+
'               <kbd class="KeyHint-kbd">/</kbd>'+
'              </div>'+
'             </div>'+
'             <div>'+
'              ：搜索'+
'             </div>'+
'            </div>'+
'            <div class="KeyHint">'+
'             <div class="KeyHint-keyContainer">'+
'              <div class="KeyHint-key">'+
'               <kbd class="KeyHint-kbd">?</kbd>'+
'              </div>'+
'             </div>'+
'             <div>'+
'              ：快捷键帮助'+
'             </div>'+
'            </div>'+
'           </div>'+
'          </div>'+
'         </div>'+
'        </div>'+
'       </div>'+
'       <button aria-label="关闭" type="button" class="Button Modal-closeButton Button--plain">'+
'        <svg class="Zi Zi--Close Modal-closeIcon" fill="currentColor" viewbox="0 0 24 24" width="24" height="24">'+
'         <path d="M13.486 12l5.208-5.207a1.048 1.048 0 0 0-.006-1.483 1.046 1.046 0 0 0-1.482-.005L12 10.514 6.793 5.305a1.048 1.048 0 0 0-1.483.005 1.046 1.046 0 0 0-.005 1.483L10.514 12l-5.208 5.207a1.048 1.048 0 0 0 .006 1.483 1.046 1.046 0 0 0 1.482.005L12 13.486l5.207 5.208a1.048 1.048 0 0 0 1.483-.006 1.046 1.046 0 0 0 .005-1.482L13.486 12z" fill-rule="evenodd"></path>'+
'        </svg></button>'+
'      </div>'+
'     </div>'+
'    </div>'+
'   </div>'+
'</div>')

function addReport0($QuestionHeaderActions,$more0)
{
    $more0.hide()
    var r0 ='<button type="button" class="Button Button--plain Button--withIcon Button--withLabel"><span style="display: inline-flex; align-items: center; vertical-align:middle;"><svg class="Title Zi--Report " fill="currentColor" viewBox="0 0 24 24" width="14" height="14"><path d="M19.947 3.129c-.633.136-3.927.639-5.697.385-3.133-.45-4.776-2.54-9.949-.888-.997.413-1.277 1.038-1.277 2.019L3 20.808c0 .3.101.54.304.718a.97.97 0 0 0 .73.304c.275 0 .519-.102.73-.304.202-.179.304-.418.304-.718v-6.58c4.533-1.235 8.047.668 8.562.864 2.343.893 5.542.008 6.774-.657.397-.178.596-.474.596-.887V3.964c0-.599-.42-.972-1.053-.835z" fill-rule="evenodd"></path></svg></span> 举报</button>'
    var $report0 = $(r0)
    $report0.bind("click",function(){
        $more0.find("button").click();
        $(".Menu.QuestionHeader-menu").children().eq(2).click();
    })
    $more0.after($report0)
}

function addAnonymous($QuestionHeaderActions,$more)
{
    var a ='<button type="button" class="Button Button--plain Button--withIcon Button--withLabel">'+
        '<span style="display: inline-flex; align-items: center; vertical-align:middle;">'+
        '<svg class="Zi Zi--Anonymous Button-zi" fill="currentColor" viewBox="0 0 1024 1024" width="1.2em" height="1.2em">'+
        '<path d="M831.994 442.66v436.364c0 24.906 7.312 45.124 42.654 45.124 35.344 0 42.656-20.218 42.656-45.124V442.66h-85.31z"></path>'+
        '<path d="M895.992 582.814c0 11.78 9.532 21.342 21.312 21.342v-42.654a21.3 21.3 0 0 0-21.312 21.312zM895.992 668.156c0 11.78 9.532 21.342 21.312 21.342v-42.686c-11.78 0-21.312 9.564-21.312 21.344zM895.992 753.496a21.3 21.3 0 0 0 21.312 21.312v-42.656c-11.78 0-21.312 9.562-21.312 21.344zM895.992 838.806c0 11.812 9.532 21.344 21.312 21.344v-42.654c-11.78 0-21.312 9.562-21.312 21.31zM853.306 582.814c0 11.78-9.532 21.342-21.312 21.342v-42.654a21.3 21.3 0 0 1 21.312 21.312zM853.306 668.156c0 11.78-9.532 21.342-21.312 21.342v-42.686c11.782 0 21.312 9.564 21.312 21.344zM853.306 753.496a21.3 21.3 0 0 1-21.312 21.312v-42.656c11.782 0 21.312 9.562 21.312 21.344zM853.306 838.806c0 11.812-9.532 21.344-21.312 21.344v-42.654c11.782 0 21.312 9.562 21.312 21.31z"></path><path d="M831.994 590.688c26.25-14.124 56.592-34.404 85.31-62.402V442.66h-85.31v148.028z"></path>'+
        '<path d="M1021.52 168.916c-15.532-160.26-413.238 8.594-509.516 8.594S17.986 8.656 2.486 168.916c-29.436 303.68 212.838 396.178 254.65 405.772 147.84 33.904 201.15-48.044 254.868-48.044 53.686 0 107.028 81.95 254.836 48.044 41.812-9.592 284.086-102.092 254.68-405.772zM392.85 399.318c-23.624 8.328-52.154 12.906-80.342 12.906-24.78 0-47.904-3.594-66.904-10.39-18.75-6.718-32.812-16.204-41.842-28.202-14.75-19.67-16.906-48.578-6.436-85.95 2.5-1.156 9.342-3.532 23.592-3.532 36.062 0 88.216 15.03 132.84 38.28 44.75 23.312 66.342 46.624 71.81 59.25-3.97 3.904-13.844 10.982-32.718 17.638z m427.364-25.688c-9 12-23.094 21.484-41.844 28.202-18.968 6.796-42.124 10.39-66.874 10.39-28.218 0-56.748-4.578-80.342-12.906-18.906-6.656-28.75-13.734-32.75-17.64 5.468-12.624 27.062-35.936 71.812-59.25 44.622-23.25 96.778-38.28 132.872-38.28 14.25 0 21.06 2.376 23.56 3.532 10.502 37.376 8.314 66.282-6.434 85.952z" ></path>'+
        '<path d="M867.71 276.15a42.61 42.61 0 0 0-22.998-27.124c-10.718-5-24.716-7.546-41.624-7.546-43.094 0-101.56 16.516-152.59 43.11-46.406 24.186-79.688 53.404-91.248 80.154a42.642 42.642 0 0 0 9.342 47.466c7.532 7.344 22.032 18.062 48.376 27.342 28.032 9.89 61.592 15.344 94.53 15.344 29.592 0 57.716-4.468 81.28-12.89 26.75-9.578 47.436-23.968 61.56-42.764 12.31-16.406 19.404-36.186 21.124-58.764 1.436-19.284-1.158-40.938-7.752-64.328z m-47.496 97.48c-9 12-23.094 21.484-41.844 28.202-18.968 6.796-42.124 10.39-66.874 10.39-28.218 0-56.748-4.578-80.342-12.906-18.906-6.656-28.75-13.734-32.75-17.64 5.468-12.624 27.062-35.936 71.812-59.25 44.622-23.25 96.778-38.28 132.872-38.28 14.25 0 21.06 2.376 23.56 3.532 10.502 37.376 8.314 66.282-6.434 85.952zM464.722 364.742c-11.562-26.75-44.81-55.968-91.248-80.154-51.03-26.594-109.498-43.11-152.558-43.11-16.906 0-30.906 2.532-41.624 7.532a42.69 42.69 0 0 0-23.03 27.14c-6.562 23.39-9.156 45.044-7.718 64.326 1.688 22.578 8.782 42.358 21.092 58.764 14.124 18.796 34.842 33.188 61.592 42.764 23.562 8.422 51.654 12.89 81.278 12.89 32.906 0 66.468-5.454 94.53-15.344 26.312-9.28 40.812-20 48.342-27.342a42.638 42.638 0 0 0 9.344-47.466z m-71.872 34.576c-23.624 8.328-52.154 12.906-80.342 12.906-24.78 0-47.904-3.594-66.904-10.39-18.75-6.718-32.812-16.204-41.842-28.202-14.75-19.67-16.906-48.578-6.436-85.95 2.5-1.156 9.342-3.532 23.592-3.532 36.062 0 88.216 15.03 132.84 38.28 44.75 23.312 66.342 46.624 71.81 59.25-3.97 3.904-13.844 10.982-32.718 17.638z"></path>'+
        '</svg></span> 匿名</button>'
    var $anonymous = $(a)
    $anonymous.bind("click",function(){
        $more.find("button").click();
        $(".Menu.QuestionHeader-menu").children().eq(0).click();
    })
    $QuestionHeaderActions.append($anonymous)
}

function addLog($QuestionHeaderActions)
{
    var url = window.location.href;
    var end,href;
    if(url.indexOf("?")>-1)
    {
        end=url.indexOf("?")
        url = url.substring(0,end);
    }

    if(url.indexOf("answer")>-1)
    {
        end=url.indexOf("answer")
        href = url.substring(0,end);
    }
    else
    {
        href=url+"/"
    }
    var L='<button type="button" class="Button Button--plain Button--withIcon Button--withLabel"><a href="'+href+'log" target="_self"><span style="display: inline-flex; align-items: center; vertical-align:middle;"><svg class="Zi Zi--Log Button-zi" fill="currentColor" viewBox="0 0 1024 1024" width="1.2em" height="1.2em"><path d="M733.129568 1.700997H1.700997v1020.598006h1020.598006v-765.448505z m204.119601 935.548172h-850.498338v-850.498338h614.910299l235.588039 206.671096z"></path><path d="M170.099668 171.800664h279.813953v85.049834H170.099668zM170.099668 372.518272h683.800664v85.049834H170.099668zM170.099668 567.282392h683.800664v85.049834H170.099668zM170.099668 762.046512h683.800664v85.049834H170.099668z"></path></svg></span>问题日志</a></button>'
    var $log = $(L);
    $QuestionHeaderActions.append($log)
}

function addShortCut($QuestionHeaderActions)
{
    var s ='<button type="button" class="Button Button--plain Button--withIcon Button--withLabel"><span style="display: inline-flex; align-items: center; vertical-align:middle;"><svg class="Zi Zi--ShortCut Button-zi" fill="currentColor" viewBox="0 0 1024 1024" width="1.5em" height="1.2em"><path d="M1088 128H64C28.8 128 0 156.8 0 192v640c0 35.2 28.8 64 64 64h1024c35.2 0 64-28.8 64-64V192c0-35.2-28.8-64-64-64zM640 256h128v128h-128V256z m192 192v128h-128v-128h128zM448 256h128v128h-128V256z m192 192v128h-128v-128h128zM256 256h128v128H256V256z m192 192v128h-128v-128h128zM128 256h64v128H128V256z m0 192h128v128H128v-128z m64 320H128v-128h64v128z m576 0H256v-128h512v128z m256 0h-192v-128h192v128z m0-192h-128v-128h128v128z m0-192h-192V256h192v128z"></path></svg></span>  快捷键</button>'
    var $shortcut = $(s)
    $shortcut.css({"margin-left":"10px"})
    $shortcut.click(function(){
            $(".Modal-wrapper").show()
        });
    $QuestionHeaderActions.append($shortcut)

}

function addReport1($more1)
{
    $more1.hide()
    var r1 = '<button type="button" class="Button ContentItem-action Button--plain Button--withIcon Button--withLabel"><span style="display: inline-flex; align-items: center;"><svg class="Zi Zi--Report" fill="currentColor" viewBox="0 0 24 24" width="14" height="14"><path d="M19.947 3.129c-.633.136-3.927.639-5.697.385-3.133-.45-4.776-2.54-9.949-.888-.997.413-1.277 1.038-1.277 2.019L3 20.808c0 .3.101.54.304.718a.97.97 0 0 0 .73.304c.275 0 .519-.102.73-.304.202-.179.304-.418.304-.718v-6.58c4.533-1.235 8.047.668 8.562.864 2.343.893 5.542.008 6.774-.657.397-.178.596-.474.596-.887V3.964c0-.599-.42-.972-1.053-.835z" fill-rule="evenodd"></path></svg></span> 举报</button>'
    var $report1 = $(r1)
    $report1.bind("click",function(){
        $more1.find("button").click();
        $(".Menu.AnswerItem-selfMenu").find("button").each(function(){
            if($(this).text().indexOf("举报")>-1)
                $(this).click();
        })
    })
    $more1.after($report1)
}


function question()
{

    if(hideQuestionSidebar==1)
    {
        if(window.location.href.indexOf("waiting")>-1)
        {
            $(".GlobalSideBar").hide();
            $(".QuestionWaiting-mainColumn").width($(".QuestionWaiting").width());
        }
        else
        {
            $(".Question-sideColumn.Question-sideColumn--sticky").hide();
            if($(".ListShortcut").length>0)
            {
                $(".ListShortcut").width($(".Question-main").width());
                $(".Question-mainColumn").width($(".ListShortcut").width());
                $(".ContentItem-actions").width($(".Question-mainColumn").width()-40);

            }
            else
            {
                $(".Question-mainColumn").width($(".Question-main").width());
                $(".ContentItem-actions").width($(".Question-mainColumn").width()-40);
            }
        }
    }


    if($(".Modal-wrapper").length==0)
    {
        $(document.body).append($hint)
        $(".Modal-wrapper").hide()
        $(".Modal-closeButton").click(function(){
            $(".Modal-wrapper").hide()
        })
    }

    var $QuestionHeaderActions = $("div.QuestionHeaderActions")

    var $titlemore = $QuestionHeaderActions.find(".Zi--Dots").parent().parent().parent() //更多
    var $titlereport = $QuestionHeaderActions.find(".Title.Zi--Report") //举报
    var $anonymous = $(".Zi--Anonymous")//匿名
    var $log = $(".Zi--Log") //日志
    var $shortcut = $(".Zi--ShortCut") //快捷键
    
    if($(".AppHeader-profileAvatar").length>0) //已登录
    {
        if($titlereport.length == 0) //未添加举报
        {
            addReport0($QuestionHeaderActions,$titlemore)
        }
        if($anonymous.length == 0) //未添加匿名
        {
            addAnonymous($QuestionHeaderActions,$titlemore)
        }
        if($log.length == 0) //未添加查看问题日志
        {
            addLog($QuestionHeaderActions)
        }
        if($shortcut.length == 0) //未添加快捷键帮助
        {
            addShortCut($QuestionHeaderActions)
        }

        var $ContentItem_actions = $(".ContentItem-actions")
        $ContentItem_actions.each(function(){
            var $Content_child5 = $(this).children().eq(5-1) //喜欢
            var $Content_child6 = $(this).children().eq(6-1) //更多
            var $Content_child7 = $(this).children().eq(7-1) //举报
            if($ContentItem_actions.text().indexOf("设置") == -1)
            {
                if($Content_child7.length==0 || $Content_child7.text().indexOf("举报")==-1 ) //未添加举报
                {
                    addReport1($Content_child6)
                }
            }
        })

    }
    else //未登录
    {
        $(".Zi--Dots").parent().parent().parent().hide();

        $log = $(".Zi--Log") //日志
        $shortcut = $(".Zi--ShortCut") //快捷键

        if($log.length == 0) //未添加查看问题日志
        {
            addLog($QuestionHeaderActions)
        }
        if($shortcut.length == 0) //未添加快捷键帮助
        {
            addShortCut($QuestionHeaderActions)
        }
    }

    $(".QuestionHeaderActions .QuestionHeader-Comment").css({"margin": "0px 0px 0px 0px"})
    $(".QuestionHeaderActions .Popover.ShareMenu").css({"margin": "0px 0px 0px 0px"})
    $(".QuestionHeaderActions .Button.Button--plain.Button--withIcon.Button--withLabel").css({"margin": "0px 0px 0px 9px"})

    $(".CommentCollapseButton").on("click",function(){
        $(this).parent().parent().parent().prev().find(".Zi--Comment").attr("fill","currentColor")
    })

    $(".ContentItem.AnswerItem").each(function(){
        if($(this).find(".ContentItem-time").length>0 && $(this).find(".ContentItem-time").find("span").text() != null)
        {
            if($(this).find(".ContentItem-time").text().indexOf("发布于")==-1)
            {
                var data_tooltip = $(this).find(".ContentItem-time").find("span").attr("data-tooltip");
                var oldtext =$(this).find(".ContentItem-time").find("span").text();
                $(this).find(".ContentItem-time").find("span").text(data_tooltip+"\xa0\xa0，\xa0\xa0"+oldtext);
            }
            if(publishTop==1)
            {
                if(!$(this).find(".ContentItem-time").parent().hasClass("ContentItem-meta"))
                {
                    $(this).find(".ContentItem-time").appendTo($(this).find(".ContentItem-meta"))
                }
            }
        }

    })

    var $QuestionButtonGroup = $(".QuestionHeader-footer-main").find(".QuestionButtonGroup")
    $QuestionButtonGroup.children().eq(0).css({"margin": "0px 0px 0px 8px"})
    $QuestionButtonGroup.children().eq(1).css({"margin": "0px 0px 0px 8px"})

    $(".QuestionHeaderActions").children().eq(0).css({"margin": "0px 8px 0px 0px"})

    $(".GoodQuestionAction-commonBtn").css("margin","0px 0px 0px 0px")
    $(".Pc-card.Card").attr("style","display:none")
    $(".Card.ViewAll").attr("style","background-color:#0084FF")
    $(".QuestionMainAction").attr("style","color:white;background-color:#0084FF")

}

function directLink()
{
    var equal,colon,external_href,protocol,path,new_href;
    $("a[class*='external']").each(function(){
        if($(this).find("span").length>0)
        {
            new_href = $(this).text()
            $(this).attr("href",new_href)
        }
        else if($(this).attr("href").indexOf("link.zhihu.com/?target=") > -1)
        {
            external_href=$(this).attr("href")
            new_href = external_href.substring(external_href=$(this).attr("href").indexOf("link.zhihu.com/?target=")+"link.zhihu.com/?target=".length)
            $(this).attr("href",decodeURIComponent(new_href))
        }
        else
        {
            external_href=$(this).attr("href")
            if(external_href.lastIndexOf("https%3A"))
                new_href=$(this).attr("href").substring($(this).attr("href").lastIndexOf("https%3A"))
            else if(external_href.lastIndexOf("http%3A%2F%2F"))
                new_href=$(this).attr("href").substring($(this).attr("href").lastIndexOf("http%3A"))
            $(this).attr("href",decodeURIComponent(new_href))
        }
    })


    $("a[class*='LinkCard']:not([class*='MCNLinkCard'])").each(function(){
        if($(this).find("LinkCard-title").length>0 && $(this).find("LinkCard-title").indexOf("http")>-1 )
        {
            new_href = $(this).find("LinkCard-title").text()
            $(this).attr("href",new_href)
        }
        else if($(this).attr("href").indexOf("link.zhihu.com/?target=") > -1)
        {
            external_href=$(this).attr("href")
            new_href = external_href.substring(external_href=$(this).attr("href").indexOf("link.zhihu.com/?target=")+"link.zhihu.com/?target=".length)
            $(this).attr("href",decodeURIComponent(new_href))
        }
        else
        {
            external_href=$(this).attr("href")
            if(external_href.lastIndexOf("https%3A"))
                new_href=$(this).attr("href").substring($(this).attr("href").lastIndexOf("https%3A"))
            else if(external_href.lastIndexOf("http%3A%2F%2F"))
                new_href=$(this).attr("href").substring($(this).attr("href").lastIndexOf("http%3A"))
            $(this).attr("href",decodeURIComponent(new_href))
        }
    })

    $("a.VideoCard-link").each(function(){
        if($(this).attr("href").indexOf("link.zhihu.com/?target=") > -1)
        {
            external_href=$(this).attr("href")
            equal = external_href.lastIndexOf("http")
            colon = external_href.lastIndexOf("%3A")
            protocol = external_href.substring(equal,colon)
            path = external_href.substring(colon+5,external_href.length)
            new_href = protocol+"://"+path
            $(this).attr("href",decodeURIComponent(new_href))
        }
    })

    $(".TopstoryItem--advertCard").hide()

}

function addReport2($more2)
{
    $more2.hide()
    var r2 = '<button type="button" class="Button ContentItem-action Button--plain"><span style="display: inline-flex; align-items: center;"><svg class="Zi Zi--Report" fill="currentColor" viewBox="0 0 24 24" width="14" height="14"><path d="M19.947 3.129c-.633.136-3.927.639-5.697.385-3.133-.45-4.776-2.54-9.949-.888-.997.413-1.277 1.038-1.277 2.019L3 20.808c0 .3.101.54.304.718a.97.97 0 0 0 .73.304c.275 0 .519-.102.73-.304.202-.179.304-.418.304-.718v-6.58c4.533-1.235 8.047.668 8.562.864 2.343.893 5.542.008 6.774-.657.397-.178.596-.474.596-.887V3.964c0-.599-.42-.972-1.053-.835z" fill-rule="evenodd"></path></svg></span> 举报</button>'
    var $report2 = $(r2)
    $report2.bind("click",function(){
        $more2.find("button").click();
        $(".Menu.Post-ActionMenu").find("button").click();
    })
    $more2.after($report2)
}

function zhuanlan()
{
    $(".Recommendations-Main").hide()

    if($(".Zi--Report").length == 0) //未添加举报
    {
        addReport2($(".Post-ActionMenuButton"))
    }

    if($(".ContentItem-time").text().indexOf("发布于")==-1)
    {
        var data_tooltip = $(".ContentItem-time").find("span").attr("data-tooltip");
        var oldtext =$(".ContentItem-time").find("span").text();
        $(".ContentItem-time").find("span").text(data_tooltip+"\xa0\xa0，\xa0\xa0"+oldtext);
    }
    if(publishTop==1 && $(".Post-Header").children().eq(3).length==0)
    {
        $(".ContentItem-time").css({"padding":"0px 0px 0px 0px","margin-top": "14px"})
        $(".ContentItem-time").appendTo($(".Post-Header"))
    }

}

function zvideo()
{
    $(".ZVideo-sideColumn").hide()
}

function addReport3($more3)
{
    $more3.hide()
    var r3 ='<button class="ClubJoinOrCheckinButton" style="margin-right:20px"><img src="https://gitee.com/AN_drew/picBed/raw/master/img/exit.svg"/><span style="color:red">&nbsp;退出圈子</span></button>';
    var $report3 = $(r3)
    $report3.bind("click",function(){
        $more3.find("button").click();
        $(".ClubHeaderInfoMoreButton-item").click();
    })
    $more3.after($report3)
}


function addReport4($more4)
{
    $more4.hide()
    var r4 = '<button type="button" class="Button PostWebActionButtons-comment Button--plain Button--withIcon Button--withLabel"><span style="display: inline-flex; align-items: center;"><svg class="Zi Zi--Report" fill="currentColor" viewBox="0 0 24 24" width="14" height="14"><path d="M19.947 3.129c-.633.136-3.927.639-5.697.385-3.133-.45-4.776-2.54-9.949-.888-.997.413-1.277 1.038-1.277 2.019L3 20.808c0 .3.101.54.304.718a.97.97 0 0 0 .73.304c.275 0 .519-.102.73-.304.202-.179.304-.418.304-.718v-6.58c4.533-1.235 8.047.668 8.562.864 2.343.893 5.542.008 6.774-.657.397-.178.596-.474.596-.887V3.964c0-.599-.42-.972-1.053-.835z" fill-rule="evenodd"></path></svg></span> 举报</button>'
    var $report4 = $(r4)
    $report4.bind("click",function(){
        $more4.find("button").click();
        $(".PostWebActionButtons-item").click();
    })
    $more4.after($report4)
}

function club()
{
    if(hideClubSideBar==1)
    {
        $(".ClubSideBar").hide();
        $(".Club-mainColumn").width($(".Club-container").width());
        $(".ClubEdit").width($(".Club-mainColumn").width()-40);
    }

    var $ClubHeaderInfo_buttonGroup = $(".ClubHeaderInfo-buttonGroup")
    var $child1 = $ClubHeaderInfo_buttonGroup.children().eq(1-1)
    var $child2 = $ClubHeaderInfo_buttonGroup.children().eq(2-1)
    if($child2.length > 0 && $child2.text().indexOf("签到") > -1 && $child2.text().indexOf("加入") == -1) //退出圈子
    {
        addReport3($child1)
    }

    $(".PostReaction").each(function(){
        var post_child5 = $(this).children().eq(5-1)
        var post_child6 = $(this).children().eq(6-1)
        if(post_child6.length==0 || post_child6.text().indexOf("举报")==-1 ) //未添加举报
        {
            addReport4(post_child5)
        }
    })
    $(".PostItem-time").each(function(){

        if($(this).text().indexOf("发布时间")==-1 && $(this).parent().text().indexOf("最后回复")>-1)
        {
            let datetime = $(this).attr("datetime");
            let posttime = datetime.replace("T","  ").replace(".000Z","");
            let replytime = $(this).text();

            $(this).parent().get(0).childNodes[1].nodeValue="";
            $(this).parent().get(0).childNodes[2].nodeValue="";
            $(this).text("发布时间 "+posttime+"\xa0\xa0，\xa0\xa0"+"最后回复 "+replytime);

        }
    })
}

function addReport5($more5)
{
    $more5.hide()
    var r5 = '<button type="button" class="Button ContentItem-action Button--plain"><span style="display: inline-flex; align-items: center;"><svg class="Zi Zi--Report" fill="currentColor" viewBox="0 0 24 24" width="14" height="14"><path d="M19.947 3.129c-.633.136-3.927.639-5.697.385-3.133-.45-4.776-2.54-9.949-.888-.997.413-1.277 1.038-1.277 2.019L3 20.808c0 .3.101.54.304.718a.97.97 0 0 0 .73.304c.275 0 .519-.102.73-.304.202-.179.304-.418.304-.718v-6.58c4.533-1.235 8.047.668 8.562.864 2.343.893 5.542.008 6.774-.657.397-.178.596-.474.596-.887V3.964c0-.599-.42-.972-1.053-.835z" fill-rule="evenodd"></path></svg></span> 举报</button>'
    var $report5 = $(r5)
    $report5.bind("click",function(){
        $more5.find("button").click();
        $(".AnswerItem-selfMenu").children().eq(1).click();
    })
    $more5.after($report5)
}

function getQueryVariable(variable)
{
       var query = window.location.search.substring(1);
       var vars = query.split("&");
       for (var i=0;i<vars.length;i++) {
               var pair = vars[i].split("=");
               if(pair[0] == variable){return pair[1];}
       }
       return(false);
}

function search()
{
    if(hideSearchSideBar==1)
    {
        $(".SearchSideBar").hide();
        $(".SearchMain").width($(".Search-container").width());
    }

    $(".ContentItem-actions").each(function(){
        var $child6 = $(this).children().eq(6-1)
        var $child7 = $(this).children().eq(7-1)
        if($child7.text().indexOf("收起") > -1)
        {
            addReport5($child6)
        }
    })
    $(".ContentItem.AnswerItem").each(function(){
        if($(this).find(".ContentItem-time").length>0 && $(this).find(".ContentItem-time").find("span").text() != null)
        {
            if($(this).find(".ContentItem-time").text().indexOf("发布于")==-1)
            {
                var data_tooltip = $(this).find(".ContentItem-time").find("span").attr("data-tooltip");
                var oldtext =$(this).find(".ContentItem-time").find("span").text();
                $(this).find(".ContentItem-time").find("span").text(data_tooltip+"\xa0\xa0，\xa0\xa0"+oldtext);
            }
            if(publishTop==1)
            {
                console.log($(this).find(".ContentItem-time").parent())
                if(!$(this).find(".ContentItem-time").parent().hasClass("SearchItem-meta"))
                {
                    $(this).find(".ContentItem-time").appendTo($(this).find(".SearchItem-meta"))
                }
            }
        }
    })
    $(".RelevantQuery").closest(".Card.SearchResult-Card").hide();
    if(getQueryVariable("type")=="content")
    {
        $('.Card.SearchResult-Card[data-za-detail-view-path-module="UserItem"]').hide();
    }

}

function lives()
{
    $("[class*='LiveWechatSpread']").hide()
}

function collection()
{
    if(hideCollectionSideBar==1)
    {
        $(".CollectionDetailPageSideBar").hide();
        $(".CollectionsDetailPage-mainColumn").width($(".CollectionsDetailPage").width());

        $(".GlobalSideBar").hide();
        $(".Collections-mainColumn").width($(".Collections-container").width());
    }

    $(".ContentItem-actions").each(function(){
        var $child6 = $(this).children().eq(6-1)
        var $child7 = $(this).children().eq(7-1)
        if($child7.length==0 || $child7.text().indexOf("收起") > -1)
        {
            addReport5($child6)
        }
    })
}

function iconColor()
{
    $(".Zi--List").parent().parent().hover(function(){
        $(this).find(".Zi--List").attr("fill","#0084FF")
        $(this).attr("style","color:#0084FF");
    },function(){
        $(this).find(".Zi--List").attr("fill","currentColor")
        $(this).attr("style","color:#8590A6");
    })
  
    $(".Zi--Comment").parent().parent().hover(function(){
        $(this).find(".Zi--Comment").attr("fill","#0084FF")

        if($(this).closest(".QuestionHeaderActions").length>0)
            $(this).attr("style","color:#0084FF;margin: 0px 0px 0px 9px;");
        else
            $(this).attr("style","color:#0084FF");

    },function(){
        if($(this).closest(".QuestionHeaderActions").length>0)
        {
            $(this).find(".Zi--Comment").attr("fill","currentColor")
            $(this).attr("style","color:#8590A6;margin: 0px 0px 0px 9px;");
        }
        else
        {
            if($(this).prop('lastChild').nodeValue.indexOf("收起评论")==-1)
            {
                $(this).find(".Zi--Comment").attr("fill","currentColor")
                $(this).attr("style","color:#8590A6");
            }
        }
    })

    $(".Zi--Comment").parent().parent().each(function(){
        if($(this).prop('lastChild').nodeValue!=null && $(this).prop('lastChild').nodeValue.indexOf("收起评论") > -1)
        {
            $(this).find(".Zi--Comment").attr("fill","#0084FF")
            $(this).attr("style","color:#0084FF");
        }
    })

     $(".Zi--Close").on("click",function(){
         $(".Zi--Comment").parent().parent().each(function(){
             if($(this).prop('lastChild').nodeValue!=null && $(this).prop('lastChild').nodeValue.indexOf("收起评论") > -1)
             {
                 $(this).find(".Zi--Comment").attr("fill","currentColor")
                 $(this).attr("style","color:#8590A6");
             }
         })
    })

    $(".Zi--Comments").parent().parent().hover(function(){
        $(this).find(".Zi--Comments").attr("fill","#00FF7F")
        $(this).attr("style","color:#00FF7F");
    },function(){
        if($(".Messages-content").length==0)
        {
            $(this).find(".Zi--Comments").attr("fill","currentColor")
            $(this).attr("style","color:#8590A6");
        }
    })

    $(".Zi--Reply").parent().parent().hover(function(){
        $(this).find(".Zi--Reply").attr("fill","#32CD32")
        $(this).attr("style","color:#32CD32");
    },function(){
        if($(this).prop('lastChild').nodeValue!=null && $(this).prop('lastChild').nodeValue.indexOf("取消回复")==-1)
        {
            $(this).find(".Zi--Reply").attr("fill","currentColor")
            $(this).attr("style","color:#8590A6");
        }
    })

    $(".Zi--Reply").parent().parent().each(function(){
        if($(this).prop('lastChild').nodeValue!=null && $(this).prop('lastChild').nodeValue.indexOf("取消回复") > -1)
        {
            $(this).find(".Zi--Reply").attr("fill","#32CD32")
            $(this).attr("style","color:#32CD32");
        }
    })
    
    $(".Zi--Like").parent().parent().hover(function(){
        if($(this).prop('lastChild').nodeValue!=null && $(this).prop('lastChild').nodeValue.indexOf("踩") > -1 || $(this).attr("data-tooltip")=="不推荐")
        {
            $(this).find(".Zi--Like").attr("fill","black")
            $(this).attr("style","color:black");
        }
        else if(window.location.href.indexOf("search") > -1)
        {
            if($(this).hasClass("SearchTopicReview-Icon--like") || $(this).hasClass("SearchTopicReview-Icon--liked"))
            {
                $(this).find(".Zi--Like").find("path").attr("fill","#FF4D82")
                $(this).attr("style","color:#FF4D82;");
            }
            else
            {
                $(this).find(".Zi--Like").find("path").attr("fill","black")
                $(this).attr("style","color:black;");
            }
        }
        else
        {
            $(this).find(".Zi--Like").attr("fill","#FF4D82")
            $(this).attr("style","color:#FF4D82;margin:0px;");
        }
    },function(){
        if($(this).find("#topic-recommend").length>0 ||$(this).find("#topic-against").length>0 || $(this).prop('lastChild').nodeValue!=null && $(this).prop('lastChild').nodeValue.indexOf("取消踩") == -1)
          $(this).find(".Zi--Like").attr("fill","currentColor")

        if($(this).prop('lastChild').nodeValue!=null && $(this).prop('lastChild').nodeValue.indexOf("取消踩")>-1)
        {
            $(this).attr("style","color:black;");
        }
        else if($(this).prop('lastChild').nodeValue!=null && $(this).prop('lastChild').nodeValue.indexOf("踩") > -1 || $(this).attr("data-tooltip")=="不推荐")
        {
            $(this).attr("style","color:#8590A6;");
        }
        else if(window.location.href.indexOf("search") > -1)
        {
            $(this).find(".Zi--Like").find("path").attr("fill","#8590A6")
            $(this).attr("style","color:#8590A6;");
        }
        else
            $(this).attr("style","color:#8590A6; margin:0px;");
    })
    
    $(".Zi--Like").parent().parent().each(function(){
        if($(this).prop('lastChild').nodeValue!=null && $(this).prop('lastChild').nodeValue=="取消踩")
            $(this).find(".Zi--Like").attr("fill","black")

        if(window.location.href.indexOf("search") > -1)
        {
            if($(this).hasClass("SearchTopicReview-Icon--liked"))
            {
                $(this).find(".Zi--Like").find("path").attr("fill","#FF4D82")
                $(this).attr("style","color:#FF4D82;");
            }
        }
    })

    $(".GoodQuestionAction-highLightBtn").attr("style","color:#FF4D82;margin:0px;"); //题目点赞后保持变色
    $(".is-liked").attr("style","color:#FF4D82;margin:0px;"); //评论点赞后保持变色


    $(".Zi--Share").parent().parent().parent().hover(function(){
        $(this).find(".Zi--Share").attr("fill","blue")

        if($(this).closest(".QuestionHeaderActions").length>0)
            $(this).find("button").attr("style","color:blue;margin: 0px 0px 0px 9px;");
        else if($(this).find(".Post-SideActions-icon").length>0)
            $(this).attr("style","color:blue;");
        else
            $(this).find("button").attr("style","color:blue;");

    },function(){
        $(this).find(".Zi--Share").attr("fill","currentColor")

        if($(this).closest(".QuestionHeaderActions").length>0)
            $(this).find("button").attr("style","color:#8590A6;margin: 0px 0px 0px 9px;");
        else if($(this).find(".Post-SideActions-icon").length>0)
            $(this).attr("style","color:#8590A6;");
        else
            $(this).find("button").attr("style","color:#8590A6;");
    })


    $(".Zi--Star").parent().parent().hover(function(){
        $(this).find(".Zi--Star").attr("fill","orange")
        $(this).attr("style","color:orange");
    },function(){
        $(this).find(".Zi--Star").attr("fill","currentColor")
        $(this).attr("style","color:#8590A6");
    })

    $(".Zi--Heart").parent().parent().hover(function(){
        $(this).find(".Zi--Heart").attr("fill","red")
        $(this).attr("style","color:red");
    },function(){
        if($(this).prop('lastChild').nodeValue=="喜欢")
            $(this).find(".Zi--Heart").attr("fill","currentColor")

        $(this).attr("style","color:#8590A6");
    })

    $(".Zi--Heart").parent().parent().each(function(){
        if($(this).prop('lastChild').nodeValue!=null && $(this).prop('lastChild').nodeValue=="取消喜欢")
            $(this).prop('lastChild').nodeValue="已喜欢"
        if($(this).prop('lastChild').nodeValue!=null && $(this).prop('lastChild').nodeValue=="已喜欢")
        {
            $(this).find(".Zi--Heart").attr("fill","red")
            $(this).attr("style","color:red");
        }
    })
  
    $(".Zi--Report").parent().parent().hover(function(){
        $(this).find(".Zi--Report").attr("fill","brown")

        if($(this).closest(".QuestionHeaderActions").length>0)
            $(this).attr("style","color:brown;margin: 0px 0px 0px 9px;");
        else
            $(this).attr("style","color:brown");

    },function(){
        $(this).find(".Zi--Report").attr("fill","currentColor")

        if($(this).closest(".QuestionHeaderActions").length>0)
            $(this).attr("style","color:#8590A6;margin: 0px 0px 0px 9px;");
        else
            $(this).attr("style","color:#8590A6");
    })
    
  
    $(".Zi--Bell").parent().parent().hover(function(){
        $(this).find(".Zi--Bell").attr("fill","#FACB62")
    },function(){
        if($(".PushNotifications-content").length==0)
          $(this).find(".Zi--Bell").attr("fill","currentColor")
    })
    
    $(".Zi--Bell").parent().parent().on("click",function(){
        if($(".PushNotifications-content").length==0)
        {
            $(this).find(".Zi--Bell").attr("fill","#FACB62")
        }
        else
        {
            $(this).find(".Zi--Bell").attr("fill","currentColor")
        }
    })
  
    $(".Zi--Heart.PushNotifications-tabIcon").parent().parent().hover(function(){
        $(this).find(".Zi--Heart").attr("fill","#0084FF")
    },function(){
        $(this).find(".Zi--Heart").attr("fill","currentColor")
    })
  
    $(".Zi--Users").parent().parent().hover(function(){
        $(this).find(".Zi--Users").attr("fill","#0084FF")
    },function(){
        $(this).find(".Zi--Users").attr("fill","currentColor")
    })
  
    $(".Zi--Anonymous").parent().parent().hover(function(){
        $(this).find(".Zi--Anonymous").attr("fill","black")
        $(this).attr("style","color:black;margin: 0px 0px 0px 9px;");
    },function(){
        $(this).find(".Zi--Anonymous").attr("fill","currentColor")
        $(this).attr("style","color:#8590A6;margin: 0px 0px 0px 9px;");
    })
  
    $(".Zi--Log").parent().parent().hover(function(){
        $(this).find(".Zi--Log").attr("fill","purple")
        $(this).parent().attr("style","color:purple;margin: 0px 0px 0px 9px;");
    },function(){
        $(this).find(".Zi--Log").attr("fill","currentColor")
        $(this).parent().attr("style","color:#8590A6;margin: 0px 0px 0px 9px;");
    })
  
    $(".Zi--ShortCut").parent().parent().hover(function(){
        $(this).find(".Zi--ShortCut").attr("fill","#44B8A1")
        $(this).attr("style","color:#44B8A1;margin: 0px 0px 0px 9px;");
    },function(){
        $(this).find(".Zi--ShortCut").attr("fill","currentColor")
        $(this).attr("style","color:#8590A6;margin: 0px 0px 0px 9px;");
    })

    $(".Zi--Invite").parent().parent().hover(function(){
        $(this).find(".Zi--ShortCut").attr("fill","black")
        $(this).attr("style","color:black;margin: 0px 8px 0px 0px;");
    },function(){
        $(this).find(".Zi--ShortCut").attr("fill","currentColor")
        $(this).attr("style","color:#8590A6;margin: 0px 8px 0px 0px;");
    })

    $(".Zi--Trash").parent().parent().hover(function(){
        $(this).find(".Zi--Trash").attr("fill","#C70000");
        $(this).attr("style","color:#C70000");
    },function(){
        $(this).find(".Zi--Trash").attr("fill","currentColor");
        $(this).attr("style","color:#8590A6");
    })

    $(".SelfCollectionItem-actions .Zi--EditSurround").parent().parent().hover(function(){
        $(this).find(".Zi--EditSurround").attr("fill","orange");
        $(this).attr("style","color:orange");
    },function(){
        $(this).find(".Zi--EditSurround").attr("fill","currentColor");
        $(this).attr("style","color:#8590A6");
    })

    $(".Zi--Emotion").parent().parent().hover(function(){
        $(this).find(".Zi--Emotion").find("path").attr("fill","#0084FF")
    },function(){
        $(this).find(".Zi--Emotion").find("path").removeAttr("fill")
    })

    $(".Zi--AddImage").parent().parent().hover(function(){
        $(this).find(".Zi--AddImage").find("path").attr("fill","#0084FF")
    },function(){
        $(this).find(".Zi--AddImage").find("path").removeAttr("fill")
    })

    $(".Zi--InsertImage").find("path").attr("fill","blue")

    $(".Zi--InsertVideo, .Zi--FormatClear").find("path").attr("fill","red")

    $(".Zi--InsertFormula").find("path").attr("fill","rgb(115,216,244)")

    $(".Zi--InsertLink").find("path").attr("fill","#0084FF");

    $(".Zi--Folder").find("path").attr("fill","#FF8C00")

    $(".ColumnPageHeader-Menu .Menu-item").attr("style","color:black")
    $(".ColumnPageHeader-Menu .Menu-item.is-active").attr("style","color:#0084FF")

    $(".AnswerAdd-topicBiosButton").attr("style","color:#0084FF")
    $(".AnswerAdd-topicBiosButton .Zi--Edit").attr("fill","#0084FF")

    $(".Zi--Document").parent().hover(function(){
        $(this).find(".Zi--Document").find("path").attr("fill","#FF8C00")
        $(this).attr("style","color:#FF8C00");
    },function(){
        $(this).find(".Zi--Document").find("path").removeAttr("fill")
        $(this).attr("style","color:#8590A6");
    })

    $(".Zi--Time").parent().hover(function(){
        $(this).find(".Zi--Time").find("path").attr("fill","black")
        $(this).attr("style","color:black");
    },function(){
        $(this).find(".Zi--Time").find("path").removeAttr("fill")
        $(this).attr("style","color:#8590A6");
    })

    $(".Zi--Deliver").parent().parent().hover(function(){
        $(this).find(".Zi--Deliver").find("path").attr("fill","#02E6B8")
        $(this).attr("style","color:#02E6B8");
    },function(){
        $(this).find(".Zi--Deliver").find("path").removeAttr("fill")
        $(this).attr("style","color:#8590A6");
    })

    $(".Zi--FullscreenEnter").parent().hover(function(){
        $(this).find(".Zi--FullscreenEnter").find("path").attr("fill","#0084FF")
        $(this).attr("style","color:#0084FF");
    },function(){
        $(this).find(".Zi--FullscreenEnter").find("path").removeAttr("fill")
        $(this).attr("style","color:#8590A6");
    })

    $(".AnswerForm-exitFullscreenButton").hover(function(){
        $(this).find(".AnswerForm-exitFullscreenButton").find("path").attr("fill","#0084FF")
        $(this).attr("style","color:#0084FF");
    },function(){
        $(this).find(".AnswerForm-exitFullscreenButton").find("path").removeAttr("fill")
        $(this).attr("style","color:#8590A6");
    })

    $(".TopicActions .Zi--Settings").parent().parent().hover(function(){
        $(this).find(".Zi--Settings").attr("fill","purple")
        $(this).attr("style","color:purple");
    },function(){
        $(this).find(".Zi--Settings").attr("fill","currentColor")
        $(this).attr("style","color:#8590A6");
    })

    $(".ContentItem-action .Zi--Settings, .AnswerForm-footerRight .Zi--Settings").parent().parent().hover(function(){
        $(this).find(".Zi--Settings").attr("fill","purple")
        $(this).attr("style","color:purple");
    },function(){
        $(this).find(".Zi--Settings").attr("fill","currentColor")
        $(this).attr("style","color:#8590A6");
    })

    $(".AppHeaderProfileMenu .Zi--Settings").parent().hover(function(){
        $(this).find(".Zi--Settings").attr("fill","purple")
        $(this).attr("style","color:purple");
    },function(){
        $(this).find(".Zi--Settings").attr("fill","currentColor")
        $(this).attr("style","color:#8590A6");
    })

    $(".AppHeaderProfileMenu .Zi--Logout").parent().hover(function(){
        $(this).find(".Zi--Logout").attr("fill","red")
        $(this).attr("style","color:red");
    },function(){
        $(this).find(".Zi--Logout").attr("fill","currentColor")
        $(this).attr("style","color:#8590A6");
    })

    $(".AppHeaderProfileMenu .Zi--Profile").parent().hover(function(){
        $(this).find(".Zi--Profile").attr("fill","black")
        $(this).attr("style","color:black");
    },function(){
        $(this).find(".Zi--Profile").attr("fill","currentColor")
        $(this).attr("style","color:#8590A6");
    })

    $(".AppHeaderProfileMenu .Zi--Creator").parent().hover(function(){
        $(this).find(".Zi--Creator").attr("fill","#0084FF")
        $(this).attr("style","color:#0084FF");
    },function(){
        $(this).find(".Zi--Creator").attr("fill","currentColor")
        $(this).attr("style","color:#8590A6");
    })

    $(".CommentMoreReplyButton .Button").hover(function(){
        $(this).attr("style","color:#00FF7F");
    },function(){
        $(this).attr("style","color:#8590A6");
    })

    $(".CommentCollapseButton").hover(function(){
        $(this).find("Zi--ArrowUp").attr("fill","#0084FF")
        $(this).css({"color":"#0084FF"})

    },function(){
        $(this).find("Zi--ArrowUp").attr("fill","currentColor")
        $(this).css({"color":"#8590A6"})
  
    })

    $(".CommentCollapseButton").on("click",function(){
        let $t =$(this).closest(".Comments-container").prev().find(".Zi--Comment").parent().parent();
        $t.find(".Zi--Comment").attr("fill","currentColor")
        $t.attr("style","color:#8590A6");
    })

    $(".CornerButton").hover(function(){
        $(this).find(".Zi--BackToTop").attr("style","color:#0084FF");
    },function(){
        $(this).find(".Zi--BackToTop").attr("style","color:#8590A6");
    })

    $(".ContentItem-time").each(function(){
        $(this).find("a").attr("style","border-bottom: 1px solid rgba(133,144,166,.72)")
    })

    $(".Button.ContentItem-action.ContentItem-rightButton.Button--plain").attr("style","color:#175199");
    $(".QuestionRichText-more").attr("style","color:#0084FF");
    $(".QuestionHeader-actions .Button").attr("style","color:#0084FF");

    $(".Zi--Switch").attr("fill","#0084FF")
    $(".Zi--Switch").parent().parent().css("color","#0084FF")

    $(".Zi--Select").attr("fill","#0084FF")
    $(".Zi--Select").parent().css("color","#0084FF")

    $(".Zi--Dots").hover(function(){
        $(this).find("path").attr("fill","#0084FF")
    },function(){
        $(this).find("path").attr("fill","#8590A6")
    })

    $(".Zi--FormatBold, .Zi--FormatItalic, .Zi--FormatHeader, .Zi--FormatBlockquote, .Zi--InsertOrderedList, .Zi--InsertUnorderedList, .Zi--InsertReference, .Zi--InsertDivider").find("path").attr("fill","black")

    $(".Zi--FormatCode").find("path").attr("fill","#0084FF");

    $(".AnswerItem-selectMenuItem .Zi--Check, .CommentPermission-item .Zi--Check").attr("fill","black");
    $(".AnswerItem-selectMenuItem .Zi--Check, .CommentPermission-item .Zi--Check").parent().parent().parent().attr("style","color:black");

    $(".AnswerItem-selectMenuItem").hover(function(){
        $(this).attr("style","color:black");
    },function(){
        if($(this).find(".Zi--Check").length==0)
            $(this).attr("style","color:#8590A6");
    })

    $(".CommentPermission-item").hover(function(){
        $(this).attr("style","color:black");
    },function(){
        if($(this).find(".Zi--Check").length==0)
            $(this).attr("style","color:#8590A6");
    })

    $(".AnswerAdd-toggleAnonymous").hover(function(){
        $(this).attr("style","color:#0084FF");
    },function(){
        $(this).attr("style","color:#8590A6");
    })

    $(".DisclaimerEntry").hover(function(){
        $(this).find("path").attr("fill","black")
        $(this).find("button").attr("style","color:black");
    },function(){
        $(this).find("path").attr("fill","currentColor")
        $(this).find("button").attr("style","color:#8590A6");
    })

    if($(".css-70qvj9 .Zi--CheckboxOn").length>0)
        $(".css-70qvj9 .css-1d83bu8").attr("style","color:#0084FF");
    if($(".css-70qvj9 .Zi--CheckboxOff").length>0)
        $(".css-70qvj9 .css-1d83bu8").attr("style","color:#8590A6");

    if($.cookie('nightmode')==undefined)
        $.cookie('nightmode', 0, { expires: 365, path: "/", domain: "zhihu.com" });

    var $nightmode =$('<button id="nightmode" style="margin-left:15px;" onselectstart="return false;">'+
                      '<img style="vertical-align:middle; width:18px; height:18px;" src="'+dark+'">'+
                      '<span style="vertical-align:middle;"> 夜间模式</span></button>')


    $nightmode.click(function(){
        if( $("html").attr("data-theme")=="light")
        {
            $("html").attr("data-theme","dark")
            $(this).find("img").attr("src",light).attr("style","vertical-align:middle; width:20px; height:20px;")
            $(this).find("span").text(" 日间模式")
            $.cookie('nightmode', 1, { expires: 365, path: "/", domain: "zhihu.com" });
        }
        else
        {
            $("html").attr("data-theme","light")
            $(this).find("img").attr("src",dark).attr("style","vertical-align:middle; width:18px; height:18px;")
            $(this).find("span").text(" 夜间模式")
            $.cookie('nightmode', 0, { expires: 365, path: "/", domain: "zhihu.com" });
        }
    })

    if($("#nightmode").length==0)
    {
        $(".SearchBar").after($nightmode)
        var $nightmode_zhuanlan = $nightmode.clone(true);
        $nightmode_zhuanlan.css("margin-right","50px")
        $(".ColumnPageHeader-WriteButton").before($nightmode_zhuanlan)
    }

    if($.cookie('nightmode')==1)
    {
        $("html").attr("data-theme","dark")
        $("#nightmode").find("img").attr("src",light).attr("style","vertical-align:middle; width:20px; height:20px;")
        if( $("#nightmode").find("span").text()!=" 日间模式")
            $("#nightmode").find("span").text(" 日间模式")
    }
    else
    {
        $("html").attr("data-theme","light")
        $("#nightmode").find("img").attr("src",dark).attr("style","vertical-align:middle; width:18px; height:18px;")
        if( $("#nightmode").find("span").text()!=" 夜间模式")
            $("#nightmode").find("span").text(" 夜间模式")
    }

    $(".Tabs-link.AppHeader-TabsLink").hover(function(){
        $(this).attr("style","color:#0084FF");
    },function(){
        if( $("html").attr("data-theme")=="light")
        {
            $(this).attr("style","color:#8590A6");
        }
        else
        {
            $(this).attr("style","color:#606A80");
        }
    })

}

function index()
{

    $(".Card.TopstoryItem").each(function(){
        if($(this).find(".ContentItem-time").length>0 && $(this).find(".ContentItem-time").find("span").text() != null)
        {
            if($(this).find(".ContentItem-time").text().indexOf("发布于")==-1)
            {
                var data_tooltip = $(this).find(".ContentItem-time").find("span").attr("data-tooltip");
                var oldtext =$(this).find(".ContentItem-time").find("span").text();
                $(this).find(".ContentItem-time").find("span").text(data_tooltip+"\xa0\xa0，\xa0\xa0"+oldtext);
            }
            if(publishTop==1)
            {
                $(this).find(".ContentItem-time").appendTo($(this).find(".ContentItem-meta"))
            }
        }
    })
    $(".Card.GlobalSideBar-category>a").hide();

    if(hideIndexSidebar==1)
    {
        $(".GlobalSideBar").hide();
        $(".Topstory-mainColumn").width($(".Topstory-container").width());
    }

    $(".ContentItem-actions").each(function(){
        if($(this).find(".Zi--Report").length==0 ) //未添加举报
        {
            addReport1($(this).find(".Zi--Dots").closest(".ContentItem-action"))
        }
        else
        {
            $(this).find(".Zi--Dots").closest(".ContentItem-action").hide();
        }

    })


}

function people()
{
    $(".ContentItem").each(function(){
        if($(this).find(".ContentItem-time").length>0 && $(this).find(".ContentItem-time").find("span").text() != null)
        {
            if($(this).find(".ContentItem-time").text().indexOf("发布于")==-1)
            {
                var data_tooltip = $(this).find(".ContentItem-time").find("span").attr("data-tooltip");
                var oldtext =$(this).find(".ContentItem-time").find("span").text();
                $(this).find(".ContentItem-time").find("span").text(data_tooltip+"\xa0\xa0，\xa0\xa0"+oldtext);
            }
            if(publishTop==1)
            {
                if(!$(this).find(".ContentItem-time").parent().hasClass("ContentItem-meta"))
                {
                    $(this).find(".ContentItem-time").appendTo($(this).find(".ContentItem-meta"))
                }
            }
        }

    })
}

function originalPic()
{
    $("img").each(function(){
        if($(this).attr("data-original")!=undefined && !$(this).hasClass("comment_sticker"))
        {
            if($(this).attr("src") != $(this).attr("data-original"))
                $(this).attr("src",$(this).attr("data-original"))
        }
    })
    $(".Modal-inner").css({"overflow-y":"hidden"})
}

//知乎视频下载功能来自脚本https://greasyfork.org/zh-CN/scripts/39206-%E4%B8%8B%E8%BD%BD%E7%9F%A5%E4%B9%8E%E8%A7%86%E9%A2%91
function downloadVideo()
{
    (async () => {
        if (window.location.host == 'www.zhihu.com') return;

        const playlistBaseUrl = 'https://lens.zhihu.com/api/videos/';
        //const videoBaseUrl = 'https://video.zhihu.com/video/';
        const videoId = window.location.pathname.split('/').pop(); // 视频id
        const menuStyle = 'transform:none !important; left:auto !important; right:-0.5em !important;';
        const playerId = 'player';
        const coverSelector = '#' + playerId + ' > div:first-child > div:first-child > div:nth-of-type(2)';
        const controlBarSelector = '#' + playerId + ' > div:first-child > div:first-child > div:last-child > div:last-child > div:first-child';
        const svgDownload = '<path d="M9.5,4 H14.5 V10 H17.8 L12,15.8 L6.2,10 H9.5 Z M6.2,18 H17.8 V20 H6.2 Z"></path>';
        let player = document.getElementById(playerId);
        let resolutionMap = {'标清': 'sd', '高清': 'ld', '超清': 'hd'};
        let videos = []; // 存储各分辨率的视频信息
        let downloading = false;

        function getBrowerInfo() {
            let browser = (function (window) {
                let document = window.document;
                let navigator = window.navigator;
                let agent = navigator.userAgent.toLowerCase();
                // IE8+支持.返回浏览器渲染当前文档所用的模式
                // IE6,IE7:undefined.IE8:8(兼容模式返回7).IE9:9(兼容模式返回7||8)
                // IE10:10(兼容模式7||8||9)
                let IEMode = document.documentMode;
                let chrome = window.chrome || false;
                let system = {
                    // user-agent
                    agent: agent,
                    // 是否为IE
                    isIE: /trident/.test(agent),
                    // Gecko内核
                    isGecko: agent.indexOf('gecko') > 0 && agent.indexOf('like gecko') < 0,
                    // webkit内核
                    isWebkit: agent.indexOf('webkit') > 0,
                    // 是否为标准模式
                    isStrict: document.compatMode === 'CSS1Compat',
                    // 是否支持subtitle
                    supportSubTitle: function () {
                        return 'track' in document.createElement('track');
                    },
                    // 是否支持scoped
                    supportScope: function () {
                        return 'scoped' in document.createElement('style');
                    },

                    // 获取IE的版本号
                    ieVersion: function () {
                        let rMsie = /(msie\s|trident.*rv:)([\w.]+)/;
                        let match = rMsie.exec(agent);
                        try {
                            return match[2];
                        } catch (e) {
                            return IEMode;
                        }
                    },
                    // Opera版本号
                    operaVersion: function () {
                        try {
                            if (window.opera) {
                                return agent.match(/opera.([\d.]+)/)[1];
                            }
                            else if (agent.indexOf('opr') > 0) {
                                return agent.match(/opr\/([\d.]+)/)[1];
                            }
                        } catch (e) {
                            return 0;
                        }
                    }
                };

                try {
                    // 浏览器类型(IE、Opera、Chrome、Safari、Firefox)
                    system.type = system.isIE ? 'IE' :
                    window.opera || (agent.indexOf('opr') > 0) ? 'Opera' :
                    (agent.indexOf('chrome') > 0) ? 'Chrome' :
                    //safari也提供了专门的判定方式
                    window.openDatabase ? 'Safari' :
                    (agent.indexOf('firefox') > 0) ? 'Firefox' :
                    'unknow';

                    // 版本号
                    system.version = (system.type === 'IE') ? system.ieVersion() :
                    (system.type === 'Firefox') ? agent.match(/firefox\/([\d.]+)/)[1] :
                    (system.type === 'Chrome') ? agent.match(/chrome\/([\d.]+)/)[1] :
                    (system.type === 'Opera') ? system.operaVersion() :
                    (system.type === 'Safari') ? agent.match(/version\/([\d.]+)/)[1] :
                    '0';

                    // 浏览器外壳
                    system.shell = function () {
                        if (agent.indexOf('edge') > 0) {
                            system.version = agent.match(/edge\/([\d.]+)/)[1] || system.version;
                            return 'Edge';
                        }
                        // 遨游浏览器
                        if (agent.indexOf('maxthon') > 0) {
                            system.version = agent.match(/maxthon\/([\d.]+)/)[1] || system.version;
                            return 'Maxthon';
                        }
                        // QQ浏览器
                        if (agent.indexOf('qqbrowser') > 0) {
                            system.version = agent.match(/qqbrowser\/([\d.]+)/)[1] || system.version;
                            return 'QQBrowser';
                        }
                        // 搜狗浏览器
                        if (agent.indexOf('se 2.x') > 0) {
                            return '搜狗浏览器';
                        }

                        // Chrome:也可以使用window.chrome && window.chrome.webstore判断
                        if (chrome && system.type !== 'Opera') {
                            let external = window.external;
                            let clientInfo = window.clientInformation;
                            // 客户端语言:zh-cn,zh.360下面会返回undefined
                            let clientLanguage = clientInfo.languages;

                            // 猎豹浏览器:或者agent.indexOf("lbbrowser")>0
                            if (external && 'LiebaoGetVersion' in external) {
                                return 'LBBrowser';
                            }
                            // 百度浏览器
                            if (agent.indexOf('bidubrowser') > 0) {
                                system.version = agent.match(/bidubrowser\/([\d.]+)/)[1] ||
                                    agent.match(/chrome\/([\d.]+)/)[1];
                                return 'BaiDuBrowser';
                            }
                            // 360极速浏览器和360安全浏览器
                            if (system.supportSubTitle() && typeof clientLanguage === 'undefined') {
                                let storeKeyLen = Object.keys(chrome.webstore).length;
                                let v8Locale = 'v8Locale' in window;
                                return storeKeyLen > 1 ? '360极速浏览器' : '360安全浏览器';
                            }
                            return 'Chrome';
                        }
                        return system.type;
                    };

                    // 浏览器名称(如果是壳浏览器,则返回壳名称)
                    system.name = system.shell();
                    // 对版本号进行过滤过处理
                    // System.version = System.versionFilter(System.version);

                } catch (e) {
                    // console.log(e.message);
                }

                return system;

            })(window);

            if (browser.name == undefined || browser.name == '') {
                browser.name = 'Unknown';
                browser.version = 'Unknown';
            }
            else if (browser.version == undefined) {
                browser.version = 'Unknown';
            }
            return browser;
        }

        function fetchRetry(url, options = {}, times = 1, delay = 1000, checkStatus = true) {
            return new Promise((resolve, reject) => {
                // fetch 成功处理函数
                function success(res) {
                    if (checkStatus && !res.ok) {
                        failure(res);
                    }
                    else {
                        resolve(res);
                    }
                }

                // 单次失败处理函数
                function failure(error) {
                    times--;

                    if (times) {
                        setTimeout(fetchUrl, delay);
                    }
                    else {
                        reject(error);
                    }
                }

                // 总体失败处理函数
                function finalHandler(error) {
                    throw error;
                }

                function fetchUrl() {
                    return fetch(url, options)
                        .then(success)
                        .catch(failure)
                        .catch(finalHandler);
                }

                fetchUrl();
            });
        }

        // 下载指定url的资源
        async function downloadUrl(url, name = (new Date()).valueOf() + '.mp4') {
            let browser = getBrowerInfo();

            // Greasemonkey 需要把 url 转为 blobUrl
            if (GM_info.scriptHandler == 'Greasemonkey') {
                let res = await fetchRetry(url);
                let blob = await res.blob();
                url = URL.createObjectURL(blob);
            }

            // Chrome 可以使用 Tampermonkey 的 GM_download 函数绕过 CSP(Content Security Policy) 的限制
            if (window.GM_download) {
                GM_download({url, name});
            }
            else {
                // firefox 需要禁用 CSP, about:config -> security.csp.enable => false
                let a = document.createElement('a');
                a.href = url;
                a.download = name;
                // a.target = '_blank';
                document.body.appendChild(a);
                a.click();
                document.body.removeChild(a);

                setTimeout(function () {
                    URL.revokeObjectURL(url);
                }, 100);
            }
        }

        function humanSize(size) {
            let n = Math.log(size) / Math.log(1024) | 0;
            return (size / Math.pow(1024, n)).toFixed(0) + ' ' + (n ? 'KMGTPEZY'[--n] + 'B' : 'Bytes');
        }

        if (!player) return;

        // 获取视频信息
        const res = await fetchRetry(playlistBaseUrl + videoId, {
            headers: {
                'referer': 'refererBaseUrl + videoId',
                'authorization': 'oauth c3cef7c66a1843f8b3a9e6a1e3160e20' // in zplayer.min.js of zhihu
            }
        }, 3);
        const videoInfo = await res.json();

        // 获取不同分辨率视频的信息
        for (let [key, video] of Object.entries(videoInfo.playlist)) {
            video.name = key;

            if (!videos.find(v => v.width == video.width)) {
                videos.push(video);
            }
        }

        // 按分辨率大小排序
        videos = videos.sort(function (v1, v2) {
            return v1.width == v2.width ? 0 : (v1.width > v2.width ? 1 : -1);
        }).reverse();

        document.addEventListener('DOMNodeInserted', (evt) => {
            let domControlBar = evt.relatedNode.querySelector(':scope > div:last-child > div:first-child');
            if (!domControlBar || domControlBar.querySelector('.download')) return;

            let domFullScreenBtn = domControlBar.querySelector(':scope > div:nth-last-of-type(1)');
            let domResolutionBtn = domControlBar.querySelector(':scope > div:nth-last-of-type(3)');
            let domDownloadBtn, defaultResolution, buttons;
            if (!domFullScreenBtn || !domFullScreenBtn.querySelector('button')) return;

            // 克隆分辨率菜单或全屏按钮为下载按钮
            domDownloadBtn = (domResolutionBtn && (domResolutionBtn.className == domFullScreenBtn.className))
                ? domResolutionBtn.cloneNode(true)
            : domFullScreenBtn.cloneNode(true);

            defaultResolution = domDownloadBtn.querySelector('button').innerText;

            // 生成下载按钮图标
            domDownloadBtn.querySelector('button:first-child').outerHTML = domFullScreenBtn.cloneNode(true).querySelector('button').outerHTML;
            domDownloadBtn.querySelector('svg').innerHTML = svgDownload;
            domDownloadBtn.className = domDownloadBtn.className + ' download';

            buttons = domDownloadBtn.querySelectorAll('button');

            // button 元素添加对应的下载地址
            buttons.forEach(dom => {
                let video = videos.find(v => v.name == resolutionMap[dom.innerText || defaultResolution]);
                video = video || videos[0];
                dom.dataset.video = video.play_url;
                if (dom.innerText) {
                    (dom.innerText = `${dom.innerText} (${humanSize(video.size)})`);
                }
                else if (buttons.length == 1) {
                    dom.nextSibling.querySelector('div').innerText = humanSize(video.size);
                }
            });

            // 鼠标事件 - 显示菜单
            domDownloadBtn.addEventListener('pointerenter', () => {
                let domMenu = domDownloadBtn.querySelector('div:nth-of-type(1)');
                if (domMenu) {
                    domMenu.style.cssText = menuStyle + 'opacity:1 !important; visibility:visible !important';
                }
            });

            // 鼠标事件 - 隐藏菜单
            domDownloadBtn.addEventListener('pointerleave', () => {
                let domMenu = domDownloadBtn.querySelector('div:nth-of-type(1)');
                if (domMenu) {
                    domMenu.style.cssText = menuStyle;
                }
            });

            // 鼠标事件 - 选择菜单项
            domDownloadBtn.addEventListener('pointerup', event => {
                if (downloading) {
                    alert('当前正在执行下载任务，请等待任务完成。');
                    return;
                }

                let e = event.srcElement || event.target;

                while (e.tagName != 'BUTTON') {
                    e = e.parentNode;
                }

                downloadUrl(e.dataset.video);
            });

            // 显示下载按钮
            domControlBar.appendChild(domDownloadBtn);

        });
    })();
}

function addCSS()
{
    var css = 'html[data-theme=dark] .css-1qefhqu{background-color:#1A1A1A}'+
        '.TopstorySideNav-link{color:black}'+
        'html[data-theme=dark] .TopstorySideNav-link{color:#606A80}'+
        'html[data-theme=dark] .TopstorySideNav-link:hover{background-color:#F0F2F7}'+
        'html[data-theme=dark] .TopstorySideNav-link.is-active{color:#0084FF}'+
        '#nightmode{color:black}'+
        '#nightmode:hover{color:#0084FF}'+
        'html[data-theme=dark] #nightmode{color:hsla(0,0%,100%,.8)}'+
        'html[data-theme=dark] #nightmode:hover{color:#0084FF}'


    var head = document.getElementsByTagName('head')[0];
    var style = document.createElement('style');

    style.type = 'text/css';
    if(style.styleSheet)
    {
        style.styleSheet.cssText = css;
    }
    else
    {
        style.appendChild(document.createTextNode(css));
    }
    head.appendChild(style);
}

function topic()
{
    if(hideTopicSideBar==1)
    {
        $(".ContentLayout-sideColumn").hide();
        $(".ContentLayout-mainColumn").width($(".ContentLayout").width());
    }
}

function gifPlaying()
{
    if(GIFAutoPlay==1)
    {
        $(".GifPlayer").addClass("isPlaying");
        $(".GifPlayer .ztext-gif").each(function(){
            if($(this).attr("src").indexOf("webp")==-1)
            {
                $(this).attr("src",$(this).attr("src").replace("jpg","webp"));
                $(this).wrap("<a target='_blank' href='"+$(this).attr("src")+"'></a>")
            }
        })
    }

}

(function() {
    'use strict';

    setInterval(function(){
        $(".SearchBar-input input").attr("placeholder","")
    })

    if($.cookie('nightmode')!=undefined)
    {
        if($.cookie('nightmode')==1)
        {
            $("html").attr("data-theme","dark")
            $("#nightmode").find("img").attr("src",light).attr("style","vertical-align:middle; width:20px; height:20px;")
            $("#nightmode").find("span").text(" 日间模式")
        }
        else
        {
            $("html").attr("data-theme","light")
            $("#nightmode").find("img").attr("src",dark).attr("style","vertical-align:middle; width:18px; height:18px;")
            $("#nightmode").find("span").text(" 夜间模式")
        }
    }


    addCSS();

    setInterval(directLink,100)
    setInterval(iconColor,100)
    setInterval(originalPic,100)
    setInterval(downloadVideo,100)
    setInterval(gifPlaying,100)
    
    if(window.location.href.indexOf("question") > -1)
        setInterval(question, 300);
    else if(window.location.href.indexOf("zvideo") > -1)
        setInterval(zvideo, 300);
    else if(window.location.href.indexOf("club") > -1)
        setInterval(club, 300);
    else if(window.location.href.indexOf("search") > -1)
        setInterval(search, 300);
    else if(window.location.href.indexOf("lives") > -1)
        setInterval(lives, 300);
    else if(window.location.href.indexOf("collection") > -1)
        setInterval(collection, 300);
    else if(window.location.href.indexOf("zhuanlan") > -1)
        setInterval(zhuanlan, 300);
    else if(window.location.href.indexOf("people") > -1)
        setInterval(people, 300);
    else if(window.location.href.indexOf("topic") > -1)
        setInterval(topic, 300);
    else
        setInterval(index, 300);

})();
