(function(window){
    var $ = layui.jquery,layer = layui.layer;
    var gStatus = 0;
    var mGuID = null;
    var timer = null;
    var outTimer = null;

    var $AppConstants = {
        hostName: location.protocol+"//" + location.hostname,
        // hostName: "http://127.0.0.1",
        // hostName: "http://192.168.1.128",
        port: location.port?(":"+location.port):"",
        // port: ":8080",
        webHostName: location.protocol+"//" + location.hostname,
        // webHostName: "http://127.0.0.1",
        webPort: location.port?(":"+location.port):"",
        // webPort: ":8080",
        certificateHostName: "",
        certificatePort: "",
        projectName: "/app/webReport",
        // projectName: "",
        recordCountPerPage: 20
    };

    var $AppURLs = {
        jspPath: "/Report/report_front_end/jsp/report.jsp",
        reportViewPath: "/Report/reports/"
    };

    var $AppVars = {};
    
    var $Utils = {
        formatString: {},
        request: {},
        cookie: {},
        Base64: {},
        loading: {},
        windowLoading: {},
        floatingNumberProcessing: {},
        openWindow:{}
    };

    $Utils.csharp2rgba = function(val) {
        var opacity = ((val >> 24) & 0xFF) + '',
            red = ((val >> 16) & 0xFF) + '',
            green = ((val >> 8) & 0xFF) + '',
            blue = (val & 0xFF) + '';
        return 'rgba(' + red+',' + green+',' + blue+','+(parseInt(opacity.slice(-3))/255).toFixed(2)+')';
    };

    $Utils.converRgbToArgb = function (r,g,b,a){
        var color = ((a << 24)|(r << 16)|(g << 8)|b);
        return color;
    }

    $Utils.reverseFormatting = function(val){
        if (typeof val==='number') return val;
        if(!val)return val;
        if(val.indexOf(',') != -1){
            var reverseVal = val.replace(/,/g,'');
            if(val.indexOf('%') != -1){
                reverseVal = parseFloat(reverseVal)/100;
            }
            return parseFloat(reverseVal);
        }else if(val.indexOf('%') != -1){
            return (parseFloat(val)/100);
        }else{
            return parseFloat(val);
        }
    };

    $.extend($Utils.floatingNumberProcessing,{
        accAdd: function(arg1, arg2){
            var r1, r2, m;
            try {
                r1 = arg1.toString().split(".")[1].length;
            }
            catch (e) {
                r1 = 0;
            }
            try {
                r2 = arg2.toString().split(".")[1].length;
            }
            catch (e) {
                r2 = 0;
            }
            m = Math.pow(10, Math.max(r1, r2));
            
            return (arg1 * m + arg2 * m) / m;
        },
        accSub: function(arg1, arg2){
            var r1, r2, m, n;
            try {
                r1 = arg1.toString().split(".")[1].length;
            }
            catch (e) {
                r1 = 0;
            }
            try {
                r2 = arg2.toString().split(".")[1].length;
            }
            catch (e) {
                r2 = 0;
            }
            m = Math.pow(10, Math.max(r1, r2));
             //last modify by deeka
             //动态控制精度长度
            return (arg1 * m - arg2 * m) / m;
        }
    });
    
    $.extend($Utils.formatString,{
        number : function(type,num){
            if (!type){return num;}
            if (num == null){return num;}
            if (typeof num === "undefined") return num;
            if (typeof num === 'string') return num;
            var decimalDigits = 0;       /* 小数位数*/
            var isNegative = false;

            if(type == '###0'){
                return num;
            }
            if(type.indexOf('E') != -1){
                if(type.indexOf('.') != -1){
                    decimalDigits = type.indexOf('E') - type.indexOf('.')-1;
                    num = num.toExponential(decimalDigits);
                }else{
                    num = num.toExponential();
                }
                return num;
            }
            if(num <= 0){
                isNegative = true;
                num = Math.abs(num);
            }
            if(type.indexOf('%') != -1){
                num = num * 100;
            }
            if(type.indexOf('.') != -1){
                decimalDigits = type.length - type.indexOf('.')-1;
                if(type.indexOf('%') != -1){
                    num = num.toFixed(decimalDigits-1);
                }else{
                    num = num.toFixed(decimalDigits);
                }
            }
            if(type.indexOf(',') != -1){
                var decimalString = "";

                num = num.toString();
                if(num.indexOf('.') != -1){
                    decimalString = num.substring(num.indexOf('.'));
                    num = num.substring(0,num.indexOf('.'));
                }
                var intString = num.toString(), result = '';
                while (intString.length > 3) {
                    result = ',' + intString.slice(-3) + result;
                    intString = intString.slice(0, intString.length - 3);
                }
                if (intString) { result = intString + result; }
                num = result + decimalString;

            }
            if(isNegative && num != 0){
                num = "-" + num;
            }
            if(type.indexOf('%') != -1){
                num = num + "%";
            }
            return num;
        },
        date : function(type,date){
            if (typeof date == 'string') return date;
            if(date == 'Invalid Date') return date;
            if (!date)return date;
            if (type == ''){
                return this.formatDay('YYYY-MM-dd',date);
            }else {
                if (type.indexOf('YYYY')!=-1&&type.indexOf('mm')!=-1){
                    var hourIndex = (type.indexOf('h') == -1?type.indexOf('H'):type.indexOf('h'));
                    var a = this.formatDay(type.slice(0,hourIndex),date);
                    var b = this.formatTime(type.slice(hourIndex),date);
                    return this.formatDay(type.slice(0,hourIndex),date)+this.formatTime(type.slice(hourIndex),date);
                }else{
                    if (type.indexOf('YYYY')!=-1){
                        return this.formatDay(type,date);
                    }else if (type.indexOf('mm')!=-1){
                        return this.formatTime(type,date);
                    }
                }
            }
            return date;
        },
        formatDay:function(type,date){
            var z ={
                Y:date.getFullYear(),
                M:date.getMonth()+1,
                d:date.getDate()
            };
            return type.replace(/(Y+|M+|d+)/g,function(v) {
                var a = (v.length>1?"0":"")+z[v.slice(-1)];
                var b = a.slice(-(v.length>2?v.length:2));
                return ((v.length>1?"0":"")+z[v.slice(-1)]).slice(-(v.length>2?v.length:2))
            });
        },
        formatTime:function(type,date){
            var z ={
                H:date.getHours(),
                h:date.getHours()%12,
                m:date.getMinutes(),
                s:date.getSeconds(),
                aa:['AM','PM']
            };
            return type.replace(/(H+|h+|m+|s+|aa)/g,function(v) {
                if (v=='aa'){
                    return z.aa[z.H>=12?1:0]
                }else{
                    var a = ((v.length>1?"0":"")+z[v.slice(-1)]);
                    var b = a.slice(-(v.length>2?v.length:2))
                    return ((v.length>1?"0":"")+z[v.slice(-1)]).slice(-(v.length>2?v.length:2));
                }
            });
        }
    });

    $.extend($Utils.request,{
        getRequest:function(url,obj,asyncOrSync,dataType,succCallback,failCallback,timeOut){
            var headersObj = {};
            headersObj["Authorization"] = $AppVars.token;
            $.ajax({
                type: 'get',
                url: url ,
                dataType: dataType,
                timeout: timeOut?0:(63000 * $AppVars.queryTimeOut),
                traditional: true,
                headers: headersObj,
                data: obj,
                async: asyncOrSync,
                context: this,
                cache: false,
                /*请求成功回调*/
                success: function(data,status,request){
                    succCallback(data,status,request);
                },
                /*请求失败回调*/
                error:function(XHR,textStatus){
                    failCallback(XHR,textStatus);
                }
            }).then();
        },
        postRequest:function(url,obj,asyncOrSync,dataType,succCallback,failCallback){
            var headersObj = {};
            headersObj["Content-Type"] = "application/json; charset=utf-8";
            headersObj["Authorization"] = $AppVars.token;
            $.ajax({
                type: 'post',
                url: url ,
                dataType: dataType,
                timeout: 63000,
                traditional:true,
                headers: headersObj,
                data: obj,
                async: asyncOrSync,
                context: this,
                cache: false,
                /*请求成功回调*/
                success: function(data,status,request){
                    succCallback(data,status,request);
                },
                /*请求失败回调*/
                error:function(XHR,textStatus){
                    failCallback(XHR,textStatus);
                }
            }).then();
        },
        putRequest:function(url,obj,asyncOrSync,dataType,succCallback,failCallback){
            var headersObj = {};
            headersObj["Content-Type"] = "application/json; charset=utf-8";
            headersObj["Authorization"] = $AppVars.token;
            $.ajax({
                type: 'PUT',
                url: url ,
                dataType: dataType,
                timeout: 63000,
                traditional:true,
                headers: headersObj,
                data: obj,
                async: asyncOrSync,
                context: this,
                cache: false,
                /*请求成功回调*/
                success: function(data,status,request){
                    succCallback(data,status,request);
                },
                /*请求失败回调*/
                error:function(XHR,textStatus){
                    failCallback(XHR,textStatus);
                }
            }).then();
        },
        deleteRequest:function(url,obj,asyncOrSync,dataType,succCallback,failCallback){
            var headersObj = {};
            headersObj["Content-Type"] = "application/json; charset=utf-8";
            headersObj["Authorization"] = $AppVars.token;
            $.ajax({
                type: 'DELETE',
                url: url ,
                dataType: dataType,
                timeout: 63000,
                traditional:true,
                headers: headersObj,
                data: obj,
                async: asyncOrSync,
                context: this,
                cache: false,
                /*请求成功回调*/
                success: function(data,status,request){
                    succCallback(data,status,request);
                },
                /*请求失败回调*/
                error:function(XHR,textStatus){
                    failCallback(XHR,textStatus);
                }
            }).then();
        },
        upLoadRequest:function(url,obj,asyncOrSync,dataType,succCallback,failCallback){
            var headersObj = {};
            headersObj["Authorization"] = $AppVars.token;
            $.ajax({
                type: 'post',
                url: url ,
                dataType: dataType,
                timeout: 63000,
                traditional:true,
                headers: headersObj,
                data: obj,
                async: asyncOrSync,
                contentType:false,
                processData:false,
                context: this,
                cache: false,
                /*请求成功回调*/
                success: function(data,status,request){
                    succCallback(data,status,request);
                },
                /*请求失败回调*/
                error:function(XHR,textStatus){
                    failCallback(XHR,textStatus);
                }
            }).then();
        },
        downLoadRequest:function(url,obj,asyncOrSync,dataType,succCallback,failCallback){
            var xhr = new XMLHttpRequest();
            xhr.open('GET', url, asyncOrSync);        // 也可以使用POST方式，根据接口
            xhr.responseType = dataType;    // 返回类型blob
            xhr.setRequestHeader("Authorization",$AppVars.gLogin.token);
            // 定义请求完成的处理函数，请求前也可以增加加载框/禁用下载按钮逻辑
            xhr.onreadystatechange = function(){
                if(xhr.readyState == 4 && xhr.status == 200){
                    succCallback([this.response]);
                }else{
                    if(xhr.readyState == 4){
                        var data = this.response;
                        var fileReader = new FileReader();
                        fileReader.onload = function() {
                            try {
                                var jsonData = JSON.parse(this.result);  // 说明是普通对象数据，后台转换失败
                                failCallback(xhr.status,jsonData.error)
                            } catch (err) {   // 解析成对象失败，说明是正常的文件流
                                failCallback();
                            } 
                        };
                        fileReader.readAsText(data);
                    }
                }
            };

            xhr.send()
        },
        isJson: function(str){
            if (typeof str == 'string') {
                try {
                    var obj=JSON.parse(str);
                    if(typeof obj == 'object' && obj ){
                        return true;
                    }else{
                        return false;
                    }

                } catch(e) {
                    return false;
                }
            }
        }
    });

    $.extend($Utils.cookie, {
		addCookie: function(cname,cvalue,exdays){
		    var d = new Date();
		    d.setTime(d.getTime() + (exdays*24*60*60*1000));
		    var expires = "expires=" + d.toGMTString();
		    document.cookie = cname+"="+cvalue+";"+expires+";path=/";
		},
		getCookie: function(cname){
		    var name = cname + "=";
		    var ca = document.cookie.split(";");
		    for(var i=0;i<ca.length;i++){
		        var c = ca[i];
		        while(c.charAt(0)==' '){
		            c = c.substring(1);
		        }
		        if(c.indexOf(cname) == 0){
		            return c.substring(name.length,c.length);
		        }
		    }
		    return "";
		},
		deleteCookie: function(cname){
			var exp = new Date()
			exp.setTime(exp.getTime() - 1)
			var cval = this.getCookie(cname);
			if (cval && cval != null) {
				document.cookie = cname + '=' + cval + ';expires=' + exp.toGMTString()+";path=/";
			}
		}
    });

    $Utils.getDeviceTypeID = function(){
        var ua = navigator.userAgent;
        var flag = true;
        if(/Android/i.test(ua)||/iPhone/i.test(ua)){
            if(/Android/i.test(ua)&&(window.screen.width>=540)){
                flag = false;
                return 1;
            }else{
                flag = false;
                return 0;
            }
        }
        if(/iPad|iPod|pad|pod/i.test(ua)){
            flag = false;
            return 1;
        }
        if(flag){
            return 2;
        }
    };

    $Utils.getOsID = function(){
        var ua = navigator.userAgent;
        if (/(iPhone|iPad|iPod|iOS)/i.test(ua)) {
            return 1;
        } else if (/(Android)/i.test(ua)) {
            return 2;
        } else {
               return 0;
        };
    };

    $Utils.sorter = function(data,field,isDesc){
        var tempArr = $.extend(true,[],JSON.parse(JSON.stringify(data)));
        if(isDesc){
            tempArr.sort(arrSortMaxToMin);
        }else{
            tempArr.sort(arrSortMinToMax);
        }

        return tempArr;

        function arrSortMinToMax(a, b) {
            // 判断是否为数字开始; 为啥要判断?看上图源数据
            if (Number(a[field]) && Number(b[field])) {
                // 提取起始数字, 然后比较返回
                return a[field] - b[field];
                // 如包含中文, 按照中文拼音排序
            } else if (isChinese(a[field]) && isChinese(b[field])) {
                // 按照中文拼音, 比较字符串
                return a[field].localeCompare(b[field], 'zh-CN')
            } else {
                // 排序数字和字母
                return a[field].localeCompare(b[field], 'en');
            }
        }

        function arrSortMaxToMin(a,b){
            // 判断是否为数字开始; 为啥要判断?看上图源数据
            if (Number(a[field]) && Number(b[field])) {
                // 提取起始数字, 然后比较返回
                return b[field] - a[field];
                // 如包含中文, 按照中文拼音排序
            } else if (isChinese(a[field]) && isChinese(b[field])) {
                // 按照中文拼音, 比较字符串
                //return a[sortId].localeCompare(b[sortId], 'zh-CN');
                return b[field].localeCompare(a[field], 'zh-CN');
            } else {
                // 排序数字和字母
                return b[field].localeCompare(a[field], 'en');
            }

        }

        // 检测是否为中文，true表示是中文，false表示非中文
        function isChinese(str) {
            // 中文万国码正则
            var repx = new RegExp("^[\u4e00-\u9fa5]");
            if (repx.test(str)) {
                return true;
            } else {
                return false;
            }
        }
    };

    $Utils.openClient = function(url){
        $(".module-yun-tip").show();
        var guID = new GUID();
        mGuID = guID.newGUID();
        // $("body").append("<iframe id='clientOpen'></iframe>");
        // $("#clientOpen").attr("src",url+" /g "+mGuID +" /bp " + $AppConstants.hostName+$AppConstants.port+"/");
        window.location.href = url+" /g "+mGuID +" /bp " + $AppConstants.hostName+$AppConstants.port+"/";
        window.sessionStorage.setItem(window.location.host+"-openClient",0);
        clearTimeout(outTimer);
        clearInterval(timer);
        var num = 0;
        outTimer = setTimeout(function(){
            timer = setInterval(function(){
                if(gStatus == 0){
                    if(num == 10){
                        clearInterval(timer);
                        $Utils.openDownLoadWindow();
                        $(".module-yun-tip").hide();
                        window.sessionStorage.setItem(window.location.host+"-openClient",1);
                    }else{
                        judgeGuID();
                        num++;
                    }
                }else if(gStatus == 1){
                    clearInterval(timer);
                    $(".module-yun-tip").hide();
                    window.sessionStorage.setItem(window.location.host+"-openClient",1);
                }
            }, 1000);
        },3000);
    };

    $Utils.openDownLoadWindow = function(){
        layer.open({
            type: 0,
            title: ["客户端下载","font-size: 14px"],
            resize: false,
            area: ["480px","270px"],
            skin: "delete-window",
            content: '<div class="down-load-content">\
                <div class="file-name">\
                    <span>云智算客户端</span>\
                </div>\
                <div class="down-load-button">\
                    <a href="/app/client/Yunzhisuan Windows Client.zip">下载最新版客户端</a>\
                </div>\
            </div>',
            btn: false,
            success: function(){
                $(".down-load-content .down-load-button a").click(function(){
                    window.sessionStorage.setItem(window.location.host+"-openClient",1);
                });
            },
            cancel: function(){
                window.sessionStorage.setItem(window.location.host+"-openClient",1);
            }
        });
    }

    function judgeGuID(){
        var succ = function(data,status,request){
            if(request.status == 204){
                gStatus = 1;
            }
        };
        var fail = function(){
            gStatus = 0;
        };
        var url = $AppConstants.hostName + $AppConstants.port+'/bdasystem/webOpenClients/'+mGuID;
        $Utils.request.getRequest(url,{},false,'json',succ,fail);
    }

    function GUID(){
        this.date = new Date();   /* 判断是否初始化过，如果初始化过以下代码，则以下代码将不再执行，实际中只执行一次 */
        if (typeof this.newGUID != 'function') {   /* 生成GUID码 */
            GUID.prototype.newGUID = function () {
                this.date = new Date(); var guidStr = '';
                sexadecimalDate = this.hexadecimal(this.getGUIDDate(), 16);
                sexadecimalTime = this.hexadecimal(this.getGUIDTime(), 16);
                for (var i = 0; i < 9; i++) {
                    guidStr += Math.floor(Math.random() * 16).toString(16);
                }
                guidStr += sexadecimalDate;
                guidStr += sexadecimalTime;
                while (guidStr.length < 32) {
                    guidStr += Math.floor(Math.random() * 16).toString(16);
                }
                return this.formatGUID(guidStr);
            }
            /* * 功能：获取当前日期的GUID格式，即8位数的日期：19700101 * 返回值：返回GUID日期格式的字条串 */
            GUID.prototype.getGUIDDate = function () {
                return this.date.getFullYear() + this.addZero(this.date.getMonth() + 1) + this.addZero(this.date.getDay());
            }
            /* * 功能：获取当前时间的GUID格式，即8位数的时间，包括毫秒，毫秒为2位数：12300933 * 返回值：返回GUID日期格式的字条串 */
            GUID.prototype.getGUIDTime = function () {
                return this.addZero(this.date.getHours()) + this.addZero(this.date.getMinutes()) + this.addZero(this.date.getSeconds()) + this.addZero(parseInt(this.date.getMilliseconds() / 10));
            }
            /* * 功能: 为一位数的正整数前面添加0，如果是可以转成非NaN数字的字符串也可以实现 * 参数: 参数表示准备再前面添加0的数字或可以转换成数字的字符串 * 返回值: 如果符合条件，返回添加0后的字条串类型，否则返回自身的字符串 */
            GUID.prototype.addZero = function (num) {
                if (Number(num).toString() != 'NaN' && num >= 0 && num < 10) {
                    return '0' + Math.floor(num);
                } else {
                    return num.toString();
                }
            }
            /*  * 功能：将y进制的数值，转换为x进制的数值 * 参数：第1个参数表示欲转换的数值；第2个参数表示欲转换的进制；第3个参数可选，表示当前的进制数，如不写则为10 * 返回值：返回转换后的字符串 */GUID.prototype.hexadecimal = function (num, x, y) {
                if (y != undefined) { return parseInt(num.toString(), y).toString(x); }
                else { return parseInt(num.toString()).toString(x); }
            }
            /* * 功能：格式化32位的字符串为GUID模式的字符串 * 参数：第1个参数表示32位的字符串 * 返回值：标准GUID格式的字符串 */
            GUID.prototype.formatGUID = function (guidStr) {
                var str1 = guidStr.slice(0, 8) + '-', str2 = guidStr.slice(8, 12) + '-', str3 = guidStr.slice(12, 16) + '-', str4 = guidStr.slice(16, 20) + '-', str5 = guidStr.slice(20);
                return str1 + str2 + str3 + str4 + str5;
            }
        }
    }

    $.extend($Utils.loading,{
        open: function(){
            $(".page-loading").show();
        },
        close: function(){
            $(".page-loading").hide();
        }
    });
    
    $Utils.capitalTip = function (id){
		var capital = false; //聚焦初始化，防止刚聚焦时点击Caps按键提示信息显隐错误
        
        // 获取大写提示的标签，并提供大写提示显示隐藏的调用接口
        var capitalTip = {
            $elem: $("#tips-"+id),
            toggle: function (s) {
                if(s === 'none'){
                    this.$elem.hide();
                }else if(s === 'block'){
                    this.$elem.show();
                }else if(this.$elem.is(':hidden')){
                    this.$elem.show();
                }else{
                    this.$elem.hide();
                   }
            }
        }
        $("#" + id).on("keydown",function(e){
            if (e.keyCode === 20 && capital) { // 点击Caps大写提示显隐切换
                capitalTip.toggle();
            }
        }).on("focus",function(){
        	capital = false
        }).on("keypress",function(e){
        	capsLock(e)
        }).on("blur",function(e){
            //输入框失去焦点，提示隐藏
            capitalTip.toggle('none');
        });
        function capsLock(e){
            var keyCode = e.keyCode || e.which;// 按键的keyCode
            var isShift = e.shiftKey || keyCode === 16 || false;// shift键是否按住
            if(keyCode === 9){
                capitalTip.toggle("none");
            }else{
              //指定位置的字符的 Unicode 编码 , 通过与shift键对于的keycode，就可以判断capslock是否开启了
              // 90 Caps Lock 打开，且没有按住shift键
              if (((keyCode >= 65 && keyCode <= 90) && !isShift) || ((keyCode >= 97 && keyCode <= 122) && isShift)) {
                  // 122 Caps Lock打开，且按住shift键
                  capitalTip.toggle("block"); // 大写开启时弹出提示框
                  capital = true;
              } else {
                  capitalTip.toggle("none");
                  capital = true;
              }
            }
        }
	};
    
    $Utils.sumWidth = function(arry){
        var sumArry = 0;
        for(var i= 0;i<arry.length;i++){
            sumArry += arry[i];
        }
        return sumArry;
    }

    $.extend($Utils.openWindow,{
        failWindow: function(name,errorStatus,msg){
            layer.open({
                type: 0,
                title: name,
                resize: false,
                area: ["480px","270px"],
                skin: "delete-window",
                content: "<div class='fail-box clearfix'><div class='fl fail-icon'></div><div class='fr fail-content'>"+(msg?(errorStatus+'# '+msg):(errorStatus == 0 ?('0# 未知错误。'):errorStatus))+"</div></div>",
                btn: ["确定"],
                success: function(layero,index){
                },
                yes: function(index,layero){
                    layer.close(index);
                }
            });
        }
    });

    $Utils.drawCode = function(show_num) {
        var canvas_width=$('#canvas').width();
        var canvas_height=$('#canvas').height();
        var canvas = document.getElementById("canvas");//获取到canvas的对象，演员
        var context = canvas.getContext("2d");//获取到canvas画图的环境，演员表演的舞台
        canvas.width = canvas_width;
        canvas.height = canvas_height;
        var sCode = "A,B,C,E,F,G,H,J,K,L,M,N,P,Q,R,S,T,W,X,Y,Z,1,2,3,4,5,6,7,8,9,0";
        var aCode = sCode.split(",");
        var aLength = aCode.length;//获取到数组的长度
        
        for (var i = 0; i <= 3; i++) {
            var j = Math.floor(Math.random() * aLength);//获取到随机的索引值
            var deg = Math.random() * 30 * Math.PI / 180;//产生0~30之间的随机弧度
            var txt = aCode[j];//得到随机的一个内容
            show_num[i] = txt.toLowerCase();
            var x = 10 + i * 20;//文字在canvas上的x坐标
            var y = 20 + Math.random() * 8;//文字在canvas上的y坐标
            context.font = "bold 23px 微软雅黑";
 
            context.translate(x, y);
            context.rotate(deg);
 
            context.fillStyle = randomColor();
            context.fillText(txt, 0, 0);
 
            context.rotate(-deg);
            context.translate(-x, -y);
        }
        for (var i = 0; i <= 5; i++) { //验证码上显示线条
            context.strokeStyle = randomColor();
            context.beginPath();
            context.moveTo(Math.random() * canvas_width, Math.random() * canvas_height);
            context.lineTo(Math.random() * canvas_width, Math.random() * canvas_height);
            context.stroke();
        }
        for (var i = 0; i <= 30; i++) { //验证码上显示小点
            context.strokeStyle = randomColor();
            context.beginPath();
            var x = Math.random() * canvas_width;
            var y = Math.random() * canvas_height;
            context.moveTo(x, y);
            context.lineTo(x + 1, y + 1);
            context.stroke();
        }
    };

    function randomColor() {//得到随机的颜色值
        var r = Math.floor(Math.random() * 256);
        var g = Math.floor(Math.random() * 256);
        var b = Math.floor(Math.random() * 256);
        return "rgb(" + r + "," + g + "," + b + ")";
    }

    $Utils.slide = function(){
		var slideBox = $('#slide_box')[0];
        var btn = $('#btn')[0];
        var slideBoxWidth = slideBox.offsetWidth;
        var btnWidth = btn.offsetWidth;
        //pc端
        btn.ondragstart = function () {
            return false;
        };
        btn.onselectstart = function () {
            return false;
        };
        btn.onmousedown = function (e) {
            var disX = e.clientX - btn.offsetLeft;
            document.onmousemove = function (e) {
                var objX = e.clientX - disX + btnWidth;
                if (objX < btnWidth) {
                    objX = btnWidth
                }
                if (objX > slideBoxWidth) {
                    objX = slideBoxWidth
                }
                $('#slide_xbox').width(objX + 'px');
            };
            document.onmouseup = function (e) {
                var objX = e.clientX - disX + btnWidth;
                if (objX < slideBoxWidth) {
                    objX = btnWidth;
                } else {
                    objX = slideBoxWidth;
                    locked = true;
                    $('#slide_xbox').html('验证通过<div id="btn" style="color: #35b34a;">&gt;&gt;</div>');
                    $("#validate-hidden").val(1).change();;
                }
                $('#slide_xbox').width(objX + 'px');
                document.onmousemove = null;
                document.onmouseup = null;
            };
        };
	};

    window.$Utils = $Utils;
    window.$AppURLs = $AppURLs;
    window.$AppConstants = $AppConstants;
    window.$AppVars = $AppVars;

})(window)