/*类---PromptFilter*/
function PromptFilter(){
    this.filterID = null;
    this.valueObjectType = null;
    this.multipleValue = null;
    this.valueObjectName = null;
    this.dataType = null;
    this.prompt = null;
    this.operation = null;
    this.valueObjectData = null;
    this.filterValues = null;
    this.formatString = null;
    this.cascadePrompt = null;
    this.marginRight = null;
    this.inputWidth = null;
    this.selectedValues = [];

    this.convertObjectData = function(){
        if (this.dataType == 1 && this.valueObjectData.length){
            var self = this;
            $.each(this.valueObjectData,function(){
                this[self.valueObjectName] = $BDA.formatString.date('',new Date(this[self.valueObjectName]));
            });
        }
    };

    this.setSelectedValues = function(){
        for (var i = 0,len=this.filterValues.length;i<len;i++){
            var value = this.filterValues[i].value;
            //if (this.dataType == 1){
            //    value = $BDA.formatString.date('',new Date(parseInt(this.filterValues[i].value)));
            //}
            this.selectedValues.push(value);
        }
    };

    this.init = function(options){
        for(var key in options){
            this[key] = options[key];
        }
    };
}

function PromptFilters(){
    var me=this;
    this.count = 0;
    this.dicPromptFilters = {};
    this.aryPromptFilters = [];

    this.add = function (filter) {
        this.aryPromptFilters.push(filter);
        this.dicPromptFilters[filter.filterID]=filter;

        this.count = this.aryPromptFilters.length;
    };

    this.remove = function (filter) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryPromptFilters[i].filterID==filter.filterID){
                k=i;
                break;
            }
        }
        this.aryPromptFilters.splice(k,1);
        delete this.dicPromptFilters[filter.filterID];

        this.count=this.aryPromptFilters.length;
    };

    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryPromptFilters[indexOrKey];
        }else{
            return this.dicPromptFilters[indexOrKey];
        }
    };

    this.getPromptFilters = function (reportID,includeValueObjectData,asyncOrSync,succ,fail) {
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.reportViewPath + reportID + "/promptFilters?includeValueObjectData=" + includeValueObjectData;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                setPromptFilters(data.items);
                succ();
            }
        };
        var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        };
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    function setPromptFilters(data){
        me.count = 0;
        me.dicPromptFilters = {};
        me.aryPromptFilters = [];
        for(var i = 0; i < data.length; i++){
            var promptFilter = new PromptFilter();
            promptFilter.init(data[i]);
            promptFilter.convertObjectData();
            promptFilter.setSelectedValues();
            me.add(promptFilter);
        }
    }
}

function ReportView(){
    var me=this;
    this.reportView = {};

    this.init = function(reportID,requestParameters,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.reportViewPath + reportID + "/reportView";
        var obj = JSON.stringify(requestParameters);
        var dataType = 'json';

    	var succCallback = function(data,status,request){
    		if(request.status == 200){
                setReportView(me,data,succ);
    		}
    	};
    	var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
        		fail("网络连接不可用。");
        	}else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
        		if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
        	}else{
        		fail("未知错误。");
        	}
        };
        $Utils.request.postRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    function setReportView(me,data,succ){
        me.reportView = data.property;
        me.viewBlocks = new ViewBlocks();
        me.viewVerticalTableBlocks = new ViewVerticalTableBlocks();
        me.reportSettings = new ReportSettings();

        if(data.property.viewVerticalTableBlocks.length){
            me.viewVerticalTableBlocks.setViewVerticalTableBlocks([data.property.viewVerticalTableBlocks[0]]);
            me.viewBlocks.addAll(me.viewVerticalTableBlocks);
    
            me.reportSettings.setReportSettings(data.property.reportSettings);
            copyBlockDataToBlockDataToDraw(me.viewBlocks);
            succ();
        }
    }

    function copyBlockDataToBlockDataToDraw(viewBlocks){
        for(var i = 0; i < viewBlocks.count; i++){
            $.extend(true,viewBlocks.item(i).blockDataToDraw,viewBlocks.item(i).blockData);
        }
    }
}

function ViewBlock(options){
    this.queryIDs = options.queryIDs;
    this.blockID = options.blockID;
    this.blockName = options.blockName;
    this.chartID = options.chartID;
    this.blockLayouts = options.blockLayouts;
    this.reportLink = options.reportLink;
    this.blockData = options.blockData;
    this.linkageParameters = [];
    this.blockDataToDraw = [];
    this.linkage = options.linkage?new Linkage(options.linkage):null;
    this.backgroundImage = options.backgroundImage;
    this.showToolButtons = options.showToolButtons;
    this.singleLineTitleBar = options.singleLineTitleBar;
    this.backgroundColorTransparent  = options.backgroundColorTransparent ;
    this.margin = options.margin;
    this.backgroundColor = options.backgroundColor;
    this.autoRefreshFollowReport = options.autoRefreshFollowReport;
    this.scaleUpByMagnifyButton = options.scaleUpByMagnifyButton;
    this.borderWidth = options.borderWidth;
    this.borderColor = options.borderColor;
    this.borderRadius = options.borderRadius;
}

function ViewBlocks(){
    this.count = 0;
    this.dicViewBlocks = {};
    this.aryViewBlocks = [];

    this.add = function (viewBlock) {
        this.aryViewBlocks.push(viewBlock);
        this.dicViewBlocks['_' + viewBlock.blockID]=viewBlock;

        this.count = this.aryViewBlocks.length;
    };

    this.addAll = function(viewBlocks){
        for (var i = 0; i < viewBlocks.count; i++){
            this.add(viewBlocks.item(i));
        }
    }
    this.remove = function (viewBlock) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryViewBlocks[i].blockID==viewBlock.blockID){
                k=i;
                break;
            }
        }
        this.aryViewBlocks.splice(k,1);
        delete this.dicViewBlocks['_' + viewBlock.blockID];

        this.count = this.aryViewBlocks.length;
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryViewBlocks[indexOrKey];
        }else{
            return this.dicViewBlocks[indexOrKey];
        }
    };

}

/*类---标题*/
function BlockTitle(options){
    this.title = options.title;
    this.titleTextBox = options.titleTextBox;
    this.titleBottomBorderWidth = options.titleBottomBorderWidth;
    this.titleBottomBorderColor = options.titleBottomBorderColor;
    this.titleExpression = options.titleExpression;
    this.titleIcon = options.titleIcon;
}

/*类---副标题*/
function Subtitle(options){
    this.subtitle = options.subtitle;
    this.subtitleTextBox = options.subtitleTextBox;
    this.subtitleExpression = options.subtitleExpression;
}

/*类---标记区*/
function Mark(options){
    this.remark = options.remark;
    this.remarkTextBox = options.remarkTextBox;
}

/*类---表格块*/
function ViewVerticalTableBlock(options){

    ViewBlock.call(this,options);
    BlockTitle.call(this,options);
    Subtitle.call(this,options);
    Mark.call(this,options);

    this.viewTableHead = new TableHead(options.viewTableHead);
    this.viewTableBody = new TableBody(options.viewTableBody);
    this.viewTableFoot = new TableFoot(options.viewTableFoot);
    this.viewTableWarnings = options.viewTableWarnings;
    this.autoMergeDimensionCells = options.autoMergeDimensionCells;
    this.showColumnBarForMeasure = options.showColumnBarForMeasure;
    this.positiveColumnBarColor = options.positiveColumnBarColor;
    this.negativeColumnBarColor = options.negativeColumnBarColor;
    this.notShowBorderOfDetailTableCell = options.notShowBorderOfDetailTableCell;
    this.columnBarMaxLength = options.columnBarMaxLength;
    this.tBodyScrolling = options.tBodyScrolling;
    this.scrollTimePerLine = options.scrollTimePerLine;
    this.headHeight = options.headHeight;
    this.bodyHeight = options.bodyHeight;
    this.footHeight = options.footHeight;
    this.tableStyle = options.tableStyle;
    this.tableStyleColor = options.tableStyleColor;
    this.wordWrap = options.wordWrap;
    this.striped = options.striped;
    this.rowMarginBottom = options.rowMarginBottom;
    this.pagingDisplay = options.pagingDisplay;
    this.pageRecordCount = options.pageRecordCount;
    this.frozenColumnCount = options.frozenColumnCount;
    this.padding = options.padding;
}

function ViewVerticalTableBlocks(){
    this.count = 0;
    this.dicViewVerticalTableBlocks = {};
    this.aryViewVerticalTableBlocks = [];

    this.add = function (block) {
        this.aryViewVerticalTableBlocks.push(block);
        this.dicViewVerticalTableBlocks[block.blockID]=block;

        this.count = this.aryViewVerticalTableBlocks.length;
    };
    this.remove = function (block) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryViewVerticalTableBlocks[i].blockID==block.blockID){
                k=i;
                break;
            }
        }
        this.aryViewVerticalTableBlocks.splice(k,1);
        delete this.dicViewVerticalTableBlocks[block.blockID];

        this.count=this.aryViewVerticalTableBlocks.length;
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryViewVerticalTableBlocks[indexOrKey];
        }else{
            return this.dicViewVerticalTableBlocks[indexOrKey];
        }
    };
    this.setViewVerticalTableBlocks = function (data) {
        this.count = 0;
        this.dicViewVerticalTableBlocks = {};
        this.aryViewVerticalTableBlocks = [];
        for(var intI = 0; intI < data.length; intI++ ){
            var block = new ViewVerticalTableBlock(data[intI]);
            this.add(block);
        }
    };
}

function TableHead(options){
    var tableRows = new TableRows();
    tableRows.setTableRows(options.viewTableRows)
    this.viewTableRows = tableRows;
}

function TableBody(options){
    var tableRows = new TableRows();
    tableRows.setTableRows(options.viewTableRows)
    this.viewTableRows = tableRows;
}

function TableFoot(options){
    var tableRows = new TableRows();
    tableRows.setTableRows(options.viewTableRows)
    this.viewTableRows = tableRows;
}

function TableRow(options){
    var tableCells = new TableCells();
    tableCells.setTableCells(options.viewTableCells)
    this.rowID = options.rowID;
    this.viewTableCells = tableCells;
}

function TableRows(){
    this.count = 0;
    this.dicTableRows = {};
    this.aryTableRows = [];

    this.add = function (tableRow){
        this.aryTableRows.push(tableRow);
        this.dicTableRows[tableRow.rowID]=tableRow;

        this.count = this.aryTableRows.length;
    };
    this.remove = function (tableRow) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryTableRows[i].rowID==tableRow.rowID){
                k=i;
                break;
            }
        }
        this.aryTableRows.splice(k,1);
        delete this.dicTableRows[tableRow.rowID];

        this.count=this.aryTableRows.length;
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryTableRows[indexOrKey];
        }else{
            return this.dicTableRows[indexOrKey];
        }
    };
    this.setTableRows = function (data){
        this.count = 0;
        this.dicTableRows = {};
        this.aryTableRows = [];
        if(data.length){
            var tableRow = new TableRow(data[data.length-1]);
            this.add(tableRow);
        }
        // for(var intI = 0; intI < data.length; intI++ ){
        //     var tableRow = new TableRow(data[intI]);
        //     this.add(tableRow);
        // }
    };
}

function TableCell(){
    this.cellObject = null;
    this.cellTextBox = null;
    this.colspan = 0;
    this.columnBarMaxLength = 0.8;
    this.columnIndex = null;
    this.formatString = '';
    this.negativeColumnBarColor = null;
    this.positiveColumnBarColor = null;
    this.reportLink = null;
    this.rowID = null;
    this.rowspan = 0;
    this.showColumnBarForMeasure = false;
    this.text = null;
    this.columnWidth = 108;
    this.autoColumnWidth = true;
    this.viewSparkline = null;
    this.borderWidth = null;
    this.borderColor = null;
    this.borderRadius = null;

    this.init = function(options){
        for(var key in options){
            this[key] = options[key];
        }
    };
}

function TableCells(){
    this.count = 0;
    this.aryTableCells = [];

    this.add = function (tableCell){
        this.aryTableCells.push(tableCell);

        this.count = this.aryTableCells.length;
    };
    this.positionAdd = function(index,tableCell){
        this.aryTableCells.splice(index,0,tableCell);
        this.count = this.aryTableCells.length;
        for(var i = 0; i < this.count; i++){
            this.aryTableCells[i].columnIndex = i;
        }
    };
    this.remove = function (tableCell) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryTableCells[i].columnIndex==tableCell.columnIndex){
                k=i;
                break;
            }
        }
        this.aryTableCells.splice(k,1);

        this.count=this.aryTableCells.length;
        for(var i = 0; i < this.count; i++){
            this.aryTableCells[i].columnIndex = i;
        }
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryTableCells[indexOrKey];
        }
    };
    this.setTableCells = function (data){
        this.count = 0;
        this.aryTableCells = [];
        for(var intI = 0; intI < data.length; intI++ ){
            var tableCell = new TableCell();
            tableCell.init(data[intI]);
            this.add(tableCell);
        }
    };
}

function ReportSetting(){
    this.reportSettingKey = null;
    this.reportSettingValue = null;

    this.init = function(options){
        for(var key in options){
            this[key] = options[key];
        }
    };
}

function ReportSettings(){
    var me = this;
    this.count = 0;
    this.dicreportSettings = {};
    this.aryreportSettings = [];

    this.add = function (reportSetting) {
        this.aryreportSettings.push(reportSetting);
        this.dicreportSettings[reportSetting.reportSettingKey]=reportSetting;

        this.count = this.aryreportSettings.length;
    };
    this.remove = function (reportSetting) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryreportSettings[i].reportSettingKey==reportSetting.reportSettingKey){
                k=i;
                break;
            }
        }
        this.aryreportSettings.splice(k,1);
        delete this.dicreportSettings[reportSetting.reportSettingKey];

        this.count=this.aryreportSettings.length;
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryreportSettings[indexOrKey];
        }else{
            return this.dicreportSettings[indexOrKey];
        }
    };

    this.setReportSettings = function (data) {
        this.count = 0;
        this.dicreportSettings = {};
        this.aryreportSettings = [];
        for(var intI = 0; intI < data.length; intI++ ){
            var reportSetting = new ReportSetting();
            reportSetting.init(data[intI]);
            this.add(reportSetting);
        }
    };
}

function GetDatas(){
    this.getDataObjects = function(reportID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.reportViewPath + reportID;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                succ(data.item);
            }
        };
        var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        };
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.getQueryDatas = function(reportID,parameters,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.reportViewPath + reportID + "/queryDatas?parameters=" + encodeURIComponent(JSON.stringify(parameters));
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                succ(data.items);
            }
        };
        var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        };
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
}