/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-11-11 09:26:27
 * @LastEditTime: 2020-11-30 18:16:56
 * @LastModifyUser: 
 * @pxark: 
 */

layui.config({
    base: './layui/lay/modules/' //此处路径请自行处理, 可以使用绝对路径
}).extend({
    formSelects: 'formSelects-v4'
}).use(['jquery','form','layer','formSelects','laydate'],function(){
    var $ = layui.jquery, form = layui.form, layer = layui.layer, laydate = layui.laydate, formSelects = layui.formSelects;
    var reportID = null;
    var reportView = new ReportView();
    var promptFilters = new PromptFilters();
    var getData = new GetDatas();
    var dataObjects = null;
    var queryDatas = null;
    var filterSucc = false;
    var queryGetSucc = false;
    var requestParameters = null;
    var clientHeight = document.documentElement.clientHeight;

    if((location.href.indexOf("reportID=") != -1) && (location.href.indexOf("token=") != -1)){
        reportID = (location.href.split("reportID=")[1]).split("&")[0];
        $AppVars.token = (location.href.split("token=")[1]).split("&")[0];
        if(location.href.indexOf("parameters=") != -1){
            requestParameters = decodeURIComponent(((location.href.split("parameters=")[1]).split("&")[0]));
        }
    }else{
        return;
    }
    getDataObjects();

    function getDataObjects(){
        var succ = function(data){
            dataObjects = data;
            getReportView();
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取数据对象列表",errorStatus,msg);
		};
        getData.getDataObjects(reportID,true,succ,fail);
    }

    function getReportView(){
        var succ = function(){
            $Utils.loading.close();
            getQueryDatas();
            getPromptFilters(0);
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取报表",errorStatus,msg);
        };
        var currentParameters = requestParameters?requestParameters:{};
        reportView.init(reportID,currentParameters,true,succ,fail);
    }

    function getQueryDatas(){
        var succ = function(data){
            queryGetSucc = true;
            queryDatas = data[0].dataSet;
		};
		var fail = function(errorStatus,msg){
			$Utils.openWindow.failWindow("获取数据集",errorStatus,msg);
        };
        var currentParameters = requestParameters?requestParameters:{};
        getData.getQueryDatas(reportID,currentParameters,true,succ,fail);
    }

    function init(){
        $(".container").css("height",clientHeight);
        clientHeight = clientHeight - ($(".pc-filter-custom").innerHeight() <= 10 ?0:$(".pc-filter-custom").innerHeight());
        $(".vertical-table").css("height",clientHeight);
        createLeftTree();
        createRightTable();
        try{
            window.external.loaded();
        }catch(e) {
            return false;
        }
    }

    function getPromptFilters(index){
        var succ = function(){
            if(index == 0){
                if(promptFilters.count){
                    $(".pc-filter-custom").show().height((calculateFilterHeight()*42));
                }
                init();
                getPromptFilters(1);
            }
            if(index == 1){
                if (requestParameters){
                    var parameters= JSON.parse(decodeURIComponent(filter_base64));
                    $.each(promptFilters.aryPromptFilters,function(){
                        for (var key in parameters){
                            if (this.prompt == key){
                                if(parameters[key]){
                                    this.selectedValues = parameters[key];
                                }
                                break;
                            }
                        }
                    });
                }
                filterSucc = true;
                initPromptFilters();
            }
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取报表过滤条件",errorStatus,msg);
        };
        promptFilters.getPromptFilters(reportID,index,true,succ,fail);
    }

    function calculateFilterHeight(){
        var widthSum = [];
        for(var i = 0; i < promptFilters.aryPromptFilters.length; i++){
            widthSum.push(getLength(promptFilters.aryPromptFilters[i].prompt) + 5);
            widthSum.push(promptFilters.aryPromptFilters[i].inputWidth + promptFilters.aryPromptFilters[i].marginRight);
        }
        widthSum.push(64);
        var rowNum = 1;
        var maxWidth = $("body").width();
        var sumWidth = 0;
        for(var i = 0; i < widthSum.length;){
            sumWidth += widthSum[i];
            if(sumWidth > maxWidth){
                rowNum++;
                sumWidth = 0;
                i = i - 1;
            }
            i++;
        }
        return rowNum;
    }

    function getLength(str){
        $('.test-length span').css({
            'font-family': "微软雅黑",
            'font-size': "12px"
        });
        return parseInt($('.test-length span').html(str).width());
    }

    function initPromptFilters(){
        var cascadeSelectArr = [];
        for(var i = 0; i < promptFilters.count; i++){
            var str = "";
            if(promptFilters.item(i).valueObjectType == 1 || promptFilters.item(i).operation == 8 || promptFilters.item(i).operation == 9){
                //输入框
                initInputText(form,i);
            }else if(promptFilters.item(i).operation == 6 || promptFilters.item(i).operation == 7){
                //多选下拉框
                initFormSelects(formSelects,i,cascadeSelectArr);
            }else{
                if(promptFilters.item(i).dataType == 1){
                    //日期控件
                    if(reportView.reportSettings.item("calendarWithLunar") && reportView.reportSettings.item("calendarWithLunar").reportSettingValue == '1'){
                        initLunarCalendar(form,i);
                    }else{
                        initDateControl(laydate,i);
                    }
                }else{
                    //单选下拉框
                    initSelect(form,i,cascadeSelectArr);
                }
            }
        }

        var buttonStr = '<div class="layui-inline filter-button">\
            <div class="layui-input-block">\
                <button class="layui-btn" lay-submit="" lay-filter="submitFilter">查询</button>\
            </div>\
        </div>';

        $(".pc-filter-custom .layui-form").append(buttonStr);

        bindChangeSelectEvent(form,formSelects,cascadeSelectArr);
        // initNormal();

        bindSubmitEvent(form,layer);
        $(".pc-filter-custom").css("height","auto");
    }

    function initInputText(form,i){
        var str = "";
        str = '<div class="layui-inline filter" data-filterid='+promptFilters.item(i).filterID+' style="margin-right:'+promptFilters.item(i).marginRight+'px">\
            <label class="layui-form-label">'+promptFilters.item(i).prompt+'</label>\
            <div class="layui-input-inline" style="width:'+(promptFilters.item(i).inputWidth?promptFilters.item(i).inputWidth:90)+'px;">\
                <input type="text" name='+promptFilters.item(i).filterID+' class="layui-input">\
            </div>\
        </div>';
        var obj = {};
        obj[promptFilters.item(i).filterID] = promptFilters.item(i).selectedValues[0];

        $(".pc-filter-custom .layui-form").append(str);
        form.val('pcFilter', obj);
        form.render();
    }

    function initFormSelects(formSelects,i,cascadeSelectArr){
        var str = "";
        var option = "";
        var tempArr = [];
        var cascadeObjectName = '';
        var cascadeSelecteds = [];
        var operation = 0;
        var cascadeObjectData = $.extend(true,[],promptFilters.item(i).valueObjectData);
        if(promptFilters.item(i).cascadePrompt){
            for(var j = 0; j < promptFilters.count; j++){
                if(promptFilters.item(i).cascadePrompt == promptFilters.item(j).prompt){
                    cascadeObjectName = promptFilters.item(j).valueObjectName;
                    cascadeSelecteds = promptFilters.item(j).selectedValues;
                    operation = promptFilters.item(j).operation;
                    cascadeSelectArr.push({
                        isFormSelect:(promptFilters.item(j).operation==6 || promptFilters.item(j).operation==7)?true:false,
                        filterName:promptFilters.item(j).filterID,
                        targetID:promptFilters.item(i).filterID,
                        cascadePrompt: promptFilters.item(j).valueObjectName,
                        cascadeOperation: promptFilters.item(j).operation,
                        childIsFormSelect: true
                    });
                    break;
                }
            }
            for(var j = cascadeObjectData.length-1; j >= 0; j--){
                if(judgeCascadeObjectData(cascadeSelecteds,cascadeObjectData[j][cascadeObjectName]+'',operation)){
                    cascadeObjectData.splice(j,1);
                }
            }
        }
        for(var j = 0; j < cascadeObjectData.length; j++){
            option += '<option value="'+cascadeObjectData[j][promptFilters.item(i).valueObjectName]+'">'+cascadeObjectData[j][promptFilters.item(i).valueObjectName]+'</option>';
        }
        for(var j = 0; j < promptFilters.item(i).selectedValues.length; j++){
            tempArr.push(promptFilters.item(i).selectedValues[j]);
        }
        str =  '<div class="layui-inline filter form-select" data-filterid='+promptFilters.item(i).filterID+' style="margin-right:'+promptFilters.item(i).marginRight+'px">\
            <label class="layui-form-label">'+promptFilters.item(i).prompt+'</label>\
            <div class="layui-input-inline" style="width:'+(promptFilters.item(i).inputWidth?promptFilters.item(i).inputWidth:200)+'px;">\
                <select id='+promptFilters.item(i).filterID+' name='+promptFilters.item(i).filterID+' xm-select='+promptFilters.item(i).filterID+' xm-select-show-count="2" xm-select-search="" xm-select-height="27px">'+option+'</select>\
            </div>\
        </div>';

        $(".pc-filter-custom .layui-form").append(str);
        formSelects.render(promptFilters.item(i).filterID);
        formSelects.value(promptFilters.item(i).filterID,tempArr);
        formSelects.btns(promptFilters.item(i).filterID, ['select', 'remove'], {show: 'name'});
    }

    function initDateControl(laydate,i){
        var str = "";
        str = '<div class="layui-inline filter" data-filterid='+promptFilters.item(i).filterID+' style="margin-right:'+promptFilters.item(i).marginRight+'px">\
            <label class="layui-form-label">'+promptFilters.item(i).prompt+'</label>\
            <div class="layui-input-inline" style="width:'+(promptFilters.item(i).inputWidth?promptFilters.item(i).inputWidth:90)+'px;">\
                <input type="text" class="layui-input search-date" id="date-custom-input'+i+'" lay-key='+i+'>\
            </div>\
        </div>';
        var startYear = new Date(Number(promptFilters.item(i).selectedValues[0])).getFullYear();
        var startMonth = new Date(Number(promptFilters.item(i).selectedValues[0])).getMonth()+1>9?(new Date(Number(promptFilters.item(i).selectedValues[0])).getMonth()+1):("0"+(new Date(Number(promptFilters.item(i).selectedValues[0])).getMonth()+1));
        var startDate = new Date(Number(promptFilters.item(i).selectedValues[0])).getDate() >9 ?new Date(Number(promptFilters.item(i).selectedValues[0])).getDate():("0"+new Date(Number(promptFilters.item(i).selectedValues[0])).getDate());

        $(".pc-filter-custom .layui-form").append(str);
        var layDateType = "date";
        var layDateFormat = "yyyy/MM/dd";
        var startValue = startYear+'/'+startMonth+'/'+startDate;
        if(promptFilters.item(i).formatString.indexOf("mm") != -1){
            layDateType = "datetime";
            layDateFormat = "yyyy/MM/dd HH:mm:ss";
            var startTime = $Utils.formatString.date("HH:mm:ss",new Date(Number(promptFilters.item(i).selectedValues[0])));
            startValue = startValue+" "+startTime;
            $("#date-custom-input"+i).addClass("time-input");
        }
        laydate.render({
            elem: '#date-custom-input'+i,
            value: promptFilters.item(i).selectedValues[0]?startValue:"",
            format: layDateFormat,
            isInitValue: true,
            type: layDateType,
            theme: '#3278b4'
        });
    }

    function initLunarCalendar(form,i){
        var startValue = '';
        var inputStartValue = '';
        if(promptFilters.item(i).selectedValues.length){
            var startYear = new Date(Number(promptFilters.item(i).selectedValues[0])).getFullYear();
            var startMonth = new Date(Number(promptFilters.item(i).selectedValues[0])).getMonth()+1>9?(new Date(Number(promptFilters.item(i).selectedValues[0])).getMonth()+1):("0"+(new Date(Number(promptFilters.item(i).selectedValues[0])).getMonth()+1));
            var startDate = new Date(Number(promptFilters.item(i).selectedValues[0])).getDate() >9 ?new Date(Number(promptFilters.item(i).selectedValues[0])).getDate():("0"+new Date(Number(promptFilters.item(i).selectedValues[0])).getDate());
    
            startValue = startYear+'/'+startMonth+'/'+startDate;
            inputStartValue = startValue;
        }else{
            var startYear = new Date().getFullYear();
            var startMonth = new Date().getMonth()+1>9?(new Date().getMonth()+1):("0"+(new Date().getMonth()+1));
            var startDate = new Date().getDate() >9 ?new Date().getDate():("0"+new Date().getDate());
    
            startValue = startYear+'/'+startMonth+'/'+startDate;
        }
        var str = "";
        str = '<div class="layui-inline filter" data-filterid='+promptFilters.item(i).filterID+' style="margin-right:'+promptFilters.item(i).marginRight+'px">\
            <label class="layui-form-label">'+promptFilters.item(i).prompt+'</label>\
            <div class="layui-input-inline date-calendar" style="width:'+(promptFilters.item(i).inputWidth?promptFilters.item(i).inputWidth:90)+'px;">\
                <input type="text" class="layui-input" name='+promptFilters.item(i).filterID+' id="date-custom-input'+i+'">\
                <div class="date-box" id="date-custom-box'+i+'"></div>\
            </div>\
        </div>';
        
        $(".pc-filter-custom .layui-form").append(str);

        $("#date-custom-input"+i).off('click').on('click',function(e){
            $(".date-calendar .sc-calendar").html('').css("visibility","hidden");
            var currentDate = $(this).val();
            if(currentDate == ""){
                var startYear = new Date().getFullYear();
                var startMonth = new Date().getMonth()+1>9?(new Date().getMonth()+1):("0"+(new Date().getMonth()+1));
                var startDate = new Date().getDate() >9 ?new Date().getDate():("0"+new Date().getDate());
        
                currentDate = startYear+'/'+startMonth+'/'+startDate;
            }
            var myCalendar = null;
            var boxID = "#date-custom-box"+i;
            myCalendar = new SimpleCalendar(boxID,{
                'width': '270px',
                'height': '270px',
                'initDate': currentDate
            });
            e.stopPropagation();
        
            $(boxID).css("visibility","visible");
        });

        var obj = {};
        obj[promptFilters.item(i).filterID] = inputStartValue;
        form.val('pcFilter', obj);
        form.render();
        
    }

    function judgeCascadeObjectData(originalArray,compareValue,operation){
        var judgeSymbol = false;
        switch (operation){
            case 0:
                for(var i = 0; i < originalArray.length; i++){
                    if(originalArray[i] != compareValue){
                        judgeSymbol = true;
                    }
                }
                break;
            case 1:
                for(var i = 0; i < originalArray.length; i++){
                    if(originalArray[i] == compareValue){
                        judgeSymbol = true;
                    }
                }
                break;
            case 2:
                for(var i = 0; i < originalArray.length; i++){
                    if(originalArray[i] > compareValue || originalArray[i] == compareValue){
                        judgeSymbol = true;
                    }
                }
                break;
            case 3:
                for(var i = 0; i < originalArray.length; i++){
                    if(originalArray[i] > compareValue){
                        judgeSymbol = true;
                    }
                }
                break;
            case 4:
                for(var i = 0; i < originalArray.length; i++){
                    if(originalArray[i] < compareValue || originalArray[i] == compareValue){
                        judgeSymbol = true;
                    }
                }
                break;
            case 5:
                for(var i = 0; i < originalArray.length; i++){
                    if(originalArray[i] < compareValue){
                        judgeSymbol = true;
                    }
                }
                break;
            case 6:
                if(originalArray.indexOf(compareValue) == -1){
                    judgeSymbol = true;
                }
                break;
            case 7:
                if(originalArray.indexOf(compareValue) != -1){
                    judgeSymbol = true;
                }
                break;
        }
        return judgeSymbol;
    }

    function initSelect(form,i,cascadeSelectArr){
        var str = "";
        var option = "";
        var cascadeObjectName = '';
        var cascadeSelecteds = [];
        var operation = 0;
        var cascadeObjectData = $.extend(true,[],promptFilters.item(i).valueObjectData);
        if(promptFilters.item(i).cascadePrompt){
            for(var j = 0; j < promptFilters.count; j++){
                if(promptFilters.item(i).cascadePrompt == promptFilters.item(j).prompt){
                    cascadeObjectName = promptFilters.item(j).valueObjectName;
                    cascadeSelecteds = promptFilters.item(j).selectedValues;
                    operation = promptFilters.item(j).operation;
                    cascadeSelectArr.push({
                        isFormSelect:(promptFilters.item(j).operation==6 || promptFilters.item(j).operation==7)?true:false,
                        filterName:promptFilters.item(j).filterID,
                        targetID:promptFilters.item(i).filterID,
                        cascadePrompt: promptFilters.item(j).valueObjectName,
                        cascadeOperation: promptFilters.item(j).operation,
                        childIsFormSelect: false
                    });
                    break;
                }
            }
            for(var j = cascadeObjectData.length-1; j >= 0; j--){
                if(judgeCascadeObjectData(cascadeSelecteds,cascadeObjectData[j][cascadeObjectName]+'',operation)){
                    cascadeObjectData.splice(j,1);
                }
            }
        }

        for(var j = 0; j <= cascadeObjectData.length; j++){
            if(j==0){
                if(promptFilters.item(i).selectedValues.length == 0){
                    option += '<option value="" selected="">（忽略）</option>';
                }else{
                    option += '<option value="">（忽略）</option>';
                }
            }else{
                if(promptFilters.item(i).selectedValues.length && cascadeObjectData[j-1][promptFilters.item(i).valueObjectName] == promptFilters.item(i).selectedValues[0]){
                    option += '<option value="'+cascadeObjectData[j-1][promptFilters.item(i).valueObjectName]+'" selected="">'+cascadeObjectData[j-1][promptFilters.item(i).valueObjectName]+'</option>';
                }else{
                    option += '<option value="'+cascadeObjectData[j-1][promptFilters.item(i).valueObjectName]+'">'+cascadeObjectData[j-1][promptFilters.item(i).valueObjectName]+'</option>';
                }
            }
        }
        str = '<div class="layui-inline search-list filter" id="'+promptFilters.item(i).filterID+'" data-filterid='+promptFilters.item(i).filterID+' style="margin-right:'+promptFilters.item(i).marginRight+'px">\
            <label class="layui-form-label">'+promptFilters.item(i).prompt+'</label>\
            <div class="layui-input-inline" style="width:'+(promptFilters.item(i).inputWidth?promptFilters.item(i).inputWidth:90)+'px;">\
                <select name='+promptFilters.item(i).filterID+' id="checkStatus'+promptFilters.item(i).filterID+'" lay-filter="checkStatus'+promptFilters.item(i).filterID+'" lay-search>'+option+'</select>\
            </div>\
        </div>';

        $(".pc-filter-custom .layui-form").append(str);
        form.render();
    }

    function bindChangeSelectEvent(form,formSelects,cascadeSelectArr){
        for(var i = 0; i < cascadeSelectArr.length; i++){
            (function(i){
                if(cascadeSelectArr[i].isFormSelect){
                    formSelects.on(cascadeSelectArr[i].filterName,function(id, vals, val, isAdd, isDisabled){
                        var selectValue = [];
                        if(isAdd){
                            for(var j = 0; j < vals.length; j++){
                                selectValue.push(vals[j].value);
                            }
                            selectValue.push(val.value);
                        }else{
                            for(var j = vals.length-1; j>=0; j--){
                                if(vals[j].value == val.value){
                                    vals.splice(j,1);
                                }else{
                                    selectValue.unshift(vals[j].value);
                                }
                            }
                        }
                        var cascadeObjectData = $.extend(true,[],promptFilters.item(cascadeSelectArr[i].targetID).valueObjectData);
                        for(var j = cascadeObjectData.length-1; j >= 0; j--){
                            if(judgeCascadeObjectData(selectValue,cascadeObjectData[j][cascadeSelectArr[i].cascadePrompt]+'',cascadeSelectArr[i].cascadeOperation)){
                                cascadeObjectData.splice(j,1);
                            }
                        }
                        if(cascadeSelectArr[i].childIsFormSelect){
                            setFormSelectEvent(cascadeSelectArr,i,cascadeObjectData,formSelects)
                        }else{
                            setSelectEvent(cascadeSelectArr,i,cascadeObjectData,form)
                        }
                    });
                }else{
                    form.on("select(checkStatus"+cascadeSelectArr[i].filterName+")",function(data){
                        var cascadeObjectData = $.extend(true,[],promptFilters.item(cascadeSelectArr[i].targetID).valueObjectData);
                        for(var j = cascadeObjectData.length-1; j >= 0; j--){
                            if(judgeCascadeObjectData([data.value],cascadeObjectData[j][cascadeSelectArr[i].cascadePrompt]+'',cascadeSelectArr[i].cascadeOperation)){
                                cascadeObjectData.splice(j,1);
                            }
                        }
                        if(cascadeSelectArr[i].childIsFormSelect){
                            setFormSelectEvent(cascadeSelectArr,i,cascadeObjectData,formSelects)
                        }else{
                            setSelectEvent(cascadeSelectArr,i,cascadeObjectData,form)
                        }
                    });
                }
            })(i);
        }
    }

    function setFormSelectEvent(cascadeSelectArr,i,cascadeObjectData,formSelects){
        var tempArr = [];
        for(var j = 0; j < cascadeObjectData.length; j++){
            var tempObj = {};
            tempObj.name = cascadeObjectData[j][promptFilters.item(cascadeSelectArr[i].targetID).valueObjectName];
            tempObj.value = cascadeObjectData[j][promptFilters.item(cascadeSelectArr[i].targetID).valueObjectName];
            tempArr.push(tempObj);
        }
        formSelects.data(cascadeSelectArr[i].targetID,'local',{
            arr:tempArr
        });
        if(cascadeObjectData.length){
            $("#"+cascadeSelectArr[i].targetID).siblings("div.xm-select-parent").find('dl dd').eq(2).click();
            formSelects.value(cascadeSelectArr[i].targetID,[cascadeObjectData[0][promptFilters.item(cascadeSelectArr[i].targetID).valueObjectName]]);
        }
    }

    function setSelectEvent(cascadeSelectArr,i,cascadeObjectData,form){
        $("#checkStatus"+cascadeSelectArr[i].targetID).empty();
        var option = "";
        for(var j = 0; j <= cascadeObjectData.length; j++){
            var option = document.createElement("option");
            if(j == 0){
                option.setAttribute("selected",true);
                option.setAttribute("value","");
                option.innerText = "（忽略）";
            }else{
                option.setAttribute("value",cascadeObjectData[j-1][promptFilters.item(cascadeSelectArr[i].targetID).valueObjectName]);
                option.innerText = cascadeObjectData[j-1][promptFilters.item(cascadeSelectArr[i].targetID).valueObjectName];
            }
            $("#checkStatus"+cascadeSelectArr[i].targetID)[0].appendChild(option);
        }
        form.render();
        $("#checkStatus"+cascadeSelectArr[i].targetID).siblings("div.layui-form-select").find('dl dd').eq(0).click();
    }

    function bindSubmitEvent(form,layer){
        $(".filter-button button").off('click').on('click',function(){
            var filterData = form.val("pcFilter");
            $(".pc-filter-custom").trigger("click");
            for(var i = 0; i < promptFilters.count; i++){
                if(promptFilters.item(i).dataType == 1){
                    promptFilters.item(i).selectedValues = [];
                    if($("#date-custom-input"+i).val()){
                        promptFilters.item(i).selectedValues.push(new Date($("#date-custom-input"+i).val()).getTime()+"");
                    }else{
                        promptFilters.item(i).selectedValues = [];
                    }
                }else if(promptFilters.item(i).operation == 6 || promptFilters.item(i).operation == 7){
                    if(filterData[promptFilters.item(i).filterID]){
                        promptFilters.item(i).selectedValues = filterData[promptFilters.item(i).filterID].split(",");
                    }else{
                        promptFilters.item(i).selectedValues = [];
                    }
                }else{
                    var arr = [];
                    if(filterData[promptFilters.item(i).filterID]){
                        arr.push(filterData[promptFilters.item(i).filterID]);
                    }
                    promptFilters.item(i).selectedValues = arr;
                }
            }
            loadAfterFilter();
            return false;
        });

    }

    function filterParameters(){
        var parameters = {};
        $.each(promptFilters.aryPromptFilters , function(){
            parameters[this.prompt] = this.selectedValues;
        });
        return parameters;
    }

    function loadAfterFilter(){
        requestParameters = filterParameters();
        $Utils.loading.open();
        queryGetSucc = false;
        var succ = function(data){
            $Utils.loading.close();
            queryGetSucc = true;
            queryDatas = data[0].dataSet;
            setBlockData();
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取数据集",errorStatus,msg);
        };
        var currentParameters = requestParameters?requestParameters:{};
        getData.getQueryDatas(reportID,currentParameters,true,succ,fail);
    }

    function createLeftTree(){
        $(".data-objects ul").html("");
        for(var i = 0; i < dataObjects.reportDesign.dataObjects.length; i++){
            var dataObject = dataObjects.reportDesign.dataObjects[i];
            if(dataObject.objectType == 0){
                $(".data-objects ul").append("<li class='object' draggable='true' data-objectid='"+dataObject.objectID+"' title='"+dataObject.objectName+"'><i class='iconfont icon-dimension'></i>"+dataObject.objectName+"</li>");
            }
            if(dataObject.objectType == 1){
                $(".data-objects ul").append("<li class='object' draggable='true' data-objectid='"+dataObject.objectID+"' title='"+dataObject.objectName+"'><i class='iconfont icon-measure'></i>"+dataObject.objectName+"</li>");
            }
        }
    }

    $(window).resize(function(){
        clientHeight = document.documentElement.clientHeight;
        init();
    });

    function createRightTable(){
        var tableData = assignTableData(reportView.viewBlocks.item(0));
        drawTable(reportView.viewBlocks.item(0),tableData);
    }

    function assignTableData(viewBlock){
        var vertivalTable = {};
        var tableHead = viewBlock.viewTableHead;
        var tableBody = viewBlock.viewTableBody;
        var tableFoot = viewBlock.viewTableFoot;
        var intLength = tableHead.viewTableRows.count;

        vertivalTable.sum = viewBlock.blockDataToDraw?viewBlock.blockDataToDraw.length:0;

        viewBlock.blockDataToDraw = viewBlock.blockDataToDraw || [];

        var tableBodyArry = [],formatArry = [];
        for(var i= 0,len=viewBlock.blockDataToDraw.length;i<len;i++){
            var obj = {},finalObj = {};
            var tempObj = $.extend(true,{},viewBlock.blockDataToDraw[i]);
            for(var j= 0,jen=tableBody.viewTableRows.item(0).viewTableCells.count;j<jen;j++){
                var tableCell = tableBody.viewTableRows.item(0).viewTableCells.item(j);
                finalObj[tableCell.columnIndex] = viewBlock.blockDataToDraw[i][tableCell.cellObject[0]+'___'+tableCell.cellObject[1]]===null ? '' : viewBlock.blockDataToDraw[i][tableCell.cellObject[0]+'___'+tableCell.cellObject[1]];

                var value = viewBlock.blockDataToDraw[i][tableCell.cellObject[0]+'___'+tableCell.cellObject[1]];
                if(tableCell.cellObject[3] == 3){
                    if(value.indexOf("http://") != -1 || value.indexOf("https://") != -1){
                        obj[tableCell.columnIndex] = "<img height='"+(parseInt(tableCell.cellTextBox.font.size))+"' src='"+ value +"'/>";
                    }else {
                        obj[tableCell.columnIndex] = "<img height='" + (parseInt(tableCell.cellTextBox.font.size)) + "' src='/Report/resource/report/custom/img/" + value + "'/>";
                    }
                }else if(tableCell.cellObject[3] == 4){
                    obj[tableCell.columnIndex] = "<img height='"+(parseInt(tableCell.cellTextBox.font.size))+"' src='data:image/png;base64,"+ value +"'/>";
                }else{
                    if(!tableCell.formatString){
                        if(tableCell.cellObject[3] == 1){
                            obj[tableCell.columnIndex] = (value===null || value==="")?"":$Utils.formatString.date(tableCell.formatString,new Date(value));
                        }else{
                            obj[tableCell.columnIndex] = value===null?"":value;
                        }
                    }else {
                        if(tableCell.cellObject[3] == 1){
                            obj[tableCell.columnIndex] = (value===null || value==="")?"":$Utils.formatString.date(tableCell.formatString,new Date(Number(value)));
                        }else if(tableCell.cellObject[3] == 2){
                            obj[tableCell.columnIndex] = (value===null || value==="")?"":$Utils.formatString.number(tableCell.formatString,value);
                        }else{
                            obj[tableCell.columnIndex] = value===null?"":value;
                        }
                    }
                }
                delete tempObj[tableCell.cellObject[0]+'___'+tableCell.cellObject[1]];
            }
            for(var key in tempObj){
                obj[key] =tempObj[key];
            }
            obj.rowIndex = i;
            finalObj.rowIndex = i;
            tableBodyArry.push(finalObj);
            formatArry.push(obj);
        }

        vertivalTable.original = viewBlock.blockDataToDraw;
        vertivalTable.startBody = tableBodyArry;
        vertivalTable.tableBodyData = formatArry;

        var sortArry = [];
        $.extend(true,sortArry,vertivalTable.tableBodyData);
        vertivalTable.sortArry = sortArry;

        var theadIdentical = [];

        for(var i=0;i<intLength;i++){
            for(var j=0;j<tableHead.viewTableRows.item(i).viewTableCells.count;j++){
                if(!tableHead.viewTableRows.item(i).viewTableCells.item(j).text){
                    theadIdentical.push(tableHead.viewTableRows.item(i).viewTableCells.item(j).columnIndex);
                }
            }
        }

        vertivalTable.tableHead = [];
        vertivalTable.tableHeadStyle = [];
        vertivalTable.tableHeadDivStyle = [];

        for(var i=0;i<intLength;i++){
            var tableHeadData = [];
            var tdStyleArr = [];
            var divStyleArr = [];
            for(var j= 0,jen=tableHead.viewTableRows.item(i).viewTableCells.count;j<jen;j++){
                var tableCell = tableHead.viewTableRows.item(i).viewTableCells.item(j);
                if(tableCell.colspan && tableCell.rowspan){
                    var obj = {};

                    if(tableCell.colspan==1){
                        obj.field = tableCell.columnIndex+'';
                    }

                    if(!tableCell.formatString){
                        if(tableCell.cellObject[3] != 1){
                            obj.title = tableCell.text===null?"":tableCell.text;
                        }else{
                            obj.title = (tableCell.text===null || tableCell.text==="")?"":$Utils.formatString.date(tableCell.formatString,new Date(Number(tableCell.text)));
                        }
                    }else {
                        if(tableCell.cellObject[3] <= 0){
                            obj.title = tableCell.text===null?"":tableCell.text;
                        }else if(tableCell.cellObject[3] == 1){
                            obj.title = (tableCell.text===null || tableCell.text==="")?"":$Utils.formatString.date(tableCell.formatString,new Date(Number(tableCell.text)));
                        }else{
                            obj.title = (tableCell.text===null || tableCell.text==="")?"":$Utils.formatString.number(tableCell.formatString,tableCell.text);
                        }
                    }

                    obj.colspan = tableCell.colspan;
                    obj.rowspan = tableCell.rowspan;
                    //obj.resizable = false;
                    obj.align = tableCell.cellTextBox.textAlign=='0'?'left':(tableCell.cellTextBox.textAlign=='1'?'center':'right');

                    if((tableCell.autoColumnWidth || (!tableCell.autoColumnWidth && tableCell.columnWidth !=0))&&tableCell.colspan){
                        tdStyleArr.push({
                            "color": $Utils.csharp2rgba(tableCell.cellTextBox.color),
                            "backgroundColor": $Utils.csharp2rgba(tableCell.cellTextBox.backgroundColor),
                            "textAlign": tableCell.cellTextBox.textAlign=='0'?'left':(tableCell.cellTextBox.textAlign=='1'?'center':'right'),
                            "verticalAlign": tableCell.cellTextBox.verticalAlign=='0'?'top':(tableCell.cellTextBox.verticalAlign=='1'?'middle':'bottom'),
                            "font-family": tableCell.cellTextBox.font.fontFamily,
                            'font-size': tableCell.cellTextBox.font.size+"px",
                            'font-style': tableCell.cellTextBox.font.italic?'italic':'normal',
                            'font-weight': tableCell.cellTextBox.font.bold?'bold':'normal',
                            'text-decoration': tableCell.cellTextBox.font.underline?'underline':(tableCell.cellTextBox.font.strikeout?'line-through':'none')
                        });
                        divStyleArr.push({
                            "color": $Utils.csharp2rgba(tableCell.cellTextBox.color),
                            "textAlign": tableCell.cellTextBox.textAlign=='0'?'left':(tableCell.cellTextBox.textAlign=='1'?'center':'right'),
                            "verticalAlign": tableCell.cellTextBox.verticalAlign=='0'?'top':(tableCell.cellTextBox.verticalAlign=='1'?'middle':'bottom'),
                            "font-family": tableCell.cellTextBox.font.fontFamily,
                            'font-size': tableCell.cellTextBox.font.size+"px",
                            'font-style': tableCell.cellTextBox.font.italic?'italic':'normal',
                            'font-weight': tableCell.cellTextBox.font.bold?'bold':'normal',
                            'text-decoration': tableCell.cellTextBox.font.underline?'underline':(tableCell.cellTextBox.font.strikeout?'line-through':'none')
                        })
                    }
                    tableHeadData.push(obj);
                }
            }
            vertivalTable.tableHeadStyle.push(tdStyleArr);
            vertivalTable.tableHeadDivStyle.push(divStyleArr);
            vertivalTable.tableHead.push(tableHeadData);
        }

        /*获取所有含有field的对象*/
        var fieldObjArry = [], fieldList = [];
        for(var i= 0,len=vertivalTable.tableHead.length;i<len;i++){
            for(var j= 0,jen=vertivalTable.tableHead[i].length;j<jen;j++){
                var columnIndex = vertivalTable.tableHead[i][j].field;
                if(columnIndex&&(fieldList.indexOf(columnIndex)==-1)){
                    fieldObjArry.push(vertivalTable.tableHead[i][j]);
                    fieldList.push(columnIndex);
                }
            }
        }

        /*以field的大小来正序*/
        fieldObjArry.sort(function(a,b){
            return parseFloat(a.field)-parseFloat(b.field);
        });

        vertivalTable.fieldObjArry = fieldObjArry;

        var tableBlockFoot = [];

        for(var m=0;m<tableFoot.viewTableRows.count;m++){
            var obj = {};

            for(var n=0;n<tableFoot.viewTableRows.item(m).viewTableCells.count;n++){
                var tableCell = tableFoot.viewTableRows.item(m).viewTableCells.item(n);
                if(!tableCell.formatString){
                    if(tableCell.cellObject[3] != 1){
                        obj[tableCell.columnIndex] = tableCell.text===null?"":tableCell.text;
                    }else{
                        obj[tableCell.columnIndex] = (tableCell.text===null || tableCell.text==="")?"":$Utils.formatString.date(tableCell.formatString,new Date(Number(tableCell.text)));
                    }
                }else {
                    if(tableCell.cellObject[3] <= 0){
                        obj[tableCell.columnIndex] = tableCell.text===null?"":tableCell.text;
                    }else if(tableCell.cellObject[3] == 1){
                        obj[tableCell.columnIndex] = (tableCell.text===null || tableCell.text==="")?"":$Utils.formatString.date(tableCell.formatString,new Date(Number(tableCell.text)));
                    }else{
                        obj[tableCell.columnIndex] = (tableCell.text===null || tableCell.text==="")?"":$Utils.formatString.number(tableCell.formatString,tableCell.text);
                    }
                }
                obj.rowIndex = vertivalTable.sum + i;
            }
            tableBlockFoot.push(obj);
        }

        for(var i=0;i<tableBlockFoot.length;i++){
            vertivalTable.tableBodyData.push(tableBlockFoot[i]);
        }

        vertivalTable.footerData = tableBlockFoot;

        function getMeasureColumnMaxValue(){
            var bodyTableRows = viewBlock.viewTableBody.viewTableRows.item(0);
            var maxValueArry = [];
            for(var i= 0,len=bodyTableRows.viewTableCells.count;i<len;i++){
                if(bodyTableRows.viewTableCells.item(i).cellObject[2] == 1){
                    var maxValue = 0;
                    for(var j= 0,jen=viewBlock.blockDataToDraw.length;j<jen;j++){
                        if(maxValue < Math.abs(viewBlock.blockDataToDraw[j][bodyTableRows.viewTableCells.item(i).cellObject[0]+'___'+bodyTableRows.viewTableCells.item(i).cellObject[1]])){
                            maxValue = Math.abs(viewBlock.blockDataToDraw[j][bodyTableRows.viewTableCells.item(i).cellObject[0]+'___'+bodyTableRows.viewTableCells.item(i).cellObject[1]]);
                        }
                    }
                    maxValueArry.push(maxValue);
                }
            }

            return maxValueArry;
        }

        vertivalTable.maxValueArray = getMeasureColumnMaxValue();
        vertivalTable.isNotHiddenScroll = false;

        var tableWarnings = [];
        var tempObj = {};
        var isRepeat = false;
        var currentRepeatIndex = null;
        if(viewBlock.viewTableWarnings){
            for(var i = 0; i < viewBlock.viewTableWarnings.length; i++){
                tempObj = {};
                if(tableWarnings.length){
                    isRepeat = false;
                    for(var j = 0; j < tableWarnings.length; j++){
                        if(viewBlock.viewTableWarnings[i].objectName == tableWarnings[j].objectName){
                            isRepeat = true;
                            break;
                        }
                    }
                    if(isRepeat){
                        tableWarnings[j].warnings.push(viewBlock.viewTableWarnings[i]);
                    }else{
                        tempObj.objectName = viewBlock.viewTableWarnings[i].objectName;
                        tempObj.warnings = [];
                        tempObj.warnings.push(viewBlock.viewTableWarnings[i]);
                        tableWarnings.push(tempObj);
                    }
                }else{
                    tempObj.objectName = viewBlock.viewTableWarnings[i].objectName;
                    tempObj.warnings = [];
                    tempObj.warnings.push(viewBlock.viewTableWarnings[i]);
                    tableWarnings.push(tempObj);
                }
            }
            for(var i = 0; i < tableWarnings.length; i++){
                for(var j = 0; j < tableWarnings[i].warnings.length; j++){
                    if(tableWarnings[i].warnings[j].compareValueType){
                        isRepeat = false;
                        currentRepeatIndex = null;
                        for(var k = 0; k < tableBody.viewTableRows.item(0).viewTableCells.count; k++){
                            var tableBodyCell = tableBody.viewTableRows.item(0).viewTableCells.item(k);
                            if((tableWarnings[i].warnings[j].compareObject[0]+"___"+tableWarnings[i].warnings[j].compareObject[1]) == (tableBodyCell.cellObject[0]+"___"+tableBodyCell.cellObject[1])){
                                isRepeat = true;
                                currentRepeatIndex = tableBodyCell.columnIndex;
                                break;
                            }
                        }
                        if(isRepeat){
                            tableWarnings[i].warnings[j].compareObjectField = currentRepeatIndex;
                        }else{
                            tableWarnings[i].warnings[j].compareObjectField = tableWarnings[i].warnings[j].compareObject[0]+"___"+tableWarnings[i].warnings[j].compareObject[1];
                        }
                    }
                }
            }
            vertivalTable.tableWarnings = tableWarnings;
        }
        vertivalTable.currentPage = 1;
        vertivalTable.pageSizeNum = 0;

        return vertivalTable;
    }

    function drawTable(viewBlock,tableData){
        var userAgent = window.navigator.userAgent;
        var isWebkit = false;
        if(userAgent.indexOf('Chrome') != -1){
            isWebkit = true;
        }
        var tableHeight = $('.vertical-table').height();
        var tableWidth = $('.vertical-table').width();
        var table = document.createElement('table');
        
        var pageSizeNum = setPageSIze();
        var queue = 0;     /*1正序  -1倒序*/
        var pageLoaded = true;
        var firstLoading = true;
        var timer = null;
        
        maxWidth();
        setTableWidth(tableWidth);
        tableData.pageSizeNum = pageSizeNum;

        $('.vertical-table').html('');

        $(table).css({
            width: tableWidth,
            height: tableHeight
        });

        $('.vertical-table').append(table);
        deleteTableCellWidth0();
        if(firstLoading){
            setFrozenColumn();

        }
        if(viewBlock.pagingDisplay){
            $(table).datagrid({loadFilter: pagerFilter}).datagrid({
                pagination: viewBlock.pagingDisplay,	//表示在datagrid设置分页
                pageSize: pageSizeNum,
                pageNumber:1,	//第几页显示（默认第一页，可以省略）
                pageList: [pageSizeNum, 20, 30,40,50],
                url: null,
                remoteSort: false,
                frozenColumns: viewBlock.frozenColumnCount?tableData.frozenColumns:[],
                columns: tableData.tableHead,
                scrollbarSize: 20,
                striped: viewBlock.striped,
                singleSelect: true,
                data: tableData.tableBodyData,
                onLoadSuccess: function () {
                    var self = this;
                    tableSuccess(self);
                }
            });
            $($(table).datagrid("getPager")).pagination({
                showRefresh: false,
            })
        }else{
            var datagridObj = {
                pageSize: pageSizeNum,
                url: null,
                remoteSort: false,
                frozenColumns: viewBlock.frozenColumnCount?tableData.frozenColumns:[],
                columns: tableData.tableHead,
                scrollbarSize: 20,
                striped: viewBlock.striped,
                singleSelect: true,
                //data: tableData.tableBodyData,
                onLoadSuccess: function () {
                    var self = this;
                    tableSuccess(self);
                }
            };

            if(!viewBlock.tBodyScrolling && tableData.tableBodyData.length>100){
                datagridObj.view = scrollview
            }
            $(table).datagrid(datagridObj).datagrid('loadData', tableData.tableBodyData);
        }

        function tableSuccess(self){
            var indexType = viewBlock.tableStyle?viewBlock.tableStyle:0;
            setBorderType(indexType);
            setStyle();

            clickTrBackground();

            /*高度不满一屏 取消滚动条*/
            var tBodyHeight = parseFloat($('.vertical-table').find('.datagrid-view .datagrid-btable').height());
            var datagridBodyHeight = parseFloat($('.vertical-table').find('.datagrid-view div.datagrid-body').height());

            if(((tBodyHeight<=datagridBodyHeight) && tableData.isNotHiddenScroll)||viewBlock.tBodyScrolling){
                $('.vertical-table').find('.datagrid-view div.datagrid-body').css('overflow-y','hidden');
            }

            ///*宽度设置   start*/
            var contentWidth = parseFloat($('.vertical-table').find('.bda-chart-content').width());
            var currentTheadWidth = parseFloat($('.vertical-table').find('.datagrid-view .datagrid-htable').width());

            if((contentWidth - currentTheadWidth) < 17){
                $('.vertical-table').find('.datagrid-view .datagrid-body').css('overflow-x','auto');
            }

            //是否设置合并
            if(viewBlock.autoMergeDimensionCells){
                var tableBodyMergeRows = computeTableMergeRows(viewBlock.viewTableBody);
                mergeTDForBody(self,tableBodyMergeRows);
            }

            mergeTDForFoot(self);

            var measureIndexArray = addSpanBox();
            setSpanStyle(tableData.maxValueArray, measureIndexArray);

            if(viewBlock.notShowBorderOfDetailTableCell){
                hideCellBorder();
            }

            if(viewBlock.viewTableWarnings){
                setTableWarnings();
            }

            if(viewBlock.tBodyScrolling && (tBodyHeight>datagridBodyHeight)){
                var speed = viewBlock.scrollTimePerLine;
                clearTimeout(timer);
                timer = null;
                timer = setTimeout(function(){
                    tBodyScroll(speed);
                },1000);
            }
            
            if(firstLoading){
                addSpanToHeadCell();
            }
            pageLoaded = true;
            firstLoading = false;
        }

        function setPageSIze(){
            var pageSize = 50;
            if(viewBlock.pageRecordCount != -1){
                pageSize = viewBlock.pageRecordCount;
            }else{
                var bodyHeight = tableHeight - tableData.tableHead.length * viewBlock.headHeight;
                bodyHeight = viewBlock.pagingDisplay?(bodyHeight-35):bodyHeight;
                pageSize = viewBlock.bodyHeight?parseInt(bodyHeight/viewBlock.bodyHeight):50;
            }
            return pageSize;
        }

        function pagerFilter(data){
            if (typeof data.length == 'number' && typeof data.splice == 'function') {	// is array
                data = {
                    total: data.length,
                    rows: data
                }
            }
            var dg = $(this);
            var opts = dg.datagrid('options');
            var pager = dg.datagrid('getPager');
            tableData.currentPage = opts.pageNumber;
            tableData.pageSizeNum = opts.pageSize;
            pager.pagination({
                onSelectPage: function (pageNum, pageSize) {
                    if(!pageLoaded){ return;}
                    pageLoaded = false;
                    opts.pageNumber = pageNum;
                    opts.pageSize = pageSize;
                    pager.pagination('refresh', {
                        pageNumber: pageNum,
                        pageSize: pageSize
                    });
                    dg.datagrid('loadData', data);
                }
            });
            if (!data.originalRows) {
                data.originalRows = (data.rows);
            }
            var start = (opts.pageNumber - 1) * parseInt(opts.pageSize);
            var end = start + parseInt(opts.pageSize);
            data.rows = (data.originalRows.slice(start, end));
            return data;
        }

        function  computeTableMergeRows(tableBody){
            var arrMergeRows = [], arrMergeRow=[], mergeRow = {}, lastMergeRow = {}, previousIsMerge = true;
            var currentPageTableRowLength = $('.vertical-table').find('.datagrid-view2 .datagrid-body .datagrid-btable tr').length;
            var lastTableRowIndex = $('.vertical-table').find('.datagrid-view2 .datagrid-body .datagrid-btable tr:last-child').attr("datagrid-row-index");
            if(viewBlock.pagingDisplay){
                if((Number(lastTableRowIndex) + (tableData.currentPage - 1) * tableData.pageSizeNum) >= tableData.sum){
                    currentPageTableRowLength = tableData.sum - (tableData.currentPage - 1) * tableData.pageSizeNum;
                }
            }else{
                if(Number(lastTableRowIndex) >= tableData.sum){
                    currentPageTableRowLength = currentPageTableRowLength - (Number(lastTableRowIndex) - tableData.sum) - 1;
                }
            }

            for(var i = 0; i<tableBody.viewTableRows.item(0).viewTableCells.count; i++){
                arrMergeRow=[];
                if(tableBody.viewTableRows.item(0).viewTableCells.item(i).cellObject[2] == 0){      //2 is object type, and 0 is diemenssion
                    for(var j = 0; j < currentPageTableRowLength;){
                        mergeRow = {};
                        mergeRow.row = Number($('.vertical-table').find('.datagrid-view2 .datagrid-body .datagrid-btable tr').eq(j).attr('datagrid-row-index'));
                        mergeRow.rowspan = 1;
                        mergeRow.col =i;mergeRow.rowDomIndex=j;
                        var cellText = $('.vertical-table').find('.datagrid-view2 .datagrid-body .datagrid-btable tr').eq(j).find('td').eq(i).find('div').html();
                        if(arrMergeRows.length == 0){
                            for(var k = j + 1; k < currentPageTableRowLength; k++){
                                j = k;
                                if (cellText == $('.vertical-table').find('.datagrid-view2 .datagrid-body .datagrid-btable tr').eq(k).find('td').eq(i).find('div').html()){
                                     mergeRow.rowspan++;
                                }else { break;}
                            }
                        }else {
                            previousIsMerge = false;
                            for(var m = 0; m < arrMergeRows[arrMergeRows.length - 1].length; m++){
                                lastMergeRow = arrMergeRows[arrMergeRows.length - 1][m];
                                if(j >= lastMergeRow.rowDomIndex && j <= lastMergeRow.rowDomIndex + lastMergeRow.rowspan - 2) {
                                    previousIsMerge = true;
                                    break;
                                }
                            }
                            if(previousIsMerge){
                                for(var k = j + 1; k < currentPageTableRowLength; k++){
                                    j = k;
                                    if ((cellText == $('.vertical-table').find('.datagrid-view2 .datagrid-body .datagrid-btable tr').eq(k).find('td').eq(i).find('div').html()) &&
                                        (k >= lastMergeRow.rowDomIndex + 1 && k <= lastMergeRow.rowDomIndex + lastMergeRow.rowspan - 1)){
                                            mergeRow.rowspan++;
                                    }else { break;}
                                }
                            }else { j++; }
                        }
                        arrMergeRow.push(mergeRow);
                        if(j == currentPageTableRowLength - 1){ j++; }
                    }
                    arrMergeRows.push(arrMergeRow);
                }
            }

            return arrMergeRows;
        }

        function getLength(str,isHead,i,j){
            if(isHead){
                $('.test-length span').css({
                    'font-family': viewBlock.viewTableHead.viewTableRows.item(j).viewTableCells.item(i).cellTextBox.font.fontFamily,
                    'font-size': viewBlock.viewTableHead.viewTableRows.item(j).viewTableCells.item(i).cellTextBox.font.size+"px"
                });
                return parseInt($('.test-length span').html(str).width() + (10 + 13));   //8,表头单元格内边距，13，表头排序三角符宽度
            }else{
                $('.test-length span').css({
                    'font-family': viewBlock.viewTableBody.viewTableRows.item(0).viewTableCells.item(i).cellTextBox.font.fontFamily,
                    'font-size': viewBlock.viewTableBody.viewTableRows.item(0).viewTableCells.item(i).cellTextBox.font.size+"px"
                });
                return parseInt($('.test-length span').html(str).width() + 14);
            }
        }

        function maxWidth(){
            var tableHeadStrLength = computeTableHeadTableCellWidth();
            var tableBodyStrLength = computeTableBodyTableCellWidth();
            var tableCellMaxWidthArray = [];
            var maxValue = 0;

            for(var i= 0;i<tableBodyStrLength.length;i++){
                maxValue = Math.max(tableHeadStrLength[i],tableBodyStrLength[i]);
                tableCellMaxWidthArray.push(maxValue);
            }

            tableData.maxTopWidth = tableCellMaxWidthArray;
        }

        function computeTableHeadTableCellWidth(){
            var tableHead = viewBlock.viewTableHead;
            var tableHeadStrLength = [];
            var array = [];
            var tableCell = null;
            for(var i = 0; i < tableHead.viewTableRows.item(0).viewTableCells.count; i++){
                array = [];
                tableCell = tableHead.viewTableRows.item(0).viewTableCells.item(i);
                // if(tableCell.colspan > 1){
                //     array.push(0);
                // }else{
                    if(tableCell.autoColumnWidth){
                        for(var j= 0,jen=tableHead.viewTableRows.count;j<jen;j++){
                            if(tableHead.viewTableRows.item(j).viewTableCells.item(i).colspan > 1){
                                array.push(0);
                            }else{
                                var strLength = tableHead.viewTableRows.item(j).viewTableCells.item(i).text;
                                array.push(getLength(strLength,true,i,j)+1);
                            }
                        }
                    }else{
                        array.push(tableCell.columnWidth);
                    }
                // }

                tableHeadStrLength.push(Math.max.apply(Math,array));
            }
            return tableHeadStrLength;
        }

        function computeTableBodyTableCellWidth(){
            var tableBodyStrLength = [];
            var tableBody = viewBlock.viewTableBody;
            var array = [];
            var tableCell = null;
            var jen = tableData.tableBodyData.length>pageSizeNum?pageSizeNum:tableData.tableBodyData.length;
            for(var i = 0; i < tableBody.viewTableRows.item(0).viewTableCells.count; i++){
                array = [];
                tableCell = tableBody.viewTableRows.item(0).viewTableCells.item(i);
                if(tableCell.autoColumnWidth){
                    for(var j= 0;j<jen;j++){
                        var strLength = tableData.tableBodyData[j][i];
                        array.push(getLength(strLength,false,i)+1);
                    }
                }else{
                    array.push(tableCell.columnWidth);
                }
                tableBodyStrLength.push(Math.max.apply(Math,array));
            }

            return tableBodyStrLength;
        }

        function setTableWidth(tableWidth){
            var headHeight = (viewBlock.headHeight?viewBlock.headHeight:30);
            var bodyHeight = (viewBlock.bodyHeight?viewBlock.bodyHeight:30);
            var footHeight = (viewBlock.footHeight?viewBlock.footHeight:30);
            var currentTableHeight = tableData.tableHead.length * headHeight + tableData.startBody.length * bodyHeight + tableData.footerData.length * footHeight + viewBlock.rowMarginBottom * (tableData.tableHead.length + tableData.startBody.length + tableData.footerData.length);
            var maxSumValue = sumWidth(tableData.maxTopWidth);
            var indexType = viewBlock.tableStyle?viewBlock.tableStyle:0;
            var borderAddedValue = 0;
            var scrollWidth = parseInt(isWebkit?10:17);

            switch (indexType){
                case 0:
                    tableWidth = tableWidth - (tableData.maxTopWidth.length+1)
                    break;
                case 1:
                    if(!viewBlock.tBodyScrolling){
                        borderAddedValue = (tableData.maxTopWidth.length - 2);
                    }
                    break;
                case 2:
                case 3:
                    if(!viewBlock.tBodyScrolling){
                        borderAddedValue = tableData.maxTopWidth.length;
                    }
                    break;
            }

            if(viewBlock.tBodyScrolling){
                if (tableWidth >= maxSumValue) {
                    setNotExceedingWidth(tableWidth,maxSumValue,0,borderAddedValue);
                } else {
                    setExceedWidth();
                }
            }else{
                if(currentTableHeight<=tableHeight){
                    if (tableWidth >= maxSumValue) {
                        setNotExceedingWidth(tableWidth,maxSumValue,0,borderAddedValue);
                    } else {
                        setExceedWidth();
                    }
                    tableData.isNotHiddenScroll = true;
                }else {
                    if ((tableWidth - maxSumValue) >= scrollWidth) {
                        setNotExceedingWidth(tableWidth,maxSumValue,scrollWidth,borderAddedValue);
                    } else {
                        setExceedWidth();
                    }
                }
            }
        }

        function sumWidth(arry){
            var sumArry = 0;
            for(var i= 0;i<arry.length;i++){
                sumArry += arry[i];
            }
            return sumArry;
        }

        function setNotExceedingWidth(tableWidth,maxSumValue,scrollWidth,borderAddedValue){
            var averageWidth = parseInt((tableWidth - maxSumValue - scrollWidth) / tableData.maxTopWidth.length);

            for (var i = 0; i < viewBlock.viewTableBody.viewTableRows.item(0).viewTableCells.count; i++) {
                if(viewBlock.viewTableBody.viewTableRows.item(0).viewTableCells.item(i).autoColumnWidth){
                    tableData.maxTopWidth[i] += averageWidth;
                }
            }

            var lastTd = tableWidth - sumWidth(tableData.maxTopWidth) - scrollWidth + borderAddedValue;

            for(var i = viewBlock.viewTableBody.viewTableRows.item(0).viewTableCells.count - 1; i >= 0; i--){
                if(viewBlock.viewTableBody.viewTableRows.item(0).viewTableCells.item(i).autoColumnWidth){
                    tableData.maxTopWidth[i] += lastTd;
                    break;
                }
            }

            for (var i = 0, len = tableData.fieldObjArry.length; i < len; i++) {
                tableData.fieldObjArry[i].width = tableData.maxTopWidth[i];
            }

            for (var i = 0, len = tableData.tableHead.length; i < len; i++) {
                for (var j = 0, jen = tableData.tableHead[i].length; j < jen; j++) {
                    if (tableData.tableHead[i][j].field) {
                        var field = tableData.tableHead[i][j].field;
                        for (var k = 0, ken = tableData.fieldObjArry.length; k < ken; k++) {
                            if (field == tableData.fieldObjArry[k].field) {
                                tableData.tableHead[i][j].width = tableData.fieldObjArry[k].width;
                            }
                        }
                    }
                }
            }
        }

        function setExceedWidth(){
            for (var i = 0, len = tableData.fieldObjArry.length; i < len; i++) {
                tableData.fieldObjArry[i].width = tableData.maxTopWidth[i];
            }

            for (var i = 0, len = tableData.tableHead.length; i < len; i++) {
                for (var j = 0, jen = tableData.tableHead[i].length; j < jen; j++) {
                    if (tableData.tableHead[i][j].field) {
                        var field = tableData.tableHead[i][j].field;
                        for (var k = 0, ken = tableData.fieldObjArry.length; k < ken; k++) {
                            if (field == tableData.fieldObjArry[k].field) {
                                tableData.tableHead[i][j].width = tableData.fieldObjArry[k].width;
                            }
                        }
                    }
                }
            }
        }

        function deleteTableCellWidth0(){
            for(var i = 0; i < tableData.tableHead.length; i++){
                for(var j = tableData.tableHead[i].length - 1; j >= 0; j--){
                    if(tableData.tableHead[i][j].width == 0){
                        tableData.tableHead[i].splice(j,1);
                    }
                }
            }
        }

        function setFrozenColumn(){
            var indexArr = [];
            var sumIndexArr = [];
            for(var i = 0; i < tableData.tableHead.length; i++){
                sumIndexArr.push(0);
            }
            var frozenColumns = [];
            for(var i = 0; i < tableData.tableHead.length; i++){
                var tempArr = [];
                var tempIndexArr = [];
                for(var j = 0; j < tableData.tableHead[i].length; j++){
                    if(sumIndexArr[i] < viewBlock.frozenColumnCount){
                        if(tableData.tableHead[i][j].colspan > 1){
                            sumIndexArr[i] += tableData.tableHead[i][j].colspan;
                            tempIndexArr.push(j);
                            tempArr.push(tableData.tableHead[i][j]);
                        }else if(tableData.tableHead[i][j].rowspan > 1){
                            for(var k = 0; k < tableData.tableHead[i][j].rowspan; k++){
                                sumIndexArr[k] += 1;
                            }
                            tempIndexArr.push(j);
                            tempArr.push(tableData.tableHead[i][j]);
                        }else{
                            sumIndexArr[i] += 1;
                            tempIndexArr.push(j);
                            tempArr.push(tableData.tableHead[i][j]); 
                        }
                    }
                }
                indexArr.push(tempIndexArr);
                frozenColumns.push(tempArr);
            }
            for(var i = 0; i < indexArr.length; i++){
                for(var j = indexArr[i].length-1; j >= 0; j--){
                    tableData.tableHead[i].splice(indexArr[i][j],1);
                }
            }
            tableData.frozenColumns = frozenColumns;
        }

        if(viewBlock.blockDataToDraw){
            $('.vertical-table').find('.datagrid-view2 .datagrid-header .datagrid-htable tr:last-child td').click(function(){
                if($(this).attr('field')){
                    if(!$(this).hasClass('datagrid-sort-desc')&&!$(this).hasClass('datagrid-sort-asc')){
                        queue = -1;
                        $('.vertical-table').find(".datagrid-view .datagrid-sort-desc").removeClass('datagrid-sort-desc');
                        $('.vertical-table').find(".datagrid-view .datagrid-sort-asc").removeClass('datagrid-sort-asc');
                        $(this).addClass('datagrid-sort-desc');
                    }else if($(this).hasClass('datagrid-sort-desc')){
                        queue = 1;
                        $(this).removeClass('datagrid-sort-desc').addClass('datagrid-sort-asc').siblings('td').removeClass('datagrid-sort-desc').removeClass('datagrid-sort-asc');
                    }else if($(this).hasClass('datagrid-sort-asc')){
                        queue = -1;
                        $(this).removeClass('datagrid-sort-asc').addClass('datagrid-sort-desc').siblings('td').removeClass('datagrid-sort-desc').removeClass('datagrid-sort-asc');
                    }
                    var sortBody = [];
                    $.extend(true,sortBody,tableData.sortArry);

                    var sortId = Number($(this).attr('field'));

                    sorter(sortBody,sortId);
                    $.extend(true,tableData.sortArry,sortBody);

                    for(var i = 0,len = tableData.footerData.length;i<len;i++){
                        sortBody.push(tableData.footerData[i]);
                    }
                    $.extend(true,tableData.tableBodyData,sortBody);

                    $(table).datagrid('load');
                    $(table).datagrid('loadData',sortBody);
                }
            });
        }

        function sorter(sortBody,sortId){
            if(queue > 0){
                sortBody.sort(arrSortMinToMax);
            }else{
                sortBody.sort(arrSortMaxToMin);
            }
            queue = -queue

            function arrSortMinToMax(a, b) {
                if(viewBlock.viewTableBody.viewTableRows.item(0).viewTableCells.item(sortId).cellObject[3] == 2){
                    var currentA = 0 , currentB = 0;
                    currentA = a[sortId] === ''? Number.NEGATIVE_INFINITY : a[sortId];
                    currentB = b[sortId] === ''? Number.NEGATIVE_INFINITY : b[sortId];
                    return $Utils.reverseFormatting(currentA) - $Utils.reverseFormatting(currentB);
                }else if(viewBlock.viewTableBody.viewTableRows.item(0).viewTableCells.item(sortId).cellObject[3] == 1){
                    a[sortId] = a[sortId] || '';
                    b[sortId] = b[sortId] || '';
                    return new Date(a[sortId] || 0).getTime() - new Date(b[sortId] || 0).getTime();
                }else{
                    // 判断是否为数字开始; 为啥要判断?看上图源数据
                    if (Number($Utils.reverseFormatting(a[sortId])) && Number($Utils.reverseFormatting(b[sortId]))) {
                        // 提取起始数字, 然后比较返回
                        return $Utils.reverseFormatting(a[sortId]) - $Utils.reverseFormatting(b[sortId]);
                        // 如包含中文, 按照中文拼音排序
                    } else if (isChinese(a[sortId]) && isChinese(b[sortId])) {
                        // 按照中文拼音, 比较字符串
                        return a[sortId].localeCompare(b[sortId], 'zh-CN')
                    } else {
                        // 排序数字和字母
                        return a[sortId].localeCompare(b[sortId], 'en');
                    }
                }
            }

            function arrSortMaxToMin(a,b){
                if(viewBlock.viewTableBody.viewTableRows.item(0).viewTableCells.item(sortId).cellObject[3] == 2){
                    var currentA = 0 , currentB = 0;
                    currentA = a[sortId] === ''? Number.NEGATIVE_INFINITY : a[sortId];
                    currentB = b[sortId] === ''? Number.NEGATIVE_INFINITY : b[sortId];
                    return $Utils.reverseFormatting(currentB) - $Utils.reverseFormatting(currentA);
                }else if(viewBlock.viewTableBody.viewTableRows.item(0).viewTableCells.item(sortId).cellObject[3] == 1){
                    a[sortId] = a[sortId] || '';
                    b[sortId] = b[sortId] || '';
                    return new Date(b[sortId] || 0).getTime() - new Date(a[sortId] || 0).getTime();
                }else{
                    // 判断是否为数字开始; 为啥要判断?看上图源数据
                    if (Number($Utils.reverseFormatting(a[sortId])) && Number($Utils.reverseFormatting(b[sortId]))) {
                        // 提取起始数字, 然后比较返回
                        return $Utils.reverseFormatting(b[sortId]) - $Utils.reverseFormatting(a[sortId]);
                        // 如包含中文, 按照中文拼音排序
                    } else if (isChinese(a[sortId]) && isChinese(b[sortId])) {
                        // 按照中文拼音, 比较字符串
                        //return a[sortId].localeCompare(b[sortId], 'zh-CN');
                        return b[sortId].localeCompare(a[sortId], 'zh-CN');
                    } else {
                        // 排序数字和字母
                        return b[sortId].localeCompare(a[sortId], 'en');
                    }
                }

            }
        }
        // 检测是否为中文，true表示是中文，false表示非中文
        function isChinese(str) {
            // 中文万国码正则
            if (/[\u4E00-\u9FCC\u3400-\u4DB5\uFA0E\uFA0F\uFA11\uFA13\uFA14\uFA1F\uFA21\uFA23\uFA24\uFA27-\uFA29]|[\ud840-\ud868][\udc00-\udfff]|\ud869[\udc00-\uded6\udf00-\udfff]|[\ud86a-\ud86c][\udc00-\udfff]|\ud86d[\udc00-\udf34\udf40-\udfff]|\ud86e[\udc00-\udc1d]/.test(str)) {
                return true;
            } else {
                return false;
            }
        }

        function clickTrBackground(){
            if(!$('.vertical-table').parents().hasClass("drill-page")){
                $('.vertical-table').find('.datagrid-view .datagrid-body tr').click(function(){
                    if(!$(this).hasClass("add-background-color")){
                        var rowIndex = $(this).attr("datagrid-row-index");
                        $('.vertical-table').find('.datagrid-view .datagrid-body').each(function(){
                            $(this).find("tr").each(function(){
                                if(rowIndex == $(this).attr("datagrid-row-index")){
                                    $(this).addClass("add-background-color").css({
                                        "background-color": "rgba("+int2hex(viewBlock.tableStyleColor,1)+",.2)"
                                    });
                                    $(this).siblings("tr").removeClass("add-background-color").css("background-color","transparent");
                                    $(this).siblings("tr.datagrid-row-alt").css("background-color","rgba("+int2hex(viewBlock.tableStyleColor,2)+",.1)");
                                }
                            });
                        });

                        
                    }
                });
            }
        }

        function mergeTDForBody(self,mergeRows){
            /*表体合并行*/
            for(var i=0,len=mergeRows.length;i<len;i++){
                for(var j= 0,jen=mergeRows[i].length;j<jen;j++){
                    if(mergeRows[i][j].rowspan > 1){
                        $(self).datagrid('mergeCells',{
                            index: mergeRows[i][j].row,
                            field: mergeRows[i][j].col,
                            rowspan: mergeRows[i][j].rowspan,
                            colspan: null
                        });
                    }

                }
            }
        }

        function mergeTDForFoot(self){
            /*表尾合并*/
            if(viewBlock.pagingDisplay && (tableData.currentPage * tableData.pageSizeNum) >= tableData.sum){
                var currentIndex = null;
                $('.vertical-table').find('.datagrid-view .datagrid-body .datagrid-btable tr').each(function(){
                    if((Number($(this).attr("datagrid-row-index")) + (tableData.currentPage - 1)*tableData.pageSizeNum) >= tableData.sum){
                        currentIndex = Number($(this).attr("datagrid-row-index"));
                        return false;
                    }
                });
                if(currentIndex != null){
                    for(var i=0;i<viewBlock.viewTableBody.viewTableRows.item(0).viewTableCells.count;i++){
                        for(var j=0;j<tableData.footerData.length;j++){
                            $(self).datagrid('mergeCells',{
                                index: currentIndex+j,
                                field: viewBlock.viewTableBody.viewTableRows.item(0).viewTableCells.item(i).columnIndex,
                                colspan: viewBlock.viewTableFoot.viewTableRows.item(j).viewTableCells.item(i).colspan,
                                rowspan: viewBlock.viewTableFoot.viewTableRows.item(j).viewTableCells.item(i).rowspan
                            });
                        }
                    }
                }
            }else{
                for(var i=0;i<viewBlock.viewTableBody.viewTableRows.item(0).viewTableCells.count;i++){
                    for(var j=0;j<tableData.footerData.length;j++){
                        $(self).datagrid('mergeCells',{
                            index: tableData.sum+j,
                            field: viewBlock.viewTableBody.viewTableRows.item(0).viewTableCells.item(i).columnIndex,
                            colspan: viewBlock.viewTableFoot.viewTableRows.item(j).viewTableCells.item(i).colspan,
                            rowspan: viewBlock.viewTableFoot.viewTableRows.item(j).viewTableCells.item(i).rowspan
                        });
                    }
                }
            }
        }

        function setStyle(){
            if(viewBlock.tableStyleColor){
                $('.vertical-table').find(".datagrid-view td").css({
                    "border-color": "rgba("+int2hex(viewBlock.tableStyleColor,2)+",.3)"
                });
            }

            $('.vertical-table').find(".datagrid-wrap").css({
                "height": $('.vertical-table').height() +"px"
            }).find(".datagrid-view").css({
                "height": ($('.vertical-table').height()-(viewBlock.pagingDisplay?35:0)) +"px"
            });

            $('.vertical-table').find(".datagrid-view .datagrid-header table.datagrid-htable tr").css({
                "height": viewBlock.headHeight+"px"
            });
            $('.vertical-table').find(".datagrid-view .datagrid-body table.datagrid-btable tr").css({
                "height": viewBlock.bodyHeight+"px"
            });
            $('.vertical-table').find(".datagrid-view .datagrid-header table.datagrid-htable tr td").css({
                "height": viewBlock.headHeight+"px"
            });
            $('.vertical-table').find(".datagrid-view .datagrid-header table.datagrid-htable tr td div").css({
                "height": viewBlock.headHeight>0?'auto':(viewBlock.headHeight+"px")
            });
            $('.vertical-table').find(".datagrid-view .datagrid-body table.datagrid-btable tr td").css({
                "height": viewBlock.bodyHeight+"px"
            });
            $('.vertical-table').find(".datagrid-view .datagrid-body table.datagrid-btable tr td div").css({
                "height": viewBlock.bodyHeight>0?'auto':(viewBlock.bodyHeight+"px")
            });
            if(viewBlock.rowMarginBottom){
                $('.vertical-table').find("tr").css({
                    "height": "auto",
                    "display": "block",
                    "margin-bottom": viewBlock.rowMarginBottom
                });
                $('.vertical-table').find(".datagrid-header").css("margin-bottom",viewBlock.rowMarginBottom);
                $('.vertical-table').find("tr td:first-child").css("border-radius","3px 0 0 3px");
                $('.vertical-table').find("tr td:last-child").css("border-radius","0 3px 3px 0");
            }
            /*表头行高*/
            if(viewBlock.wordWrap){
                $('.vertical-table').find(".datagrid-header table.datagrid-htable td").css({
                    'padding': '5px 0'
                }).find("span").css({
                    'white-space': 'normal',
                    'word-break': 'break-all'
                });
            }
            $('.vertical-table').find("table.datagrid-htable").css({
                "height": viewBlock.headHeight*viewBlock.viewTableHead.viewTableRows.count+"px"
            });

            $('.vertical-table').find(".datagrid-header").css({
                "height":  viewBlock.headHeight*viewBlock.viewTableHead.viewTableRows.count+"px"
            });
            
            if(viewBlock.bodyHeight == 0 && viewBlock.footHeight == 0 || viewBlock.bodyHeight == 0 && viewBlock.viewTableFoot.viewTableRows.count == 0){
                $('.vertical-table').find(".datagrid-body").css({
                    "height": 0
                });
            }else{
                $('.vertical-table').find(".datagrid-body").css({
                    "height": ($('.vertical-table').height()-(viewBlock.pagingDisplay?35:0)) - viewBlock.headHeight*viewBlock.viewTableHead.viewTableRows.count +"px"
                });
            }

            if(viewBlock.headHeight == 0 && viewBlock.bodyHeight == 0 && viewBlock.footHeight == 0){
                $('.vertical-table').find(".datagrid-pager").css("display","none");
            }

            if(viewBlock.frozenColumnCount){
                $('.vertical-table').find('.datagrid-view1 .datagrid-header-row').each(function(i){
                    $(this).find('td').each(function(j){
                        $(this).css(tableData.tableHeadStyle[i][j]).find("div").css(tableData.tableHeadDivStyle[i][j]);
                        
                        if($(this).find("a").length){
                            $(this).find("div").css({
                                'text-decoration': 'underline'
                            }).find("a").css({
                                'color': $Utils.csharp2rgba(tableData.tableHeadStyle[i][j].color)
                            })
                        }
                    });
                });
                $('.vertical-table').find('.datagrid-view2 .datagrid-header-row').each(function(i){
                    $(this).find('td').each(function(j){
                        $(this).css(tableData.tableHeadStyle[i][j+viewBlock.frozenColumnCount]).find("div").css(tableData.tableHeadDivStyle[i][j+viewBlock.frozenColumnCount]);
                        
                        if($(this).find("a").length){
                            $(this).find("div").css({
                                'text-decoration': 'underline'
                            }).find("a").css({
                                'color': $Utils.csharp2rgba(tableData.tableHeadStyle[i][j+viewBlock.frozenColumnCount].color)
                            })
                        }
                    });
                });
            }else{
                $('.vertical-table').find('.datagrid-header-row').each(function(i){
                    $(this).find('td').each(function(j){
                        $(this).css(tableData.tableHeadStyle[i][j]).find("div").css(tableData.tableHeadDivStyle[i][j]);
                        
                        if($(this).find("a").length){
                            $(this).find("div").css({
                                'text-decoration': 'underline'
                            }).find("a").css({
                                'color': $Utils.csharp2rgba(tableData.tableHeadStyle[i][j].color)
                            })
                        }
                    });
                });
                // $('.vertical-table').find('.datagrid-header-row td').each(function(i){
                //     $(this).css(tableData.tableHeadStyle[i]).find("div").css(tableData.tableHeadDivStyle[i]);
                // });
            }

            /*表体样式设置*/
            $('.vertical-table').find('tr.datagrid-row td').each(function(){
                var tdField = parseFloat($(this).attr('field'));
                var rowspan = parseFloat($(this).attr('rowspan'));
                var tBodyCell = viewBlock.viewTableBody.viewTableRows.item(0).viewTableCells.item(tdField);

                if(rowspan>1 && tBodyCell.cellTextBox.backgroundColor == ''){
                    $(this).css('background-color','#ffffff');
                }else{
                    $(this).css('background-color',$Utils.csharp2rgba(tBodyCell.cellTextBox.backgroundColor));
                }

                $(this).css({
                    'color': $Utils.csharp2rgba(tBodyCell.cellTextBox.color),
                    'font-family': tBodyCell.cellTextBox.font.fontFamily,
                    'font-style': tBodyCell.cellTextBox.font.italic?'italic':'normal',
                    'font-weight': tBodyCell.cellTextBox.font.bold?'bold':'normal'
                }).find('div').css({
                    'font-size': tBodyCell.cellTextBox.font.size+"px",
                    verticalAlign: tBodyCell.cellTextBox.verticalAlign=='0'?'top':(tBodyCell.cellTextBox.verticalAlign=='1'?'middle':'bottom'),
                    textAlign: tBodyCell.cellTextBox.textAlign=='0'?'left':(tBodyCell.cellTextBox.textAlign=='1'?'center':'right'),
                    'text-decoration': tBodyCell.cellTextBox.font.underline?'underline':
                        (tBodyCell.cellTextBox.font.strikeout?'line-through':'none')
                });

                if($(this).find("a").length){
                    $(this).find("div").css({
                        'text-decoration': 'underline'
                    }).find("a").css({
                        'color': $Utils.csharp2rgba(tBodyCell.cellTextBox.color)
                    })
                }

                if(viewBlock.wordWrap){
                    $(this).css({
                        'padding': '5px 0'
                    }).find('div').css({
                        'white-space': 'normal',
                        'word-break': 'break-all'
                    });
                }
            });

            /*表尾样式设置*/
            if(viewBlock.pagingDisplay && (tableData.currentPage * tableData.pageSizeNum) >= tableData.sum){
                $('.vertical-table').find('.datagrid-view .datagrid-body .datagrid-btable tr').each(function(){
                    if((Number($(this).attr("datagrid-row-index")) + (tableData.currentPage - 1)*tableData.pageSizeNum) >= tableData.sum){
                        var j = (Number($(this).attr("datagrid-row-index")) + (tableData.currentPage - 1)*tableData.pageSizeNum) - tableData.sum;
                        $(this).css("height",viewBlock.footHeight+"px");
                        $(this).find("td").each(function(){
                            var k = Number($(this).attr("field"));
                            var tFootCell = viewBlock.viewTableFoot.viewTableRows.item(j).viewTableCells.item(k);
                            $(this).css({
                                'height': viewBlock.footHeight+"px",
                                'background-color': $Utils.csharp2rgba(tFootCell.cellTextBox.backgroundColor),
                                'font-family': tFootCell.cellTextBox.font.fontFamily,
                                'font-size': tFootCell.cellTextBox.font.size+"px",
                                'font-style': tFootCell.cellTextBox.font.italic?'italic':'normal',
                                'font-weight': tFootCell.cellTextBox.font.bold?'bold':'normal',
                                color: $Utils.csharp2rgba(tFootCell.cellTextBox.color)
                            }).find('div').css({
                                'height': viewBlock.footHeight>0?'auto':(viewBlock.footHeight+"px"),
                                'textAlign': tFootCell.cellTextBox.textAlign=='0'?'left':(tFootCell.cellTextBox.textAlign=='1'?'center':'right'),
                                'verticalAlign': tFootCell.cellTextBox.verticalAlign=='0'?'top':(tFootCell.cellTextBox.verticalAlign=='1'?'middle':'bottom'),
                                'text-decoration': tFootCell.cellTextBox.font.underline?'underline':
                                    (tFootCell.cellTextBox.font.strikeout?'line-through':'none')
                            });
                            
                            if($(this).find("a").length){
                                $(this).find("div").css({
                                    'text-decoration': 'underline'
                                })
                            }
                        });
                    }
                });
            }else{
                var j=0;
                for(var i=tableData.sum;i<tableData.tableBodyData.length;i++){
                    $('.vertical-table').find('tr[datagrid-row-index='+i+']').css("height",viewBlock.footHeight+"px");
                    $('.vertical-table').find('tr[datagrid-row-index='+i+']').find('td').each(function(k){
                        var tFootCell = viewBlock.viewTableFoot.viewTableRows.item(j).viewTableCells.item(k);
                        $(this).css({
                            'height': viewBlock.footHeight+"px",
                            'background-color': $Utils.csharp2rgba(tFootCell.cellTextBox.backgroundColor),
                            'font-family': tFootCell.cellTextBox.font.fontFamily,
                            'font-size': tFootCell.cellTextBox.font.size+"px",
                            'font-style': tFootCell.cellTextBox.font.italic?'italic':'normal',
                            'font-weight': tFootCell.cellTextBox.font.bold?'bold':'normal',
                            color: $Utils.csharp2rgba(tFootCell.cellTextBox.color)
                        }).find('div').css({
                            'height': viewBlock.footHeight>0?'auto':(viewBlock.footHeight+"px"),
                            'textAlign': tFootCell.cellTextBox.textAlign=='0'?'left':(tFootCell.cellTextBox.textAlign=='1'?'center':'right'),
                            'verticalAlign': tFootCell.cellTextBox.verticalAlign=='0'?'top':(tFootCell.cellTextBox.verticalAlign=='1'?'middle':'bottom'),
                            'text-decoration': tFootCell.cellTextBox.font.underline?'underline':
                                (tFootCell.cellTextBox.font.strikeout?'line-through':'none')
                        });
                        
                        if($(this).find("a").length){
                            $(this).find("div").css({
                                'text-decoration': 'underline'
                            })
                        }
                    });
                    j++;
                }
            }
        
        }

        function setBorderType(type){
            switch (type){
                case 0:
                    if(viewBlock.tableStyleColor){
                        $('.vertical-table').find("tr.datagrid-row-alt").css({
                            "background-color": "rgba("+int2hex(viewBlock.tableStyleColor,2)+",.1)"
                        });
                    }
                    break;
                case 1:
                    $('.vertical-table').find("tr.datagrid-header-row").each(function(){
                        var me = this;
                        $(this).find("td").each(function(i){
                            if(i!=($(me).find("td").length-1)){
                                $(this).css({
                                    "border-right": 0
                                });
                            }
                        })
                    });
                    $('.vertical-table').find("tr.datagrid-row").each(function(){
                        var me = this;
                        $(this).find("td").each(function(i){
                            if(i!=($(me).find("td").length-1)){
                                $(this).css({
                                    "border-right": 0
                                });
                            }
                        })
                    });
                    if(viewBlock.tableStyleColor){
                        $('.vertical-table').find("tr.datagrid-row-alt").css({
                            "background-color": "rgba("+int2hex(viewBlock.tableStyleColor,2)+",.1)"
                        });
                    }
                    break;
                case 2:
                    $('.vertical-table').find(".datagrid-view .datagrid-header-inner").each(function(){
                        var self = this;
                        $(this).find("tr.datagrid-header-row").each(function(i){
                            if(i!=($(self).find("tr.datagrid-header-row").length-1)){
                                $(this).find("td").css({
                                    "border-bottom": 0
                                });
                            }
                            $(this).find("td").css({
                                "border-left": 0,
                                "border-right": 0
                            });
                        });
                    });
                    $('.vertical-table').find(".datagrid-view .datagrid-body").each(function(){
                        var self = this;
                        $(this).find("tr.datagrid-row").each(function(i){
                            if(i!=($(self).find("tr.datagrid-row").length-1)){
                                $(this).find("td").css({
                                    "border-bottom": 0
                                });
                            }
                            $(this).find("td").css({
                                "border-left": 0,
                                "border-right": 0
                            });
                        });
                    });
                    break;
                case 3:
                    $('.vertical-table').find(".datagrid-view .datagrid-header-inner").each(function(){
                        var self = this;
                        $(this).find("tr.datagrid-header-row").each(function(i){
                            $(this).find("td").css({
                                "border-left": 0,
                                "border-right": 0,
                                "border-top": 0
                            });
                            if(i!=($(self).find("tr.datagrid-header-row").length-1)){
                                $(this).find("td").css({
                                    "border-bottom": 0
                                });
                            }
                        });
                    });

                    $('.vertical-table').find("tr.datagrid-row").each(function(i){
                        $(this).find("td").css({
                            "border-left": 0,
                            "border-right": 0,
                            "border-bottom": 0
                        });
                    });
                    break;
            }
        }

        function addSpanBox(){
            var bodyTable = viewBlock.viewTableBody;
            var measureIndexArray = [];
            for(var i= 0,len=bodyTable.viewTableRows.item(0).viewTableCells.count;i<len;i++){
                if(bodyTable.viewTableRows.item(0).viewTableCells.item(i).cellObject[2] == 1){
                    measureIndexArray.push(bodyTable.viewTableRows.item(0).viewTableCells.item(i).columnIndex);
                }
            }

            for(var i= 0,len=measureIndexArray.length;i<len;i++){
                $('.vertical-table').find('.datagrid-view .datagrid-body .datagrid-btable td[field='+measureIndexArray[i]+']').append('<span></span>');
            }

            
            $('.vertical-table').find('.datagrid-view .datagrid-body .datagrid-btable tr').each(function(){
                var rowIndex = Number($(this).attr("datagrid-row-index"));
                if(viewBlock.pagingDisplay){
                    if((Number(rowIndex) + (tableData.currentPage - 1) * tableData.pageSizeNum) >= tableData.sum){
                        $(this).find("span").remove();
                    }
                }else{
                    if(Number(rowIndex) >= tableData.sum){
                        $(this).find("span").remove();
                    }
                }
            });

            return measureIndexArray;
        }

        function setSpanStyle(maxValueArray, measureIndexArray){
            for(var i= 0,len=measureIndexArray.length;i<len;i++){
                $('.vertical-table').find('.datagrid-view .datagrid-body .datagrid-btable tr').each(function(){
                    var cells = viewBlock.viewTableBody.viewTableRows.item(0).viewTableCells;
                    if (cells.item(measureIndexArray[i]).showColumnBarForMeasure){
                        var currentValue = $Utils.reverseFormatting($(this).find('td[field='+measureIndexArray[i]+']').text() || 0);
                        var currentDivHeight = $(this).find('td[field='+measureIndexArray[i]+'] div').height();
                        $(this).find('td[field='+measureIndexArray[i]+'] span').css({
                            'width': (Math.abs(currentValue)/maxValueArray[i]) * cells.item(measureIndexArray[i]).columnBarMaxLength * 100 + '%',
                            'background-color': currentValue>=0 ? $Utils.csharp2rgba(cells.item(measureIndexArray[i]).positiveColumnBarColor) :$Utils.csharp2rgba(cells.item(measureIndexArray[i]).negativeColumnBarColor),
                            'height': currentDivHeight * 0.8 + "px"
                        });
                    }
                });
            }
        }

        function hideCellBorder(){
            var tableBodyCellLength = viewBlock.viewTableBody.viewTableRows.item(0).viewTableCells.count;
            var tableBodyTrLength = $('.vertical-table').find('.datagrid-view .datagrid-body .datagrid-btable tr').length;
            var mergeColumn = [],mergeColumnLast = [];

            for(var i=tableBodyCellLength-1;i>=0;i--){
                for(var j=0;j<tableBodyTrLength;j++){
                    var rowspan = $('.vertical-table').find('.datagrid-view .datagrid-body .datagrid-btable tr').eq(j).find('td').eq(i).attr('rowspan');
                    if(rowspan){
                        var obj = {};

                        obj.field = i;
                        obj.index = j;
                        obj.rowspan = parseFloat(rowspan);
                        mergeColumn.push(obj);
                    }
                }
                if(mergeColumn.length){ break;}
                mergeColumnLast.push(i);
            }

            for(var i= 0,len=mergeColumnLast.length;i<len;i++){
                for(var m= 0,men=mergeColumn.length;m<men;m++){
                    for(var n= mergeColumn[m].index;n<(mergeColumn[m].rowspan+mergeColumn[m].index-1);n++){
                        $('.vertical-table').find('.datagrid-view .datagrid-body .datagrid-btable tr').eq(n).find('td').eq(mergeColumnLast[i]).css('border-bottom',0);
                    }
                }
            }
        }

        function setTableWarnings(){
            var rowIndex = 0;
            if(viewBlock.pagingDisplay){
                rowIndex = tableData.pageSizeNum * (tableData.currentPage - 1);
            }
            for(var i = 0; i < tableData.tableWarnings.length; i++){
                for(var j = 0; j < viewBlock.viewTableBody.viewTableRows.item(0).viewTableCells.count; j++){
                    var viewTableCell = viewBlock.viewTableBody.viewTableRows.item(0).viewTableCells.item(j);
                    if(tableData.tableWarnings[i].objectName == (viewTableCell.cellObject[0]+"___"+viewTableCell.cellObject[1])){
                        $('.vertical-table').find(".datagrid-view .datagrid-body").each(function(){
                            $(this).find(".datagrid-btable tr").each(function(){
                                var tdText = $(this).find("td[field="+viewTableCell.columnIndex+"]").text();
                                var warningStyle = getWarningStyle(tdText,tableData.tableWarnings[i].warnings,(rowIndex + Number($(this).attr("datagrid-row-index"))));
                                if(warningStyle.length){
                                    if(warningStyle[warningStyle.length - 1].effectType == 0){
                                        $(this).find("td[field="+viewTableCell.columnIndex+"]").css({
                                            "color": warningStyle[warningStyle.length - 1].color,
                                            "background-color": warningStyle[warningStyle.length - 1].BackgroundColor
                                        });
                                    }else{
                                        $(this).find("td").css({
                                            "color": warningStyle[warningStyle.length - 1].color,
                                            "background-color": warningStyle[warningStyle.length - 1].BackgroundColor
                                        });
                                    }
                                }
                            });
                        });
                    }
                }
            }
        }

        function getWarningStyle(compareValue,warnings,rowIndex){
            var styleArr = [];
            for(var i = 0; i < warnings.length; i++){
                if(warnings[i].dataType == 2){
                    if(warnings[i].compareValueType){
                        setCaseStyle(warnings[i].operation,$Utils.reverseFormatting(compareValue),$Utils.reverseFormatting(tableData.tableBodyData[rowIndex][warnings[i].compareObjectField]),warnings[i],styleArr);
                    }else{
                        setCaseStyle(warnings[i].operation,$Utils.reverseFormatting(compareValue),$Utils.reverseFormatting(warnings[i].compareConstants[0]),warnings[i],styleArr);
                    }
                }
                if(warnings[i].dataType == 1){
                    if(warnings[i].compareValueType){
                        setCaseStyle(warnings[i].operation,new Date(compareValue).getTime(),new Date(tableData.tableBodyData[rowIndex][warnings[i].compareObjectField]).getTime(),warnings[i],styleArr);
                    }else{
                        setCaseStyle(warnings[i].operation,new Date(compareValue).getTime(),new Date(Number(warnings[i].compareConstants[0])).getTime(),warnings[i],styleArr);
                    }
                }
                if(warnings[i].dataType == 0){
                    if(warnings[i].compareValueType){
                        setCaseStyle(warnings[i].operation,compareValue,tableData.tableBodyData[rowIndex][warnings[i].compareObjectField],warnings[i],styleArr);
                    }else{
                        setCaseStyle(warnings[i].operation,compareValue,warnings[i].compareConstants[0],warnings[i],styleArr);
                    }
                }
            }
            return styleArr;
        }

        function setCaseStyle(operation,compareValue,warningValue,warnings,styleArr){
            switch(operation){
                case 0:
                    if(compareValue == warningValue){
                        return setWarningStyle(warnings,styleArr);
                    }
                    break;
                case 1:
                    if(compareValue != warningValue){
                        return setWarningStyle(warnings,styleArr);
                    }
                    break;
                case 2:
                    if(compareValue > warningValue){
                        return setWarningStyle(warnings,styleArr);
                    }
                    break;
                case 3:
                    if(compareValue >= warningValue){
                        return setWarningStyle(warnings,styleArr);
                    }
                    break;
                case 4:
                    if(compareValue < warningValue){
                        return setWarningStyle(warnings,styleArr);
                    }
                    break;
                case 5:
                    if(compareValue <= warningValue){
                        return setWarningStyle(warnings,styleArr);
                    }
                    break;
                case 6:
                    if(warnings.compareConstants.indexOf(compareValue+'')!=-1){
                        return setWarningStyle(warnings,styleArr);
                    }
                    break;
                case 7:
                    if(warnings.compareConstants.indexOf(compareValue+'')==-1){
                        return setWarningStyle(warnings,styleArr);
                    }
                    break;
            }

        }

        function setWarningStyle(warnings,styleArr){
            var obj = {};
            obj.color = $Utils.csharp2rgba(warnings.color);
            obj.BackgroundColor = $Utils.csharp2rgba(warnings.backgroundColor);
            obj.effectType = warnings.effectType;
            styleArr.push(obj);
            return styleArr;
        }

        function tBodyScroll(speed){
            var speed=speed/30;
            var originalBox = $('.vertical-table').find('.datagrid-view .datagrid-body .datagrid-btable');
            var originalBoxHtml = originalBox.html();
            originalBox.html(originalBoxHtml+originalBoxHtml);
            var timeId = null;

            var originalBoxHeight = originalBox.height();
            $('.vertical-table').find('.datagrid-view .datagrid-body').css('position','relative');
            originalBox.css('position','absolute');
            var scrollTop = -1;

            function slider(){
                if(originalBox.css('top')==(-parseInt(originalBoxHeight/2)+'px')){
                    originalBox.css('top','0px');
                    scrollTop = -1;
                }
                originalBox.css('top',scrollTop);
                scrollTop--;
            }

            // setInterval()函数的作用是：每隔一段时间，执行该函数里的代码
            clearInterval(timeId);
            timeId = null;
            timeId = setInterval(slider,speed);

            $('.vertical-table').find('.datagrid-view .datagrid-body').mouseover(function(){
                // clearInterval()函数的作用是用来清除定时器
                clearInterval(timeId);
                timeId = null;
            });

            $('.vertical-table').find('.datagrid-view .datagrid-body').mouseout(function(){
                timeId = setInterval(slider,speed);
            });
        }

        function int2hex(rgbInt,isTrue) {
            var red = (rgbInt >> 16) & 255;
            var green = (rgbInt >> 8) & 255;
            var blue = rgbInt & 255;
            if(isTrue){
                isTrue == 1 ? ((red - 48 >= 0)?(red = red - 48):0):((red + 24 > 255)?255:(red = red + 24));
                isTrue == 1 ? ((green - 48 >= 0)?(green = green - 48):0):((green + 24 > 255)?255:(green = green + 24));
                isTrue == 1 ? ((blue - 48 >= 0)?(blue = blue - 48):0):((blue + 24 > 255)?255:(blue = blue + 24));
            }
            return red+","+green+","+blue;
        }

        function addSpanToHeadCell(){
            $('.vertical-table .datagrid-view .datagrid-htable tr td').each(function(){
                $(this).append("<span class='drop drop-left'></span><span class='drop drop-middle'></span><span class='drop drop-right'></span>");
            });
        }
    }

    $(".data-objects ul").on("dragstart", "li", function(e) {
        var dragObjectID = $(this).attr("data-objectid");
        e.originalEvent.dataTransfer.setData("dragID",dragObjectID);
        var count = 0;
        $(".vertical-table").off("dragenter").on("dragenter", ".datagrid-htable td", function(e) {
            count++;
            if(!$(this).hasClass("drag-now")){
                $(this).addClass("drag-now").siblings("td").removeClass("drag-now");
            }
            if($(e.target).hasClass("drop")){
                $(e.target).addClass("drop-now").siblings().removeClass("drop-now");
            }
        });

        $(".vertical-table").off("dragover").on("dragover", ".datagrid-htable td", function(e) {
            e.preventDefault();
        });

        $(".vertical-table").off("dragleave").on("dragleave", ".datagrid-htable td", function(e) {
            e.stopPropagation();
            e.preventDefault();
            if($(e.target).hasClass("drop-now")){
                $(e.target).removeClass("drag-now");
            }
            count--;
            if(count==0){
                $(this).removeClass("drag-now");
            }
        });

        $(".vertical-table").off("drop").on("drop", ".datagrid-htable td span.drop", function(e) {
            if($(this).parent("td").hasClass("drag-now")){
                var dropField = Number($(this).parent("td").attr("field"));
                var index = 0;
                if($(this).hasClass("drop-left")){
                    index = 0;
                }
                if($(this).hasClass("drop-middle")){
                    index = 1;
                }
                if($(this).hasClass("drop-right")){
                    index = 2;
                }
                setTableCell(e.originalEvent.dataTransfer.getData("dragID"),dropField,index);
            }
            $(".vertical-table .datagrid-htable td").removeClass("drag-now");
        });
    });

    function setTableCell(dragObjectID,dropField,index){
        var dataObject = null;
        for(var i = 0; i < dataObjects.reportDesign.dataObjects.length; i++){
            var tempDataObject = dataObjects.reportDesign.dataObjects[i];
            if(tempDataObject.objectID == dragObjectID){
                dataObject = tempDataObject;
            }
        }
        if(index != 1){
            addCell(dataObject,dropField,index);
        }
        if(index == 1){
            replaceCell(dataObject,dropField,index);
        }
        setBlockData();
    }

    function addCell(dataObject,dropField,index){
        var tempIndex = index==0?dropField:(dropField+1);
        var currentBlock = reportView.viewBlocks.item(0);
        var tempHeadCell = currentBlock.viewTableHead.viewTableRows.item(currentBlock.viewTableHead.viewTableRows.count-1).viewTableCells.item(dropField);
        var tableHeadCell = $.extend(true,{},tempHeadCell);
        tableHeadCell.text = dataObject.objectName;
        var finalHeadCell = new TableCell();
        finalHeadCell.init(tableHeadCell);
        var tempBodyCell = currentBlock.viewTableBody.viewTableRows.item(0).viewTableCells.item(dropField);
        var tableBodyCell = $.extend(true,{},tempBodyCell);
        tableBodyCell.cellObject[0] = dataObject.sourceName;
        tableBodyCell.cellObject[1] = dataObject.objectName;
        tableBodyCell.cellObject[2] = dataObject.objectType;
        tableBodyCell.cellObject[3] = dataObject.dataType;
        tableBodyCell.text = "["+dataObject.sourceName+"].["+dataObject.objectName+"]";
        tableBodyCell.formatString = dataObject.formatString;
        tableBodyCell.showColumnBarForMeasure = false;
        var finalBodyCell = new TableCell();
        finalBodyCell.init(tableBodyCell);
        currentBlock.viewTableHead.viewTableRows.item(currentBlock.viewTableHead.viewTableRows.count-1).viewTableCells.positionAdd(tempIndex,finalHeadCell);
        currentBlock.viewTableBody.viewTableRows.item(0).viewTableCells.positionAdd(tempIndex,finalBodyCell);
    }

    function replaceCell(dataObject,dropField,index){
        var currentBlock = reportView.viewBlocks.item(0);
        currentBlock.viewTableHead.viewTableRows.item(currentBlock.viewTableHead.viewTableRows.count-1).viewTableCells.item(dropField).text = dataObject.objectName;
        currentBlock.viewTableBody.viewTableRows.item(0).viewTableCells.item(dropField).cellObject[0] = dataObject.sourceName;
        currentBlock.viewTableBody.viewTableRows.item(0).viewTableCells.item(dropField).cellObject[1] = dataObject.objectName;
        currentBlock.viewTableBody.viewTableRows.item(0).viewTableCells.item(dropField).cellObject[2] = dataObject.objectType;
        currentBlock.viewTableBody.viewTableRows.item(0).viewTableCells.item(dropField).cellObject[3] = dataObject.dataType;
        currentBlock.viewTableBody.viewTableRows.item(0).viewTableCells.item(dropField).text = "["+dataObject.sourceName+"].["+dataObject.objectName+"]";
        currentBlock.viewTableBody.viewTableRows.item(0).viewTableCells.item(dropField).formatString = dataObject.formatString;
        currentBlock.viewTableBody.viewTableRows.item(0).viewTableCells.item(dropField).showColumnBarForMeasure = false;
    }

    function setBlockData(){
        var tempArr = $.extend(true,[],queryDatas);
        var showData = setData(tempArr);
        reportView.viewBlocks.item(0).blockData = showData;
        reportView.viewBlocks.item(0).blockDataToDraw = showData;
        createRightTable();
    }

    function setData(queryData){
        var curTableBlock = reportView.viewBlocks.item(0);
        var dimensionObj = {};
        var dimensionStr = "";
        var dimensionValueStr = "";
        var measureObj = {};
        var measureStr = "";
        var queryName = dataObjects.reportDesign.queries[0].queryName + "___";
        for(var i = 0; i< curTableBlock.viewTableBody.viewTableRows.item(0).viewTableCells.count; i++){
            var tableCell = curTableBlock.viewTableBody.viewTableRows.item(0).viewTableCells.item(i);
            if(tableCell.cellObject[2] == 0){
                dimensionObj[tableCell.cellObject[1]] = "$." + tableCell.cellObject[1];
                if(dimensionStr == ""){
                    dimensionStr = tableCell.cellObject[1] + ":$."+tableCell.cellObject[1];
                }else{
                    dimensionStr += ","+tableCell.cellObject[1] + ":$."+tableCell.cellObject[1];
                }
                if(dimensionValueStr == ""){
                    dimensionValueStr = "$." + tableCell.cellObject[1];
                }else{
                    dimensionValueStr += "+'-'+"+"$." + tableCell.cellObject[1];
                }
            }
            else if(tableCell.cellObject[2] == 1){
                if(measureStr == ""){
                    measureStr = '$.'+tableCell.cellObject[1];
                }else{
                    measureStr += ',$.'+tableCell.cellObject[1];
                }
                measureObj[tableCell.cellObject[1]] = tableCell.cellObject[1];
            }   
        }
        if(dimensionStr == ""){
            var showData = Enumerable.from(queryData).groupBy("1", null,function(key, group){
                var obj = {};
                for(var item in measureObj){
                    obj[queryName + ""+item] = group.sum("$."+item);
                }
                return obj
            },"1")
            .toArray();
        }else{
            var showData = Enumerable.from(queryData).groupBy("{"+dimensionStr+"}", null,function(key, group){
                var obj = {};
                for(var item in dimensionObj){
                    obj[queryName + ""+item] = key[item];
                }
                for(var item in measureObj){
                    obj[queryName + ""+item] = group.sum("$."+item);
                }
                return obj
            },dimensionValueStr)
            .orderByDescending("{"+dimensionStr+"}")
            .toArray();
        }
        return showData;
    }

    $(".vertical-table").on('contextmenu', ".datagrid-htable td", function () {//禁用掉#demo1的右键菜单
        return false;
    });

    $(".table-contextmenu").on('contextmenu', function () {//禁用掉#demo1的右键菜单
        return false;
    });

    $('.vertical-table').on('mousedown', ".datagrid-htable td", function(e){//紧接上面的实例demo1 在script中插入这段代码即可获取到鼠标点击事件
        var code = e.which;//判断是单机了鼠标哪个键(1,2,3)
        var field = Number($(this).attr("field"));
        if(code == 3){
            setBoxStyle(e);
            $(".table-contextmenu li").off("click").on("click",function(){
                if($(this).attr("data-code") == 0){
                    $(".table-contextmenu").hide();
                    if(reportView.viewBlocks.item(0).viewTableBody.viewTableRows.item(0).viewTableCells.count > 1){
                        var tableHeadCell = reportView.viewBlocks.item(0).viewTableHead.viewTableRows.item(0).viewTableCells.item(field);
                        var tableBodyCell = reportView.viewBlocks.item(0).viewTableBody.viewTableRows.item(0).viewTableCells.item(field);
                        reportView.viewBlocks.item(0).viewTableHead.viewTableRows.item(0).viewTableCells.remove(tableHeadCell);
                        reportView.viewBlocks.item(0).viewTableBody.viewTableRows.item(0).viewTableCells.remove(tableBodyCell);
                        setBlockData();
                    }else{
                        layer.msg("最后一列不能删除");
                    }
                }
            });

            $("body").off("click").on("click", function(e) {
                // IE支持 event.srcElement ， FF支持 event.target
                var evt = e.srcElement ? e.srcElement : e.target;
                if($(evt).hasClass("table-contextmenu") || $(evt).parents("div").hasClass("contextmenu-li")){
                    return; // 如果是元素本身，则返回
                }else {
                    $(".table-contextmenu").hide(); // 如不是则隐藏元素
                }
            });
        }
    });

    function setBoxStyle(e){
        var pageX = e.pageX;
        var pageY = e.pageY;
        var documentWidth = $(document).width();
        var documentHeight = $(document).height();
        var y = 0;
        var x = 0;
        var styleObj = {};
        styleObj.left = pageX + "px";
        styleObj.top = pageY + "px";
        if(pageX + 100 >= documentWidth){
            styleObj.left = (pageX - 100)+"px";
        }
        if(pageY + 33 >= documentHeight){
            styleObj.top = (pageY - 100) + "px";
        }
        $(".table-contextmenu").show().css(styleObj);
    }

    window.refresh = function(){
        layer.msg("请使用表格上方的过滤条件查询！");
    };

    window.quitFullScreen = function(){
        if(window.parent && window.parent.quitFullScreen){
            window.parent.quitFullScreen();
        }
    }
    window.magnify = function(){
        if(window.parent && window.parent.magnify){
            window.parent.magnify();
        }
    }

    var isESCPress = false;
    
    document.body.onkeydown = function(e){
        var ev = e||window.event;
        var code = ev.keyCode;
        if(code == 27){
            isESCPress = true;
        }
        if(isESCPress && window.parent.quitFullScreen){
            quitFullScreen();
        }
        if(code == 122 && ev.ctrlKey){
            magnify();
        }
    };

    document.body.onkeyup = function(e){
        var ev = e||window.event;
        if(ev.keyCode == 27){
            isESCPress = false
        }
    };

    window.printing = function(){
        var bodyHTML=window.document.body.innerHTML;
        window.document.body.innerHTML=$('.vertical-table').html();
        window.print();
        window.document.body.innerHTML=bodyHTML;
    };

    window.exportToExcel = function(reportName){
        if(reportView.viewBlocks.count){
            var blocks = blocksGenerateObject();
            for(var i = 0; i < blocks.length; i++){
                blocks[i].sheet = obj2sheet(blocks[i]);
            }
            if(blocks.length){
                var blob = sheet2blob(blocks);
                openDownloadDialog(blob,reportName + '.xlsx');
            }
        }
    };

    function blocksGenerateObject(){
        var blocks = [];
        var viewBlock = reportView.viewBlocks.item(0);
        var chartID = viewBlock.chartID;
        var blockObj = {};
        blockObj.blockName = viewBlock.blockName?((typeof viewBlock.blockName == "number")?("块" + viewBlock.blockName):viewBlock.blockName):("块" + i);
        blockObj.chartID = chartID;
        if(chartID == 1){
            getTableObj(blockObj,viewBlock);
        }
        blocks.push(blockObj);
        return blocks;
    }

    function getTableObj(blockObj,viewBlock){
        var merges = [];
        var tempData = [];
        var tempArr = [];
        var tempObj = {};
        for(var j = 0; j < viewBlock.viewTableHead.viewTableRows.count; j++){
            tempArr = [];
            var viewTableRow = viewBlock.viewTableHead.viewTableRows.item(j);
            for(var k = 0; k < viewTableRow.viewTableCells.count; k++){
                tempObj = {};
                if(!viewTableRow.viewTableCells.item(k).autoColumnWidth && viewTableRow.viewTableCells.item(k).columnWidth==0){continue;}
                if(viewTableRow.viewTableCells.item(k).colspan > 1 || viewTableRow.viewTableCells.item(k).rowspan > 1){
                    var obj = {};
                    var startColAndRowObj = {};
                    var endColAndRowObj = {};
                    startColAndRowObj.c = viewTableRow.viewTableCells.item(k).columnIndex;
                    startColAndRowObj.r = viewTableRow.viewTableCells.item(k).rowID;
                    obj.s = startColAndRowObj;
                    endColAndRowObj.c = viewTableRow.viewTableCells.item(k).columnIndex + viewTableRow.viewTableCells.item(k).colspan - 1;
                    endColAndRowObj.r = viewTableRow.viewTableCells.item(k).rowID + viewTableRow.viewTableCells.item(k).rowspan - 1;
                    obj.e = endColAndRowObj;
                    merges.push(obj);
                }
                tempObj.value = viewTableRow.viewTableCells.item(k).text;
                tempObj.dataType = viewTableRow.viewTableCells.item(k).cellObject[3];
                tempObj.format = viewTableRow.viewTableCells.item(k).formatString;
                tempArr.push(tempObj);
            }
            tempData.push(tempArr);
        }

        for(var j = 0; j < viewBlock.blockDataToDraw.length; j++){
            tempArr = [];
            for(var k = 0; k < viewBlock.viewTableBody.viewTableRows.item(0).viewTableCells.count; k++){
                var tempViewTableCell = viewBlock.viewTableBody.viewTableRows.item(0).viewTableCells.item(k);
                if(!tempViewTableCell.autoColumnWidth && tempViewTableCell.columnWidth==0){continue;}
                tempObj = {};
                tempObj.value = viewBlock.blockDataToDraw[j][tempViewTableCell.cellObject[0]+"___"+tempViewTableCell.cellObject[1]];
                tempObj.dataType = tempViewTableCell.cellObject[3];
                tempObj.format = tempViewTableCell.formatString;
                tempArr.push(tempObj);
            }
            tempData.push(tempArr);
        }

        for(var j = 0; j < viewBlock.viewTableFoot.viewTableRows.count; j++){
            tempArr = [];
            var viewTableRow = viewBlock.viewTableFoot.viewTableRows.item(j);
            for(var k = 0; k < viewTableRow.viewTableCells.count; k++){
                tempObj = {};
                if(!viewTableRow.viewTableCells.item(k).autoColumnWidth && viewTableRow.viewTableCells.item(k).columnWidth==0){continue;}
                if(viewTableRow.viewTableCells.item(k).colspan > 1 || viewTableRow.viewTableCells.item(k).rowspan > 1){
                    var obj = {};
                    var footStartColAndRowObj = {};
                    var footEndColAndRowObj = {};
                    footStartColAndRowObj.c = viewTableRow.viewTableCells.item(k).columnIndex;
                    footStartColAndRowObj.r = tempData.length;
                    obj.s = footStartColAndRowObj;
                    footEndColAndRowObj.c = viewTableRow.viewTableCells.item(k).columnIndex + viewTableRow.viewTableCells.item(k).colspan - 1;
                    footEndColAndRowObj.r = tempData.length + viewTableRow.viewTableCells.item(k).rowspan - 1;
                    obj.e = footEndColAndRowObj;
                    merges.push(obj);
                }
                tempObj.value = viewTableRow.viewTableCells.item(k).text;
                tempObj.dataType = viewTableRow.viewTableCells.item(k).cellObject[3];
                tempObj.format = viewTableRow.viewTableCells.item(k).formatString;
                tempArr.push(tempObj);
            }
            tempData.push(tempArr);
        }
        blockObj.merges = merges;
        blockObj.data = tempData;
        blockObj.columnCount = tempData[0].length;
        blockObj.rowCount = tempData.length;
    }

    function obj2sheet(blockObj){
        var sheet = {};
        var endNum = blockObj.columnCount%26?blockObj.columnCount%26:parseInt(blockObj.columnCount/26);
        var endCode = "";
        if(parseInt(blockObj.columnCount/26) < 1){
            endCode = String.fromCharCode(65+blockObj.columnCount-1);
        }else{
            endCode = String.fromCharCode(65+parseInt(blockObj.columnCount/26)-1) + String.fromCharCode(65+endNum-1);
        }

        for(var i = 0; i < blockObj.data.length; i++){
            if(i == 0) sheet['!ref'] = 'A1:'+endCode+(blockObj.rowCount);
            for(var j = 0; j < blockObj.data[i].length; j++){
                var cell = blockObj.data[i][j]
                if(j < 26){
                    if(cell.dataType == 2){
                        if(cell.format.indexOf("E") != -1){
                            var format = cell.format.slice(0,cell.format.indexOf("E")+1) + "+" + cell.format.slice(cell.format.indexOf("E")+1);
                            sheet[String.fromCharCode(65+j)+(i+1)] = (cell.value!=null && cell.value != "null" || cell.value == 0)?{v: cell.value,t:'n',z:format}:{v: ""};
                        }else if(cell.format.indexOf(".") != -1){
                            var format = cell.format.split(".");
                            if(format[1].length == 0 || format[1] == "%"){
                                if(format[1] == "%"){
                                    sheet[String.fromCharCode(65+j)+(i+1)] = (cell.value!=null && cell.value != "null" || cell.value == 0)?{v: cell.value,t:'n',z:(format[0]+format[1])}:{v: ""};
                                }else{
                                    sheet[String.fromCharCode(65+j)+(i+1)] = (cell.value!=null && cell.value != "null" || cell.value == 0)?{v: cell.value,t:'n',z:format[0]}:{v: ""};
                                }
                            }else{
                                sheet[String.fromCharCode(65+j)+(i+1)] = (cell.value!=null && cell.value != "null" || cell.value == 0)?{v: cell.value,t:'n',z:cell.format}:{v: ""};
                            }
                        }else{
                            sheet[String.fromCharCode(65+j)+(i+1)] = (cell.value!=null && cell.value != "null" || cell.value == 0)?{v: cell.value,t:'n',z:cell.format}:{v: ""};
                        }
                    }else if(cell.dataType == 1){
                        sheet[String.fromCharCode(65+j)+(i+1)] = (cell.value!=null && cell.value != "null")?({v: Number(cell.value),t:'d',z:(cell.format)?cell.format:"yyyy-mm-dd"}):({v: ""});
                    }else{
                        sheet[String.fromCharCode(65+j)+(i+1)] = (cell.value!=null && cell.value != "null")?{v: cell.value}:{v: ""};
                    }
                }else{
                    if(cell.dataType == 2){
                        if(cell.format.indexOf("E") != -1){
                            var format = cell.format.slice(0,cell.format.indexOf("E")+1) + "+" + cell.format.slice(cell.format.indexOf("E")+1);
                            sheet[String.fromCharCode(65+parseInt(j/26)-1)+String.fromCharCode(65+j%26)+(i+1)] = (cell.value!=null && cell.value != "null" || cell.value == 0)?{v: cell.value,t:'n',z:format}:{v: ""};
                        }else if(cell.format.indexOf(".") != -1){
                            var format = cell.format.split(".");
                            if(format[1].length == 0 || format[1] == "%"){
                                if(format[1] == "%"){
                                    sheet[String.fromCharCode(65+parseInt(j/26)-1)+String.fromCharCode(65+j%26)+(i+1)] = (cell.value!=null && cell.value != "null" || cell.value == 0)?{v: cell.value,t:'n',z:(format[0]+format[1])}:{v: ""};
                                }else{
                                    sheet[String.fromCharCode(65+parseInt(j/26)-1)+String.fromCharCode(65+j%26)+(i+1)] = (cell.value!=null && cell.value != "null" || cell.value == 0)?{v: cell.value,t:'n',z:format[0]}:{v: ""};
                                }
                            }else{
                                sheet[String.fromCharCode(65+parseInt(j/26)-1)+String.fromCharCode(65+j%26)+(i+1)] = (cell.value!=null && cell.value != "null" || cell.value == 0)?{v: cell.value,t:'n',z:cell.format}:{v: ""};
                            }
                        }else{
                            sheet[String.fromCharCode(65+parseInt(j/26)-1)+String.fromCharCode(65+j%26)+(i+1)] = (cell.value!=null && cell.value != "null" || cell.value == 0)?{v: cell.value,t:'n',z:cell.format}:{v: ""};
                        }
                        // sheet[String.fromCharCode(65+parseInt(j/26)-1)+String.fromCharCode(65+j%26)+(i+1)] = (cell.value || cell.value == 0)?{v: Number(cell.value),t:'n',z:cell.format}:"";
                    }else if(cell.dataType == 1){
                        sheet[String.fromCharCode(65+parseInt(j/26)-1)+String.fromCharCode(65+j%26)+(i+1)] = (cell.value!=null && cell.value != "null")?({v: Number(cell.value),t:'d',z:(cell.format)?cell.format:"yyyy-mm-dd"}):({v: ""});
                    }else{
                        sheet[String.fromCharCode(65+parseInt(j/26)-1)+String.fromCharCode(65+j%26)+(i+1)] = (cell.value!=null && cell.value != "null")?{v: cell.value}:{v: ""};
                    }
                }
            }
        }
        sheet['!merges'] = blockObj.merges;
        return sheet;
    }

    function sheet2blob(blocks) {
        var workbook = {
            SheetNames: [],
            Sheets: {}
        };
        for(var i = 0; i < blocks.length; i++){
            workbook.SheetNames.push(blocks[i].blockName);
            workbook.Sheets[blocks[i].blockName] = blocks[i].sheet;
        }
        //workbook.Sheets["块1"] = blocksCSV.strCSV;
        // 生成excel的配置项
        var wopts = {
            bookType: 'xlsx', // 要生成的文件类型
            bookSST: false, // 是否生成Shared String Table，官方解释是，如果开启生成速度会下降，但在低版本IOS设备上有更好的兼容性
            type: 'binary'
        };
        var wbout = XLSX.write(workbook, wopts);
        var blob = new Blob([s2ab(wbout)], {type:"application/excel"});
        // 字符串转ArrayBuffer
        function s2ab(s) {
            var buf = new ArrayBuffer(s.length);
            var view = new Uint8Array(buf);
            for (var i=0; i!=s.length; ++i) view[i] = s.charCodeAt(i) & 0xFF;
            return buf;
        }
        return blob;
    }

    function openDownloadDialog(url, saveName){
        if(window.navigator.msSaveOrOpenBlob){
            window.navigator.msSaveOrOpenBlob(url, saveName);
        }else{
            if(typeof url == 'object' && url instanceof Blob)
            {
                url = URL.createObjectURL(url); // 创建blob地址
            }
            //url = 'data:text/csv;charset=utf-8,' + url;
            var aLink = document.createElement('a');
            aLink.href = url;
            aLink.download = saveName || ''; // HTML5新增的属性，指定保存文件名，可以不要后缀，注意，file:///模式下不会生效
            document.body.appendChild(aLink);
            aLink.click();
            document.body.removeChild(aLink);
        }
    }
});