/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-04-22 21:07:01
 * @LastEditTime: 2020-05-19 15:55:29
 * @LastModifyUser: 
 * @Remark: 
 */
!function(){
    var $ = layui.jquery, layer = layui.layer, form = layui.form;
    var users = new Users();
    var mFiles = null;

    initForm();

    function initForm(){
        form.val("formWindow",{
            fullName: $AppVars.gUser.fullName,
            mobileNumber: $AppVars.gUser.mobileNumber,
            emailAddress: $AppVars.gUser.emailAddress
        });

        if($AppVars.gUser.portrait){
            $(".face img").attr("src",$AppConstants.hostName + $AppConstants.port+"/bdasystem/" + $AppVars.gUser.portrait);
        }

        var organization = document.getElementById("organizationList");
        for(var i = 0; i < $AppVars.gOrganizations.count; i++){
            var option = document.createElement("option");
            option.setAttribute("value",$AppVars.gOrganizations.item(i).organizationID);
            if($AppVars.gOrganizations.item(i).organizationID == $AppVars.gUser.defaultOrganizationID){
                option.setAttribute("selected",true);
            }
            option.innerText = $AppVars.gOrganizations.item(i).organizationShortName;
            organization.appendChild(option);
        }

        form.render();

        form.on("submit(formSubmit)",function(obj){
            var userMessageChange = false;
            if(change(obj)){
                userMessageChange = true;
                var user = setUser(obj);
                var succ = function(){
                    $Utils.loading.close();
                    layer.closeAll();
                    if(!mFiles){
                        reloadUserMessage();
                    }
                };
                var fail = function(errorStatus,msg){
                    $Utils.loading.close();
                    $Utils.openWindow.failWindow("修改用户信息",errorStatus,msg);
                };
                users.editItem(user,true,succ,fail);
            }
            if(mFiles){
                uploadFace(userMessageChange);
            }else{
                layer.closeAll();
            }
            return false;
        });

        $(".layui-btn-cancel").click(function(){
            layer.closeAll();
        });

        $(".face img").click(function(){
            $("#uploadFile").click();
        });

        $("#uploadFile").change(function(e) {
            var files = Object.values(e.target.files);
            showImage(files[0]);
            mFiles = files[0];
            e.target.value = '';
        });
    }

    function showImage(fileObj){
        var src = window.URL.createObjectURL(fileObj);
        $(".face img").attr('src', src); 
    }

    function change(obj){
        if(obj.field.fullName != $AppVars.gUser.fullName){
            return true;
        }
        if(obj.field.defaultOrganizationID != $AppVars.gUser.defaultOrganizationID){
            return true;
        }

        return false;
    }

    function setUser(obj){
        var user = new User();
        user.userID = $AppVars.gUser.userID;
        user.userName = $AppVars.gUser.userName;
        user.mobileNumber = $AppVars.gUser.mobileNumber;
        user.emailAddress = $AppVars.gUser.emailAddress;
        user.fullName = obj.field.fullName;
        user.defaultOrganizationID = obj.field.defaultOrganizationID;
        user.organizationShortName = $AppVars.gOrganizations.item(obj.field.defaultOrganizationID).organizationShortName;
        user.registerMethod = $AppVars.gUser.registerMethod;
        user.userForbidden = $AppVars.gUser.userForbidden;

        return user;
    }

    function uploadFace(userMessageChange){
        var file = new FormData();
        file.append("portrait", mFiles);
        var succ = function(){
            $Utils.loading.close();
            reloadUserMessage();
            if(!userMessageChange){
                layer.closeAll();
            }
        };
        var fail = function(errorStatus,msg){
            $Utils.loading.close();
            $Utils.openWindow.failWindow("修改用户头像",errorStatus,msg);
        };
        $AppVars.gUser.uploadFace(file,true,succ,fail);
    }
    
}();