/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-05-28 11:08:54
 * @LastEditTime: 2020-05-28 14:42:44
 * @LastModifyUser: 
 * @Remark: 
 */ 
!function(){
    var $ = layui.jquery, form = layui.form, layer = layui.layer;
    var countries = new Countries();
    var provinces = new Provinces();
    var cities = new Cities();

    $Utils.loading.open();
    getRegionDataAndInitForm();

    function getRegionDataAndInitForm(){
        var succ = function(){
            getProvincesAndInitForm();
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取国家列表",errorStatus,msg);
		};
        countries.getItems(true,succ,fail);
    }

    function getProvincesAndInitForm(){
        var succ = function(){
            getCitiesAndInitForm();
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取省份列表",errorStatus,msg);
		};
        provinces.getItems(true,succ,fail);
    }

    function getCitiesAndInitForm(){
        var succ = function(){
            $Utils.loading.close();
            initForm();
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取城市列表",errorStatus,msg);
		};
        cities.getItems(true,succ,fail);
    }

    function initForm(){

        initSelectForm();
        bindEvent();
    }

    function initSelectForm(){
        var country = document.getElementById("country");
        for(var i = 0; i < countries.count; i++){
            if(countries.item(i).haveChildMap){
                var option = document.createElement("option");
                option.setAttribute("value",countries.item(i).countryID);
                if(countries.item(i).countryID == 1){
                    option.setAttribute("selected",true);
                }
                option.innerText = countries.item(i).countryName;
                country.appendChild(option);
            }
        }
        form.render();
        initProvincesSelect(1);
        initCitiesSelect(1);
        
    }

    function initProvincesSelect(countryID){
        var province = document.getElementById("province");
        for(var i = 0; i < provinces.count; i++){
            if(provinces.item(i).countryID == countryID){
                var option = document.createElement("option");
                option.setAttribute("value",provinces.item(i).provinceID);
                if( i == 0){
                    option.setAttribute("selected",true);
                }
                option.innerText = provinces.item(i).provinceName;
                province.appendChild(option);
            }
        }
        form.render();
    }

    function initCitiesSelect(provinceID){
        var city = document.getElementById("city");
        for(var i = 0; i < cities.count; i++){
            if(cities.item(i).provinceID == provinceID){
                var option = document.createElement("option");
                option.setAttribute("value",cities.item(i).cityID);
                if(i == 0){
                    option.setAttribute("selected",true);
                }
                option.innerText = cities.item(i).cityName;
                city.appendChild(option);
            }
        }
        form.render();
    }

    function bindEvent(){
        form.on("select(province)",function(data){
            var selectProvinceID = data.value;
            var city = document.getElementById("city");
            $(city).empty();
            initCitiesSelect(selectProvinceID)
        });

        form.verify({
            shortName: function(value){
              if(value.length > 8){
                return '简称不能超过8个字符';
              }
            },
            mail:function(value){
                if(value != "" && value.indexOf("@")==-1){
                    return '邮箱格式不正确';
                }
            }
        });

        form.on("submit(formSubmit)",function(obj){
            $Utils.loading.open();
            var organization = new Organization();
            organization.organizationName = obj.field.organizationName;
            organization.organizationShortName = obj.field.organizationShortName;
            organization.contactPerson = obj.field.contactPerson;
            organization.telephone = obj.field.telephone;
            organization.mobileNumber = obj.field.mobileNumber;
            organization.emailAddress = obj.field.emailAddress;
            organization.countryID = Number(obj.field.countryID);
            organization.provinceID = Number(obj.field.provinceID);
            organization.cityID = Number(obj.field.cityID);
            organization.organizationLogo = "";
            organization.systemName = "";
            var succ = function(){
                $Utils.loading.close();
                layer.closeAll();
                layer.msg("创建成功！",{icon:1});
                $AppVars.gOrganizations.add(organization);
            };
            var fail = function(errorStatus,msg){
                $Utils.loading.close();
                $Utils.openWindow.failWindow("新增组织",errorStatus,msg);
            };
            $AppVars.gOrganizations.addItem(organization,true,succ,fail);
            return false;
        });

        $(".layui-btn-cancel").click(function(){
            layer.closeAll();
        });
    }
    
}();