/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-04-22 09:17:06
 * @LastEditTime: 2021-01-28 09:30:45
 * @LastModifyUser: 
 * @Remark: 
 */
!function(){
    var $ = layui.jquery, layer = layui.layer, tree = layui.tree;
    var folders = new ReportFolders();
    var reports = new Reports();
    var selfAnalysis = new SelfAnalysis();

    getFoldersAndReportsAndInitPersonalization();

    function getFoldersAndReportsAndInitPersonalization(){
        var succ = function(){
            getReportsAndInitPersonalization();
        };
        var fail = function(errorStatus,msg){
            $Utils.openWindow.failWindow("获取报表文件夹列表",errorStatus,msg);
        };
        folders.getItems(true,succ,fail);
    }

    function getReportsAndInitPersonalization(){
        var succ = function(){
            getSelfAnalysisAndInitPersonalization();
        };
        var fail = function(errorStatus,msg){
            $Utils.openWindow.failWindow("获取报表列表",errorStatus,msg);
        };
        reports.getItems(0,true,succ,fail);
    }

    function getSelfAnalysisAndInitPersonalization(){
        var succ = function(){
            initPersonalizationForm()
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取自助报表列表",errorStatus,msg);
		};
		selfAnalysis.getItems(0,true,succ,fail);
    }

    function initPersonalizationForm(){
        var organizationUserSetting = $AppVars.gOrganizationUsers.item(0).organizationUserSettings;
        if(organizationUserSetting.item("homePageType").settingValue == 0){
            $(".personalization-box ul.homeOrReport li").eq(0).find("span.radio").addClass("select-radio");
        }
        if(organizationUserSetting.item("homePageType").settingValue == 1){
            $(".personalization-box ul.homeOrReport li").eq(1).find("span.radio").addClass("select-radio");
            $(".personalization-box ul.homeOrReport li").eq(1).attr("data-reportid",organizationUserSetting.item("pageURI").settingValue);
            $(".personalization-box ul.homeOrReport li").eq(1).find("input").val(setReportName(organizationUserSetting.item("pageURI").settingValue));
        }
        if(organizationUserSetting.item("linkReportTarget").settingValue == 0){
            $(".personalization-box ul.reportLinkPage li").eq(0).find("span.radio").addClass("select-radio");
        }else{
            $(".personalization-box ul.reportLinkPage li").eq(1).find("span.radio").addClass("select-radio");
        }
        if(organizationUserSetting.item("showChartSample").settingValue == 1){
            $(".personalization-box p.chart-sample span").addClass("select-checkbox");
        }
        if(organizationUserSetting.item("showExcelUpload") && organizationUserSetting.item("showExcelUpload").settingValue == 1){
            $(".personalization-box p.excel-upload span").addClass("select-checkbox");
        }
        initPersonalizationEvent();
    }

    function initPersonalizationEvent(){
        var treeSelect = {};
        $(".personalization-box ul li span").click(function(){
            if(!$(this).hasClass("select-radio")){
                $(this).addClass("select-radio").parent("li").siblings("li").find("span").removeClass("select-radio");
            }
        });
        $(".personalization-box p span").click(function(){
            if(!$(this).hasClass("select-checkbox")){
                $(this).addClass("select-checkbox");
            }else{
                $(this).removeClass("select-checkbox");
            }
        });
        $(".personalization-box ul li button").click(function(){
            if($(this).siblings("span.radio").hasClass("select-radio")){
                openAndShowReportList(treeSelect);
            }
        });

        $(".layui-btn-determine").click(function(){
            if(change()){
                savePersonalization();
            }
        });

        $(".layui-btn-cancel").click(function(){
            layer.closeAll();
        });
    }

    function openAndShowReportList(treeSelect){
        layer.open({
            type: 1,
            title: ["报表列表","font-size: 14px"],
            btn: ["确定","取消"],
            resize: false,
            area: ["500px","666px"],
            content: '<div id="treeReportList"></div>',
            success: function(layero,index){
                TrimFoldersData();
                initTreeList(treeSelect);
            },
            yes: function(index, layero){
                $(".personalization-box ul.homeOrReport li").eq(1).find("input").val(setReportName(treeSelect.reportID));
                $(".personalization-box ul.homeOrReport li").eq(1).attr("data-reportid",treeSelect.reportID);
                layer.close(index);
            }
        });
    }

    function TrimFoldersData(){
        var haveReportFolders = [];
        for(var i = 0; i < reports.count; i++){
            var folderID = reports.item(i).folderID;
            while(folderID != -1 && haveReportFolders.indexOf(folderID) == -1){
                haveReportFolders.push(folderID);
                folderID = folders.item(folderID).folderParentID;
            }
        }
        for(var i = folders.count-1;i>=0;i--){
			if(haveReportFolders.indexOf(folders.item(i).folderID) == -1){
				folders.remove(folders.item(i));
			}
		}
    }

    function initTreeList(treeSelect){
        var treeData = setTreeData();
        
        tree.render({
            elem: '#treeReportList',
            data: treeData,
            isJump: true,
            click: function(obj){
                if(obj.data.reportID){
                    treeSelect.reportID = obj.data.reportID;
                    $('#treeReportList').find(".select-tree").removeClass("select-tree");
                    $(obj.elem).addClass("select-tree");
                }
            }
        });
    }

    function setTreeData(){
        var tempArr = []
        var hashTable = new HashTable();
        hashTable.add("-1", { title: "组织分析", id: "0", folderID: "0", folderParentID: "0", spread: true});
        for(var i = 0; i < folders.count; i++){
            hashTable.add(folders.item(i).folderID,{title:folders.item(i).folderName,id:folders.item(i).folderID,folderID:folders.item(i).folderID,folderParentID:folders.item(i).folderParentID});
        }
        for(var i = 0; i < folders.count; i++){
            var parentFolder = hashTable.getValue(folders.item(i).folderParentID);
            if(!parentFolder.children){
                parentFolder.children = [];
            }
            parentFolder.children.push(hashTable.getValue(folders.item(i).folderID));
        }
        for(var i = 0; i < reports.count; i++){
            var parentFolder = hashTable.getValue(reports.item(i).folderID);
            if(!parentFolder.children){
                parentFolder.children = [];
            }
            parentFolder.children.push({title:reports.item(i).reportName,id:reports.item(i).reportID,folderParentID:reports.item(i).folderID,reportID:reports.item(i).reportID});
        }
        tempArr.push(hashTable.getValue("-1"));
        var selfObj = {
            title: "自助分析",
            id: "-1",
            folderID: "-1",
            spread: true
        };
        var tempSelfArr = [];
        for(var i = 0; i < selfAnalysis.count; i++){
            var obj = {};
            obj.title = selfAnalysis.item(i).reportName;
            obj.id = selfAnalysis.item(i).reportID;
            obj.reportID = selfAnalysis.item(i).reportID;
            obj.folderParentID = selfAnalysis.item(i).folderID;
            tempSelfArr.push(obj);
        }
        if(tempSelfArr.length){
            selfObj.children = tempSelfArr;
        }
		if(selfObj.children){
			tempArr.push(selfObj);
        }
        
        return tempArr;
    }

    function setReportName(reportID){
        var reportName = "未找到可见报表。";
        for(var i = 0; i < reports.count; i++){
            if(reports.item(i).reportID == reportID){
                reportName = reports.item(i).reportName;
                break;
            }
        }
        for(var i = 0; i < selfAnalysis.count; i++){
            if(selfAnalysis.item(i).reportID == reportID){
                reportName = selfAnalysis.item(i).reportName;
                break;
            }
        }
        return reportName;
    }

    function change(){
        if($(".personalization-box ul.homeOrReport li span.select-radio").parent("li").index() == 1 && !$(".personalization-box ul.homeOrReport li").eq(1).attr("data-reportid")){
            layer.msg("请选择需要默认打开的报表。",{icon:2});
            return false;
        }
        return true;
    }

    function savePersonalization(){
        $Utils.loading.open();
        var tempArr = [];
        var tempObj = {};
        tempObj.settingKey = "homePageType";
        tempObj.settingValue = $(".personalization-box ul.homeOrReport li span.select-radio").parent("li").index() == 0?0:1;
        tempArr.push(tempObj);
        tempObj = {};
        tempObj.settingKey = "pageURI";
        tempObj.settingValue = $(".personalization-box ul.homeOrReport li span.select-radio").parent("li").index() != 0?$(".personalization-box ul.homeOrReport li").eq(1).attr("data-reportid"):"home.html";
        tempArr.push(tempObj);
        tempObj = {};
        tempObj.settingKey = "linkReportTarget";
        tempObj.settingValue = $(".personalization-box ul.reportLinkPage li span.select-radio").parent("li").index() == 0?0:1;
        tempArr.push(tempObj);
        tempObj = {};
        tempObj.settingKey = "showChartSample";
        tempObj.settingValue = $(".personalization-box p.chart-sample span").hasClass("select-checkbox")?1:0;
        tempArr.push(tempObj);
        tempObj = {};
        tempObj.settingKey = "showExcelUpload";
        tempObj.settingValue = $(".personalization-box p.excel-upload span").hasClass("select-checkbox")?1:0;
        tempArr.push(tempObj);
        var succ = function(){
            $Utils.loading.close();
            layer.closeAll();
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("修改个性化",errorStatus,msg);
		};
        $AppVars.gOrganizationUsers.item(0).organizationUserSettings.editItem($AppVars.gOrganizationUsers.item(0).organizationUserID,tempArr,true,succ,fail);
    }

    function HashTable() {
        var size = 0;
        var entry = new Object();
        this.add = function (key, value) {
            if (!this.containsKey(key)) {
                size++;
            }
            entry[key] = value;
        }
        this.getValue = function (key) {
            return this.containsKey(key) ? entry[key] : null;
        }
        this.remove = function (key) {
            if (this.containsKey(key) && (delete entry[key])) {
                size--;
            }
        }
        this.containsKey = function (key) {
            return (key in entry);
        }
        this.containsValue = function (value) {
            for (var prop in entry) {
                if (entry[prop] == value) {
                    return true;
                }
            }
            return false;
        }
        this.getValues = function () {
            var values = new Array();
            for (var prop in entry) {
                values.push(entry[prop]);
            }
            return values;
        }
        this.getKeys = function () {
            var keys = new Array();
            for (var prop in entry) {
                keys.push(prop);
            }
            return keys;
        }
        this.getSize = function () {
            return size;
        }
        this.clear = function () {
            size = 0;
            entry = new Object();
        }
    }
    
}();