/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-04-22 10:58:07
 * @LastEditTime: 2020-11-30 15:05:21
 * @LastModifyUser: 
 * @Remark: 
 */
!function(){
    var $ = layui.jquery, layer = layui.layer, form = layui.form;
    var countries = new Countries();
    var provinces = new Provinces();
    var cities = new Cities();
    var mFiles = null;
    var logoReset = false;

    $Utils.loading.open();
    form.render();
    getRegionDataAndInitForm();

    function getRegionDataAndInitForm(){
        var succ = function(){
            getProvincesAndInitForm();
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取国家列表",errorStatus,msg);
		};
        countries.getItems(true,succ,fail);
    }

    function getProvincesAndInitForm(){
        var succ = function(){
            getCitiesAndInitForm();
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取省份列表",errorStatus,msg);
		};
        provinces.getItems(true,succ,fail);
    }

    function getCitiesAndInitForm(){
        var succ = function(){
            $Utils.loading.close();
            initForm();
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取城市列表",errorStatus,msg);
		};
        cities.getItems(true,succ,fail);
    }

    function initForm(){
        form.val("formWindow",{
            organizationName: $AppVars.gOrganizations.item($AppVars.gLogin.organizationID).organizationName,
            organizationShortName: $AppVars.gOrganizations.item($AppVars.gLogin.organizationID).organizationShortName,
            contactPerson: $AppVars.gOrganizations.item($AppVars.gLogin.organizationID).contactPerson,
            telephone: $AppVars.gOrganizations.item($AppVars.gLogin.organizationID).telephone,
            mobileNumber: $AppVars.gOrganizations.item($AppVars.gLogin.organizationID).mobileNumber,
            emailAddress: $AppVars.gOrganizations.item($AppVars.gLogin.organizationID).emailAddress,
            systemName: $AppVars.gOrganizations.item($AppVars.gLogin.organizationID).systemName
        });

        initSelectForm();
        initLogo();
        bindEvent();
        form.render();
    }

    function initSelectForm(){
        var country = document.getElementById("country");
        for(var i = 0; i < countries.count; i++){
            if(countries.item(i).haveChildMap){
                var option = document.createElement("option");
                option.setAttribute("value",countries.item(i).countryID);
                if(countries.item(i).countryID == $AppVars.gOrganizations.item($AppVars.gLogin.organizationID).countryID){
                    option.setAttribute("selected",true);
                }
                option.innerText = countries.item(i).countryName;
                country.appendChild(option);
            }
        }
        initProvincesSelect($AppVars.gOrganizations.item($AppVars.gLogin.organizationID).countryID,true);
        initCitiesSelect($AppVars.gOrganizations.item($AppVars.gLogin.organizationID).provinceID,true);
        
    }

    function initProvincesSelect(countryID,isFirst){
        var province = document.getElementById("province");
        for(var i = 0; i < provinces.count; i++){
            if(provinces.item(i).countryID == countryID){
                var option = document.createElement("option");
                option.setAttribute("value",provinces.item(i).provinceID);
                if(provinces.item(i).provinceID == $AppVars.gOrganizations.item($AppVars.gLogin.organizationID).provinceID && isFirst){
                    option.setAttribute("selected",true);
                }else if( i == 0 && !isFirst){
                    option.setAttribute("selected",true);
                }
                option.innerText = provinces.item(i).provinceName;
                province.appendChild(option);
            }
        }
    }

    function initCitiesSelect(provinceID,isFirst){
        var city = document.getElementById("city");
        for(var i = 0; i < cities.count; i++){
            if(cities.item(i).provinceID == provinceID){
                var option = document.createElement("option");
                option.setAttribute("value",cities.item(i).cityID);
                if(cities.item(i).cityID == $AppVars.gOrganizations.item($AppVars.gLogin.organizationID).cityID && isFirst){
                    option.setAttribute("selected",true);
                }else if(i == 0 && !isFirst){
                    option.setAttribute("selected",true);
                }
                option.innerText = cities.item(i).cityName;
                city.appendChild(option);
            }
        }
    }

    function initLogo(){
        logoReset = false;
        if($AppVars.gOrganizations.item($AppVars.gLogin.organizationID).organizationLogo){
            var url = $AppConstants.hostName + $AppConstants.port + "/bdasystem/" + $AppVars.gOrganizations.item($AppVars.gLogin.organizationID).organizationLogo;
            $(".logo-box img").attr("src",url);
        }else{
            $(".logo-box img").attr("src","images/defaultLogo.png");
        }
    }

    function bindEvent(){
        form.on("select(province)",function(data){
            var selectProvinceID = data.value;
            var city = document.getElementById("city");
            $(city).empty();
            initCitiesSelect(selectProvinceID,false);
            form.render();
        });

        $(".logo-change").click(function(){
            $("#uploadFile").click();
        });

        $(".logo-reset").click(function(){
            mFiles = null;
            $(".logo-box img").attr('src', "images/defaultLogo.png");
            $AppVars.gOrganizations.item($AppVars.gLogin.organizationID).organizationLogo = "";
            logoReset = true;
        });

        $("#uploadFile").change(function(e) {
            mFiles = null;
            var files = Object.values(e.target.files);
            showImage(files[0]);
            mFiles = files[0];
            e.target.value = '';
            logoReset = false;
        });

        form.on("submit(formSubmit)",function(obj){
            var organizationMessageIsChange = false;
            if(change(obj)){
                organizationMessageIsChange = true;
                var organization = setOrganization(obj);
                var succ = function(){
                    $Utils.loading.close();
                    layer.closeAll();
                    if(!mFiles){
                        reloadSystem();
                    }
                };
                var fail = function(errorStatus,msg){
                    $Utils.loading.close();
                    $Utils.openWindow.failWindow("修改组织信息",errorStatus,msg);
                };
                $AppVars.gOrganizations.editItem(organization,true,succ,fail);
            }
            if(($AppVars.gOrganizations.item($AppVars.gLogin.organizationID).organizationLogo == null && mFiles) || ($AppVars.gOrganizations.item($AppVars.gLogin.organizationID).organizationLogo == "" && mFiles)){
                uploadLogo(organizationMessageIsChange);
            }else if(mFiles && mFiles.name != $AppVars.gOrganizations.item($AppVars.gLogin.organizationID).organizationLogo.split("images/logo/")[1]){
                uploadLogo(organizationMessageIsChange);
            }else{
                layer.closeAll();
            }
            return false;
        });

        $(".layui-btn-cancel").click(function(){
            layer.closeAll();
        });
    }

    function showImage(fileObj){
        var src = window.URL.createObjectURL(fileObj);
        $(".logo-image img").attr('src', src); 
    }

    function change(obj){
        if(obj.field.organizationName != $AppVars.gOrganizations.item($AppVars.gLogin.organizationID).organizationName){
            return true;
        }
        if(obj.field.organizationShortName != $AppVars.gOrganizations.item($AppVars.gLogin.organizationID).organizationShortName){
            return true;
        }
        if(obj.field.countryID != $AppVars.gOrganizations.item($AppVars.gLogin.organizationID).countryID){
            return true;
        }
        if(obj.field.provinceID != $AppVars.gOrganizations.item($AppVars.gLogin.organizationID).provinceID){
            return true;
        }
        if(obj.field.cityID != $AppVars.gOrganizations.item($AppVars.gLogin.organizationID).cityID){
            return true;
        }
        if(obj.field.contactPerson != $AppVars.gOrganizations.item($AppVars.gLogin.organizationID).contactPerson){
            return true;
        }
        if(obj.field.telephone != $AppVars.gOrganizations.item($AppVars.gLogin.organizationID).telephone){
            return true;
        }
        if(obj.field.mobileNumber != $AppVars.gOrganizations.item($AppVars.gLogin.organizationID).mobileNumber){
            return true;
        }
        if(obj.field.emailAddress != $AppVars.gOrganizations.item($AppVars.gLogin.organizationID).emailAddress){
            return true;
        }
        if(obj.field.systemName != $AppVars.gOrganizations.item($AppVars.gLogin.organizationID).systemName){
            return true;
        }
        if(logoReset && $AppVars.gOrganizations.item($AppVars.gLogin.organizationID).organizationLogo == ""){
            return true;
        }
        return false
    }

    function setOrganization(obj){
        var organization = new Organization();
        organization.organizationID = $AppVars.gOrganizations.item($AppVars.gLogin.organizationID).organizationID;
        organization.organizationCode = $AppVars.gOrganizations.item($AppVars.gLogin.organizationID).organizationCode;
        organization.organizationName = obj.field.organizationName;
        organization.organizationShortName = obj.field.organizationShortName;
        organization.contactPerson = obj.field.contactPerson;
        organization.telephone = obj.field.telephone;
        organization.mobileNumber = obj.field.mobileNumber;
        organization.emailAddress = obj.field.emailAddress;
        organization.countryID = obj.field.countryID;
        organization.provinceID = obj.field.provinceID;
        organization.cityID = obj.field.cityID;
        organization.organizationLogo = $AppVars.gOrganizations.item($AppVars.gLogin.organizationID).organizationLogo;
        organization.systemName = obj.field.systemName;

        return organization;
    }
    
    function uploadLogo(organizationMessageIsChange){
        var file = new FormData();
        file.append("organizationLogo", mFiles);
        var succ = function(data){
            mFiles = null;
            $Utils.loading.close();
            $AppVars.gOrganizations.item($AppVars.gLogin.organizationID).organizationLogo = data;
            reloadSystem();
            if(!organizationMessageIsChange){
                layer.closeAll();
            }
        };
        var fail = function(errorStatus,msg){
            $Utils.loading.close();
            $Utils.openWindow.failWindow("修改组织Logo",errorStatus,msg);
        };
        $AppVars.gOrganizations.item($AppVars.gLogin.organizationID).updateLogo(file,true,succ,fail);
    }

}();