/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-04-22 16:49:08
 * @LastEditTime: 2020-11-28 15:23:07
 * @LastModifyUser: 
 * @Remark: 
 */
!function(){
    var $ = layui.jquery, layer = layui.layer, form = layui.form;
    var bdaColorPalettes = new BDAColorPalettes();
    var isCloseWindow = true;

    getBDAColorPalettes();

    function getBDAColorPalettes(){
        var succ = function(){
            $Utils.loading.close();
            initForm();
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取调色板列表",errorStatus,msg);
		};
        bdaColorPalettes.getItems(true,succ,fail);
    }

    function initForm(){
        var pageWidth = Number($AppVars.gOrganizationSystemSettings.item("pageWidth").systemSettingValue);
        var pageHeight = Number($AppVars.gOrganizationSystemSettings.item("pageHeight").systemSettingValue);
        var scale = 0;
        if(pageWidth * 3 == pageHeight * 4){
            scale = 0;
        }else if(pageWidth * 9 == pageHeight * 16){
            scale = 1;
        }else if(pageWidth * 10 == pageHeight * 16){
            scale = 2;
        }else{
            scale = 3;
        }
        form.val("formWindow",{
            rowsOfQueryResult: $AppVars.gOrganizationSystemSettings.item("rowsOfQueryResult").systemSettingValue,
            queryTimeOut: $AppVars.gOrganizationSystemSettings.item("queryTimeOut").systemSettingValue,
            customLayoutForMobile: ($AppVars.gOrganizationSystemSettings.item("customLayoutForMobile").systemSettingValue == 1 ?true:false),
            directShowDataInChartForMobile: $AppVars.gOrganizationSystemSettings.item("directShowDataInChartForMobile")?(($AppVars.gOrganizationSystemSettings.item("directShowDataInChartForMobile").systemSettingValue == 1 ?true:false)):false,
            useNumericSymbols: ($AppVars.gOrganizationSystemSettings.item("useNumericSymbols").systemSettingValue == 1 ?true:false),
            pageWidth: $AppVars.gOrganizationSystemSettings.item("pageWidth").systemSettingValue,
            pageHeight: $AppVars.gOrganizationSystemSettings.item("pageHeight").systemSettingValue,
            defaultColorPaletteID: $AppVars.gOrganizationSystemSettings.item("defaultColorPaletteID").systemSettingValue,
            scale: scale,
            useCommentAsName: ($AppVars.gOrganizationSystemSettings.item("useCommentAsName")?($AppVars.gOrganizationSystemSettings.item("useCommentAsName").systemSettingValue==1?true:false):false),
            showFinanceReport: ($AppVars.gOrganizationSystemSettings.item("showFinanceReport")?($AppVars.gOrganizationSystemSettings.item("showFinanceReport").systemSettingValue==1?true:false):false),
            showFinanceIndex: ($AppVars.gOrganizationSystemSettings.item("showFinanceIndex")?($AppVars.gOrganizationSystemSettings.item("showFinanceIndex").systemSettingValue==1?true:false):false)
        });
        form.render();
        createColorBox($AppVars.gOrganizationSystemSettings.item("defaultColorPaletteID").systemSettingValue)
        

        bindEvent();
    }

    function createColorBox(paletteID){
        $(".color-content").html("");
        for(var i = 0; i < bdaColorPalettes.item(paletteID).colorSequence.length; i++){
            var color = bdaColorPalettes.item(paletteID).colorSequence[i];
            var str = "<span style='background-color:"+$Utils.csharp2rgba(color)+"'></span>";
            $(".color-content").append(str);
        }
    }

    function bindEvent(){
        form.on("select(scale)",function(data){
            var formData = form.val('formWindow');
            if(data.value == 0){
                var pageHeight = Math.round((Number(formData.pageWidth) * 3) / 4);
                $("input[name=pageHeight]").val(pageHeight);
            }
            if(data.value == 1){
                var pageHeight = Math.round((Number(formData.pageWidth) * 9) / 16);
                $("input[name=pageHeight]").val(pageHeight);
            }
            if(data.value == 2){
                var pageHeight = Math.round((Number(formData.pageWidth) * 10) / 16);
                $("input[name=pageHeight]").val(pageHeight);
            }
        });

        $(".input-value-empt").bind("input propertychange", function () {
            if (isNaN(parseFloat($(this).val())) || parseFloat($(this).val()) <= 0){
                $(this).val("");
            };
        })

        $("input[name=pageWidth]").bind("input propertychange", function () {
            var formData = form.val('formWindow');
            if(formData.scale == 0){
                var pageHeight = Math.round((Number(formData.pageWidth) * 3) / 4);
                if(isNaN(pageHeight)){
                    pageHeight = "";
                }
                $("input[name=pageHeight]").val(pageHeight);
            }
            if(formData.scale == 1){
                var pageHeight = Math.round((Number(formData.pageWidth) * 9) / 16);
                if(isNaN(pageHeight)){
                    pageHeight = "";
                }
                $("input[name=pageHeight]").val(pageHeight);
            }
            if(formData.scale == 2){
                var pageHeight = Math.round((Number(formData.pageWidth) * 10) / 16);
                if(isNaN(pageHeight)){
                    pageHeight = "";
                }
                $("input[name=pageHeight]").val(pageHeight);
            }
        });

        $("input[name=pageHeight]").bind("input propertychange", function () {
            var formData = form.val('formWindow');
            if(formData.scale == 0){
                var pageWidth = Math.round((Number(formData.pageHeight) * 4) / 3);
                if(isNaN(pageWidth)){
                    pageWidth = "";
                }
                $("input[name=pageWidth]").val(pageWidth);
            }
            if(formData.scale == 1){
                var pageWidth = Math.round((Number(formData.pageHeight) * 16) / 9);
                if(isNaN(pageWidth)){
                    pageWidth = "";
                }
                $("input[name=pageWidth]").val(pageWidth);
            }
            if(formData.scale == 2){
                var pageWidth = Math.round((Number(formData.pageHeight) * 16) / 10);
                if(isNaN(pageWidth)){
                    pageWidth = "";
                }
                $("input[name=pageWidth]").val(pageWidth);
            }
        });

        $(".color-change").click(function(){
            getAndLoadColorsForm();
        });

        $(".layui-btn-cancel").click(function(){
            layer.closeAll();
        });
        
        form.on("submit(formSubmit)",function(obj){
            if(change(obj)){
                $Utils.loading.open();
                var organizationSystemSettingsObj = setSettings(obj);
                var succ = function(){
                    $Utils.loading.close();
                    layer.closeAll();
                    $AppVars.queryTimeOut = $AppVars.gOrganizationSystemSettings.item("queryTimeOut").systemSettingValue;
                };
                var fail = function(errorStatus,msg){
                    $Utils.loading.close();
                    $Utils.openWindow.failWindow("修改选项",errorStatus,msg);
                };
                $AppVars.gOrganizationSystemSettings.update(organizationSystemSettingsObj,true,succ,fail);
            }else{
                if(isCloseWindow){
                    layer.closeAll();
                }
            }
            return false;
        });
    }

    function getAndLoadColorsForm(){
        $.ajax({
            url: "html/settings/colors.html",
            type: 'GET',
            success: function(data){
                loadColorsForm(data);
            }
        });
    }

    function loadColorsForm(strHtml){
        layer.open({
            type: 1,
            title: ["选择调色板","font-size: 14px"],
            btn: false,
            resize: false,
            area: ["500px","666px"],
            skin: "color-list-box",
            content: strHtml,
            success: function(layero,index){
                var formData = form.val('formWindow');
                initColorsListForm(index,formData.defaultColorPaletteID,bdaColorPalettes,updateDefaultColor);
            }
        });
    }

    function change(obj){
        isCloseWindow = true;
        if(obj.field.rowsOfQueryResult == ""){
            layer.msg("数据库查询结果集的大小限制不能为空。", {icon: 2});
            isCloseWindow = false;
            return false;
        }
        if(obj.field.queryTimeOut == ""){
            layer.msg("执行时间不能为空。", {icon: 2});
            isCloseWindow = false;
            return false;
        }
        if(obj.field.pageWidth == ""){
            layer.msg("宽度不能为空。", {icon: 2});
            isCloseWindow = false;
            return false;
        }
        if(obj.field.pageHeight == ""){
            layer.msg("高度不能为空。", {icon: 2});
            isCloseWindow = false;
            return false;
        }
        if(obj.field.rowsOfQueryResult != $AppVars.gOrganizationSystemSettings.item("rowsOfQueryResult").systemSettingValue){
            return true;
        }
        if(obj.field.queryTimeOut != $AppVars.gOrganizationSystemSettings.item("queryTimeOut").systemSettingValue){
            return true;
        }
        if(obj.field.pageWidth != $AppVars.gOrganizationSystemSettings.item("pageWidth").systemSettingValue){
            return true;
        }
        if(obj.field.pageHeight != $AppVars.gOrganizationSystemSettings.item("pageHeight").systemSettingValue){
            return true;
        }
        
        if(obj.field.customLayoutForMobile && $AppVars.gOrganizationSystemSettings.item("customLayoutForMobile").systemSettingValue == 0){
            return true;
        }
        if(!obj.field.customLayoutForMobile && $AppVars.gOrganizationSystemSettings.item("customLayoutForMobile").systemSettingValue == 1){
            return true;
        }

        if(obj.field.directShowDataInChartForMobile && $AppVars.gOrganizationSystemSettings.item("directShowDataInChartForMobile").systemSettingValue == 0){
            return true;
        }
        if(!obj.field.directShowDataInChartForMobile && $AppVars.gOrganizationSystemSettings.item("directShowDataInChartForMobile").systemSettingValue == 1){
            return true;
        }

        if(obj.field.useNumericSymbols && $AppVars.gOrganizationSystemSettings.item("useNumericSymbols").systemSettingValue == 0){
            return true;
        }
        if(!obj.field.useNumericSymbols && $AppVars.gOrganizationSystemSettings.item("useNumericSymbols").systemSettingValue == 1){
            return true;
        }

        if($AppVars.gOrganizationSystemSettings.item("useCommentAsName")){
            if(obj.field.useCommentAsName && $AppVars.gOrganizationSystemSettings.item("useCommentAsName").systemSettingValue == 0){
                return true;
            }
            if(!obj.field.useCommentAsName && $AppVars.gOrganizationSystemSettings.item("useCommentAsName").systemSettingValue == 1){
                return true;
            }
        }else{
            if(obj.field.useCommentAsName){
                return true;
            }
        }

        if($AppVars.gOrganizationSystemSettings.item("showFinanceReport")){
            if(obj.field.showFinanceReport && $AppVars.gOrganizationSystemSettings.item("showFinanceReport").systemSettingValue == 0){
                return true;
            }
            if(!obj.field.showFinanceReport && $AppVars.gOrganizationSystemSettings.item("showFinanceReport").systemSettingValue == 1){
                return true;
            }
        }else{
            if(obj.field.showFinanceReport){
                return true;
            }
        }

        if($AppVars.gOrganizationSystemSettings.item("showFinanceIndex")){
            if(obj.field.showFinanceIndex && $AppVars.gOrganizationSystemSettings.item("showFinanceIndex").systemSettingValue == 0){
                return true;
            }
            if(!obj.field.showFinanceIndex && $AppVars.gOrganizationSystemSettings.item("showFinanceIndex").systemSettingValue == 1){
                return true;
            }
        }else{
            if(obj.field.showFinanceIndex){
                return true;
            }
        }
        return false;
    }

    function setSettings(obj){
        var tempArr = [];
        var organizationSystemSetting = new OrganizationSystemSetting();
        organizationSystemSetting.systemSettingKey = "rowsOfQueryResult";
        organizationSystemSetting.systemSettingValue = obj.field.rowsOfQueryResult;
        tempArr.push(organizationSystemSetting);
        var organizationSystemSetting = new OrganizationSystemSetting();
        organizationSystemSetting.systemSettingKey = "queryTimeOut";
        organizationSystemSetting.systemSettingValue = obj.field.queryTimeOut;
        tempArr.push(organizationSystemSetting);
        var organizationSystemSetting = new OrganizationSystemSetting();
        organizationSystemSetting.systemSettingKey = "pageWidth";
        organizationSystemSetting.systemSettingValue = obj.field.pageWidth;
        tempArr.push(organizationSystemSetting);
        var organizationSystemSetting = new OrganizationSystemSetting();
        organizationSystemSetting.systemSettingKey = "pageHeight";
        organizationSystemSetting.systemSettingValue = obj.field.pageHeight;
        tempArr.push(organizationSystemSetting);
        var organizationSystemSetting = new OrganizationSystemSetting();
        organizationSystemSetting.systemSettingKey = "defaultColorPaletteID";
        organizationSystemSetting.systemSettingValue = obj.field.defaultColorPaletteID;
        tempArr.push(organizationSystemSetting);
        var organizationSystemSetting = new OrganizationSystemSetting();
        organizationSystemSetting.systemSettingKey = "customLayoutForMobile";
        organizationSystemSetting.systemSettingValue = obj.field.customLayoutForMobile?1:0;
        tempArr.push(organizationSystemSetting);
        var organizationSystemSetting = new OrganizationSystemSetting();
        organizationSystemSetting.systemSettingKey = "directShowDataInChartForMobile";
        organizationSystemSetting.systemSettingValue = obj.field.directShowDataInChartForMobile?1:0;
        tempArr.push(organizationSystemSetting);
        var organizationSystemSetting = new OrganizationSystemSetting();
        organizationSystemSetting.systemSettingKey = "useNumericSymbols";
        organizationSystemSetting.systemSettingValue = obj.field.useNumericSymbols?1:0;
        tempArr.push(organizationSystemSetting);
        var organizationSystemSetting = new OrganizationSystemSetting();
        organizationSystemSetting.systemSettingKey = "useCommentAsName";
        organizationSystemSetting.systemSettingValue = obj.field.useCommentAsName?1:0;
        tempArr.push(organizationSystemSetting);
        var organizationSystemSetting = new OrganizationSystemSetting();
        organizationSystemSetting.systemSettingKey = "showFinanceReport";
        organizationSystemSetting.systemSettingValue = obj.field.showFinanceReport?1:0;
        tempArr.push(organizationSystemSetting);
        var organizationSystemSetting = new OrganizationSystemSetting();
        organizationSystemSetting.systemSettingKey = "showFinanceIndex";
        organizationSystemSetting.systemSettingValue = obj.field.showFinanceIndex?1:0;
        tempArr.push(organizationSystemSetting);

        return tempArr;
    }
    
    var updateDefaultColor = function(colorPalette,index){
        layer.close(index);
        $("input[name=defaultColorPaletteID]").val(colorPalette.paletteID);
        createColorBox(colorPalette.paletteID);
    };

}();