/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-04-21 18:55:08
 * @LastEditTime: 2020-11-30 15:06:00
 * @LastModifyUser: 
 * @Remark: 
 */
!function(){
    var $ = layui.jquery, layer = layui.layer, form = layui.form;
    var organizationDateFormats = new OrganizationDateFormats();
    var days = ["yyyy-MM-dd","yyyy/MM/dd","yyyyMMdd"];
    var weeks = ["yyyy-ww","yyyy/ww","yyyyww"];
    var months = ["yyyy-MM","yyyy/MM","yyyyMM"];
    var quarters = ["yyyy-q","yyyy/q","yyyyq"];
    var years = ["yyyy"];

    form.render();
    getDateFormats();


    function getDateFormats(){
        var succ = function(){
            initForm();
        };
        var fail = function(errorStatus,msg){
            $Utils.openWindow.failWindow("获取组织缺省日期设置",errorStatus,msg);
        };
        organizationDateFormats.getItems(true,succ,fail);
    }

    function initForm(){
        var day = document.getElementById("day");
        for(var i = 0; i < days.length; i++){
            var option = document.createElement("option");
            option.setAttribute("value",days[i]);
            if(days[i] == organizationDateFormats.item("day").format){
                option.setAttribute("selected",true);
            }
            option.innerText = days[i];
            day.appendChild(option);
        }
        var week = document.getElementById("week");
        for(var i = 0; i < weeks.length; i++){
            var option = document.createElement("option");
            option.setAttribute("value",weeks[i]);
            if(weeks[i] == organizationDateFormats.item("week").format){
                option.setAttribute("selected",true);
            }
            option.innerText = weeks[i];
            week.appendChild(option);
        }
        var month = document.getElementById("month");
        for(var i = 0; i < months.length; i++){
            var option = document.createElement("option");
            option.setAttribute("value",months[i]);
            if(months[i] == organizationDateFormats.item("month").format){
                option.setAttribute("selected",true);
            }
            option.innerText = months[i];
            month.appendChild(option);
        }
        var quarter = document.getElementById("quarter");
        for(var i = 0; i < quarters.length; i++){
            var option = document.createElement("option");
            option.setAttribute("value",quarters[i]);
            if(quarters[i] == organizationDateFormats.item("quarter").format){
                option.setAttribute("selected",true);
            }
            option.innerText = quarters[i];
            quarter.appendChild(option);
        }
        var year = document.getElementById("year");
        for(var i = 0; i < years.length; i++){
            var option = document.createElement("option");
            option.setAttribute("value",years[i]);
            if(years[i] == organizationDateFormats.item("year").format){
                option.setAttribute("selected",true);
            }
            option.innerText = years[i];
            year.appendChild(option);
        }

        form.render();

        bindButtonEvent();
    }

    function bindButtonEvent(){
        $(".layui-btn-cancel").click(function(){
            layer.closeAll();
        });

        form.on("submit(formSubmit)",function(obj){
            if(change(obj)){
                var formatObj = setFormat(obj);
                var succ = function(){
                    layer.closeAll();
                };
                var fail = function(errorStatus,msg){
                    $Utils.openWindow.failWindow("修改组织缺省日期设置",errorStatus,msg);
                };
                organizationDateFormats.update(formatObj,true,succ,fail);
            }else{
                layer.closeAll();
            }
            return false;
        });
    }

    function change(obj){
        var tempArr = [];
        tempArr.push(obj.field.day);
        tempArr.push(obj.field.week);
        tempArr.push(obj.field.month);
        tempArr.push(obj.field.quarter);
        tempArr.push(obj.field.year);
        
        for(var i = 0; i < organizationDateFormats.count; i++){
            if(tempArr.indexOf(organizationDateFormats.item(i).format) == -1){
                return true;
            }
        }

        return false;
    }

    function setFormat(obj){
        var tempArr = [];
        organizationDateFormats.item("day").format = obj.field.day;
        organizationDateFormats.item("week").format = obj.field.week;
        organizationDateFormats.item("month").format = obj.field.month;
        organizationDateFormats.item("quarter").format = obj.field.quarter;
        organizationDateFormats.item("year").format = obj.field.year;

        for(var i = 0; i < organizationDateFormats.count; i++){
            tempArr.push(organizationDateFormats.item(i));
        }

        return tempArr;
    }

}();