/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-04-22 18:27:52
 * @LastEditTime: 2020-04-22 18:45:59
 * @LastModifyUser: 
 * @Remark: 
 */
!function(){
    var $ = layui.jquery, table = layui.table, layer = layui.layer, form = layui.form;
    
    window.initColorsListForm = function(index,paletteID,bdaColorPalettes,updateDefaultColor){
        initTable(bdaColorPalettes,paletteID);

        $(".layui-btn-determine").click(function(){
            var tableCheckData = table.checkStatus('colorList').data;
            updateDefaultColor(bdaColorPalettes.item(tableCheckData[0].paletteID),index);
        });

        $(".color-change-button .layui-btn-cancel").click(function(){
            layer.close(index);
        });
    };

    function initTable(bdaColorPalettes,paletteID){
        var tableHead = [
            [
                {type: "radio"},
                {field: "paletteName",title: "调色板名称"},
                {field: "colorSequence", title: "颜色序列", templet: function(d){
                    var str = "";
                    for(var i = 0; i < d.colorSequence.length; i++){
                        str += "<span style='background-color:"+$Utils.csharp2rgba(d.colorSequence[i])+"'></span>";
                    }
                    return ("<span class='color-sequence'>"+ str +"</span>");
                }}
            ]
        ];
        var tableBody = [];
        for(var i = 0; i < bdaColorPalettes.count; i++){
            var tempObj = {};
            for(var key in bdaColorPalettes.item(i)){
                if(typeof bdaColorPalettes.item(i)[key] === "function"){ continue;}
                tempObj[key] = bdaColorPalettes.item(i)[key];
                if(paletteID == bdaColorPalettes.item(i).paletteID){
                    tempObj.LAY_CHECKED = true;
                }
            }
            tableBody.push(tempObj);
        }
        table.render({
            elem: '#colorList',
            height: 540,
            cellMinWidth: 194, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: tableBody,
            cols: tableHead,
            toolbar: false,
            limit: 10
        });
    }
    
}();