import { currentDiagram } from "./components/bottomStatusBar_controller.js";
import initAddTablesDialog from "./dialogs/addTables_controller.js";
import {initTableValuesDialog, onFull, onRestore } from "./dialogs/tableValues_controller.js";
import initFieldVisibilityDialog from "./dialogs/fieldVisibility_controller.js";
import initTableAliasDialog from "./dialogs/tableAlias_controller.js";
import GUID from "./components/guid.js";
import initTableJoinDialog from "./dialogs/tableJoin_controller.js";
let mRelationDiagram = null;
let mRelationModel = null;
let mDatabaseLink = null;
let mLayuiObject = null;

let svgns = "http://www.w3.org/2000/svg";
let svger = null;

const TITLE_HEIGHT1 = 28;
const TITLE_HEIGHT2 = 46;
const FIELD_HEIGHT = 24;
const MORE_HEIGHT = 18;
const RESIZE_HEIGHT = 3;

const SCROLL_WIDTH = 10;

let MIDDLE_WIDTH = 0;
let MIDDLE_HEIGHT = 0;

let dragType;//"object","folder"
let dragObjectStr;

let useCommentAsName = false;

/**
 * 0:划线，1:改变位置
 */
let dragTypeEnum = -1;
let fieldDragObject = {};
let blockDragObject = {};

let copyingTableBlock;

bindEvent();
function initRelationDiagram(relationDiagram, relationModel, databaseLink, layuiObject) {
    $("#tbkDiagramName").html("");
    $(".relation-model-toolbar .center-button").hide();
    saveDiagramSize();//保存当前的大小
    clearDiagramCanvas();
    if(relationDiagram){
        $("#tbkDiagramName").html(relationDiagram.relationDiagramName);
        $(".relation-model-toolbar .center-button").show();
        MIDDLE_WIDTH = $(".middle-content").width();
        MIDDLE_HEIGHT = $(".middle-content").height() - 5;
        let systemSettings = new OrganizationSystemSettings();
        var succ = function () {
            if ("1" == systemSettings.item("useCommentAsName").systemSettingValue) {
                useCommentAsName = true;
            }
        };
        var fail = function (errorStatus, msg) {
            $Utils.loading.close();
            $Utils.openWindow.failWindow("获取组织设置", errorStatus, msg);
        };
        systemSettings.getItems(false, succ, fail);

        mRelationDiagram = relationDiagram;
        mRelationModel = relationModel;
        mDatabaseLink = databaseLink;
        mLayuiObject = layuiObject;
        currentDiagram(mRelationDiagram.relationDiagramName || "", mRelationDiagram.tableBlocks.count(), mRelationDiagram.tableJoins.count());


        
        let daigramCanvas = document.getElementById("daigramCanvas");
        // let svgcontainer = $("#daigramCanvas");
        
        
        svger = document.createElementNS(svgns, "svg");
        svger.setAttribute("class", "svg-map");
        svger.setAttribute("z-index", "-1");
        // svger.setAttribute("width", daigramCanvas.scrollWidth - SCROLL_WIDTH);
        // svger.setAttribute("height", daigramCanvas.scrollHeight - SCROLL_WIDTH);
        // svger.setAttribute("viewBox", "0 0 " + (daigramCanvas.scrollWidth - SCROLL_WIDTH) + " " + (daigramCanvas.scrollHeight - SCROLL_WIDTH));
        daigramCanvas.appendChild(svger);
        resetCurDiagramSize();

        let blockBorderStr = `<div id="blockBorder" class="box-hide"></div>`
        $("#daigramCanvas").append(blockBorderStr);

        $("#btnAddTable").addClass("button-color");
        $("#btnAddTableJoin").addClass("button-color");

        //把relationDiagram画到画布上
        loadRelationDiagram();
    }
}
function saveDiagramSize(){
    if(mRelationDiagram != null){
        let diagramCanvas = document.getElementById("daigramCanvas");
        mRelationDiagram.width = diagramCanvas.scrollWidth;
        mRelationDiagram.height = diagramCanvas.scrollHeight;
    }
}
function resetCurDiagramSize(){
    let diagramCanvas = document.getElementById("daigramCanvas");
    let diagramSize = calculateDiagramSize();
    
    $(diagramCanvas).css({
        width: diagramSize.width,
        height: diagramSize.height
    });
    svger.setAttribute("width", diagramSize.width);
    svger.setAttribute("height", diagramSize.height);
}

function calculateDiagramSize(){
    let size = {};
    let measureHeigth = 0;
    let measureWidth = 0;
    for(let i = 0; i < mRelationDiagram.tableBlocks.count(); i++){
        let tableBlock = mRelationDiagram.tableBlocks.item(i);
        if(tableBlock.y + tableBlock.height - measureHeigth > 0){
            measureHeigth = tableBlock.y + tableBlock.height + 50;
        }
        if(tableBlock.x + 100 - measureWidth > 0){//tableBlock.width的最小值是100
            measureWidth = tableBlock.x + 100 + 50;
        }
    }

    // size.width = Math.max(MIDDLE_WIDTH, measureWidth, mRelationDiagram.width);
    // size.height = Math.max(MIDDLE_HEIGHT, measureHeigth, mRelationDiagram.height);
    size.width = Math.max(MIDDLE_WIDTH, Math.min(measureWidth, mRelationDiagram.width));
    size.height = Math.max(MIDDLE_HEIGHT, Math.min(measureHeigth, mRelationDiagram.height));
    return size;
}

function loadRelationDiagram() {
    loadTableBlocks();
    loadTableJoins();
}

function loadTableBlocks() {
    for (let i = 0; i < mRelationDiagram.tableBlocks.count(); i++) {
        let tableBlock = mRelationDiagram.tableBlocks.item(i);
        drawTableBlock(tableBlock);
    }
}
function drawTableBlock(tableBlock) {
    let table = tableBlock.table;
    let stringBuilder = "";
    let haveHideField = false;
    let curHeight = 0;
    let maxFieldCount = 0;
    let showFieldCount = 0;

    let titleHieght = TITLE_HEIGHT1;
    let realName = "";
    if (tableBlock.tableAlias == tableBlock.table.tableName) {
        titleHieght = TITLE_HEIGHT1;
        realName = "";
    } else {
        titleHieght = TITLE_HEIGHT2;
        realName = `<br>（${tableBlock.table.tableName}）`;
    }
    curHeight += titleHieght;

    for (let j = 0; j < table.tableFields.count(); j++) {
        if (table.tableFields.item(j).visible) {
            let tableField = table.tableFields.item(j);
            maxFieldCount++;
            curHeight += FIELD_HEIGHT;
            if (curHeight > tableBlock.height) {
                curHeight -= FIELD_HEIGHT;
                stringBuilder += `<li class="field box-hide" draggable="true" comment="${tableField.commemt ? tableField.commemt : ""}" dataType="${tableField.dataType}">${tableField.fieldName}</li>`;
                haveHideField = true;
            } else {
                showFieldCount++;
                stringBuilder += `<li class="field" draggable="true" comment="${tableField.commemt ? tableField.commemt : ""}" dataType="${tableField.dataType}">${tableField.fieldName}</li>`;
            }
        } else {
            haveHideField = true;
            // haveNotvisible = true;
        }
    }
    if (haveHideField) {
        stringBuilder += `<li class="more" >...</li>`;
        curHeight += MORE_HEIGHT;
    }
    // if(haveNotvisible){
    //     maxHeight += MORE_HEIGHT;
    // }
    stringBuilder += `<li class="resize"></li>`;
    curHeight += RESIZE_HEIGHT;
    tableBlock.height = curHeight;
    // maxHeight += RESIZE_HEIGHT;

    let strHtml = `<div class="table-block" draggable="true" id="${tableBlock.tableBlockID}" maxFieldCount="${maxFieldCount}" showFieldCount="${showFieldCount}" style="left: ${tableBlock.x}px; top: ${tableBlock.y}px;">
            <h5 style="height:${titleHieght}px;">${tableBlock.tableAlias}${realName}</h5>
            <ul>${stringBuilder}</ul>
        </div>`;
    $("#daigramCanvas").append(strHtml);
}

function loadTableJoins() {

    for (let i = 0; i < mRelationDiagram.tableJoins.count(); i++) {
        let tableJoin = mRelationDiagram.tableJoins.item(i);
        drawTableJoin(tableJoin);
    }
}
function drawTableJoin(tableJoin, path) {
    let canvasTop = $("#daigramCanvas").offset().top;
    let canvasLeft = $("#daigramCanvas").offset().left;
    let tableBlock1 = mRelationDiagram.tableBlocks.getTableBlockByAlias(tableJoin.table1Alias);
    let tableBlock2 = mRelationDiagram.tableBlocks.getTableBlockByAlias(tableJoin.table2Alias);
    let eleBlock1 = $("#" + tableBlock1.tableBlockID);
    let eleBlock2 = $("#" + tableBlock2.tableBlockID);
    let width1 = eleBlock1.width() + 2;//边框宽度为1
    let top1 = eleBlock1.offset().top - canvasTop + getTableFieldHeight(tableJoin.table1Alias, tableJoin.table1Field1, eleBlock1.height() + 1);//上边框1+标题上padding4
    let top12 = -1;
    if (tableJoin.table1Field2) {
        top12 = eleBlock1.offset().top - canvasTop + getTableFieldHeight(tableJoin.table1Alias, tableJoin.table1Field2, eleBlock1.height() + 1);
    }
    let left1 = eleBlock1.offset().left - canvasLeft;
    let width2 = eleBlock2.width() + 2;
    let top2 = eleBlock2.offset().top - canvasTop + getTableFieldHeight(tableJoin.table2Alias, tableJoin.table2Field1, eleBlock2.height() + 1);
    let top22 = -1;
    if (tableJoin.table2Field2) {
        top22 = eleBlock2.offset().top - canvasTop + getTableFieldHeight(tableJoin.table2Alias, tableJoin.table2Field2, eleBlock2.height() + 1);
    }
    let left2 = eleBlock2.offset().left - canvasLeft;

    let leftPoint = {};
    let leftPoint2 = null;
    let rightPoint = {};
    let rightPoint2 = null;
    let leftMore = false;
    let rightMore = false;
    if (left1 < left2) {
        leftPoint.x = left1 + width1;
        leftPoint.y = top1;
        if (top12 != -1) {
            leftPoint2 = {};
            leftPoint2.x = left1 + width1;
            leftPoint2.y = top12;
        }

        rightPoint.x = left2;
        rightPoint.y = top2;
        if (top22 != -1) {
            rightPoint2 = {};
            rightPoint2.x = left2;
            rightPoint2.y = top22;
        }

        if (tableJoin.cardinality == 1) {
            rightMore = true;
        } else if (tableJoin.cardinality == 2) {
            leftMore = true;
        } else if (tableJoin.cardinality == 3) {
            leftMore = true;
            rightMore = true;
        }

    } else {
        leftPoint.x = left2 + width2;
        leftPoint.y = top2;
        if (top22 != -1) {
            leftPoint2 = {};
            leftPoint2.x = left2 + width2;
            leftPoint2.y = top22;
        }

        rightPoint.x = left1;
        rightPoint.y = top1;
        if (top12 != -1) {
            rightPoint2 = {};
            rightPoint2.x = left1;
            rightPoint2.y = top12;
        }

        if (tableJoin.cardinality == 1) {
            leftMore = true;
        } else if (tableJoin.cardinality == 2) {
            rightMore = true;
        } else if (tableJoin.cardinality == 3) {
            leftMore = true;
            rightMore = true;
        }

    }
    if (!path) {
        path = document.createElementNS(svgns, "path");
    }
    let pathBuilder = [];
    pathBuilder.push("M " + leftPoint.x + " " + leftPoint.y + ",L" + (leftPoint.x + 10) + " " + leftPoint.y);
    if (leftMore) {
        pathBuilder.push("M " + leftPoint.x + " " + (leftPoint.y + 5) + ",L" + (leftPoint.x + 10) + " " + leftPoint.y);
        pathBuilder.push("M " + leftPoint.x + " " + (leftPoint.y - 5) + ",L" + (leftPoint.x + 10) + " " + leftPoint.y);
    }
    if (leftPoint2) {
        pathBuilder.push("M " + leftPoint2.x + " " + leftPoint2.y + ",L" + (leftPoint2.x + 10) + " " + leftPoint2.y);
        if (leftMore) {
            pathBuilder.push("M " + leftPoint2.x + " " + (leftPoint2.y + 5) + ",L" + (leftPoint2.x + 10) + " " + leftPoint2.y);
            pathBuilder.push("M " + leftPoint2.x + " " + (leftPoint2.y - 5) + ",L" + (leftPoint2.x + 10) + " " + leftPoint2.y);
        }
    }
    if (leftPoint2 || rightPoint2) {
        //确定中点
        let centerPoint = {};
        centerPoint.x = (leftPoint.x + rightPoint.x) / 2;
        let sum = 0;
        let count = 2;
        sum += leftPoint.y;
        sum += rightPoint.y;
        if (leftPoint2 && rightPoint2) {
            sum += leftPoint2.y;
            count++;
            sum += rightPoint2.y;
            count++;
        } else if (leftPoint2) {
            sum += leftPoint2.y;
            sum += rightPoint.y;
            count += 2;
        } else if (rightPoint2) {
            sum += rightPoint2.y;
            sum += leftPoint.y;
            count += 2;
        }

        centerPoint.y = sum / count;
        pathBuilder.push("L" + centerPoint.x + " " + centerPoint.y);
        if (leftPoint2) {
            pathBuilder.push("L" + (leftPoint.x + 10) + " " + leftPoint.y);
            pathBuilder.push("M" + centerPoint.x + " " + centerPoint.y);
        }
        if (rightPoint2) {
            pathBuilder.push("L" + (rightPoint2.x - 10) + " " + rightPoint2.y);
            pathBuilder.push("M" + centerPoint.x + " " + centerPoint.y);
        }
    }
    pathBuilder.push("L" + (rightPoint.x - 10) + " " + rightPoint.y);

    pathBuilder.push("L" + rightPoint.x + " " + rightPoint.y);
    if (rightMore) {
        pathBuilder.push("M" + (rightPoint.x - 10) + " " + rightPoint.y + ",L" + rightPoint.x + " " + (rightPoint.y + 5));
        pathBuilder.push("M" + (rightPoint.x - 10) + " " + rightPoint.y + ",L" + rightPoint.x + " " + (rightPoint.y - 5));
    }
    if (rightPoint2) {
        pathBuilder.push("M" + (rightPoint2.x - 10) + " " + rightPoint2.y + ",L" + rightPoint2.x + " " + rightPoint2.y);
        if (rightMore) {
            pathBuilder.push("M" + (rightPoint2.x - 10) + " " + rightPoint2.y + ",L" + rightPoint2.x + " " + (rightPoint2.y + 5));
            pathBuilder.push("M" + (rightPoint2.x - 10) + " " + rightPoint2.y + ",L" + rightPoint2.x + " " + (rightPoint2.y - 5));
        }
    }
    path.setAttribute("d", pathBuilder.join(","));
    path.setAttribute("class", "table-join");
    path.setAttribute("id", tableJoin.tableJoinID);
    // path.setAttribute("stroke", "#666");
    // path.setAttribute("stroke-width", "2");
    // path.setAttribute("fill", "none");
    svger.appendChild(path);
}
/**
 * 清除画板
 */
function clearDiagramCanvas() {
    $("#daigramCanvas").html("");
}

function getTableFieldHeight(tableAlias, fieldName, height) {

    let tableBlock = mRelationDiagram.tableBlocks.getTableBlockByAlias(tableAlias);
    let y = 1;//上边框高度为1
    if (tableBlock.tableAlias == tableBlock.table.tableName) {
        y += TITLE_HEIGHT1;
    } else {
        y += TITLE_HEIGHT2;
    }
    let tableFields = tableBlock.table.tableFields;
    let haveField = false;
    for (let i = 0; i < tableFields.count(); i++) {
        if (tableFields.item(i).visible) {
            y += FIELD_HEIGHT;
            if (y > height) {
                y = height - RESIZE_HEIGHT - MORE_HEIGHT / 2;
                return y;
            }
            if (fieldName == tableFields.item(i).fieldName) {
                y -= FIELD_HEIGHT / 2;
                haveField = true;
                break;
            }
        }
    }
    if (!haveField) {
        y += MORE_HEIGHT / 2;
    }
    if (y > height) {
        y = height - RESIZE_HEIGHT - MORE_HEIGHT / 2;
    }
    return y;
}



let lastMousedownTime;
let selectedBlockView;//选中的tableBlock
let selectedJoinView;//选中的tableBlock
function bindEvent() {
    //#region 按钮事件
    $("#btnAddTable").click(function () {
        insertTable();

    });

    $("#btnAddTableJoin").click(function () {
        $.ajax({
            url: "dialogs/tableJoin.html",
            type: "GET",
            success: function (data) {
                layer.open({
                    type: 1,
                    title: ["表连接属性", "font-size: 14px"],
                    btn: false,
                    resize: false,
                    area: ["560px", "680px"],
                    content: data,
                    success: function (layero, index) {
                        let tableJoin = new TableJoin();
                        initTableJoinDialog(index, mLayuiObject, 0, tableJoin, mRelationDiagram.tableBlocks, mDatabaseLink, function () {
                            mRelationDiagram.tableJoins.add(tableJoin);
                            drawTableJoin(tableJoin);
                            currentDiagram(mRelationDiagram.relationDiagramName || "", mRelationDiagram.tableBlocks.count(), mRelationDiagram.tableJoins.count());
                            return true;
                        });
                    }
                });
            }
        });
    });

    $("#btnTableJoinsAttribute").click(function () {
        if (selectedJoinView) {
            editTableJoin();
        }
    });
    $("#btnDeleteTableOrTableJoins").click(function () {
        if (selectedJoinView) {
            deleteTableJoin();
        } else if (selectedBlockView) {
            deleteTableBlock();
        }
    });
    //#endregion

    //#region 上下文菜单
    $(".canvas-box").on("mousedown", function (e) {
        // console.log("mousedown");
        if ($(e.target).parents().hasClass("table-block")) {
            // selectBlock($(e.target).parents().find(".table-block"));
            selectBlock($(e.target).parents(".table-block"));
        } else {
            unselectBlock();
        }
        let code = e.which;//判断是单机了鼠标哪个键(1,2,3)
        if (code == 3) {
            $(".diagram-contextmenu").hide();
            $(".middle-contextmenu ul li").addClass("hide-li");
            // $(".middle-contextmenu ul").removeClass("hide-li");
            let menuItems = $(".middle-contextmenu ul li");
            if ($(e.target).parents().hasClass("table-block")) {
                menuItems.eq(0).removeClass("hide-li");
                menuItems.eq(1).removeClass("hide-li");
                menuItems.eq(2).removeClass("hide-li");
                menuItems.eq(4).removeClass("hide-li");
                menuItems.eq(5).removeClass("hide-li");
                menuItems.eq(6).removeClass("hide-li");
                menuItems.eq(7).removeClass("hide-li");
                let blockID = selectedBlockView.attr("id");
                let tableBlock = mRelationDiagram.tableBlocks.item(blockID);
                menuItems.eq(8 + tableBlock.fieldSort).addClass("selected");
                menuItems.eq(8).removeClass("hide-li");
                menuItems.eq(9).removeClass("hide-li");
                menuItems.eq(10).removeClass("hide-li");
                // console.log("右键表块");
            } else if (e.target.tagName == "path") {
                menuItems.eq(3).removeClass("hide-li");
                menuItems.eq(4).removeClass("hide-li");
                // console.log("右键表连接");
            } else {
                menuItems.eq(11).removeClass("hide-li");
                menuItems.eq(12).removeClass("hide-li");
                // console.log("右键空白处");
            }
            setBoxStyle(e);
            $(".middle-contextmenu li").off("click").on("click", function () {
                if ($(this).attr("data-code") == 0) {//查看表值
                    loadTableValues();
                } else if ($(this).attr("data-code") == 1) {//别名
                    if (selectedBlockView) {
                        setTableAlias();
                    }
                } else if ($(this).attr("data-code") == 2) {//复制
                    if (selectedBlockView) {
                        copyBlock();
                    }
                } else if ($(this).attr("data-code") == 3) {//属性
                    if (selectedJoinView) {
                        editTableJoin();
                    }
                } else if ($(this).attr("data-code") == 4) {//删除
                    if (selectedJoinView) {
                        deleteTableJoin();
                    } else if (selectedBlockView) {
                        deleteTableBlock();
                    }
                } else if ($(this).attr("data-code") == 5) {//字段可见性
                    if (selectedBlockView) {
                        setFieldVisibility();
                    }

                } else if ($(this).attr("data-code") == 6) {//字段排序

                } else if ($(this).attr("data-code") == "6-1") {//数据库排序
                    if (selectedBlockView) {
                        resortTableFields(0);
                    }
                } else if ($(this).attr("data-code") == "6-2") {//顺序
                    if (selectedBlockView) {
                        resortTableFields(1);
                    }
                } else if ($(this).attr("data-code") == "6-3") {//降序
                    if (selectedBlockView) {
                        resortTableFields(2);
                    }
                } else if ($(this).attr("data-code") == 7) {//刷新
                    //通过表名重新去服务器拿取表字段
                    if (selectedBlockView) {
                        resortTableFields(0);
                    }
                } else if ($(this).attr("data-code") == 8) {//插入表
                    insertTable();
                } else if ($(this).attr("data-code") == 9) {//粘贴
                    if (copyingTableBlock) {
                        pasteTableBlock({ left: e.pageX - $("#daigramCanvas").offset().left, top: e.pageY - $("#daigramCanvas").offset().top });
                    }
                }
                $(".diagram-contextmenu").hide();
            });
            e.stopPropagation();
        }
    });
    //#endregion
    $("#daigramCanvas").resize(function(){
        let daigramCanvas = document.getElementById("daigramCanvas");
        svger.setAttribute("width", daigramCanvas.clientWidth - SCROLL_WIDTH);
        svger.setAttribute("height", daigramCanvas.clientHeight - SCROLL_WIDTH);
        // svger.setAttribute("viewBox", "0 0 " + (daigramCanvas.clientWidth - SCROLL_WIDTH) + " " + (daigramCanvas.clientHeight - SCROLL_WIDTH));
    });
    
    $(".canvas-box").on("mousedown", ".table-join", function (e) {
        // console.log("table-join mousedown");
        let time = new Date().getTime();
        if (time - lastMousedownTime < 300) {
            editTableJoin();
            lastMousedownTime = -1;
            return;
        }
        lastMousedownTime = time;

        selectJoin($(this));
    });
    $(".canvas-box").on("dragstart", ".table-block ul li.field", function (e) {
        console.log("field dragstart");
        let crt = this.cloneNode(true);
        crt.style.backgroundColor = "red";
        e.originalEvent.dataTransfer.setDragImage(crt, 0, 0);

        dragTypeEnum = 0;
        dragObjectStr = "";
        dragType = "";
        fieldDragObject = {};
        fieldDragObject.canvasTop = $("#daigramCanvas").offset().top;
        fieldDragObject.canvasLeft = $("#daigramCanvas").offset().left;
        let scrollTop = $(".middle-content").scrollTop();
        let scrollLeft = $(".middle-content").scrollLeft();

        fieldDragObject.tempPath = document.createElementNS(svgns, "path");
        fieldDragObject.tempPath.setAttribute("stroke", "black");
        fieldDragObject.tempPath.setAttribute("stroke-width", "1");
        fieldDragObject.tempPath.setAttribute("fill", "none");
        fieldDragObject.fieldView = $(this);
        selectBlock($(this).parent().parent())
        let position = selectedBlockView.position();
        fieldDragObject.blockID = selectedBlockView.attr("id");
        fieldDragObject.tableBlock = mRelationDiagram.tableBlocks.item(fieldDragObject.blockID);

        fieldDragObject.leftX = position.left + scrollLeft;
        fieldDragObject.rightX = fieldDragObject.leftX + selectedBlockView.width() + 2;//边框宽度为1
        fieldDragObject.centerX = fieldDragObject.leftX + selectedBlockView.width() / 2 + 1;//边框宽度为1
        fieldDragObject.startY = position.top + scrollTop + $(this).position().top + FIELD_HEIGHT / 2;
        fieldDragObject.field = $(this).html();
        let tableField = new TableField();
        tableField.fieldName = fieldDragObject.fieldView.html();
        tableField.comment = fieldDragObject.fieldView.attr("comment");
        tableField.dataType = fieldDragObject.fieldView.attr("dataType");
        tableField.visible = true;

        let businessObject = createBOByTableField(tableField, fieldDragObject.tableBlock.tableAlias);
        dragObjectStr = JSON.stringify(businessObject);
        dragType = "object";

        e.originalEvent.dataTransfer.setData(dragType, dragObjectStr);

        fieldDragObject.drawLine = true;
        e.stopPropagation();
    });
    $("body").on("dragend", ".table-block ul li.field", function (e) {
        // console.log("field dragend");
        if(dragTypeEnum == 0){
            fieldDragObject.drawLine = false;
            fieldDragObject.tempPath.remove();
        }
        dragTypeEnum = -1;
    });
    $(".canvas-box")[0].ondragover = function (e) {
        if (dragTypeEnum == 0) {
            if (fieldDragObject.drawLine) {
                // console.log("field dragover");
                let stringBuilder = [];
                let X = e.pageX - fieldDragObject.canvasLeft;
                let Y = e.pageY - fieldDragObject.canvasTop;

                if (X < fieldDragObject.centerX) {
                    stringBuilder.push("M " + fieldDragObject.leftX + " " + fieldDragObject.startY + ",L " + (fieldDragObject.leftX - 10) + " " + fieldDragObject.startY);
                } else {
                    stringBuilder.push("M " + fieldDragObject.rightX + " " + fieldDragObject.startY + ",L " + (fieldDragObject.rightX + 10) + " " + fieldDragObject.startY);
                }
                stringBuilder.push("L " + X + " " + Y);
                fieldDragObject.tempPath.setAttribute("d", stringBuilder.join(","));
                svger.appendChild(fieldDragObject.tempPath);
            }

        } else if (dragTypeEnum == 1) {
            // blockDragObject.blockBorder.css({
            //     "left": blockDragObject.position.left + (e.pageX - blockDragObject.startX),
            //     "top": blockDragObject.position.top + (e.pageY - blockDragObject.startY),
            // });
        }
        e.preventDefault();
    };
    $(".canvas-box")[0].ondrop = function (e) {
        if (dragTypeEnum == 0) {
            // console.log("field drop");
            fieldDragObject.tempPath.remove();
            let field2View = $(e.target);
            //如果当前位置是表字段，生成tableJoin
            if (field2View.hasClass("field")) {
                let alias1 = fieldDragObject.tableBlock.tableAlias;
                let field1 = fieldDragObject.field;
                let blockID2 = field2View.parent().parent().attr("id");
                let block2 = mRelationDiagram.tableBlocks.item(blockID2);
                let alias2 = block2.tableAlias;
                let field2 = field2View.html();
                if (alias1 != alias2) {
                    let tableJoin = new TableJoin();
                    tableJoin.tableJoinID = new GUID().newGUID();
                    tableJoin.table1Alias = alias1;
                    tableJoin.table2Alias = alias2;
                    tableJoin.table1Field1 = field1;
                    tableJoin.table2Field1 = field2;
                    tableJoin.joinType = 0;
                    tableJoin.expression = `${alias1}.${field1} = ${alias2}.${field2}`;
                    mRelationDiagram.tableJoins.add(tableJoin);
                    drawTableJoin(tableJoin);
                }
                currentDiagram(mRelationDiagram.relationDiagramName || "", mRelationDiagram.tableBlocks.count(), mRelationDiagram.tableJoins.count());
            }
        } else if (dragTypeEnum == 1) {
            // console.log("block drop");
            let blockID = selectedBlockView.attr('id');
            let tableBlock = mRelationDiagram.tableBlocks.item(blockID);
            let endX = e.pageX - blockDragObject.canvasLeft;
            let endY = e.pageY - blockDragObject.canvasTop;

            tableBlock.x = endX - blockDragObject.titleLeft + $(".middle-content").scrollLeft();
            tableBlock.y = endY - blockDragObject.titleTop + $(".middle-content").scrollTop();
            selectedBlockView.css({
                "left": tableBlock.x,
                "top": tableBlock.y,
            });
            //重新绘制相关的tableJoins
            for (let i = 0; i < mRelationDiagram.tableJoins.count(); i++) {
                let tableJoin = mRelationDiagram.tableJoins.item(i);
                if (tableJoin.table1Alias == tableBlock.tableAlias || tableJoin.table2Alias == tableBlock.tableAlias) {
                    drawTableJoin(tableJoin, $("#" + tableJoin.tableJoinID)[0]);
                }

            }

            
        }
    };
    $(".canvas-box").on("dblclick", ".table-block h5", function (e) {
        // console.log("h5 dblclick");
        blockDoubleClick($(this).parent());
    });
    $(".canvas-box").on("dragstart", ".table-block", function (e) {
        console.log("block dragstart");
        dragTypeEnum = 1;
        blockDragObject = {};
        blockDragObject.canvasTop = $("#daigramCanvas").offset().top;
        blockDragObject.canvasLeft = $("#daigramCanvas").offset().left;
        selectBlock($(this));
        blockDragObject.position = selectedBlockView.position();
        blockDragObject.titleLeft = e.originalEvent.pageX - blockDragObject.position.left - blockDragObject.canvasLeft;
        blockDragObject.titleTop = e.originalEvent.pageY - blockDragObject.position.top - blockDragObject.canvasTop;

        dragObjectStr = JSON.stringify(createBusinessObjectFolderByBlock(selectedBlockView));
        dragType = "folder";

        e.originalEvent.dataTransfer.setData(dragType, dragObjectStr);
        e.stopPropagation();
    });
    $("body").on("dragover", function (e) {
        if (!$(e.target).hasClass("middle-content") && !$(e.target).parents().hasClass("middle-content")) {
            if(dragTypeEnum == 0){
                fieldDragObject.drawLine = false;
                fieldDragObject.tempPath.remove();
                dragTypeEnum = -1;
            }else if(dragTypeEnum == 1){
                let daigramCanvas = document.getElementById("daigramCanvas");
                if(e.originalEvent.pageX > $(window).width()- $(".middle-right").width()){
                    $(daigramCanvas).css({width: daigramCanvas.clientWidth + 2 });
                    $(".middle-content").scrollLeft(daigramCanvas.clientWidth);
                }
                if(e.originalEvent.pageY > $(window).height() - 25){//25为状态栏高度
                    $(daigramCanvas).css({height: daigramCanvas.clientHeight + 2 });
                    $(".middle-content").scrollTop(daigramCanvas.clientHeight);
                }
            }
            
        }
    });
    $("body").on("mousedown", ".table-block", function (e) {
        console.log("block mousedown");
        selectBlock($(this));
    });
    $(".canvas-box").on("mousedown", ".table-block ul li.resize", function (e) {
        console.log("resize mousedown");
        e.stopPropagation();
        let canvasTop = $("#daigramCanvas").offset().top;
        let canvasLeft = $("#daigramCanvas").offset().left;


        selectBlock($(this).parent().parent());
        let ulView = $(this).parent();
        let position = selectedBlockView.position();
        let blockID = selectedBlockView.attr("id");
        let tableBlock = mRelationDiagram.tableBlocks.item(blockID);


        let blockBorder = $("#blockBorder");
        let left = selectedBlockView.offset().left - canvasLeft;
        let top = selectedBlockView.offset().top - canvasTop;
        let titleHeight = tableBlock.tableAlias == tableBlock.table.tableName ? TITLE_HEIGHT1 : TITLE_HEIGHT2;
        let minHeight = titleHeight + FIELD_HEIGHT;
        let maxCount = parseInt(selectedBlockView.attr("maxFieldCount"));
        let maxHeight = titleHeight + maxCount * FIELD_HEIGHT;
        if (maxCount < tableBlock.table.tableFields.count()) {
            maxHeight += MORE_HEIGHT;
        }
        blockBorder.removeClass("box-hide").css({
            left: left - 1,
            top: top - 1,
            width: selectedBlockView.width(),
            height: selectedBlockView.height()
        });

        $(document.body).mousemove(function (e) {
            let height = e.pageY - canvasTop - top;
            if (height > maxHeight) {
                height = maxHeight;
            }
            if (height < minHeight) {
                height = minHeight;
            }
            blockBorder.css({
                height: height
            });
        });

        $(document.body).mouseup(function (e) {
            blockBorder.addClass("box-hide");
            $(document.body).off('mouseup');
            $(document.body).off('mousemove');
            let endY = e.pageY - canvasTop;
            let h = endY - position.top - ulView.position().top;
            let maxFieldCount = parseInt(selectedBlockView.attr("maxFieldCount"));
            let fieldCount = Math.min(Math.max(1, Math.round(h / FIELD_HEIGHT)), maxFieldCount);
            let showFieldCount = parseInt(selectedBlockView.attr("showFieldCount"));

            if (fieldCount != showFieldCount) {
                ulView.find("li.field").each(function () {
                    if ($(this).index() >= fieldCount) {
                        $(this).css({
                            "display": "none"
                        });
                    } else {
                        $(this).css({
                            "display": "block"
                        });
                    }
                });
                if (fieldCount >= tableBlock.table.tableFields.count()) {
                    ulView.find("li.more").css({
                        "display": "none"
                    });
                } else {
                    ulView.find("li.more").css({
                        "display": "block"
                    });
                }
                selectedBlockView.attr("showFieldCount", fieldCount);
                tableBlock.height = blockBorder.height();
                //重新绘制相关的tableJoins
                for (let i = 0; i < mRelationDiagram.tableJoins.count(); i++) {
                    let tableJoin = mRelationDiagram.tableJoins.item(i);
                    if (tableJoin.table1Alias == tableBlock.tableAlias || tableJoin.table2Alias == tableBlock.tableAlias) {
                        drawTableJoin(tableJoin, $("#" + tableJoin.tableJoinID)[0]);
                    }

                }
            }

        });
    });

}

function resortTableFields(sortType) {
    let blockID = selectedBlockView.attr("id");
    let tableBlock = mRelationDiagram.tableBlocks.item(blockID);
    let table = tableBlock.table;
    let tableFields = table.tableFields;
    if (sortType == 0) {//数据库顺序
        //需要对比可见性
        let visibilityMap = new HashTable();
        for (let i = 0; i < tableFields.count(); i++) {
            visibilityMap.add(tableFields.item(i).fieldName, tableFields.item(i).visible);
        }

        let tmpTables = new Tables();
        tmpTables.add(table);
        tmpTables.getTableFields(mDatabaseLink.dataSourceID, false, function () {
            for (let i = 0; i < table.tableFields.count(); i++) {
                if (visibilityMap.containsKey(table.tableFields.item(i).fieldName)) {
                    table.tableFields.item(i).visible = visibilityMap.getValue(table.tableFields.item(i).fieldName);
                }
            }
        }, function (errorStatus, errorMsg) { $Utils.openWindow.failWindow("获取表字段", errorStatus, errorMsg); });
    } else if (sortType == 1) {//升序
        tableFields.resortOrderByAsc();
    } else if (sortType == 2) {//降序
        tableFields.resortOrderByDesc();
    }

    //重画
    selectedBlockView.remove();
    drawTableBlock(tableBlock);
    selectBlock($("#" + blockID));
    //重新绘制相关的tableJoins
    for (let i = 0; i < mRelationDiagram.tableJoins.count(); i++) {
        let tableJoin = mRelationDiagram.tableJoins.item(i);
        if (tableJoin.table1Alias == tableBlock.tableAlias || tableJoin.table2Alias == tableBlock.tableAlias) {
            drawTableJoin(tableJoin, $("#" + tableJoin.tableJoinID)[0]);
        }
    }
}
function pasteTableBlock(position) {
    let newTableBlock = new TableBlock();
    let strBlock = JSON.stringify(copyingTableBlock);
    newTableBlock.init(JSON.parse(strBlock));
    newTableBlock.tableBlockID = new GUID().newGUID();
    let alias = copyingTableBlock.tableAlias;
    if (mRelationDiagram.relationDiagramType == 0) {
        alias = mRelationModel.getDimensionDiagrams().getDefaultTableAlias(alias);
    } else {
        alias = mRelationDiagram.getDefaultTableAlias(alias);
    }
    newTableBlock.tableAlias = alias;
    newTableBlock.x = position.left;
    newTableBlock.y = position.top;
    mRelationDiagram.tableBlocks.add(newTableBlock);
    drawTableBlock(newTableBlock);
    
    currentDiagram(mRelationDiagram.relationDiagramName || "", mRelationDiagram.tableBlocks.count(), mRelationDiagram.tableJoins.count());
}

function copyBlock() {
    let blockID = selectedBlockView.attr("id");
    copyingTableBlock = mRelationDiagram.tableBlocks.item(blockID);
}
function insertTable() {
    let tables = new Tables();
    if (mDatabaseLink != null) {
        tables.getItems(mDatabaseLink.dataSourceID, false, function () {
            $.ajax({
                url: "dialogs/addTables.html",
                type: 'GET',
                success: function (data) {
                    layer.open({
                        type: 1,
                        title: ["选择表", "font-size: 14px"],
                        btn: false,
                        resize: false,
                        area: ["480px", "640px"],
                        content: data,
                        success: function (layero, index) {
                            initAddTablesDialog(index, mLayuiObject, tables, function (selectedTables) {
                                //获取tableFields
                                insertTables(selectedTables);
                                
                                currentDiagram(mRelationDiagram.relationDiagramName || "", mRelationDiagram.tableBlocks.count(), mRelationDiagram.tableJoins.count());
                                return true;
                            });
                        }
                    });
                }
            });
        }, function (errorStatus, errorMsg) { $Utils.openWindow.failWindow("获取表", errorStatus, errorMsg); });
    } else {
        alert("缺少数据库连接。");
    }
}
function deleteTableJoin() {
    //弹出询问框
    layer.open({
        type: 0,
        title: "删除表连接",
        closeBtn: 1,
        shadeClose: true,
        resize: false,
        area: ["480px", "270px"],
        skin: "delete-window",
        content: "<div class='fail-box enquire-box clearfix'><div class='fl fail-icon enquire-icon'><i class='iconfont bda-xunwen'></i></div><div class='fr fail-content'>" + "是否删除表连接？" + "</div></div>",
        btn: ["是", "否"],
        // success: function(layero,index){
        //     $(layero).find('.layui-layer-content').css('height','137px');
        // },
        yes: function (index, layero) {
            let joinID = selectedJoinView.attr("id");
            let tableJoin = mRelationDiagram.tableJoins.item(joinID);
            mRelationDiagram.tableJoins.remove(tableJoin);
            selectedJoinView.remove();
            selectedJoinView = null;

            currentDiagram(mRelationDiagram.relationDiagramName || "", mRelationDiagram.tableBlocks.count(), mRelationDiagram.tableJoins.count());
            layer.close(index);
        }
    });
}
function deleteTableBlock() {
    let blockID = selectedBlockView.attr("id");
    let tableBlock = mRelationDiagram.tableBlocks.item(blockID);
    layer.open({
        type: 0,
        title: "删除表块",
        closeBtn: 1,
        shadeClose: true,
        resize: false,
        area: ["480px", "270px"],
        skin: "delete-window",
        content: `<div class='fail-box enquire-box clearfix'><div class='fl fail-icon enquire-icon'><i class='iconfont bda-xunwen'></i></div><div class='fr fail-content'>是否删除表 ${tableBlock.tableAlias} 以及所有与之相连的表连接吗？</div></div>`,
        btn: ["是", "否"],
        // success: function(layero,index){
        //     $(layero).find('.layui-layer-content').css('height','137px');
        // },
        yes: function (index, layero) {
            mRelationDiagram.tableBlocks.remove(tableBlock);
            selectedBlockView.remove();
            selectedBlockView = null;

            let tableAlias = tableBlock.tableAlias;
            for (let i = mRelationDiagram.tableJoins.count() - 1; i >= 0; i--) {
                let tableJoin = mRelationDiagram.tableJoins.item(i);
                if (tableJoin.table1Alias == tableAlias || tableJoin.table2Alias == tableAlias) {
                    $("#" + tableJoin.tableJoinID).remove();
                    mRelationDiagram.tableJoins.remove(tableJoin);
                }
            }
            
            currentDiagram(mRelationDiagram.relationDiagramName || "", mRelationDiagram.tableBlocks.count(), mRelationDiagram.tableJoins.count());
            layer.close(index);
        }
    });
}
function setTableAlias() {
    let blockID = selectedBlockView.attr("id");
    let tableBlock = mRelationDiagram.tableBlocks.item(blockID);
    
    $.ajax({
        url: "dialogs/tableAlias.html",
        type: 'GET',
        success: function (data) {
            layer.open({
                type: 1,
                title: [`为表 ${tableBlock.table.tableName} 创建别名`, "font-size: 14px"],
                btn: false,
                resize: false,
                area: ["400px", "300px"],
                content: data,
                success: function (layero, index) {
                    initTableAliasDialog(index, mLayuiObject, tableBlock, changeViewByChangedAlias);
                }
            });
        }
    });
}

const changeViewByChangedAlias = (tableBlock, oldTableAlias) =>{
    //重画TableBlock
    refreshBlockViewByChangeAlias(oldTableAlias, tableBlock);
    
    //TODO
    // let regexStr = "(?<![\\w.\\[`])"+oldTableAlias+"\\s*.";

    if(askNeedChangeAlias(oldTableAlias)){
        let str= "是否修改关联关系图和业务对象的表达式。"
        mLayuiObject.layer.open({
            type: 0,
            title: "修改别名",
            closeBtn: 1,
            resize: false,
            area: ["480px","270px"],
            skin: "delete-window",
            content: "<div class='fail-box enquire-box clearfix'><div class='fl fail-icon enquire-icon'><i class='iconfont bda-xunwen'></i></div><div class='fr fail-content'>"+str+"</div></div>",
            btn: ["是","否"],
            yes: function(index,layero){
                mLayuiObject.layer.closeAll();
                refreshOtherBlocksByChangeAlias(oldTableAlias, tableBlock.tableAlias);
                refreshOtherDiagramTableJoinsByChangeAlias(oldTableAlias, tableBlock.tableAlias);
                refreshBusinessObjectByChangeAlias(oldTableAlias, tableBlock.tableAlias);
            },
            btn2: function(){
                mLayuiObject.layer.closeAll();
            }
        });
    }else{
        mLayuiObject.layer.closeAll();
    }
};

function refreshBlockViewByChangeAlias(oldAlias, tableBlock){
    selectedBlockView.remove();
    drawTableBlock(tableBlock);
    selectBlock($("#" + tableBlock.blockID));

    let regexStr = oldAlias + ".";
    //重新绘制相关的tableJoins
    for (let i = 0; i < mRelationDiagram.tableJoins.count(); i++) {
        let tableJoin = mRelationDiagram.tableJoins.item(i);
        if (tableJoin.table1Alias == oldAlias || tableJoin.table2Alias == oldAlias) {
            if (tableJoin.table1Alias == oldAlias) tableJoin.table1Alias = tableBlock.tableAlias;
            if (tableJoin.table2Alias == oldAlias) tableJoin.table2Alias = tableBlock.tableAlias;
            tableJoin.expression = tableJoin.expression.replace(regexStr, tableBlock.tableAlias + ".");
            drawTableJoin(tableJoin, $("#" + tableJoin.tableJoinID)[0]);
        }
    }
}
function refreshBusinessObjectByChangeAlias(oldAlias, newAlias){
    
    console.log("修改BO");
    let containAlias = false;
    if(mRelationModel.getDimensionDiagrams().containTableAlias(oldAlias)){
        containAlias = true;
    }
    if(mRelationDiagram.relationDiagramType == 0){
        if(!containAlias){
            refreshBOExpression(oldAlias, newAlias);
        }
    }else{
        let factDiagrams = mRelationModel.getFactDiagrams();
        for(let i = 0; i < factDiagrams.count(); i++){
            if(factDiagrams.item(i) != mRelationModel && factDiagrams.item(i).tableBlocks.containTableAlias(oldAlias)){
                containAlias = true;
                break;
            }
        }
        if(!containAlias){
            refreshBOExpression(oldAlias, newAlias);
        }
    }
}
function refreshBOExpression(oldAlias, newAlias){
    console.log("修改BO表达式");
    let regexStr = oldAlias + ".";
    for(let i = 0; i < mRelationModel.businessObjects.count(); i++){
        let expChanged = false;
        let businessObject = mRelationModel.businessObjects.item(i);
        for(let j = 0; j < businessObject.expressionList.length; j++){
            for(let k = 0; k < businessObject.tableNamesList[j].length; k++){
                if(businessObject.tableNamesList[j][k] == oldAlias){
                    businessObject.tableNamesList[j][k] = newAlias;
                    businessObject.expressionList[j] = businessObject.expressionList[j].replace(regexStr, newAlias + ".");
                    expChanged = true;
                    break;
                }
            }
        }
        if(expChanged){
            businessObject.expressionText = businessObject.expressionText.replace(regexStr, newAlias + ".");
        }
    }
    return false
}
function askNeedChangeAlias(oldAlias){
    if(mRelationDiagram.relationDiagramType == 0){
        let factDiagrams = mRelationModel.getFactDiagrams();
        for(let i = 0; i < factDiagrams.count(); i++){
            let factDiagram = factDiagrams.item(i);
            for(let j = 0; j < factDiagram.tableBlocks.count(); j++){
                if(factDiagram.tableBlocks.item(j).tableAlias == oldAlias){
                    return true;
                }
            }
        }
    }

    if(!mRelationModel.getDimensionDiagrams().containTableAlias(oldAlias)){
        let containAlias = false;
        let factDiagrams = mRelationModel.getFactDiagrams();
        for(let i = 0; i < factDiagrams.count(); i++){
            if(factDiagrams.item(i) != mRelationModel && factDiagrams.item(i).tableBlocks.containTableAlias(oldAlias)){
                containAlias = true;
                break;
            }
        }
        if(containAlias){
            for(let i = 0; i < mRelationModel.businessObjects.count(); i++){
                let businessObject = mRelationModel.businessObjects.item(i);
                for(let j = 0; j < businessObject.expressionList.length; j++){
                    for(let k = 0; k < businessObject.tableNamesList[j].length; k++){
                        if(businessObject.tableNamesList[j][k] == oldAlias){
                            return true;
                        }
                    }
                }
            }
        }
    }

    return false;
    
}
function refreshOtherDiagramTableJoinsByChangeAlias(oldAlias, newAlias){
    let regexStr = oldAlias + ".";
    if(mRelationDiagram.relationDiagramType == 0){
        let factDiagrams = mRelationModel.getFactDiagrams();
        for(let i = 0; i < factDiagrams.count(); i++){
            let factDiagram = factDiagrams.item(i);
            for(let j = 0; j < factDiagram.tableJoins.count(); j++){
                let tableJoin = factDiagram.tableJoins.item(j);
                if (tableJoin.table1Alias == oldAlias || tableJoin.table2Alias == oldAlias) {
                    if (tableJoin.table1Alias == oldAlias) tableJoin.table1Alias = newAlias;
                    if (tableJoin.table2Alias == oldAlias) tableJoin.table2Alias = newAlias;
                    tableJoin.expression = tableJoin.expression.replace(regexStr, newAlias + ".");
                }
            }
        }
    }
}
function refreshOtherBlocksByChangeAlias(oldAlias, newAlias){
    if(mRelationDiagram.relationDiagramType == 0){
        let factDiagrams = mRelationModel.getFactDiagrams();
        for(let i = 0; i < factDiagrams.count(); i++){
            let factDiagram = factDiagrams.item(i);
            for(let j = 0; j < factDiagram.tableBlocks.count(); j++){
                if(factDiagram.tableBlocks.item(j).tableAlias == oldAlias){
                    // if(needChangeAlias == null){
                    //     askNeedChangeAlias();
                    // }
                    // if(needChangeAlias == true)
                    // {
                        factDiagram.tableBlocks.item(j).tableAlias = newAlias;
                    // }
                }
            }
        }
    }
}

function setFieldVisibility() {
    let blockID = selectedBlockView.attr("id");
    let tableBlock = mRelationDiagram.tableBlocks.item(blockID);
    let tableFields = tableBlock.table.tableFields;
    $.ajax({
        url: "dialogs/fieldVisibility.html",
        type: 'GET',
        success: function (data) {
            layer.open({
                type: 1,
                title: ["设置表字段可见性", "font-size: 14px"],
                btn: false,
                resize: false,
                area: ["480px", "640px"],
                content: data,
                success: function (layero, index) {
                    initFieldVisibilityDialog(index, mLayuiObject, tableFields, function () {
                        //重画TableBlock
                        selectedBlockView.remove();
                        drawTableBlock(tableBlock);
                        selectBlock($("#" + blockID));
                        //重新绘制相关的tableJoins
                        for (let i = 0; i < mRelationDiagram.tableJoins.count(); i++) {
                            let tableJoin = mRelationDiagram.tableJoins.item(i);
                            if (tableJoin.table1Alias == tableBlock.tableAlias || tableJoin.table2Alias == tableBlock.tableAlias) {
                                drawTableJoin(tableJoin, $("#" + tableJoin.tableJoinID)[0]);
                            }

                        }
                        return true;
                    });
                }
            });
        }
    });
}
function loadTableValues() {
    if (selectedBlockView) {
        let blockID = selectedBlockView.attr("id");
        let tableBlock = mRelationDiagram.tableBlocks.item(blockID);
        tableBlock.table.getTableData(mDatabaseLink.dataSourceID, false, function (tableValues) {
            $.ajax({
                url: "dialogs/tableValues.html",
                type: "GET",
                success: function (data) {
                    layer.open({
                        type: 1,
                        maxmin: true,
                        title: [tableBlock.table.tableName + "表值（前200行）", "font-size: 14px"],
                        btn: false,
                        resize: false,
                        area: ["800px", "700px"],
                        content: data,
                        success: function (layero, index) {
                            initTableValuesDialog(index, mLayuiObject, tableBlock.table, tableValues);
                        },
                        full: onFull,
                        restore: onRestore
                    });
                }
            });
        }, function (errorStatus, errorMsg) { $Utils.openWindow.failWindow("获取表记录", errorStatus, errorMsg); }, 200);
    }
}

function setBoxStyle(e) {
    let positionWidth = 78;
    let positionHeight = 187;
    let pageX = e.pageX;
    let pageY = e.pageY;
    let documentWidth = $(document).width();
    let documentHeight = $(document).height();
    let styleObj = {};
    styleObj.left = pageX + "px";
    styleObj.top = pageY + "px";
    if (pageX + positionWidth >= documentWidth) {
        styleObj.left = (pageX - positionWidth) + "px";
    }
    if (pageY + positionHeight >= documentHeight) {
        styleObj.top = (pageY - positionHeight) + "px";
    }
    $(".middle-contextmenu").show().css(styleObj);
}

function editTableJoin() {
    $.ajax({
        url: "dialogs/tableJoin.html",
        type: "GET",
        success: function (data) {
            layer.open({
                type: 1,
                title: ["表连接属性", "font-size: 14px"],
                btn: false,
                resize: false,
                area: ["560px", "680px"],
                content: data,
                success: function (layero, index) {
                    let joinID = selectedJoinView.attr("id");
                    let tableJoin = mRelationDiagram.tableJoins.item(joinID);
                    initTableJoinDialog(index, mLayuiObject, 1, tableJoin, mRelationDiagram.tableBlocks, mDatabaseLink, function () {
                        //重画tableJoin
                        drawTableJoin(tableJoin, $("#" + tableJoin.tableJoinID)[0]);
                        return true;
                    });
                }
            });
        }
    });

}

function createBOByTableField(tableField, tableAlias) {
    let businessObject = new BusinessObject();
    businessObject.businessObjectID = new GUID().newGUID();
    if (useCommentAsName && tableField.comment) {
        businessObject.businessObjectName = getAppropriateName(tableField.comment);
    } else {
        businessObject.businessObjectName = getAppropriateName(tableField.fieldName);
    }
    businessObject.businessObjectFolderID = "-1";
    businessObject.visibility = 0;
    businessObject.aggregateFunction = false;
    businessObject.aggregateAware = false;
    businessObject.valueOrder = "";
    businessObject.formatString = "";
    businessObject.businessObjectType = tableField.dataType == 2 ? 1 : 0;
    businessObject.dataType = tableField.dataType;
    businessObject.columnName = "";
    businessObject.expressionText = `${tableAlias}.${tableField.fieldName}`;
    businessObject.expressionList = [`${tableAlias}.${tableField.fieldName}`];
    businessObject.tableNameList = [[tableAlias]];
    businessObject.sortIndex = 0;
    return businessObject;
}
/**
 * 根据表块生成业务对象分类
 */
function createBusinessObjectFolderByBlock(blockView) {
    let blockID = blockView.attr("id");
    let tableBlock = mRelationDiagram.tableBlocks.item(blockID);
    let businessObjectFolder = new BusinessObjectFolder();
    businessObjectFolder.folderID = new GUID().newGUID();
    businessObjectFolder.folderName = tableBlock.tableAlias;
    businessObjectFolder.description = "";
    businessObjectFolder.folderParentID = "-1";
    businessObjectFolder.visibility = 0;
    businessObjectFolder.sortIndex = 0;

    let businessObjects = new BusinessObjects();
    let tableFields = tableBlock.table.tableFields;
    for (let i = 0; i < tableFields.count(); i++) {
        let businessObject = createBOByTableField(tableFields.item(i), tableBlock.tableAlias);
        businessObject.businessObjectFolderID = businessObjectFolder.folderID;
        businessObjects.add(businessObject);
    }
    return { folder: businessObjectFolder, objects: businessObjects };
}

function insertTables(tables) {
    tables.getTableFields(mDatabaseLink.dataSourceID, false, function () {
        let col = 0;
        let row = 0;

        for (let i = 0; i < tables.count(); i++) {
            let table = tables.item(i);
            let tableBlock = new TableBlock();
            tableBlock.tableBlockID = new GUID().newGUID();
            let alias = getAppropriateName(table.tableName);
            if (mRelationDiagram.relationDiagramType == 0) {
                alias = mRelationModel.getDimensionDiagrams().getDefaultTableAlias(alias);
            } else {
                alias = mRelationDiagram.getDefaultTableAlias(alias);
            }
            tableBlock.tableAlias = alias;
            tableBlock.table = table;
            tableBlock.x = 100 + col * 150;
            tableBlock.y = 100 + row * 300;
            tableBlock.height = 1000000000;
            mRelationDiagram.tableBlocks.add(tableBlock);
            drawTableBlock(tableBlock);
            col++;
            if (col > 5) {
                row++;
                col = 0;
            }
        }
    }, function (errorStatus, errorMsg) { $Utils.openWindow.failWindow("获取表字段", errorStatus, errorMsg); });
}

function selectBlock(blockView) {
    unselectBlock();
    unselectJoin();

    blockView.addClass("block-selected");
    selectedBlockView = blockView;

    $("#btnDeleteTableOrTableJoins").addClass("button-color");
}

function selectJoin(joinView) {
    unselectBlock();
    unselectJoin();

    joinView[0].setAttribute("class", "table-join join-selected");
    selectedJoinView = joinView;

    $("#btnTableJoinsAttribute").addClass("button-color");
    $("#btnDeleteTableOrTableJoins").addClass("button-color");
}

function unselectBlock() {
    if (selectedBlockView != null) {
        selectedBlockView.removeClass("block-selected");
        selectedBlockView = null;

        $("#btnDeleteTableOrTableJoins").removeClass("button-color");
    }
}
function unselectJoin() {
    if (selectedJoinView != null) {
        selectedJoinView[0].setAttribute("class", "table-join");
        selectedJoinView = null;

        $("#btnTableJoinsAttribute").removeClass("button-color");
        $("#btnDeleteTableOrTableJoins").removeClass("button-color");
    }
}

function blockDoubleClick(selectedBlockView) {
    let blockID = selectedBlockView.attr("id");
    let tableBlock = mRelationDiagram.tableBlocks.item(blockID);

    let maxFieldCount = parseInt(selectedBlockView.attr("maxFieldCount"));
    let showFieldCount = parseInt(selectedBlockView.attr("showFieldCount"));

    if (showFieldCount == maxFieldCount) {
        selectedBlockView.attr("showFieldCount", "1");
        selectedBlockView.find("ul li.field").each(function () {
            if ($(this).index() > 0) {
                $(this).css({
                    "display": "none"
                });
            }
        });
        if (maxFieldCount > 1) {
            selectedBlockView.find("ul li.more").css({
                "display": "block"
            });
        }

    } else {
        selectedBlockView.attr("showFieldCount", maxFieldCount);
        selectedBlockView.find("ul li.field").each(function () {
            $(this).css({
                "display": "block"
            });
        });
        if (maxFieldCount == tableBlock.table.tableFields.count()) {
            selectedBlockView.find("ul li.more").css({
                "display": "none"
            });
        }
    }
    //重新绘制相关的tableJoins
    for (let i = 0; i < mRelationDiagram.tableJoins.count(); i++) {
        let tableJoin = mRelationDiagram.tableJoins.item(i);
        if (tableJoin.table1Alias == tableBlock.tableAlias || tableJoin.table2Alias == tableBlock.tableAlias) {
            drawTableJoin(tableJoin, $("#" + tableJoin.tableJoinID)[0]);
        }

    }
}

export { initRelationDiagram };