/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2021-01-30 16:52:40
 * @LastEditTime: 2021-03-09 11:04:32
 * @LastModifyUser: 
 * @Remark: 
 */
import GUID from "./components/guid.js";
import { totalDiagram } from "./components/bottomStatusBar_controller.js";
import { initRelationDiagram } from "./relationDiagram_controller.js";
import initDiagramFolderForm from "./dialogs/diagramFolder_controller.js";
import initDiagramForm from "./dialogs/diagram_controller.js";

let mRelationModel = null;
let mLayuiObject = null;
let cloneNodeHtml = null;
let copyNewDiagramFolders = new RelationDiagramFolders();
let copyNewDiagrams = new RelationDiagrams();
let guID = new GUID();

function initRelationDiagramList(relationModel, layuiObject, databaseLink){
    mRelationModel = relationModel;
    mLayuiObject = layuiObject;
    totalDiagram(mRelationModel.relationDiagrams.count());
    loadTreeList();
    bindEvent(databaseLink);
}

function loadTreeList(){
    let treeData = setTreeData();
    $("#diagramTree").html("");
    createFolder(treeData);
    createDiagram();
}

function setTreeData(){
    let hashTable = new HashTable();
    hashTable.add("-2", { name: "维度表关系图", folderID: "-2", folderParentID: "-1", relationDiagramType: 0, spread: true});
    hashTable.add("-3", { name: "事实表关系图", folderID: "-3", folderParentID: "-1", relationDiagramType: 1, spread: true});
    for (let i = 0; i < mRelationModel.relationDiagramFolders.count(); i++){
        let folder = mRelationModel.relationDiagramFolders.item(i);
        hashTable.add(folder.folderID, { name: folder.folderName, folderID: folder.folderID, folderParentID: folder.folderParentID, relationDiagramType: folder.relationDiagramType, spread: false});
    }
    for (let i = 0; i < mRelationModel.relationDiagramFolders.count(); i++){
        let folder = mRelationModel.relationDiagramFolders.item(i);
        let parentFolder = hashTable.getValue(folder.folderParentID);
        if (!parentFolder.children){
            parentFolder.children = [];
        }
        parentFolder.children.push(hashTable.getValue(folder.folderID));
    }
    hashTable.add("-1", { name: "关系图", folderID: "-1", folderParentID: "-1", spread: true, children: []});
    hashTable.getValue("-1").children.push(hashTable.getValue("-2"));
    hashTable.getValue("-1").children.push(hashTable.getValue("-3"));
    
    return hashTable.getValue("-1").children;
}

function createFolder(treeData){
    for (let i = 0; i < treeData.length; i++) {
        let spread = treeData[i].spread;
        let strHtml = `<li class="folder ${(spread ? "open-folder" : "")}" data-folderID="${treeData[i].folderID}" data-relationDiagramType="${treeData[i].relationDiagramType}">
            <div title="${treeData[i].name}">
                <i class="iconfont bda-wenjianjia"></i>
                <span class="folder-name">${treeData[i].name}</span>
                <span class="triangle"></span>
            </div>
            <ul></ul>
        </li>`;
        $("#diagramTree").append(strHtml);
        if (treeData[i].children){
            $("#diagramTree li:last-child").addClass("hasChildren");
            createChildrenFolder(treeData[i].children, $("#diagramTree li:last-child").children("ul"));
        }
    }
}

function createChildrenFolder(treeData, element){
    for (let i = 0; i < treeData.length; i++) {
        let spread = treeData[i].spread;
        let strHtml = `<li class="folder ${(spread ? "open-folder" : "")}" data-folderID="${treeData[i].folderID}" data-relationDiagramType="${treeData[i].relationDiagramType}">
            <div title="${treeData[i].name}">
                <i class="iconfont bda-wenjianjia"></i>
                <span class="folder-name">${treeData[i].name}</span>
                <span class="triangle"></span>
            </div>
            <ul></ul>
        </li>`;
        element.append(strHtml);
        if (treeData[i].children) {
            element.find("li:last-child").addClass("hasChildren");
            createChildrenFolder(treeData[i].children, element.find("li:last-child").children("ul"));
        }
    }
}

function createDiagram(){
    for (let i = 0; i < mRelationModel.relationDiagrams.count(); i++){
        let diagram = mRelationModel.relationDiagrams.item(i);
        $("#diagramTree li").each(function(){
            if ($(this).attr("data-folderID") == diagram.folderID){
                let strHtml = `<li class="diagrams" data-relationDiagramID="${diagram.relationDiagramID}">
                    <div title="${diagram.relationDiagramName}">
                        <i class="iconfont bda-${(diagram.relationDiagramType ? "shishibiao" : "weibiao")}"></i>
                        <span>${diagram.relationDiagramName}</span>
                    </div>
                </li>`;
                $(this).children("ul").append(strHtml);
                if (!$(this).hasClass("hasChildren")){
                    $(this).addClass("hasChildren");
                }
            }
        });
    }
}

function bindEvent(databaseLink){
    treeClickEvent(databaseLink);
    defaultTriggerEvent();
    mouseRightEvent();
    buttonEvent();
}

function treeClickEvent(databaseLink) {
    $("#diagramTree").on("click", "li", function (e) {
        if (!$(this).hasClass("selected-li")) {
            $("#diagramTree").find("li").removeClass("selected-li");
            $(this).addClass("selected-li");
            if ($(this).hasClass("folder") && ($(this).attr("data-folderid") == -3 || $(this).attr("data-folderid") == -2)){
                $("#diagramOrCategoryAttribute,#deleteDiagramOrCategory,#moveDiagramOrCategroyUp,#moveDiagramOrCategroyDown").removeClass("button-color").addClass("default-status");
            } else {
                $("#diagramOrCategoryAttribute,#deleteDiagramOrCategory,#moveDiagramOrCategroyUp,#moveDiagramOrCategroyDown").removeClass("default-status").addClass("button-color");
            }
            if ($(this).hasClass("diagrams")) {
                let relationDiagramID = $(this).attr("data-relationdiagramid");
                let relationDiagram = mRelationModel.relationDiagrams.item(relationDiagramID);
                initRelationDiagram(relationDiagram, mRelationModel, databaseLink, mLayuiObject);
            } else {
                initRelationDiagram(null, mRelationModel, databaseLink, mLayuiObject);
            }
        }
        $(".right-contextmenu").hide();
        e.stopPropagation();
    });

    $("#diagramTree").on("click", "span.triangle", function (e) {
        if ($(this).parent("div").siblings("ul").is(":hidden")) {
            $(this).parent("div").parent("li").addClass("open-folder");
        } else {
            $(this).parent("div").parent("li").removeClass("open-folder");
        }
        $(".right-contextmenu").hide();
        e.stopPropagation();
    });

    $("#diagramTree").on("dblclick", "li.folder > div", function (e) {
        if ($(this).siblings("ul").is(":hidden")) {
            $(this).parent("li").addClass("open-folder");
            $("#diagramTree").find("li").removeClass("selected-li");
            $(this).parent("li").addClass("selected-li");
        } else {
            $(this).parent("li").removeClass("open-folder");
            $("#diagramTree").find("li").removeClass("selected-li");
            $(this).parent("li").addClass("selected-li");
        }
        $(".right-contextmenu").hide();
        e.stopPropagation();
    });
}

function defaultTriggerEvent() {
    let clickEvetnEnd = false;
    if ($("#diagramTree > li:first-child > ul > li").length) {
        $("#diagramTree > li:first-child > ul > li.diagrams").eq(0).trigger("click");
    } else if ($("#diagramTree > li:last-child > ul > li").length) {
        $("#diagramTree > li:last-child > ul > li.diagrams").eq(0).trigger("click");
    } else {
        $("#diagramTree > li:last-child").trigger("click");
    }
}

function mouseRightEvent(){
    $("#diagramTree").on("mousedown", "li > div", function (e) {//紧接上面的实例demo1 在script中插入这段代码即可获取到鼠标点击事件
        let code = e.which;//判断是单机了鼠标哪个键(1,2,3)
        if (code == 3) {
            $(".diagram-contextmenu").hide();
            setBoxStyle(e,0);
            let self = $(this).parent("li")[0];
            if ($(this).parent().hasClass("folder") && ($(this).parent().attr("data-folderid") == "-2" || $(this).parent().attr("data-folderid") == "-3")){
                $(".right-contextmenu ul").addClass("hide-li");
            }else{
                $(".right-contextmenu ul").removeClass("hide-li");
            }
            $(".right-contextmenu li").off("click").on("click", function () {
                if ($(this).attr("data-code") == 0) {
                    let folderParentID = $(self).hasClass("folder") ? $(self).attr("data-folderid") : $(self).parents(".folder").eq(0).attr("data-folderid");
                    let relationDiagramType = $(self).hasClass("folder") ? $(self).attr("data-relationdiagramtype") : $(self).parents(".folder").eq(0).attr("data-relationdiagramtype");
                    addDiagramCategory(folderParentID, relationDiagramType);
                }
                if ($(this).attr("data-code") == 1) {
                    let folderID = $(self).hasClass("folder") ? $(self).attr("data-folderid") : $(self).parents(".folder").eq(0).attr("data-folderid");
                    let relationDiagramType = $(self).hasClass("folder") ? $(self).attr("data-relationdiagramtype") : $(self).parents(".folder").eq(0).attr("data-relationdiagramtype");
                    addDiagram(folderID, relationDiagramType);
                }
                if ($(this).attr("data-code") == 2) {
                    if ($(self).hasClass("folder")) {
                        let folderID = $(self).attr("data-folderid");
                        if (mRelationModel.relationDiagramFolders.item(folderID)) {
                            getAndLoadFolderForm(1, mRelationModel.relationDiagramFolders.item(folderID));
                        } else {
                            layer.msg("不能修改固有的文件夹。", { icon: 2 });
                        }
                    } else {
                        let relationDiagram = mRelationModel.relationDiagrams.item($(self).attr("data-relationdiagramid"));
                        getAndLoadDiagramForm(1, relationDiagram);
                    }
                }
                if($(this).attr("data-code") == 3) {
                    cloneNodeHtml = null;
                    cloneNodeHtml = $(self).clone(true);
                    copyDiagramOrFolder();
                }
                if ($(this).attr("data-code") == 4) {
                    pasteDiagramOrFolder(self);
                }
                if ($(this).attr("data-code") == 5) {
                    if ($(self).hasClass("folder")) {
                        let folderID = $(self).attr("data-folderid");
                        if (mRelationModel.relationDiagramFolders.item(folderID)) {
                            if ($(self).children("ul").find("li").length > 0) {
                                layer.msg("分类 " + mRelationModel.relationDiagramFolders.item(folderID).folderName + " 底下还有子分类或关系图，不能删除。", { icon: 2 });
                            } else {
                                deleteDiagramFolder(mRelationModel.relationDiagramFolders.item(folderID), $(self));
                            }
                        } else {
                            layer.msg("不能删除固有的文件夹。", { icon: 2 });
                        }

                    } else {
                        let relationDiagram = mRelationModel.relationDiagrams.item($(self).attr("data-relationdiagramid"));
                        deleteDiagram(relationDiagram, $(self));
                    }
                }
                $(".diagram-contextmenu").hide();
            });
            // hideContextmenuBox();
            e.stopPropagation();
        }
    });

    $(".right-content").on("mousedown", function (e) {
        let code = e.which;//判断是单机了鼠标哪个键(1,2,3)
        if (code == 3 && !$(e.target).parents().hasClass("tree")) {
            $(".diagram-contextmenu").hide();
            $(".right-contextmenu ul").addClass("hide-li");
            setBoxStyle(e,1);
            $(".right-contextmenu li").off("click").on("click", function () {
                if ($(this).attr("data-code") == 0) {
                    let folderParentID = $("#diagramTree li.selected-li").hasClass("folder") ? $("#diagramTree li.selected-li").attr("data-folderid") : $("#diagramTree li.selected-li").parents(".folder").eq(0).attr("data-folderid");
                    let relationDiagramType = $("#diagramTree li.selected-li").hasClass("folder") ? $("#diagramTree li.selected-li").attr("data-relationdiagramtype") : $("#diagramTree li.selected-li").parents(".folder").eq(0).attr("data-relationdiagramtype");
                    addDiagramCategory(folderParentID, relationDiagramType);
                }
                if ($(this).attr("data-code") == 1) {
                    let folderID = $("#diagramTree li.selected-li").hasClass("folder") ? $("#diagramTree li.selected-li").attr("data-folderid") : $("#diagramTree li.selected-li").parents(".folder").eq(0).attr("data-folderid");
                    let relationDiagramType = $("#diagramTree li.selected-li").hasClass("folder") ? $("#diagramTree li.selected-li").attr("data-relationdiagramtype") : $("#diagramTree li.selected-li").parents(".folder").eq(0).attr("data-relationdiagramtype");
                    addDiagram(folderID, relationDiagramType);
                }
                $(".diagram-contextmenu").hide();
            });
            // hideContextmenuBox();
            e.stopPropagation();
        }
    });
}

function setBoxStyle(e,index) {
    let positionWidth = 134;
    let positionHeight = index ? 62 : 162;
    let pageX = e.pageX;
    let pageY = e.pageY;
    let documentWidth = $(document).width();
    let documentHeight = $(document).height();
    let styleObj = {};
    styleObj.left = pageX + "px";
    styleObj.top = pageY + "px";
    if (pageX + positionWidth >= documentWidth) {
        styleObj.left = (pageX - positionWidth) + "px";
    }
    if (pageY + positionHeight >= documentHeight) {
        styleObj.top = (pageY - positionHeight) + "px";
    }
    $(".right-contextmenu").show().css(styleObj);
}

function copyDiagramOrFolder(){
    copyNewDiagramFolders.clear();
    copyNewDiagrams.clear();
    let cloneNodeArr = [];
    cloneNodeArr.push(cloneNodeHtml);
    while(cloneNodeArr.length > 0){
        let currentNode = cloneNodeArr[0];
        cloneNodeArr.splice(0,1);
        if(currentNode.hasClass("folder")){
            let diagramFolder = new RelationDiagramFolder();
            diagramFolder.init(JSON.parse(JSON.stringify(mRelationModel.relationDiagramFolders.item(currentNode.attr("data-folderid")))));
            copyNewDiagramFolders.add(diagramFolder);
            if (currentNode.hasClass("hasChildren")) {
                currentNode.children("ul").children("li").each(function () {
                    cloneNodeArr.push($(this));
                });
            }
        } else if (currentNode.hasClass("diagrams")){
            let diagram = new RelationDiagram();
            diagram.init(JSON.parse(JSON.stringify(mRelationModel.relationDiagrams.item(currentNode.attr("data-relationdiagramid")))));
            copyNewDiagrams.add(diagram);
        }
    }
    if (copyNewDiagramFolders.count() > 0){
        copyNewDiagramFolders.item(0).folderParentID = "-1";
    }
}

function pasteDiagramOrFolder(elem){
    let pasteFolderID = $(elem).hasClass("folder") ? $(elem).attr("data-folderid") : $(elem).parents("li.folder").eq(0).attr("data-folderid");
    let idMaps = {};

    let copyDiagramFolders = new RelationDiagramFolders();
    copyDiagramFolders.init(copyNewDiagramFolders.toJSON());
    let copyDiagrams = new RelationDiagrams();
    copyDiagrams.init(copyNewDiagrams.toJSON());
    if(copyDiagramFolders.count() > 0){
        copyDiagramFolders.item(0).folderParentID = pasteFolderID;
        idMaps[pasteFolderID] = pasteFolderID;
    } else if (copyDiagramFolders.count() == 0 && copyDiagrams.count() > 0){
        copyDiagrams.item(0).folderID = pasteFolderID;
        idMaps[pasteFolderID] = pasteFolderID;
    }
    for(let i = 0; i < copyDiagramFolders.count(); i++){
        let folder = copyDiagramFolders.item(i);
        if(i == 0){
            let name = folder.folderName;
            let j = 1;
            while (existFolderName(name, pasteFolderID)){
                name = name + j;
                j++;
            }
            folder.folderName = name;
        }
        let oldFolderID = folder.folderID;
        folder.folderID = guID.newGUID();
        idMaps[oldFolderID] = folder.folderID;
        folder.folderParentID = idMaps[folder.folderParentID];
        mRelationModel.relationDiagramFolders.add(folder);
    }
    for(let i = 0; i < copyDiagrams.count(); i++){
        let diagram = copyDiagrams.item(i);
        if(copyDiagramFolders.count() == 0 && i == 0){
            let name = diagram.relationDiagramName;
            let j = 1;
            while(existDiagramName(name,pasteFolderID)){
                name = name + j;
                j++;
            }
            diagram.relationDiagramName = name;
        }
        diagram.relationDiagramID = guID.newGUID();
        diagram.folderID = idMaps[diagram.folderID];
        mRelationModel.relationDiagrams.add(diagram);
    }
    createPasteDom(elem, copyDiagramFolders, copyDiagrams);
}

function createPasteDom(elem, copyDiagramFolders, copyDiagrams) {
    $("#diagramTree li.selected-li").removeClass("selected-li");
    let targetDiagramType = $(elem).hasClass("folder") ? Number($(elem).attr("data-relationdiagramtype")) : Number($(elem).parents(".folder").eq(0).attr("data-relationdiagramtype"));
    if(copyDiagramFolders.count() > 0){
        if (copyDiagramFolders.item(0).relationDiagramType != targetDiagramType) {
            let msg = `${(copyDiagramFolders.item(0).relationDiagramType == 1 ? "事实表关系图" : "维度表关系图")} 不能粘贴到 ${(targetDiagramType == 1 ? "事实表关系图" : "维度表关系图")} 下。`;
            mLayuiObject.layer.msg(msg, { icon: 2 });
            return;
        }
        let treeData = setPasteData(copyDiagramFolders);
        createPasteFolder(treeData, elem, copyDiagrams);
    }
    if(copyDiagrams.count() > 0){
        if (copyDiagrams.item(0).relationDiagramType != targetDiagramType){
            let msg = `${(copyDiagrams.item(0).relationDiagramType == 1 ? "事实表关系图" : "维度表关系图")} 不能粘贴到 ${(targetDiagramType == 1 ? "事实表关系图" : "维度表关系图")} 下。`;
            mLayuiObject.layer.msg(msg, { icon: 2 });
            return;
        }
        for (let i = 0; i < copyDiagrams.count(); i++) {
            let isLast = (i == copyDiagrams.count() -1) ? true : false;
            let diagram = copyDiagrams.item(i);
            $("#diagramTree li").each(function () {
                if ($(this).attr("data-folderID") == diagram.folderID) {
                    let strHtml = `<li class="diagrams ${(isLast ? "selected-li" : "")}" data-relationDiagramID="${diagram.relationDiagramID}">
                        <div title="${diagram.relationDiagramName}">
                            <i class="iconfont bda-${(diagram.relationDiagramType ? "shishibiao" : "weibiao")}"></i>
                            <span>${diagram.relationDiagramName}</span>
                        </div>
                    </li>`;
                    $(this).children("ul").append(strHtml);
                    if (!$(this).hasClass("hasChildren")) {
                        $(this).addClass("hasChildren");
                    }
                }
            });
        }
        $("#diagramTree li.selected-li").trigger("click");
    }
}

function createPasteFolder(treeData, elem, copyDiagrams){
    for (let i = 0; i < treeData.length; i++) {
        let spread = treeData[i].spread;
        let isLast = (i == treeData.length - 1) ? true : false;
        if(isLast){
            if(copyDiagrams.count() == 0 && !treeData[i].children){
                isLast = true;
            }else{
                isLast = false;
            }
        }
        let strHtml = `<li class="folder ${(spread ? "open-folder" : "")} ${(isLast ? "selected-li" : "")}" data-folderID="${treeData[i].folderID}" data-relationDiagramType="${treeData[i].relationDiagramType}">
            <div title="${treeData[i].name}">
                <i class="iconfont bda-wenjianjia"></i>
                <span class="folder-name">${treeData[i].name}</span>
                <span class="triangle"></span>
            </div>
            <ul></ul>
        </li>`;
        if($(elem).hasClass("folder")){
            $(elem).children("ul").append(strHtml);
        }else{
            $(elem).parent("ul").append(strHtml);
        }
        if (treeData[i].children) {
            if ($(elem).hasClass("folder")) {
                $(elem).addClass("hasChildren").children("ul").children("li:last-child").addClass("hasChildren");
                createPasteChildrenFolder(treeData[i].children, $(elem).children("ul").children("li:last-child").children("ul"), copyDiagrams);
            } else {
                $(elem).parent("ul").children("li:last-child").addClass("hasChildren");
                createPasteChildrenFolder(treeData[i].children, $(elem).parent("ul").children("li:last-child").children("ul"), copyDiagrams);
            }
        }
    }
}

function createPasteChildrenFolder(treeData, element, copyDiagrams) {
    for (let i = 0; i < treeData.length; i++) {
        let spread = treeData[i].spread;
        let isLast = (treeData.length - 1 == i) ? true : false;
        if (isLast) {
            if (copyDiagrams.count() == 0 && !treeData[i].children) {
                isLast = true;
            } else {
                isLast = false;
            }
        }
        let strHtml = `<li class="folder ${(spread ? "open-folder" : "")} ${(isLast ? "selected-li" : "")}" data-folderID="${treeData[i].folderID}" data-relationDiagramType="${treeData[i].relationDiagramType}">
            <div title="${treeData[i].name}">
                <i class="iconfont bda-wenjianjia"></i>
                <span class="folder-name">${treeData[i].name}</span>
                <span class="triangle"></span>
            </div>
            <ul></ul>
        </li>`;
        element.append(strHtml);
        if (treeData[i].children) {
            element.find("li:last-child").addClass("hasChildren");
            createChildrenFolder(treeData[i].children, element.find("li:last-child").children("ul"));
        }
    }
}

function setPasteData(copyDiagramFolders){
    let hashTable = new HashTable();
    hashTable.add(copyDiagramFolders.item(0).folderParentID, { name: "维度表关系图", folderID: copyDiagramFolders.item(0).folderParentID, folderParentID: "-1", relationDiagramType: 0, spread: true });
    for (let i = 0; i < copyDiagramFolders.count(); i++) {
        let folder = copyDiagramFolders.item(i);
        hashTable.add(folder.folderID, { name: folder.folderName, folderID: folder.folderID, folderParentID: folder.folderParentID, relationDiagramType: folder.relationDiagramType, spread: true });
    }
    for (let i = 0; i < copyDiagramFolders.count(); i++) {
        let folder = copyDiagramFolders.item(i);
        let parentFolder = hashTable.getValue(folder.folderParentID);
        if (!parentFolder.children) {
            parentFolder.children = [];
        }
        parentFolder.children.push(hashTable.getValue(folder.folderID));
    }
    return hashTable.getValue(copyDiagramFolders.item(0).folderParentID).children;
}

function existFolderName(name,folderParentID){
    for (let i = 0; i < mRelationModel.relationDiagramFolders.count(); i++){
        if (mRelationModel.relationDiagramFolders.item(i).folderParentID == folderParentID && name == mRelationModel.relationDiagramFolders.item(i).folderName){
            return true;
        }
    }
    return false;
}

function existDiagramName(name, folderID){
    for(let i = 0; i < mRelationModel.relationDiagrams.count(); i++){
        if (mRelationModel.relationDiagrams.item(i).folderID == folderID && name == mRelationModel.relationDiagrams.item(i).relationDiagramName){
            return true;
        }
    }
    return false;
}

function buttonEvent() {
    $("#newDiagramCategory").click(function () {
        if ($("#diagramTree li").hasClass("selected-li")) {
            let folderParentID = $("#diagramTree li.selected-li").hasClass("folder") ? $("#diagramTree li.selected-li").attr("data-folderid") : $("#diagramTree li.selected-li").parents(".folder").eq(0).attr("data-folderid");
            let relationDiagramType = $("#diagramTree li.selected-li").hasClass("folder") ? $("#diagramTree li.selected-li").attr("data-relationdiagramtype") : $("#diagramTree li.selected-li").parents(".folder").eq(0).attr("data-relationdiagramtype");
            addDiagramCategory(folderParentID, relationDiagramType);
        } else {
            layer.msg("请选择一条记录。", { icon: 2 });
        }
    });

    $("#newDiagram").click(function () {
        if ($("#diagramTree li").hasClass("selected-li")) {
            let folderID = $("#diagramTree li.selected-li").hasClass("folder") ? $("#diagramTree li.selected-li").attr("data-folderid") : $("#diagramTree li.selected-li").parents(".folder").eq(0).attr("data-folderid");
            let relationDiagramType = $("#diagramTree li.selected-li").hasClass("folder") ? $("#diagramTree li.selected-li").attr("data-relationdiagramtype") : $("#diagramTree li.selected-li").parents(".folder").eq(0).attr("data-relationdiagramtype");
            addDiagram(folderID, relationDiagramType);
        } else {
            layer.msg("请选择一条记录。", { icon: 2 });
        }
    });

    // $("#newFactDiagram").click(function () {
    //     if ($("#diagramTree li").hasClass("selected-li")) {
    //         let folderID = $("#diagramTree li.selected-li").hasClass("folder") ? $("#diagramTree li.selected-li").attr("data-folderid") : $("#diagramTree li.selected-li").parents(".folder").eq(0).attr("data-folderid");
    //         let relationDiagram = new RelationDiagram();
    //         relationDiagram.relationDiagramType = 1;
    //         relationDiagram.folderID = folderID;
    //         getAndLoadDiagramForm(0, relationDiagram);
    //     } else {
    //         layer.msg("请选择一条记录。", { icon: 2 });
    //     }
    // });

    $("#diagramOrCategoryAttribute").click(function(){
        if ($("#diagramTree li").hasClass("selected-li")) {
            if ($("#diagramTree li.selected-li").hasClass("folder")){
                let folderID = $("#diagramTree li.selected-li").attr("data-folderid");
                if (mRelationModel.relationDiagramFolders.item(folderID)) {
                    getAndLoadFolderForm(1, mRelationModel.relationDiagramFolders.item(folderID));
                } else {
                    layer.msg("不能修改固有的文件夹。", { icon: 2 });
                }
            }else{
                let relationDiagram = mRelationModel.relationDiagrams.item($("#diagramTree li.selected-li").attr("data-relationdiagramid"));
                getAndLoadDiagramForm(1,relationDiagram);
            }
        } else {
            layer.msg("请选择一条记录。", { icon: 2 });
        }
    });

    $("#deleteDiagramOrCategory").click(function(){
        if ($("#diagramTree li").hasClass("selected-li")) {
            if ($("#diagramTree li.selected-li").hasClass("folder")) {
                let folderID = $("#diagramTree li.selected-li").attr("data-folderid");
                if (mRelationModel.relationDiagramFolders.item(folderID)) {
                    if ($("#diagramTree li.selected-li").children("ul").find("li").length > 0) {
                        layer.msg("分类 " + mRelationModel.relationDiagramFolders.item(folderID).folderName+" 底下还有子分类或关系图，不能删除。", { icon: 2 });
                    } else {
                        deleteDiagramFolder(mRelationModel.relationDiagramFolders.item(folderID), $("#diagramTree li.selected-li"));
                    }
                } else {
                    layer.msg("不能删除固有的文件夹。", { icon: 2 });
                }
                
            } else {
                let relationDiagram = mRelationModel.relationDiagrams.item($("#diagramTree li.selected-li").attr("data-relationdiagramid"));
                deleteDiagram(relationDiagram, $("#diagramTree li.selected-li"));
            }
        }else{
            layer.msg("请选择一条记录。", { icon: 2 });
        }
    });
    
    $("#moveDiagramOrCategroyUp").click(function(){
        if ($("#diagramTree li").hasClass("selected-li")) {
            let currentNode = $("#diagramTree li.selected-li");
            if(currentNode.index() != 0){
                currentNode.prev().before(currentNode);
            }
        } else {
            layer.msg("请选择一条记录。", { icon: 2 });
        }
    });

    $("#moveDiagramOrCategroyDown").click(function () {
        if ($("#diagramTree li").hasClass("selected-li")) {
            let currentNode = $("#diagramTree li.selected-li");
            let length = currentNode.parent("ul").children("li").length;
            if (currentNode.index() != length - 1) {
                currentNode.next().after(currentNode);
            }
        } else {
            layer.msg("请选择一条记录。", { icon: 2 });
        }
    });
    
}

function addDiagramCategory(folderParentID, relationDiagramType){
    let relationDiagramFolder = new RelationDiagramFolder();
    relationDiagramFolder.relationDiagramType = relationDiagramType;
    relationDiagramFolder.folderParentID = folderParentID;
    getAndLoadFolderForm(0, relationDiagramFolder);
}

function addDiagram(folderID, relationDiagramType){
    let relationDiagram = new RelationDiagram();
    relationDiagram.relationDiagramType = Number(relationDiagramType);
    relationDiagram.folderID = folderID;
    getAndLoadDiagramForm(0, relationDiagram);
}

function getAndLoadFolderForm(operationType, relationDiagramFolder){
    $.ajax({
        url: "dialogs/relationDiagramFolder.html",
        type: 'GET',
        success: function (data) {
            loadFolderForm(data, operationType, relationDiagramFolder)
        }
    });
    
}

function loadFolderForm(strHtml, operationType, relationDiagramFolder){
    layer.open({
        type: 1,
        title: [operationType ? (relationDiagramFolder.folderName + " 属性") : "新增关系图文件夹", "font-size: 14px"],
        btn: false,
        resize: false,
        area: ["500px", "450px"],
        content: strHtml,
        success: function (layero, index) {
            initDiagramFolderForm(index, mLayuiObject, operationType, relationDiagramFolder, addDiagramFolderSubmit, editDiagramFolderSubmit, mRelationModel.relationDiagramFolders);
        }
    });
}

function getAndLoadDiagramForm(operationType, relationDiagram){
    $.ajax({
        url: "dialogs/relationDiagram.html",
        type: 'GET',
        success: function (data) {
            loadDiagramForm(data, operationType, relationDiagram)
        }
    });
}

function loadDiagramForm(strHtml, operationType, relationDiagram) {
    layer.open({
        type: 1,
        title: [operationType ? (relationDiagram.relationDiagramName + " 属性") : "新增关系图", "font-size: 14px"],
        btn: false,
        resize: false,
        area: ["500px", "450px"],
        content: strHtml,
        success: function (layero, index) {
            initDiagramForm(index, mLayuiObject, operationType, relationDiagram, addDiagramSubmit, editDiagramSubmit, mRelationModel.relationDiagramFolders, mRelationModel.relationDiagrams);
        }
    });
}

function deleteDiagramFolder(folder,element){
    layer.open({
        type: 0,
        title: "删除分类",
        closeBtn: 1,
        resize: false,
        area: ["480px", "270px"],
        skin: "delete-window",
        content: `<div class="fail-box enquire-box clearfix">
            <div class="fl fail-icon enquire-icon">
                <i class="iconfont bda-xunwen"></i>
            </div>
            <div class="fr fail-content">是否删除 ${folder.folderName} ？</div>
        </div>`,
        btn: ["确定", "取消"],
        yes: function (index, layero) {
            layer.close(index);
            mRelationModel.relationDiagramFolders.remove(folder.folderID);
            element.parents("li").eq(0).trigger("click");
            element.remove();
        }
    });
}

function deleteDiagram(relationDiagram,element){
    layer.open({
        type: 0,
        title: "删除分类",
        closeBtn: 1,
        resize: false,
        area: ["480px", "270px"],
        skin: "delete-window",
        content: `<div class="fail-box enquire-box clearfix">
            <div class="fl fail-icon enquire-icon">
                <i class="iconfont bda-xunwen"></i>
            </div>
            <div class="fr fail-content">是否删除 ${relationDiagram.relationDiagramName} ？</div>
        </div>`,
        btn: ["确定", "取消"],
        yes: function (index, layero) {
            layer.close(index);
            mRelationModel.relationDiagrams.remove(relationDiagram.relationDiagramID);
            element.parents("li").eq(0).trigger("click");
            element.remove();
        }
    });
}

const addDiagramFolderSubmit = (relationDiagramFolder) => {
    mRelationModel.relationDiagramFolders.add(relationDiagramFolder);
    addFolderNode(relationDiagramFolder);
};

function addFolderNode(relationDiagramFolder){
    $("#diagramTree li.selected-li").removeClass("selected-li");
    $("#diagramTree li.folder").each(function(){
        if ($(this).attr("data-folderid") == relationDiagramFolder.folderParentID){
            let strHtml = `<li class="folder selected-li" data-folderID="${relationDiagramFolder.folderID}" data-relationDiagramType="${relationDiagramFolder.relationDiagramType}">
                <div title="${relationDiagramFolder.folderName}">
                    <i class="iconfont bda-wenjianjia"></i>
                    <span class="folder-name">${relationDiagramFolder.folderName}</span>
                    <span class="triangle"></span>
                </div>
                <ul></ul>
            </li>`;
            $(this).addClass("open-folder hasChildren").children("ul").append(strHtml);
            $(this).parents("li.folder").addClass("open-folder hasChildren");
            return false;
        }
    });
}

const editDiagramFolderSubmit = (relationDiagramFolder) => {
    $("#diagramTree li.folder").each(function () {
        if ($(this).attr("data-folderid") == relationDiagramFolder.folderID) {
            if ($(this).parents("li.folder").eq(0).attr("data-folderid") == relationDiagramFolder.folderParentID){
                $(this).children("div").attr("title",relationDiagramFolder.folderName);
                $(this).children("div").find("span.folder-name").text(relationDiagramFolder.folderName);
            }else{
                changeParentFolder(this,relationDiagramFolder);
            }
            return false;
        }
    });
};

function changeParentFolder(documentNode,relationDiagramFolder){
    $("#diagramTree li.folder").each(function () {
        if ($(this).attr("data-folderid") == relationDiagramFolder.folderParentID) {
            $(this).addClass("open-folder hasChildren").children("ul").append($(documentNode));
            $(this).parents("li.folder").addClass("open-folder hasChildren");
            return false;
        }
    });
}

const addDiagramSubmit = (relationDiagram) => {
    mRelationModel.relationDiagrams.add(relationDiagram);
    addDiagramNode(relationDiagram);
    totalDiagram(mRelationModel.relationDiagrams.count());
};

function addDiagramNode(relationDiagram){
    $("#diagramTree li.selected-li").removeClass("selected-li");
    $("#diagramTree li.folder").each(function () {
        if ($(this).attr("data-folderid") == relationDiagram.folderID) {
            let strHtml = `<li class="diagrams" data-relationDiagramID="${relationDiagram.relationDiagramID}">
                    <div title="${relationDiagram.relationDiagramName}">
                        <i class="iconfont bda-${(relationDiagram.relationDiagramType ? "shishibiao" : "weibiao")}"></i>
                        <span>${relationDiagram.relationDiagramName}</span>
                    </div>
                </li>`;
            $(this).addClass("open-folder hasChildren").children("ul").append(strHtml);
            $(this).children("ul").children("li:last-child").trigger("click");
            $(this).parents("li.folder").addClass("open-folder hasChildren");
            return false;
        }
    });
}

const editDiagramSubmit = (relationDiagram) => {
    let folderID = $("#diagramTree li.selected-li").parent("li.folder").eq(0).attr("data-folderid");
    if(relationDiagram.folderID == folderID){
        $("#diagramTree li.selected-li").children("div").attr("title", relationDiagram.relationDiagramName);
    }else{
        $("#diagramTree li.folder").each(function () {
            if ($(this).attr("data-folderid") == relationDiagram.folderID) {
                $(this).addClass("open-folder hasChildren").children("ul").append($("#diagramTree li.selected-li"));
                $(this).parents("li.folder").addClass("open-folder hasChildren");
                return false;
            }
        });
    }
};

export { initRelationDiagramList };