/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2021-01-28 11:40:40
 * @LastEditTime: 2021-03-01 20:17:34
 * @LastModifyUser: 
 * @Remark: 
 */
import { initRelationDiagramList } from "./relationDiagramList_controller.js";
import { initBusinessObjects } from "./businessObjects_controller.js";
import rightClickOnOtherPlaces from "./components/closeRightBox.js";
import initQueriesForm from "./dialogs/queryTableRestrictions_controller.js";
import changeProgressBar from "./dialogs/check_controller.js";
import initRelationModelForm from "./dialogs/relationModel_controller.js";
import hideContextmenuBox from "./components/contextmenuBox.js";
!(function () {
    let layuiObject = {
        layer: layui.layer,
        form: layui.form,
        tree: layui.tree,
        table: layui.table
    }
    let storage = window.sessionStorage;
    let relationModel = new RelationModel();
    let relationModels = new RelationModels();
    let databaseLink = new DatabaseLink();
    let timeOutTimer = null;
    let relationModelChanged = false;

    blockRightClickEvents();
    if (location.href.indexOf("businessModelID=") != -1){
        storage.setItem(window.location.host + "businessModelID", (location.href.split("businessModelID=")[1]).split("&")[0]);
        $AppVars.token = $Utils.cookie.getCookie(window.location.host + "-token");
        getRelationModel((location.href.split("businessModelID=")[1]).split("&")[0]);
    }

    function getRelationModel(businessModelID){
        relationModel.businessModelID = businessModelID;
        let success = () => {
            getDataSource();
        };
        let fail = (errorStatus, msg) => {
            $Utils.loading.close();
            $Utils.openWindow.failWindow("获取关系模型", errorStatus, msg);
        };
        relationModel.initByModelID(true,success,fail);
    }

    function getDataSource(){
        databaseLink.dataSourceID = relationModel.dataSourceID;
        let success = () => {
            initRelationDiagramList(relationModel, layuiObject, databaseLink);
            initBusinessObjects(relationModel, layuiObject, databaseLink);
            $Utils.loading.close();
            initMainPage();
        };
        let fail = () => {
            initRelationDiagramList(relationModel, layuiObject);
            initBusinessObjects(relationModel, layuiObject);
            $Utils.loading.close();
            initMainPage();
        };
        databaseLink.initByID(true, success, fail);
    }

    function initMainPage(){
        loadRelationName();
        hideContextmenuBox();
        bindEvent();
    }

    function loadRelationName(){
        $("#relationName").text(relationModel.businessModelName);
        document.title = relationModel.businessModelName;
    }

    function bindEvent(){
        bindLeftOrRightWidthChangeEvents();

        $("#queryTableRestrictionsButton").click(function(){
            getAndLoadQueryForm();
        });

        $("#saveRelationModelButton").click(function(){
            let successCallback = () => {
                layuiObject.layer.closeAll();
                editItem();
            };
            openDialogAndCheckRelationModelAndSave(successCallback);
        });

        $("#saveAsRelationModelButton").click(function () {
            let successCallback = () => {
                layuiObject.layer.closeAll();
                setTimeout(() => {
                    saveAs();
                }, 150);
            };
            openDialogAndCheckRelationModelAndSave(successCallback);
        });
    }

    function bindLeftOrRightWidthChangeEvents(){
        bindLeftWidthChangeEvent();
        bindRightWidthChangeEvent();
        
    }

    function bindLeftWidthChangeEvent(){
        $("#lineWhenMovingLeft").mousedown(function (e) {
            let positionDiv = $(this).offset();
            let distenceX = e.pageX - positionDiv.left;
            let movingDistance = 0;
            let leftEnd = 230;
            let rightEnd = 300;
            $("#maskLayerMovingLeft").show();
            let isMove = false;

            $(document.body).mousemove(function (e) {
                isMove = true;
                movingDistance = e.pageX - distenceX;
                if (movingDistance < leftEnd) {
                    movingDistance = leftEnd
                } else if (movingDistance > rightEnd) {
                    movingDistance = rightEnd;
                }
                $("#lineWhenMovingLeft").css({
                    "left": movingDistance - 3,
                    "border-left": "1px #666 dashed"
                });
            });

            $(document.body).mouseup(function () {
                if (isMove) {
                    $(".middle-center").css("margin-left", movingDistance);
                    $("#maskLayerMovingLeft").css("left", movingDistance);
                    $(".middle-left").css("width", movingDistance);
                    $("#lineWhenMovingLeft").css("border-color","transparent");

                    $("#maskLayerMovingLeft").hide();
                }

                $(document.body).off('mousemove');
                $(document.body).off('mouseup');
            });
            return false;
        });
    }

    function bindRightWidthChangeEvent() {
        $("#lineWhenMovingRight").mousedown(function (e) {
            let positionDiv = $(this).offset();
            let distenceX = e.pageX - positionDiv.left;
            let windowWidth = $(window).width();
            let movingDistance = 0;
            let leftEnd = 300;
            let rightEnd = 180;
            $("#maskLayerMovingRight").show();
            let isMove = false;

            $(document.body).mousemove(function (e) {
                isMove = true;
                movingDistance = windowWidth - e.pageX - distenceX;
                if (movingDistance > leftEnd) {
                    movingDistance = leftEnd
                } else if (movingDistance < rightEnd) {
                    movingDistance = rightEnd;
                }
                $("#lineWhenMovingRight").css({
                    "right": movingDistance - 3,
                    "border-right": "1px #666 dashed"
                });
            });

            $(document.body).mouseup(function () {
                if (isMove) {
                    $(".middle-center").css("margin-right", movingDistance);
                    $("#maskLayerMovingRight").css("right", movingDistance);
                    $(".middle-right").css("width", movingDistance);
                    $("#lineWhenMovingRight").css("border-color", "transparent");

                    $("#maskLayerMovingRight").hide();
                }

                $(document.body).off('mousemove');
                $(document.body).off('mouseup');
            });
            return false;
        });
    }

    function blockRightClickEvents() {
        $(".left-content").on('contextmenu', function () {//禁用掉body的右键菜单
            return false;
        });
        $(".middle-content").on('contextmenu', function () {//禁用掉body的右键菜单
            return false;
        });
        $(".right-content").on('contextmenu', function () {//禁用掉body的右键菜单
            return false;
        });

        $(window).bind('beforeunload', function () {
            if(true){
                return '您输入的内容尚未保存，确定离开此页面吗？';
            }
        });
    }

    function getAndLoadQueryForm(){
        $.ajax({
            url: "dialogs/queryTableRestrictions.html",
            type: 'GET',
            success: function (data) {
                loadQueriesForm(data);
            }
        });
    }

    function loadQueriesForm(strHtml){
        layer.open({
            type: 1,
            title: ["查询限制列表", "font-size: 14px"],
            btn: false,
            resize: false,
            area: ["800px", "600px"],
            content: strHtml,
            success: function (layero, index) {
                initQueriesForm(layuiObject, relationModel);
            }
        });
    }

    function editItem(){
        reloadBusinessObjects();
        reloadRelationDiagrams();

        editItemByRelationModel();
        
    }

    function editItemByRelationModel() {
        const savePrompt = `自从上次打开关系模型编辑界面后，关系模型元数据已经更改。是否要保存您的更改？<br>
            （乐观并发控制错误）<br><br>
            单击“是”将您的更改保存到服务器。<br>
            单击“否”放弃更改并获取关系模型的当前元数据。<br>
            单击“取消”继续编辑。`;
        let success = () => {
            relationModelChanged = false;
        };
        let fail = (errorStatus, msg) => {
            if (errorStatus == 409){
                layer.open({
                    type: 0,
                    title: "保存关系模型",
                    resize: false,
                    area: ["480px", "300px"],
                    skin: "delete-window",
                    content: `<div class='fail-box clearfix'>
                            <div class='fl fail-icon enquire-icon'><i class="iconfont bda-xunwen"></i></div>
                            <div class='fr fail-content'>${savePrompt}</div>
                        </div>`,
                    btn: ["是", "否","取消"],
                    yes: function (index, layero) {
                        let success = () => {
                            layuiObject.layer.close(index);
                        };
                        let fail = (errorStatus, msg) => {
                            $Utils.loading.close();
                            $Utils.openWindow.failWindow("保存关系模型", errorStatus, msg);
                        };
                        relationModels.editItem(relationModel, true, success, fail, "?forceModify=1");
                    },
                    btn2: function (index, layero){
                        getRelationModel(relationModel.businessModelID);
                        layuiObject.layer.close(index);
                    }
                });
            }else{
                $Utils.openWindow.failWindow("保存关系模型", errorStatus, msg);
            }
        };
        relationModels.editItem(relationModel,true,success,fail);
    }

    function reloadBusinessObjects(){
        $("#businessObjectTree > li").each(function () {
            let sortIndex = $(this).index();
            if ($(this).hasClass("hasChildren")) {
                relationModel.businessObjectFolders.item($(this).attr("data-folderid")).sortIndex = sortIndex;
                reloadChildren($(this).children("ul"));
            } else {
                if ($(this).hasClass("folder")) {
                    relationModel.businessObjectFolders.item($(this).attr("data-folderid")).sortIndex = sortIndex;
                } else {
                    relationModel.businessObjects.item($(this).attr("data-objectid")).sortIndex = sortIndex;
                }
            }
        });
    }

    function reloadChildren(elem){
        $(elem).children("li").each(function(){
            if ($(this).hasClass("hasChildren")) {
                reloadChildren($(this).children("ul"));
            }else{
                let sortIndex = $(this).index();
                if($(this).hasClass("folder")){
                    relationModel.businessObjectFolders.item($(this).attr("data-folderid")).sortIndex = sortIndex;
                }else{
                    relationModel.businessObjects.item($(this).attr("data-objectid")).sortIndex = sortIndex;
                }
            }
        });
    }

    function reloadRelationDiagrams(){
        let relationDiagrams = new RelationDiagrams();
        let relationDiagramFolders = new RelationDiagramFolders();
        $("#diagramTree > li").each(function () {
            let folderID = $(this).attr("data-folderid");
            if ((folderID == "-2" || folderID == "-3") && $(this).hasClass("hasChildren")) {
                reloadChildrenDiagrams($(this).children("ul"), relationDiagrams, relationDiagramFolders);
            }
        });
    }

    function reloadChildrenDiagrams(elem, relationDiagrams, relationDiagramFolders){
        $(elem).children("li").each(function(){
            if($(this).hasClass("folder")){
                let folderID = $(this).attr("data-folderid");
                let currentFolder = relationModel.relationDiagramFolders.item(folderID);
                let relationDiagramFolder = new RelationDiagramFolder();
                relationDiagramFolder.init(JSON.parse(JSON.stringify(currentFolder)));
                relationDiagramFolders.add(relationDiagramFolder);
                if ($(this).hasClass("hasChildren")){
                    reloadChildrenDiagrams($(this).children("ul"), relationDiagrams, relationDiagramFolders);
                }
            }else{
                let relationDiagramID = $(this).attr("data-relationdiagramid");
                let currentDiagram = relationModel.relationDiagrams.item(relationDiagramID);
                let relationDiagram = new RelationDiagram();
                relationDiagram.init(JSON.parse(JSON.stringify(currentDiagram)));
                relationDiagrams.add(relationDiagram);
            }
        });
    }

    function saveAs() {
        reloadBusinessObjects();
        reloadRelationDiagrams();

        saveAsRelationModel();
    }

    function saveAsRelationModel(){
        let newRelationModel =  new RelationModel();
        newRelationModel.init(JSON.parse(JSON.stringify(relationModel)));
        newRelationModel.businessModelName = newRelationModel.businessModelName + "副本";
        getAndLoadRelationModelForm(0,newRelationModel)
        
    }

    function getAndLoadRelationModelForm(operationType, relationModel) {
        $.ajax({
            url: "dialogs/relationModel.html",
            type: 'GET',
            success: function (data) {
                loadRelationModelForm(operationType, relationModel, data);
            }
        });
    }

    function loadRelationModelForm(operationType, relationModel, strHtml) {
        layer.open({
            type: 1,
            title: [operationType ? relationModel.businessModelName + " 属性" : "新增关系模型", "font-size: 14px"],
            btn: false,
            resize: false,
            area: ["760px", "570px"],
            content: strHtml,
            success: function (layero, index) {
                initRelationModelForm(index, layuiObject, operationType, relationModel, addSubmit, editSubmit, true);
            }
        });
    }

    function openDialogAndCheckRelationModelAndSave(resultCallback){
        $.ajax({
            url: "dialogs/check.html",
            type: 'GET',
            async: false,
            success: function (data) {
                loadCheckDialogAndCheckRelationModel(data, resultCallback);
            }
        });
    }

    function loadCheckDialogAndCheckRelationModel(strHtml, resultCallback){
        layer.open({
            type: 1,
            title: ["正在进行完整性检测", "font-size: 14px"],
            btn: false,
            resize: false,
            closeBtn: 0,
            area: ["600px", "450px"],
            content: strHtml,
            success: function (layero, index) {
                checkRelationModel(resultCallback);
            }
        });
    }

    function checkRelationModel(resultCallback){
        clearTimeout(timeOutTimer);
        timeOutTimer = setTimeout(() => {
            if (!checkTableBlockDuplicate()) return false;
            clearTimeout(timeOutTimer);
            timeOutTimer = setTimeout(() => {
                if (!checkTableJoinsConsistency()) return false;
                clearTimeout(timeOutTimer);
                timeOutTimer = setTimeout(() => {
                    if (!checkConnectivity()) return false;
                    clearTimeout(timeOutTimer);
                    timeOutTimer = setTimeout(() => {
                        if (!checkIntersection()) return false;
                        clearTimeout(timeOutTimer);
                        timeOutTimer = setTimeout(() => {
                            if (!checkRelationModelTable()) return false;
                            clearTimeout(timeOutTimer);
                            timeOutTimer = setTimeout(() => {
                                if (!checkQueryRestrictions()) return false;
                                clearTimeout(timeOutTimer);
                                timeOutTimer = setTimeout(() => {
                                    clearTimeout(timeOutTimer);
                                    resultCallback();
                                }, 150);
                            }, 150);
                        }, 150);
                    }, 150);
                }, 150);
            }, 150);
        },150);
    }

    function checkTableBlockDuplicate(){
        let result = relationModel.relationDiagrams.checkTableBlocks();
        if (!result.result) {
            changeProgressBar(0, false, 0, 0);
            layer.open({
                type: 0,
                title: "检测",
                resize: false,
                area: ["480px", "270px"],
                skin: "delete-window",
                content: `<div class='fail-box clearfix'>
                            <div class='fl fail-icon'></div>
                            <div class='fr fail-content'>${result.message}</div>
                        </div>`,
                btn: ["确定"],
                yes: function (index, layero) {
                    layuiObject.layer.closeAll();
                },
                cancel: function (index, layero) {
                    layuiObject.layer.closeAll();
                }    
            });
            return false;
        }else{
            changeProgressBar(0,true,5.6*20,20);
            return true;
        }
    }

    function checkTableJoinsConsistency(){
        let result = relationModel.relationDiagrams.checkTableJoinsConsistency();
        if (!result.result) {
            changeProgressBar(1, false, 5.6 * 20, 20);
            layer.open({
                type: 0,
                title: "检测",
                resize: false,
                area: ["480px", "270px"],
                skin: "delete-window",
                content: `<div class='fail-box clearfix'>
                            <div class='fl fail-icon'></div>
                            <div class='fr fail-content'>${result.message}</div>
                        </div>`,
                btn: ["确定"],
                yes: function (index, layero) {
                    layuiObject.layer.closeAll();
                },
                cancel: function (index, layero) {
                    layuiObject.layer.closeAll();
                }
            });
            return false;
        } else {
            changeProgressBar(1, true, 5.6 * 40, 20);
            return true;
        }
    }

    function checkConnectivity(){
        let result = relationModel.relationDiagrams.checkConnectivityAndLoop();
        if (!result.result) {
            changeProgressBar(1, false, 5.6 * 40, 20);
            layer.open({
                type: 0,
                title: "检测",
                resize: false,
                area: ["480px", "270px"],
                skin: "delete-window",
                content: `<div class='fail-box clearfix'>
                            <div class='fl fail-icon'></div>
                            <div class='fr fail-content'>${result.message}</div>
                        </div>`,
                btn: ["确定"],
                yes: function (index, layero) {
                    layuiObject.layer.closeAll();
                },
                cancel: function (index, layero) {
                    layuiObject.layer.closeAll();
                }
            });
            return false;
        } else {
            changeProgressBar(1, true, 5.6 * 60, 20);
            return true;
        }
    }

    function checkIntersection(){
        let result = relationModel.relationDiagrams.checkIntersection();
        if (!result.result) {
            changeProgressBar(2, false, 5.6 * 60, 20);
            layer.open({
                type: 0,
                title: "检测",
                resize: false,
                area: ["480px", "270px"],
                skin: "delete-window",
                content: `<div class='fail-box clearfix'>
                            <div class='fl fail-icon'></div>
                            <div class='fr fail-content'>${result.message}</div>
                        </div>`,
                btn: ["确定"],
                yes: function (index, layero) {
                    layuiObject.layer.closeAll();
                },
                cancel: function (index, layero) {
                    layuiObject.layer.closeAll();
                }
            });
            return false;
        } else {
            changeProgressBar(2, true, 5.6 * 80, 20);
            return true;
        }
    }

    function checkRelationModelTable(){
        let tableBlocks = relationModel.relationDiagrams.getTableBlocks();
        for(let i = 0; i < relationModel.businessObjects.count(); i++){
            let businessObject = relationModel.businessObjects.item(i);
            if (businessObject.businessObjectType == 3) continue; //如果是过滤对象就直接下一个
            for (let j = 0; j < businessObject.expressionList.length; j++){
                for (let k = 0; k < businessObject.tableNamesList[j].length; k++){
                    if (!tableBlocks.containTableAlias(businessObject.tableNamesList[j][k])) {
                        changeProgressBar(3, false, 5.6 * 80, 20);
                        layer.open({
                            type: 0,
                            title: "关系模型完整性检测",
                            resize: false,
                            area: ["480px", "270px"],
                            skin: "delete-window",
                            content: `<div class='fail-box clearfix'>
                                <div class='fl fail-icon'></div>
                                <div class='fr fail-content'>保存失败，无法识别业务对象 ${businessObject.businessModelName} 的表达式中的 ${businessObject.tableNamesList[j][k]}</div>
                            </div>`,
                            btn: ["确定"],
                            yes: function (index, layero) {
                                layuiObject.layer.closeAll();
                            },
                            cancel: function (index, layero) {
                                layuiObject.layer.closeAll();
                            }
                        });
                        return false;
                    }
                }
                let factDiagrams = relationModel.relationDiagrams.getFactRelationDiagrams();
                let factDiagram = null;
                let factOnly = false;
                let dimensionTableBlocks = relationModel.relationDiagrams.getDimensionRelationDiagrams().getTableBlocks();
                for(let k = 0; k < businessObject.tableNamesList[j].length; k++){
                    if (!dimensionTableBlocks.containTableAlias(businessObject.tableNamesList[j][k])){
                        factOnly = true;
                        for(let g = 0; g < factDiagrams.count(); g++){
                            if (factDiagrams.item(g).containTableAlias(businessObject.tableNamesList[j][k])){
                                if (factDiagram != null && factDiagram != factDiagrams.item(g)){
                                    changeProgressBar(3, false, 5.6 * 80, 20);
                                    layer.open({
                                        type: 0,
                                        title: "关系模型完整性检测",
                                        resize: false,
                                        area: ["480px", "270px"],
                                        skin: "delete-window",
                                        content: `<div class='fail-box clearfix'>
                                            <div class='fl fail-icon'></div>
                                            <div class='fr fail-content'>保存失败，业务对象 ${businessObject.businessModelName} 使用了事实表关系图 ${factDiagram.relationDiagramName} 和 ${factDiagrams.item(g).relationDiagramName} 的数据。</div>
                                        </div>`,
                                        btn: ["确定"],
                                        yes: function (index, layero) {
                                            layuiObject.layer.closeAll();
                                        },
                                        cancel: function (index, layero) {
                                            layuiObject.layer.closeAll();
                                        }
                                    });
                                }else{
                                    factDiagram = null;
                                    factDiagram = factDiagrams.item(g);
                                }
                            }
                        }
                        break;
                    }
                }
                if (businessObject.aggregateAware && !factOnly){
                    changeProgressBar(3, false, 5.6 * 80, 20);
                    layer.open({
                        type: 0,
                        title: "关系模型完整性检测",
                        resize: false,
                        area: ["480px", "270px"],
                        skin: "delete-window",
                        content: `<div class='fail-box clearfix'>
                                <div class='fl fail-icon'></div>
                                <div class='fr fail-content'>保存失败，业务对象 ${businessObject.businessModelName} 使用了聚合感知函数，第 ${(i + 1)}个参数缺少事实表仅有的表。</div>
                            </div>`,
                        btn: ["确定"],
                        yes: function (index, layero) {
                            layuiObject.layer.closeAll();
                        },
                        cancel: function (index, layero) {
                            layuiObject.layer.closeAll();
                        }
                    });
                    return false
                }
            }
        }
        changeProgressBar(3, true, 5.6 * 90, 10);
        return true;
    }

    function checkQueryRestrictions(){
        let result = relationModel.checkQueryRestrictions();
        if (!result.result) {
            changeProgressBar(4, false, 5.6 * 90, 10);
            layer.open({
                type: 0,
                title: "检测",
                resize: false,
                area: ["480px", "270px"],
                skin: "delete-window",
                content: `<div class='fail-box clearfix'>
                            <div class='fl fail-icon'></div>
                            <div class='fr fail-content'>${result.message}</div>
                        </div>`,
                btn: ["确定"],
                yes: function (index, layero) {
                    layuiObject.layer.closeAll();
                },
                cancel: function (index, layero) {
                    layuiObject.layer.closeAll();
                }
            });
            return false;
        } else {
            changeProgressBar(4, true, 5.6 * 100, 10);
            return true;
        }
    }

    const addSubmit = (relationModel, index) => {
        var succ = function (data) {
            $Utils.loading.close();
            layuiObject.layer.close(index);
            getRelationModel(relationModel.businessModelID);
        };
        var fail = function (errorStatus, msg) {
            $Utils.loading.close();
            $Utils.openWindow.failWindow("新增关系模型", errorStatus, msg);
        };
        relationModels.addItem(relationModel, true, succ, fail);
    };

    const editSubmit = (relationModel, index) => {
        var succ = function (data) {
            $Utils.loading.close();
        };
        var fail = function (errorStatus, msg) {
            $Utils.loading.close();
            $Utils.openWindow.failWindow("新增关系模型", errorStatus, msg);
        };
        relationModels.addItem(relationModel, true, succ, fail);
    };
    
})();