/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2021-02-23 11:27:11
 * @LastEditTime: 2021-03-05 11:29:41
 * @LastModifyUser: 
 * @Remark: 
 */
export default function initTableListForm(index, layuiObject, relationModel, selectTableName){
    initList(relationModel);
    bindListEvent();

    $(".table-list-query .layui-btn-cancel").click(function () {
        layuiObject.layer.close(index);
    });

    $(".table-list-query .submit-field").click(function () {
        if ($("#tableTree li.selected-li").length) {
            let tableName = $.trim($("#tableTree li.selected-li").children("div").find("span.folder-name").text());
            selectTableName(tableName);
            layuiObject.layer.close(index);
        } else {
            layuiObject.layer.msg("请选择表。", { icon: 2 });
        }
    });
}

function initList(relationModel){
    for (let i = 0; i < relationModel.relationDiagrams.count(); i++) {
        for (let j = 0; j < relationModel.relationDiagrams.item(i).tableBlocks.count(); j++) {
            let tableName = relationModel.relationDiagrams.item(i).tableBlocks.item(j).table.tableName;
            let strHtml = `<li class="folder table">
                <div title="${tableName}">
                    <i class="iconfont bda-biao"></i>
                    <span class="folder-name">${tableName}</span>
                </div>
            </li>`;
            $("#tableTree").append(strHtml);
        }
    }
}

function bindListEvent(){
    $("#tableTree").on("click", "li", function (e) {
        if (!$(this).hasClass("selected-li")) {
            $("#tableTree").find("li").removeClass("selected-li");
            $(this).addClass("selected-li");
        }
        e.stopPropagation();
    });
}