import GUID from "../components/guid.js";

let mLayuiObject = null;
let mTableJoin = null;
let mTableBlocks = null;
let mDatabaseLink = null;

let mOperationType = 0;

let sqlEditor = null;

let mIndex = null;

let tableBlock1 = null;
let tableBlock2 = null;
let table1Fields = [];
let table2Fields = [];
const OPTION_1TO1 = `<option value="=">=</option>
<option value=">">></option>
<option value="&lt;">&lt;</option>
<option value=">=">>=</option>
<option value="&lt;=">&lt;=</option>
<option value="&lt;>">&lt;></option>`;
const OPTION_1TON = `<option value="between">between</option>`;
const OPTION_NTON = `<option value="complex">complex</option>`;



let onSucc;

let haveBind = false;

let tableFieldMap = new HashTable();
export default function initTableJoinDialog(index, layuiObject, operationType, tableJoin, tableBlocks, databaseLink, succCallback){
    tableFieldMap.clear();
    mIndex = index;
    mOperationType = operationType;
    mTableBlocks = tableBlocks;
    mLayuiObject = layuiObject;
    mDatabaseLink = databaseLink;
    onSucc = succCallback;
    if(mOperationType == 0){
        mTableJoin = tableJoin;
        mTableJoin.tableJoinID = new GUID().newGUID();
        mTableJoin.joinType = 0;
        mTableJoin.operator= "=";
        mTableJoin.cardinality = 0;
        if(tableBlocks.count() > 0){
            mTableJoin.table1Alias = tableBlocks.item(0).tableAlias;
            // mTableJoin.table1Field1 = tableBlocks.item(0).table.tableFields.item(0).fieldName;
            if(tableBlocks.count() > 1){
                mTableJoin.table2Alias = tableBlocks.item(1).tableAlias;
                // mTableJoin.table2Field1 = tableBlocks.item(1).table.tableFields.item(0).fieldName;
            }else{
                mTableJoin.table2Alias = tableBlocks.item(0).tableAlias;
                // mTableJoin.table2Field1 = tableBlocks.item(0).table.tableFields.item(0).fieldName;
            }
        }
    }else{
        mTableJoin = tableJoin;
    }
    initExpression();
    
    loadTableJoin();
    layuiObject.form.render();
    // if(!haveBind){
        bindEvents();
        haveBind = true;
    // }
}
function bindEvents(){
    $("#btnSure").click(function(){
        //验证
        let formObj = mLayuiObject.form.val("formWindow");
        if(formObj.chkLeftJoin){
            mTableJoin.joinType = 1;
        }else if(formObj.chkRightJoin){
            mTableJoin.joinType = 2;
        }else{
            mTableJoin.joinType = 0;
        }
        mTableJoin.operator= formObj.cmbOperator;
        if(formObj.rdoLeft == "1" && formObj.rdoRight == "1"){
            mTableJoin.cardinality = 0;
        }else if(formObj.rdoLeft == "1" && formObj.rdoRight == "n"){
            mTableJoin.cardinality = 1;
        }else if(formObj.rdoLeft == "n" && formObj.rdoRight == "1"){
            mTableJoin.cardinality = 2;
        }else if(formObj.rdoLeft == "n" && formObj.rdoRight == "n"){
            mTableJoin.cardinality = 3;
        }
        mTableJoin.table1Alias = formObj.cmbTable1;
        if(table1Fields.length > 0){
            mTableJoin.table1Field1 = table1Fields[0];
        }
        if(table1Fields.length > 1){
            mTableJoin.table1Field2 = table1Fields[1];
        }
        mTableJoin.table2Alias = formObj.cmbTable2;
        if(table2Fields.length > 0){
            mTableJoin.table2Field1 = table2Fields[0];
        }
        if(table2Fields.length > 1){
            mTableJoin.table2Field2 = table2Fields[1];
        }

        mTableJoin.expression = sqlEditor.getValue();
        
        if(onSucc() == true){
            mLayuiObject.layer.close(mIndex);
        }
        return false;
    });

    $(".layui-btn-cancel").click(function(){
        mLayuiObject.layer.close(mIndex);
    });
    $("#btnAnalysis").click(function(){
        let bdaResult = AnalysisExpression();
        if(bdaResult.result){
            mLayuiObject.layer.msg("表达式正确。",{icon: 1});
            refreshViewByExpression();
        }else{
            $Utils.openWindow.failWindow("分析结果",bdaResult.message);
        }
    });

    mLayuiObject.form.on("select(filterTable1)",function(val){
        tableBlock1 = mTableBlocks.getTableBlockByAlias(val.value);
        initAndSelectFieldList($("#lstTable1"),tableBlock1,tableBlock1.table.tableFields.item(0).fieldName,null);
        createExpression();
    });
    mLayuiObject.form.on("select(filterTable2)",function(val){
        tableBlock2 = mTableBlocks.getTableBlockByAlias(val.value);
        initAndSelectFieldList($("#lstTable2"),tableBlock2,tableBlock2.table.tableFields.item(0).fieldName,null);
        createExpression();
    });
    mLayuiObject.form.on("select(filterOperator)",function(operator){
        createExpression();
    });
    mLayuiObject.form.on("checkbox(filterLeftJoin)",function(operator){
        let formObj = mLayuiObject.form.val("formWindow");
        if(formObj.chkLeftJoin && formObj.chkRightJoin){
            formObj.chkRightJoin = false;
            mLayuiObject.form.val("formWindow",{
                "chkRightJoin": false
            });
        }
        setShowCardinality(formObj.chkLeftJoin,formObj.chkRightJoin,formObj.rdoLeft,formObj.rdoRight,mTableJoin.table1Alias,mTableJoin.table2Alias)
    });
    mLayuiObject.form.on("checkbox(filterRightJoin)",function(operator){
        let formObj = mLayuiObject.form.val("formWindow");
        if(formObj.chkLeftJoin && formObj.chkRightJoin){
            formObj.chkLeftJoin = false;
            mLayuiObject.form.val("formWindow",{
                "chkLeftJoin": false
            });
        }
        setShowCardinality(formObj.chkLeftJoin,formObj.chkRightJoin,formObj.rdoLeft,formObj.rdoRight,mTableJoin.table1Alias,mTableJoin.table2Alias)
    });
    mLayuiObject.form.on("radio(filterCardinalityLeft)",function(operator){
        let formObj = mLayuiObject.form.val("formWindow");
        if(formObj.rdoLeft == "n" && formObj.rdoRight == "n"){
            formObj.rdoRight = "1";
            mLayuiObject.form.val("formWindow",{
                "rdoRight": "1"
            });
        }
        setShowCardinality(formObj.chkLeftJoin,formObj.chkRightJoin,formObj.rdoLeft,formObj.rdoRight,mTableJoin.table1Alias,mTableJoin.table2Alias)
    });
    mLayuiObject.form.on("radio(filterCardinalityRight)",function(operator){
        let formObj = mLayuiObject.form.val("formWindow");
        if(formObj.rdoLeft == "n" && formObj.rdoRight == "n"){
            formObj.rdoLeft = "1";
            mLayuiObject.form.val("formWindow",{
                "rdoLeft": "1"
            });
        }
        setShowCardinality(formObj.chkLeftJoin,formObj.chkRightJoin,formObj.rdoLeft,formObj.rdoRight,mTableJoin.table1Alias,mTableJoin.table2Alias)
    });
    $("#lstTable1").on("mousedown", "li", function (e) {
        let fieldView = $(this);
        let field = $(this).html();
        let table1Ul = $("#lstTable1");
        if(e.ctrlKey){
            // alert("control 已按下");
            if(table1Fields.indexOf(field) == -1){
                table1Fields.push(field);
                fieldView.addClass("selected");
            }else{
                table1Fields.forEach(function(item, index, arr) {
                    if(item == field) {
                        arr.splice(index, 1);
                    }
                });
                fieldView.removeClass("selected");
            }
        }else{
            // alert("control 没按下");
            //清除已选择的字段
            table1Fields.length = 0;
            table1Ul.find("li").each(function(index,val){
                $(val).removeClass("selected");
            });
            table1Fields.push(field);
            fieldView.addClass("selected");
        }

        if(table1Fields.length>1 && table2Fields.length>1){
            $("#cmbOperator").html(OPTION_NTON);
        }else if((table1Fields.length>1&&table2Fields.length<=1) || (table2Fields.length>1&&table1Fields.length<=1)){
            $("#cmbOperator").html(OPTION_1TON);
        }else{
            $("#cmbOperator").html(OPTION_1TO1);
        }
        //重新生成表达式
        createExpression();
    });
    $("#lstTable2").on("mousedown", "li", function (e) {
        let fieldView = $(this);
        let field = $(this).html();
        let table2Ul = $("#lstTable2");
        if(e.ctrlKey){
            // alert("control 已按下");
            if(table2Fields.indexOf(field) == -1){
                table2Fields.push(field);
                fieldView.addClass("selected");
            }else{
                table2Fields.forEach(function(item, index, arr) {
                    if(item == field) {
                        arr.splice(index, 1);
                    }
                });
                fieldView.removeClass("selected");
            }
        }else{
            // alert("control 没按下");
            //清除已选择的字段
            table2Fields.length = 0;
            table2Ul.find("li").each(function(index,val){
                $(val).removeClass("selected");
            });
            table2Fields.push(field);
            fieldView.addClass("selected");
        }
        if(table1Fields.length>1 && table2Fields.length>1){
            $("#cmbOperator").html(OPTION_NTON);
        }else if((table1Fields.length>1&&table2Fields.length<=1) || (table2Fields.length>1&&table1Fields.length<=1)){
            $("#cmbOperator").html(OPTION_1TON);
        }else{
            $("#cmbOperator").html(OPTION_1TO1);
        }
        //重新生成表达式
        createExpression();
    });
}
//#region 根据界面生成表达式
function createExpression(){
    // let formObj = mLayuiObject.form.val("formWindow");
    if(!tableBlock1 || !tableBlock2){
        return;
    }
    if(table1Fields.length>0 && table2Fields.length>0){
        if(table1Fields.length == 1 && table2Fields.length == 1){
            createOneToOneExpression();
        }else if(table1Fields.length == 1 && table2Fields.length > 1){
            createOneToNExpression();
        }else if(table1Fields.length > 1 && table2Fields.length == 1){
            createNToOneExpression();
        }else {
            createNToNExpression();
        }
    }
    
}
function createOneToOneExpression(){
    let oper = "=";
    
    let formObj = mLayuiObject.form.val("formWindow");
    if(formObj.cmbOperator){
        oper = formObj.cmbOperator;
    }
    let sqlText = `${tableBlock1.tableAlias}.${table1Fields[0]} ${oper} ${tableBlock2.tableAlias}.${table2Fields[0]}`;
    sqlEditor.setValue(sqlText);
}
function createOneToNExpression(){
    let sqlText = `${tableBlock1.tableAlias}.${table1Fields[0]} bewteen ${tableBlock2.tableAlias}.${table2Fields[0]} AND ${tableBlock2.tableAlias}.${table2Fields[2]}`;
    sqlEditor.setValue(sqlText);
}
function createNToOneExpression(){
    let sqlText = `${tableBlock2.tableAlias}.${table2Fields[0]} bewteen ${tableBlock1.tableAlias}.${table1Fields[0]} AND ${tableBlock1.tableAlias}.${table1Fields[2]}`;
    sqlEditor.setValue(sqlText);
}
function createNToNExpression(){
    let sqlText = `${tableBlock1.tableAlias}.${table1Fields[0]} = ${tableBlock2.tableAlias}.${table2Fields[0]} AND ${tableBlock1.tableAlias}.${table1Fields[1]} = ${tableBlock2.tableAlias}.${table2Fields[1]}`;
    sqlEditor.setValue(sqlText);
}
//#endregion
function AnalysisExpression(){
    let result = new BDAResult();

    let tableFields = getTableFields();
    if(tableFields.length > 0){
        let tableAlias = [];
        let sbSql = [];
        sbSql.push(`SELECT 1 `);
        sbSql.push("FROM ");
        for( let i = 0; i < tableFields.length; i++){
            if(tableAlias.indexOf(tableFields[i][0]) == -1){
                let str = "";
                if(tableAlias.length > 0){
                    str += ",";
                }
                str += mTableBlocks.getTableNameByTableAlias(tableFields[i][0]) + " " + tableFields[i][0];
                sbSql.push(str);
                tableAlias.push(tableFields[i][0]);
            }
        }
        sbSql.push(" ");
        sbSql.push("WHERE " + sqlEditor.getValue() + " AND 1 = 2");
        let sql = sbSql.join("");
        if(mDatabaseLink){
            mDatabaseLink.executeSQL(sql, false, function(){
                result.result = true;
            }, function(errorStatus,msg){
                result.result = false;
                result.message = msg;
                
            });
        }else{
            alert("请设置数据库连接。")
        }
    }
    return result;
}
function refreshViewByExpression(){
    let table1Tmp = null;
    let table2Tmp = null;
    let table1FieldsTmp = [];
    let table2FieldsTmp = [];
    let tableFields = getTableFields();
    for(let i = 0; i < tableFields.length; i++){
        let tableAlias = tableFields[i][0];
        if(!table1Tmp || !table2Tmp){
            let tmpBlock = mTableBlocks.getTableBlockByAlias(tableAlias);
            if(!tmpBlock){
                $Utils.openWindow.failWindow("分析结果","找不到表 "+tableAlias+" 。");
                return false;
            }else if(!table1Tmp){
                table1Tmp = tmpBlock;
            }else if(!table2Tmp){
                table2Tmp = tmpBlock;
            }else{
                $Utils.openWindow.failWindow("分析结果","每个表达式中最多存在两个表的信息。");
                return false;
            }
        }
        if(table1Tmp && table1Tmp.tableAlias == tableAlias){
            if(table1FieldsTmp.indexOf(tableFields[i][1]) == -1){
                table1FieldsTmp.push(tableFields[i][1]);
            }
        }else if(table2Tmp && table2Tmp.tableAlias == tableAlias){
            if(table2FieldsTmp.indexOf(tableFields[i][1]) == -1){
                table2FieldsTmp.push(tableFields[i][1]);
            }
        }
    } 
    tableBlock1 = table1Tmp;
    tableBlock2 = table2Tmp;
    table1Fields = table1FieldsTmp;
    table2Fields = table2FieldsTmp;
    if(tableBlock1){
        mLayuiObject.form.val("formWindow",{
            "cmbTable1": tableBlock1.tableBlockID
        });
        initAndSelectFieldList($("#lstTable1"),tableBlock1,table1Fields[0],table1Fields[1]);
    }
    if(tableBlock2){
        mLayuiObject.form.val("formWindow",{
            "cmbTable2": tableBlock2.tableBlockID
        });
        initAndSelectFieldList($("#lstTable2"),tableBlock2,table2Fields[0],table2Fields[1]);
    }
    
   
}
function getTableFields(){
    let sqlText = sqlEditor.getValue();
    if(tableFieldMap.containsKey(sqlText)){
        return tableFieldMap.getValue(sqlText);
    }
    let list = [];//new List<string[]>()
    var lexicalAnalyzer = new Analyzer();
    let tokens = lexicalAnalyzer.analysis(sqlText);
    if(tokens instanceof Tokens){
        for(let i = 0; i < tokens.length; i++){
            if(tokens[i].type == TokenType.Dot && i > 0 && i < tokens.length - 1){
                let tableField = new Array(2);
                if(tokens[i - 1].type == TokenType.SquareBracketRight || tokens[i - 1].type == TokenType.Backticks){
                    if(i > 2){
                        tableField[0] = tokens[i - 2].value;
                    }
                }else{
                    tableField[0] = tokens[i - 1].value;
                }
                if(tokens[i + 1].type == TokenType.SquareBracketLeft || tokens[i + 1].type == TokenType.Backticks){
                    if(i < tokens.length - 3){
                        tableField[1] = tokens[i + 2].value;
                    }
                }else{
                    tableField[1] = tokens[i + 1].value;
                }
                if(tableField[0] && tableField[1]){
                    list.push(tableField);
                }
            }
        }
    }
    if(!tableFieldMap.containsKey(sqlText)){
        tableFieldMap.add(sqlText,list);
    }
    return list;
}
function initTableAliasCmb(){
    let cmbTable1 = document.getElementById("cmbTable1");
    let cmbTable2 = document.getElementById("cmbTable2");
    for(var i = 0; i < mTableBlocks.count(); i++){
        let option1 = document.createElement("option");
        // option1.setAttribute("value", mTableBlocks.item(i).tableBlockID);
        option1.setAttribute("value", mTableBlocks.item(i).tableAlias);
        option1.innerText = mTableBlocks.item(i).tableAlias;
        if(option1.innerText == mTableJoin.table1Alias){
            option1.setAttribute("selected", true);
            tableBlock1 = mTableBlocks.item(i);
        }
        cmbTable1.appendChild(option1);

        let option2 = document.createElement("option");
        // option2.setAttribute("value", mTableBlocks.item(i).tableBlockID);
        option2.setAttribute("value", mTableBlocks.item(i).tableAlias);
        option2.innerText = mTableBlocks.item(i).tableAlias;
        if(option2.innerText == mTableJoin.table2Alias){
            option2.setAttribute("selected", true);
            tableBlock2 = mTableBlocks.item(i);
        }
        cmbTable2.appendChild(option2);
    }
}
function initTableFieldLst(){
    if(tableBlock1){
        table1Fields = [];
        if(mTableJoin.table1Field1){
            table1Fields.push(mTableJoin.table1Field1);
        }
        if(mTableJoin.table1Field2){
            table1Fields.push(mTableJoin.table1Field2);
        }
        initAndSelectFieldList($("#lstTable1"),tableBlock1,mTableJoin.table1Field1,mTableJoin.table1Field2);
    }

    if(tableBlock2){
        table2Fields = [];
        if(mTableJoin.table2Field1){
            table2Fields.push(mTableJoin.table2Field1);
        }
        if(mTableJoin.table2Field2){
            table2Fields.push(mTableJoin.table2Field2);
        }
        initAndSelectFieldList($("#lstTable2"),tableBlock2,mTableJoin.table2Field1,mTableJoin.table2Field2);
    }
}
function initAndSelectFieldList(listView,tableBlock,field1,field2){
    let FIELD_HEIGHT = 18;
    listView.html("");
    let stringBuilder = "";
    let table = tableBlock.table;
    for(let i = 0; i < table.tableFields.count(); i++){
        let fieldName = table.tableFields.item(i).fieldName;
        let isSelectedClass = "";
        if(field1 == fieldName || field2 == fieldName){
            isSelectedClass = ` selected`
        }
        stringBuilder += `<li class="field${isSelectedClass}">${fieldName}</li>`;
    }
    listView.append(stringBuilder);
}
function loadTableJoin(){
    initTableAliasCmb();
    initTableFieldLst();
    initOperator();
    if(mDatabaseLink){
        $("#tbkTip").html(`支持 ${mDatabaseLink.databaseTypeName} 的所有的函数及运算`)
    }
    
    mLayuiObject.form.val("formWindow",{
        "cmbOperator": mTableJoin.operator,
        "chkLeftJoin":  mTableJoin.joinType == 1 ? true : false,
        "chkRightJoin":  mTableJoin.joinType == 2 ? true : false,
        "rdoLeft": mTableJoin.cardinality == 0 || mTableJoin.cardinality == 1 ? "1" : "n",
        "rdoRight": mTableJoin.cardinality == 0 || mTableJoin.cardinality == 2 ? "1" : "n"

    });
    let formObj = mLayuiObject.form.val("formWindow");
    setShowCardinality(formObj.chkLeftJoin,formObj.chkRightJoin,formObj.rdoLeft,formObj.rdoRight,mTableJoin.table1Alias,mTableJoin.table2Alias)

    sqlEditor.setValue(mTableJoin.expression || "");
}
function initOperator(){
    // $("#cmbOperator").html("");
    if(mTableJoin.operator == "between"){
        $("#cmbOperator").html(OPTION_1TON);
    }else if(mTableJoin.operator == "complex"){
        $("#cmbOperator").html(OPTION_NTON);
    }else{
        $("#cmbOperator").html(OPTION_1TO1);
    }
}
function setShowCardinality(leftJoin,rightJoin,leftCardinality,rightCardinality,alias1,alias2){
    $("#tbkCardinality").html(`${leftCardinality}：${rightCardinality}`);
    //外链接不勾选
    let STR1 = ` 有且仅有一个 `;
    let STR2 = ` 有一个或多个 `;
    //外链接勾选
    let STR3 = ` 有零个或一个 `;
    let STR4 = ` 有零个或多个 `;
    let strTip1 = STR1;
    let strTip2 = STR1;
    if("1" == leftCardinality){
        if(rightJoin){
            strTip2 = STR3;
        }else{
            strTip2 = STR1;
        }
    }else{
        if(rightJoin){
            strTip2 = STR4;
        }else{
            strTip2 = STR2;
        }
    }
    if("1" == rightCardinality){
        if(leftJoin){
            strTip1 = STR3;
        }else{
            strTip1 = STR1;
        }
    }else{
        if(leftJoin){
            strTip1 = STR4;
        }else{
            strTip1 = STR2;
        }
    }

    $("#tbkTip1").html(`每个 ${alias1} ${strTip1} ${alias2}`);
    $("#tbkTip2").html(`每个 ${alias2} ${strTip2} ${alias1}`);
}

function initExpression(){
    sqlEditor = CodeMirror.fromTextArea(document.getElementById("sqlEditor"), {
        mode: "text/x-sparksql", // spark sql模式
        tabSize: 4,
        styleActiveLine: true, // 行高亮
        lineNumbers: false,  // 显示行号
        theme: "eclipse", // 设置主题
        lineWrapping: true, // 自动换行
        matchBrackets: false, // 匹配括号
        autoCloseBrackets: true
    });

    sqlEditor.on('keyup', (cm, event) => {
        if (event.keyCode >= 65 && event.keyCode <= 90) {
            cm.showHint();
        }
    });

}