let mTableBlock = null;
let mLayuiObject = null;
let mIndex = null;
let oldTableAlias = null;
let onSucc = null;

export default function initTableAliasDialog(index, layuiObject, tableBoock,succCallback){
    mIndex = index;
    mLayuiObject = layuiObject;
    mTableBlock = tableBoock;
    onSucc = succCallback;
    oldTableAlias = tableBoock.tableAlias;
    mLayuiObject.form.val("formWindow",{
        "txtTableAlias": mTableBlock.tableAlias,
    });

    $(".folder-window input[name=txtTableAlias]").focus();

    $(".layui-btn-cancel").click(function () {
        mLayuiObject.layer.close(index);
    });

    mLayuiObject.form.on("submit(formSubmit)", function (formObject) {
        
        if (validate(formObject)) {
            if(change(formObject)){
                setProperties(formObject);
                onSucc(mTableBlock,oldTableAlias);

            }else{
                mLayuiObject.layer.close(index);
            }
        }
        return false;
    });
}

function validate(formObject){
    if(!isStrictNameCorrect(formObject.field.txtTableAlias).result){
        mLayuiObject.layer.msg(isStrictNameCorrect(formObject.field.txtTableAlias).message, { icon: 2 });
        $(".folder-window input[name=txtTableAlias]").focus();
        return false;
    }
    return true;
}

function change(formObject) {
    if (formObject.field.txtTableAlias != mTableBlock.tableAlias) {
        return true;
    }
    return false;
}

function setProperties(formObject){
    mTableBlock.tableAlias = formObject.field.txtTableAlias;
}