/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-03-30 14:31:06
 * @LastEditTime: 2021-03-01 17:59:33
 * @LastModifyUser: 
 * @Remark: 
 */
let mLayuiObject = null, layerIndex = null, mOperationType = null, mRelationModel = null, formAddSubmit = null, formEditSubmit = null;
let databaseLinks = new DatabaseLinks();

export default function initRelationModelForm(index,layuiObject,operationType, relationModel, addSubmit, editSubmit,isDisabled){
    mLayuiObject = layuiObject;
    mOperationType = operationType;
    mRelationModel = relationModel;
    layerIndex = index;
    formAddSubmit = addSubmit;
    formEditSubmit = editSubmit;
    getDatabaseLinks();
    initForm(isDisabled);
    $(".relation-model-window input[name=businessModelName]").focus();

    bindElementEvent(isDisabled);
}

function getDatabaseLinks() {
    let succ = function () {
        $Utils.loading.close();
    };
    let fail = function (errorStatus, msg) {
        $Utils.loading.close();
        $Utils.openWindow.failWindow("获取数据库连接", errorStatus, msg);
    };
    databaseLinks.getItems(2, false, succ, fail);
}

function initForm(isDisabled){
    initSelectOption();
    if (isDisabled) {
        $("#databaseLink,.edit-test-link").attr("disabled", true);
    }
    mLayuiObject.form.val("formWindow", {
        "businessModelName": mRelationModel.businessModelName || "",
        "description": mRelationModel.description || "",
        "dataSourceID": mRelationModel.dataSourceID || 0
    });
}

function initSelectOption(){
    let databaseLink = document.getElementById("databaseLink");
    for (let i = 0; i <= databaseLinks.count(); i++) {
        let option = document.createElement("option");
        if (i == 0) {
            option.setAttribute("value", 0);
            option.innerText = "请选择数据库连接";
        } else {
            option.setAttribute("value", databaseLinks.item(i - 1).dataSourceID);
            option.innerText = databaseLinks.item(i - 1).dataSourceName;
        }
        databaseLink.appendChild(option);
    }
}

function bindElementEvent(isDisabled) {
    $(".edit-test-link").on("click", function () {
        $Utils.loading.open();
        let data = form.val("formWindow");
        if (databaseLinks.item(data.dataSourceID)) {
            formTestConnections(data);
        } else {
            $Utils.loading.close();
            mLayuiObject.layer.msg("数据库连接不存在。", { icon: 2 });
        }
    });

    $(".layui-btn-cancel").click(function () {
        mLayuiObject.layer.close(layerIndex);
    });

    mLayuiObject.form.on('submit(formSubmit)', function (data) {
        if (data.field.dataSourceID === "0") {
            mLayuiObject.layer.msg("请选择数据库连接。", { icon: 2 });
            return false;
        }
        $Utils.loading.open();
        if (mOperationType == 1) {
            if (changed(data)) {
                let relationModel = new RelationModel();
                relationModel.init(JSON.parse(JSON.stringify(mRelationModel)));
                setRelationModel(data, relationModel, isDisabled);
                formEditSubmit(relationModel, layerIndex);
            } else {
                $Utils.loading.close();
                mLayuiObject.layer.close(layerIndex);
            }
        } else if (mOperationType == 0) {
            setRelationModel(data, mRelationModel, isDisabled);
            formAddSubmit(mRelationModel, layerIndex);
        }
        return false;
    });
}

function formTestConnections(data) {
    let parameters = "databaseTypeName=" + encodeURIComponent(databaseLinks.item(data.dataSourceID).databaseTypeName) + "&databaseTypeVersion=" + encodeURIComponent(databaseLinks.item(data.dataSourceID).databaseTypeVersion) + "&databaseIP=" + encodeURIComponent(databaseLinks.item(data.dataSourceID).databaseIP) + "&databasePort=" + encodeURIComponent(databaseLinks.item(data.dataSourceID).databasePort) +
        "&userName=" + encodeURIComponent(databaseLinks.item(data.dataSourceID).userName) + "&password=" + encodeURIComponent(databaseLinks.item(data.dataSourceID).password) + "&databaseName=" + encodeURIComponent(databaseLinks.item(data.dataSourceID).databaseName);
    let succ = function () {
        $Utils.loading.close();
        mLayuiObject.layer.msg("连接成功！", { icon: 1 });
    };
    let fail = function (errorStatus, msg) {
        $Utils.loading.close();
        $Utils.openWindow.failWindow("测试连接", errorStatus, msg);
    };
    databaseLinks.item(data.dataSourceID).testConnections(parameters, true, succ, fail);
}

function setRelationModel(data, relationModel, isDisabled) {
    relationModel.businessModelType = 0;
    relationModel.businessModelName = data.field.businessModelName;
    relationModel.description = data.field.description;
    relationModel.dataSourceID = data.field.dataSourceID;
    relationModel.dataSourceName = databaseLinks.item(data.field.dataSourceID) ? databaseLinks.item(data.field.dataSourceID).dataSourceName : "";
    if (mOperationType == 0 && !isDisabled) {
        relationModel.relationDiagramFolders = [];
        relationModel.relationDiagrams = [];
        relationModel.businessObjectFolders = [];
        relationModel.businessObjects = [];
        relationModel.queryTableRestrictions = [];
    }
}

function changed(data) {
    if (mRelationModel.businessModelName != data.field.businessModelName) {
        return true
    }
    if (mRelationModel.description != data.field.description) {
        return true
    }
    if (mRelationModel.dataSourceID != data.field.dataSourceID) {
        return true
    }
    return false;
}