/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2021-02-22 20:02:21
 * @LastEditTime: 2021-02-23 18:46:00
 * @LastModifyUser: 
 * @Remark: 
 */
import initQueryForm from "./queryTableRestriction_controller.js";
let mLayuiObject = null, mRelationModel = null, bakTableBodyData = [];
export default function initQueriesForm(layuiObject,relationModel){
    mLayuiObject = layuiObject;
    mRelationModel = relationModel;
    initTableHead();
    initTableBody();
    bindEvent();
}

function initTableHead(){
    const tableHead = [
        [
            {type: "radio"},
            { field: "tableAlias", title: "表名"},
            { field: "whereClause", title: "Where 子句"}
        ]
    ];

    mLayuiObject.table.render({
        elem: '#queryList',
        height: 477,
        cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
        data: [],
        cols: tableHead,
        toolbar: false,
        autoSort: false,
        limit: 10
    });
}

function initTableBody(){
    let tableBodyData = [];
    for (let i = 0; i < mRelationModel.queryTableRestrictions.count(); i++){
        let tempObj = JSON.parse(JSON.stringify(mRelationModel.queryTableRestrictions.item(i)));
        tempObj.index = i;
        tableBodyData.push(tempObj);
    }
    $.extend(true, bakTableBodyData, tableBodyData);
    mLayuiObject.table.reload("queryList",{data: tableBodyData});
}

function bindEvent(){
    $("#newQuery").click(function(){
        let queryTableRestriction = new QueryTableRestriction();
        getAndLoadQueryTableRestrictionForm(0, queryTableRestriction);
    });

    $("#queryAttribute").click(function(){
        if (mLayuiObject.table.checkStatus('queryList').data.length) {
            let queryTableRestriction = mRelationModel.queryTableRestrictions.item(mLayuiObject.table.checkStatus('queryList').data[0].index);
            getAndLoadQueryTableRestrictionForm(1, queryTableRestriction, mLayuiObject.table.checkStatus('queryList').data[0].index);
        } else {
            layer.msg("请选择一条记录。", { icon: 2 });
        }
    });

    $("#deleteQuery").click(function(){
        if (mLayuiObject.table.checkStatus('queryList').data.length) {
            deleteQueryTableRestriction(mLayuiObject.table.checkStatus('queryList').data[0]);
        } else {
            layer.msg("请选择一条记录。", { icon: 2 });
        }
    });
}

function getAndLoadQueryTableRestrictionForm(operationType, queryTableRestriction, selectIndex){
    $.ajax({
        url: "dialogs/queryTableRestriction.html",
        type: 'GET',
        success: function (data) {
            loadQueryForm(data, operationType, queryTableRestriction, selectIndex);
        }
    });
}

function loadQueryForm(strHtml, operationType, queryTableRestriction, selectIndex) {
    layer.open({
        type: 1,
        title: [operationType ? "查询限制" : "新增查询限制", "font-size: 14px"],
        btn: false,
        resize: false,
        area: ["600px", "450px"],
        content: strHtml,
        success: function (layero, index) {
            initQueryForm(index, mLayuiObject, operationType, queryTableRestriction, mRelationModel, addQueryTableRestriction, editAddQueryTableRestriction, selectIndex);
        }
    });
}

function deleteQueryTableRestriction(queryTableRestriction){
    mRelationModel.queryTableRestrictions.remove(queryTableRestriction);
}

const addQueryTableRestriction = (queryTableRestriction) => {
    mRelationModel.queryTableRestrictions.add(queryTableRestriction);
    let tempObj = JSON.parse(JSON.stringify(queryTableRestriction));
    tempObj.index = bakTableBodyData.length;
    bakTableBodyData.push(tempObj);
    let tempBodyData = $.extend(true, [], bakTableBodyData);
    mLayuiObject.table.reload("queryList", { data: tempBodyData });
};

const editAddQueryTableRestriction = (queryTableRestriction, selectIndex) => {
    let tempBodyData = $.extend(true, [], bakTableBodyData);
    for (let i = 0; i < tempBodyData.length; i++){
        if (tempBodyData[i].index == selectIndex){
            tempBodyData[i].LAY_CHECKED = true;
            tempBodyData[i].tableAlias = queryTableRestriction.tableAlias;
            tempBodyData[i].whereClause = queryTableRestriction.whereClause;
        }else{
            tempBodyData[i].LAY_CHECKED = false;
        }
    }
    mLayuiObject.table.reload("queryList", { data: tempBodyData });
};