/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2021-02-22 20:35:36
 * @LastEditTime: 2021-03-05 11:29:05
 * @LastModifyUser: 
 * @Remark: 
 */
import initFieldListForm from "./fieldList_controller.js";
import initTableListForm from "./tableList_controller.js";
let mLayuiObject = null, mQueryTableRestriction = null, mRelationModel = null, sqlEditor = null;
export default function initQueryForm(index, layuiObject, operationType, queryTableRestriction, relationModel, addQueryTableRestriction, editAddQueryTableRestriction, selectIndex){
    mLayuiObject = layuiObject;
    mQueryTableRestriction = queryTableRestriction;
    mRelationModel = relationModel;
    
    mLayuiObject.form.val("queryFormWindow",{
        "tableAlias": queryTableRestriction.tableAlias || ""
    });
    if (operationType == 1) {
        $("#tableList").attr("disabled", true);
    }
    initExpression();

    $(".query-window .layui-btn-cancel").click(function () {
        mLayuiObject.layer.close(index);
    });

    mLayuiObject.form.on("submit(formSubmit)", function (data) {
        if(validate()){
            let result = analyseExpression();
            if (result.result) {
                if (operationType == 0) {
                    mQueryTableRestriction.tableAlias = data.field.tableAlias;
                    mQueryTableRestriction.whereClause = $.trim(sqlEditor.getValue());
                    addQueryTableRestriction(mQueryTableRestriction);
                    mLayuiObject.layer.close(index);
                } else {
                    if (change(data)) {
                        mQueryTableRestriction.tableAlias = data.field.tableAlias;
                        mQueryTableRestriction.whereClause = $.trim(sqlEditor.getValue());
                        editAddQueryTableRestriction(mQueryTableRestriction, selectIndex);
                    }
                    mLayuiObject.layer.close(index);
                }
            } else {
                $Utils.openWindow.failWindow("分析表达式", result.message);
            }
        }
        return false;
    });

    bindEvent();
}

function initExpression() {
    sqlEditor = CodeMirror.fromTextArea(document.getElementById("sqlEditor"), {
        mode: "text/x-sparksql", // spark sql模式
        tabSize: 4,
        styleActiveLine: true, // 行高亮
        lineNumbers: false,  // 显示行号
        theme: "eclipse", // 设置主题
        lineWrapping: true, // 自动换行
        matchBrackets: false, // 匹配括号
        autoCloseBrackets: true
    });

    sqlEditor.on('keyup', (cm, event) => {
        if (event.keyCode >= 65 && event.keyCode <= 90) {
            cm.showHint();
        }
    });

    sqlEditor.setValue(mQueryTableRestriction.whereClause || "");
}

function bindEvent() {
    $("#tableList").click(function () {
        getAndLoadTableListForm();
    });

    $("#selectField").click(function () {
        let formData = mLayuiObject.form.val("queryFormWindow");
        if(formData.tableAlias){
            getAndLoadFieldListForm(formData.tableAlias);
        }else{
            mLayuiObject.layer.msg("请选择表。",{icon: 2});
        }

    });

    $("#analysis").click(function () {
        if(validate()){
            let result = analyseExpression();
            if (result.result) {
                mLayuiObject.layer.msg("表达式正确。", { icon: 1 });
            } else {
                $Utils.openWindow.failWindow("分析表达式", result.message);
            }
        }
    });
}

function getAndLoadTableListForm(){
    $.ajax({
        url: "dialogs/tableList.html",
        type: 'GET',
        success: function (data) {
            loadTableListHtml(data);
        }
    });
}

function loadTableListHtml(strHtml){
    mLayuiObject.layer.open({
        type: 1,
        title: ["选择表", "font-size: 14px"],
        btn: false,
        resize: false,
        area: ["375px", "500px"],
        content: strHtml,
        success: function (layero, index) {
            initTableListForm(index, mLayuiObject, mRelationModel, selectTableName);
        }
    });
}

function getAndLoadFieldListForm(tableName) {
    $.ajax({
        url: "dialogs/fieldList.html",
        type: 'GET',
        success: function (data) {
            loadFieldListHtml(data, tableName);
        }
    });
}

function loadFieldListHtml(strHtml, tableName) {
    mLayuiObject.layer.open({
        type: 1,
        title: ["选择表字段", "font-size: 14px"],
        btn: false,
        resize: false,
        area: ["375px", "500px"],
        content: strHtml,
        success: function (layero, index) {
            initFieldListForm(index, mLayuiObject, mRelationModel, addField, tableName);
        }
    });
}

function validate() {
    let formData = mLayuiObject.form.val("queryFormWindow");
    if (!formData.tableAlias) {
        mLayuiObject.layer.msg("请选择表。", { icon: 2 });
        return false;
    }
    if (sqlEditor.getValue() == "") {
        mLayuiObject.layer.msg("请填写Where子句。", { icon: 2 });
        return false;
    }
    return true;
}

function analyseExpression() {
    let formData = mLayuiObject.form.val("queryFormWindow");
    let expression = sqlEditor.getValue();
    let result = new BDAResult(true);
    let tableBlock = mRelationModel.relationDiagrams.getTableBlockByTableAlias(formData.tableAlias);
    if(!tableBlock){
        result.result = false;
        result.message = "选择的表已被删除。";
    }else{
        let lexicalAnalyzer = new Analyzer();
        let tokens = lexicalAnalyzer.analysis($.trim(expression.replace(/[ ]/g, "").replace("/[\r\n]/g", "")));
        if (tokens instanceof Tokens){
            for(let i = 0; i < tokens.length; i++){
                if (tokens[i].type == TokenType.Identifier){
                    for(let tableField in tableBlock.table.tableFields){
                        if(tableField.indexOf(tokens[i].value) != -1){
                            if(i < 2 || tokens[i-1].type != Tokens.Dot || tokens[i-2].value != tableBlock.tableAlias){
                                result.result = false;
                                result.message = "字段 " + tokens[i].value + " 前缺少表名，请添加上表名。";
                                return result;
                            }
                        }
                    }
                }
            }
        }else if(tokens instanceof Error){
            result.result = false;
            result.message = tokens.message;
            return result;
        }
        let stringBuilder = [];
        stringBuilder.push("SELECT * ");
        stringBuilder.push("FROM " + tableBlock.table.tableName + " " + tableBlock.tableAlias);
        stringBuilder.push(" WHERE " + expression + " AND 1 = 2");
        let sql = stringBuilder.join("");
        var databaseLink = new DatabaseLink();
        databaseLink.dataSourceID = mRelationModel.dataSourceID;
        databaseLink.executeSQL(sql, false, function(){}, function(status, errorMsg) {
            result.result = false;
            result.message = status + "# " + errorMsg;
        });
    }
    return result;
}

function change(data){
    if(data.field.tableAlias != mQueryTableRestriction.tableAlias){
        return true;
    }
    if ($.trim(sqlEditor.getValue()) != mQueryTableRestriction.whereClause){
        return true;
    }
    return false;
}

function editorInsertText(text, offset) {
    sqlEditor.replaceSelection(text);
    let currentCursorPosition = sqlEditor.getCursor();
    let line = {
        ch: currentCursorPosition.ch - offset,
        line: 0,
        sticky: "after",
        xRel: currentCursorPosition.ch - offset,
    };
    sqlEditor.setCursor(line)
    sqlEditor.focus();
}

const addField = (tableFieldStr) => {
    editorInsertText(tableFieldStr, 0);
};

const selectTableName = (tableName) => {
    mLayuiObject.form.val("queryFormWindow", {
        "tableAlias": tableName
    });
    $("#tableList").attr("disabled",true);
};