import initValueListForm from "./businessObjectList_controller.js";
import initDefaultValueForm from "./dateDefaultValue_controller.js";

let mLayuiObject = null, mRelationModel = null;
export default function initPromptForm(index, layuiObject, relationModel, addPrompt){
    mLayuiObject = layuiObject;
    mRelationModel = relationModel;
    $(".prompt-window input[name=prompt]").focus();

    bindEvent();

    $(".prompt-window .layui-btn-cancel").click(function(){
        mLayuiObject.layer.close(index);
    });

    mLayuiObject.form.on("submit(formSubmit)",function(data){
        addPrompt($.trim($(".prompt-window .sql-content").text()));
        mLayuiObject.layer.close(index);
        return false;
    });
}

function bindEvent(){
    $(".prompt-window input[name='prompt']").bind('input propertychange', function(){
        let prompt = $(this).val();
        let valueList = $(".prompt-window input[name='valueList']").val();
        let defaultValue = $(".prompt-window input[name='defaultValue']").val();
        outputResults(prompt,valueList,defaultValue);
    });
    $(".prompt-window input[name='valueList']").bind('input propertychange', function(){
        let prompt = $(".prompt-window input[name='prompt']").val();
        let valueList = $(this).val();
        let defaultValue = $(".prompt-window input[name='defaultValue']").val();
        outputResults(prompt,valueList,defaultValue);
    });
    $(".prompt-window input[name='defaultValue']").bind('input propertychange', function(){
        let prompt = $(".prompt-window input[name='prompt']").val();
        let valueList = $(".prompt-window input[name='valueList']").val();
        let defaultValue = $(this).val();
        outputResults(prompt,valueList,defaultValue);
    });

    $("#valueListButton").click(function(){
        getAndLoadValueList();
        return false;
    });

    $("#defaultValueButton").click(function(){
        let valueStr = $(".prompt-window input[name='defaultValue']").val();
        getAndLoadDefaultValue(valueStr);
        return false;
    });
}

function outputResults(prompt,valueList,defaultValue){
    let strText = `@Prompt('${prompt}','[${valueList}]','${defaultValue}')`;
    $(".prompt-window .sql-content").text(strText);
}

function getAndLoadValueList(){
    $.ajax({
        url: "dialogs/businessObjectList.html",
        type: 'GET',
        success: function (data) {
            loadValueListHtml(data);
        }
    });
}

function loadValueListHtml(strHtml){
    mLayuiObject.layer.open({
        type: 1,
        title: ["选择业务对象", "font-size: 14px"],
        btn: false,
        resize: false,
        area: ["375px", "500px"],
        content: strHtml,
        success: function (layero, index) {
            initValueListForm(index, mLayuiObject, mRelationModel, selectValue);
        }
    });
}

function getAndLoadDefaultValue(valueStr){
    $.ajax({
        url: "dialogs/dateDefaultValue.html",
        type: 'GET',
        success: function (data) {
            loadDefaultValueHtml(data,valueStr);
        }
    });
}

function loadDefaultValueHtml(strHtml,valueStr){
    mLayuiObject.layer.open({
        type: 1,
        title: ["设置日期过滤缺省值", "font-size: 14px"],
        btn: false,
        resize: false,
        area: ["480px", "360px"],
        content: strHtml,
        success: function (layero, index) {
            initDefaultValueForm(index, mLayuiObject, valueStr, setDefaultValue);
        }
    });
}

const selectValue = (value) => {
    let prompt = $(".prompt-window input[name='prompt']").val();
    let defaultValue = $(".prompt-window input[name='defaultValue']").val();
    $(".prompt-window input[name='valueList']").val(value);
    outputResults(prompt,value,defaultValue);
};

const setDefaultValue = (value) => {
    let prompt = $(".prompt-window input[name='prompt']").val();
    let valueList = $(".prompt-window input[name='valueList']").val();
    $(".prompt-window input[name='defaultValue']").val(value);
    outputResults(prompt,valueList,value);
}