

let mLayuiObject = null;

let mTableFields = null;

let mFieldBody = [];
let backupArr = [];
let lazyArr = [];

let searchBody = [];//筛选后的的obj

let selectFields = [];

let onSucc;
let mIndex;

export default function initFieldVisibilityDialog(index, layuiObject, tableFields, succCallback){
    selectFields = [];
    searchBody = [];
    mIndex = index;
    mLayuiObject = layuiObject;
    mTableFields = tableFields;
    onSucc = succCallback;
    initTableListHead();
    let fieldBody = [];
    for(let i = 0; i < tableFields.count(); i++){
        let fieldObj = {};
        fieldObj.fieldName = tableFields.item(i).fieldName;
        fieldObj.visible = tableFields.item(i).visible;
        if(fieldObj.visible){
            selectFields.push(fieldObj);
        }
        
        fieldBody.push(fieldObj);
    }
    $.extend(true,mFieldBody,fieldBody);
    $.extend(true,searchBody,fieldBody);
    loadTableListBody(fieldBody);
    bindEvent();
}

function initTableListHead(){
    let tableHead = [
        [
            {type: "checkbox"},
            {field: "fieldName", title: "字段名"}
        ]
    ];

    mLayuiObject.table.render({
        elem: "#lstFieldList",
        height: 480,
        cellMinWidth: 80,
        data: [],
        cols: tableHead,
        toolbar: false,
        limit: 1000
    });
}

function loadTableListBody(fieldBody){
    if(fieldBody.length > 100){
        lazyArr = fieldBody.splice(100,fieldBody.length);
    }
    backupArr = fieldBody;
    if(selectFields.length){
        setSelect(fieldBody);
    }
    mLayuiObject.table.reload("lstFieldList",{
        data:fieldBody,limit:fieldBody.length,skin: "nob",done:function(){
            $(".field-list .layui-table-main").scroll(function(){
                var scrollTop = $(this)[0].scrollTop;
                var clientHeight = $(this)[0].clientHeight;
                var scrollHeight = $(this)[0].scrollHeight;
                
                if(lazyArr.length > 0 && scrollHeight > clientHeight && scrollTop + clientHeight === scrollHeight) {
                    loadmore(scrollTop);
                }
            });
        }
    });
    $("#tbkTip").html("共 " + fieldBody.length + " 个对象");
}

function setSelect(currentData){
    let selectFeildNames = [];
    for(let i = 0; i < selectFields.length; i++){
        selectFeildNames.push(selectFields[i].fieldName);
    }
    for(let i = 0; i < currentData.length; i++){
        if(selectFeildNames.indexOf(currentData[i].fieldName) != -1){
            currentData[i].LAY_CHECKED = true;
        }else if(currentData[i].LAY_CHECKED){
            currentData[i].LAY_CHECKED = false;
        }
    }
}

function loadmore(scrollTop){
    if(lazyArr.length > 100){
        var tempArr = lazyArr.splice(0,100);
        backupArr = backupArr.concat(tempArr);
    }else{
        backupArr = backupArr.concat(lazyArr);
        lazyArr = [];
    }
    if(selectUsers.length){
        setSelect(backupArr)
    }
    table.reload("tableList",{data:backupArr,limit:backupArr.length,skin: "nob"});
    $(".table-list .layui-table-main").scrollTop(scrollTop);
}

function setSearchData(searchValue){
    searchBody = [];
    // let searchData = [];
    let lowerSearchValue = searchValue.toLowerCase();
    for(let i = 0; i < mFieldBody.length; i++){
        if(mFieldBody[i].fieldName.toLowerCase().indexOf(lowerSearchValue) != -1){
            searchBody.push(mFieldBody[i]);
        }
    }
    // return searchData;
}


function bindEvent(){
    mLayuiObject.table.on("checkbox(fieldList)",function(obj){
        
        if(obj.type == "one"){
            if(obj.checked){
                selectFields.push(obj.data);
            }else{
                for(let i = selectFields.length - 1; i >= 0; i--){
                    if(selectFields[i].fieldName == obj.data.fieldName){
                        selectFields.splice(i,1);
                        break;
                    }
                }
            }
        }else if(obj.type == "all"){
            
            if(obj.checked){
                for(let i = 0; i < searchBody.length; i++){
                    if(selectFields.indexOf(searchBody[i]) == -1){
                        selectFields.push(searchBody[i]);
                    }
                }
            }else{
                for(let i = 0; i < searchBody.length; i++){
                    for(let j = selectFields.length - 1; j >= 0; j--){
                        if(selectFields[j].fieldName == searchBody[i].fieldName){
                            selectFields.splice(j,1);
                            break;
                        }
                    }
                }
            }
        }
    });

    $("#btnFilter").click(function(){
        let searchValue = $(".list-filter input").val();
        if(searchValue == ""){
            searchBody = [];
            $.extend(true,searchBody,mFieldBody);
        }else{
            setSearchData(searchValue);
        }
        loadTableListBody(searchBody);
    })
    $(".list-filter input").keypress(function (e) {
        if (e.which == 13) {
            $("#btnFilter").click();
        }
    });


    $("#btnSure").click(function(){
        for(let i = 0; i < mTableFields.count(); i++){
            mTableFields.item(i).visible = false;
        }
        for(let i = 0; i < selectFields.length; i++){
            mTableFields.item(selectFields[i].fieldName).visible = true;
        }
        if(onSucc() == true){
            layer.close(mIndex);
        }
    });

    $(".layui-btn-cancel").click(function(){
        layer.close(mIndex);
    });
}
