/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2021-02-04 18:01:56
 * @LastEditTime: 2021-02-23 16:59:20
 * @LastModifyUser: 
 * @Remark: 
 */
export default function initFieldListForm(index, layuiObject, relationModel, addField, targetTableName) {

    initTreeList(relationModel, targetTableName);
    bindTreeEvent();

    $(".field-list .layui-btn-cancel").click(function () {
        layuiObject.layer.close(index);
    });
    
    $(".field-list .submit-field").click(function () {
        if($("#fieldTree li.selected-li").length && $("#fieldTree li.selected-li").hasClass("table-field")){
            let tableName = $.trim($("#fieldTree li.selected-li").parents("li.table").children("div").find("span.folder-name").text());
            let fieldName = $.trim($("#fieldTree li.selected-li").text());
            addField(tableName+"."+fieldName);
            layuiObject.layer.close(index);
        }else{
            layuiObject.layer.msg("请选择表字段。",{icon: 2});
        }
    });
}

function initTreeList(relationModel, targetTableName){
    let treeData = setTreeData(relationModel, targetTableName);
    for(let i = 0; i < treeData.length; i++){
        let strHtml = `<li class="folder table ` + (targetTableName ?"open-folder": "")+`">
            <div title="${treeData[i].tableName}">
                <i class="iconfont bda-biao"></i>
                <span class="folder-name">${treeData[i].tableName}</span>
                <span class="triangle"></span>
            </div>
            <ul></ul>
        </li>`;
        $("#fieldTree").append(strHtml);
        if(treeData[i].tableFields.count()){
            $("#fieldTree li:last-child").addClass("hasChildren");
            createTableField(treeData[i].tableFields,$("#fieldTree li:last-child").children("ul"));
        }
    }
}

function createTableField(tableFieldArr, element){
    for(let i = 0; i < tableFieldArr.count(); i++){
        let strHtml = `<li class="object table-field">
            <div title="${tableFieldArr.item(i).fieldName}" data-type="${tableFieldArr.item(i).dataType}">
                <i class="iconfont bda-ziduan"></i>
                <span>${tableFieldArr.item(i).fieldName}</span>
            </div>
        </li>`;
        element.append(strHtml);
    }
}

function setTreeData(relationModel, targetTableName){
    let treeData = [];
    let endLoop = false;
    for(let i = 0; i < relationModel.relationDiagrams.count(); i++){
        for(let j = 0; j < relationModel.relationDiagrams.item(i).tableBlocks.count(); j++){
            if (targetTableName && relationModel.relationDiagrams.item(i).tableBlocks.item(j).table.tableName == targetTableName) {
                treeData.push(relationModel.relationDiagrams.item(i).tableBlocks.item(j).table);
                endLoop = true;
                break;
            } else if (!targetTableName){
                treeData.push(relationModel.relationDiagrams.item(i).tableBlocks.item(j).table);
            }
        }
        if(endLoop){ break;}
    }
    return treeData;
}

function bindTreeEvent(){
    $("#fieldTree").on("click", "li", function (e) {
        if (!$(this).hasClass("selected-li")) {
            $("#fieldTree").find("li").removeClass("selected-li");
            $(this).addClass("selected-li");
        }
        e.stopPropagation();
    });

    $("#fieldTree").on("click", "span.triangle", function (e) {
        $("#fieldTree").find("li").removeClass("selected-li");
        if ($(this).parent("div").siblings("ul").is(":hidden")) {
            $(this).parent("div").parent("li").addClass("selected-li open-folder");
        } else {
            $(this).parent("div").parent("li").addClass("selected-li").removeClass("open-folder");
        }
    });

    $("#fieldTree").on("dblclick", "li.folder > div", function (e) {
        if ($(this).siblings("ul").is(":hidden")) {
            $(this).parent("li").addClass("open-folder");
            $("#fieldTree").find("li").removeClass("selected-li");
            $(this).parent("li").addClass("selected-li");
        } else {
            $(this).parent("li").removeClass("open-folder");
            $("#fieldTree").find("li").removeClass("selected-li");
            $(this).parent("li").addClass("selected-li");
        }
    });
}