/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2021-02-02 10:53:39
 * @LastEditTime: 2021-03-17 10:36:55
 * @LastModifyUser: 
 * @Remark: 
 */
import GUID from "../components/guid.js";

let mLayuiObject = null, mRelationDiagram = null, mOperationType = null;
export default function initDiagramForm(index, layuiObject, operationType, relationDiagram, addDiagramSubmit, editDiagramSubmit, relationDiagramFolders, relationDiagrams){
    mLayuiObject = layuiObject;
    mRelationDiagram = relationDiagram;
    mOperationType = operationType;

    mLayuiObject.form.val("formWindow", {
        "relationDiagramName": relationDiagram.relationDiagramName || "",
        "relationDiagramType": relationDiagram.relationDiagramType,
        "folderID": relationDiagram.folderID
    });
    if(mOperationType == 1){
        $(".diagram-window input[name=relationDiagramType]").attr("disabled",true);
    }

    mLayuiObject.form.render();

    $("#folderParentName").text(relationDiagramFolders.item(relationDiagram.folderID) ? relationDiagramFolders.item(relationDiagram.folderID).folderName : (relationDiagram.relationDiagramType == 0 ? "维度表关系图" : "事实表关系图"));
    $(".diagram-window input[name=relationDiagramName]").focus();

    createFolderTree(relationDiagramFolders,mRelationDiagram.relationDiagramType);

    bindFormEvent(index, addDiagramSubmit, editDiagramSubmit, relationDiagramFolders, relationDiagrams);

    $(".layui-btn-cancel").click(function () {
        mLayuiObject.layer.close(index);
    });
}

function createFolderTree(relationDiagramFolders, relationDiagramType) {
    drawTree(relationDiagramFolders, relationDiagramType);
    $(".diagram-window .downpanel").off("click").on("click", ".layui-select-title", function (e) {
        $(".diagram-window .layui-form-select").not($(this).parents(".layui-form-select")).removeClass("layui-form-selected");
        $(this).parents(".downpanel").toggleClass("layui-form-selected");
        layui.stope(e);
    }).on("click", "dl i", function (e) {
        layui.stope(e);
    });
    $(document).on("click", function (e) {
        $(".diagram-window .layui-form-select").removeClass("layui-form-selected");
    });
}

function drawTree(relationDiagramFolders, relationDiagramType){
    let treeData = setTreeData(relationDiagramFolders, relationDiagramType);
    mLayuiObject.tree.render({
        elem: '#classtree',
        data: treeData,
        onlyIconControl: true,
        click: function (node) { //点击节点回调
            var $select = $($(this)[0].elem).parents(".layui-form-select");
            $select.removeClass("layui-form-selected").find(".layui-select-title span").html(node.data.title).end().find("input:hidden[name='folderID']").val(node.data.folderID);
        },
    });
}

function setTreeData(relationDiagramFolders, relationDiagramType) {
    let treeData = [];
    let hashTable = new HashTable();
    if (relationDiagramType == "0") {
        hashTable.add("-2", { title: "维度表关系图", id: "-2", folderID: "-2", folderParentID: "-1", relationDiagramType: 0, spread: true });
    } else {
        hashTable.add("-3", { title: "事实表关系图", id: "-3", folderID: "-3", folderParentID: "-1", relationDiagramType: 1, spread: true });
    }
    for (let i = 0; i < relationDiagramFolders.count(); i++) {
        let folder = relationDiagramFolders.item(i);
        if (relationDiagramType == folder.relationDiagramType) {
            hashTable.add(folder.folderID, { title: folder.folderName, id: folder.folderID, folderID: folder.folderID, folderParentID: folder.folderParentID, relationDiagramType: folder.relationDiagramType, spread: false });
        }
    }
    for (let i = 0; i < relationDiagramFolders.count(); i++) {
        let folder = relationDiagramFolders.item(i);
        if (relationDiagramType == folder.relationDiagramType) {
            let parentFolder = hashTable.getValue(folder.folderParentID);
            if (!parentFolder.children) {
                parentFolder.children = [];
            }
            parentFolder.children.push(hashTable.getValue(folder.folderID));
        }
    }
    if (relationDiagramType == "0") {
        treeData.push(hashTable.getValue("-2"));
    } else {
        treeData.push(hashTable.getValue("-3"));
    }

    return treeData;
}

function bindFormEvent(index, addDiagramSubmit, editDiagramSubmit, relationDiagramFolders, relationDiagrams){
    mLayuiObject.form.on("submit(formSubmit)", function (formObject) {
        if (mOperationType == 0) {
            if (validate(formObject, relationDiagrams)) {
                let guID = new GUID();
                mRelationDiagram.relationDiagramID = guID.newGUID();
                mRelationDiagram.relationDiagramName = formObject.field.relationDiagramName;
                mRelationDiagram.relationDiagramType = Number(formObject.field.relationDiagramType);
                mRelationDiagram.folderID = formObject.field.folderID;
                addDiagramSubmit(mRelationDiagram);
                mLayuiObject.layer.close(index);
            }
        } else {
            if (change(formObject)) {
                if (validate(formObject, relationDiagrams)) {
                    mRelationDiagram.relationDiagramName = formObject.field.relationDiagramName;
                    mRelationDiagram.folderID = formObject.field.folderID;
                    editDiagramSubmit(mRelationDiagram);
                    mLayuiObject.layer.close(index);
                }
            }else{
                mLayuiObject.layer.close(index);
            }
        }
        return false;
    });

    mLayuiObject.form.on("radio(relationDiagramType)", function () {
        if (this.value == "0") {
            drawTree(relationDiagramFolders, "0");
            $("#folderParentName").text("维度表关系图");
            mLayuiObject.form.val("formWindow", {
                "folderID": "-2"
            });
        } else if (this.value == "1") {
            drawTree(relationDiagramFolders, "1");
            $("#folderParentName").text("事实表关系图");
            mLayuiObject.form.val("formWindow", {
                "folderID": "-3"
            });
        }
    });
}

function validate(formObject, relationDiagrams){
    let result = isNameCorrect(formObject.field.relationDiagramName);
    if (!result.result) {
        mLayuiObject.layer.msg(result.message, { icon: 2 });
        return false;
    }
    for (let i = 0; i < relationDiagrams.count(); i++){
        if (mOperationType == 0) {
            if (relationDiagrams.item(i).folderID == formObject.field.folderID && relationDiagrams.item(i).relationDiagramName == formObject.field.relationDiagramName) {
                mLayuiObject.layer.msg("关系图名称已存在。", { icon: 2 });
                return false;
            }
        } else if (mOperationType == 1) {
            if (mRelationDiagram.relationDiagramID != relationDiagrams.item(i).relationDiagramID && relationDiagrams.item(i).folderID == formObject.field.folderID && relationDiagrams.item(i).relationDiagramName == formObject.field.relationDiagramName) {
                mLayuiObject.layer.msg("关系图名称已存在。", { icon: 2 });
                return false;
            }
        }
    }
    return true;
}

function change(formObject) {
    if (formObject.field.relationDiagramName != mRelationDiagram.relationDiagramName) {
        return true;
    }
    if (formObject.field.folderID != mRelationDiagram.folderID) {
        return true;
    }
    return false;
}